/*! Copyright [Amazon.com](http://amazon.com/), Inc. or its affiliates. All Rights Reserved.
SPDX-License-Identifier: Apache-2.0 */
import { Project, ProjectOptions, Task } from "projen";
import { OpenApiProjectDefinition } from "./openapi/open-api-project-definition";
import { SmithyProjectDefinition } from "./smithy/smithy-project-definition";
import { Language } from "../languages";
import { ModelLanguage, ModelOptions, OpenApiModelOptions, SmithyModelOptions } from "../types";
export interface TypeSafeApiModelProjectBaseOptions extends ProjectOptions {
    /**
     * Language the model is defined in
     */
    readonly modelLanguage: ModelLanguage;
    /**
     * Options for the model
     */
    readonly modelOptions: ModelOptions;
    /**
     * The languages users have specified for handler projects (if any)
     */
    readonly handlerLanguages?: Language[];
}
export declare abstract class TypeSafeApiModelProjectBase extends Project {
    /**
     * Name of the final bundled OpenAPI specification
     */
    readonly parsedSpecFile: string;
    /**
     * Reference to the task used for generating the final bundled OpenAPI specification
     */
    readonly generateTask: Task;
    /**
     * Name of the API. If Smithy, will resolve to serviceName otherwise it will use title.
     */
    readonly apiName: string | undefined;
    constructor(options: TypeSafeApiModelProjectBaseOptions);
    protected abstract addSmithyApiDefinition(options: SmithyModelOptions, handlerLanguages?: Language[]): SmithyProjectDefinition;
    protected abstract addOpenApiDefinition(options: OpenApiModelOptions, handlerLanguages?: Language[]): OpenApiProjectDefinition;
    private addApiDefinition;
    private addParseAndBundleTask;
}
