# Code of Conduct

## 1. Purpose

A primary goal of Django-Detector is to be inclusive to the largest number of contributors, with the most varied and
diverse backgrounds possible. As such, we are committed to providing a friendly, safe, and welcoming environment for
all, regardless of gender, sexual orientation, ability, ethnicity, socioeconomic status, and religion (or lack thereof).

This Code of Conduct outlines our expectations for all those who participate in our community, as well as the
consequences for unacceptable behavior.

We invite all those who participate in Django-Detector to help us create safe and positive experiences for everyone.

## 2. Open Source Citizenship

A supplemental goal of this Code of Conduct is to increase open source citizenship by encouraging participants to
recognize and strengthen the relationships between our actions and their effects on our community.

Communities mirror the societies in which they exist and positive action is essential to counteract the many forms of
inequality and abuses of power that exist in society.

If you see someone who is making an extra effort to ensure our community is welcoming, friendly, and encourages all
participants to contribute to the fullest extent, we want to know.

## 3. Expected Behavior

The following behaviors are expected and requested of all community members:

- Participate in an authentic and active way. In doing so, you contribute to the health and longevity of this community.
- Exercise consideration and respect in your speech and actions.
- Attempt collaboration before conflict.
- Refrain from demeaning, discriminatory, or harassing behavior and speech.
- Be mindful of your surroundings and of your fellow participants.
- Alert community leaders if you notice a dangerous situation, someone in distress, or violations of this Code of
  Conduct, even if they seem inconsequential.

## 4. Unacceptable Behavior

The following behaviors are considered harassment and are unacceptable within our community:

- Violence, threats of violence, or violent language directed against another person.
- Sexist, racist, homophobic, transphobic, ableist, or otherwise discriminatory jokes and language.
- Posting or displaying sexually explicit or violent material.
- Posting or threatening to post other people’s personally identifying information ("doxing").
- Personal insults, particularly those related to gender, sexual orientation, race, religion, or disability.
- Inappropriate photography or recording.
- Inappropriate physical contact. You should have someone’s consent before touching them.
- Unwelcome sexual attention. This includes sexualized comments or jokes; inappropriate touching, groping, and unwelcome
  sexual advances.
- Deliberate intimidation, stalking, or following (online or in person).
- Advocating for, or encouraging, any of the above behavior.

## 5. Consequences of Unacceptable Behavior

Unacceptable behavior from any community member, including sponsors and those with decision-making authority, will not
be tolerated.

Anyone asked to stop unacceptable behavior is expected to comply immediately.

If a community member engages in unacceptable behavior, the project maintainers may take any action they deem
appropriate, up to and including a temporary ban or permanent expulsion from the community without warning (and without
refund in the case of a paid event).

## 6. Reporting Guidelines

If you are subject to or witness unacceptable behavior, or have any other concerns, please notify a community organizer
as soon as possible by contacting [PAGE](https://adamspierredavid.com/contact/).

[Link to reporting guidelines]

## 7. Addressing Grievances

If you feel you have been falsely or unfairly accused of violating this Code of Conduct, you should notify the project
team with a concise description of your grievance. Your grievance will be handled in accordance with our existing
governing policies.

## 8. Scope

We expect all community participants (contributors, paid or otherwise; sponsors; and other guests) to abide by this Code
of Conduct in all community venues – online and in-person – as well as in all one-on-one communications pertaining to
community business.

This Code of Conduct and its related procedures also applies to unacceptable behavior occurring outside the scope of
community activities when such behavior has the potential to adversely affect the safety and well-being of community
members.

## 9. Contact info

[Contact Page](https://adamspierredavid.com/contact/)

## 10. License and attribution

This Code of Conduct is distributed under a Creative Commons Attribution-ShareAlike license.

Portions of a text derived from the Django Code of Conduct and the Geek Feminism Anti-Harassment Policy.

