# Contributing to Spam-Detection

We would like to thank you for considering contributing to Spam-Detection! Contributions from the community are a big
part of what makes open source so great. Whether you are a newcomer or an experienced developer, your contributions are
greatly appreciated.

Please make sure to read and understand this guide before making a contribution. It will help you to get started and
ensure a smooth process for submitting your contributions.

## Code of Conduct

By participating in this project, you are expected to uphold our [Code of Conduct](./CODE_OF_CONDUCT.md).

## Getting Started

1. Fork the repository on GitHub by clicking the "Fork" button in the top right corner.
2. Clone the forked repository to your local machine.
    ```
    git clone https://github.com/yourusername/spam-detection-project.git
    ```
3. Add the original repository as a remote, so you can fetch changes.
    ```
    git remote add upstream https://github.com/adamspd/spam-detection-project.git
    ```

## Making a Contribution

1. Fetch the latest changes from the upstream repository.
    ```
    git fetch upstream
    ```
2. Checkout to the main branch and merge the latest changes.
    ```
    git checkout main
    git merge upstream/main
    ```
3. Create a new branch for your feature or bug fix.
    ```
    git checkout -b your-feature-branch
    ```
4. Make your changes in the codebase.
5. Commit your changes using a clear and descriptive commit message.
    ```
    git add .
    git commit -m "Your clear and descriptive commit message"
    ```
6. Push your branch to your forked repository.
    ```
    git push origin your-feature-branch
    ```
7. Create a pull request by going to the [original repository on GitHub](https://github.com/adamspd/spam-detection-project) and
   clicking the "New pull request" button.

## Pull Request Guidelines

- Make sure that your code follows the project's coding style.
- Write [good commit messages](https://chris.beams.io/posts/git-commit/).
- Your pull request should be made from a branch other than `main`.
- Your pull request should have a meaningful title.
- Describe the changes made in the pull request description.
- Include any relevant issue numbers in the pull request description.

## Reporting Bugs

If you find a bug, please create an issue in the GitHub issue tracker describing the problem and including steps to
reproduce the issue.

## Requesting Features

Feature requests are welcome. Please create an issue in the GitHub issue tracker describing the feature you would like
to see, why it is useful, and how it should work.

## License

By contributing, you agree that your contributions will be licensed under the project's license.

## Thank you!

Thank you for contributing to Spam-Detection!
