# coding: utf-8

"""
REDACcess User API

This API provides functionalities to interact with a deployed anabrid REDAC system, including hardware status checks, job submission, job status retrieval, and result downloads. Also supports streaming of results by attaching to endpoints.

The version of the OpenAPI document: 1.0.0
Generated by OpenAPI Generator (https://openapi-generator.tech)

Do not edit the class manually.
"""  # noqa: E501


import re  # noqa: F401
import io
import warnings

from pydantic import validate_call, ValidationError
from typing import overload, Optional, Union, Awaitable

from typing_extensions import Annotated
from pydantic import Field, StrictInt, StrictStr

from typing import List, Optional, Union, Dict

from anabrid.redaccess.api.common.models.gen.job_request import JobRequest
from anabrid.redaccess.api.common.models.gen.job_response import JobResponse
from anabrid.redaccess.api.common.models.gen.job_status import JobStatus
from anabrid.redaccess.api.common.models.gen.log import Log

from anabrid.redaccess.api.client.gen.api_client import ApiClient
from anabrid.redaccess.api.client.gen.api_response import ApiResponse
from anabrid.redaccess.api.client.gen.exceptions import (  # noqa: F401
    ApiTypeError,
    ApiValueError,
)


class JobsApi:
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None) -> None:
        if api_client is None:
            api_client = ApiClient.get_default()
        self.api_client = api_client

    @validate_call
    async def delete_job(
        self,
        job_id: Annotated[
            StrictStr, Field(..., description="The UUID of the job to cancel.")
        ],
        **kwargs
    ) -> None:  # noqa: E501
        """Cancel a job  # noqa: E501

        Cancel a specific job.  # noqa: E501

        :param job_id: The UUID of the job to cancel. (required)
        :type job_id: str
        :param _request_timeout: timeout setting for this request.
               If one number provided, it will be total request
               timeout. It can also be a pair (tuple) of
               (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: None
        """
        kwargs["_return_http_data_only"] = True
        if "_preload_content" in kwargs:
            message = "Error! Please call the delete_job_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        return await self.delete_job_with_http_info(job_id, **kwargs)  # noqa: E501

    @validate_call
    async def delete_job_with_http_info(
        self,
        job_id: Annotated[
            StrictStr, Field(..., description="The UUID of the job to cancel.")
        ],
        **kwargs
    ) -> ApiResponse:  # noqa: E501
        """Cancel a job  # noqa: E501

        Cancel a specific job.  # noqa: E501

        :param job_id: The UUID of the job to cancel. (required)
        :type job_id: str
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: None
        """

        _params = locals()

        _all_params = ["job_id"]
        _all_params.extend(
            [
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
                "_request_auth",
                "_content_type",
                "_headers",
            ]
        )

        # validate the arguments
        for _key, _val in _params["kwargs"].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_job" % _key
                )
            _params[_key] = _val
        del _params["kwargs"]

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params["job_id"] is not None:
            _path_params["jobId"] = _params["job_id"]

        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get("_headers", {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # authentication setting
        _auth_settings = ["BearerAuth"]  # noqa: E501

        _response_types_map = {}

        return await self.api_client.call_api(
            "/jobs/{jobId}",
            "DELETE",
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            _return_http_data_only=_params.get("_return_http_data_only"),  # noqa: E501
            _preload_content=_params.get("_preload_content", True),
            _request_timeout=_params.get("_request_timeout"),
            collection_formats=_collection_formats,
            _request_auth=_params.get("_request_auth"),
        )

    @validate_call
    async def get_job(
        self,
        job_id: Annotated[
            StrictStr, Field(..., description="The UUID of the job to retrieve.")
        ],
        **kwargs
    ) -> JobRequest:  # noqa: E501
        """Get job data  # noqa: E501

        Retrieve the input data of a specific job.  # noqa: E501

        :param job_id: The UUID of the job to retrieve. (required)
        :type job_id: str
        :param _request_timeout: timeout setting for this request.
               If one number provided, it will be total request
               timeout. It can also be a pair (tuple) of
               (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: JobRequest
        """
        kwargs["_return_http_data_only"] = True
        if "_preload_content" in kwargs:
            message = "Error! Please call the get_job_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        return await self.get_job_with_http_info(job_id, **kwargs)  # noqa: E501

    @validate_call
    async def get_job_with_http_info(
        self,
        job_id: Annotated[
            StrictStr, Field(..., description="The UUID of the job to retrieve.")
        ],
        **kwargs
    ) -> ApiResponse:  # noqa: E501
        """Get job data  # noqa: E501

        Retrieve the input data of a specific job.  # noqa: E501

        :param job_id: The UUID of the job to retrieve. (required)
        :type job_id: str
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(JobRequest, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = ["job_id"]
        _all_params.extend(
            [
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
                "_request_auth",
                "_content_type",
                "_headers",
            ]
        )

        # validate the arguments
        for _key, _val in _params["kwargs"].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_job" % _key
                )
            _params[_key] = _val
        del _params["kwargs"]

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params["job_id"] is not None:
            _path_params["jobId"] = _params["job_id"]

        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get("_headers", {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json"]
        )  # noqa: E501

        # authentication setting
        _auth_settings = ["BearerAuth"]  # noqa: E501

        _response_types_map = {
            "200": "JobRequest",
            "404": None,
            "500": None,
        }

        return await self.api_client.call_api(
            "/jobs/{jobId}",
            "GET",
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            _return_http_data_only=_params.get("_return_http_data_only"),  # noqa: E501
            _preload_content=_params.get("_preload_content", True),
            _request_timeout=_params.get("_request_timeout"),
            collection_formats=_collection_formats,
            _request_auth=_params.get("_request_auth"),
        )

    @validate_call
    async def get_job_channel_data(
        self,
        job_id: Annotated[
            StrictStr,
            Field(..., description="The UUID of the job to download channel data for."),
        ],
        channel_no: Annotated[
            StrictInt,
            Field(..., description="The channel number to download data for."),
        ],
        **kwargs
    ) -> List[float]:  # noqa: E501
        """Download channel data  # noqa: E501

        Downloads all data measured in a certain channel.  # noqa: E501

        :param job_id: The UUID of the job to download channel data for. (required)
        :type job_id: str
        :param channel_no: The channel number to download data for. (required)
        :type channel_no: int
        :param _request_timeout: timeout setting for this request.
               If one number provided, it will be total request
               timeout. It can also be a pair (tuple) of
               (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: List[float]
        """
        kwargs["_return_http_data_only"] = True
        if "_preload_content" in kwargs:
            message = "Error! Please call the get_job_channel_data_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        return await self.get_job_channel_data_with_http_info(
            job_id, channel_no, **kwargs
        )  # noqa: E501

    @validate_call
    async def get_job_channel_data_with_http_info(
        self,
        job_id: Annotated[
            StrictStr,
            Field(..., description="The UUID of the job to download channel data for."),
        ],
        channel_no: Annotated[
            StrictInt,
            Field(..., description="The channel number to download data for."),
        ],
        **kwargs
    ) -> ApiResponse:  # noqa: E501
        """Download channel data  # noqa: E501

        Downloads all data measured in a certain channel.  # noqa: E501

        :param job_id: The UUID of the job to download channel data for. (required)
        :type job_id: str
        :param channel_no: The channel number to download data for. (required)
        :type channel_no: int
        :param format: The format of the results to download.
        :type format: str
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(List[float], status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = ["job_id", "channel_no", "format"]
        _all_params.extend(
            [
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
                "_request_auth",
                "_content_type",
                "_headers",
            ]
        )

        # validate the arguments
        for _key, _val in _params["kwargs"].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_job_channel_data" % _key
                )
            _params[_key] = _val
        del _params["kwargs"]

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params["job_id"] is not None:
            _path_params["jobId"] = _params["job_id"]

        if _params["channel_no"] is not None:
            _path_params["channelNo"] = _params["channel_no"]

        # process the query parameters
        _query_params = []
        if _params.get("format") is not None:  # noqa: E501
            _query_params.append(("format", _params["format"]))

        # process the header parameters
        _header_params = dict(_params.get("_headers", {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(
            ["text/csv", "application/octet-stream"]
        )  # noqa: E501

        # authentication setting
        _auth_settings = ["BearerAuth"]  # noqa: E501

        _response_types_map = {
            "200": "List[float]",
            "404": None,
            "500": None,
        }

        return await self.api_client.call_api(
            "/jobs/{jobId}/channels/{channelNo}",
            "GET",
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            _return_http_data_only=_params.get("_return_http_data_only"),  # noqa: E501
            _preload_content=_params.get("_preload_content", True),
            _request_timeout=_params.get("_request_timeout"),
            collection_formats=_collection_formats,
            _request_auth=_params.get("_request_auth"),
        )

    @validate_call
    async def get_job_logs(
        self,
        job_id: Annotated[
            StrictStr,
            Field(..., description="The UUID of the job to retrieve logs for."),
        ],
        **kwargs
    ) -> Log:  # noqa: E501
        """Retrieve job logs  # noqa: E501

        Retrieves logs for a job.  # noqa: E501

        :param job_id: The UUID of the job to retrieve logs for. (required)
        :type job_id: str
        :param _request_timeout: timeout setting for this request.
               If one number provided, it will be total request
               timeout. It can also be a pair (tuple) of
               (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: Log
        """
        kwargs["_return_http_data_only"] = True
        if "_preload_content" in kwargs:
            message = "Error! Please call the get_job_logs_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        return await self.get_job_logs_with_http_info(job_id, **kwargs)  # noqa: E501

    @validate_call
    async def get_job_logs_with_http_info(
        self,
        job_id: Annotated[
            StrictStr,
            Field(..., description="The UUID of the job to retrieve logs for."),
        ],
        **kwargs
    ) -> ApiResponse:  # noqa: E501
        """Retrieve job logs  # noqa: E501

        Retrieves logs for a job.  # noqa: E501

        :param job_id: The UUID of the job to retrieve logs for. (required)
        :type job_id: str
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(Log, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = ["job_id"]
        _all_params.extend(
            [
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
                "_request_auth",
                "_content_type",
                "_headers",
            ]
        )

        # validate the arguments
        for _key, _val in _params["kwargs"].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_job_logs" % _key
                )
            _params[_key] = _val
        del _params["kwargs"]

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params["job_id"] is not None:
            _path_params["jobId"] = _params["job_id"]

        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get("_headers", {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json"]
        )  # noqa: E501

        # authentication setting
        _auth_settings = ["BearerAuth"]  # noqa: E501

        _response_types_map = {
            "200": "Log",
            "404": None,
            "500": None,
        }

        return await self.api_client.call_api(
            "/jobs/{jobId}/logs",
            "GET",
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            _return_http_data_only=_params.get("_return_http_data_only"),  # noqa: E501
            _preload_content=_params.get("_preload_content", True),
            _request_timeout=_params.get("_request_timeout"),
            collection_formats=_collection_formats,
            _request_auth=_params.get("_request_auth"),
        )

    @validate_call
    async def get_job_results(
        self,
        job_id: Annotated[
            StrictStr,
            Field(..., description="The UUID of the job to download results for."),
        ],
        **kwargs
    ) -> Dict[str, List[float]]:  # noqa: E501
        """Download job results  # noqa: E501

        Download the results of a specific job in the requested format.  # noqa: E501

        :param job_id: The UUID of the job to download results for. (required)
        :type job_id: str
        :param _request_timeout: timeout setting for this request.
               If one number provided, it will be total request
               timeout. It can also be a pair (tuple) of
               (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: bytearray
        """
        kwargs["_return_http_data_only"] = True
        if "_preload_content" in kwargs:
            message = "Error! Please call the get_job_results_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        return await self.get_job_results_with_http_info(job_id, **kwargs)  # noqa: E501

    @validate_call
    async def get_job_results_with_http_info(
        self,
        job_id: Annotated[
            StrictStr,
            Field(..., description="The UUID of the job to download results for."),
        ],
        **kwargs
    ) -> ApiResponse:  # noqa: E501
        """Download job results  # noqa: E501

        Download the results of a specific job in the requested format.  # noqa: E501

        :param job_id: The UUID of the job to download results for. (required)
        :type job_id: str
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(bytearray, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = ["job_id", "format"]
        _all_params.extend(
            [
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
                "_request_auth",
                "_content_type",
                "_headers",
            ]
        )

        # validate the arguments
        for _key, _val in _params["kwargs"].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_job_results" % _key
                )
            _params[_key] = _val
        del _params["kwargs"]

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params["job_id"] is not None:
            _path_params["jobId"] = _params["job_id"]

        # process the query parameters
        _query_params = []
        if _params.get("format") is not None:  # noqa: E501
            _query_params.append(("format", _params["format"]))

        # process the header parameters
        _header_params = dict(_params.get("_headers", {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(
            ["text/csv", "application/octet-stream"]
        )  # noqa: E501

        # authentication setting
        _auth_settings = ["BearerAuth"]  # noqa: E501

        _response_types_map = {
            "200": "Dict[str, List[float]]",
            "404": None,
            "500": None,
        }

        return await self.api_client.call_api(
            "/jobs/{jobId}/results",
            "GET",
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            _return_http_data_only=_params.get("_return_http_data_only"),  # noqa: E501
            _preload_content=_params.get("_preload_content", True),
            _request_timeout=_params.get("_request_timeout"),
            collection_formats=_collection_formats,
            _request_auth=_params.get("_request_auth"),
        )

    @validate_call
    async def get_job_status(
        self,
        job_id: Annotated[
            StrictStr, Field(..., description="The UUID of the job to retrieve.")
        ],
        **kwargs
    ) -> JobStatus:  # noqa: E501
        """Get job status  # noqa: E501

        Retrieve the status of a specific job.  # noqa: E501

        :param job_id: The UUID of the job to retrieve. (required)
        :type job_id: str
        :param _request_timeout: timeout setting for this request.
               If one number provided, it will be total request
               timeout. It can also be a pair (tuple) of
               (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: JobStatus
        """
        kwargs["_return_http_data_only"] = True
        if "_preload_content" in kwargs:
            message = "Error! Please call the get_job_status_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        return await self.get_job_status_with_http_info(job_id, **kwargs)  # noqa: E501

    @validate_call
    async def get_job_status_with_http_info(
        self,
        job_id: Annotated[
            StrictStr, Field(..., description="The UUID of the job to retrieve.")
        ],
        **kwargs
    ) -> ApiResponse:  # noqa: E501
        """Get job status  # noqa: E501

        Retrieve the status of a specific job.  # noqa: E501

        :param job_id: The UUID of the job to retrieve. (required)
        :type job_id: str
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(JobStatus, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = ["job_id"]
        _all_params.extend(
            [
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
                "_request_auth",
                "_content_type",
                "_headers",
            ]
        )

        # validate the arguments
        for _key, _val in _params["kwargs"].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_job_status" % _key
                )
            _params[_key] = _val
        del _params["kwargs"]

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params["job_id"] is not None:
            _path_params["jobId"] = _params["job_id"]

        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get("_headers", {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json"]
        )  # noqa: E501

        # authentication setting
        _auth_settings = ["BearerAuth"]  # noqa: E501

        _response_types_map = {
            "200": "JobStatus",
            "404": None,
            "500": None,
        }

        return await self.api_client.call_api(
            "/jobs/{jobId}/status",
            "GET",
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            _return_http_data_only=_params.get("_return_http_data_only"),  # noqa: E501
            _preload_content=_params.get("_preload_content", True),
            _request_timeout=_params.get("_request_timeout"),
            collection_formats=_collection_formats,
            _request_auth=_params.get("_request_auth"),
        )

    @validate_call
    async def list_job_channels(
        self,
        job_id: Annotated[
            StrictStr,
            Field(..., description="The UUID of the job to get channels for."),
        ],
        **kwargs
    ) -> List[str]:  # noqa: E501
        """Get active channels for a job  # noqa: E501

        Gets a list of all active channels for a job.  # noqa: E501

        :param job_id: The UUID of the job to get channels for. (required)
        :type job_id: str
        :param _request_timeout: timeout setting for this request.
               If one number provided, it will be total request
               timeout. It can also be a pair (tuple) of
               (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: List[str]
        """
        kwargs["_return_http_data_only"] = True
        if "_preload_content" in kwargs:
            message = "Error! Please call the list_job_channels_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        return await self.list_job_channels_with_http_info(
            job_id, **kwargs
        )  # noqa: E501

    @validate_call
    async def list_job_channels_with_http_info(
        self,
        job_id: Annotated[
            StrictStr,
            Field(..., description="The UUID of the job to get channels for."),
        ],
        **kwargs
    ) -> ApiResponse:  # noqa: E501
        """Get active channels for a job  # noqa: E501

        Gets a list of all active channels for a job.  # noqa: E501

        :param job_id: The UUID of the job to get channels for. (required)
        :type job_id: str
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(List[str], status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = ["job_id"]
        _all_params.extend(
            [
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
                "_request_auth",
                "_content_type",
                "_headers",
            ]
        )

        # validate the arguments
        for _key, _val in _params["kwargs"].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_job_channels" % _key
                )
            _params[_key] = _val
        del _params["kwargs"]

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params["job_id"] is not None:
            _path_params["jobId"] = _params["job_id"]

        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get("_headers", {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json"]
        )  # noqa: E501

        # authentication setting
        _auth_settings = ["BearerAuth"]  # noqa: E501

        _response_types_map = {
            "200": "List[str]",
            "404": None,
            "500": None,
        }

        return await self.api_client.call_api(
            "/jobs/{jobId}/channels",
            "GET",
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            _return_http_data_only=_params.get("_return_http_data_only"),  # noqa: E501
            _preload_content=_params.get("_preload_content", True),
            _request_timeout=_params.get("_request_timeout"),
            collection_formats=_collection_formats,
            _request_auth=_params.get("_request_auth"),
        )

    @validate_call
    async def list_jobs(self, **kwargs) -> List[JobStatus]:  # noqa: E501
        """Get list of jobs  # noqa: E501

        Retrieve a list of all jobs with their current status.  # noqa: E501

        :param _request_timeout: timeout setting for this request.
               If one number provided, it will be total request
               timeout. It can also be a pair (tuple) of
               (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: List[JobStatus]
        """
        kwargs["_return_http_data_only"] = True
        if "_preload_content" in kwargs:
            message = "Error! Please call the list_jobs_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        return await self.list_jobs_with_http_info(**kwargs)  # noqa: E501

    @validate_call
    async def list_jobs_with_http_info(self, **kwargs) -> ApiResponse:  # noqa: E501
        """Get list of jobs  # noqa: E501

        Retrieve a list of all jobs with their current status.  # noqa: E501

        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(List[JobStatus], status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = []
        _all_params.extend(
            [
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
                "_request_auth",
                "_content_type",
                "_headers",
            ]
        )

        # validate the arguments
        for _key, _val in _params["kwargs"].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_jobs" % _key
                )
            _params[_key] = _val
        del _params["kwargs"]

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get("_headers", {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json"]
        )  # noqa: E501

        # authentication setting
        _auth_settings = ["BearerAuth"]  # noqa: E501

        _response_types_map = {
            "200": "List[JobStatus]",
            "500": None,
        }

        return await self.api_client.call_api(
            "/jobs",
            "GET",
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            _return_http_data_only=_params.get("_return_http_data_only"),  # noqa: E501
            _preload_content=_params.get("_preload_content", True),
            _request_timeout=_params.get("_request_timeout"),
            collection_formats=_collection_formats,
            _request_auth=_params.get("_request_auth"),
        )

    @validate_call
    async def submit_job(
        self, job_request: JobRequest, **kwargs
    ) -> JobResponse:  # noqa: E501
        """Submit a new job  # noqa: E501

        Submit a new job with configuration and timing parameters.  # noqa: E501

        :param job_request: (required)
        :type job_request: JobRequest
        :param _request_timeout: timeout setting for this request.
               If one number provided, it will be total request
               timeout. It can also be a pair (tuple) of
               (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: JobResponse
        """
        kwargs["_return_http_data_only"] = True
        if "_preload_content" in kwargs:
            message = "Error! Please call the submit_job_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        return await self.submit_job_with_http_info(job_request, **kwargs)  # noqa: E501

    @validate_call
    async def submit_job_with_http_info(
        self, job_request: JobRequest, **kwargs
    ) -> ApiResponse:  # noqa: E501
        """Submit a new job  # noqa: E501

        Submit a new job with configuration and timing parameters.  # noqa: E501

        :param job_request: (required)
        :type job_request: JobRequest
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(JobResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = ["job_request"]
        _all_params.extend(
            [
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
                "_request_auth",
                "_content_type",
                "_headers",
            ]
        )

        # validate the arguments
        for _key, _val in _params["kwargs"].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method submit_job" % _key
                )
            _params[_key] = _val
        del _params["kwargs"]

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get("_headers", {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params["job_request"] is not None:
            _body_params = _params["job_request"]

        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json"]
        )  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get(
            "_content_type",
            self.api_client.select_header_content_type(["application/json"]),
        )
        if _content_types_list:
            _header_params["Content-Type"] = _content_types_list

        # authentication setting
        _auth_settings = ["BearerAuth"]  # noqa: E501

        _response_types_map = {
            "201": "JobResponse",
            "400": None,
            "500": None,
        }

        return await self.api_client.call_api(
            "/jobs",
            "POST",
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            _return_http_data_only=_params.get("_return_http_data_only"),  # noqa: E501
            _preload_content=_params.get("_preload_content", True),
            _request_timeout=_params.get("_request_timeout"),
            collection_formats=_collection_formats,
            _request_auth=_params.get("_request_auth"),
        )
