""" Test FaceInfo class """

import pytest

PHOTOS_DB_5 = "tests/Test-Faces-10.15.7.photoslibrary"
PHOTOS_DB_4 = "tests/Test-Faces-10.14.6.photoslibrary"

UUID_NO_FACE_4 = "et+K1HHhT8+I64oIGy6sxg"
UUID_NO_FACE_5 = "660AF0C1-169A-46BD-907B-D259527162BE"

UUID_LIST_4 = [
    {
        "ay%v0qDWSK23jM+qwGg8DA": {
            "dJliJWFGQhqkhMcxdqpHiw": {
                "_pk": 8,
                "uuid": "dJliJWFGQhqkhMcxdqpHiw",
                "name": None,
                "asset_uuid": "ay%v0qDWSK23jM+qwGg8DA",
                "_person_pk": 5,
                "center_x": 0.41347498446702957,
                "center_y": 0.6922065243124962,
                "center": (403, 200),
                "mouth_x": 0.42387221059626745,
                "mouth_y": 0.64986898973002,
                "mouth": (418, 224),
                "left_eye_x": 0.3868246160432272,
                "left_eye_y": 0.7252634200821332,
                "left_eye": (372, 184),
                "right_eye_x": 0.4345336260311544,
                "right_eye_y": 0.741291431805021,
                "right_eye": (415, 164),
                "size": 0.13793781399726868,
                "face_rect": [
                    (335.7553156763315, 132.75531567633152),
                    (470.2446843236685, 267.2446843236685),
                ],
                "mpri_reg_rect": {
                    "x": 0.34450607746839523,
                    "y": 0.2043401151895523,
                    "h": 0.13793781399726868,
                    "w": 0.20690672099590302,
                },
                "mwg_rs_area": {
                    "x": 0.41347498446702957,
                    "y": 0.3077934756875038,
                    "h": 0.20690672099590302,
                    "w": 0.13793781399726868,
                },
                "roll": 0.21323637664318085,
                "pitch": 0.15810084342956543,
                "yaw": -0.13662023842334747,
                "quality": 98,
                "source_width": 975,
                "source_height": 650,
                "has_smile": 1,
                "left_eye_closed": 0,
                "right_eye_closed": 0,
                "manual": 0,
                "face_type": 1,
                "age_type": None,
                "eye_makeup_type": None,
                "eye_state": None,
                "facial_hair_type": None,
                "gender_type": None,
                "glasses_type": None,
                "hair_color_type": None,
                "intrash": None,
                "lip_makeup_type": None,
                "smile_type": None,
            }
        }
    },
    {
        "RhXj7UBlQvOV4M6u%DMOvA": {
            "mWmrp43NS+KnMg00HZ4S5A": {
                "_pk": 12,
                "uuid": "mWmrp43NS+KnMg00HZ4S5A",
                "name": None,
                "asset_uuid": "RhXj7UBlQvOV4M6u%DMOvA",
                "_person_pk": 11,
                "center_x": 0.48083364963531494,
                "center_y": 0.5796643048524857,
                "center": (984, 576),
                "mouth_x": 0.44906091358837824,
                "mouth_y": 0.470311523036815,
                "mouth": (883, 705),
                "left_eye_x": 0.45720542859770674,
                "left_eye_y": 0.8387260070116769,
                "left_eye": (1025, 220),
                "right_eye_x": 0.643946774654701,
                "right_eye_y": 0.7615909226089039,
                "right_eye": (1369, 416),
                "size": 0.5559377903700806,
                "face_rect": [
                    (414.71970266103745, 6.719702661037445),
                    (1553.2802973389626, 1145.2802973389626),
                ],
                "mpri_reg_rect": {
                    "x": 0.20286475445027463,
                    "y": 0.005105718970298767,
                    "h": 0.5559377903700806,
                    "w": 0.8304599523544312,
                },
                "mwg_rs_area": {
                    "x": 0.48083364963531494,
                    "y": 0.42033569514751434,
                    "h": 0.8304599523544312,
                    "w": 0.5559377903700806,
                },
                "roll": -0.250908762216568,
                "pitch": -0.22496965527534485,
                "yaw": -0.581797182559967,
                "quality": 46,
                "source_width": 2048,
                "source_height": 1371,
                "has_smile": 0,
                "left_eye_closed": 1,
                "right_eye_closed": 1,
                "manual": 0,
                "face_type": 1,
                "age_type": None,
                "eye_makeup_type": None,
                "eye_state": None,
                "facial_hair_type": None,
                "gender_type": None,
                "glasses_type": None,
                "hair_color_type": None,
                "intrash": None,
                "lip_makeup_type": None,
                "smile_type": None,
            }
        }
    },
    {
        "p%NvN+LDR7GmU3UMUfdOpg": {
            "AyndTdC1RVWdB9fOkG2A+Q": {
                "_pk": 1,
                "uuid": "AyndTdC1RVWdB9fOkG2A+Q",
                "name": "Girl Winking",
                "asset_uuid": "p%NvN+LDR7GmU3UMUfdOpg",
                "_person_pk": 17,
                "center_x": 0.19874780625104904,
                "center_y": 0.5244172364473343,
                "center": (1640, 649),
                "mouth_x": 0.19445147873170782,
                "mouth_y": 0.45158542344711616,
                "mouth": (1652, 747),
                "left_eye_x": 0.1533762462682851,
                "left_eye_y": 0.5930982142995265,
                "left_eye": (1729, 551),
                "right_eye_x": 0.24563000415562875,
                "right_eye_y": 0.602793876447614,
                "right_eye": (1540, 545),
                "size": 0.24455414582917,
                "face_rect": [
                    (1389.57655467093, 398.5765546709299),
                    (1890.42344532907, 899.4234453290701),
                ],
                "mpri_reg_rect": {
                    "x": 0.678975120834366,
                    "y": 0.29212236404418945,
                    "h": 0.24455414582917,
                    "w": 0.3669207990169525,
                },
                "mwg_rs_area": {
                    "x": 0.801252193748951,
                    "y": 0.4755827635526657,
                    "h": 0.3669207990169525,
                    "w": 0.24455414582917,
                },
                "roll": 0.035273514688014984,
                "pitch": 0.05399006977677345,
                "yaw": -0.64935702085495,
                "quality": 287,
                "source_width": 2048,
                "source_height": 1365,
                "has_smile": 0,
                "left_eye_closed": 0,
                "right_eye_closed": 0,
                "manual": 0,
                "face_type": 0,
                "age_type": None,
                "eye_makeup_type": None,
                "eye_state": None,
                "facial_hair_type": None,
                "gender_type": None,
                "glasses_type": None,
                "hair_color_type": None,
                "intrash": None,
                "lip_makeup_type": None,
                "smile_type": None,
            }
        }
    },
    {
        "D3qv+aiuQiu30Gf1XtXnKw": {
            "YJ4%IxOzS+yZ%K302hD%lA": {
                "_pk": 9,
                "uuid": "YJ4%IxOzS+yZ%K302hD%lA",
                "name": None,
                "asset_uuid": "D3qv+aiuQiu30Gf1XtXnKw",
                "_person_pk": 14,
                "center_x": 0.4718262702226639,
                "center_y": 0.4822359085083008,
                "center": (966, 662),
                "mouth_x": 0.5056993685547921,
                "mouth_y": 0.3640364429813756,
                "mouth": (1062, 798),
                "left_eye_x": 0.40206999041582603,
                "left_eye_y": 0.5673758152979675,
                "left_eye": (805, 581),
                "right_eye_x": 0.5591965665831469,
                "right_eye_y": 0.6131431824728817,
                "right_eye": (1110, 464),
                "size": 0.3410559594631195,
                "face_rect": [
                    (616.7586975097656, 312.7586975097656),
                    (1315.2413024902344, 1011.2413024902344),
                ],
                "mpri_reg_rect": {
                    "x": 0.3012982904911041,
                    "y": 0.24491932392120364,
                    "h": 0.3410559594631195,
                    "w": 0.5456895351409912,
                },
                "mwg_rs_area": {
                    "x": 0.4718262702226639,
                    "y": 0.5177640914916992,
                    "h": 0.5456895351409912,
                    "w": 0.3410559594631195,
                },
                "roll": 0.18944384157657623,
                "pitch": 0.09714129567146301,
                "yaw": 0.10908138751983643,
                "quality": 50,
                "source_width": 2048,
                "source_height": 1280,
                "has_smile": 0,
                "left_eye_closed": 1,
                "right_eye_closed": 1,
                "manual": 0,
                "face_type": 1,
                "age_type": None,
                "eye_makeup_type": None,
                "eye_state": None,
                "facial_hair_type": None,
                "gender_type": None,
                "glasses_type": None,
                "hair_color_type": None,
                "intrash": None,
                "lip_makeup_type": None,
                "smile_type": None,
            }
        }
    },
    {
        "QR7M5%NHS4CFh083FG89AA": {
            "jA3QqsAPQemcz1utrq3vMg": {
                "_pk": 22,
                "uuid": "jA3QqsAPQemcz1utrq3vMg",
                "name": "Lipstick",
                "asset_uuid": "QR7M5%NHS4CFh083FG89AA",
                "_person_pk": 19,
                "center_x": 0.4784306287765503,
                "center_y": 0.39015408605337143,
                "center": (1068, 832),
                "mouth_x": 0.48387350854591027,
                "mouth_y": 0.2668730584418455,
                "mouth": (1055, 999),
                "left_eye_x": 0.4130895994925139,
                "left_eye_y": 0.502680173113216,
                "left_eye": (1202, 679),
                "right_eye_x": 0.5621348168843756,
                "right_eye_y": 0.5023313897760282,
                "right_eye": (897, 677),
                "size": 0.36072171467822045,
                "face_rect": [
                    (698.6209641695023, 462.62096416950226),
                    (1437.3790358304977, 1201.3790358304977),
                ],
                "mpri_reg_rect": {
                    "x": 0.3412085138843395,
                    "y": 0.33923856168985367,
                    "h": 0.36072171467822045,
                    "w": 0.5412147045135498,
                },
                "mwg_rs_area": {
                    "x": 0.5215693712234497,
                    "y": 0.6098459139466286,
                    "h": 0.5412147045135498,
                    "w": 0.36072171467822045,
                },
                "roll": -0.00878172367811203,
                "pitch": 0.20460352301597595,
                "yaw": -0.1261640340089798,
                "quality": 191,
                "source_width": 2048,
                "source_height": 1365,
                "has_smile": 0,
                "left_eye_closed": 0,
                "right_eye_closed": 0,
                "manual": 0,
                "face_type": 0,
                "age_type": None,
                "eye_makeup_type": None,
                "eye_state": None,
                "facial_hair_type": None,
                "gender_type": None,
                "glasses_type": None,
                "hair_color_type": None,
                "intrash": None,
                "lip_makeup_type": None,
                "smile_type": None,
            }
        }
    },
    {
        "oYEHHYpFRCeyVQ0P1JORXA": {
            "5uijKNDeTsWROronEd3Abg": {
                "_pk": 6,
                "uuid": "5uijKNDeTsWROronEd3Abg",
                "name": None,
                "asset_uuid": "oYEHHYpFRCeyVQ0P1JORXA",
                "_person_pk": 2,
                "center_x": 0.5973683595657349,
                "center_y": 0.4345279335975647,
                "center": (645, 653),
                "mouth_x": 0.7098645245358473,
                "mouth_y": 0.3638399654200981,
                "mouth": (790, 655),
                "left_eye_x": 0.5021282153948434,
                "left_eye_y": 0.4635712089724464,
                "left_eye": (540, 680),
                "right_eye_x": 0.6843432186069451,
                "right_eye_y": 0.5707060862312616,
                "right_eye": (638, 469),
                "size": 0.5660233497619629,
                "face_rect": [
                    (318.12151551246643, 326.12151551246643),
                    (971.8784844875336, 979.8784844875336),
                ],
                "mpri_reg_rect": {
                    "x": 0.29470309615135193,
                    "y": 0.28246039152145386,
                    "h": 0.6053305268287659,
                    "w": 0.5660233497619629,
                },
                "mwg_rs_area": {
                    "x": 0.5973683595657349,
                    "y": 0.5654720664024353,
                    "h": 0.5660233497619629,
                    "w": 0.6053305268287659,
                },
                "roll": 0.5728198289871216,
                "pitch": -0.053152959793806076,
                "yaw": 0.22457750141620636,
                "quality": 95,
                "source_width": 1080,
                "source_height": 1155,
                "has_smile": 0,
                "left_eye_closed": 0,
                "right_eye_closed": 0,
                "manual": 0,
                "face_type": 1,
                "age_type": None,
                "eye_makeup_type": None,
                "eye_state": None,
                "facial_hair_type": None,
                "gender_type": None,
                "glasses_type": None,
                "hair_color_type": None,
                "intrash": None,
                "lip_makeup_type": None,
                "smile_type": None,
            }
        }
    },
    {
        "%cpwL2b%RfaVD1YIY2r7OQ": {
            "bGjl7MxFRoOEMOngy21IEg": {
                "_pk": 25,
                "uuid": "bGjl7MxFRoOEMOngy21IEg",
                "name": "Lipstick",
                "asset_uuid": "%cpwL2b%RfaVD1YIY2r7OQ",
                "_person_pk": 19,
                "center_x": 0.49900373816490173,
                "center_y": 0.4124687761068344,
                "center": (1021, 563),
                "mouth_x": 0.5159825623064371,
                "mouth_y": 0.2651180562335753,
                "mouth": (1054, 360),
                "left_eye_x": 0.43235921504548847,
                "left_eye_y": 0.508712370488908,
                "left_eye": (885, 694),
                "right_eye_x": 0.5844922924995668,
                "right_eye_y": 0.5045386428834604,
                "right_eye": (1197, 686),
                "size": 0.32122206687927246,
                "face_rect": [
                    (692.068603515625, 234.068603515625),
                    (1349.931396484375, 891.931396484375),
                ],
                "mpri_reg_rect": {
                    "x": 0.3383927047252655,
                    "y": 0.17149339406699923,
                    "h": 0.32122206687927246,
                    "w": 0.48195076407967036,
                },
                "mwg_rs_area": {
                    "x": 0.49900373816490173,
                    "y": 0.4124687761068344,
                    "h": 0.48195076407967036,
                    "w": 0.32122206687927246,
                },
                "roll": 0.006197962909936905,
                "pitch": 0.21005557477474213,
                "yaw": 0.15046006441116333,
                "quality": 188,
                "source_width": 2048,
                "source_height": 1365,
                "has_smile": 0,
                "left_eye_closed": 0,
                "right_eye_closed": 0,
                "manual": 0,
                "face_type": 0,
                "age_type": None,
                "eye_makeup_type": None,
                "eye_state": None,
                "facial_hair_type": None,
                "gender_type": None,
                "glasses_type": None,
                "hair_color_type": None,
                "intrash": None,
                "lip_makeup_type": None,
                "smile_type": None,
            }
        }
    },
    {
        "Cb%vzf7fQ66ugEa6VKpUOw": {
            "nAabJg8xSJuSjPSdC1Mzgg": {
                "_pk": 2,
                "uuid": "nAabJg8xSJuSjPSdC1Mzgg",
                "name": "Statue",
                "asset_uuid": "Cb%vzf7fQ66ugEa6VKpUOw",
                "_person_pk": 1,
                "center_x": 0.48914097119645494,
                "center_y": 0.8721554191285079,
                "center": (1347, 352),
                "mouth_x": 0,
                "mouth_y": 0,
                "mouth": (0, 2754),
                "left_eye_x": 0,
                "left_eye_y": 0,
                "left_eye": (0, 2754),
                "right_eye_x": 0,
                "right_eye_y": 0,
                "right_eye": (0, 2754),
                "size": 0.06172188225364008,
                "face_rect": [
                    (1262.0089681367376, 267.0089681367376),
                    (1431.9910318632624, 436.9910318632624),
                ],
                "mpri_reg_rect": {
                    "x": 0.4582800300696349,
                    "y": 0.09698363974467204,
                    "h": 0.06172188225364008,
                    "w": 0.06172188225364008,
                },
                "mwg_rs_area": {
                    "x": 0.48914097119645494,
                    "y": 0.1278445808714921,
                    "h": 0.06172188225364008,
                    "w": 0.06172188225364008,
                },
                "roll": 0,
                "pitch": 0,
                "yaw": 0,
                "quality": 0,
                "source_width": 2754,
                "source_height": 2754,
                "has_smile": 0,
                "left_eye_closed": 0,
                "right_eye_closed": 0,
                "manual": 1,
                "face_type": 2,
                "age_type": None,
                "eye_makeup_type": None,
                "eye_state": None,
                "facial_hair_type": None,
                "gender_type": None,
                "glasses_type": None,
                "hair_color_type": None,
                "intrash": None,
                "lip_makeup_type": None,
                "smile_type": None,
            }
        }
    },
    {
        "F0cTJn97T020nbdYok4PsA": {
            "XEUathGjS96VT2b5Nkky9w": {
                "_pk": 18,
                "uuid": "XEUathGjS96VT2b5Nkky9w",
                "name": "Exif",
                "asset_uuid": "F0cTJn97T020nbdYok4PsA",
                "_person_pk": 16,
                "center_x": 0.5979335755109787,
                "center_y": 0.4000065103173256,
                "center": (820, 823),
                "mouth_x": 0.5701882112594951,
                "mouth_y": 0.22819440997812163,
                "mouth": (1058, 861),
                "left_eye_x": 0.49976774329850177,
                "left_eye_y": 0.42227468854307304,
                "left_eye": (804, 1025),
                "right_eye_x": 0.633480766800602,
                "right_eye_y": 0.4474139110816546,
                "right_eye": (749, 755),
                "size": 0.4199619094724767,
                "face_rect": [
                    (389.95900470018387, 392.95900470018387),
                    (1250.0409952998161, 1253.0409952998161),
                ],
                "mpri_reg_rect": {
                    "x": 0.28540607541799545,
                    "y": 0.19208546975278296,
                    "h": 0.6291748285293579,
                    "w": 0.4199619094724767,
                },
                "mwg_rs_area": {
                    "x": 0.5999934896826744,
                    "y": 0.4020664244890213,
                    "h": 0.4199619094724767,
                    "w": 0.6291748285293579,
                },
                "roll": 0.07780183106660843,
                "pitch": 0.2246328890323639,
                "yaw": -0.6294457912445068,
                "quality": 245,
                "source_width": 2048,
                "source_height": 1367,
                "has_smile": 0,
                "left_eye_closed": 0,
                "right_eye_closed": 0,
                "manual": 0,
                "face_type": 0,
                "age_type": None,
                "eye_makeup_type": None,
                "eye_state": None,
                "facial_hair_type": None,
                "gender_type": None,
                "glasses_type": None,
                "hair_color_type": None,
                "intrash": None,
                "lip_makeup_type": None,
                "smile_type": None,
            }
        }
    },
    {
        "sp5RBdGrQCC+I%YfMHjoZA": {
            "MSyq1yMuT%mRFL%nTg52JQ": {
                "_pk": 24,
                "uuid": "MSyq1yMuT%mRFL%nTg52JQ",
                "name": "Lipstick",
                "asset_uuid": "sp5RBdGrQCC+I%YfMHjoZA",
                "_person_pk": 19,
                "center_x": 0.5048958957195282,
                "center_y": 0.39591725170612335,
                "center": (1013, 824),
                "mouth_x": 0.5163976288938734,
                "mouth_y": 0.26605577475987374,
                "mouth": (991, 1001),
                "left_eye_x": 0.4322333065850734,
                "left_eye_y": 0.5076869609068195,
                "left_eye": (1160, 670),
                "right_eye_x": 0.5864400681517541,
                "right_eye_y": 0.5023518790495496,
                "right_eye": (844, 680),
                "size": 0.35138061008183286,
                "face_rect": [
                    (653.1862552762032, 464.18625527620316),
                    (1372.8137447237968, 1183.8137447237968),
                ],
                "mpri_reg_rect": {
                    "x": 0.3194137992395554,
                    "y": 0.3404829353094101,
                    "h": 0.35138061008183286,
                    "w": 0.5271996259689331,
                },
                "mwg_rs_area": {
                    "x": 0.4951041042804718,
                    "y": 0.6040827482938766,
                    "h": 0.5271996259689331,
                    "w": 0.35138061008183286,
                },
                "roll": 0.007040311582386494,
                "pitch": 0.20919206738471985,
                "yaw": 0.13513553142547607,
                "quality": 186,
                "source_width": 2048,
                "source_height": 1365,
                "has_smile": 0,
                "left_eye_closed": 0,
                "right_eye_closed": 0,
                "manual": 0,
                "face_type": 2,
                "age_type": None,
                "eye_makeup_type": None,
                "eye_state": None,
                "facial_hair_type": None,
                "gender_type": None,
                "glasses_type": None,
                "hair_color_type": None,
                "intrash": None,
                "lip_makeup_type": None,
                "smile_type": None,
            }
        }
    },
    {
        "iSgalkCMRjWXP8HnW19wnQ": {
            "ZXhdkXTHR+qwk189VQedxA": {
                "_pk": 13,
                "uuid": "ZXhdkXTHR+qwk189VQedxA",
                "name": None,
                "asset_uuid": "iSgalkCMRjWXP8HnW19wnQ",
                "_person_pk": 4,
                "center_x": 0.49157917499542236,
                "center_y": 0.4659397155046463,
                "center": (502, 364),
                "mouth_x": 0.5123779577260212,
                "mouth_y": 0.2582757475010169,
                "mouth": (536, 502),
                "left_eye_x": 0.4050272297081152,
                "left_eye_y": 0.5518229548743072,
                "left_eye": (408, 313),
                "right_eye_x": 0.5948667321137826,
                "right_eye_y": 0.5856497606665094,
                "right_eye": (599, 272),
                "size": 0.4159531593322754,
                "face_rect": [
                    (289.23995900154114, 151.23995900154114),
                    (714.7600409984589, 576.7600409984589),
                ],
                "mpri_reg_rect": {
                    "x": 0.28360259532928467,
                    "y": 0.22209541499614716,
                    "h": 0.4159531593322754,
                    "w": 0.6239297389984131,
                },
                "mwg_rs_area": {
                    "x": 0.49157917499542236,
                    "y": 0.5340602844953537,
                    "h": 0.6239297389984131,
                    "w": 0.4159531593322754,
                },
                "roll": 0.09273363649845123,
                "pitch": 0.12770117819309235,
                "yaw": -0.11702278256416321,
                "quality": 82,
                "source_width": 1023,
                "source_height": 682,
                "has_smile": 0,
                "left_eye_closed": 0,
                "right_eye_closed": 0,
                "manual": 0,
                "face_type": 1,
                "age_type": None,
                "eye_makeup_type": None,
                "eye_state": None,
                "facial_hair_type": None,
                "gender_type": None,
                "glasses_type": None,
                "hair_color_type": None,
                "intrash": None,
                "lip_makeup_type": None,
                "smile_type": None,
            }
        }
    },
    {
        "QjVE5TXlT7++IIFcaIdi8w": {
            "5gCD9cLzS+2bFaQCj%5ctg": {
                "_pk": 15,
                "uuid": "5gCD9cLzS+2bFaQCj%5ctg",
                "name": None,
                "asset_uuid": "QjVE5TXlT7++IIFcaIdi8w",
                "_person_pk": 6,
                "center_x": 0.5858511626720428,
                "center_y": 0.5037799179553986,
                "center": (1199, 668),
                "mouth_x": 0.5892474464528483,
                "mouth_y": 0.35767456356643335,
                "mouth": (1206, 864),
                "left_eye_x": 0.5193234659502858,
                "left_eye_y": 0.6105601153481182,
                "left_eye": (1062, 524),
                "right_eye_x": 0.6540367582498816,
                "right_eye_y": 0.618458101733407,
                "right_eye": (1338, 513),
                "size": 0.3303346037864685,
                "face_rect": [
                    (860.7373657226562, 329.73736572265625),
                    (1537.2626342773438, 1006.2626342773438),
                ],
                "mpri_reg_rect": {
                    "x": 0.4206838607788086,
                    "y": 0.2452834097320319,
                    "h": 0.3303346037864685,
                    "w": 0.5018733446251391,
                },
                "mwg_rs_area": {
                    "x": 0.5858511626720428,
                    "y": 0.49622008204460144,
                    "h": 0.5018733446251391,
                    "w": 0.3303346037864685,
                },
                "roll": 0.0011079381220042706,
                "pitch": 0.15608316659927368,
                "yaw": -0.17298434674739838,
                "quality": 72,
                "source_width": 2048,
                "source_height": 1348,
                "has_smile": 1,
                "left_eye_closed": 1,
                "right_eye_closed": 1,
                "manual": 0,
                "face_type": 1,
                "age_type": None,
                "eye_makeup_type": None,
                "eye_state": None,
                "facial_hair_type": None,
                "gender_type": None,
                "glasses_type": None,
                "hair_color_type": None,
                "intrash": None,
                "lip_makeup_type": None,
                "smile_type": None,
            }
        }
    },
    {
        "1OznJLyLTL+MilyfvdtUVA": {
            "yepVq6gaQ1mh4exLspUtTg": {
                "_pk": 5,
                "uuid": "yepVq6gaQ1mh4exLspUtTg",
                "name": "Exif",
                "asset_uuid": "1OznJLyLTL+MilyfvdtUVA",
                "_person_pk": 16,
                "center_x": 0.49520042538642883,
                "center_y": 0.4185177907347679,
                "center": (1014, 794),
                "mouth_x": 0.4949742422706098,
                "mouth_y": 0.2797994672715518,
                "mouth": (1034, 982),
                "left_eye_x": 0.4381955488736562,
                "left_eye_y": 0.5188265057902228,
                "left_eye": (882, 671),
                "right_eye_x": 0.5439683676951406,
                "right_eye_y": 0.5509752697572754,
                "right_eye": (1092, 602),
                "size": 0.4084373274235986,
                "face_rect": [
                    (595.760176718235, 375.760176718235),
                    (1432.239823281765, 1212.239823281765),
                ],
                "mpri_reg_rect": {
                    "x": 0.2909817616746295,
                    "y": 0.2755276933312416,
                    "h": 0.4084373274235986,
                    "w": 0.611909031867981,
                },
                "mwg_rs_area": {
                    "x": 0.49520042538642883,
                    "y": 0.5814822092652321,
                    "h": 0.611909031867981,
                    "w": 0.4084373274235986,
                },
                "roll": 0.11499591916799545,
                "pitch": 0.23600168526172638,
                "yaw": -0.5437864065170288,
                "quality": 228,
                "source_width": 2048,
                "source_height": 1367,
                "has_smile": 0,
                "left_eye_closed": 0,
                "right_eye_closed": 0,
                "manual": 0,
                "face_type": 0,
                "age_type": None,
                "eye_makeup_type": None,
                "eye_state": None,
                "facial_hair_type": None,
                "gender_type": None,
                "glasses_type": None,
                "hair_color_type": None,
                "intrash": None,
                "lip_makeup_type": None,
                "smile_type": None,
            }
        }
    },
    {
        "7p4lu%p9R+GqgmYFZ6aCiQ": {
            "wMl+k8OQR9ObpdLuizmUig": {
                "_pk": 16,
                "uuid": "wMl+k8OQR9ObpdLuizmUig",
                "name": "Exif",
                "asset_uuid": "7p4lu%p9R+GqgmYFZ6aCiQ",
                "_person_pk": 16,
                "center_x": 0.49283619225025177,
                "center_y": 0.4199286699295044,
                "center": (1038, 574),
                "mouth_x": 0.49455960669416604,
                "mouth_y": 0.28072212860962215,
                "mouth": (1013, 384),
                "left_eye_x": 0.43746744610133503,
                "left_eye_y": 0.5173764723232099,
                "left_eye": (1166, 693),
                "right_eye_x": 0.5433972949013759,
                "right_eye_y": 0.5509179967349169,
                "right_eye": (956, 763),
                "size": 0.407234111597063,
                "face_rect": [
                    (620.9922697246075, 156.99226972460747),
                    (1455.0077302753925, 991.0077302753925),
                ],
                "mpri_reg_rect": {
                    "x": 0.3035467519512167,
                    "y": 0.11487546563148499,
                    "h": 0.407234111597063,
                    "w": 0.6101064085960388,
                },
                "mwg_rs_area": {
                    "x": 0.5071638077497482,
                    "y": 0.4199286699295044,
                    "h": 0.6101064085960388,
                    "w": 0.407234111597063,
                },
                "roll": 0.1143658310174942,
                "pitch": 0.218518927693367,
                "yaw": -0.5080658793449402,
                "quality": 230,
                "source_width": 2048,
                "source_height": 1367,
                "has_smile": 0,
                "left_eye_closed": 0,
                "right_eye_closed": 0,
                "manual": 0,
                "face_type": 2,
                "age_type": None,
                "eye_makeup_type": None,
                "eye_state": None,
                "facial_hair_type": None,
                "gender_type": None,
                "glasses_type": None,
                "hair_color_type": None,
                "intrash": None,
                "lip_makeup_type": None,
                "smile_type": None,
            }
        }
    },
    {
        "Kw9u7AzRTm6ZlrLS7uk%7g": {
            "GINakHzJROi+xYZ1V10bcA": {
                "_pk": 7,
                "uuid": "GINakHzJROi+xYZ1V10bcA",
                "name": "Eye Makeup",
                "asset_uuid": "Kw9u7AzRTm6ZlrLS7uk%7g",
                "_person_pk": 18,
                "center_x": 0.38622215390205383,
                "center_y": 0.4991014401894063,
                "center": (790, 685),
                "mouth_x": 0.3257504820828174,
                "mouth_y": 0.14377994911402245,
                "mouth": (566, 1134),
                "left_eye_x": 0.31362280485886185,
                "left_eye_y": 0.8060209784105674,
                "left_eye": (734, 243),
                "right_eye_x": 0.5770966030124338,
                "right_eye_y": 0.6688087663145099,
                "right_eye": (1221, 541),
                "size": 0.6647756442835089,
                "face_rect": [
                    (109.2697402536869, 4.269740253686905),
                    (1470.730259746313, 1365.730259746313),
                ],
                "mpri_reg_rect": {
                    "x": 0.05383433176029939,
                    "y": 0.003652204992249608,
                    "h": 0.6647756442835089,
                    "w": 0.9944927096366882,
                },
                "mwg_rs_area": {
                    "x": 0.38622215390205383,
                    "y": 0.5008985598105937,
                    "h": 0.9944927096366882,
                    "w": 0.6647756442835089,
                },
                "roll": -0.21350595355033875,
                "pitch": 0.019776595756411552,
                "yaw": -0.7791038155555725,
                "quality": 256,
                "source_width": 2048,
                "source_height": 1369,
                "has_smile": 1,
                "left_eye_closed": 0,
                "right_eye_closed": 0,
                "manual": 0,
                "face_type": 2,
                "age_type": None,
                "eye_makeup_type": None,
                "eye_state": None,
                "facial_hair_type": None,
                "gender_type": None,
                "glasses_type": None,
                "hair_color_type": None,
                "intrash": None,
                "lip_makeup_type": None,
                "smile_type": None,
            }
        }
    },
    {
        "mFtXPfaqS46xOmW6oUmjqw": {
            "RfluEu+6S8GiUaerDwhGmA": {
                "_pk": 26,
                "uuid": "RfluEu+6S8GiUaerDwhGmA",
                "name": "Lipstick",
                "asset_uuid": "mFtXPfaqS46xOmW6oUmjqw",
                "_person_pk": 19,
                "center_x": 0.49835699796676636,
                "center_y": 0.409689337015152,
                "center": (559, 1027),
                "mouth_x": 0.5165723112827033,
                "mouth_y": 0.26518058035270275,
                "mouth": (360, 991),
                "left_eye_x": 0.4329161551265429,
                "left_eye_y": 0.5067393811582874,
                "left_eye": (691, 1160),
                "right_eye_x": 0.585127821172057,
                "right_eye_y": 0.50484344806048,
                "right_eye": (687, 848),
                "size": 0.3202422261238098,
                "face_rect": [
                    (231.07196044921875, 699.0719604492188),
                    (886.9280395507812, 1354.9280395507812),
                ],
                "mpri_reg_rect": {
                    "x": 0.16944901499992762,
                    "y": 0.34152188897132874,
                    "h": 0.4804806440304487,
                    "w": 0.3202422261238098,
                },
                "mwg_rs_area": {
                    "x": 0.409689337015152,
                    "y": 0.5016430020332336,
                    "h": 0.3202422261238098,
                    "w": 0.4804806440304487,
                },
                "roll": 0.006006680894643068,
                "pitch": 0.18651345372200012,
                "yaw": 0.15917356312274933,
                "quality": 188,
                "source_width": 2048,
                "source_height": 1365,
                "has_smile": 0,
                "left_eye_closed": 0,
                "right_eye_closed": 0,
                "manual": 0,
                "face_type": 0,
                "age_type": None,
                "eye_makeup_type": None,
                "eye_state": None,
                "facial_hair_type": None,
                "gender_type": None,
                "glasses_type": None,
                "hair_color_type": None,
                "intrash": None,
                "lip_makeup_type": None,
                "smile_type": None,
            }
        }
    },
    {
        "q9FarmdfTBady8nD%PvS2w": {
            "SEJHJQ1TRoKac1OlZ68p1w": {
                "_pk": 3,
                "uuid": "SEJHJQ1TRoKac1OlZ68p1w",
                "name": None,
                "asset_uuid": "q9FarmdfTBady8nD%PvS2w",
                "_person_pk": 3,
                "center_x": 0.35166485607624054,
                "center_y": 0.7609184086322784,
                "center": (683, 489),
                "mouth_x": 0.35556657906816547,
                "mouth_y": 0.7238666447663498,
                "mouth": (693, 564),
                "left_eye_x": 0.32227703141131914,
                "left_eye_y": 0.7932268581371029,
                "left_eye": (623, 424),
                "right_eye_x": 0.3941207257922079,
                "right_eye_y": 0.7964365028712619,
                "right_eye": (763, 413),
                "size": 0.16078049541393255,
                "face_rect": [
                    (518.44116294384, 324.44116294384),
                    (847.55883705616, 653.55883705616),
                ],
                "mpri_reg_rect": {
                    "x": 0.2670152485370636,
                    "y": 0.15869134366075527,
                    "h": 0.16929921507835388,
                    "w": 0.16078049541393255,
                },
                "mwg_rs_area": {
                    "x": 0.35166485607624054,
                    "y": 0.23908159136772156,
                    "h": 0.16078049541393255,
                    "w": 0.16929921507835388,
                },
                "roll": 0.030966969206929207,
                "pitch": -0.15051455795764923,
                "yaw": -0.14275819063186646,
                "quality": 111,
                "source_width": 1944,
                "source_height": 2047,
                "has_smile": 1,
                "left_eye_closed": 0,
                "right_eye_closed": 0,
                "manual": 0,
                "face_type": 1,
                "age_type": None,
                "eye_makeup_type": None,
                "eye_state": None,
                "facial_hair_type": None,
                "gender_type": None,
                "glasses_type": None,
                "hair_color_type": None,
                "intrash": None,
                "lip_makeup_type": None,
                "smile_type": None,
            },
            "7CqIoKTTRvm%yJlnVaQ33w": {
                "_pk": 4,
                "uuid": "7CqIoKTTRvm%yJlnVaQ33w",
                "name": None,
                "asset_uuid": "q9FarmdfTBady8nD%PvS2w",
                "_person_pk": 10,
                "center_x": 0.6266480758786201,
                "center_y": 0.6014776527881622,
                "center": (1218, 815),
                "mouth_x": 0.6258384021404593,
                "mouth_y": 0.5530578120025305,
                "mouth": (1224, 913),
                "left_eye_x": 0.5855725633978821,
                "left_eye_y": 0.6364960223978318,
                "left_eye": (1132, 750),
                "right_eye_x": 0.6708216799147163,
                "right_eye_y": 0.6449978725079792,
                "right_eye": (1296, 719),
                "size": 0.21031826734542847,
                "face_rect": [
                    (1002.739253371954, 599.739253371954),
                    (1433.260746628046, 1030.260746628046),
                ],
                "mpri_reg_rect": {
                    "x": 0.5159172391357981,
                    "y": 0.29336321353912354,
                    "h": 0.22146167348564408,
                    "w": 0.21031826734542847,
                },
                "mwg_rs_area": {
                    "x": 0.6266480758786201,
                    "y": 0.39852234721183777,
                    "h": 0.21031826734542847,
                    "w": 0.22146167348564408,
                },
                "roll": 0.08154229819774628,
                "pitch": 0.08564881980419159,
                "yaw": 0.04153404384851456,
                "quality": 132,
                "source_width": 1944,
                "source_height": 2047,
                "has_smile": 0,
                "left_eye_closed": 0,
                "right_eye_closed": 0,
                "manual": 0,
                "face_type": 1,
                "age_type": None,
                "eye_makeup_type": None,
                "eye_state": None,
                "facial_hair_type": None,
                "gender_type": None,
                "glasses_type": None,
                "hair_color_type": None,
                "intrash": None,
                "lip_makeup_type": None,
                "smile_type": None,
            },
        }
    },
    {
        "4Jyb01fTQVulQSQusXCd0g": {
            "xaMv0TM%RU+0LnsyF6gLgQ": {
                "_pk": 14,
                "uuid": "xaMv0TM%RU+0LnsyF6gLgQ",
                "name": "Girl Winking",
                "asset_uuid": "4Jyb01fTQVulQSQusXCd0g",
                "_person_pk": 17,
                "center_x": 0.7967365458607674,
                "center_y": 0.5234079957008362,
                "center": (1631, 650),
                "mouth_x": 0.8046641000137214,
                "mouth_y": 0.45113750280791454,
                "mouth": (1642, 749),
                "left_eye_x": 0.7553940984237065,
                "left_eye_y": 0.6019085802032054,
                "left_eye": (1551, 539),
                "right_eye_x": 0.8466470655607516,
                "right_eye_y": 0.5878877046499715,
                "right_eye": (1736, 566),
                "size": 0.2454776929516811,
                "face_rect": [
                    (1379.6308424174786, 398.63084241747856),
                    (1882.3691575825214, 901.3691575825214),
                ],
                "mpri_reg_rect": {
                    "x": 0.6739976993849268,
                    "y": 0.2924387753009796,
                    "h": 0.2454776929516811,
                    "w": 0.3683064579963684,
                },
                "mwg_rs_area": {
                    "x": 0.7967365458607674,
                    "y": 0.4765920042991638,
                    "h": 0.3683064579963684,
                    "w": 0.2454776929516811,
                },
                "roll": -0.04044049605727196,
                "pitch": 0.06674261391162872,
                "yaw": 0.6553094983100891,
                "quality": 355,
                "source_width": 2048,
                "source_height": 1365,
                "has_smile": 1,
                "left_eye_closed": 0,
                "right_eye_closed": 0,
                "manual": 0,
                "face_type": 2,
                "age_type": None,
                "eye_makeup_type": None,
                "eye_state": None,
                "facial_hair_type": None,
                "gender_type": None,
                "glasses_type": None,
                "hair_color_type": None,
                "intrash": None,
                "lip_makeup_type": None,
                "smile_type": None,
            }
        }
    },
    {
        "d%8mtMMqQh62cWwTL%62ig": {
            "iiaQTczXTTeaDyEw+0CoZg": {
                "_pk": 11,
                "uuid": "iiaQTczXTTeaDyEw+0CoZg",
                "name": "Lipstick",
                "asset_uuid": "d%8mtMMqQh62cWwTL%62ig",
                "_person_pk": 19,
                "center_x": 0.504969596862793,
                "center_y": 0.4010424464941025,
                "center": (1034, 817),
                "mouth_x": 0.5169273786714754,
                "mouth_y": 0.2643267306198762,
                "mouth": (1059, 1003),
                "left_eye_x": 0.4328751582495114,
                "left_eye_y": 0.5063963073010473,
                "left_eye": (885, 674),
                "right_eye_x": 0.5847249659037077,
                "right_eye_y": 0.5024008466671561,
                "right_eye": (1196, 677),
                "size": 0.345591909281211,
                "face_rect": [
                    (680.11388489604, 463.11388489603996),
                    (1387.88611510396, 1170.88611510396),
                ],
                "mpri_reg_rect": {
                    "x": 0.3321736422221875,
                    "y": 0.3397003263235092,
                    "h": 0.345591909281211,
                    "w": 0.5185144543647766,
                },
                "mwg_rs_area": {
                    "x": 0.504969596862793,
                    "y": 0.5989575535058975,
                    "h": 0.5185144543647766,
                    "w": 0.345591909281211,
                },
                "roll": 0.006853761617094278,
                "pitch": 0.21358969807624817,
                "yaw": 0.12813955545425415,
                "quality": 185,
                "source_width": 2048,
                "source_height": 1365,
                "has_smile": 0,
                "left_eye_closed": 0,
                "right_eye_closed": 0,
                "manual": 0,
                "face_type": 0,
                "age_type": None,
                "eye_makeup_type": None,
                "eye_state": None,
                "facial_hair_type": None,
                "gender_type": None,
                "glasses_type": None,
                "hair_color_type": None,
                "intrash": None,
                "lip_makeup_type": None,
                "smile_type": None,
            }
        }
    },
    {
        "SuDOJaA7REKBzYCEy19dHQ": {
            "HHvHG+i8SimPaZQkZLGw9w": {
                "_pk": 17,
                "uuid": "HHvHG+i8SimPaZQkZLGw9w",
                "name": None,
                "asset_uuid": "SuDOJaA7REKBzYCEy19dHQ",
                "_person_pk": 12,
                "center_x": 0.3634738326072693,
                "center_y": 0.7156831920146942,
                "center": (581, 255),
                "mouth_x": 0.4014207073465249,
                "mouth_y": 0.6208798692679718,
                "mouth": (662, 321),
                "left_eye_x": 0.3191890815262972,
                "left_eye_y": 0.846999683488884,
                "left_eye": (481, 160),
                "right_eye_x": 0.4304217538290107,
                "right_eye_y": 0.9158867686635856,
                "right_eye": (636, 53),
                "size": 0.31717346236109734,
                "face_rect": [
                    (327.26123011112213, 1.2612301111221313),
                    (834.7387698888779, 508.73876988887787),
                ],
                "mpri_reg_rect": {
                    "x": 0.20488710142672062,
                    "y": 0.0023848414421081543,
                    "h": 0.31717346236109734,
                    "w": 0.5638639330863953,
                },
                "mwg_rs_area": {
                    "x": 0.3634738326072693,
                    "y": 0.2843168079853058,
                    "h": 0.5638639330863953,
                    "w": 0.31717346236109734,
                },
                "roll": 0.26922887563705444,
                "pitch": -0.009663085453212261,
                "yaw": -0.27014461159706116,
                "quality": 230,
                "source_width": 1600,
                "source_height": 900,
                "has_smile": 0,
                "left_eye_closed": 0,
                "right_eye_closed": 0,
                "manual": 0,
                "face_type": 1,
                "age_type": None,
                "eye_makeup_type": None,
                "eye_state": None,
                "facial_hair_type": None,
                "gender_type": None,
                "glasses_type": None,
                "hair_color_type": None,
                "intrash": None,
                "lip_makeup_type": None,
                "smile_type": None,
            }
        }
    },
    {
        "VNn4U31zQpmDv2vUgpaXAw": {
            "yUVrbA2eSnGg2SeLUYgALQ": {
                "_pk": 10,
                "uuid": "yUVrbA2eSnGg2SeLUYgALQ",
                "name": "Exif",
                "asset_uuid": "VNn4U31zQpmDv2vUgpaXAw",
                "_person_pk": 16,
                "center_x": 0.5564179867506027,
                "center_y": 0.4015430510044098,
                "center": (548, 1139),
                "mouth_x": 0.6077994839334737,
                "mouth_y": 0.21313020189502296,
                "mouth": (290, 1243),
                "left_eye_x": 0.5076221950606581,
                "left_eye_y": 0.4479901973317695,
                "left_eye": (612, 1039),
                "right_eye_x": 0.6663632581008312,
                "right_eye_y": 0.41701617124271095,
                "right_eye": (569, 1364),
                "size": 0.4360983669757843,
                "face_rect": [
                    (101.43527221679688, 692.4352722167969),
                    (994.5647277832031, 1585.5647277832031),
                ],
                "mpri_reg_rect": {
                    "x": 0.07486804896841626,
                    "y": 0.33836880326271057,
                    "h": 0.6533500040719871,
                    "w": 0.4360983669757843,
                },
                "mwg_rs_area": {
                    "x": 0.4015430510044098,
                    "y": 0.5564179867506027,
                    "h": 0.4360983669757843,
                    "w": 0.6533500040719871,
                },
                "roll": -0.0014577136607840657,
                "pitch": 0.006985893473029137,
                "yaw": 0.323245644569397,
                "quality": 259,
                "source_width": 2048,
                "source_height": 1367,
                "has_smile": 0,
                "left_eye_closed": 0,
                "right_eye_closed": 0,
                "manual": 0,
                "face_type": 0,
                "age_type": None,
                "eye_makeup_type": None,
                "eye_state": None,
                "facial_hair_type": None,
                "gender_type": None,
                "glasses_type": None,
                "hair_color_type": None,
                "intrash": None,
                "lip_makeup_type": None,
                "smile_type": None,
            }
        }
    },
]

UUID_LIST_5 = [
    {
        "41581532-858D-4767-ADA8-9D26C52FCB96": {
            "2DBD01FF-EC8F-4757-8F9E-D5F6AB6EC963": {
                "_pk": 5,
                "uuid": "2DBD01FF-EC8F-4757-8F9E-D5F6AB6EC963",
                "name": "Exif",
                "asset_uuid": "41581532-858D-4767-ADA8-9D26C52FCB96",
                "_person_pk": 16,
                "center_x": 0.506168320775032,
                "center_y": 0.4063185453414917,
                "center": (555, 1036),
                "mouth_x": 0.49372094131355543,
                "mouth_y": 0.28159753170711355,
                "mouth": (384, 1011),
                "left_eye_x": 0.43724246548613566,
                "left_eye_y": 0.5224152194593512,
                "left_eye": (714, 895),
                "right_eye_x": 0.544619582741027,
                "right_eye_y": 0.557959678001068,
                "right_eye": (762, 1115),
                "size": 0.3950786292552948,
                "face_rect": [
                    (150.43948364257812, 631.4394836425781),
                    (959.5605163574219, 1440.5605163574219),
                ],
                "mpri_reg_rect": {
                    "x": 0.1103708376915854,
                    "y": 0.30862900614738464,
                    "h": 0.5918954152998126,
                    "w": 0.3950786292552948,
                },
                "mwg_rs_area": {
                    "x": 0.4063185453414917,
                    "y": 0.506168320775032,
                    "h": 0.3950786292552948,
                    "w": 0.5918954152998126,
                },
                "roll": 0.0,
                "pitch": 0.0,
                "yaw": 0.0,
                "quality": 0.6100583076477051,
                "source_width": 2048,
                "source_height": 1367,
                "has_smile": 0,
                "left_eye_closed": 0,
                "right_eye_closed": 0,
                "manual": 0,
                "face_type": None,
                "age_type": 3,
                "eye_makeup_type": 0,
                "eye_state": 2,
                "facial_hair_type": 1,
                "gender_type": 2,
                "glasses_type": 3,
                "hair_color_type": 1,
                "intrash": 0,
                "lip_makeup_type": 0,
                "smile_type": 2,
            }
        }
    },
    {
        "8C5431B3-5F59-4B5F-855A-021408C519E4": {
            "1F542CBF-BE11-4ACB-A553-FABF81391C97": {
                "_pk": 11,
                "uuid": "1F542CBF-BE11-4ACB-A553-FABF81391C97",
                "name": "",
                "asset_uuid": "8C5431B3-5F59-4B5F-855A-021408C519E4",
                "_person_pk": 3,
                "center_x": 0.39346015453338623,
                "center_y": 0.7326074540615082,
                "center": (629, 240),
                "mouth_x": 0.40481402092397767,
                "mouth_y": 0.6259192903725435,
                "mouth": (692, 314),
                "left_eye_x": 0.3189057640673409,
                "left_eye_y": 0.8466228381157048,
                "left_eye": (474, 211),
                "right_eye_x": 0.43329471470208714,
                "right_eye_y": 0.91743794198708,
                "right_eye": (601, 64),
                "size": 0.3104049414396286,
                "face_rect": [
                    (380.6760468482971, -8.32395315170288),
                    (877.3239531517029, 488.3239531517029),
                ],
                "mpri_reg_rect": {
                    "x": 0.23825768381357193,
                    "y": -0.008522957563400269,
                    "h": 0.3104049414396286,
                    "w": 0.5518310070037842,
                },
                "mwg_rs_area": {
                    "x": 0.39346015453338623,
                    "y": 0.2673925459384918,
                    "h": 0.5518310070037842,
                    "w": 0.3104049414396286,
                },
                "roll": 0.5235987901687622,
                "pitch": 0.0,
                "yaw": 0.0,
                "quality": 0.14434178173542023,
                "source_width": 1600,
                "source_height": 900,
                "has_smile": 0,
                "left_eye_closed": 0,
                "right_eye_closed": 0,
                "manual": 0,
                "face_type": None,
                "age_type": 5,
                "eye_makeup_type": 0,
                "eye_state": 2,
                "facial_hair_type": 2,
                "gender_type": 1,
                "glasses_type": 3,
                "hair_color_type": 3,
                "intrash": 0,
                "lip_makeup_type": 0,
                "smile_type": 1,
            }
        }
    },
    {
        "E7B8ED9C-314E-4459-895D-6BDC6B7D8F6C": {
            "975FE274-A15A-45A2-B12C-031343448048": {
                "_pk": 45,
                "uuid": "975FE274-A15A-45A2-B12C-031343448048",
                "name": "left8",
                "asset_uuid": "E7B8ED9C-314E-4459-895D-6BDC6B7D8F6C",
                "_person_pk": 48,
                "center_x": 0.3113360471918876,
                "center_y": 0.6745229809192367,
                "center": (920, 637),
                "mouth_x": 0.0,
                "mouth_y": 0.0,
                "mouth": (0, 0),
                "left_eye_x": 0.0,
                "left_eye_y": 0.0,
                "left_eye": (0, 0),
                "right_eye_x": 0.0,
                "right_eye_y": 0.0,
                "right_eye": (0, 0),
                "size": 0.0907672643661499,
                "face_rect": [
                    (827.0543212890625, 544.0543212890625),
                    (1012.9456787109375, 729.9456787109375),
                ],
                "mpri_reg_rect": {
                    "x": 0.6064309086035315,
                    "y": 0.26595241500881267,
                    "h": 0.13618414463141026,
                    "w": 0.0907672643661499,
                },
                "mwg_rs_area": {
                    "x": 0.6745229809192367,
                    "y": 0.3113360471918876,
                    "h": 0.0907672643661499,
                    "w": 0.13618414463141026,
                },
                "roll": 0.0,
                "pitch": 0.0,
                "yaw": 0.0,
                "quality": -1.0,
                "source_width": 2048,
                "source_height": 1365,
                "has_smile": 0,
                "left_eye_closed": 0,
                "right_eye_closed": 0,
                "manual": 1,
                "face_type": None,
                "age_type": 0,
                "eye_makeup_type": 0,
                "eye_state": 0,
                "facial_hair_type": 0,
                "gender_type": 0,
                "glasses_type": 0,
                "hair_color_type": 0,
                "intrash": 0,
                "lip_makeup_type": 0,
                "smile_type": 0,
            },
            "05BC1A65-9743-4B8E-9A10-1A0B78E3E949": {
                "_pk": 46,
                "uuid": "05BC1A65-9743-4B8E-9A10-1A0B78E3E949",
                "name": "right8",
                "asset_uuid": "E7B8ED9C-314E-4459-895D-6BDC6B7D8F6C",
                "_person_pk": 49,
                "center_x": 0.7171411856474258,
                "center_y": 0.5784734246512717,
                "center": (789, 1468),
                "mouth_x": 0.0,
                "mouth_y": 0.0,
                "mouth": (0, 0),
                "left_eye_x": 0.0,
                "left_eye_y": 0.0,
                "left_eye": (0, 0),
                "right_eye_x": 0.0,
                "right_eye_y": 0.0,
                "right_eye": (0, 0),
                "size": 0.08651255071163177,
                "face_rect": [
                    (700.4111480712891, 1379.411148071289),
                    (877.5888519287109, 1556.588851928711),
                ],
                "mpri_reg_rect": {
                    "x": 0.5135731668280402,
                    "y": 0.6738849102916099,
                    "h": 0.12980051564646292,
                    "w": 0.08651255071163177,
                },
                "mwg_rs_area": {
                    "x": 0.5784734246512717,
                    "y": 0.7171411856474258,
                    "h": 0.08651255071163177,
                    "w": 0.12980051564646292,
                },
                "roll": 0.0,
                "pitch": 0.0,
                "yaw": 0.0,
                "quality": -1.0,
                "source_width": 2048,
                "source_height": 1365,
                "has_smile": 0,
                "left_eye_closed": 0,
                "right_eye_closed": 0,
                "manual": 1,
                "face_type": None,
                "age_type": 0,
                "eye_makeup_type": 0,
                "eye_state": 0,
                "facial_hair_type": 0,
                "gender_type": 0,
                "glasses_type": 0,
                "hair_color_type": 0,
                "intrash": 0,
                "lip_makeup_type": 0,
                "smile_type": 0,
            },
        }
    },
    {
        "74C3C5B5-F9EB-4527-A03F-8064B1496542": {
            "B552E117-9419-441A-B772-36F3C798C1FF": {
                "_pk": 16,
                "uuid": "B552E117-9419-441A-B772-36F3C798C1FF",
                "name": "",
                "asset_uuid": "74C3C5B5-F9EB-4527-A03F-8064B1496542",
                "_person_pk": 4,
                "center_x": 0.5952992588281631,
                "center_y": 0.49017810821533203,
                "center": (1219, 687),
                "mouth_x": 0.5881596664819962,
                "mouth_y": 0.3549293373939501,
                "mouth": (1204, 869),
                "left_eye_x": 0.5232154194375097,
                "left_eye_y": 0.6100698135934515,
                "left_eye": (1071, 525),
                "right_eye_x": 0.6608530058804294,
                "right_eye_y": 0.6057527381688228,
                "right_eye": (1353, 531),
                "size": 0.36225399374961853,
                "face_rect": [
                    (848.0519104003906, 316.0519104003906),
                    (1589.9480895996094, 1057.9480895996094),
                ],
                "mpri_reg_rect": {
                    "x": 0.4141722619533539,
                    "y": 0.2346378490549874,
                    "h": 0.36225399374961853,
                    "w": 0.5503680854593611,
                },
                "mwg_rs_area": {
                    "x": 0.5952992588281631,
                    "y": 0.509821891784668,
                    "h": 0.5503680854593611,
                    "w": 0.36225399374961853,
                },
                "roll": 0.0,
                "pitch": 0.0,
                "yaw": 0.0,
                "quality": 0.6104320287704468,
                "source_width": 2048,
                "source_height": 1348,
                "has_smile": 0,
                "left_eye_closed": 0,
                "right_eye_closed": 0,
                "manual": 0,
                "face_type": None,
                "age_type": 3,
                "eye_makeup_type": 0,
                "eye_state": 2,
                "facial_hair_type": 1,
                "gender_type": 2,
                "glasses_type": 3,
                "hair_color_type": 1,
                "intrash": 0,
                "lip_makeup_type": 0,
                "smile_type": 2,
            }
        }
    },
    {
        "52E95CFC-DD9A-4B60-9FC4-FC8EA716DF38": {
            "B0EC274C-BADD-49B8-87C6-847EA68FD9B4": {
                "_pk": 13,
                "uuid": "B0EC274C-BADD-49B8-87C6-847EA68FD9B4",
                "name": "",
                "asset_uuid": "52E95CFC-DD9A-4B60-9FC4-FC8EA716DF38",
                "_person_pk": 11,
                "center_x": 0.49487878382205963,
                "center_y": 0.4678105264902115,
                "center": (1013, 681),
                "mouth_x": 0.5038044308198595,
                "mouth_y": 0.368350300135897,
                "mouth": (1031, 808),
                "left_eye_x": 0.401402636309869,
                "left_eye_y": 0.5665164105993239,
                "left_eye": (822, 554),
                "right_eye_x": 0.5676369358480788,
                "right_eye_y": 0.6174688525820913,
                "right_eye": (1162, 489),
                "size": 0.34953396767377853,
                "face_rect": [
                    (655.0772171020508, 323.0772171020508),
                    (1370.9227828979492, 1038.9227828979492),
                ],
                "mpri_reg_rect": {
                    "x": 0.32011179998517036,
                    "y": 0.2525622993707657,
                    "h": 0.34953396767377853,
                    "w": 0.5592543482780457,
                },
                "mwg_rs_area": {
                    "x": 0.49487878382205963,
                    "y": 0.5321894735097885,
                    "h": 0.5592543482780457,
                    "w": 0.34953396767377853,
                },
                "roll": 0.0,
                "pitch": 0.0,
                "yaw": 0.0,
                "quality": 0.4167588949203491,
                "source_width": 2048,
                "source_height": 1280,
                "has_smile": 0,
                "left_eye_closed": 1,
                "right_eye_closed": 1,
                "manual": 0,
                "face_type": None,
                "age_type": 3,
                "eye_makeup_type": 0,
                "eye_state": 1,
                "facial_hair_type": 1,
                "gender_type": 2,
                "glasses_type": 3,
                "hair_color_type": 2,
                "intrash": 0,
                "lip_makeup_type": 0,
                "smile_type": 2,
            }
        }
    },
    {
        "80080A31-77A1-4984-8E51-E7466D9B9F34": {
            "F86D4A0C-8261-48E2-98A2-F23EA9476204": {
                "_pk": 22,
                "uuid": "F86D4A0C-8261-48E2-98A2-F23EA9476204",
                "name": "exif5",
                "asset_uuid": "80080A31-77A1-4984-8E51-E7466D9B9F34",
                "_person_pk": 24,
                "center_x": 0.6222684847853996,
                "center_y": 0.7361774780108254,
                "center": (540, 849),
                "mouth_x": 0.0,
                "mouth_y": 0.0,
                "mouth": (2048, 0),
                "left_eye_x": 0.0,
                "left_eye_y": 0.0,
                "left_eye": (2048, 0),
                "right_eye_x": 0.0,
                "right_eye_y": 0.0,
                "right_eye": (2048, 0),
                "size": 0.1869848668575287,
                "face_rect": [
                    (348.5274963378906, 657.5274963378906),
                    (731.4725036621094, 1040.4725036621094),
                ],
                "mpri_reg_rect": {
                    "x": 0.1703300885604102,
                    "y": 0.48199558832964184,
                    "h": 0.1869848668575287,
                    "w": 0.28054579291151555,
                },
                "mwg_rs_area": {
                    "x": 0.26382252198917455,
                    "y": 0.6222684847853996,
                    "h": 0.28054579291151555,
                    "w": 0.1869848668575287,
                },
                "roll": 0.0,
                "pitch": 0.0,
                "yaw": 0.0,
                "quality": -1.0,
                "source_width": 1365,
                "source_height": 2048,
                "has_smile": 0,
                "left_eye_closed": 0,
                "right_eye_closed": 0,
                "manual": 1,
                "face_type": None,
                "age_type": 0,
                "eye_makeup_type": 0,
                "eye_state": 0,
                "facial_hair_type": 0,
                "gender_type": 0,
                "glasses_type": 0,
                "hair_color_type": 0,
                "intrash": 0,
                "lip_makeup_type": 0,
                "smile_type": 0,
            }
        }
    },
    {
        "E2930419-BEFD-4590-BC44-03E48466459D": {
            "8729CB49-F829-401C-9D46-074D779A7F88": {
                "_pk": 8,
                "uuid": "8729CB49-F829-401C-9D46-074D779A7F88",
                "name": "Makeup",
                "asset_uuid": "E2930419-BEFD-4590-BC44-03E48466459D",
                "_person_pk": 18,
                "center_x": 0.6579082906246185,
                "center_y": 0.4387013465166092,
                "center": (710, 648),
                "mouth_x": 0.7108257118094201,
                "mouth_y": 0.3613844465998112,
                "mouth": (803, 696),
                "left_eye_x": 0.5002830154631764,
                "left_eye_y": 0.46416851825610195,
                "left_eye": (547, 707),
                "right_eye_x": 0.6879877893428137,
                "right_eye_y": 0.5751814254453071,
                "right_eye": (659, 494),
                "size": 0.47093212604522705,
                "face_rect": [
                    (438.0366972088814, 376.0366972088814),
                    (981.9633027911186, 919.9633027911186),
                ],
                "mpri_reg_rect": {
                    "x": 0.4060904176698791,
                    "y": 0.3258325904607773,
                    "h": 0.5036357459094789,
                    "w": 0.47093212604522705,
                },
                "mwg_rs_area": {
                    "x": 0.6579082906246185,
                    "y": 0.5612986534833908,
                    "h": 0.47093212604522705,
                    "w": 0.5036357459094789,
                },
                "roll": 0.5235987901687622,
                "pitch": 0.0,
                "yaw": 0.0,
                "quality": 0.6832470893859863,
                "source_width": 1080,
                "source_height": 1155,
                "has_smile": 0,
                "left_eye_closed": 0,
                "right_eye_closed": 0,
                "manual": 0,
                "face_type": None,
                "age_type": 3,
                "eye_makeup_type": 0,
                "eye_state": 2,
                "facial_hair_type": 1,
                "gender_type": 2,
                "glasses_type": 3,
                "hair_color_type": 1,
                "intrash": 0,
                "lip_makeup_type": 0,
                "smile_type": 1,
            }
        }
    },
    {
        "A2E762C9-F2A2-4806-9684-D1A78910B71E": {
            "3B2DBD1A-1A6C-4278-8BA7-CCC786523159": {
                "_pk": 18,
                "uuid": "3B2DBD1A-1A6C-4278-8BA7-CCC786523159",
                "name": "Statue",
                "asset_uuid": "A2E762C9-F2A2-4806-9684-D1A78910B71E",
                "_person_pk": 15,
                "center_x": 0.4856320488721805,
                "center_y": 0.8716400375939848,
                "center": (1337, 353),
                "mouth_x": 0.0,
                "mouth_y": 0.0,
                "mouth": (0, 2754),
                "left_eye_x": 0.0,
                "left_eye_y": 0.0,
                "left_eye": (0, 2754),
                "right_eye_x": 0.0,
                "right_eye_y": 0.0,
                "right_eye": (0, 2754),
                "size": 0.08544087409973145,
                "face_rect": [
                    (1219.3479163646698, 235.3479163646698),
                    (1454.6520836353302, 470.6520836353302),
                ],
                "mpri_reg_rect": {
                    "x": 0.44291161182231475,
                    "y": 0.08563952535614949,
                    "h": 0.08544087409973145,
                    "w": 0.08544087409973145,
                },
                "mwg_rs_area": {
                    "x": 0.4856320488721805,
                    "y": 0.12835996240601522,
                    "h": 0.08544087409973145,
                    "w": 0.08544087409973145,
                },
                "roll": 0.0,
                "pitch": 0.0,
                "yaw": 0.0,
                "quality": -1.0,
                "source_width": 2754,
                "source_height": 2754,
                "has_smile": 0,
                "left_eye_closed": 0,
                "right_eye_closed": 0,
                "manual": 1,
                "face_type": None,
                "age_type": 0,
                "eye_makeup_type": 0,
                "eye_state": 0,
                "facial_hair_type": 0,
                "gender_type": 0,
                "glasses_type": 0,
                "hair_color_type": 0,
                "intrash": 0,
                "lip_makeup_type": 0,
                "smile_type": 0,
            }
        }
    },
    {
        "94D0440B-28BD-4724-89BD-A53662F57CC6": {
            "03646A62-5D84-4425-BA83-0EE4EBA279C4": {
                "_pk": 10,
                "uuid": "03646A62-5D84-4425-BA83-0EE4EBA279C4",
                "name": "Exif",
                "asset_uuid": "94D0440B-28BD-4724-89BD-A53662F57CC6",
                "_person_pk": 16,
                "center_x": 0.5034043937921524,
                "center_y": 0.40654684603214264,
                "center": (1017, 555),
                "mouth_x": 0.49383093682306267,
                "mouth_y": 0.2808416709048345,
                "mouth": (1036, 383),
                "left_eye_x": 0.4368750899788476,
                "left_eye_y": 0.5222734803531885,
                "left_eye": (1153, 713),
                "right_eye_x": 0.5449226343292468,
                "right_eye_y": 0.5579434879607916,
                "right_eye": (931, 762),
                "size": 0.39579104888252914,
                "face_rect": [
                    (611.7099659442902, 149.70996594429016),
                    (1422.2900340557098, 960.2900340557098),
                ],
                "mpri_reg_rect": {
                    "x": 0.298700081766583,
                    "y": 0.11006547510623932,
                    "h": 0.39579104888252914,
                    "w": 0.5929627418518066,
                },
                "mwg_rs_area": {
                    "x": 0.4965956062078476,
                    "y": 0.40654684603214264,
                    "h": 0.5929627418518066,
                    "w": 0.39579104888252914,
                },
                "roll": 0.0,
                "pitch": 0.0,
                "yaw": 0.0,
                "quality": 0.6154575347900391,
                "source_width": 2048,
                "source_height": 1367,
                "has_smile": 0,
                "left_eye_closed": 0,
                "right_eye_closed": 0,
                "manual": 0,
                "face_type": None,
                "age_type": 3,
                "eye_makeup_type": 0,
                "eye_state": 2,
                "facial_hair_type": 1,
                "gender_type": 2,
                "glasses_type": 3,
                "hair_color_type": 1,
                "intrash": 0,
                "lip_makeup_type": 0,
                "smile_type": 2,
            }
        }
    },
    {
        "77BD401F-4308-47A5-BA28-3369FAAFEBE2": {
            "C4856268-8917-4DDD-AD8B-5894F4858CD0": {
                "_pk": 23,
                "uuid": "C4856268-8917-4DDD-AD8B-5894F4858CD0",
                "name": "exif4",
                "asset_uuid": "77BD401F-4308-47A5-BA28-3369FAAFEBE2",
                "_person_pk": 25,
                "center_x": 0.6141950066171988,
                "center_y": 0.7367272073748309,
                "center": (838, 1508),
                "mouth_x": 0.0,
                "mouth_y": 0.0,
                "mouth": (0, 0),
                "left_eye_x": 0.0,
                "left_eye_y": 0.0,
                "left_eye": (0, 0),
                "right_eye_x": 0.0,
                "right_eye_y": 0.0,
                "right_eye": (0, 0),
                "size": 0.18636979162693024,
                "face_rect": [
                    (647.1573333740234, 1317.1573333740234),
                    (1028.8426666259766, 1698.8426666259766),
                ],
                "mpri_reg_rect": {
                    "x": 0.47438352923553107,
                    "y": 0.6435423115613658,
                    "h": 0.2796229547633356,
                    "w": 0.18636979162693024,
                },
                "mwg_rs_area": {
                    "x": 0.6141950066171988,
                    "y": 0.7367272073748309,
                    "h": 0.18636979162693024,
                    "w": 0.2796229547633356,
                },
                "roll": 0.0,
                "pitch": 0.0,
                "yaw": 0.0,
                "quality": -1.0,
                "source_width": 1365,
                "source_height": 2048,
                "has_smile": 0,
                "left_eye_closed": 0,
                "right_eye_closed": 0,
                "manual": 1,
                "face_type": None,
                "age_type": 0,
                "eye_makeup_type": 0,
                "eye_state": 0,
                "facial_hair_type": 0,
                "gender_type": 0,
                "glasses_type": 0,
                "hair_color_type": 0,
                "intrash": 0,
                "lip_makeup_type": 0,
                "smile_type": 0,
            }
        }
    },
    {
        "26011634-7F89-47DD-AA3B-A3693708E3F9": {
            "A556C3BC-B7C5-42A4-95BB-C3EF8B016FF7": {
                "_pk": 2,
                "uuid": "A556C3BC-B7C5-42A4-95BB-C3EF8B016FF7",
                "name": "",
                "asset_uuid": "26011634-7F89-47DD-AA3B-A3693708E3F9",
                "_person_pk": 12,
                "center_x": 0.5023972690105438,
                "center_y": 0.4377516508102417,
                "center": (513, 383),
                "mouth_x": 0.5147463933231222,
                "mouth_y": 0.2578869997454092,
                "mouth": (526, 506),
                "left_eye_x": 0.38380930066924357,
                "left_eye_y": 0.5466387005792122,
                "left_eye": (392, 309),
                "right_eye_x": 0.5959029685288542,
                "right_eye_y": 0.5919662357251205,
                "right_eye": (609, 278),
                "size": 0.43259525299072266,
                "face_rect": [
                    (291.72752809524536, 161.72752809524536),
                    (734.2724719047546, 604.2724719047546),
                ],
                "mpri_reg_rect": {
                    "x": 0.2860996425151825,
                    "y": 0.2378019094467163,
                    "h": 0.43259525299072266,
                    "w": 0.648892879486084,
                },
                "mwg_rs_area": {
                    "x": 0.5023972690105438,
                    "y": 0.5622483491897583,
                    "h": 0.648892879486084,
                    "w": 0.43259525299072266,
                },
                "roll": 0.0,
                "pitch": 0.0,
                "yaw": 0.0,
                "quality": 0.491061806678772,
                "source_width": 1023,
                "source_height": 682,
                "has_smile": 0,
                "left_eye_closed": 0,
                "right_eye_closed": 0,
                "manual": 0,
                "face_type": None,
                "age_type": 5,
                "eye_makeup_type": 0,
                "eye_state": 2,
                "facial_hair_type": 2,
                "gender_type": 1,
                "glasses_type": 3,
                "hair_color_type": 1,
                "intrash": 0,
                "lip_makeup_type": 0,
                "smile_type": 1,
            }
        }
    },
    {
        "79096F62-C8E9-4652-85A0-D77C972FDFDF": {
            "61AE5DBA-DE4F-44A3-BF47-4CF34846C0C6": {
                "_pk": 37,
                "uuid": "61AE5DBA-DE4F-44A3-BF47-4CF34846C0C6",
                "name": "left4",
                "asset_uuid": "79096F62-C8E9-4652-85A0-D77C972FDFDF",
                "_person_pk": 40,
                "center_x": 0.3106900838533541,
                "center_y": 0.6720543107438582,
                "center": (636, 917),
                "mouth_x": 0.0,
                "mouth_y": 0.0,
                "mouth": (0, 0),
                "left_eye_x": 0.0,
                "left_eye_y": 0.0,
                "left_eye": (0, 0),
                "right_eye_x": 0.0,
                "right_eye_y": 0.0,
                "right_eye": (0, 0),
                "size": 0.11487732082605362,
                "face_rect": [
                    (518.3656234741211, 799.3656234741211),
                    (753.6343765258789, 1034.634376525879),
                ],
                "mpri_reg_rect": {
                    "x": 0.2532514234403273,
                    "y": 0.5858752803219689,
                    "h": 0.11487732082605362,
                    "w": 0.1723580608437786,
                },
                "mwg_rs_area": {
                    "x": 0.3106900838533541,
                    "y": 0.6720543107438582,
                    "h": 0.1723580608437786,
                    "w": 0.11487732082605362,
                },
                "roll": 0.0,
                "pitch": 0.0,
                "yaw": 0.0,
                "quality": -1.0,
                "source_width": 2048,
                "source_height": 1365,
                "has_smile": 0,
                "left_eye_closed": 0,
                "right_eye_closed": 0,
                "manual": 1,
                "face_type": None,
                "age_type": 0,
                "eye_makeup_type": 0,
                "eye_state": 0,
                "facial_hair_type": 0,
                "gender_type": 0,
                "glasses_type": 0,
                "hair_color_type": 0,
                "intrash": 0,
                "lip_makeup_type": 0,
                "smile_type": 0,
            },
            "1B9F9019-D6BF-4892-BBCA-C4DED32FDA64": {
                "_pk": 38,
                "uuid": "1B9F9019-D6BF-4892-BBCA-C4DED32FDA64",
                "name": "right4",
                "asset_uuid": "79096F62-C8E9-4652-85A0-D77C972FDFDF",
                "_person_pk": 41,
                "center_x": 0.7148559379875195,
                "center_y": 0.5797809055219351,
                "center": (1464, 791),
                "mouth_x": 0.0,
                "mouth_y": 0.0,
                "mouth": (0, 0),
                "left_eye_x": 0.0,
                "left_eye_y": 0.0,
                "left_eye": (0, 0),
                "right_eye_x": 0.0,
                "right_eye_y": 0.0,
                "right_eye": (0, 0),
                "size": 0.08438519388437271,
                "face_rect": [
                    (1377.5895614624023, 704.5895614624023),
                    (1550.4104385375977, 877.4104385375977),
                ],
                "mpri_reg_rect": {
                    "x": 0.6726633410453331,
                    "y": 0.5164765549449405,
                    "h": 0.08438519388437271,
                    "w": 0.12660870115398923,
                },
                "mwg_rs_area": {
                    "x": 0.7148559379875195,
                    "y": 0.5797809055219351,
                    "h": 0.12660870115398923,
                    "w": 0.08438519388437271,
                },
                "roll": 0.0,
                "pitch": 0.0,
                "yaw": 0.0,
                "quality": -1.0,
                "source_width": 2048,
                "source_height": 1365,
                "has_smile": 0,
                "left_eye_closed": 0,
                "right_eye_closed": 0,
                "manual": 1,
                "face_type": None,
                "age_type": 0,
                "eye_makeup_type": 0,
                "eye_state": 0,
                "facial_hair_type": 0,
                "gender_type": 0,
                "glasses_type": 0,
                "hair_color_type": 0,
                "intrash": 0,
                "lip_makeup_type": 0,
                "smile_type": 0,
            },
        }
    },
    {
        "9E7D89FF-05C0-415E-BA48-1B3AE8A8A910": {
            "DCE806B8-39A9-454A-8FA3-BAD40D9B0A66": {
                "_pk": 6,
                "uuid": "DCE806B8-39A9-454A-8FA3-BAD40D9B0A66",
                "name": "Girl Winking",
                "asset_uuid": "9E7D89FF-05C0-415E-BA48-1B3AE8A8A910",
                "_person_pk": 21,
                "center_x": 0.7959673330187798,
                "center_y": 0.5137898772954941,
                "center": (1630, 663),
                "mouth_x": 0.8051418400925123,
                "mouth_y": 0.45098027932299384,
                "mouth": (1648, 749),
                "left_eye_x": 0.755372609972766,
                "left_eye_y": 0.6016391057377022,
                "left_eye": (1547, 543),
                "right_eye_x": 0.8485378818859849,
                "right_eye_y": 0.5883882606575139,
                "right_eye": (1737, 561),
                "size": 0.22552989423274994,
                "face_rect": [
                    (1399.057388305664, 432.05738830566406),
                    (1860.942611694336, 893.9426116943359),
                ],
                "mpri_reg_rect": {
                    "x": 0.6832023859024048,
                    "y": 0.3170213961885089,
                    "h": 0.22552989423274994,
                    "w": 0.33837745303199407,
                },
                "mwg_rs_area": {
                    "x": 0.7959673330187798,
                    "y": 0.4862101227045059,
                    "h": 0.33837745303199407,
                    "w": 0.22552989423274994,
                },
                "roll": 0.0,
                "pitch": 0.0,
                "yaw": 0.0,
                "quality": 0.40995678305625916,
                "source_width": 2048,
                "source_height": 1365,
                "has_smile": 0,
                "left_eye_closed": 0,
                "right_eye_closed": 0,
                "manual": 0,
                "face_type": None,
                "age_type": 2,
                "eye_makeup_type": 0,
                "eye_state": 2,
                "facial_hair_type": 1,
                "gender_type": 1,
                "glasses_type": 3,
                "hair_color_type": 3,
                "intrash": 0,
                "lip_makeup_type": 0,
                "smile_type": 2,
            }
        }
    },
    {
        "21EF6CF1-7BA6-43CB-A6B8-597CA9C52E76": {
            "91408749-20D9-4202-8A88-B22E596256CA": {
                "_pk": 25,
                "uuid": "91408749-20D9-4202-8A88-B22E596256CA",
                "name": "exif2",
                "asset_uuid": "21EF6CF1-7BA6-43CB-A6B8-597CA9C52E76",
                "_person_pk": 27,
                "center_x": 0.6049943741418708,
                "center_y": 0.7312299137347767,
                "center": (539, 550),
                "mouth_x": 0.0,
                "mouth_y": 0.0,
                "mouth": (1365, 2048),
                "left_eye_x": 0.0,
                "left_eye_y": 0.0,
                "left_eye": (1365, 2048),
                "right_eye_x": 0.0,
                "right_eye_y": 0.0,
                "right_eye": (1365, 2048),
                "size": 0.1636117547750473,
                "face_rect": [
                    (371.46156311035156, 382.46156311035156),
                    (706.5384368896484, 717.5384368896484),
                ],
                "mpri_reg_rect": {
                    "x": 0.2722668442539911,
                    "y": 0.1869642088776996,
                    "h": 0.2454775632082761,
                    "w": 0.1636117547750473,
                },
                "mwg_rs_area": {
                    "x": 0.39500562585812915,
                    "y": 0.26877008626522325,
                    "h": 0.1636117547750473,
                    "w": 0.2454775632082761,
                },
                "roll": 0.0,
                "pitch": 0.0,
                "yaw": 0.0,
                "quality": -1.0,
                "source_width": 1365,
                "source_height": 2048,
                "has_smile": 0,
                "left_eye_closed": 0,
                "right_eye_closed": 0,
                "manual": 1,
                "face_type": None,
                "age_type": 0,
                "eye_makeup_type": 0,
                "eye_state": 0,
                "facial_hair_type": 0,
                "gender_type": 0,
                "glasses_type": 0,
                "hair_color_type": 0,
                "intrash": 0,
                "lip_makeup_type": 0,
                "smile_type": 0,
            }
        }
    },
    {
        "C3BE45BB-F9E8-46C2-88FF-EB6A8E445A31": {
            "EA76107F-FA57-41DD-A0C6-E5B0E2B8CBCC": {
                "_pk": 29,
                "uuid": "EA76107F-FA57-41DD-A0C6-E5B0E2B8CBCC",
                "name": "left0",
                "asset_uuid": "C3BE45BB-F9E8-46C2-88FF-EB6A8E445A31",
                "_person_pk": 31,
                "center_x": 0.3147730596723869,
                "center_y": 0.6831690410473562,
                "center": (644, 432),
                "mouth_x": 0.0,
                "mouth_y": 0.0,
                "mouth": (0, 1365),
                "left_eye_x": 0.0,
                "left_eye_y": 0.0,
                "left_eye": (0, 1365),
                "right_eye_x": 0.0,
                "right_eye_y": 0.0,
                "right_eye": (0, 1365),
                "size": 0.11274996399879456,
                "face_rect": [
                    (528.5440368652344, 316.5440368652344),
                    (759.4559631347656, 547.4559631347656),
                ],
                "mpri_reg_rect": {
                    "x": 0.2583980776729896,
                    "y": 0.23224783577699132,
                    "h": 0.11274996399879456,
                    "w": 0.16916624635130495,
                },
                "mwg_rs_area": {
                    "x": 0.3147730596723869,
                    "y": 0.3168309589526438,
                    "h": 0.16916624635130495,
                    "w": 0.11274996399879456,
                },
                "roll": 0.0,
                "pitch": 0.0,
                "yaw": 0.0,
                "quality": -1.0,
                "source_width": 2048,
                "source_height": 1365,
                "has_smile": 0,
                "left_eye_closed": 0,
                "right_eye_closed": 0,
                "manual": 1,
                "face_type": None,
                "age_type": 0,
                "eye_makeup_type": 0,
                "eye_state": 0,
                "facial_hair_type": 0,
                "gender_type": 0,
                "glasses_type": 0,
                "hair_color_type": 0,
                "intrash": 0,
                "lip_makeup_type": 0,
                "smile_type": 0,
            },
            "D391058C-2780-4B94-95AE-C58DECB35477": {
                "_pk": 30,
                "uuid": "D391058C-2780-4B94-95AE-C58DECB35477",
                "name": "right0",
                "asset_uuid": "C3BE45BB-F9E8-46C2-88FF-EB6A8E445A31",
                "_person_pk": 32,
                "center_x": 0.7304504680187207,
                "center_y": 0.5982010708999789,
                "center": (1495, 548),
                "mouth_x": 0.0,
                "mouth_y": 0.0,
                "mouth": (0, 1365),
                "left_eye_x": 0.0,
                "left_eye_y": 0.0,
                "left_eye": (0, 1365),
                "right_eye_x": 0.0,
                "right_eye_y": 0.0,
                "right_eye": (0, 1365),
                "size": 0.11274996399879456,
                "face_rect": [
                    (1379.5440368652344, 432.5440368652344),
                    (1610.4559631347656, 663.4559631347656),
                ],
                "mpri_reg_rect": {
                    "x": 0.6740754860193234,
                    "y": 0.31721580592436865,
                    "h": 0.11274996399879456,
                    "w": 0.16916624635130495,
                },
                "mwg_rs_area": {
                    "x": 0.7304504680187207,
                    "y": 0.40179892910002113,
                    "h": 0.16916624635130495,
                    "w": 0.11274996399879456,
                },
                "roll": 0.0,
                "pitch": 0.0,
                "yaw": 0.0,
                "quality": -1.0,
                "source_width": 2048,
                "source_height": 1365,
                "has_smile": 0,
                "left_eye_closed": 0,
                "right_eye_closed": 0,
                "manual": 1,
                "face_type": None,
                "age_type": 0,
                "eye_makeup_type": 0,
                "eye_state": 0,
                "facial_hair_type": 0,
                "gender_type": 0,
                "glasses_type": 0,
                "hair_color_type": 0,
                "intrash": 0,
                "lip_makeup_type": 0,
                "smile_type": 0,
            },
        }
    },
    {
        "B0757DA2-0D67-4991-980E-E935C4790827": {
            "D94A34C4-9F78-44B8-9730-8D72E6625CCD": {
                "_pk": 24,
                "uuid": "D94A34C4-9F78-44B8-9730-8D72E6625CCD",
                "name": "exif3",
                "asset_uuid": "B0757DA2-0D67-4991-980E-E935C4790827",
                "_person_pk": 26,
                "center_x": 0.6091659355529451,
                "center_y": 0.7419337787550745,
                "center": (533, 1519),
                "mouth_x": 0.0,
                "mouth_y": 0.0,
                "mouth": (1365, 0),
                "left_eye_x": 0.0,
                "left_eye_y": 0.0,
                "left_eye": (1365, 0),
                "right_eye_x": 0.0,
                "right_eye_y": 0.0,
                "right_eye": (1365, 0),
                "size": 0.18944519758224487,
                "face_rect": [
                    (339.00811767578125, 1325.0081176757812),
                    (726.9918823242188, 1712.9918823242188),
                ],
                "mpri_reg_rect": {
                    "x": 0.24871546933773717,
                    "y": 0.647211179963952,
                    "h": 0.2842371902186355,
                    "w": 0.18944519758224487,
                },
                "mwg_rs_area": {
                    "x": 0.39083406444705493,
                    "y": 0.7419337787550745,
                    "h": 0.18944519758224487,
                    "w": 0.2842371902186355,
                },
                "roll": 0.0,
                "pitch": 0.0,
                "yaw": 0.0,
                "quality": -1.0,
                "source_width": 1365,
                "source_height": 2048,
                "has_smile": 0,
                "left_eye_closed": 0,
                "right_eye_closed": 0,
                "manual": 1,
                "face_type": None,
                "age_type": 0,
                "eye_makeup_type": 0,
                "eye_state": 0,
                "facial_hair_type": 0,
                "gender_type": 0,
                "glasses_type": 0,
                "hair_color_type": 0,
                "intrash": 0,
                "lip_makeup_type": 0,
                "smile_type": 0,
            }
        }
    },
    {
        "75DCDF37-A924-4280-BEC7-A5EC6EFE6016": {
            "73BDD408-7465-46D7-9B10-53486E235059": {
                "_pk": 31,
                "uuid": "73BDD408-7465-46D7-9B10-53486E235059",
                "name": "left1",
                "asset_uuid": "75DCDF37-A924-4280-BEC7-A5EC6EFE6016",
                "_person_pk": 33,
                "center_x": 0.3119149765990639,
                "center_y": 0.6578240272468041,
                "center": (638, 467),
                "mouth_x": 0.0,
                "mouth_y": 0.0,
                "mouth": (0, 1365),
                "left_eye_x": 0.0,
                "left_eye_y": 0.0,
                "left_eye": (0, 1365),
                "right_eye_x": 0.0,
                "right_eye_y": 0.0,
                "right_eye": (0, 1365),
                "size": 0.0872216671705246,
                "face_rect": [
                    (548.6850128173828, 377.6850128173828),
                    (727.3149871826172, 556.3149871826172),
                ],
                "mpri_reg_rect": {
                    "x": 0.2683041430138016,
                    "y": 0.2767437477109855,
                    "h": 0.0872216671705246,
                    "w": 0.1308644500844208,
                },
                "mwg_rs_area": {
                    "x": 0.3119149765990639,
                    "y": 0.3421759727531959,
                    "h": 0.1308644500844208,
                    "w": 0.0872216671705246,
                },
                "roll": 0.0,
                "pitch": 0.0,
                "yaw": 0.0,
                "quality": -1.0,
                "source_width": 2048,
                "source_height": 1365,
                "has_smile": 0,
                "left_eye_closed": 0,
                "right_eye_closed": 0,
                "manual": 1,
                "face_type": None,
                "age_type": 0,
                "eye_makeup_type": 0,
                "eye_state": 0,
                "facial_hair_type": 0,
                "gender_type": 0,
                "glasses_type": 0,
                "hair_color_type": 0,
                "intrash": 0,
                "lip_makeup_type": 0,
                "smile_type": 0,
            },
            "8D9E2AC9-43C8-44C1-B0E9-FAF39B4464B1": {
                "_pk": 32,
                "uuid": "8D9E2AC9-43C8-44C1-B0E9-FAF39B4464B1",
                "name": "right1",
                "asset_uuid": "75DCDF37-A924-4280-BEC7-A5EC6EFE6016",
                "_person_pk": 35,
                "center_x": 0.7187439060062402,
                "center_y": 0.5911242163972272,
                "center": (1471, 558),
                "mouth_x": 0.0,
                "mouth_y": 0.0,
                "mouth": (0, 1365),
                "left_eye_x": 0.0,
                "left_eye_y": 0.0,
                "left_eye": (0, 1365),
                "right_eye_x": 0.0,
                "right_eye_y": 0.0,
                "right_eye": (0, 1365),
                "size": 0.09998581558465958,
                "face_rect": [
                    (1368.6145248413086, 455.6145248413086),
                    (1573.3854751586914, 660.3854751586914),
                ],
                "mpri_reg_rect": {
                    "x": 0.6687509982139104,
                    "y": 0.3338681094938413,
                    "h": 0.09998581558465958,
                    "w": 0.15001534821786286,
                },
                "mwg_rs_area": {
                    "x": 0.7187439060062402,
                    "y": 0.40887578360277277,
                    "h": 0.15001534821786286,
                    "w": 0.09998581558465958,
                },
                "roll": 0.0,
                "pitch": 0.0,
                "yaw": 0.0,
                "quality": -1.0,
                "source_width": 2048,
                "source_height": 1365,
                "has_smile": 0,
                "left_eye_closed": 0,
                "right_eye_closed": 0,
                "manual": 1,
                "face_type": None,
                "age_type": 0,
                "eye_makeup_type": 0,
                "eye_state": 0,
                "facial_hair_type": 0,
                "gender_type": 0,
                "glasses_type": 0,
                "hair_color_type": 0,
                "intrash": 0,
                "lip_makeup_type": 0,
                "smile_type": 0,
            },
        }
    },
    {
        "C36C837E-338D-40D5-B151-0AE3171DEF52": {
            "913589EA-415D-4EEC-B11D-701E94F380F2": {
                "_pk": 1,
                "uuid": "913589EA-415D-4EEC-B11D-701E94F380F2",
                "name": "Glasses",
                "asset_uuid": "C36C837E-338D-40D5-B151-0AE3171DEF52",
                "_person_pk": 20,
                "center_x": 0.5327368080615997,
                "center_y": 0.5844670832157135,
                "center": (1091, 569),
                "mouth_x": 0.4490566604817152,
                "mouth_y": 0.4718863689543422,
                "mouth": (864, 617),
                "left_eye_x": 0.4541499845274388,
                "left_eye_y": 0.8410009129315803,
                "left_eye": (1127, 183),
                "right_eye_x": 0.6545159121780388,
                "right_eye_y": 0.7686483517304801,
                "right_eye": (1432, 475),
                "size": 0.5316190338344313,
                "face_rect": [
                    (546.6221093535423, 24.622109353542328),
                    (1635.3778906464577, 1113.3778906464577),
                ],
                "mpri_reg_rect": {
                    "x": 0.26692729114438407,
                    "y": 0.01846662163734436,
                    "h": 0.5316190338344313,
                    "w": 0.7941325902938843,
                },
                "mwg_rs_area": {
                    "x": 0.5327368080615997,
                    "y": 0.4155329167842865,
                    "h": 0.7941325902938843,
                    "w": 0.5316190338344313,
                },
                "roll": -0.5235987901687622,
                "pitch": 0.0,
                "yaw": 0.0,
                "quality": 0.33670586347579956,
                "source_width": 2048,
                "source_height": 1371,
                "has_smile": 0,
                "left_eye_closed": 0,
                "right_eye_closed": 0,
                "manual": 0,
                "face_type": None,
                "age_type": 5,
                "eye_makeup_type": 0,
                "eye_state": 2,
                "facial_hair_type": 1,
                "gender_type": 2,
                "glasses_type": 1,
                "hair_color_type": 3,
                "intrash": 0,
                "lip_makeup_type": 0,
                "smile_type": 1,
            }
        }
    },
    {
        "5E461935-2FE5-4762-80D3-FCF70739FFA0": {
            "878F66D3-0E53-47C7-BE17-BAC1212EEF47": {
                "_pk": 7,
                "uuid": "878F66D3-0E53-47C7-BE17-BAC1212EEF47",
                "name": "Exif",
                "asset_uuid": "5E461935-2FE5-4762-80D3-FCF70739FFA0",
                "_person_pk": 16,
                "center_x": 0.5060971826314926,
                "center_y": 0.4065530300140381,
                "center": (811, 1011),
                "mouth_x": 0.4947084969874238,
                "mouth_y": 0.28146992416738925,
                "mouth": (982, 1034),
                "left_eye_x": 0.4379364977447421,
                "left_eye_y": 0.5229665160904489,
                "left_eye": (652, 1151),
                "right_eye_x": 0.5447459726413946,
                "right_eye_y": 0.5572845329942382,
                "right_eye": (605, 932),
                "size": 0.3970904248999432,
                "face_rect": [
                    (404.3794049024582, 604.3794049024582),
                    (1217.6205950975418, 1417.6205950975418),
                ],
                "mpri_reg_rect": {
                    "x": 0.29599225521087646,
                    "y": 0.2953576049185358,
                    "h": 0.5949094295501709,
                    "w": 0.3970904248999432,
                },
                "mwg_rs_area": {
                    "x": 0.5934469699859619,
                    "y": 0.4939028173685074,
                    "h": 0.3970904248999432,
                    "w": 0.5949094295501709,
                },
                "roll": 0.0,
                "pitch": 0.0,
                "yaw": 0.0,
                "quality": 0.6108523607254028,
                "source_width": 2048,
                "source_height": 1367,
                "has_smile": 0,
                "left_eye_closed": 0,
                "right_eye_closed": 0,
                "manual": 0,
                "face_type": None,
                "age_type": 3,
                "eye_makeup_type": 0,
                "eye_state": 2,
                "facial_hair_type": 1,
                "gender_type": 2,
                "glasses_type": 3,
                "hair_color_type": 1,
                "intrash": 0,
                "lip_makeup_type": 0,
                "smile_type": 2,
            }
        }
    },
    {
        "11639AAB-F5C3-46F8-9058-9C19AD726D00": {
            "B4308009-CC51-4ED1-8A93-6F443BC21A27": {
                "_pk": 19,
                "uuid": "B4308009-CC51-4ED1-8A93-6F443BC21A27",
                "name": "exif7",
                "asset_uuid": "11639AAB-F5C3-46F8-9058-9C19AD726D00",
                "_person_pk": 22,
                "center_x": 0.605224365170238,
                "center_y": 0.7358444688768608,
                "center": (1507, 538),
                "mouth_x": 0.0,
                "mouth_y": 0.0,
                "mouth": (0, 1365),
                "left_eye_x": 0.0,
                "left_eye_y": 0.0,
                "left_eye": (0, 1365),
                "right_eye_x": 0.0,
                "right_eye_y": 0.0,
                "right_eye": (0, 1365),
                "size": 0.17468322813510895,
                "face_rect": [
                    (1328.1243743896484, 359.12437438964844),
                    (1685.8756256103516, 716.8756256103516),
                ],
                "mpri_reg_rect": {
                    "x": 0.6485028548093064,
                    "y": 0.2637312204632041,
                    "h": 0.17468322813510895,
                    "w": 0.26208882873311584,
                },
                "mwg_rs_area": {
                    "x": 0.7358444688768608,
                    "y": 0.39477563482976197,
                    "h": 0.26208882873311584,
                    "w": 0.17468322813510895,
                },
                "roll": 0.0,
                "pitch": 0.0,
                "yaw": 0.0,
                "quality": -1.0,
                "source_width": 1365,
                "source_height": 2048,
                "has_smile": 0,
                "left_eye_closed": 0,
                "right_eye_closed": 0,
                "manual": 1,
                "face_type": None,
                "age_type": 0,
                "eye_makeup_type": 0,
                "eye_state": 0,
                "facial_hair_type": 0,
                "gender_type": 0,
                "glasses_type": 0,
                "hair_color_type": 0,
                "intrash": 0,
                "lip_makeup_type": 0,
                "smile_type": 0,
            }
        }
    },
    {
        "B507D754-0C5D-4CDF-BAE4-2257292CA28A": {
            "1524B3BF-21A4-476F-930E-87445AE6AB02": {
                "_pk": 39,
                "uuid": "1524B3BF-21A4-476F-930E-87445AE6AB02",
                "name": "left5",
                "asset_uuid": "B507D754-0C5D-4CDF-BAE4-2257292CA28A",
                "_person_pk": 42,
                "center_x": 0.3117260627925117,
                "center_y": 0.6753607287148629,
                "center": (443, 638),
                "mouth_x": 0.0,
                "mouth_y": 0.0,
                "mouth": (1365, 0),
                "left_eye_x": 0.0,
                "left_eye_y": 0.0,
                "left_eye": (1365, 0),
                "right_eye_x": 0.0,
                "right_eye_y": 0.0,
                "right_eye": (1365, 0),
                "size": 0.10140405595302582,
                "face_rect": [
                    (339.16224670410156, 534.1622467041016),
                    (546.8377532958984, 741.8377532958984),
                ],
                "mpri_reg_rect": {
                    "x": 0.2485676571489478,
                    "y": 0.2610240348159988,
                    "h": 0.15214322827237867,
                    "w": 0.10140405595302582,
                },
                "mwg_rs_area": {
                    "x": 0.32463927128513714,
                    "y": 0.3117260627925117,
                    "h": 0.10140405595302582,
                    "w": 0.15214322827237867,
                },
                "roll": 0.0,
                "pitch": 0.0,
                "yaw": 0.0,
                "quality": -1.0,
                "source_width": 2048,
                "source_height": 1365,
                "has_smile": 0,
                "left_eye_closed": 0,
                "right_eye_closed": 0,
                "manual": 1,
                "face_type": None,
                "age_type": 0,
                "eye_makeup_type": 0,
                "eye_state": 0,
                "facial_hair_type": 0,
                "gender_type": 0,
                "glasses_type": 0,
                "hair_color_type": 0,
                "intrash": 0,
                "lip_makeup_type": 0,
                "smile_type": 0,
            },
            "F2F5CAAD-934C-4FF2-9393-119F9DDAF42F": {
                "_pk": 40,
                "uuid": "F2F5CAAD-934C-4FF2-9393-119F9DDAF42F",
                "name": "right5",
                "asset_uuid": "B507D754-0C5D-4CDF-BAE4-2257292CA28A",
                "_person_pk": 43,
                "center_x": 0.7180004387675506,
                "center_y": 0.581871274850994,
                "center": (570, 1470),
                "mouth_x": 0.0,
                "mouth_y": 0.0,
                "mouth": (1365, 0),
                "left_eye_x": 0.0,
                "left_eye_y": 0.0,
                "left_eye": (1365, 0),
                "right_eye_x": 0.0,
                "right_eye_y": 0.0,
                "right_eye": (1365, 0),
                "size": 0.08793079107999802,
                "face_rect": [
                    (479.95886993408203, 1379.958869934082),
                    (660.041130065918, 1560.041130065918),
                ],
                "mpri_reg_rect": {
                    "x": 0.35216452729851666,
                    "y": 0.6740350432275516,
                    "h": 0.1319283957009787,
                    "w": 0.08793079107999802,
                },
                "mwg_rs_area": {
                    "x": 0.418128725149006,
                    "y": 0.7180004387675506,
                    "h": 0.08793079107999802,
                    "w": 0.1319283957009787,
                },
                "roll": 0.0,
                "pitch": 0.0,
                "yaw": 0.0,
                "quality": -1.0,
                "source_width": 2048,
                "source_height": 1365,
                "has_smile": 0,
                "left_eye_closed": 0,
                "right_eye_closed": 0,
                "manual": 1,
                "face_type": None,
                "age_type": 0,
                "eye_makeup_type": 0,
                "eye_state": 0,
                "facial_hair_type": 0,
                "gender_type": 0,
                "glasses_type": 0,
                "hair_color_type": 0,
                "intrash": 0,
                "lip_makeup_type": 0,
                "smile_type": 0,
            },
        }
    },
    {
        "3609084A-8A63-429D-A122-41F147F6D1BB": {
            "0164751A-5827-43D8-ACE1-E901694A46B2": {
                "_pk": 27,
                "uuid": "0164751A-5827-43D8-ACE1-E901694A46B2",
                "name": "exif0",
                "asset_uuid": "3609084A-8A63-429D-A122-41F147F6D1BB",
                "_person_pk": 29,
                "center_x": 0.6116175209544628,
                "center_y": 0.7398564360622464,
                "center": (834, 532),
                "mouth_x": 0.0,
                "mouth_y": 0.0,
                "mouth": (0, 2048),
                "left_eye_x": 0.0,
                "left_eye_y": 0.0,
                "left_eye": (0, 2048),
                "right_eye_x": 0.0,
                "right_eye_y": 0.0,
                "right_eye": (0, 2048),
                "size": 0.17837372422218323,
                "face_rect": [
                    (651.3453063964844, 349.3453063964844),
                    (1016.6546936035156, 714.6546936035156),
                ],
                "mpri_reg_rect": {
                    "x": 0.4778045586075649,
                    "y": 0.170956701826662,
                    "h": 0.2676259246937958,
                    "w": 0.17837372422218323,
                },
                "mwg_rs_area": {
                    "x": 0.6116175209544628,
                    "y": 0.2601435639377536,
                    "h": 0.17837372422218323,
                    "w": 0.2676259246937958,
                },
                "roll": 0.0,
                "pitch": 0.0,
                "yaw": 0.0,
                "quality": -1.0,
                "source_width": 1365,
                "source_height": 2048,
                "has_smile": 0,
                "left_eye_closed": 0,
                "right_eye_closed": 0,
                "manual": 1,
                "face_type": None,
                "age_type": 0,
                "eye_makeup_type": 0,
                "eye_state": 0,
                "facial_hair_type": 0,
                "gender_type": 0,
                "glasses_type": 0,
                "hair_color_type": 0,
                "intrash": 0,
                "lip_makeup_type": 0,
                "smile_type": 0,
            }
        }
    },
    {
        "A478D042-FA26-4863-8E6F-EE749F4710E5": {
            "072894ED-0B0F-4711-8D7B-F6F4991C8E53": {
                "_pk": 41,
                "uuid": "072894ED-0B0F-4711-8D7B-F6F4991C8E53",
                "name": "left6",
                "asset_uuid": "A478D042-FA26-4863-8E6F-EE749F4710E5",
                "_person_pk": 44,
                "center_x": 0.31069617784711384,
                "center_y": 0.6640231323538656,
                "center": (458, 1411),
                "mouth_x": 0.0,
                "mouth_y": 0.0,
                "mouth": (1365, 2048),
                "left_eye_x": 0.0,
                "left_eye_y": 0.0,
                "left_eye": (1365, 2048),
                "right_eye_x": 0.0,
                "right_eye_y": 0.0,
                "right_eye": (1365, 2048),
                "size": 0.09856758266687393,
                "face_rect": [
                    (357.0667953491211, 1310.066795349121),
                    (558.9332046508789, 1511.933204650879),
                ],
                "mpri_reg_rect": {
                    "x": 0.2620331279751609,
                    "y": 0.6400200308194492,
                    "h": 0.14788747934194713,
                    "w": 0.09856758266687393,
                },
                "mwg_rs_area": {
                    "x": 0.33597686764613444,
                    "y": 0.6893038221528862,
                    "h": 0.09856758266687393,
                    "w": 0.14788747934194713,
                },
                "roll": 0.0,
                "pitch": 0.0,
                "yaw": 0.0,
                "quality": -1.0,
                "source_width": 2048,
                "source_height": 1365,
                "has_smile": 0,
                "left_eye_closed": 0,
                "right_eye_closed": 0,
                "manual": 1,
                "face_type": None,
                "age_type": 0,
                "eye_makeup_type": 0,
                "eye_state": 0,
                "facial_hair_type": 0,
                "gender_type": 0,
                "glasses_type": 0,
                "hair_color_type": 0,
                "intrash": 0,
                "lip_makeup_type": 0,
                "smile_type": 0,
            },
            "AAE996DF-2BAF-4945-A6F2-442DA1986F69": {
                "_pk": 42,
                "uuid": "AAE996DF-2BAF-4945-A6F2-442DA1986F69",
                "name": "right6",
                "asset_uuid": "A478D042-FA26-4863-8E6F-EE749F4710E5",
                "_person_pk": 45,
                "center_x": 0.7150996977379095,
                "center_y": 0.5716582949032247,
                "center": (584, 583),
                "mouth_x": 0.0,
                "mouth_y": 0.0,
                "mouth": (1365, 2048),
                "left_eye_x": 0.0,
                "left_eye_y": 0.0,
                "left_eye": (1365, 2048),
                "right_eye_x": 0.0,
                "right_eye_y": 0.0,
                "right_eye": (1365, 2048),
                "size": 0.09360374510288239,
                "face_rect": [
                    (488.14976501464844, 487.14976501464844),
                    (679.8502349853516, 678.8502349853516),
                ],
                "mpri_reg_rect": {
                    "x": 0.35812175272655433,
                    "y": 0.23809842971064932,
                    "h": 0.14043990474044185,
                    "w": 0.09360374510288239,
                },
                "mwg_rs_area": {
                    "x": 0.42834170509677527,
                    "y": 0.2849003022620905,
                    "h": 0.09360374510288239,
                    "w": 0.14043990474044185,
                },
                "roll": 0.0,
                "pitch": 0.0,
                "yaw": 0.0,
                "quality": -1.0,
                "source_width": 2048,
                "source_height": 1365,
                "has_smile": 0,
                "left_eye_closed": 0,
                "right_eye_closed": 0,
                "manual": 1,
                "face_type": None,
                "age_type": 0,
                "eye_makeup_type": 0,
                "eye_state": 0,
                "facial_hair_type": 0,
                "gender_type": 0,
                "glasses_type": 0,
                "hair_color_type": 0,
                "intrash": 0,
                "lip_makeup_type": 0,
                "smile_type": 0,
            },
        }
    },
    {
        "4736ED4D-B3DC-46EB-93F0-6481674753B1": {
            "B1D0CBD2-4B16-487F-8555-6EEA65EEE257": {
                "_pk": 20,
                "uuid": "B1D0CBD2-4B16-487F-8555-6EEA65EEE257",
                "name": "exif6",
                "asset_uuid": "4736ED4D-B3DC-46EB-93F0-6481674753B1",
                "_person_pk": 23,
                "center_x": 0.6203482579666613,
                "center_y": 0.7382918217185386,
                "center": (535, 518),
                "mouth_x": 0.0,
                "mouth_y": 0.0,
                "mouth": (2048, 1365),
                "left_eye_x": 0.0,
                "left_eye_y": 0.0,
                "left_eye": (2048, 1365),
                "right_eye_x": 0.0,
                "right_eye_y": 0.0,
                "right_eye": (2048, 1365),
                "size": 0.17714355885982513,
                "face_rect": [
                    (353.60499572753906, 336.60499572753906),
                    (716.3950042724609, 699.3950042724609),
                ],
                "mpri_reg_rect": {
                    "x": 0.17313639885154886,
                    "y": 0.24676162901322082,
                    "h": 0.17714355885982513,
                    "w": 0.2657802260402358,
                },
                "mwg_rs_area": {
                    "x": 0.2617081782814614,
                    "y": 0.37965174203333873,
                    "h": 0.2657802260402358,
                    "w": 0.17714355885982513,
                },
                "roll": 0.0,
                "pitch": 0.0,
                "yaw": 0.0,
                "quality": -1.0,
                "source_width": 1365,
                "source_height": 2048,
                "has_smile": 0,
                "left_eye_closed": 0,
                "right_eye_closed": 0,
                "manual": 1,
                "face_type": None,
                "age_type": 0,
                "eye_makeup_type": 0,
                "eye_state": 0,
                "facial_hair_type": 0,
                "gender_type": 0,
                "glasses_type": 0,
                "hair_color_type": 0,
                "intrash": 0,
                "lip_makeup_type": 0,
                "smile_type": 0,
            }
        }
    },
    {
        "4BE91165-2DA2-438C-A768-C332BB3827B1": {
            "D2A1A019-9CAA-4D41-89C0-7B03E7EC12E3": {
                "_pk": 43,
                "uuid": "D2A1A019-9CAA-4D41-89C0-7B03E7EC12E3",
                "name": "left7",
                "asset_uuid": "4BE91165-2DA2-438C-A768-C332BB3827B1",
                "_person_pk": 46,
                "center_x": 0.31374317472698904,
                "center_y": 0.6682598732520728,
                "center": (912, 1405),
                "mouth_x": 0.0,
                "mouth_y": 0.0,
                "mouth": (0, 2048),
                "left_eye_x": 0.0,
                "left_eye_y": 0.0,
                "left_eye": (0, 2048),
                "right_eye_x": 0.0,
                "right_eye_y": 0.0,
                "right_eye": (0, 2048),
                "size": 0.11700467765331268,
                "face_rect": [
                    (792.1872100830078, 1285.1872100830078),
                    (1031.8127899169922, 1524.8127899169922),
                ],
                "mpri_reg_rect": {
                    "x": 0.5804849355839466,
                    "y": 0.6277544864463547,
                    "h": 0.1755498753362523,
                    "w": 0.11700467765331268,
                },
                "mwg_rs_area": {
                    "x": 0.6682598732520728,
                    "y": 0.686256825273011,
                    "h": 0.11700467765331268,
                    "w": 0.1755498753362523,
                },
                "roll": 0.0,
                "pitch": 0.0,
                "yaw": 0.0,
                "quality": -1.0,
                "source_width": 2048,
                "source_height": 1365,
                "has_smile": 0,
                "left_eye_closed": 0,
                "right_eye_closed": 0,
                "manual": 1,
                "face_type": None,
                "age_type": 0,
                "eye_makeup_type": 0,
                "eye_state": 0,
                "facial_hair_type": 0,
                "gender_type": 0,
                "glasses_type": 0,
                "hair_color_type": 0,
                "intrash": 0,
                "lip_makeup_type": 0,
                "smile_type": 0,
            },
            "881A2FBC-0B54-4946-9AE5-EA872DDA7B3A": {
                "_pk": 44,
                "uuid": "881A2FBC-0B54-4946-9AE5-EA872DDA7B3A",
                "name": "right7",
                "asset_uuid": "4BE91165-2DA2-438C-A768-C332BB3827B1",
                "_person_pk": 47,
                "center_x": 0.7053858716848673,
                "center_y": 0.5853674146965878,
                "center": (799, 603),
                "mouth_x": 0.0,
                "mouth_y": 0.0,
                "mouth": (0, 2048),
                "left_eye_x": 0.0,
                "left_eye_y": 0.0,
                "left_eye": (0, 2048),
                "right_eye_x": 0.0,
                "right_eye_y": 0.0,
                "right_eye": (0, 2048),
                "size": 0.08863990753889084,
                "face_rect": [
                    (708.2327346801758, 512.2327346801758),
                    (889.7672653198242, 693.7672653198242),
                ],
                "mpri_reg_rect": {
                    "x": 0.5188712496271195,
                    "y": 0.25029417454568725,
                    "h": 0.13299233013893658,
                    "w": 0.08863990753889084,
                },
                "mwg_rs_area": {
                    "x": 0.5853674146965878,
                    "y": 0.2946141283151327,
                    "h": 0.08863990753889084,
                    "w": 0.13299233013893658,
                },
                "roll": 0.0,
                "pitch": 0.0,
                "yaw": 0.0,
                "quality": -1.0,
                "source_width": 2048,
                "source_height": 1365,
                "has_smile": 0,
                "left_eye_closed": 0,
                "right_eye_closed": 0,
                "manual": 1,
                "face_type": None,
                "age_type": 0,
                "eye_makeup_type": 0,
                "eye_state": 0,
                "facial_hair_type": 0,
                "gender_type": 0,
                "glasses_type": 0,
                "hair_color_type": 0,
                "intrash": 0,
                "lip_makeup_type": 0,
                "smile_type": 0,
            },
        }
    },
    {
        "399592DC-B764-4489-929A-4CD820E374C1": {
            "5693923B-449A-4B8D-8E32-20748FB67E46": {
                "_pk": 35,
                "uuid": "5693923B-449A-4B8D-8E32-20748FB67E46",
                "name": "left3",
                "asset_uuid": "399592DC-B764-4489-929A-4CD820E374C1",
                "_person_pk": 38,
                "center_x": 0.31382849063962553,
                "center_y": 0.669613070237095,
                "center": (1405, 914),
                "mouth_x": 0.0,
                "mouth_y": 0.0,
                "mouth": (2048, 0),
                "left_eye_x": 0.0,
                "left_eye_y": 0.0,
                "left_eye": (2048, 0),
                "right_eye_x": 0.0,
                "right_eye_y": 0.0,
                "right_eye": (2048, 0),
                "size": 0.09218550473451614,
                "face_rect": [
                    (1310.6020431518555, 819.6020431518555),
                    (1499.3979568481445, 1008.3979568481445),
                ],
                "mpri_reg_rect": {
                    "x": 0.6400787569931163,
                    "y": 0.6004570578941321,
                    "h": 0.09218550473451614,
                    "w": 0.13831202468592604,
                },
                "mwg_rs_area": {
                    "x": 0.6861715093603744,
                    "y": 0.669613070237095,
                    "h": 0.13831202468592604,
                    "w": 0.09218550473451614,
                },
                "roll": 0.0,
                "pitch": 0.0,
                "yaw": 0.0,
                "quality": -1.0,
                "source_width": 2048,
                "source_height": 1365,
                "has_smile": 0,
                "left_eye_closed": 0,
                "right_eye_closed": 0,
                "manual": 1,
                "face_type": None,
                "age_type": 0,
                "eye_makeup_type": 0,
                "eye_state": 0,
                "facial_hair_type": 0,
                "gender_type": 0,
                "glasses_type": 0,
                "hair_color_type": 0,
                "intrash": 0,
                "lip_makeup_type": 0,
                "smile_type": 0,
            },
            "E2D82CB4-E3FD-4C91-B74E-AB52D35C3E3E": {
                "_pk": 36,
                "uuid": "E2D82CB4-E3FD-4C91-B74E-AB52D35C3E3E",
                "name": "right3",
                "asset_uuid": "399592DC-B764-4489-929A-4CD820E374C1",
                "_person_pk": 39,
                "center_x": 0.7172265015600623,
                "center_y": 0.582149000245724,
                "center": (579, 794),
                "mouth_x": 0.0,
                "mouth_y": 0.0,
                "mouth": (2048, 0),
                "left_eye_x": 0.0,
                "left_eye_y": 0.0,
                "left_eye": (2048, 0),
                "right_eye_x": 0.0,
                "right_eye_y": 0.0,
                "right_eye": (2048, 0),
                "size": 0.09927669912576675,
                "face_rect": [
                    (477.34066009521484, 692.3406600952148),
                    (680.6593399047852, 895.6593399047852),
                ],
                "mpri_reg_rect": {
                    "x": 0.23313514887705433,
                    "y": 0.5076732933557715,
                    "h": 0.09927669912576675,
                    "w": 0.14895141377990498,
                },
                "mwg_rs_area": {
                    "x": 0.2827734984399377,
                    "y": 0.582149000245724,
                    "h": 0.14895141377990498,
                    "w": 0.09927669912576675,
                },
                "roll": 0.0,
                "pitch": 0.0,
                "yaw": 0.0,
                "quality": -1.0,
                "source_width": 2048,
                "source_height": 1365,
                "has_smile": 0,
                "left_eye_closed": 0,
                "right_eye_closed": 0,
                "manual": 1,
                "face_type": None,
                "age_type": 0,
                "eye_makeup_type": 0,
                "eye_state": 0,
                "facial_hair_type": 0,
                "gender_type": 0,
                "glasses_type": 0,
                "hair_color_type": 0,
                "intrash": 0,
                "lip_makeup_type": 0,
                "smile_type": 0,
            },
        }
    },
    {
        "74A8D2AD-4A95-402C-AB41-8948B6268DDE": {
            "3564F47E-BE04-4EF2-9409-7F0AFC3C6C90": {
                "_pk": 12,
                "uuid": "3564F47E-BE04-4EF2-9409-7F0AFC3C6C90",
                "name": "",
                "asset_uuid": "74A8D2AD-4A95-402C-AB41-8948B6268DDE",
                "_person_pk": 9,
                "center_x": 0.4150405116379261,
                "center_y": 0.3804657310247421,
                "center": (498, 991),
                "mouth_x": 0.35514891692551487,
                "mouth_y": 0.28526406607189375,
                "mouth": (426, 1143),
                "left_eye_x": 0.24532392920940715,
                "left_eye_y": 0.5437179133602399,
                "left_eye": (294, 730),
                "right_eye_x": 0.5664884610123178,
                "right_eye_y": 0.5198140024518239,
                "right_eye": (679, 768),
                "size": 0.5623092949390411,
                "face_rect": [
                    (48.15256404876709, 541.1525640487671),
                    (947.8474359512329, 1440.847435951233),
                ],
                "mpri_reg_rect": {
                    "x": 0.04016764834523201,
                    "y": 0.3383796215057373,
                    "h": 0.7497457265853882,
                    "w": 0.5623092949390411,
                },
                "mwg_rs_area": {
                    "x": 0.4150405116379261,
                    "y": 0.6195342689752579,
                    "h": 0.5623092949390411,
                    "w": 0.7497457265853882,
                },
                "roll": 0.0,
                "pitch": 0.0,
                "yaw": 0.0,
                "quality": 0.5376036167144775,
                "source_width": 1200,
                "source_height": 1600,
                "has_smile": 0,
                "left_eye_closed": 0,
                "right_eye_closed": 0,
                "manual": 0,
                "face_type": None,
                "age_type": 3,
                "eye_makeup_type": 0,
                "eye_state": 2,
                "facial_hair_type": 1,
                "gender_type": 1,
                "glasses_type": 3,
                "hair_color_type": 5,
                "intrash": 0,
                "lip_makeup_type": 0,
                "smile_type": 2,
            }
        }
    },
    {
        "D615DA33-90CD-4F69-A216-496F3D983539": {
            "901900AD-DBA2-433F-B7B1-CA151C7128BC": {
                "_pk": 15,
                "uuid": "901900AD-DBA2-433F-B7B1-CA151C7128BC",
                "name": "",
                "asset_uuid": "D615DA33-90CD-4F69-A216-496F3D983539",
                "_person_pk": 13,
                "center_x": 0.41722412779927254,
                "center_y": 0.6922222226858139,
                "center": (406, 200),
                "mouth_x": 0.42577595307495686,
                "mouth_y": 0.6447541338080145,
                "mouth": (415, 230),
                "left_eye_x": 0.38865975022355026,
                "left_eye_y": 0.7286542254184032,
                "left_eye": (378, 176),
                "right_eye_x": 0.4346261919298051,
                "right_eye_y": 0.741291684812657,
                "right_eye": (423, 168),
                "size": 0.12307403484980266,
                "face_rect": [
                    (346.0014080107212, 140.0014080107212),
                    (465.9985919892788, 259.9985919892788),
                ],
                "mpri_reg_rect": {
                    "x": 0.35568711037437123,
                    "y": 0.2154722511768341,
                    "h": 0.12307403484980266,
                    "w": 0.18461105227470398,
                },
                "mwg_rs_area": {
                    "x": 0.41722412779927254,
                    "y": 0.3077777773141861,
                    "h": 0.18461105227470398,
                    "w": 0.12307403484980266,
                },
                "roll": 0.0,
                "pitch": 0.0,
                "yaw": 0.0,
                "quality": 0.45529818534851074,
                "source_width": 975,
                "source_height": 650,
                "has_smile": 0,
                "left_eye_closed": 0,
                "right_eye_closed": 0,
                "manual": 0,
                "face_type": None,
                "age_type": 5,
                "eye_makeup_type": 0,
                "eye_state": 2,
                "facial_hair_type": 3,
                "gender_type": 1,
                "glasses_type": 3,
                "hair_color_type": 1,
                "intrash": 0,
                "lip_makeup_type": 0,
                "smile_type": 1,
            }
        }
    },
    {
        "C547648F-B778-43B5-B12B-4338B7377D09": {
            "81D77670-997D-4EFB-97DF-1CD355C00824": {
                "_pk": 33,
                "uuid": "81D77670-997D-4EFB-97DF-1CD355C00824",
                "name": "left2",
                "asset_uuid": "C547648F-B778-43B5-B12B-4338B7377D09",
                "_person_pk": 36,
                "center_x": 0.3128778276131045,
                "center_y": 0.6626699353688433,
                "center": (1407, 460),
                "mouth_x": 0.0,
                "mouth_y": 0.0,
                "mouth": (2048, 1365),
                "left_eye_x": 0.0,
                "left_eye_y": 0.0,
                "left_eye": (2048, 1365),
                "right_eye_x": 0.0,
                "right_eye_y": 0.0,
                "right_eye": (2048, 1365),
                "size": 0.07942135632038116,
                "face_rect": [
                    (1325.6725311279297, 378.6725311279297),
                    (1488.3274688720703, 541.3274688720703),
                ],
                "mpri_reg_rect": {
                    "x": 0.6474114942267049,
                    "y": 0.27774950135491466,
                    "h": 0.07942135632038116,
                    "w": 0.11916112655248397,
                },
                "mwg_rs_area": {
                    "x": 0.6871221723868954,
                    "y": 0.33733006463115667,
                    "h": 0.11916112655248397,
                    "w": 0.07942135632038116,
                },
                "roll": 0.0,
                "pitch": 0.0,
                "yaw": 0.0,
                "quality": -1.0,
                "source_width": 2048,
                "source_height": 1365,
                "has_smile": 0,
                "left_eye_closed": 0,
                "right_eye_closed": 0,
                "manual": 1,
                "face_type": None,
                "age_type": 0,
                "eye_makeup_type": 0,
                "eye_state": 0,
                "facial_hair_type": 0,
                "gender_type": 0,
                "glasses_type": 0,
                "hair_color_type": 0,
                "intrash": 0,
                "lip_makeup_type": 0,
                "smile_type": 0,
            },
            "4A94F932-FB23-48AA-AFD3-EDF2875A3F3E": {
                "_pk": 34,
                "uuid": "4A94F932-FB23-48AA-AFD3-EDF2875A3F3E",
                "name": "right2",
                "asset_uuid": "C547648F-B778-43B5-B12B-4338B7377D09",
                "_person_pk": 37,
                "center_x": 0.7118698810452417,
                "center_y": 0.5780494076905933,
                "center": (590, 575),
                "mouth_x": 0.0,
                "mouth_y": 0.0,
                "mouth": (2048, 1365),
                "left_eye_x": 0.0,
                "left_eye_y": 0.0,
                "left_eye": (2048, 1365),
                "right_eye_x": 0.0,
                "right_eye_y": 0.0,
                "right_eye": (2048, 1365),
                "size": 0.08225783705711365,
                "face_rect": [
                    (505.7679748535156, 490.7679748535156),
                    (674.2320251464844, 659.2320251464844),
                ],
                "mpri_reg_rect": {
                    "x": 0.24700120042620144,
                    "y": 0.3602421489786489,
                    "h": 0.08225783705711365,
                    "w": 0.12341688666151557,
                },
                "mwg_rs_area": {
                    "x": 0.28813011895475826,
                    "y": 0.4219505923094067,
                    "h": 0.12341688666151557,
                    "w": 0.08225783705711365,
                },
                "roll": 0.0,
                "pitch": 0.0,
                "yaw": 0.0,
                "quality": -1.0,
                "source_width": 2048,
                "source_height": 1365,
                "has_smile": 0,
                "left_eye_closed": 0,
                "right_eye_closed": 0,
                "manual": 1,
                "face_type": None,
                "age_type": 0,
                "eye_makeup_type": 0,
                "eye_state": 0,
                "facial_hair_type": 0,
                "gender_type": 0,
                "glasses_type": 0,
                "hair_color_type": 0,
                "intrash": 0,
                "lip_makeup_type": 0,
                "smile_type": 0,
            },
        }
    },
    {
        "4B97B0B4-B5E4-42D2-821F-8926D8B9BEBA": {
            "DFEE3150-8D5E-4D55-A507-50A46C7FE8E2": {
                "_pk": 28,
                "uuid": "DFEE3150-8D5E-4D55-A507-50A46C7FE8E2",
                "name": "exif8",
                "asset_uuid": "4B97B0B4-B5E4-42D2-821F-8926D8B9BEBA",
                "_person_pk": 30,
                "center_x": 0.6077711192731491,
                "center_y": 0.7344278585926929,
                "center": (1504, 829),
                "mouth_x": 0.0,
                "mouth_y": 0.0,
                "mouth": (0, 0),
                "left_eye_x": 0.0,
                "left_eye_y": 0.0,
                "left_eye": (0, 0),
                "right_eye_x": 0.0,
                "right_eye_y": 0.0,
                "right_eye": (0, 0),
                "size": 0.16976258158683777,
                "face_rect": [
                    (1330.1631164550781, 655.1631164550781),
                    (1677.8368835449219, 1002.8368835449219),
                ],
                "mpri_reg_rect": {
                    "x": 0.649546567799274,
                    "y": 0.4804180910351111,
                    "h": 0.16976258158683777,
                    "w": 0.254706056476076,
                },
                "mwg_rs_area": {
                    "x": 0.7344278585926929,
                    "y": 0.6077711192731491,
                    "h": 0.254706056476076,
                    "w": 0.16976258158683777,
                },
                "roll": 0.0,
                "pitch": 0.0,
                "yaw": 0.0,
                "quality": -1.0,
                "source_width": 1365,
                "source_height": 2048,
                "has_smile": 0,
                "left_eye_closed": 0,
                "right_eye_closed": 0,
                "manual": 1,
                "face_type": None,
                "age_type": 0,
                "eye_makeup_type": 0,
                "eye_state": 0,
                "facial_hair_type": 0,
                "gender_type": 0,
                "glasses_type": 0,
                "hair_color_type": 0,
                "intrash": 0,
                "lip_makeup_type": 0,
                "smile_type": 0,
            }
        }
    },
    {
        "2C766B95-1D8C-40DA-AD8E-39798BF4576D": {
            "4A3085CA-9370-4401-920D-EE827BFB0385": {
                "_pk": 14,
                "uuid": "4A3085CA-9370-4401-920D-EE827BFB0385",
                "name": "",
                "asset_uuid": "2C766B95-1D8C-40DA-AD8E-39798BF4576D",
                "_person_pk": 5,
                "center_x": 0.5148479491472244,
                "center_y": 0.37627631425857544,
                "center": (1054, 851),
                "mouth_x": 0.5168212004211425,
                "mouth_y": 0.26665759770107655,
                "mouth": (1058, 1001),
                "left_eye_x": 0.43235626139945704,
                "left_eye_y": 0.5063340759639829,
                "left_eye": (885, 673),
                "right_eye_x": 0.5781170603291468,
                "right_eye_y": 0.504449233726675,
                "right_eye": (1183, 676),
                "size": 0.37983468174934387,
                "face_rect": [
                    (665.0492858886719, 462.0492858886719),
                    (1442.9507141113281, 1239.9507141113281),
                ],
                "mpri_reg_rect": {
                    "x": 0.3249306082725525,
                    "y": 0.33877810763788746,
                    "h": 0.37983468174934387,
                    "w": 0.5698911562070742,
                },
                "mwg_rs_area": {
                    "x": 0.5148479491472244,
                    "y": 0.6237236857414246,
                    "h": 0.5698911562070742,
                    "w": 0.37983468174934387,
                },
                "roll": 0.0,
                "pitch": 0.0,
                "yaw": 0.0,
                "quality": 0.6023849248886108,
                "source_width": 2048,
                "source_height": 1365,
                "has_smile": 1,
                "left_eye_closed": 0,
                "right_eye_closed": 0,
                "manual": 0,
                "face_type": None,
                "age_type": 3,
                "eye_makeup_type": 0,
                "eye_state": 2,
                "facial_hair_type": 1,
                "gender_type": 2,
                "glasses_type": 3,
                "hair_color_type": 3,
                "intrash": 0,
                "lip_makeup_type": 0,
                "smile_type": 1,
            }
        }
    },
    {
        "687A4CF6-380A-4B6F-A105-7DA04CF72CFD": {
            "4355FCE9-C3D1-4F0C-BC3A-9AF30B291346": {
                "_pk": 26,
                "uuid": "4355FCE9-C3D1-4F0C-BC3A-9AF30B291346",
                "name": "exif1",
                "asset_uuid": "687A4CF6-380A-4B6F-A105-7DA04CF72CFD",
                "_person_pk": 28,
                "center_x": 0.6187313813836142,
                "center_y": 0.7373562246278755,
                "center": (844, 537),
                "mouth_x": 0.0,
                "mouth_y": 0.0,
                "mouth": (0, 2048),
                "left_eye_x": 0.0,
                "left_eye_y": 0.0,
                "left_eye": (0, 2048),
                "right_eye_x": 0.0,
                "right_eye_y": 0.0,
                "right_eye": (0, 2048),
                "size": 0.17837372422218323,
                "face_rect": [
                    (661.3453063964844, 354.3453063964844),
                    (1026.6546936035156, 719.6546936035156),
                ],
                "mpri_reg_rect": {
                    "x": 0.4849184190367163,
                    "y": 0.17345691326103285,
                    "h": 0.2676259246937958,
                    "w": 0.17837372422218323,
                },
                "mwg_rs_area": {
                    "x": 0.6187313813836142,
                    "y": 0.26264377537212447,
                    "h": 0.17837372422218323,
                    "w": 0.2676259246937958,
                },
                "roll": 0.0,
                "pitch": 0.0,
                "yaw": 0.0,
                "quality": -1.0,
                "source_width": 1365,
                "source_height": 2048,
                "has_smile": 0,
                "left_eye_closed": 0,
                "right_eye_closed": 0,
                "manual": 1,
                "face_type": None,
                "age_type": 0,
                "eye_makeup_type": 0,
                "eye_state": 0,
                "facial_hair_type": 0,
                "gender_type": 0,
                "glasses_type": 0,
                "hair_color_type": 0,
                "intrash": 0,
                "lip_makeup_type": 0,
                "smile_type": 0,
            }
        }
    },
    {
        "916732EA-E357-47E7-894C-DB0692F24327": {
            "8B80014E-7C4C-4171-84D3-025A0AF048A2": {
                "_pk": 3,
                "uuid": "8B80014E-7C4C-4171-84D3-025A0AF048A2",
                "name": "",
                "asset_uuid": "916732EA-E357-47E7-894C-DB0692F24327",
                "_person_pk": 10,
                "center_x": 0.35888195782899857,
                "center_y": 0.7573218867182732,
                "center": (697, 496),
                "mouth_x": 0.3560030762990789,
                "mouth_y": 0.7245022736543534,
                "mouth": (692, 563),
                "left_eye_x": 0.3228970239299365,
                "left_eye_y": 0.7939033123266092,
                "left_eye": (627, 421),
                "right_eye_x": 0.3934052193929619,
                "right_eye_y": 0.7951097823258109,
                "right_eye": (764, 419),
                "size": 0.16858910024166107,
                "face_rect": [
                    (524.4490559026599, 323.4490559026599),
                    (869.5509440973401, 668.5509440973401),
                ],
                "mpri_reg_rect": {
                    "x": 0.27012118411637503,
                    "y": 0.1583835631608963,
                    "h": 0.17752154742524703,
                    "w": 0.16858910024166107,
                },
                "mwg_rs_area": {
                    "x": 0.35888195782899857,
                    "y": 0.24267811328172684,
                    "h": 0.16858910024166107,
                    "w": 0.17752154742524703,
                },
                "roll": 0.0,
                "pitch": 0.0,
                "yaw": 0.0,
                "quality": 0.457404762506485,
                "source_width": 1944,
                "source_height": 2047,
                "has_smile": 0,
                "left_eye_closed": 0,
                "right_eye_closed": 0,
                "manual": 0,
                "face_type": None,
                "age_type": 5,
                "eye_makeup_type": 0,
                "eye_state": 2,
                "facial_hair_type": 1,
                "gender_type": 2,
                "glasses_type": 3,
                "hair_color_type": 2,
                "intrash": 0,
                "lip_makeup_type": 0,
                "smile_type": 2,
            },
            "87768A03-2B8A-4C4C-9A08-277F1A50FDA6": {
                "_pk": 4,
                "uuid": "87768A03-2B8A-4C4C-9A08-277F1A50FDA6",
                "name": "Old Man with Beard and Glasses",
                "asset_uuid": "916732EA-E357-47E7-894C-DB0692F24327",
                "_person_pk": 19,
                "center_x": 0.6327871978282928,
                "center_y": 0.5937167853116989,
                "center": (1230, 831),
                "mouth_x": 0.6264235349695175,
                "mouth_y": 0.5523254625520435,
                "mouth": (1217, 916),
                "left_eye_x": 0.5852686350731954,
                "left_eye_y": 0.6364995836063867,
                "left_eye": (1137, 744),
                "right_eye_x": 0.6727350603374944,
                "right_eye_y": 0.6442028744153179,
                "right_eye": (1307, 728),
                "size": 0.20893487334251404,
                "face_rect": [
                    (1016.1551571339369, 617.1551571339369),
                    (1443.8448428660631, 1044.8448428660631),
                ],
                "mpri_reg_rect": {
                    "x": 0.5227847066420463,
                    "y": 0.30181577801704407,
                    "h": 0.2200049823724929,
                    "w": 0.20893487334251404,
                },
                "mwg_rs_area": {
                    "x": 0.6327871978282928,
                    "y": 0.4062832146883011,
                    "h": 0.20893487334251404,
                    "w": 0.2200049823724929,
                },
                "roll": 0.0,
                "pitch": 0.0,
                "yaw": 0.0,
                "quality": 0.5107378959655762,
                "source_width": 1944,
                "source_height": 2047,
                "has_smile": 0,
                "left_eye_closed": 0,
                "right_eye_closed": 0,
                "manual": 0,
                "face_type": None,
                "age_type": 4,
                "eye_makeup_type": 0,
                "eye_state": 2,
                "facial_hair_type": 2,
                "gender_type": 1,
                "glasses_type": 1,
                "hair_color_type": 6,
                "intrash": 0,
                "lip_makeup_type": 0,
                "smile_type": 2,
            },
        }
    },
    {
        "82B6F7FA-C552-4A91-9150-372EF3437FDC": {
            "5384E868-2CC2-4D2F-B171-46193567073E": {
                "_pk": 9,
                "uuid": "5384E868-2CC2-4D2F-B171-46193567073E",
                "name": "Bald Guy with Beard and Glasses",
                "asset_uuid": "82B6F7FA-C552-4A91-9150-372EF3437FDC",
                "_person_pk": 17,
                "center_x": 0.32925228029489517,
                "center_y": 0.5016408860683441,
                "center": (674, 680),
                "mouth_x": 0.35357513787707784,
                "mouth_y": 0.4528046849535592,
                "mouth": (750, 712),
                "left_eye_x": 0.2717253644791406,
                "left_eye_y": 0.5492886026650554,
                "left_eye": (539, 682),
                "right_eye_x": 0.3415018531310906,
                "right_eye_y": 0.578722708157068,
                "right_eye": (643, 576),
                "size": 0.2136638136289548,
                "face_rect": [
                    (455.2082548439503, 461.2082548439503),
                    (892.7917451560497, 898.7917451560497),
                ],
                "mpri_reg_rect": {
                    "x": 0.22242037348041777,
                    "y": 0.33807212114334106,
                    "h": 0.2136638136289548,
                    "w": 0.32057398557662964,
                },
                "mwg_rs_area": {
                    "x": 0.32925228029489517,
                    "y": 0.4983591139316559,
                    "h": 0.32057398557662964,
                    "w": 0.2136638136289548,
                },
                "roll": 0.5235987901687622,
                "pitch": 0.0,
                "yaw": 0.0,
                "quality": 0.5326955318450928,
                "source_width": 2048,
                "source_height": 1365,
                "has_smile": 0,
                "left_eye_closed": 0,
                "right_eye_closed": 0,
                "manual": 0,
                "face_type": None,
                "age_type": 5,
                "eye_makeup_type": 0,
                "eye_state": 2,
                "facial_hair_type": 2,
                "gender_type": 1,
                "glasses_type": 1,
                "hair_color_type": 3,
                "intrash": 0,
                "lip_makeup_type": 0,
                "smile_type": 1,
            }
        }
    },
    {
        "554B190D-B064-479F-89CB-EB2485C3675F": {
            "47BA92F0-2083-4AAE-AB79-B741FF8FDEAA": {
                "_pk": 17,
                "uuid": "47BA92F0-2083-4AAE-AB79-B741FF8FDEAA",
                "name": "Exif",
                "asset_uuid": "554B190D-B064-479F-89CB-EB2485C3675F",
                "_person_pk": 16,
                "center_x": 0.5058241337537766,
                "center_y": 0.40621668100357056,
                "center": (1035, 811),
                "mouth_x": 0.4940449122017374,
                "mouth_y": 0.2800719558140182,
                "mouth": (1011, 984),
                "left_eye_x": 0.4374790271180322,
                "left_eye_y": 0.5214642632262265,
                "left_eye": (895, 654),
                "right_eye_x": 0.5435461602085978,
                "right_eye_y": 0.5581745216649008,
                "right_eye": (1113, 603),
                "size": 0.3930774775217287,
                "face_rect": [
                    (632.4886630177498, 408.4886630177498),
                    (1437.5113369822502, 1213.5113369822502),
                ],
                "mpri_reg_rect": {
                    "x": 0.3092853949929122,
                    "y": 0.29933464527130127,
                    "h": 0.3930774775217287,
                    "w": 0.5888973474502563,
                },
                "mwg_rs_area": {
                    "x": 0.5058241337537766,
                    "y": 0.5937833189964294,
                    "h": 0.5888973474502563,
                    "w": 0.3930774775217287,
                },
                "roll": 0.0,
                "pitch": 0.0,
                "yaw": 0.0,
                "quality": 0.6076138019561768,
                "source_width": 2048,
                "source_height": 1367,
                "has_smile": 0,
                "left_eye_closed": 0,
                "right_eye_closed": 0,
                "manual": 0,
                "face_type": None,
                "age_type": 3,
                "eye_makeup_type": 0,
                "eye_state": 2,
                "facial_hair_type": 1,
                "gender_type": 2,
                "glasses_type": 3,
                "hair_color_type": 1,
                "intrash": 0,
                "lip_makeup_type": 0,
                "smile_type": 2,
            }
        }
    },
]


@pytest.fixture
def photosdb5():
    import osxphotos

    return osxphotos.PhotosDB(dbfile=PHOTOS_DB_5)


@pytest.fixture
def photosdb4():
    import osxphotos

    return osxphotos.PhotosDB(dbfile=PHOTOS_DB_4)


@pytest.mark.parametrize("uuid_dict", UUID_LIST_5)
def test_faceinfo_v5(photosdb5, uuid_dict):
    """ Test FaceInfo object """
    import json

    for uuid in uuid_dict:
        photo = photosdb5.get_photo(uuid)
        faces = photo.face_info
        assert len(faces) == len(uuid_dict[uuid])
        for face in faces:
            assert face.uuid in uuid_dict[uuid]
            # test by keys instead of dict == dict because Monterey+ dropped support for some of the face details
            # and I didn't want to regenerate all the test data (e.g.eye, mouth coordinates) 
            face_dict = face.asdict()
            for key in face_dict:
                if key == "yaw":
                    continue # yaw set to 0 as it's not in Ventura
                assert face_dict[key] == uuid_dict[uuid][face.uuid][key]


def test_faceinfo_v5_no_face(photosdb5):
    """ Test FaceInfo on image with no faces """
    photo = photosdb5.get_photo(UUID_NO_FACE_5)
    assert photo.face_info == []


@pytest.mark.parametrize("uuid_dict", UUID_LIST_4)
def test_faceinfo_v4(photosdb4, uuid_dict):
    """ Test FaceInfo object """
    import json

    for uuid in uuid_dict:
        photo = photosdb4.get_photo(uuid)
        faces = photo.face_info
        assert len(faces) == len(uuid_dict[uuid])
        for face in faces:
            assert face.uuid in uuid_dict[uuid]
            # test by keys instead of dict == dict because Monterey+ dropped support for some of the face details
            # and I didn't want to regenerate all the test data (e.g.eye, mouth coordinates) 
            face_dict = face.asdict()
            for key in face_dict:
                assert face_dict[key] == uuid_dict[uuid][face.uuid][key]


def test_faceinfo_v4_no_face(photosdb4):
    """ Test FaceInfo on image with no faces """
    photo = photosdb4.get_photo(UUID_NO_FACE_4)
    assert photo.face_info == []
