# -*- coding: utf-8 -*-
# This file is auto-generated, don't edit it. Thanks.
from Tea.model import TeaModel
from typing import Dict, List, Any


class ResultValue(TeaModel):
    def __init__(
        self,
        thumbnail: str = None,
        file_size: int = None,
        extension: str = None,
        file_name: str = None,
        url: str = None,
    ):
        self.thumbnail = thumbnail
        self.file_size = file_size
        self.extension = extension
        self.file_name = file_name
        self.url = url

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.thumbnail is not None:
            result['thumbnail'] = self.thumbnail
        if self.file_size is not None:
            result['fileSize'] = self.file_size
        if self.extension is not None:
            result['extension'] = self.extension
        if self.file_name is not None:
            result['fileName'] = self.file_name
        if self.url is not None:
            result['url'] = self.url
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('thumbnail') is not None:
            self.thumbnail = m.get('thumbnail')
        if m.get('fileSize') is not None:
            self.file_size = m.get('fileSize')
        if m.get('extension') is not None:
            self.extension = m.get('extension')
        if m.get('fileName') is not None:
            self.file_name = m.get('fileName')
        if m.get('url') is not None:
            self.url = m.get('url')
        return self


class ActivateDeviceHeaders(TeaModel):
    def __init__(
        self,
        common_headers: Dict[str, str] = None,
        x_acs_dingtalk_access_token: str = None,
    ):
        self.common_headers = common_headers
        self.x_acs_dingtalk_access_token = x_acs_dingtalk_access_token

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.common_headers is not None:
            result['commonHeaders'] = self.common_headers
        if self.x_acs_dingtalk_access_token is not None:
            result['x-acs-dingtalk-access-token'] = self.x_acs_dingtalk_access_token
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('commonHeaders') is not None:
            self.common_headers = m.get('commonHeaders')
        if m.get('x-acs-dingtalk-access-token') is not None:
            self.x_acs_dingtalk_access_token = m.get('x-acs-dingtalk-access-token')
        return self


class ActivateDeviceRequest(TeaModel):
    def __init__(
        self,
        license_key: str = None,
        model: str = None,
        name: str = None,
        sn: str = None,
        type: str = None,
    ):
        # This parameter is required.
        self.license_key = license_key
        # This parameter is required.
        self.model = model
        # This parameter is required.
        self.name = name
        # This parameter is required.
        self.sn = sn
        # This parameter is required.
        self.type = type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.license_key is not None:
            result['licenseKey'] = self.license_key
        if self.model is not None:
            result['model'] = self.model
        if self.name is not None:
            result['name'] = self.name
        if self.sn is not None:
            result['sn'] = self.sn
        if self.type is not None:
            result['type'] = self.type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('licenseKey') is not None:
            self.license_key = m.get('licenseKey')
        if m.get('model') is not None:
            self.model = m.get('model')
        if m.get('name') is not None:
            self.name = m.get('name')
        if m.get('sn') is not None:
            self.sn = m.get('sn')
        if m.get('type') is not None:
            self.type = m.get('type')
        return self


class ActivateDeviceResponseBody(TeaModel):
    def __init__(
        self,
        result: bool = None,
    ):
        self.result = result

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.result is not None:
            result['result'] = self.result
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('result') is not None:
            self.result = m.get('result')
        return self


class ActivateDeviceResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: ActivateDeviceResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ActivateDeviceResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class AddCollegeAlumniDeptsHeaders(TeaModel):
    def __init__(
        self,
        common_headers: Dict[str, str] = None,
        x_acs_dingtalk_access_token: str = None,
    ):
        self.common_headers = common_headers
        self.x_acs_dingtalk_access_token = x_acs_dingtalk_access_token

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.common_headers is not None:
            result['commonHeaders'] = self.common_headers
        if self.x_acs_dingtalk_access_token is not None:
            result['x-acs-dingtalk-access-token'] = self.x_acs_dingtalk_access_token
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('commonHeaders') is not None:
            self.common_headers = m.get('commonHeaders')
        if m.get('x-acs-dingtalk-access-token') is not None:
            self.x_acs_dingtalk_access_token = m.get('x-acs-dingtalk-access-token')
        return self


class AddCollegeAlumniDeptsRequestDepts(TeaModel):
    def __init__(
        self,
        name: str = None,
        super_id: int = None,
    ):
        # This parameter is required.
        self.name = name
        # This parameter is required.
        self.super_id = super_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.name is not None:
            result['name'] = self.name
        if self.super_id is not None:
            result['superId'] = self.super_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('name') is not None:
            self.name = m.get('name')
        if m.get('superId') is not None:
            self.super_id = m.get('superId')
        return self


class AddCollegeAlumniDeptsRequest(TeaModel):
    def __init__(
        self,
        depts: List[AddCollegeAlumniDeptsRequestDepts] = None,
        operator: str = None,
    ):
        # This parameter is required.
        self.depts = depts
        # This parameter is required.
        self.operator = operator

    def validate(self):
        if self.depts:
            for k in self.depts:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['depts'] = []
        if self.depts is not None:
            for k in self.depts:
                result['depts'].append(k.to_map() if k else None)
        if self.operator is not None:
            result['operator'] = self.operator
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.depts = []
        if m.get('depts') is not None:
            for k in m.get('depts'):
                temp_model = AddCollegeAlumniDeptsRequestDepts()
                self.depts.append(temp_model.from_map(k))
        if m.get('operator') is not None:
            self.operator = m.get('operator')
        return self


class AddCollegeAlumniDeptsResponseBodyResult(TeaModel):
    def __init__(
        self,
        corp_id: str = None,
        dept_id: int = None,
        dept_type: str = None,
        has_sub_dept: bool = None,
        name: str = None,
        super_id: int = None,
    ):
        self.corp_id = corp_id
        self.dept_id = dept_id
        self.dept_type = dept_type
        self.has_sub_dept = has_sub_dept
        self.name = name
        self.super_id = super_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.corp_id is not None:
            result['corpId'] = self.corp_id
        if self.dept_id is not None:
            result['deptId'] = self.dept_id
        if self.dept_type is not None:
            result['deptType'] = self.dept_type
        if self.has_sub_dept is not None:
            result['hasSubDept'] = self.has_sub_dept
        if self.name is not None:
            result['name'] = self.name
        if self.super_id is not None:
            result['superId'] = self.super_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('corpId') is not None:
            self.corp_id = m.get('corpId')
        if m.get('deptId') is not None:
            self.dept_id = m.get('deptId')
        if m.get('deptType') is not None:
            self.dept_type = m.get('deptType')
        if m.get('hasSubDept') is not None:
            self.has_sub_dept = m.get('hasSubDept')
        if m.get('name') is not None:
            self.name = m.get('name')
        if m.get('superId') is not None:
            self.super_id = m.get('superId')
        return self


class AddCollegeAlumniDeptsResponseBody(TeaModel):
    def __init__(
        self,
        result: List[AddCollegeAlumniDeptsResponseBodyResult] = None,
        success: bool = None,
    ):
        self.result = result
        self.success = success

    def validate(self):
        if self.result:
            for k in self.result:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['result'] = []
        if self.result is not None:
            for k in self.result:
                result['result'].append(k.to_map() if k else None)
        if self.success is not None:
            result['success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.result = []
        if m.get('result') is not None:
            for k in m.get('result'):
                temp_model = AddCollegeAlumniDeptsResponseBodyResult()
                self.result.append(temp_model.from_map(k))
        if m.get('success') is not None:
            self.success = m.get('success')
        return self


class AddCollegeAlumniDeptsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: AddCollegeAlumniDeptsResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = AddCollegeAlumniDeptsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class AddCollegeAlumniUserInfoHeaders(TeaModel):
    def __init__(
        self,
        common_headers: Dict[str, str] = None,
        x_acs_dingtalk_access_token: str = None,
    ):
        self.common_headers = common_headers
        self.x_acs_dingtalk_access_token = x_acs_dingtalk_access_token

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.common_headers is not None:
            result['commonHeaders'] = self.common_headers
        if self.x_acs_dingtalk_access_token is not None:
            result['x-acs-dingtalk-access-token'] = self.x_acs_dingtalk_access_token
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('commonHeaders') is not None:
            self.common_headers = m.get('commonHeaders')
        if m.get('x-acs-dingtalk-access-token') is not None:
            self.x_acs_dingtalk_access_token = m.get('x-acs-dingtalk-access-token')
        return self


class AddCollegeAlumniUserInfoRequest(TeaModel):
    def __init__(
        self,
        address: str = None,
        dept_ids: List[int] = None,
        email: str = None,
        intake: str = None,
        mobile: str = None,
        name: str = None,
        operator: str = None,
        outtake: str = None,
        student_number: str = None,
    ):
        self.address = address
        # This parameter is required.
        self.dept_ids = dept_ids
        self.email = email
        self.intake = intake
        # This parameter is required.
        self.mobile = mobile
        # This parameter is required.
        self.name = name
        # This parameter is required.
        self.operator = operator
        self.outtake = outtake
        self.student_number = student_number

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.address is not None:
            result['address'] = self.address
        if self.dept_ids is not None:
            result['deptIds'] = self.dept_ids
        if self.email is not None:
            result['email'] = self.email
        if self.intake is not None:
            result['intake'] = self.intake
        if self.mobile is not None:
            result['mobile'] = self.mobile
        if self.name is not None:
            result['name'] = self.name
        if self.operator is not None:
            result['operator'] = self.operator
        if self.outtake is not None:
            result['outtake'] = self.outtake
        if self.student_number is not None:
            result['studentNumber'] = self.student_number
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('address') is not None:
            self.address = m.get('address')
        if m.get('deptIds') is not None:
            self.dept_ids = m.get('deptIds')
        if m.get('email') is not None:
            self.email = m.get('email')
        if m.get('intake') is not None:
            self.intake = m.get('intake')
        if m.get('mobile') is not None:
            self.mobile = m.get('mobile')
        if m.get('name') is not None:
            self.name = m.get('name')
        if m.get('operator') is not None:
            self.operator = m.get('operator')
        if m.get('outtake') is not None:
            self.outtake = m.get('outtake')
        if m.get('studentNumber') is not None:
            self.student_number = m.get('studentNumber')
        return self


class AddCollegeAlumniUserInfoResponseBodyResult(TeaModel):
    def __init__(
        self,
        success: bool = None,
        type: str = None,
    ):
        self.success = success
        self.type = type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.success is not None:
            result['success'] = self.success
        if self.type is not None:
            result['type'] = self.type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('success') is not None:
            self.success = m.get('success')
        if m.get('type') is not None:
            self.type = m.get('type')
        return self


class AddCollegeAlumniUserInfoResponseBody(TeaModel):
    def __init__(
        self,
        result: AddCollegeAlumniUserInfoResponseBodyResult = None,
        success: bool = None,
    ):
        self.result = result
        self.success = success

    def validate(self):
        if self.result:
            self.result.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.result is not None:
            result['result'] = self.result.to_map()
        if self.success is not None:
            result['success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('result') is not None:
            temp_model = AddCollegeAlumniUserInfoResponseBodyResult()
            self.result = temp_model.from_map(m['result'])
        if m.get('success') is not None:
            self.success = m.get('success')
        return self


class AddCollegeAlumniUserInfoResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: AddCollegeAlumniUserInfoResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = AddCollegeAlumniUserInfoResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class AddCollegeContactExclusiveHeaders(TeaModel):
    def __init__(
        self,
        common_headers: Dict[str, str] = None,
        x_acs_dingtalk_access_token: str = None,
    ):
        self.common_headers = common_headers
        self.x_acs_dingtalk_access_token = x_acs_dingtalk_access_token

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.common_headers is not None:
            result['commonHeaders'] = self.common_headers
        if self.x_acs_dingtalk_access_token is not None:
            result['x-acs-dingtalk-access-token'] = self.x_acs_dingtalk_access_token
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('commonHeaders') is not None:
            self.common_headers = m.get('commonHeaders')
        if m.get('x-acs-dingtalk-access-token') is not None:
            self.x_acs_dingtalk_access_token = m.get('x-acs-dingtalk-access-token')
        return self


class AddCollegeContactExclusiveRequestDeptOrderList(TeaModel):
    def __init__(
        self,
        dept_id: int = None,
        order: int = None,
    ):
        self.dept_id = dept_id
        self.order = order

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dept_id is not None:
            result['deptId'] = self.dept_id
        if self.order is not None:
            result['order'] = self.order
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('deptId') is not None:
            self.dept_id = m.get('deptId')
        if m.get('order') is not None:
            self.order = m.get('order')
        return self


class AddCollegeContactExclusiveRequestDeptPositionSet(TeaModel):
    def __init__(
        self,
        dept_id: int = None,
        manager_user_id: str = None,
        title: str = None,
        work_place: str = None,
    ):
        self.dept_id = dept_id
        self.manager_user_id = manager_user_id
        self.title = title
        self.work_place = work_place

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dept_id is not None:
            result['deptId'] = self.dept_id
        if self.manager_user_id is not None:
            result['managerUserId'] = self.manager_user_id
        if self.title is not None:
            result['title'] = self.title
        if self.work_place is not None:
            result['workPlace'] = self.work_place
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('deptId') is not None:
            self.dept_id = m.get('deptId')
        if m.get('managerUserId') is not None:
            self.manager_user_id = m.get('managerUserId')
        if m.get('title') is not None:
            self.title = m.get('title')
        if m.get('workPlace') is not None:
            self.work_place = m.get('workPlace')
        return self


class AddCollegeContactExclusiveRequestDeptTitleList(TeaModel):
    def __init__(
        self,
        dept_id: int = None,
        title: str = None,
    ):
        self.dept_id = dept_id
        self.title = title

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dept_id is not None:
            result['deptId'] = self.dept_id
        if self.title is not None:
            result['title'] = self.title
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('deptId') is not None:
            self.dept_id = m.get('deptId')
        if m.get('title') is not None:
            self.title = m.get('title')
        return self


class AddCollegeContactExclusiveRequest(TeaModel):
    def __init__(
        self,
        avatar_media_id: str = None,
        dept_id_list: List[int] = None,
        dept_order_list: List[AddCollegeContactExclusiveRequestDeptOrderList] = None,
        dept_position_set: List[AddCollegeContactExclusiveRequestDeptPositionSet] = None,
        dept_title_list: List[AddCollegeContactExclusiveRequestDeptTitleList] = None,
        email: str = None,
        emp_type: str = None,
        exclusive_account: bool = None,
        exclusive_account_type: str = None,
        extension: Dict[str, str] = None,
        hired_date: int = None,
        init_password: str = None,
        job_number: str = None,
        login_id_type: str = None,
        main_dept_id: int = None,
        manager_userid: str = None,
        mobile: str = None,
        name: str = None,
        nickname: str = None,
        org_email: str = None,
        org_email_type: str = None,
        remark: str = None,
        send_active_sms: bool = None,
        senior_mode: bool = None,
        telephone: str = None,
        title: str = None,
        userid: str = None,
        work_place: str = None,
    ):
        self.avatar_media_id = avatar_media_id
        # This parameter is required.
        self.dept_id_list = dept_id_list
        self.dept_order_list = dept_order_list
        self.dept_position_set = dept_position_set
        self.dept_title_list = dept_title_list
        self.email = email
        # This parameter is required.
        self.emp_type = emp_type
        # This parameter is required.
        self.exclusive_account = exclusive_account
        # This parameter is required.
        self.exclusive_account_type = exclusive_account_type
        self.extension = extension
        self.hired_date = hired_date
        # This parameter is required.
        self.init_password = init_password
        self.job_number = job_number
        # This parameter is required.
        self.login_id_type = login_id_type
        # This parameter is required.
        self.main_dept_id = main_dept_id
        self.manager_userid = manager_userid
        self.mobile = mobile
        # This parameter is required.
        self.name = name
        self.nickname = nickname
        self.org_email = org_email
        self.org_email_type = org_email_type
        self.remark = remark
        self.send_active_sms = send_active_sms
        self.senior_mode = senior_mode
        self.telephone = telephone
        self.title = title
        self.userid = userid
        self.work_place = work_place

    def validate(self):
        if self.dept_order_list:
            for k in self.dept_order_list:
                if k:
                    k.validate()
        if self.dept_position_set:
            for k in self.dept_position_set:
                if k:
                    k.validate()
        if self.dept_title_list:
            for k in self.dept_title_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.avatar_media_id is not None:
            result['avatarMediaId'] = self.avatar_media_id
        if self.dept_id_list is not None:
            result['deptIdList'] = self.dept_id_list
        result['deptOrderList'] = []
        if self.dept_order_list is not None:
            for k in self.dept_order_list:
                result['deptOrderList'].append(k.to_map() if k else None)
        result['deptPositionSet'] = []
        if self.dept_position_set is not None:
            for k in self.dept_position_set:
                result['deptPositionSet'].append(k.to_map() if k else None)
        result['deptTitleList'] = []
        if self.dept_title_list is not None:
            for k in self.dept_title_list:
                result['deptTitleList'].append(k.to_map() if k else None)
        if self.email is not None:
            result['email'] = self.email
        if self.emp_type is not None:
            result['empType'] = self.emp_type
        if self.exclusive_account is not None:
            result['exclusiveAccount'] = self.exclusive_account
        if self.exclusive_account_type is not None:
            result['exclusiveAccountType'] = self.exclusive_account_type
        if self.extension is not None:
            result['extension'] = self.extension
        if self.hired_date is not None:
            result['hiredDate'] = self.hired_date
        if self.init_password is not None:
            result['initPassword'] = self.init_password
        if self.job_number is not None:
            result['jobNumber'] = self.job_number
        if self.login_id_type is not None:
            result['loginIdType'] = self.login_id_type
        if self.main_dept_id is not None:
            result['mainDeptId'] = self.main_dept_id
        if self.manager_userid is not None:
            result['managerUserid'] = self.manager_userid
        if self.mobile is not None:
            result['mobile'] = self.mobile
        if self.name is not None:
            result['name'] = self.name
        if self.nickname is not None:
            result['nickname'] = self.nickname
        if self.org_email is not None:
            result['orgEmail'] = self.org_email
        if self.org_email_type is not None:
            result['orgEmailType'] = self.org_email_type
        if self.remark is not None:
            result['remark'] = self.remark
        if self.send_active_sms is not None:
            result['sendActiveSms'] = self.send_active_sms
        if self.senior_mode is not None:
            result['seniorMode'] = self.senior_mode
        if self.telephone is not None:
            result['telephone'] = self.telephone
        if self.title is not None:
            result['title'] = self.title
        if self.userid is not None:
            result['userid'] = self.userid
        if self.work_place is not None:
            result['workPlace'] = self.work_place
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('avatarMediaId') is not None:
            self.avatar_media_id = m.get('avatarMediaId')
        if m.get('deptIdList') is not None:
            self.dept_id_list = m.get('deptIdList')
        self.dept_order_list = []
        if m.get('deptOrderList') is not None:
            for k in m.get('deptOrderList'):
                temp_model = AddCollegeContactExclusiveRequestDeptOrderList()
                self.dept_order_list.append(temp_model.from_map(k))
        self.dept_position_set = []
        if m.get('deptPositionSet') is not None:
            for k in m.get('deptPositionSet'):
                temp_model = AddCollegeContactExclusiveRequestDeptPositionSet()
                self.dept_position_set.append(temp_model.from_map(k))
        self.dept_title_list = []
        if m.get('deptTitleList') is not None:
            for k in m.get('deptTitleList'):
                temp_model = AddCollegeContactExclusiveRequestDeptTitleList()
                self.dept_title_list.append(temp_model.from_map(k))
        if m.get('email') is not None:
            self.email = m.get('email')
        if m.get('empType') is not None:
            self.emp_type = m.get('empType')
        if m.get('exclusiveAccount') is not None:
            self.exclusive_account = m.get('exclusiveAccount')
        if m.get('exclusiveAccountType') is not None:
            self.exclusive_account_type = m.get('exclusiveAccountType')
        if m.get('extension') is not None:
            self.extension = m.get('extension')
        if m.get('hiredDate') is not None:
            self.hired_date = m.get('hiredDate')
        if m.get('initPassword') is not None:
            self.init_password = m.get('initPassword')
        if m.get('jobNumber') is not None:
            self.job_number = m.get('jobNumber')
        if m.get('loginIdType') is not None:
            self.login_id_type = m.get('loginIdType')
        if m.get('mainDeptId') is not None:
            self.main_dept_id = m.get('mainDeptId')
        if m.get('managerUserid') is not None:
            self.manager_userid = m.get('managerUserid')
        if m.get('mobile') is not None:
            self.mobile = m.get('mobile')
        if m.get('name') is not None:
            self.name = m.get('name')
        if m.get('nickname') is not None:
            self.nickname = m.get('nickname')
        if m.get('orgEmail') is not None:
            self.org_email = m.get('orgEmail')
        if m.get('orgEmailType') is not None:
            self.org_email_type = m.get('orgEmailType')
        if m.get('remark') is not None:
            self.remark = m.get('remark')
        if m.get('sendActiveSms') is not None:
            self.send_active_sms = m.get('sendActiveSms')
        if m.get('seniorMode') is not None:
            self.senior_mode = m.get('seniorMode')
        if m.get('telephone') is not None:
            self.telephone = m.get('telephone')
        if m.get('title') is not None:
            self.title = m.get('title')
        if m.get('userid') is not None:
            self.userid = m.get('userid')
        if m.get('workPlace') is not None:
            self.work_place = m.get('workPlace')
        return self


class AddCollegeContactExclusiveResponseBodyResult(TeaModel):
    def __init__(
        self,
        create_result: int = None,
        union_id: str = None,
        userid: str = None,
    ):
        self.create_result = create_result
        self.union_id = union_id
        self.userid = userid

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.create_result is not None:
            result['createResult'] = self.create_result
        if self.union_id is not None:
            result['unionId'] = self.union_id
        if self.userid is not None:
            result['userid'] = self.userid
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('createResult') is not None:
            self.create_result = m.get('createResult')
        if m.get('unionId') is not None:
            self.union_id = m.get('unionId')
        if m.get('userid') is not None:
            self.userid = m.get('userid')
        return self


class AddCollegeContactExclusiveResponseBody(TeaModel):
    def __init__(
        self,
        result: AddCollegeContactExclusiveResponseBodyResult = None,
        success: bool = None,
    ):
        self.result = result
        self.success = success

    def validate(self):
        if self.result:
            self.result.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.result is not None:
            result['result'] = self.result.to_map()
        if self.success is not None:
            result['success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('result') is not None:
            temp_model = AddCollegeContactExclusiveResponseBodyResult()
            self.result = temp_model.from_map(m['result'])
        if m.get('success') is not None:
            self.success = m.get('success')
        return self


class AddCollegeContactExclusiveResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: AddCollegeContactExclusiveResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = AddCollegeContactExclusiveResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class AddCollegeContactUserHeaders(TeaModel):
    def __init__(
        self,
        common_headers: Dict[str, str] = None,
        x_acs_dingtalk_access_token: str = None,
    ):
        self.common_headers = common_headers
        self.x_acs_dingtalk_access_token = x_acs_dingtalk_access_token

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.common_headers is not None:
            result['commonHeaders'] = self.common_headers
        if self.x_acs_dingtalk_access_token is not None:
            result['x-acs-dingtalk-access-token'] = self.x_acs_dingtalk_access_token
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('commonHeaders') is not None:
            self.common_headers = m.get('commonHeaders')
        if m.get('x-acs-dingtalk-access-token') is not None:
            self.x_acs_dingtalk_access_token = m.get('x-acs-dingtalk-access-token')
        return self


class AddCollegeContactUserRequestDeptOrderList(TeaModel):
    def __init__(
        self,
        dept_id: int = None,
        order: int = None,
    ):
        self.dept_id = dept_id
        self.order = order

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dept_id is not None:
            result['deptId'] = self.dept_id
        if self.order is not None:
            result['order'] = self.order
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('deptId') is not None:
            self.dept_id = m.get('deptId')
        if m.get('order') is not None:
            self.order = m.get('order')
        return self


class AddCollegeContactUserRequestDeptPositionSet(TeaModel):
    def __init__(
        self,
        dept_id: int = None,
        manager_user_id: str = None,
        title: str = None,
        work_place: str = None,
    ):
        self.dept_id = dept_id
        self.manager_user_id = manager_user_id
        self.title = title
        self.work_place = work_place

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dept_id is not None:
            result['deptId'] = self.dept_id
        if self.manager_user_id is not None:
            result['managerUserId'] = self.manager_user_id
        if self.title is not None:
            result['title'] = self.title
        if self.work_place is not None:
            result['workPlace'] = self.work_place
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('deptId') is not None:
            self.dept_id = m.get('deptId')
        if m.get('managerUserId') is not None:
            self.manager_user_id = m.get('managerUserId')
        if m.get('title') is not None:
            self.title = m.get('title')
        if m.get('workPlace') is not None:
            self.work_place = m.get('workPlace')
        return self


class AddCollegeContactUserRequestDeptTitleList(TeaModel):
    def __init__(
        self,
        dept_id: int = None,
        title: str = None,
    ):
        self.dept_id = dept_id
        self.title = title

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dept_id is not None:
            result['deptId'] = self.dept_id
        if self.title is not None:
            result['title'] = self.title
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('deptId') is not None:
            self.dept_id = m.get('deptId')
        if m.get('title') is not None:
            self.title = m.get('title')
        return self


class AddCollegeContactUserRequest(TeaModel):
    def __init__(
        self,
        dept_id_list: List[int] = None,
        dept_order_list: List[AddCollegeContactUserRequestDeptOrderList] = None,
        dept_position_set: List[AddCollegeContactUserRequestDeptPositionSet] = None,
        dept_title_list: List[AddCollegeContactUserRequestDeptTitleList] = None,
        email: str = None,
        emp_type: str = None,
        extension: Dict[str, str] = None,
        hide_mobile: bool = None,
        hired_date: int = None,
        job_number: str = None,
        login_email: str = None,
        main_dept_id: int = None,
        manager_userid: str = None,
        mobile: str = None,
        name: str = None,
        org_email: str = None,
        org_email_type: str = None,
        remark: str = None,
        send_active_sms: bool = None,
        senior_mode: bool = None,
        telephone: str = None,
        title: str = None,
        userid: str = None,
        work_place: str = None,
    ):
        # This parameter is required.
        self.dept_id_list = dept_id_list
        self.dept_order_list = dept_order_list
        self.dept_position_set = dept_position_set
        self.dept_title_list = dept_title_list
        self.email = email
        # This parameter is required.
        self.emp_type = emp_type
        self.extension = extension
        self.hide_mobile = hide_mobile
        self.hired_date = hired_date
        self.job_number = job_number
        self.login_email = login_email
        # This parameter is required.
        self.main_dept_id = main_dept_id
        self.manager_userid = manager_userid
        # This parameter is required.
        self.mobile = mobile
        # This parameter is required.
        self.name = name
        self.org_email = org_email
        self.org_email_type = org_email_type
        self.remark = remark
        self.send_active_sms = send_active_sms
        self.senior_mode = senior_mode
        self.telephone = telephone
        self.title = title
        self.userid = userid
        self.work_place = work_place

    def validate(self):
        if self.dept_order_list:
            for k in self.dept_order_list:
                if k:
                    k.validate()
        if self.dept_position_set:
            for k in self.dept_position_set:
                if k:
                    k.validate()
        if self.dept_title_list:
            for k in self.dept_title_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dept_id_list is not None:
            result['deptIdList'] = self.dept_id_list
        result['deptOrderList'] = []
        if self.dept_order_list is not None:
            for k in self.dept_order_list:
                result['deptOrderList'].append(k.to_map() if k else None)
        result['deptPositionSet'] = []
        if self.dept_position_set is not None:
            for k in self.dept_position_set:
                result['deptPositionSet'].append(k.to_map() if k else None)
        result['deptTitleList'] = []
        if self.dept_title_list is not None:
            for k in self.dept_title_list:
                result['deptTitleList'].append(k.to_map() if k else None)
        if self.email is not None:
            result['email'] = self.email
        if self.emp_type is not None:
            result['empType'] = self.emp_type
        if self.extension is not None:
            result['extension'] = self.extension
        if self.hide_mobile is not None:
            result['hideMobile'] = self.hide_mobile
        if self.hired_date is not None:
            result['hiredDate'] = self.hired_date
        if self.job_number is not None:
            result['jobNumber'] = self.job_number
        if self.login_email is not None:
            result['loginEmail'] = self.login_email
        if self.main_dept_id is not None:
            result['mainDeptId'] = self.main_dept_id
        if self.manager_userid is not None:
            result['managerUserid'] = self.manager_userid
        if self.mobile is not None:
            result['mobile'] = self.mobile
        if self.name is not None:
            result['name'] = self.name
        if self.org_email is not None:
            result['orgEmail'] = self.org_email
        if self.org_email_type is not None:
            result['orgEmailType'] = self.org_email_type
        if self.remark is not None:
            result['remark'] = self.remark
        if self.send_active_sms is not None:
            result['sendActiveSms'] = self.send_active_sms
        if self.senior_mode is not None:
            result['seniorMode'] = self.senior_mode
        if self.telephone is not None:
            result['telephone'] = self.telephone
        if self.title is not None:
            result['title'] = self.title
        if self.userid is not None:
            result['userid'] = self.userid
        if self.work_place is not None:
            result['workPlace'] = self.work_place
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('deptIdList') is not None:
            self.dept_id_list = m.get('deptIdList')
        self.dept_order_list = []
        if m.get('deptOrderList') is not None:
            for k in m.get('deptOrderList'):
                temp_model = AddCollegeContactUserRequestDeptOrderList()
                self.dept_order_list.append(temp_model.from_map(k))
        self.dept_position_set = []
        if m.get('deptPositionSet') is not None:
            for k in m.get('deptPositionSet'):
                temp_model = AddCollegeContactUserRequestDeptPositionSet()
                self.dept_position_set.append(temp_model.from_map(k))
        self.dept_title_list = []
        if m.get('deptTitleList') is not None:
            for k in m.get('deptTitleList'):
                temp_model = AddCollegeContactUserRequestDeptTitleList()
                self.dept_title_list.append(temp_model.from_map(k))
        if m.get('email') is not None:
            self.email = m.get('email')
        if m.get('empType') is not None:
            self.emp_type = m.get('empType')
        if m.get('extension') is not None:
            self.extension = m.get('extension')
        if m.get('hideMobile') is not None:
            self.hide_mobile = m.get('hideMobile')
        if m.get('hiredDate') is not None:
            self.hired_date = m.get('hiredDate')
        if m.get('jobNumber') is not None:
            self.job_number = m.get('jobNumber')
        if m.get('loginEmail') is not None:
            self.login_email = m.get('loginEmail')
        if m.get('mainDeptId') is not None:
            self.main_dept_id = m.get('mainDeptId')
        if m.get('managerUserid') is not None:
            self.manager_userid = m.get('managerUserid')
        if m.get('mobile') is not None:
            self.mobile = m.get('mobile')
        if m.get('name') is not None:
            self.name = m.get('name')
        if m.get('orgEmail') is not None:
            self.org_email = m.get('orgEmail')
        if m.get('orgEmailType') is not None:
            self.org_email_type = m.get('orgEmailType')
        if m.get('remark') is not None:
            self.remark = m.get('remark')
        if m.get('sendActiveSms') is not None:
            self.send_active_sms = m.get('sendActiveSms')
        if m.get('seniorMode') is not None:
            self.senior_mode = m.get('seniorMode')
        if m.get('telephone') is not None:
            self.telephone = m.get('telephone')
        if m.get('title') is not None:
            self.title = m.get('title')
        if m.get('userid') is not None:
            self.userid = m.get('userid')
        if m.get('workPlace') is not None:
            self.work_place = m.get('workPlace')
        return self


class AddCollegeContactUserResponseBodyResult(TeaModel):
    def __init__(
        self,
        create_result: int = None,
        union_id: str = None,
        userid: str = None,
    ):
        self.create_result = create_result
        self.union_id = union_id
        self.userid = userid

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.create_result is not None:
            result['createResult'] = self.create_result
        if self.union_id is not None:
            result['unionId'] = self.union_id
        if self.userid is not None:
            result['userid'] = self.userid
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('createResult') is not None:
            self.create_result = m.get('createResult')
        if m.get('unionId') is not None:
            self.union_id = m.get('unionId')
        if m.get('userid') is not None:
            self.userid = m.get('userid')
        return self


class AddCollegeContactUserResponseBody(TeaModel):
    def __init__(
        self,
        result: AddCollegeContactUserResponseBodyResult = None,
        success: bool = None,
    ):
        self.result = result
        self.success = success

    def validate(self):
        if self.result:
            self.result.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.result is not None:
            result['result'] = self.result.to_map()
        if self.success is not None:
            result['success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('result') is not None:
            temp_model = AddCollegeContactUserResponseBodyResult()
            self.result = temp_model.from_map(m['result'])
        if m.get('success') is not None:
            self.success = m.get('success')
        return self


class AddCollegeContactUserResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: AddCollegeContactUserResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = AddCollegeContactUserResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class AddCompetitionRecordHeaders(TeaModel):
    def __init__(
        self,
        common_headers: Dict[str, str] = None,
        x_acs_dingtalk_access_token: str = None,
    ):
        self.common_headers = common_headers
        self.x_acs_dingtalk_access_token = x_acs_dingtalk_access_token

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.common_headers is not None:
            result['commonHeaders'] = self.common_headers
        if self.x_acs_dingtalk_access_token is not None:
            result['x-acs-dingtalk-access-token'] = self.x_acs_dingtalk_access_token
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('commonHeaders') is not None:
            self.common_headers = m.get('commonHeaders')
        if m.get('x-acs-dingtalk-access-token') is not None:
            self.x_acs_dingtalk_access_token = m.get('x-acs-dingtalk-access-token')
        return self


class AddCompetitionRecordRequest(TeaModel):
    def __init__(
        self,
        competition_code: str = None,
        group_template_code: str = None,
        join_group: bool = None,
        participant_name: str = None,
        union_id: str = None,
    ):
        self.competition_code = competition_code
        self.group_template_code = group_template_code
        self.join_group = join_group
        self.participant_name = participant_name
        self.union_id = union_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.competition_code is not None:
            result['competitionCode'] = self.competition_code
        if self.group_template_code is not None:
            result['groupTemplateCode'] = self.group_template_code
        if self.join_group is not None:
            result['joinGroup'] = self.join_group
        if self.participant_name is not None:
            result['participantName'] = self.participant_name
        if self.union_id is not None:
            result['unionId'] = self.union_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('competitionCode') is not None:
            self.competition_code = m.get('competitionCode')
        if m.get('groupTemplateCode') is not None:
            self.group_template_code = m.get('groupTemplateCode')
        if m.get('joinGroup') is not None:
            self.join_group = m.get('joinGroup')
        if m.get('participantName') is not None:
            self.participant_name = m.get('participantName')
        if m.get('unionId') is not None:
            self.union_id = m.get('unionId')
        return self


class AddCompetitionRecordResponseBody(TeaModel):
    def __init__(
        self,
        success: bool = None,
    ):
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.success is not None:
            result['success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('success') is not None:
            self.success = m.get('success')
        return self


class AddCompetitionRecordResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: AddCompetitionRecordResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = AddCompetitionRecordResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class AddDeviceHeaders(TeaModel):
    def __init__(
        self,
        common_headers: Dict[str, str] = None,
        x_acs_dingtalk_access_token: str = None,
    ):
        self.common_headers = common_headers
        self.x_acs_dingtalk_access_token = x_acs_dingtalk_access_token

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.common_headers is not None:
            result['commonHeaders'] = self.common_headers
        if self.x_acs_dingtalk_access_token is not None:
            result['x-acs-dingtalk-access-token'] = self.x_acs_dingtalk_access_token
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('commonHeaders') is not None:
            self.common_headers = m.get('commonHeaders')
        if m.get('x-acs-dingtalk-access-token') is not None:
            self.x_acs_dingtalk_access_token = m.get('x-acs-dingtalk-access-token')
        return self


class AddDeviceRequest(TeaModel):
    def __init__(
        self,
        merchant_id: str = None,
        model: str = None,
        name: str = None,
        scene: int = None,
        sn: str = None,
        status: int = None,
        type: int = None,
    ):
        # This parameter is required.
        self.merchant_id = merchant_id
        # This parameter is required.
        self.model = model
        # This parameter is required.
        self.name = name
        # This parameter is required.
        self.scene = scene
        # This parameter is required.
        self.sn = sn
        # This parameter is required.
        self.status = status
        # This parameter is required.
        self.type = type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.merchant_id is not None:
            result['merchantId'] = self.merchant_id
        if self.model is not None:
            result['model'] = self.model
        if self.name is not None:
            result['name'] = self.name
        if self.scene is not None:
            result['scene'] = self.scene
        if self.sn is not None:
            result['sn'] = self.sn
        if self.status is not None:
            result['status'] = self.status
        if self.type is not None:
            result['type'] = self.type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('merchantId') is not None:
            self.merchant_id = m.get('merchantId')
        if m.get('model') is not None:
            self.model = m.get('model')
        if m.get('name') is not None:
            self.name = m.get('name')
        if m.get('scene') is not None:
            self.scene = m.get('scene')
        if m.get('sn') is not None:
            self.sn = m.get('sn')
        if m.get('status') is not None:
            self.status = m.get('status')
        if m.get('type') is not None:
            self.type = m.get('type')
        return self


class AddDeviceResponseBody(TeaModel):
    def __init__(
        self,
        corp_id: str = None,
        id: int = None,
        merchant_id: str = None,
        sn: str = None,
        status: int = None,
    ):
        # This parameter is required.
        self.corp_id = corp_id
        # This parameter is required.
        self.id = id
        # This parameter is required.
        self.merchant_id = merchant_id
        # This parameter is required.
        self.sn = sn
        # This parameter is required.
        self.status = status

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.corp_id is not None:
            result['corpId'] = self.corp_id
        if self.id is not None:
            result['id'] = self.id
        if self.merchant_id is not None:
            result['merchantId'] = self.merchant_id
        if self.sn is not None:
            result['sn'] = self.sn
        if self.status is not None:
            result['status'] = self.status
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('corpId') is not None:
            self.corp_id = m.get('corpId')
        if m.get('id') is not None:
            self.id = m.get('id')
        if m.get('merchantId') is not None:
            self.merchant_id = m.get('merchantId')
        if m.get('sn') is not None:
            self.sn = m.get('sn')
        if m.get('status') is not None:
            self.status = m.get('status')
        return self


class AddDeviceResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: AddDeviceResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = AddDeviceResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class AddEvaluatePerformanceHeaders(TeaModel):
    def __init__(
        self,
        common_headers: Dict[str, str] = None,
        x_acs_dingtalk_access_token: str = None,
    ):
        self.common_headers = common_headers
        self.x_acs_dingtalk_access_token = x_acs_dingtalk_access_token

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.common_headers is not None:
            result['commonHeaders'] = self.common_headers
        if self.x_acs_dingtalk_access_token is not None:
            result['x-acs-dingtalk-access-token'] = self.x_acs_dingtalk_access_token
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('commonHeaders') is not None:
            self.common_headers = m.get('commonHeaders')
        if m.get('x-acs-dingtalk-access-token') is not None:
            self.x_acs_dingtalk_access_token = m.get('x-acs-dingtalk-access-token')
        return self


class AddEvaluatePerformanceRequestEvaluationData(TeaModel):
    def __init__(
        self,
        evaluation_content: str = None,
        event_time: str = None,
        id: str = None,
        student_id: str = None,
        teacher_id: str = None,
    ):
        self.evaluation_content = evaluation_content
        self.event_time = event_time
        self.id = id
        self.student_id = student_id
        self.teacher_id = teacher_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.evaluation_content is not None:
            result['evaluationContent'] = self.evaluation_content
        if self.event_time is not None:
            result['eventTime'] = self.event_time
        if self.id is not None:
            result['id'] = self.id
        if self.student_id is not None:
            result['studentId'] = self.student_id
        if self.teacher_id is not None:
            result['teacherId'] = self.teacher_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('evaluationContent') is not None:
            self.evaluation_content = m.get('evaluationContent')
        if m.get('eventTime') is not None:
            self.event_time = m.get('eventTime')
        if m.get('id') is not None:
            self.id = m.get('id')
        if m.get('studentId') is not None:
            self.student_id = m.get('studentId')
        if m.get('teacherId') is not None:
            self.teacher_id = m.get('teacherId')
        return self


class AddEvaluatePerformanceRequest(TeaModel):
    def __init__(
        self,
        evaluation_data: List[AddEvaluatePerformanceRequestEvaluationData] = None,
    ):
        self.evaluation_data = evaluation_data

    def validate(self):
        if self.evaluation_data:
            for k in self.evaluation_data:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['evaluationData'] = []
        if self.evaluation_data is not None:
            for k in self.evaluation_data:
                result['evaluationData'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.evaluation_data = []
        if m.get('evaluationData') is not None:
            for k in m.get('evaluationData'):
                temp_model = AddEvaluatePerformanceRequestEvaluationData()
                self.evaluation_data.append(temp_model.from_map(k))
        return self


class AddEvaluatePerformanceResponseBody(TeaModel):
    def __init__(
        self,
        success: bool = None,
    ):
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.success is not None:
            result['success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('success') is not None:
            self.success = m.get('success')
        return self


class AddEvaluatePerformanceResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: AddEvaluatePerformanceResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = AddEvaluatePerformanceResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class AddSchoolConfigHeaders(TeaModel):
    def __init__(
        self,
        common_headers: Dict[str, str] = None,
        x_acs_dingtalk_access_token: str = None,
    ):
        self.common_headers = common_headers
        self.x_acs_dingtalk_access_token = x_acs_dingtalk_access_token

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.common_headers is not None:
            result['commonHeaders'] = self.common_headers
        if self.x_acs_dingtalk_access_token is not None:
            result['x-acs-dingtalk-access-token'] = self.x_acs_dingtalk_access_token
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('commonHeaders') is not None:
            self.common_headers = m.get('commonHeaders')
        if m.get('x-acs-dingtalk-access-token') is not None:
            self.x_acs_dingtalk_access_token = m.get('x-acs-dingtalk-access-token')
        return self


class AddSchoolConfigRequest(TeaModel):
    def __init__(
        self,
        operator_id: str = None,
        operator_name: str = None,
        temperature_up_limit: int = None,
    ):
        # This parameter is required.
        self.operator_id = operator_id
        # This parameter is required.
        self.operator_name = operator_name
        # This parameter is required.
        self.temperature_up_limit = temperature_up_limit

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.operator_id is not None:
            result['operatorId'] = self.operator_id
        if self.operator_name is not None:
            result['operatorName'] = self.operator_name
        if self.temperature_up_limit is not None:
            result['temperatureUpLimit'] = self.temperature_up_limit
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('operatorId') is not None:
            self.operator_id = m.get('operatorId')
        if m.get('operatorName') is not None:
            self.operator_name = m.get('operatorName')
        if m.get('temperatureUpLimit') is not None:
            self.temperature_up_limit = m.get('temperatureUpLimit')
        return self


class AddSchoolConfigResponseBody(TeaModel):
    def __init__(
        self,
        result: bool = None,
    ):
        self.result = result

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.result is not None:
            result['result'] = self.result
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('result') is not None:
            self.result = m.get('result')
        return self


class AddSchoolConfigResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: AddSchoolConfigResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = AddSchoolConfigResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class AdjustCourseHeaders(TeaModel):
    def __init__(
        self,
        common_headers: Dict[str, str] = None,
        x_acs_dingtalk_access_token: str = None,
    ):
        self.common_headers = common_headers
        self.x_acs_dingtalk_access_token = x_acs_dingtalk_access_token

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.common_headers is not None:
            result['commonHeaders'] = self.common_headers
        if self.x_acs_dingtalk_access_token is not None:
            result['x-acs-dingtalk-access-token'] = self.x_acs_dingtalk_access_token
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('commonHeaders') is not None:
            self.common_headers = m.get('commonHeaders')
        if m.get('x-acs-dingtalk-access-token') is not None:
            self.x_acs_dingtalk_access_token = m.get('x-acs-dingtalk-access-token')
        return self


class AdjustCourseRequest(TeaModel):
    def __init__(
        self,
        attributes: str = None,
        class_name: str = None,
        class_room_id: str = None,
        class_room_name: str = None,
        class_type: int = None,
        corp_id: str = None,
        course_code: str = None,
        course_date: int = None,
        course_name: str = None,
        course_week: int = None,
        end_time: int = None,
        isv_code: str = None,
        isv_course_id: str = None,
        memo: str = None,
        school_year: str = None,
        semester: int = None,
        start_time: int = None,
        status: int = None,
        teach_week: int = None,
        timeslot_name: str = None,
        timeslot_num: int = None,
        type: int = None,
    ):
        self.attributes = attributes
        self.class_name = class_name
        self.class_room_id = class_room_id
        self.class_room_name = class_room_name
        self.class_type = class_type
        self.corp_id = corp_id
        self.course_code = course_code
        self.course_date = course_date
        self.course_name = course_name
        self.course_week = course_week
        self.end_time = end_time
        self.isv_code = isv_code
        self.isv_course_id = isv_course_id
        self.memo = memo
        self.school_year = school_year
        self.semester = semester
        self.start_time = start_time
        self.status = status
        self.teach_week = teach_week
        self.timeslot_name = timeslot_name
        self.timeslot_num = timeslot_num
        self.type = type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.attributes is not None:
            result['attributes'] = self.attributes
        if self.class_name is not None:
            result['className'] = self.class_name
        if self.class_room_id is not None:
            result['classRoomId'] = self.class_room_id
        if self.class_room_name is not None:
            result['classRoomName'] = self.class_room_name
        if self.class_type is not None:
            result['classType'] = self.class_type
        if self.corp_id is not None:
            result['corpId'] = self.corp_id
        if self.course_code is not None:
            result['courseCode'] = self.course_code
        if self.course_date is not None:
            result['courseDate'] = self.course_date
        if self.course_name is not None:
            result['courseName'] = self.course_name
        if self.course_week is not None:
            result['courseWeek'] = self.course_week
        if self.end_time is not None:
            result['endTime'] = self.end_time
        if self.isv_code is not None:
            result['isvCode'] = self.isv_code
        if self.isv_course_id is not None:
            result['isvCourseId'] = self.isv_course_id
        if self.memo is not None:
            result['memo'] = self.memo
        if self.school_year is not None:
            result['schoolYear'] = self.school_year
        if self.semester is not None:
            result['semester'] = self.semester
        if self.start_time is not None:
            result['startTime'] = self.start_time
        if self.status is not None:
            result['status'] = self.status
        if self.teach_week is not None:
            result['teachWeek'] = self.teach_week
        if self.timeslot_name is not None:
            result['timeslotName'] = self.timeslot_name
        if self.timeslot_num is not None:
            result['timeslotNum'] = self.timeslot_num
        if self.type is not None:
            result['type'] = self.type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('attributes') is not None:
            self.attributes = m.get('attributes')
        if m.get('className') is not None:
            self.class_name = m.get('className')
        if m.get('classRoomId') is not None:
            self.class_room_id = m.get('classRoomId')
        if m.get('classRoomName') is not None:
            self.class_room_name = m.get('classRoomName')
        if m.get('classType') is not None:
            self.class_type = m.get('classType')
        if m.get('corpId') is not None:
            self.corp_id = m.get('corpId')
        if m.get('courseCode') is not None:
            self.course_code = m.get('courseCode')
        if m.get('courseDate') is not None:
            self.course_date = m.get('courseDate')
        if m.get('courseName') is not None:
            self.course_name = m.get('courseName')
        if m.get('courseWeek') is not None:
            self.course_week = m.get('courseWeek')
        if m.get('endTime') is not None:
            self.end_time = m.get('endTime')
        if m.get('isvCode') is not None:
            self.isv_code = m.get('isvCode')
        if m.get('isvCourseId') is not None:
            self.isv_course_id = m.get('isvCourseId')
        if m.get('memo') is not None:
            self.memo = m.get('memo')
        if m.get('schoolYear') is not None:
            self.school_year = m.get('schoolYear')
        if m.get('semester') is not None:
            self.semester = m.get('semester')
        if m.get('startTime') is not None:
            self.start_time = m.get('startTime')
        if m.get('status') is not None:
            self.status = m.get('status')
        if m.get('teachWeek') is not None:
            self.teach_week = m.get('teachWeek')
        if m.get('timeslotName') is not None:
            self.timeslot_name = m.get('timeslotName')
        if m.get('timeslotNum') is not None:
            self.timeslot_num = m.get('timeslotNum')
        if m.get('type') is not None:
            self.type = m.get('type')
        return self


class AdjustCourseResponseBody(TeaModel):
    def __init__(
        self,
        result: int = None,
        success: bool = None,
    ):
        self.result = result
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.result is not None:
            result['result'] = self.result
        if self.success is not None:
            result['success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('result') is not None:
            self.result = m.get('result')
        if m.get('success') is not None:
            self.success = m.get('success')
        return self


class AdjustCourseResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: AdjustCourseResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = AdjustCourseResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class AdjustKitHeaders(TeaModel):
    def __init__(
        self,
        common_headers: Dict[str, str] = None,
        x_acs_dingtalk_access_token: str = None,
    ):
        self.common_headers = common_headers
        self.x_acs_dingtalk_access_token = x_acs_dingtalk_access_token

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.common_headers is not None:
            result['commonHeaders'] = self.common_headers
        if self.x_acs_dingtalk_access_token is not None:
            result['x-acs-dingtalk-access-token'] = self.x_acs_dingtalk_access_token
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('commonHeaders') is not None:
            self.common_headers = m.get('commonHeaders')
        if m.get('x-acs-dingtalk-access-token') is not None:
            self.x_acs_dingtalk_access_token = m.get('x-acs-dingtalk-access-token')
        return self


class AdjustKitRequest(TeaModel):
    def __init__(
        self,
        attributes: str = None,
        corp_id: str = None,
        isv_code: str = None,
        isv_product_scene: str = None,
        open_end_time: int = None,
        open_start_time: int = None,
        open_user_id: str = None,
    ):
        self.attributes = attributes
        self.corp_id = corp_id
        self.isv_code = isv_code
        self.isv_product_scene = isv_product_scene
        self.open_end_time = open_end_time
        self.open_start_time = open_start_time
        self.open_user_id = open_user_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.attributes is not None:
            result['attributes'] = self.attributes
        if self.corp_id is not None:
            result['corpId'] = self.corp_id
        if self.isv_code is not None:
            result['isvCode'] = self.isv_code
        if self.isv_product_scene is not None:
            result['isvProductScene'] = self.isv_product_scene
        if self.open_end_time is not None:
            result['openEndTime'] = self.open_end_time
        if self.open_start_time is not None:
            result['openStartTime'] = self.open_start_time
        if self.open_user_id is not None:
            result['openUserId'] = self.open_user_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('attributes') is not None:
            self.attributes = m.get('attributes')
        if m.get('corpId') is not None:
            self.corp_id = m.get('corpId')
        if m.get('isvCode') is not None:
            self.isv_code = m.get('isvCode')
        if m.get('isvProductScene') is not None:
            self.isv_product_scene = m.get('isvProductScene')
        if m.get('openEndTime') is not None:
            self.open_end_time = m.get('openEndTime')
        if m.get('openStartTime') is not None:
            self.open_start_time = m.get('openStartTime')
        if m.get('openUserId') is not None:
            self.open_user_id = m.get('openUserId')
        return self


class AdjustKitResponseBody(TeaModel):
    def __init__(
        self,
        result: int = None,
        success: bool = None,
    ):
        self.result = result
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.result is not None:
            result['result'] = self.result
        if self.success is not None:
            result['success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('result') is not None:
            self.result = m.get('result')
        if m.get('success') is not None:
            self.success = m.get('success')
        return self


class AdjustKitResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: AdjustKitResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = AdjustKitResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class AssignClassHeaders(TeaModel):
    def __init__(
        self,
        common_headers: Dict[str, str] = None,
        x_acs_dingtalk_access_token: str = None,
    ):
        self.common_headers = common_headers
        self.x_acs_dingtalk_access_token = x_acs_dingtalk_access_token

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.common_headers is not None:
            result['commonHeaders'] = self.common_headers
        if self.x_acs_dingtalk_access_token is not None:
            result['x-acs-dingtalk-access-token'] = self.x_acs_dingtalk_access_token
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('commonHeaders') is not None:
            self.common_headers = m.get('commonHeaders')
        if m.get('x-acs-dingtalk-access-token') is not None:
            self.x_acs_dingtalk_access_token = m.get('x-acs-dingtalk-access-token')
        return self


class AssignClassRequest(TeaModel):
    def __init__(
        self,
        class_id: int = None,
        is_finish: bool = None,
        operator: str = None,
        student_id: int = None,
        task_id: int = None,
    ):
        # This parameter is required.
        self.class_id = class_id
        self.is_finish = is_finish
        # This parameter is required.
        self.operator = operator
        # This parameter is required.
        self.student_id = student_id
        # This parameter is required.
        self.task_id = task_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.class_id is not None:
            result['classId'] = self.class_id
        if self.is_finish is not None:
            result['isFinish'] = self.is_finish
        if self.operator is not None:
            result['operator'] = self.operator
        if self.student_id is not None:
            result['studentId'] = self.student_id
        if self.task_id is not None:
            result['taskId'] = self.task_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('classId') is not None:
            self.class_id = m.get('classId')
        if m.get('isFinish') is not None:
            self.is_finish = m.get('isFinish')
        if m.get('operator') is not None:
            self.operator = m.get('operator')
        if m.get('studentId') is not None:
            self.student_id = m.get('studentId')
        if m.get('taskId') is not None:
            self.task_id = m.get('taskId')
        return self


class AssignClassResponseBody(TeaModel):
    def __init__(
        self,
        success: bool = None,
    ):
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.success is not None:
            result['success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('success') is not None:
            self.success = m.get('success')
        return self


class AssignClassResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: AssignClassResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = AssignClassResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class BatchCreateHeaders(TeaModel):
    def __init__(
        self,
        common_headers: Dict[str, str] = None,
        x_acs_dingtalk_access_token: str = None,
    ):
        self.common_headers = common_headers
        self.x_acs_dingtalk_access_token = x_acs_dingtalk_access_token

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.common_headers is not None:
            result['commonHeaders'] = self.common_headers
        if self.x_acs_dingtalk_access_token is not None:
            result['x-acs-dingtalk-access-token'] = self.x_acs_dingtalk_access_token
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('commonHeaders') is not None:
            self.common_headers = m.get('commonHeaders')
        if m.get('x-acs-dingtalk-access-token') is not None:
            self.x_acs_dingtalk_access_token = m.get('x-acs-dingtalk-access-token')
        return self


class BatchCreateRequestDataCardRuleItemParamList(TeaModel):
    def __init__(
        self,
        card_rule_attr: str = None,
        card_task_code: str = None,
        daily_dubbing: int = None,
        relation_id: str = None,
        relation_title: str = None,
        relation_url: str = None,
    ):
        self.card_rule_attr = card_rule_attr
        self.card_task_code = card_task_code
        self.daily_dubbing = daily_dubbing
        self.relation_id = relation_id
        self.relation_title = relation_title
        self.relation_url = relation_url

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.card_rule_attr is not None:
            result['cardRuleAttr'] = self.card_rule_attr
        if self.card_task_code is not None:
            result['cardTaskCode'] = self.card_task_code
        if self.daily_dubbing is not None:
            result['dailyDubbing'] = self.daily_dubbing
        if self.relation_id is not None:
            result['relationId'] = self.relation_id
        if self.relation_title is not None:
            result['relationTitle'] = self.relation_title
        if self.relation_url is not None:
            result['relationUrl'] = self.relation_url
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('cardRuleAttr') is not None:
            self.card_rule_attr = m.get('cardRuleAttr')
        if m.get('cardTaskCode') is not None:
            self.card_task_code = m.get('cardTaskCode')
        if m.get('dailyDubbing') is not None:
            self.daily_dubbing = m.get('dailyDubbing')
        if m.get('relationId') is not None:
            self.relation_id = m.get('relationId')
        if m.get('relationTitle') is not None:
            self.relation_title = m.get('relationTitle')
        if m.get('relationUrl') is not None:
            self.relation_url = m.get('relationUrl')
        return self


class BatchCreateRequestDataOrgClassStudentGroupListClassListStudents(TeaModel):
    def __init__(
        self,
        name: str = None,
        staff_id: str = None,
    ):
        self.name = name
        self.staff_id = staff_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.name is not None:
            result['name'] = self.name
        if self.staff_id is not None:
            result['staffId'] = self.staff_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('name') is not None:
            self.name = m.get('name')
        if m.get('staffId') is not None:
            self.staff_id = m.get('staffId')
        return self


class BatchCreateRequestDataOrgClassStudentGroupListClassList(TeaModel):
    def __init__(
        self,
        class_id: int = None,
        class_name: str = None,
        students: List[BatchCreateRequestDataOrgClassStudentGroupListClassListStudents] = None,
    ):
        self.class_id = class_id
        self.class_name = class_name
        self.students = students

    def validate(self):
        if self.students:
            for k in self.students:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.class_id is not None:
            result['classId'] = self.class_id
        if self.class_name is not None:
            result['className'] = self.class_name
        result['students'] = []
        if self.students is not None:
            for k in self.students:
                result['students'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('classId') is not None:
            self.class_id = m.get('classId')
        if m.get('className') is not None:
            self.class_name = m.get('className')
        self.students = []
        if m.get('students') is not None:
            for k in m.get('students'):
                temp_model = BatchCreateRequestDataOrgClassStudentGroupListClassListStudents()
                self.students.append(temp_model.from_map(k))
        return self


class BatchCreateRequestDataOrgClassStudentGroupList(TeaModel):
    def __init__(
        self,
        class_list: List[BatchCreateRequestDataOrgClassStudentGroupListClassList] = None,
        corp_id: str = None,
    ):
        self.class_list = class_list
        self.corp_id = corp_id

    def validate(self):
        if self.class_list:
            for k in self.class_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['classList'] = []
        if self.class_list is not None:
            for k in self.class_list:
                result['classList'].append(k.to_map() if k else None)
        if self.corp_id is not None:
            result['corpId'] = self.corp_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.class_list = []
        if m.get('classList') is not None:
            for k in m.get('classList'):
                temp_model = BatchCreateRequestDataOrgClassStudentGroupListClassList()
                self.class_list.append(temp_model.from_map(k))
        if m.get('corpId') is not None:
            self.corp_id = m.get('corpId')
        return self


class BatchCreateRequestData(TeaModel):
    def __init__(
        self,
        can_reissue_card: bool = None,
        card_cycle: int = None,
        card_frequency: List[int] = None,
        card_rule_item_param_list: List[BatchCreateRequestDataCardRuleItemParamList] = None,
        class_ids: List[str] = None,
        class_names: List[str] = None,
        content: str = None,
        effect_date: int = None,
        medias: str = None,
        need_metering: str = None,
        org_class_student_group_list: List[BatchCreateRequestDataOrgClassStudentGroupList] = None,
        remind_hour: int = None,
        remind_minute: int = None,
        target_role: str = None,
        template_id: int = None,
        title: str = None,
        unit_of_measurement: str = None,
    ):
        self.can_reissue_card = can_reissue_card
        self.card_cycle = card_cycle
        # This parameter is required.
        self.card_frequency = card_frequency
        # This parameter is required.
        self.card_rule_item_param_list = card_rule_item_param_list
        self.class_ids = class_ids
        self.class_names = class_names
        # This parameter is required.
        self.content = content
        self.effect_date = effect_date
        self.medias = medias
        self.need_metering = need_metering
        # This parameter is required.
        self.org_class_student_group_list = org_class_student_group_list
        # This parameter is required.
        self.remind_hour = remind_hour
        # This parameter is required.
        self.remind_minute = remind_minute
        self.target_role = target_role
        self.template_id = template_id
        # This parameter is required.
        self.title = title
        self.unit_of_measurement = unit_of_measurement

    def validate(self):
        if self.card_rule_item_param_list:
            for k in self.card_rule_item_param_list:
                if k:
                    k.validate()
        if self.org_class_student_group_list:
            for k in self.org_class_student_group_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.can_reissue_card is not None:
            result['canReissueCard'] = self.can_reissue_card
        if self.card_cycle is not None:
            result['cardCycle'] = self.card_cycle
        if self.card_frequency is not None:
            result['cardFrequency'] = self.card_frequency
        result['cardRuleItemParamList'] = []
        if self.card_rule_item_param_list is not None:
            for k in self.card_rule_item_param_list:
                result['cardRuleItemParamList'].append(k.to_map() if k else None)
        if self.class_ids is not None:
            result['classIds'] = self.class_ids
        if self.class_names is not None:
            result['classNames'] = self.class_names
        if self.content is not None:
            result['content'] = self.content
        if self.effect_date is not None:
            result['effectDate'] = self.effect_date
        if self.medias is not None:
            result['medias'] = self.medias
        if self.need_metering is not None:
            result['needMetering'] = self.need_metering
        result['orgClassStudentGroupList'] = []
        if self.org_class_student_group_list is not None:
            for k in self.org_class_student_group_list:
                result['orgClassStudentGroupList'].append(k.to_map() if k else None)
        if self.remind_hour is not None:
            result['remindHour'] = self.remind_hour
        if self.remind_minute is not None:
            result['remindMinute'] = self.remind_minute
        if self.target_role is not None:
            result['targetRole'] = self.target_role
        if self.template_id is not None:
            result['templateId'] = self.template_id
        if self.title is not None:
            result['title'] = self.title
        if self.unit_of_measurement is not None:
            result['unitOfMeasurement'] = self.unit_of_measurement
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('canReissueCard') is not None:
            self.can_reissue_card = m.get('canReissueCard')
        if m.get('cardCycle') is not None:
            self.card_cycle = m.get('cardCycle')
        if m.get('cardFrequency') is not None:
            self.card_frequency = m.get('cardFrequency')
        self.card_rule_item_param_list = []
        if m.get('cardRuleItemParamList') is not None:
            for k in m.get('cardRuleItemParamList'):
                temp_model = BatchCreateRequestDataCardRuleItemParamList()
                self.card_rule_item_param_list.append(temp_model.from_map(k))
        if m.get('classIds') is not None:
            self.class_ids = m.get('classIds')
        if m.get('classNames') is not None:
            self.class_names = m.get('classNames')
        if m.get('content') is not None:
            self.content = m.get('content')
        if m.get('effectDate') is not None:
            self.effect_date = m.get('effectDate')
        if m.get('medias') is not None:
            self.medias = m.get('medias')
        if m.get('needMetering') is not None:
            self.need_metering = m.get('needMetering')
        self.org_class_student_group_list = []
        if m.get('orgClassStudentGroupList') is not None:
            for k in m.get('orgClassStudentGroupList'):
                temp_model = BatchCreateRequestDataOrgClassStudentGroupList()
                self.org_class_student_group_list.append(temp_model.from_map(k))
        if m.get('remindHour') is not None:
            self.remind_hour = m.get('remindHour')
        if m.get('remindMinute') is not None:
            self.remind_minute = m.get('remindMinute')
        if m.get('targetRole') is not None:
            self.target_role = m.get('targetRole')
        if m.get('templateId') is not None:
            self.template_id = m.get('templateId')
        if m.get('title') is not None:
            self.title = m.get('title')
        if m.get('unitOfMeasurement') is not None:
            self.unit_of_measurement = m.get('unitOfMeasurement')
        return self


class BatchCreateRequest(TeaModel):
    def __init__(
        self,
        card_biz_code: str = None,
        data: BatchCreateRequestData = None,
        identifier: str = None,
        js_version: int = None,
        source_type: str = None,
        userid: str = None,
    ):
        # This parameter is required.
        self.card_biz_code = card_biz_code
        # This parameter is required.
        self.data = data
        # This parameter is required.
        self.identifier = identifier
        # This parameter is required.
        self.js_version = js_version
        # This parameter is required.
        self.source_type = source_type
        self.userid = userid

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.card_biz_code is not None:
            result['cardBizCode'] = self.card_biz_code
        if self.data is not None:
            result['data'] = self.data.to_map()
        if self.identifier is not None:
            result['identifier'] = self.identifier
        if self.js_version is not None:
            result['jsVersion'] = self.js_version
        if self.source_type is not None:
            result['sourceType'] = self.source_type
        if self.userid is not None:
            result['userid'] = self.userid
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('cardBizCode') is not None:
            self.card_biz_code = m.get('cardBizCode')
        if m.get('data') is not None:
            temp_model = BatchCreateRequestData()
            self.data = temp_model.from_map(m['data'])
        if m.get('identifier') is not None:
            self.identifier = m.get('identifier')
        if m.get('jsVersion') is not None:
            self.js_version = m.get('jsVersion')
        if m.get('sourceType') is not None:
            self.source_type = m.get('sourceType')
        if m.get('userid') is not None:
            self.userid = m.get('userid')
        return self


class BatchCreateResponseBodyResult(TeaModel):
    def __init__(
        self,
        corp_id_card_id_map: Dict[str, str] = None,
    ):
        self.corp_id_card_id_map = corp_id_card_id_map

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.corp_id_card_id_map is not None:
            result['corpIdCardIdMap'] = self.corp_id_card_id_map
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('corpIdCardIdMap') is not None:
            self.corp_id_card_id_map = m.get('corpIdCardIdMap')
        return self


class BatchCreateResponseBody(TeaModel):
    def __init__(
        self,
        result: BatchCreateResponseBodyResult = None,
    ):
        self.result = result

    def validate(self):
        if self.result:
            self.result.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.result is not None:
            result['result'] = self.result.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('result') is not None:
            temp_model = BatchCreateResponseBodyResult()
            self.result = temp_model.from_map(m['result'])
        return self


class BatchCreateResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: BatchCreateResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = BatchCreateResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class BatchCreateCourseHeaders(TeaModel):
    def __init__(
        self,
        common_headers: Dict[str, str] = None,
        x_acs_dingtalk_access_token: str = None,
    ):
        self.common_headers = common_headers
        self.x_acs_dingtalk_access_token = x_acs_dingtalk_access_token

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.common_headers is not None:
            result['commonHeaders'] = self.common_headers
        if self.x_acs_dingtalk_access_token is not None:
            result['x-acs-dingtalk-access-token'] = self.x_acs_dingtalk_access_token
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('commonHeaders') is not None:
            self.common_headers = m.get('commonHeaders')
        if m.get('x-acs-dingtalk-access-token') is not None:
            self.x_acs_dingtalk_access_token = m.get('x-acs-dingtalk-access-token')
        return self


class BatchCreateCourseRequestCourseDetailItemListTeacherList(TeaModel):
    def __init__(
        self,
        teacher_name: str = None,
        teacher_user_id: str = None,
    ):
        self.teacher_name = teacher_name
        self.teacher_user_id = teacher_user_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.teacher_name is not None:
            result['teacherName'] = self.teacher_name
        if self.teacher_user_id is not None:
            result['teacherUserId'] = self.teacher_user_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('teacherName') is not None:
            self.teacher_name = m.get('teacherName')
        if m.get('teacherUserId') is not None:
            self.teacher_user_id = m.get('teacherUserId')
        return self


class BatchCreateCourseRequestCourseDetailItemList(TeaModel):
    def __init__(
        self,
        attributes: str = None,
        class_room_id: str = None,
        class_room_name: str = None,
        course_code: str = None,
        course_date: int = None,
        course_name: str = None,
        course_week: int = None,
        end_time: int = None,
        isv_course_id: str = None,
        memo: str = None,
        start_time: int = None,
        status: int = None,
        teach_week: int = None,
        teacher_list: List[BatchCreateCourseRequestCourseDetailItemListTeacherList] = None,
        timeslot_name: str = None,
        timeslot_num: int = None,
        type: int = None,
    ):
        self.attributes = attributes
        self.class_room_id = class_room_id
        self.class_room_name = class_room_name
        self.course_code = course_code
        self.course_date = course_date
        self.course_name = course_name
        self.course_week = course_week
        self.end_time = end_time
        self.isv_course_id = isv_course_id
        self.memo = memo
        self.start_time = start_time
        self.status = status
        self.teach_week = teach_week
        self.teacher_list = teacher_list
        self.timeslot_name = timeslot_name
        self.timeslot_num = timeslot_num
        self.type = type

    def validate(self):
        if self.teacher_list:
            for k in self.teacher_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.attributes is not None:
            result['attributes'] = self.attributes
        if self.class_room_id is not None:
            result['classRoomId'] = self.class_room_id
        if self.class_room_name is not None:
            result['classRoomName'] = self.class_room_name
        if self.course_code is not None:
            result['courseCode'] = self.course_code
        if self.course_date is not None:
            result['courseDate'] = self.course_date
        if self.course_name is not None:
            result['courseName'] = self.course_name
        if self.course_week is not None:
            result['courseWeek'] = self.course_week
        if self.end_time is not None:
            result['endTime'] = self.end_time
        if self.isv_course_id is not None:
            result['isvCourseId'] = self.isv_course_id
        if self.memo is not None:
            result['memo'] = self.memo
        if self.start_time is not None:
            result['startTime'] = self.start_time
        if self.status is not None:
            result['status'] = self.status
        if self.teach_week is not None:
            result['teachWeek'] = self.teach_week
        result['teacherList'] = []
        if self.teacher_list is not None:
            for k in self.teacher_list:
                result['teacherList'].append(k.to_map() if k else None)
        if self.timeslot_name is not None:
            result['timeslotName'] = self.timeslot_name
        if self.timeslot_num is not None:
            result['timeslotNum'] = self.timeslot_num
        if self.type is not None:
            result['type'] = self.type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('attributes') is not None:
            self.attributes = m.get('attributes')
        if m.get('classRoomId') is not None:
            self.class_room_id = m.get('classRoomId')
        if m.get('classRoomName') is not None:
            self.class_room_name = m.get('classRoomName')
        if m.get('courseCode') is not None:
            self.course_code = m.get('courseCode')
        if m.get('courseDate') is not None:
            self.course_date = m.get('courseDate')
        if m.get('courseName') is not None:
            self.course_name = m.get('courseName')
        if m.get('courseWeek') is not None:
            self.course_week = m.get('courseWeek')
        if m.get('endTime') is not None:
            self.end_time = m.get('endTime')
        if m.get('isvCourseId') is not None:
            self.isv_course_id = m.get('isvCourseId')
        if m.get('memo') is not None:
            self.memo = m.get('memo')
        if m.get('startTime') is not None:
            self.start_time = m.get('startTime')
        if m.get('status') is not None:
            self.status = m.get('status')
        if m.get('teachWeek') is not None:
            self.teach_week = m.get('teachWeek')
        self.teacher_list = []
        if m.get('teacherList') is not None:
            for k in m.get('teacherList'):
                temp_model = BatchCreateCourseRequestCourseDetailItemListTeacherList()
                self.teacher_list.append(temp_model.from_map(k))
        if m.get('timeslotName') is not None:
            self.timeslot_name = m.get('timeslotName')
        if m.get('timeslotNum') is not None:
            self.timeslot_num = m.get('timeslotNum')
        if m.get('type') is not None:
            self.type = m.get('type')
        return self


class BatchCreateCourseRequest(TeaModel):
    def __init__(
        self,
        class_id: str = None,
        class_name: str = None,
        class_type: int = None,
        corp_id: str = None,
        course_detail_item_list: List[BatchCreateCourseRequestCourseDetailItemList] = None,
        isv_code: str = None,
        school_year: str = None,
        semester: int = None,
    ):
        self.class_id = class_id
        self.class_name = class_name
        self.class_type = class_type
        self.corp_id = corp_id
        self.course_detail_item_list = course_detail_item_list
        self.isv_code = isv_code
        self.school_year = school_year
        self.semester = semester

    def validate(self):
        if self.course_detail_item_list:
            for k in self.course_detail_item_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.class_id is not None:
            result['classId'] = self.class_id
        if self.class_name is not None:
            result['className'] = self.class_name
        if self.class_type is not None:
            result['classType'] = self.class_type
        if self.corp_id is not None:
            result['corpId'] = self.corp_id
        result['courseDetailItemList'] = []
        if self.course_detail_item_list is not None:
            for k in self.course_detail_item_list:
                result['courseDetailItemList'].append(k.to_map() if k else None)
        if self.isv_code is not None:
            result['isvCode'] = self.isv_code
        if self.school_year is not None:
            result['schoolYear'] = self.school_year
        if self.semester is not None:
            result['semester'] = self.semester
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('classId') is not None:
            self.class_id = m.get('classId')
        if m.get('className') is not None:
            self.class_name = m.get('className')
        if m.get('classType') is not None:
            self.class_type = m.get('classType')
        if m.get('corpId') is not None:
            self.corp_id = m.get('corpId')
        self.course_detail_item_list = []
        if m.get('courseDetailItemList') is not None:
            for k in m.get('courseDetailItemList'):
                temp_model = BatchCreateCourseRequestCourseDetailItemList()
                self.course_detail_item_list.append(temp_model.from_map(k))
        if m.get('isvCode') is not None:
            self.isv_code = m.get('isvCode')
        if m.get('schoolYear') is not None:
            self.school_year = m.get('schoolYear')
        if m.get('semester') is not None:
            self.semester = m.get('semester')
        return self


class BatchCreateCourseResponseBody(TeaModel):
    def __init__(
        self,
        result: bool = None,
        success: bool = None,
    ):
        self.result = result
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.result is not None:
            result['result'] = self.result
        if self.success is not None:
            result['success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('result') is not None:
            self.result = m.get('result')
        if m.get('success') is not None:
            self.success = m.get('success')
        return self


class BatchCreateCourseResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: BatchCreateCourseResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = BatchCreateCourseResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class BatchCreateStudentClassHeaders(TeaModel):
    def __init__(
        self,
        common_headers: Dict[str, str] = None,
        x_acs_dingtalk_access_token: str = None,
    ):
        self.common_headers = common_headers
        self.x_acs_dingtalk_access_token = x_acs_dingtalk_access_token

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.common_headers is not None:
            result['commonHeaders'] = self.common_headers
        if self.x_acs_dingtalk_access_token is not None:
            result['x-acs-dingtalk-access-token'] = self.x_acs_dingtalk_access_token
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('commonHeaders') is not None:
            self.common_headers = m.get('commonHeaders')
        if m.get('x-acs-dingtalk-access-token') is not None:
            self.x_acs_dingtalk_access_token = m.get('x-acs-dingtalk-access-token')
        return self


class BatchCreateStudentClassRequestStudentList(TeaModel):
    def __init__(
        self,
        attributes: str = None,
        student_name: str = None,
        student_user_id: str = None,
    ):
        self.attributes = attributes
        self.student_name = student_name
        self.student_user_id = student_user_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.attributes is not None:
            result['attributes'] = self.attributes
        if self.student_name is not None:
            result['studentName'] = self.student_name
        if self.student_user_id is not None:
            result['studentUserId'] = self.student_user_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('attributes') is not None:
            self.attributes = m.get('attributes')
        if m.get('studentName') is not None:
            self.student_name = m.get('studentName')
        if m.get('studentUserId') is not None:
            self.student_user_id = m.get('studentUserId')
        return self


class BatchCreateStudentClassRequest(TeaModel):
    def __init__(
        self,
        class_id: str = None,
        class_name: str = None,
        class_type: int = None,
        corp_id: str = None,
        isv_code: str = None,
        student_list: List[BatchCreateStudentClassRequestStudentList] = None,
    ):
        self.class_id = class_id
        self.class_name = class_name
        self.class_type = class_type
        self.corp_id = corp_id
        self.isv_code = isv_code
        self.student_list = student_list

    def validate(self):
        if self.student_list:
            for k in self.student_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.class_id is not None:
            result['classId'] = self.class_id
        if self.class_name is not None:
            result['className'] = self.class_name
        if self.class_type is not None:
            result['classType'] = self.class_type
        if self.corp_id is not None:
            result['corpId'] = self.corp_id
        if self.isv_code is not None:
            result['isvCode'] = self.isv_code
        result['studentList'] = []
        if self.student_list is not None:
            for k in self.student_list:
                result['studentList'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('classId') is not None:
            self.class_id = m.get('classId')
        if m.get('className') is not None:
            self.class_name = m.get('className')
        if m.get('classType') is not None:
            self.class_type = m.get('classType')
        if m.get('corpId') is not None:
            self.corp_id = m.get('corpId')
        if m.get('isvCode') is not None:
            self.isv_code = m.get('isvCode')
        self.student_list = []
        if m.get('studentList') is not None:
            for k in m.get('studentList'):
                temp_model = BatchCreateStudentClassRequestStudentList()
                self.student_list.append(temp_model.from_map(k))
        return self


class BatchCreateStudentClassResponseBody(TeaModel):
    def __init__(
        self,
        result: bool = None,
        success: bool = None,
    ):
        self.result = result
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.result is not None:
            result['result'] = self.result
        if self.success is not None:
            result['success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('result') is not None:
            self.result = m.get('result')
        if m.get('success') is not None:
            self.success = m.get('success')
        return self


class BatchCreateStudentClassResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: BatchCreateStudentClassResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = BatchCreateStudentClassResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class BatchCreateTeacherCourseHeaders(TeaModel):
    def __init__(
        self,
        common_headers: Dict[str, str] = None,
        x_acs_dingtalk_access_token: str = None,
    ):
        self.common_headers = common_headers
        self.x_acs_dingtalk_access_token = x_acs_dingtalk_access_token

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.common_headers is not None:
            result['commonHeaders'] = self.common_headers
        if self.x_acs_dingtalk_access_token is not None:
            result['x-acs-dingtalk-access-token'] = self.x_acs_dingtalk_access_token
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('commonHeaders') is not None:
            self.common_headers = m.get('commonHeaders')
        if m.get('x-acs-dingtalk-access-token') is not None:
            self.x_acs_dingtalk_access_token = m.get('x-acs-dingtalk-access-token')
        return self


class BatchCreateTeacherCourseRequestTeacherCourseDetailItemList(TeaModel):
    def __init__(
        self,
        attributes: str = None,
        isv_course_id: str = None,
    ):
        self.attributes = attributes
        self.isv_course_id = isv_course_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.attributes is not None:
            result['attributes'] = self.attributes
        if self.isv_course_id is not None:
            result['isvCourseId'] = self.isv_course_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('attributes') is not None:
            self.attributes = m.get('attributes')
        if m.get('isvCourseId') is not None:
            self.isv_course_id = m.get('isvCourseId')
        return self


class BatchCreateTeacherCourseRequest(TeaModel):
    def __init__(
        self,
        corp_id: str = None,
        isv_code: str = None,
        teacher_course_detail_item_list: List[BatchCreateTeacherCourseRequestTeacherCourseDetailItemList] = None,
        teacher_name: str = None,
        teacher_user_id: str = None,
    ):
        self.corp_id = corp_id
        self.isv_code = isv_code
        self.teacher_course_detail_item_list = teacher_course_detail_item_list
        self.teacher_name = teacher_name
        self.teacher_user_id = teacher_user_id

    def validate(self):
        if self.teacher_course_detail_item_list:
            for k in self.teacher_course_detail_item_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.corp_id is not None:
            result['corpId'] = self.corp_id
        if self.isv_code is not None:
            result['isvCode'] = self.isv_code
        result['teacherCourseDetailItemList'] = []
        if self.teacher_course_detail_item_list is not None:
            for k in self.teacher_course_detail_item_list:
                result['teacherCourseDetailItemList'].append(k.to_map() if k else None)
        if self.teacher_name is not None:
            result['teacherName'] = self.teacher_name
        if self.teacher_user_id is not None:
            result['teacherUserId'] = self.teacher_user_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('corpId') is not None:
            self.corp_id = m.get('corpId')
        if m.get('isvCode') is not None:
            self.isv_code = m.get('isvCode')
        self.teacher_course_detail_item_list = []
        if m.get('teacherCourseDetailItemList') is not None:
            for k in m.get('teacherCourseDetailItemList'):
                temp_model = BatchCreateTeacherCourseRequestTeacherCourseDetailItemList()
                self.teacher_course_detail_item_list.append(temp_model.from_map(k))
        if m.get('teacherName') is not None:
            self.teacher_name = m.get('teacherName')
        if m.get('teacherUserId') is not None:
            self.teacher_user_id = m.get('teacherUserId')
        return self


class BatchCreateTeacherCourseResponseBody(TeaModel):
    def __init__(
        self,
        result: bool = None,
        success: bool = None,
    ):
        self.result = result
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.result is not None:
            result['result'] = self.result
        if self.success is not None:
            result['success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('result') is not None:
            self.result = m.get('result')
        if m.get('success') is not None:
            self.success = m.get('success')
        return self


class BatchCreateTeacherCourseResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: BatchCreateTeacherCourseResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = BatchCreateTeacherCourseResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class BatchInvalidCourseHeaders(TeaModel):
    def __init__(
        self,
        common_headers: Dict[str, str] = None,
        x_acs_dingtalk_access_token: str = None,
    ):
        self.common_headers = common_headers
        self.x_acs_dingtalk_access_token = x_acs_dingtalk_access_token

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.common_headers is not None:
            result['commonHeaders'] = self.common_headers
        if self.x_acs_dingtalk_access_token is not None:
            result['x-acs-dingtalk-access-token'] = self.x_acs_dingtalk_access_token
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('commonHeaders') is not None:
            self.common_headers = m.get('commonHeaders')
        if m.get('x-acs-dingtalk-access-token') is not None:
            self.x_acs_dingtalk_access_token = m.get('x-acs-dingtalk-access-token')
        return self


class BatchInvalidCourseRequest(TeaModel):
    def __init__(
        self,
        class_id: str = None,
        corp_id: str = None,
        isv_code: str = None,
        isv_course_id: str = None,
        isv_course_ids: List[str] = None,
    ):
        self.class_id = class_id
        self.corp_id = corp_id
        self.isv_code = isv_code
        self.isv_course_id = isv_course_id
        self.isv_course_ids = isv_course_ids

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.class_id is not None:
            result['classId'] = self.class_id
        if self.corp_id is not None:
            result['corpId'] = self.corp_id
        if self.isv_code is not None:
            result['isvCode'] = self.isv_code
        if self.isv_course_id is not None:
            result['isvCourseId'] = self.isv_course_id
        if self.isv_course_ids is not None:
            result['isvCourseIds'] = self.isv_course_ids
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('classId') is not None:
            self.class_id = m.get('classId')
        if m.get('corpId') is not None:
            self.corp_id = m.get('corpId')
        if m.get('isvCode') is not None:
            self.isv_code = m.get('isvCode')
        if m.get('isvCourseId') is not None:
            self.isv_course_id = m.get('isvCourseId')
        if m.get('isvCourseIds') is not None:
            self.isv_course_ids = m.get('isvCourseIds')
        return self


class BatchInvalidCourseResponseBody(TeaModel):
    def __init__(
        self,
        result: bool = None,
        success: bool = None,
    ):
        self.result = result
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.result is not None:
            result['result'] = self.result
        if self.success is not None:
            result['success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('result') is not None:
            self.result = m.get('result')
        if m.get('success') is not None:
            self.success = m.get('success')
        return self


class BatchInvalidCourseResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: BatchInvalidCourseResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = BatchInvalidCourseResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class BatchOrgCreateHWHeaders(TeaModel):
    def __init__(
        self,
        common_headers: Dict[str, str] = None,
        x_acs_dingtalk_access_token: str = None,
    ):
        self.common_headers = common_headers
        self.x_acs_dingtalk_access_token = x_acs_dingtalk_access_token

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.common_headers is not None:
            result['commonHeaders'] = self.common_headers
        if self.x_acs_dingtalk_access_token is not None:
            result['x-acs-dingtalk-access-token'] = self.x_acs_dingtalk_access_token
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('commonHeaders') is not None:
            self.common_headers = m.get('commonHeaders')
        if m.get('x-acs-dingtalk-access-token') is not None:
            self.x_acs_dingtalk_access_token = m.get('x-acs-dingtalk-access-token')
        return self


class BatchOrgCreateHWRequestOpenSelectItemListClassListStudents(TeaModel):
    def __init__(
        self,
        avatar: str = None,
        name: str = None,
        staff_id: str = None,
    ):
        self.avatar = avatar
        self.name = name
        self.staff_id = staff_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.avatar is not None:
            result['avatar'] = self.avatar
        if self.name is not None:
            result['name'] = self.name
        if self.staff_id is not None:
            result['staffId'] = self.staff_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('avatar') is not None:
            self.avatar = m.get('avatar')
        if m.get('name') is not None:
            self.name = m.get('name')
        if m.get('staffId') is not None:
            self.staff_id = m.get('staffId')
        return self


class BatchOrgCreateHWRequestOpenSelectItemListClassList(TeaModel):
    def __init__(
        self,
        all: bool = None,
        class_id: str = None,
        class_name: str = None,
        students: List[BatchOrgCreateHWRequestOpenSelectItemListClassListStudents] = None,
    ):
        self.all = all
        self.class_id = class_id
        self.class_name = class_name
        self.students = students

    def validate(self):
        if self.students:
            for k in self.students:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.all is not None:
            result['all'] = self.all
        if self.class_id is not None:
            result['classId'] = self.class_id
        if self.class_name is not None:
            result['className'] = self.class_name
        result['students'] = []
        if self.students is not None:
            for k in self.students:
                result['students'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('all') is not None:
            self.all = m.get('all')
        if m.get('classId') is not None:
            self.class_id = m.get('classId')
        if m.get('className') is not None:
            self.class_name = m.get('className')
        self.students = []
        if m.get('students') is not None:
            for k in m.get('students'):
                temp_model = BatchOrgCreateHWRequestOpenSelectItemListClassListStudents()
                self.students.append(temp_model.from_map(k))
        return self


class BatchOrgCreateHWRequestOpenSelectItemList(TeaModel):
    def __init__(
        self,
        class_list: List[BatchOrgCreateHWRequestOpenSelectItemListClassList] = None,
        corp_id: str = None,
        selected_classes_desc: str = None,
    ):
        self.class_list = class_list
        self.corp_id = corp_id
        self.selected_classes_desc = selected_classes_desc

    def validate(self):
        if self.class_list:
            for k in self.class_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['classList'] = []
        if self.class_list is not None:
            for k in self.class_list:
                result['classList'].append(k.to_map() if k else None)
        if self.corp_id is not None:
            result['corpId'] = self.corp_id
        if self.selected_classes_desc is not None:
            result['selectedClassesDesc'] = self.selected_classes_desc
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.class_list = []
        if m.get('classList') is not None:
            for k in m.get('classList'):
                temp_model = BatchOrgCreateHWRequestOpenSelectItemListClassList()
                self.class_list.append(temp_model.from_map(k))
        if m.get('corpId') is not None:
            self.corp_id = m.get('corpId')
        if m.get('selectedClassesDesc') is not None:
            self.selected_classes_desc = m.get('selectedClassesDesc')
        return self


class BatchOrgCreateHWRequest(TeaModel):
    def __init__(
        self,
        attributes: str = None,
        biz_code: str = None,
        course_name: str = None,
        hw_content: str = None,
        hw_deadline: int = None,
        hw_deadline_open: str = None,
        hw_media: str = None,
        hw_photo: str = None,
        hw_title: str = None,
        hw_type: str = None,
        hw_video: str = None,
        identifier: str = None,
        open_select_item_list: List[BatchOrgCreateHWRequestOpenSelectItemList] = None,
        scheduled_release: str = None,
        scheduled_time: str = None,
        status: str = None,
        target_role: str = None,
        teacher_name: str = None,
        teacher_user_id: str = None,
    ):
        # This parameter is required.
        self.attributes = attributes
        # This parameter is required.
        self.biz_code = biz_code
        # This parameter is required.
        self.course_name = course_name
        # This parameter is required.
        self.hw_content = hw_content
        self.hw_deadline = hw_deadline
        self.hw_deadline_open = hw_deadline_open
        self.hw_media = hw_media
        self.hw_photo = hw_photo
        # This parameter is required.
        self.hw_title = hw_title
        self.hw_type = hw_type
        self.hw_video = hw_video
        # This parameter is required.
        self.identifier = identifier
        # This parameter is required.
        self.open_select_item_list = open_select_item_list
        self.scheduled_release = scheduled_release
        self.scheduled_time = scheduled_time
        # This parameter is required.
        self.status = status
        self.target_role = target_role
        # This parameter is required.
        self.teacher_name = teacher_name
        # This parameter is required.
        self.teacher_user_id = teacher_user_id

    def validate(self):
        if self.open_select_item_list:
            for k in self.open_select_item_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.attributes is not None:
            result['attributes'] = self.attributes
        if self.biz_code is not None:
            result['bizCode'] = self.biz_code
        if self.course_name is not None:
            result['courseName'] = self.course_name
        if self.hw_content is not None:
            result['hwContent'] = self.hw_content
        if self.hw_deadline is not None:
            result['hwDeadline'] = self.hw_deadline
        if self.hw_deadline_open is not None:
            result['hwDeadlineOpen'] = self.hw_deadline_open
        if self.hw_media is not None:
            result['hwMedia'] = self.hw_media
        if self.hw_photo is not None:
            result['hwPhoto'] = self.hw_photo
        if self.hw_title is not None:
            result['hwTitle'] = self.hw_title
        if self.hw_type is not None:
            result['hwType'] = self.hw_type
        if self.hw_video is not None:
            result['hwVideo'] = self.hw_video
        if self.identifier is not None:
            result['identifier'] = self.identifier
        result['openSelectItemList'] = []
        if self.open_select_item_list is not None:
            for k in self.open_select_item_list:
                result['openSelectItemList'].append(k.to_map() if k else None)
        if self.scheduled_release is not None:
            result['scheduledRelease'] = self.scheduled_release
        if self.scheduled_time is not None:
            result['scheduledTime'] = self.scheduled_time
        if self.status is not None:
            result['status'] = self.status
        if self.target_role is not None:
            result['targetRole'] = self.target_role
        if self.teacher_name is not None:
            result['teacherName'] = self.teacher_name
        if self.teacher_user_id is not None:
            result['teacherUserId'] = self.teacher_user_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('attributes') is not None:
            self.attributes = m.get('attributes')
        if m.get('bizCode') is not None:
            self.biz_code = m.get('bizCode')
        if m.get('courseName') is not None:
            self.course_name = m.get('courseName')
        if m.get('hwContent') is not None:
            self.hw_content = m.get('hwContent')
        if m.get('hwDeadline') is not None:
            self.hw_deadline = m.get('hwDeadline')
        if m.get('hwDeadlineOpen') is not None:
            self.hw_deadline_open = m.get('hwDeadlineOpen')
        if m.get('hwMedia') is not None:
            self.hw_media = m.get('hwMedia')
        if m.get('hwPhoto') is not None:
            self.hw_photo = m.get('hwPhoto')
        if m.get('hwTitle') is not None:
            self.hw_title = m.get('hwTitle')
        if m.get('hwType') is not None:
            self.hw_type = m.get('hwType')
        if m.get('hwVideo') is not None:
            self.hw_video = m.get('hwVideo')
        if m.get('identifier') is not None:
            self.identifier = m.get('identifier')
        self.open_select_item_list = []
        if m.get('openSelectItemList') is not None:
            for k in m.get('openSelectItemList'):
                temp_model = BatchOrgCreateHWRequestOpenSelectItemList()
                self.open_select_item_list.append(temp_model.from_map(k))
        if m.get('scheduledRelease') is not None:
            self.scheduled_release = m.get('scheduledRelease')
        if m.get('scheduledTime') is not None:
            self.scheduled_time = m.get('scheduledTime')
        if m.get('status') is not None:
            self.status = m.get('status')
        if m.get('targetRole') is not None:
            self.target_role = m.get('targetRole')
        if m.get('teacherName') is not None:
            self.teacher_name = m.get('teacherName')
        if m.get('teacherUserId') is not None:
            self.teacher_user_id = m.get('teacherUserId')
        return self


class BatchOrgCreateHWResponseBodyResultPublishList(TeaModel):
    def __init__(
        self,
        corpid: str = None,
        hwid: int = None,
    ):
        self.corpid = corpid
        self.hwid = hwid

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.corpid is not None:
            result['corpid'] = self.corpid
        if self.hwid is not None:
            result['hwid'] = self.hwid
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('corpid') is not None:
            self.corpid = m.get('corpid')
        if m.get('hwid') is not None:
            self.hwid = m.get('hwid')
        return self


class BatchOrgCreateHWResponseBodyResult(TeaModel):
    def __init__(
        self,
        publish_list: List[BatchOrgCreateHWResponseBodyResultPublishList] = None,
    ):
        self.publish_list = publish_list

    def validate(self):
        if self.publish_list:
            for k in self.publish_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['publishList'] = []
        if self.publish_list is not None:
            for k in self.publish_list:
                result['publishList'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.publish_list = []
        if m.get('publishList') is not None:
            for k in m.get('publishList'):
                temp_model = BatchOrgCreateHWResponseBodyResultPublishList()
                self.publish_list.append(temp_model.from_map(k))
        return self


class BatchOrgCreateHWResponseBody(TeaModel):
    def __init__(
        self,
        result: BatchOrgCreateHWResponseBodyResult = None,
    ):
        self.result = result

    def validate(self):
        if self.result:
            self.result.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.result is not None:
            result['result'] = self.result.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('result') is not None:
            temp_model = BatchOrgCreateHWResponseBodyResult()
            self.result = temp_model.from_map(m['result'])
        return self


class BatchOrgCreateHWResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: BatchOrgCreateHWResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = BatchOrgCreateHWResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CancelKitTaskHeaders(TeaModel):
    def __init__(
        self,
        common_headers: Dict[str, str] = None,
        x_acs_dingtalk_access_token: str = None,
    ):
        self.common_headers = common_headers
        self.x_acs_dingtalk_access_token = x_acs_dingtalk_access_token

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.common_headers is not None:
            result['commonHeaders'] = self.common_headers
        if self.x_acs_dingtalk_access_token is not None:
            result['x-acs-dingtalk-access-token'] = self.x_acs_dingtalk_access_token
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('commonHeaders') is not None:
            self.common_headers = m.get('commonHeaders')
        if m.get('x-acs-dingtalk-access-token') is not None:
            self.x_acs_dingtalk_access_token = m.get('x-acs-dingtalk-access-token')
        return self


class CancelKitTaskRequest(TeaModel):
    def __init__(
        self,
        biz_type: str = None,
        corp_id: str = None,
        identifier: str = None,
        isv_code: str = None,
    ):
        self.biz_type = biz_type
        self.corp_id = corp_id
        self.identifier = identifier
        self.isv_code = isv_code

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.biz_type is not None:
            result['bizType'] = self.biz_type
        if self.corp_id is not None:
            result['corpId'] = self.corp_id
        if self.identifier is not None:
            result['identifier'] = self.identifier
        if self.isv_code is not None:
            result['isvCode'] = self.isv_code
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('bizType') is not None:
            self.biz_type = m.get('bizType')
        if m.get('corpId') is not None:
            self.corp_id = m.get('corpId')
        if m.get('identifier') is not None:
            self.identifier = m.get('identifier')
        if m.get('isvCode') is not None:
            self.isv_code = m.get('isvCode')
        return self


class CancelKitTaskResponseBody(TeaModel):
    def __init__(
        self,
        result: bool = None,
        success: bool = None,
    ):
        self.result = result
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.result is not None:
            result['result'] = self.result
        if self.success is not None:
            result['success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('result') is not None:
            self.result = m.get('result')
        if m.get('success') is not None:
            self.success = m.get('success')
        return self


class CancelKitTaskResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CancelKitTaskResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CancelKitTaskResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CancelOrderHeaders(TeaModel):
    def __init__(
        self,
        common_headers: Dict[str, str] = None,
        x_acs_dingtalk_access_token: str = None,
    ):
        self.common_headers = common_headers
        self.x_acs_dingtalk_access_token = x_acs_dingtalk_access_token

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.common_headers is not None:
            result['commonHeaders'] = self.common_headers
        if self.x_acs_dingtalk_access_token is not None:
            result['x-acs-dingtalk-access-token'] = self.x_acs_dingtalk_access_token
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('commonHeaders') is not None:
            self.common_headers = m.get('commonHeaders')
        if m.get('x-acs-dingtalk-access-token') is not None:
            self.x_acs_dingtalk_access_token = m.get('x-acs-dingtalk-access-token')
        return self


class CancelOrderRequest(TeaModel):
    def __init__(
        self,
        face_id: str = None,
        order_no: str = None,
        signature: str = None,
        sn: str = None,
        timestamp: int = None,
        user_id: str = None,
    ):
        # This parameter is required.
        self.face_id = face_id
        # This parameter is required.
        self.order_no = order_no
        self.signature = signature
        # This parameter is required.
        self.sn = sn
        self.timestamp = timestamp
        # This parameter is required.
        self.user_id = user_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.face_id is not None:
            result['faceId'] = self.face_id
        if self.order_no is not None:
            result['orderNo'] = self.order_no
        if self.signature is not None:
            result['signature'] = self.signature
        if self.sn is not None:
            result['sn'] = self.sn
        if self.timestamp is not None:
            result['timestamp'] = self.timestamp
        if self.user_id is not None:
            result['userId'] = self.user_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('faceId') is not None:
            self.face_id = m.get('faceId')
        if m.get('orderNo') is not None:
            self.order_no = m.get('orderNo')
        if m.get('signature') is not None:
            self.signature = m.get('signature')
        if m.get('sn') is not None:
            self.sn = m.get('sn')
        if m.get('timestamp') is not None:
            self.timestamp = m.get('timestamp')
        if m.get('userId') is not None:
            self.user_id = m.get('userId')
        return self


class CancelOrderResponseBody(TeaModel):
    def __init__(
        self,
        need_retry: bool = None,
        trade_action: str = None,
    ):
        # This parameter is required.
        self.need_retry = need_retry
        # This parameter is required.
        self.trade_action = trade_action

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.need_retry is not None:
            result['needRetry'] = self.need_retry
        if self.trade_action is not None:
            result['tradeAction'] = self.trade_action
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('needRetry') is not None:
            self.need_retry = m.get('needRetry')
        if m.get('tradeAction') is not None:
            self.trade_action = m.get('tradeAction')
        return self


class CancelOrderResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CancelOrderResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CancelOrderResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CancelSnsOrderHeaders(TeaModel):
    def __init__(
        self,
        common_headers: Dict[str, str] = None,
        x_acs_dingtalk_access_token: str = None,
    ):
        self.common_headers = common_headers
        self.x_acs_dingtalk_access_token = x_acs_dingtalk_access_token

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.common_headers is not None:
            result['commonHeaders'] = self.common_headers
        if self.x_acs_dingtalk_access_token is not None:
            result['x-acs-dingtalk-access-token'] = self.x_acs_dingtalk_access_token
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('commonHeaders') is not None:
            self.common_headers = m.get('commonHeaders')
        if m.get('x-acs-dingtalk-access-token') is not None:
            self.x_acs_dingtalk_access_token = m.get('x-acs-dingtalk-access-token')
        return self


class CancelSnsOrderRequest(TeaModel):
    def __init__(
        self,
        alipay_app_id: str = None,
        merchant_id: str = None,
        order_no: str = None,
        signature: str = None,
        timestamp: int = None,
    ):
        # This parameter is required.
        self.alipay_app_id = alipay_app_id
        # This parameter is required.
        self.merchant_id = merchant_id
        # This parameter is required.
        self.order_no = order_no
        # This parameter is required.
        self.signature = signature
        # This parameter is required.
        self.timestamp = timestamp

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.alipay_app_id is not None:
            result['alipayAppId'] = self.alipay_app_id
        if self.merchant_id is not None:
            result['merchantId'] = self.merchant_id
        if self.order_no is not None:
            result['orderNo'] = self.order_no
        if self.signature is not None:
            result['signature'] = self.signature
        if self.timestamp is not None:
            result['timestamp'] = self.timestamp
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('alipayAppId') is not None:
            self.alipay_app_id = m.get('alipayAppId')
        if m.get('merchantId') is not None:
            self.merchant_id = m.get('merchantId')
        if m.get('orderNo') is not None:
            self.order_no = m.get('orderNo')
        if m.get('signature') is not None:
            self.signature = m.get('signature')
        if m.get('timestamp') is not None:
            self.timestamp = m.get('timestamp')
        return self


class CancelSnsOrderResponseBody(TeaModel):
    def __init__(
        self,
        alipay_app_id: str = None,
        merchant_id: str = None,
        merchant_order_no: str = None,
        order_no: str = None,
        pay_status: int = None,
        refund_status: int = None,
        total_amount: int = None,
    ):
        self.alipay_app_id = alipay_app_id
        self.merchant_id = merchant_id
        self.merchant_order_no = merchant_order_no
        self.order_no = order_no
        self.pay_status = pay_status
        self.refund_status = refund_status
        self.total_amount = total_amount

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.alipay_app_id is not None:
            result['alipayAppId'] = self.alipay_app_id
        if self.merchant_id is not None:
            result['merchantId'] = self.merchant_id
        if self.merchant_order_no is not None:
            result['merchantOrderNo'] = self.merchant_order_no
        if self.order_no is not None:
            result['orderNo'] = self.order_no
        if self.pay_status is not None:
            result['payStatus'] = self.pay_status
        if self.refund_status is not None:
            result['refundStatus'] = self.refund_status
        if self.total_amount is not None:
            result['totalAmount'] = self.total_amount
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('alipayAppId') is not None:
            self.alipay_app_id = m.get('alipayAppId')
        if m.get('merchantId') is not None:
            self.merchant_id = m.get('merchantId')
        if m.get('merchantOrderNo') is not None:
            self.merchant_order_no = m.get('merchantOrderNo')
        if m.get('orderNo') is not None:
            self.order_no = m.get('orderNo')
        if m.get('payStatus') is not None:
            self.pay_status = m.get('payStatus')
        if m.get('refundStatus') is not None:
            self.refund_status = m.get('refundStatus')
        if m.get('totalAmount') is not None:
            self.total_amount = m.get('totalAmount')
        return self


class CancelSnsOrderResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CancelSnsOrderResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CancelSnsOrderResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CancelUserOrderHeaders(TeaModel):
    def __init__(
        self,
        common_headers: Dict[str, str] = None,
        x_acs_dingtalk_access_token: str = None,
    ):
        self.common_headers = common_headers
        self.x_acs_dingtalk_access_token = x_acs_dingtalk_access_token

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.common_headers is not None:
            result['commonHeaders'] = self.common_headers
        if self.x_acs_dingtalk_access_token is not None:
            result['x-acs-dingtalk-access-token'] = self.x_acs_dingtalk_access_token
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('commonHeaders') is not None:
            self.common_headers = m.get('commonHeaders')
        if m.get('x-acs-dingtalk-access-token') is not None:
            self.x_acs_dingtalk_access_token = m.get('x-acs-dingtalk-access-token')
        return self


class CancelUserOrderRequest(TeaModel):
    def __init__(
        self,
        alipay_app_id: str = None,
        merchant_id: str = None,
        order_no: str = None,
        signature: str = None,
        timestamp: int = None,
    ):
        # This parameter is required.
        self.alipay_app_id = alipay_app_id
        # This parameter is required.
        self.merchant_id = merchant_id
        # This parameter is required.
        self.order_no = order_no
        # This parameter is required.
        self.signature = signature
        # This parameter is required.
        self.timestamp = timestamp

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.alipay_app_id is not None:
            result['alipayAppId'] = self.alipay_app_id
        if self.merchant_id is not None:
            result['merchantId'] = self.merchant_id
        if self.order_no is not None:
            result['orderNo'] = self.order_no
        if self.signature is not None:
            result['signature'] = self.signature
        if self.timestamp is not None:
            result['timestamp'] = self.timestamp
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('alipayAppId') is not None:
            self.alipay_app_id = m.get('alipayAppId')
        if m.get('merchantId') is not None:
            self.merchant_id = m.get('merchantId')
        if m.get('orderNo') is not None:
            self.order_no = m.get('orderNo')
        if m.get('signature') is not None:
            self.signature = m.get('signature')
        if m.get('timestamp') is not None:
            self.timestamp = m.get('timestamp')
        return self


class CancelUserOrderResponseBody(TeaModel):
    def __init__(
        self,
        alipay_app_id: str = None,
        merchant_id: str = None,
        merchant_order_no: str = None,
        order_no: str = None,
        pay_status: int = None,
        refund_status: int = None,
        total_amount: int = None,
    ):
        self.alipay_app_id = alipay_app_id
        self.merchant_id = merchant_id
        self.merchant_order_no = merchant_order_no
        self.order_no = order_no
        self.pay_status = pay_status
        self.refund_status = refund_status
        self.total_amount = total_amount

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.alipay_app_id is not None:
            result['alipayAppId'] = self.alipay_app_id
        if self.merchant_id is not None:
            result['merchantId'] = self.merchant_id
        if self.merchant_order_no is not None:
            result['merchantOrderNo'] = self.merchant_order_no
        if self.order_no is not None:
            result['orderNo'] = self.order_no
        if self.pay_status is not None:
            result['payStatus'] = self.pay_status
        if self.refund_status is not None:
            result['refundStatus'] = self.refund_status
        if self.total_amount is not None:
            result['totalAmount'] = self.total_amount
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('alipayAppId') is not None:
            self.alipay_app_id = m.get('alipayAppId')
        if m.get('merchantId') is not None:
            self.merchant_id = m.get('merchantId')
        if m.get('merchantOrderNo') is not None:
            self.merchant_order_no = m.get('merchantOrderNo')
        if m.get('orderNo') is not None:
            self.order_no = m.get('orderNo')
        if m.get('payStatus') is not None:
            self.pay_status = m.get('payStatus')
        if m.get('refundStatus') is not None:
            self.refund_status = m.get('refundStatus')
        if m.get('totalAmount') is not None:
            self.total_amount = m.get('totalAmount')
        return self


class CancelUserOrderResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CancelUserOrderResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CancelUserOrderResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CardBatchQueryCardsHeaders(TeaModel):
    def __init__(
        self,
        common_headers: Dict[str, str] = None,
        x_acs_dingtalk_access_token: str = None,
    ):
        self.common_headers = common_headers
        self.x_acs_dingtalk_access_token = x_acs_dingtalk_access_token

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.common_headers is not None:
            result['commonHeaders'] = self.common_headers
        if self.x_acs_dingtalk_access_token is not None:
            result['x-acs-dingtalk-access-token'] = self.x_acs_dingtalk_access_token
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('commonHeaders') is not None:
            self.common_headers = m.get('commonHeaders')
        if m.get('x-acs-dingtalk-access-token') is not None:
            self.x_acs_dingtalk_access_token = m.get('x-acs-dingtalk-access-token')
        return self


class CardBatchQueryCardsRequest(TeaModel):
    def __init__(
        self,
        card_biz_code: str = None,
        card_ids: List[int] = None,
        source_type: str = None,
        user_id: str = None,
    ):
        # This parameter is required.
        self.card_biz_code = card_biz_code
        # This parameter is required.
        self.card_ids = card_ids
        # This parameter is required.
        self.source_type = source_type
        # This parameter is required.
        self.user_id = user_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.card_biz_code is not None:
            result['cardBizCode'] = self.card_biz_code
        if self.card_ids is not None:
            result['cardIds'] = self.card_ids
        if self.source_type is not None:
            result['sourceType'] = self.source_type
        if self.user_id is not None:
            result['userId'] = self.user_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('cardBizCode') is not None:
            self.card_biz_code = m.get('cardBizCode')
        if m.get('cardIds') is not None:
            self.card_ids = m.get('cardIds')
        if m.get('sourceType') is not None:
            self.source_type = m.get('sourceType')
        if m.get('userId') is not None:
            self.user_id = m.get('userId')
        return self


class CardBatchQueryCardsResponseBodyResultCards(TeaModel):
    def __init__(
        self,
        card_biz_code: str = None,
        card_id: int = None,
        card_status: int = None,
        content: str = None,
        corp_id: str = None,
        effect_time: str = None,
        finished: bool = None,
        gmt_create: str = None,
        opt_end_time: str = None,
        opt_end_user_id: str = None,
        opt_end_user_name: str = None,
        send_time: str = None,
        start_time: str = None,
        status: int = None,
        teacher_id: str = None,
        teacher_name: str = None,
        title: str = None,
        type: int = None,
    ):
        self.card_biz_code = card_biz_code
        self.card_id = card_id
        self.card_status = card_status
        self.content = content
        self.corp_id = corp_id
        self.effect_time = effect_time
        self.finished = finished
        self.gmt_create = gmt_create
        self.opt_end_time = opt_end_time
        self.opt_end_user_id = opt_end_user_id
        self.opt_end_user_name = opt_end_user_name
        self.send_time = send_time
        self.start_time = start_time
        self.status = status
        self.teacher_id = teacher_id
        self.teacher_name = teacher_name
        self.title = title
        self.type = type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.card_biz_code is not None:
            result['cardBizCode'] = self.card_biz_code
        if self.card_id is not None:
            result['cardId'] = self.card_id
        if self.card_status is not None:
            result['cardStatus'] = self.card_status
        if self.content is not None:
            result['content'] = self.content
        if self.corp_id is not None:
            result['corpId'] = self.corp_id
        if self.effect_time is not None:
            result['effectTime'] = self.effect_time
        if self.finished is not None:
            result['finished'] = self.finished
        if self.gmt_create is not None:
            result['gmtCreate'] = self.gmt_create
        if self.opt_end_time is not None:
            result['optEndTime'] = self.opt_end_time
        if self.opt_end_user_id is not None:
            result['optEndUserId'] = self.opt_end_user_id
        if self.opt_end_user_name is not None:
            result['optEndUserName'] = self.opt_end_user_name
        if self.send_time is not None:
            result['sendTime'] = self.send_time
        if self.start_time is not None:
            result['startTime'] = self.start_time
        if self.status is not None:
            result['status'] = self.status
        if self.teacher_id is not None:
            result['teacherId'] = self.teacher_id
        if self.teacher_name is not None:
            result['teacherName'] = self.teacher_name
        if self.title is not None:
            result['title'] = self.title
        if self.type is not None:
            result['type'] = self.type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('cardBizCode') is not None:
            self.card_biz_code = m.get('cardBizCode')
        if m.get('cardId') is not None:
            self.card_id = m.get('cardId')
        if m.get('cardStatus') is not None:
            self.card_status = m.get('cardStatus')
        if m.get('content') is not None:
            self.content = m.get('content')
        if m.get('corpId') is not None:
            self.corp_id = m.get('corpId')
        if m.get('effectTime') is not None:
            self.effect_time = m.get('effectTime')
        if m.get('finished') is not None:
            self.finished = m.get('finished')
        if m.get('gmtCreate') is not None:
            self.gmt_create = m.get('gmtCreate')
        if m.get('optEndTime') is not None:
            self.opt_end_time = m.get('optEndTime')
        if m.get('optEndUserId') is not None:
            self.opt_end_user_id = m.get('optEndUserId')
        if m.get('optEndUserName') is not None:
            self.opt_end_user_name = m.get('optEndUserName')
        if m.get('sendTime') is not None:
            self.send_time = m.get('sendTime')
        if m.get('startTime') is not None:
            self.start_time = m.get('startTime')
        if m.get('status') is not None:
            self.status = m.get('status')
        if m.get('teacherId') is not None:
            self.teacher_id = m.get('teacherId')
        if m.get('teacherName') is not None:
            self.teacher_name = m.get('teacherName')
        if m.get('title') is not None:
            self.title = m.get('title')
        if m.get('type') is not None:
            self.type = m.get('type')
        return self


class CardBatchQueryCardsResponseBodyResult(TeaModel):
    def __init__(
        self,
        cards: List[CardBatchQueryCardsResponseBodyResultCards] = None,
    ):
        self.cards = cards

    def validate(self):
        if self.cards:
            for k in self.cards:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['cards'] = []
        if self.cards is not None:
            for k in self.cards:
                result['cards'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.cards = []
        if m.get('cards') is not None:
            for k in m.get('cards'):
                temp_model = CardBatchQueryCardsResponseBodyResultCards()
                self.cards.append(temp_model.from_map(k))
        return self


class CardBatchQueryCardsResponseBody(TeaModel):
    def __init__(
        self,
        result: CardBatchQueryCardsResponseBodyResult = None,
        success: bool = None,
    ):
        self.result = result
        self.success = success

    def validate(self):
        if self.result:
            self.result.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.result is not None:
            result['result'] = self.result.to_map()
        if self.success is not None:
            result['success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('result') is not None:
            temp_model = CardBatchQueryCardsResponseBodyResult()
            self.result = temp_model.from_map(m['result'])
        if m.get('success') is not None:
            self.success = m.get('success')
        return self


class CardBatchQueryCardsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CardBatchQueryCardsResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CardBatchQueryCardsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CardDeleteCardHeaders(TeaModel):
    def __init__(
        self,
        common_headers: Dict[str, str] = None,
        x_acs_dingtalk_access_token: str = None,
    ):
        self.common_headers = common_headers
        self.x_acs_dingtalk_access_token = x_acs_dingtalk_access_token

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.common_headers is not None:
            result['commonHeaders'] = self.common_headers
        if self.x_acs_dingtalk_access_token is not None:
            result['x-acs-dingtalk-access-token'] = self.x_acs_dingtalk_access_token
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('commonHeaders') is not None:
            self.common_headers = m.get('commonHeaders')
        if m.get('x-acs-dingtalk-access-token') is not None:
            self.x_acs_dingtalk_access_token = m.get('x-acs-dingtalk-access-token')
        return self


class CardDeleteCardRequest(TeaModel):
    def __init__(
        self,
        card_biz_code: str = None,
        card_biz_id: str = None,
        card_id: int = None,
        source_type: str = None,
        user_id: str = None,
    ):
        # This parameter is required.
        self.card_biz_code = card_biz_code
        self.card_biz_id = card_biz_id
        # This parameter is required.
        self.card_id = card_id
        # This parameter is required.
        self.source_type = source_type
        # This parameter is required.
        self.user_id = user_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.card_biz_code is not None:
            result['cardBizCode'] = self.card_biz_code
        if self.card_biz_id is not None:
            result['cardBizId'] = self.card_biz_id
        if self.card_id is not None:
            result['cardId'] = self.card_id
        if self.source_type is not None:
            result['sourceType'] = self.source_type
        if self.user_id is not None:
            result['userId'] = self.user_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('cardBizCode') is not None:
            self.card_biz_code = m.get('cardBizCode')
        if m.get('cardBizId') is not None:
            self.card_biz_id = m.get('cardBizId')
        if m.get('cardId') is not None:
            self.card_id = m.get('cardId')
        if m.get('sourceType') is not None:
            self.source_type = m.get('sourceType')
        if m.get('userId') is not None:
            self.user_id = m.get('userId')
        return self


class CardDeleteCardResponseBody(TeaModel):
    def __init__(
        self,
        result: bool = None,
        success: bool = None,
    ):
        self.result = result
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.result is not None:
            result['result'] = self.result
        if self.success is not None:
            result['success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('result') is not None:
            self.result = m.get('result')
        if m.get('success') is not None:
            self.success = m.get('success')
        return self


class CardDeleteCardResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CardDeleteCardResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CardDeleteCardResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CardEndCardHeaders(TeaModel):
    def __init__(
        self,
        common_headers: Dict[str, str] = None,
        x_acs_dingtalk_access_token: str = None,
    ):
        self.common_headers = common_headers
        self.x_acs_dingtalk_access_token = x_acs_dingtalk_access_token

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.common_headers is not None:
            result['commonHeaders'] = self.common_headers
        if self.x_acs_dingtalk_access_token is not None:
            result['x-acs-dingtalk-access-token'] = self.x_acs_dingtalk_access_token
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('commonHeaders') is not None:
            self.common_headers = m.get('commonHeaders')
        if m.get('x-acs-dingtalk-access-token') is not None:
            self.x_acs_dingtalk_access_token = m.get('x-acs-dingtalk-access-token')
        return self


class CardEndCardRequest(TeaModel):
    def __init__(
        self,
        card_biz_code: str = None,
        card_biz_id: str = None,
        card_id: int = None,
        source_type: str = None,
        user_id: str = None,
    ):
        # This parameter is required.
        self.card_biz_code = card_biz_code
        self.card_biz_id = card_biz_id
        # This parameter is required.
        self.card_id = card_id
        # This parameter is required.
        self.source_type = source_type
        # This parameter is required.
        self.user_id = user_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.card_biz_code is not None:
            result['cardBizCode'] = self.card_biz_code
        if self.card_biz_id is not None:
            result['cardBizId'] = self.card_biz_id
        if self.card_id is not None:
            result['cardId'] = self.card_id
        if self.source_type is not None:
            result['sourceType'] = self.source_type
        if self.user_id is not None:
            result['userId'] = self.user_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('cardBizCode') is not None:
            self.card_biz_code = m.get('cardBizCode')
        if m.get('cardBizId') is not None:
            self.card_biz_id = m.get('cardBizId')
        if m.get('cardId') is not None:
            self.card_id = m.get('cardId')
        if m.get('sourceType') is not None:
            self.source_type = m.get('sourceType')
        if m.get('userId') is not None:
            self.user_id = m.get('userId')
        return self


class CardEndCardResponseBody(TeaModel):
    def __init__(
        self,
        result: bool = None,
        success: bool = None,
    ):
        self.result = result
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.result is not None:
            result['result'] = self.result
        if self.success is not None:
            result['success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('result') is not None:
            self.result = m.get('result')
        if m.get('success') is not None:
            self.success = m.get('success')
        return self


class CardEndCardResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CardEndCardResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CardEndCardResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CardGetCardHeaders(TeaModel):
    def __init__(
        self,
        common_headers: Dict[str, str] = None,
        x_acs_dingtalk_access_token: str = None,
    ):
        self.common_headers = common_headers
        self.x_acs_dingtalk_access_token = x_acs_dingtalk_access_token

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.common_headers is not None:
            result['commonHeaders'] = self.common_headers
        if self.x_acs_dingtalk_access_token is not None:
            result['x-acs-dingtalk-access-token'] = self.x_acs_dingtalk_access_token
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('commonHeaders') is not None:
            self.common_headers = m.get('commonHeaders')
        if m.get('x-acs-dingtalk-access-token') is not None:
            self.x_acs_dingtalk_access_token = m.get('x-acs-dingtalk-access-token')
        return self


class CardGetCardRequest(TeaModel):
    def __init__(
        self,
        card_id: int = None,
        source_type: str = None,
    ):
        # This parameter is required.
        self.card_id = card_id
        # This parameter is required.
        self.source_type = source_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.card_id is not None:
            result['cardId'] = self.card_id
        if self.source_type is not None:
            result['sourceType'] = self.source_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('cardId') is not None:
            self.card_id = m.get('cardId')
        if m.get('sourceType') is not None:
            self.source_type = m.get('sourceType')
        return self


class CardGetCardResponseBodyResult(TeaModel):
    def __init__(
        self,
        attr: str = None,
        card_biz_code: str = None,
        card_biz_id: str = None,
        card_content_count: int = None,
        card_cycle: int = None,
        card_frequency: List[int] = None,
        card_id: int = None,
        card_status: int = None,
        card_url: str = None,
        category_content_tag: str = None,
        category_cover_image_url: str = None,
        category_create_card_small_image_url: str = None,
        category_list_small_image_url: str = None,
        category_name: str = None,
        class_ids: List[str] = None,
        class_names: List[str] = None,
        content: str = None,
        corp_id: str = None,
        effect_time: str = None,
        finished: bool = None,
        media: str = None,
        opt_end_time: str = None,
        opt_end_user_id: str = None,
        opt_end_user_name: str = None,
        remind_not_punch_card_hour: int = None,
        remind_not_punch_card_minute: int = None,
        send_time: str = None,
        source_type: str = None,
        start_time: str = None,
        status: int = None,
        system_time: int = None,
        teacher_id: str = None,
        teacher_name: str = None,
        template_cover_image_url: str = None,
        title: str = None,
        type: int = None,
    ):
        self.attr = attr
        self.card_biz_code = card_biz_code
        self.card_biz_id = card_biz_id
        self.card_content_count = card_content_count
        self.card_cycle = card_cycle
        self.card_frequency = card_frequency
        self.card_id = card_id
        self.card_status = card_status
        self.card_url = card_url
        self.category_content_tag = category_content_tag
        self.category_cover_image_url = category_cover_image_url
        self.category_create_card_small_image_url = category_create_card_small_image_url
        self.category_list_small_image_url = category_list_small_image_url
        self.category_name = category_name
        self.class_ids = class_ids
        self.class_names = class_names
        self.content = content
        self.corp_id = corp_id
        self.effect_time = effect_time
        self.finished = finished
        self.media = media
        self.opt_end_time = opt_end_time
        self.opt_end_user_id = opt_end_user_id
        self.opt_end_user_name = opt_end_user_name
        self.remind_not_punch_card_hour = remind_not_punch_card_hour
        self.remind_not_punch_card_minute = remind_not_punch_card_minute
        self.send_time = send_time
        self.source_type = source_type
        self.start_time = start_time
        self.status = status
        self.system_time = system_time
        self.teacher_id = teacher_id
        self.teacher_name = teacher_name
        self.template_cover_image_url = template_cover_image_url
        self.title = title
        self.type = type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.attr is not None:
            result['attr'] = self.attr
        if self.card_biz_code is not None:
            result['cardBizCode'] = self.card_biz_code
        if self.card_biz_id is not None:
            result['cardBizId'] = self.card_biz_id
        if self.card_content_count is not None:
            result['cardContentCount'] = self.card_content_count
        if self.card_cycle is not None:
            result['cardCycle'] = self.card_cycle
        if self.card_frequency is not None:
            result['cardFrequency'] = self.card_frequency
        if self.card_id is not None:
            result['cardId'] = self.card_id
        if self.card_status is not None:
            result['cardStatus'] = self.card_status
        if self.card_url is not None:
            result['cardUrl'] = self.card_url
        if self.category_content_tag is not None:
            result['categoryContentTag'] = self.category_content_tag
        if self.category_cover_image_url is not None:
            result['categoryCoverImageUrl'] = self.category_cover_image_url
        if self.category_create_card_small_image_url is not None:
            result['categoryCreateCardSmallImageUrl'] = self.category_create_card_small_image_url
        if self.category_list_small_image_url is not None:
            result['categoryListSmallImageUrl'] = self.category_list_small_image_url
        if self.category_name is not None:
            result['categoryName'] = self.category_name
        if self.class_ids is not None:
            result['classIds'] = self.class_ids
        if self.class_names is not None:
            result['classNames'] = self.class_names
        if self.content is not None:
            result['content'] = self.content
        if self.corp_id is not None:
            result['corpId'] = self.corp_id
        if self.effect_time is not None:
            result['effectTime'] = self.effect_time
        if self.finished is not None:
            result['finished'] = self.finished
        if self.media is not None:
            result['media'] = self.media
        if self.opt_end_time is not None:
            result['optEndTime'] = self.opt_end_time
        if self.opt_end_user_id is not None:
            result['optEndUserId'] = self.opt_end_user_id
        if self.opt_end_user_name is not None:
            result['optEndUserName'] = self.opt_end_user_name
        if self.remind_not_punch_card_hour is not None:
            result['remindNotPunchCardHour'] = self.remind_not_punch_card_hour
        if self.remind_not_punch_card_minute is not None:
            result['remindNotPunchCardMinute'] = self.remind_not_punch_card_minute
        if self.send_time is not None:
            result['sendTime'] = self.send_time
        if self.source_type is not None:
            result['sourceType'] = self.source_type
        if self.start_time is not None:
            result['startTime'] = self.start_time
        if self.status is not None:
            result['status'] = self.status
        if self.system_time is not None:
            result['systemTime'] = self.system_time
        if self.teacher_id is not None:
            result['teacherId'] = self.teacher_id
        if self.teacher_name is not None:
            result['teacherName'] = self.teacher_name
        if self.template_cover_image_url is not None:
            result['templateCoverImageUrl'] = self.template_cover_image_url
        if self.title is not None:
            result['title'] = self.title
        if self.type is not None:
            result['type'] = self.type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('attr') is not None:
            self.attr = m.get('attr')
        if m.get('cardBizCode') is not None:
            self.card_biz_code = m.get('cardBizCode')
        if m.get('cardBizId') is not None:
            self.card_biz_id = m.get('cardBizId')
        if m.get('cardContentCount') is not None:
            self.card_content_count = m.get('cardContentCount')
        if m.get('cardCycle') is not None:
            self.card_cycle = m.get('cardCycle')
        if m.get('cardFrequency') is not None:
            self.card_frequency = m.get('cardFrequency')
        if m.get('cardId') is not None:
            self.card_id = m.get('cardId')
        if m.get('cardStatus') is not None:
            self.card_status = m.get('cardStatus')
        if m.get('cardUrl') is not None:
            self.card_url = m.get('cardUrl')
        if m.get('categoryContentTag') is not None:
            self.category_content_tag = m.get('categoryContentTag')
        if m.get('categoryCoverImageUrl') is not None:
            self.category_cover_image_url = m.get('categoryCoverImageUrl')
        if m.get('categoryCreateCardSmallImageUrl') is not None:
            self.category_create_card_small_image_url = m.get('categoryCreateCardSmallImageUrl')
        if m.get('categoryListSmallImageUrl') is not None:
            self.category_list_small_image_url = m.get('categoryListSmallImageUrl')
        if m.get('categoryName') is not None:
            self.category_name = m.get('categoryName')
        if m.get('classIds') is not None:
            self.class_ids = m.get('classIds')
        if m.get('classNames') is not None:
            self.class_names = m.get('classNames')
        if m.get('content') is not None:
            self.content = m.get('content')
        if m.get('corpId') is not None:
            self.corp_id = m.get('corpId')
        if m.get('effectTime') is not None:
            self.effect_time = m.get('effectTime')
        if m.get('finished') is not None:
            self.finished = m.get('finished')
        if m.get('media') is not None:
            self.media = m.get('media')
        if m.get('optEndTime') is not None:
            self.opt_end_time = m.get('optEndTime')
        if m.get('optEndUserId') is not None:
            self.opt_end_user_id = m.get('optEndUserId')
        if m.get('optEndUserName') is not None:
            self.opt_end_user_name = m.get('optEndUserName')
        if m.get('remindNotPunchCardHour') is not None:
            self.remind_not_punch_card_hour = m.get('remindNotPunchCardHour')
        if m.get('remindNotPunchCardMinute') is not None:
            self.remind_not_punch_card_minute = m.get('remindNotPunchCardMinute')
        if m.get('sendTime') is not None:
            self.send_time = m.get('sendTime')
        if m.get('sourceType') is not None:
            self.source_type = m.get('sourceType')
        if m.get('startTime') is not None:
            self.start_time = m.get('startTime')
        if m.get('status') is not None:
            self.status = m.get('status')
        if m.get('systemTime') is not None:
            self.system_time = m.get('systemTime')
        if m.get('teacherId') is not None:
            self.teacher_id = m.get('teacherId')
        if m.get('teacherName') is not None:
            self.teacher_name = m.get('teacherName')
        if m.get('templateCoverImageUrl') is not None:
            self.template_cover_image_url = m.get('templateCoverImageUrl')
        if m.get('title') is not None:
            self.title = m.get('title')
        if m.get('type') is not None:
            self.type = m.get('type')
        return self


class CardGetCardResponseBody(TeaModel):
    def __init__(
        self,
        result: CardGetCardResponseBodyResult = None,
        success: bool = None,
    ):
        self.result = result
        self.success = success

    def validate(self):
        if self.result:
            self.result.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.result is not None:
            result['result'] = self.result.to_map()
        if self.success is not None:
            result['success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('result') is not None:
            temp_model = CardGetCardResponseBodyResult()
            self.result = temp_model.from_map(m['result'])
        if m.get('success') is not None:
            self.success = m.get('success')
        return self


class CardGetCardResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CardGetCardResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CardGetCardResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CardGetCardFinishProgressHeaders(TeaModel):
    def __init__(
        self,
        common_headers: Dict[str, str] = None,
        x_acs_dingtalk_access_token: str = None,
    ):
        self.common_headers = common_headers
        self.x_acs_dingtalk_access_token = x_acs_dingtalk_access_token

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.common_headers is not None:
            result['commonHeaders'] = self.common_headers
        if self.x_acs_dingtalk_access_token is not None:
            result['x-acs-dingtalk-access-token'] = self.x_acs_dingtalk_access_token
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('commonHeaders') is not None:
            self.common_headers = m.get('commonHeaders')
        if m.get('x-acs-dingtalk-access-token') is not None:
            self.x_acs_dingtalk_access_token = m.get('x-acs-dingtalk-access-token')
        return self


class CardGetCardFinishProgressRequest(TeaModel):
    def __init__(
        self,
        card_biz_code: str = None,
        card_biz_id: str = None,
        card_id: int = None,
        source_type: str = None,
        student_id: str = None,
        user_id: str = None,
    ):
        # This parameter is required.
        self.card_biz_code = card_biz_code
        self.card_biz_id = card_biz_id
        # This parameter is required.
        self.card_id = card_id
        # This parameter is required.
        self.source_type = source_type
        self.student_id = student_id
        # This parameter is required.
        self.user_id = user_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.card_biz_code is not None:
            result['cardBizCode'] = self.card_biz_code
        if self.card_biz_id is not None:
            result['cardBizId'] = self.card_biz_id
        if self.card_id is not None:
            result['cardId'] = self.card_id
        if self.source_type is not None:
            result['sourceType'] = self.source_type
        if self.student_id is not None:
            result['studentId'] = self.student_id
        if self.user_id is not None:
            result['userId'] = self.user_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('cardBizCode') is not None:
            self.card_biz_code = m.get('cardBizCode')
        if m.get('cardBizId') is not None:
            self.card_biz_id = m.get('cardBizId')
        if m.get('cardId') is not None:
            self.card_id = m.get('cardId')
        if m.get('sourceType') is not None:
            self.source_type = m.get('sourceType')
        if m.get('studentId') is not None:
            self.student_id = m.get('studentId')
        if m.get('userId') is not None:
            self.user_id = m.get('userId')
        return self


class CardGetCardFinishProgressResponseBodyResultClassStatisticsProcess(TeaModel):
    def __init__(
        self,
        date: str = None,
        finished_students_num: int = None,
        need_finish_students_num: int = None,
        task_code: str = None,
        today: str = None,
    ):
        self.date = date
        self.finished_students_num = finished_students_num
        self.need_finish_students_num = need_finish_students_num
        self.task_code = task_code
        self.today = today

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.date is not None:
            result['date'] = self.date
        if self.finished_students_num is not None:
            result['finishedStudentsNum'] = self.finished_students_num
        if self.need_finish_students_num is not None:
            result['needFinishStudentsNum'] = self.need_finish_students_num
        if self.task_code is not None:
            result['taskCode'] = self.task_code
        if self.today is not None:
            result['today'] = self.today
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('date') is not None:
            self.date = m.get('date')
        if m.get('finishedStudentsNum') is not None:
            self.finished_students_num = m.get('finishedStudentsNum')
        if m.get('needFinishStudentsNum') is not None:
            self.need_finish_students_num = m.get('needFinishStudentsNum')
        if m.get('taskCode') is not None:
            self.task_code = m.get('taskCode')
        if m.get('today') is not None:
            self.today = m.get('today')
        return self


class CardGetCardFinishProgressResponseBodyResultClassStatistics(TeaModel):
    def __init__(
        self,
        card_biz_id: str = None,
        card_biz_name: str = None,
        class_id: str = None,
        class_name: str = None,
        process: List[CardGetCardFinishProgressResponseBodyResultClassStatisticsProcess] = None,
    ):
        self.card_biz_id = card_biz_id
        self.card_biz_name = card_biz_name
        self.class_id = class_id
        self.class_name = class_name
        self.process = process

    def validate(self):
        if self.process:
            for k in self.process:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.card_biz_id is not None:
            result['cardBizId'] = self.card_biz_id
        if self.card_biz_name is not None:
            result['cardBizName'] = self.card_biz_name
        if self.class_id is not None:
            result['classId'] = self.class_id
        if self.class_name is not None:
            result['className'] = self.class_name
        result['process'] = []
        if self.process is not None:
            for k in self.process:
                result['process'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('cardBizId') is not None:
            self.card_biz_id = m.get('cardBizId')
        if m.get('cardBizName') is not None:
            self.card_biz_name = m.get('cardBizName')
        if m.get('classId') is not None:
            self.class_id = m.get('classId')
        if m.get('className') is not None:
            self.class_name = m.get('className')
        self.process = []
        if m.get('process') is not None:
            for k in m.get('process'):
                temp_model = CardGetCardFinishProgressResponseBodyResultClassStatisticsProcess()
                self.process.append(temp_model.from_map(k))
        return self


class CardGetCardFinishProgressResponseBodyResultPatriarchStatistics(TeaModel):
    def __init__(
        self,
        card_task_code: str = None,
        date: str = None,
        is_finished: bool = None,
        is_finished_by_reissue_card: bool = None,
        is_last_day: bool = None,
        reissue_card: bool = None,
        student_id: str = None,
        student_name: str = None,
        today: str = None,
        user_sub_task_id: int = None,
    ):
        self.card_task_code = card_task_code
        self.date = date
        self.is_finished = is_finished
        self.is_finished_by_reissue_card = is_finished_by_reissue_card
        self.is_last_day = is_last_day
        self.reissue_card = reissue_card
        self.student_id = student_id
        self.student_name = student_name
        self.today = today
        self.user_sub_task_id = user_sub_task_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.card_task_code is not None:
            result['cardTaskCode'] = self.card_task_code
        if self.date is not None:
            result['date'] = self.date
        if self.is_finished is not None:
            result['isFinished'] = self.is_finished
        if self.is_finished_by_reissue_card is not None:
            result['isFinishedByReissueCard'] = self.is_finished_by_reissue_card
        if self.is_last_day is not None:
            result['isLastDay'] = self.is_last_day
        if self.reissue_card is not None:
            result['reissueCard'] = self.reissue_card
        if self.student_id is not None:
            result['studentId'] = self.student_id
        if self.student_name is not None:
            result['studentName'] = self.student_name
        if self.today is not None:
            result['today'] = self.today
        if self.user_sub_task_id is not None:
            result['userSubTaskId'] = self.user_sub_task_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('cardTaskCode') is not None:
            self.card_task_code = m.get('cardTaskCode')
        if m.get('date') is not None:
            self.date = m.get('date')
        if m.get('isFinished') is not None:
            self.is_finished = m.get('isFinished')
        if m.get('isFinishedByReissueCard') is not None:
            self.is_finished_by_reissue_card = m.get('isFinishedByReissueCard')
        if m.get('isLastDay') is not None:
            self.is_last_day = m.get('isLastDay')
        if m.get('reissueCard') is not None:
            self.reissue_card = m.get('reissueCard')
        if m.get('studentId') is not None:
            self.student_id = m.get('studentId')
        if m.get('studentName') is not None:
            self.student_name = m.get('studentName')
        if m.get('today') is not None:
            self.today = m.get('today')
        if m.get('userSubTaskId') is not None:
            self.user_sub_task_id = m.get('userSubTaskId')
        return self


class CardGetCardFinishProgressResponseBodyResult(TeaModel):
    def __init__(
        self,
        class_statistics: List[CardGetCardFinishProgressResponseBodyResultClassStatistics] = None,
        patriarch_statistics: List[CardGetCardFinishProgressResponseBodyResultPatriarchStatistics] = None,
        student_name_list: List[str] = None,
    ):
        self.class_statistics = class_statistics
        self.patriarch_statistics = patriarch_statistics
        self.student_name_list = student_name_list

    def validate(self):
        if self.class_statistics:
            for k in self.class_statistics:
                if k:
                    k.validate()
        if self.patriarch_statistics:
            for k in self.patriarch_statistics:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['classStatistics'] = []
        if self.class_statistics is not None:
            for k in self.class_statistics:
                result['classStatistics'].append(k.to_map() if k else None)
        result['patriarchStatistics'] = []
        if self.patriarch_statistics is not None:
            for k in self.patriarch_statistics:
                result['patriarchStatistics'].append(k.to_map() if k else None)
        if self.student_name_list is not None:
            result['studentNameList'] = self.student_name_list
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.class_statistics = []
        if m.get('classStatistics') is not None:
            for k in m.get('classStatistics'):
                temp_model = CardGetCardFinishProgressResponseBodyResultClassStatistics()
                self.class_statistics.append(temp_model.from_map(k))
        self.patriarch_statistics = []
        if m.get('patriarchStatistics') is not None:
            for k in m.get('patriarchStatistics'):
                temp_model = CardGetCardFinishProgressResponseBodyResultPatriarchStatistics()
                self.patriarch_statistics.append(temp_model.from_map(k))
        if m.get('studentNameList') is not None:
            self.student_name_list = m.get('studentNameList')
        return self


class CardGetCardFinishProgressResponseBody(TeaModel):
    def __init__(
        self,
        result: CardGetCardFinishProgressResponseBodyResult = None,
        success: bool = None,
    ):
        self.result = result
        self.success = success

    def validate(self):
        if self.result:
            self.result.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.result is not None:
            result['result'] = self.result.to_map()
        if self.success is not None:
            result['success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('result') is not None:
            temp_model = CardGetCardFinishProgressResponseBodyResult()
            self.result = temp_model.from_map(m['result'])
        if m.get('success') is not None:
            self.success = m.get('success')
        return self


class CardGetCardFinishProgressResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CardGetCardFinishProgressResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CardGetCardFinishProgressResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CardQueryCardFeedsHeaders(TeaModel):
    def __init__(
        self,
        common_headers: Dict[str, str] = None,
        x_acs_dingtalk_access_token: str = None,
    ):
        self.common_headers = common_headers
        self.x_acs_dingtalk_access_token = x_acs_dingtalk_access_token

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.common_headers is not None:
            result['commonHeaders'] = self.common_headers
        if self.x_acs_dingtalk_access_token is not None:
            result['x-acs-dingtalk-access-token'] = self.x_acs_dingtalk_access_token
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('commonHeaders') is not None:
            self.common_headers = m.get('commonHeaders')
        if m.get('x-acs-dingtalk-access-token') is not None:
            self.x_acs_dingtalk_access_token = m.get('x-acs-dingtalk-access-token')
        return self


class CardQueryCardFeedsRequest(TeaModel):
    def __init__(
        self,
        biz_type: int = None,
        card_biz_code: str = None,
        card_biz_id: str = None,
        card_id: int = None,
        count: int = None,
        cursor: int = None,
        feed_type: int = None,
        need_finish_process: bool = None,
        source_type: str = None,
        student_id: str = None,
        sub_biz_id: str = None,
        user_id: str = None,
    ):
        # This parameter is required.
        self.biz_type = biz_type
        # This parameter is required.
        self.card_biz_code = card_biz_code
        self.card_biz_id = card_biz_id
        # This parameter is required.
        self.card_id = card_id
        # This parameter is required.
        self.count = count
        self.cursor = cursor
        # This parameter is required.
        self.feed_type = feed_type
        self.need_finish_process = need_finish_process
        # This parameter is required.
        self.source_type = source_type
        self.student_id = student_id
        # This parameter is required.
        self.sub_biz_id = sub_biz_id
        # This parameter is required.
        self.user_id = user_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.biz_type is not None:
            result['bizType'] = self.biz_type
        if self.card_biz_code is not None:
            result['cardBizCode'] = self.card_biz_code
        if self.card_biz_id is not None:
            result['cardBizId'] = self.card_biz_id
        if self.card_id is not None:
            result['cardId'] = self.card_id
        if self.count is not None:
            result['count'] = self.count
        if self.cursor is not None:
            result['cursor'] = self.cursor
        if self.feed_type is not None:
            result['feedType'] = self.feed_type
        if self.need_finish_process is not None:
            result['needFinishProcess'] = self.need_finish_process
        if self.source_type is not None:
            result['sourceType'] = self.source_type
        if self.student_id is not None:
            result['studentId'] = self.student_id
        if self.sub_biz_id is not None:
            result['subBizId'] = self.sub_biz_id
        if self.user_id is not None:
            result['userId'] = self.user_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('bizType') is not None:
            self.biz_type = m.get('bizType')
        if m.get('cardBizCode') is not None:
            self.card_biz_code = m.get('cardBizCode')
        if m.get('cardBizId') is not None:
            self.card_biz_id = m.get('cardBizId')
        if m.get('cardId') is not None:
            self.card_id = m.get('cardId')
        if m.get('count') is not None:
            self.count = m.get('count')
        if m.get('cursor') is not None:
            self.cursor = m.get('cursor')
        if m.get('feedType') is not None:
            self.feed_type = m.get('feedType')
        if m.get('needFinishProcess') is not None:
            self.need_finish_process = m.get('needFinishProcess')
        if m.get('sourceType') is not None:
            self.source_type = m.get('sourceType')
        if m.get('studentId') is not None:
            self.student_id = m.get('studentId')
        if m.get('subBizId') is not None:
            self.sub_biz_id = m.get('subBizId')
        if m.get('userId') is not None:
            self.user_id = m.get('userId')
        return self


class CardQueryCardFeedsResponseBodyResultPostsAuthor(TeaModel):
    def __init__(
        self,
        show_name: str = None,
        user_id: str = None,
        user_role: str = None,
    ):
        self.show_name = show_name
        self.user_id = user_id
        self.user_role = user_role

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.show_name is not None:
            result['showName'] = self.show_name
        if self.user_id is not None:
            result['userId'] = self.user_id
        if self.user_role is not None:
            result['userRole'] = self.user_role
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('showName') is not None:
            self.show_name = m.get('showName')
        if m.get('userId') is not None:
            self.user_id = m.get('userId')
        if m.get('userRole') is not None:
            self.user_role = m.get('userRole')
        return self


class CardQueryCardFeedsResponseBodyResultPostsContent(TeaModel):
    def __init__(
        self,
        content_type: int = None,
        text: str = None,
    ):
        self.content_type = content_type
        self.text = text

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.content_type is not None:
            result['contentType'] = self.content_type
        if self.text is not None:
            result['text'] = self.text
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('contentType') is not None:
            self.content_type = m.get('contentType')
        if m.get('text') is not None:
            self.text = m.get('text')
        return self


class CardQueryCardFeedsResponseBodyResultPosts(TeaModel):
    def __init__(
        self,
        author: CardQueryCardFeedsResponseBodyResultPostsAuthor = None,
        biz_type: int = None,
        content: CardQueryCardFeedsResponseBodyResultPostsContent = None,
        create_at: int = None,
        feed_type: int = None,
        post_id: int = None,
        status: int = None,
    ):
        self.author = author
        self.biz_type = biz_type
        self.content = content
        self.create_at = create_at
        self.feed_type = feed_type
        self.post_id = post_id
        self.status = status

    def validate(self):
        if self.author:
            self.author.validate()
        if self.content:
            self.content.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.author is not None:
            result['author'] = self.author.to_map()
        if self.biz_type is not None:
            result['bizType'] = self.biz_type
        if self.content is not None:
            result['content'] = self.content.to_map()
        if self.create_at is not None:
            result['createAt'] = self.create_at
        if self.feed_type is not None:
            result['feedType'] = self.feed_type
        if self.post_id is not None:
            result['postId'] = self.post_id
        if self.status is not None:
            result['status'] = self.status
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('author') is not None:
            temp_model = CardQueryCardFeedsResponseBodyResultPostsAuthor()
            self.author = temp_model.from_map(m['author'])
        if m.get('bizType') is not None:
            self.biz_type = m.get('bizType')
        if m.get('content') is not None:
            temp_model = CardQueryCardFeedsResponseBodyResultPostsContent()
            self.content = temp_model.from_map(m['content'])
        if m.get('createAt') is not None:
            self.create_at = m.get('createAt')
        if m.get('feedType') is not None:
            self.feed_type = m.get('feedType')
        if m.get('postId') is not None:
            self.post_id = m.get('postId')
        if m.get('status') is not None:
            self.status = m.get('status')
        return self


class CardQueryCardFeedsResponseBodyResult(TeaModel):
    def __init__(
        self,
        has_more: bool = None,
        posts: List[CardQueryCardFeedsResponseBodyResultPosts] = None,
    ):
        self.has_more = has_more
        self.posts = posts

    def validate(self):
        if self.posts:
            for k in self.posts:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.has_more is not None:
            result['hasMore'] = self.has_more
        result['posts'] = []
        if self.posts is not None:
            for k in self.posts:
                result['posts'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('hasMore') is not None:
            self.has_more = m.get('hasMore')
        self.posts = []
        if m.get('posts') is not None:
            for k in m.get('posts'):
                temp_model = CardQueryCardFeedsResponseBodyResultPosts()
                self.posts.append(temp_model.from_map(k))
        return self


class CardQueryCardFeedsResponseBody(TeaModel):
    def __init__(
        self,
        result: CardQueryCardFeedsResponseBodyResult = None,
        success: bool = None,
    ):
        self.result = result
        self.success = success

    def validate(self):
        if self.result:
            self.result.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.result is not None:
            result['result'] = self.result.to_map()
        if self.success is not None:
            result['success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('result') is not None:
            temp_model = CardQueryCardFeedsResponseBodyResult()
            self.result = temp_model.from_map(m['result'])
        if m.get('success') is not None:
            self.success = m.get('success')
        return self


class CardQueryCardFeedsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CardQueryCardFeedsResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CardQueryCardFeedsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CheckRestrictionHeaders(TeaModel):
    def __init__(
        self,
        common_headers: Dict[str, str] = None,
        x_acs_dingtalk_access_token: str = None,
    ):
        self.common_headers = common_headers
        self.x_acs_dingtalk_access_token = x_acs_dingtalk_access_token

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.common_headers is not None:
            result['commonHeaders'] = self.common_headers
        if self.x_acs_dingtalk_access_token is not None:
            result['x-acs-dingtalk-access-token'] = self.x_acs_dingtalk_access_token
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('commonHeaders') is not None:
            self.common_headers = m.get('commonHeaders')
        if m.get('x-acs-dingtalk-access-token') is not None:
            self.x_acs_dingtalk_access_token = m.get('x-acs-dingtalk-access-token')
        return self


class CheckRestrictionRequest(TeaModel):
    def __init__(
        self,
        actual_amount: int = None,
        face_id: str = None,
        scene: int = None,
        sn: str = None,
        user_id: str = None,
    ):
        # This parameter is required.
        self.actual_amount = actual_amount
        # This parameter is required.
        self.face_id = face_id
        # This parameter is required.
        self.scene = scene
        # This parameter is required.
        self.sn = sn
        # This parameter is required.
        self.user_id = user_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.actual_amount is not None:
            result['actualAmount'] = self.actual_amount
        if self.face_id is not None:
            result['faceId'] = self.face_id
        if self.scene is not None:
            result['scene'] = self.scene
        if self.sn is not None:
            result['sn'] = self.sn
        if self.user_id is not None:
            result['userId'] = self.user_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('actualAmount') is not None:
            self.actual_amount = m.get('actualAmount')
        if m.get('faceId') is not None:
            self.face_id = m.get('faceId')
        if m.get('scene') is not None:
            self.scene = m.get('scene')
        if m.get('sn') is not None:
            self.sn = m.get('sn')
        if m.get('userId') is not None:
            self.user_id = m.get('userId')
        return self


class CheckRestrictionResponseBody(TeaModel):
    def __init__(
        self,
        success: bool = None,
    ):
        # This parameter is required.
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.success is not None:
            result['success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('success') is not None:
            self.success = m.get('success')
        return self


class CheckRestrictionResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CheckRestrictionResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CheckRestrictionResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ClearEvaluatePerformanceCountHeaders(TeaModel):
    def __init__(
        self,
        common_headers: Dict[str, str] = None,
        x_acs_dingtalk_access_token: str = None,
    ):
        self.common_headers = common_headers
        self.x_acs_dingtalk_access_token = x_acs_dingtalk_access_token

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.common_headers is not None:
            result['commonHeaders'] = self.common_headers
        if self.x_acs_dingtalk_access_token is not None:
            result['x-acs-dingtalk-access-token'] = self.x_acs_dingtalk_access_token
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('commonHeaders') is not None:
            self.common_headers = m.get('commonHeaders')
        if m.get('x-acs-dingtalk-access-token') is not None:
            self.x_acs_dingtalk_access_token = m.get('x-acs-dingtalk-access-token')
        return self


class ClearEvaluatePerformanceCountRequest(TeaModel):
    def __init__(
        self,
        student_id_list: List[str] = None,
    ):
        self.student_id_list = student_id_list

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.student_id_list is not None:
            result['studentIdList'] = self.student_id_list
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('studentIdList') is not None:
            self.student_id_list = m.get('studentIdList')
        return self


class ClearEvaluatePerformanceCountResponseBody(TeaModel):
    def __init__(
        self,
        success: bool = None,
    ):
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.success is not None:
            result['success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('success') is not None:
            self.success = m.get('success')
        return self


class ClearEvaluatePerformanceCountResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: ClearEvaluatePerformanceCountResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ClearEvaluatePerformanceCountResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ConsumePointHeaders(TeaModel):
    def __init__(
        self,
        common_headers: Dict[str, str] = None,
        x_acs_dingtalk_access_token: str = None,
    ):
        self.common_headers = common_headers
        self.x_acs_dingtalk_access_token = x_acs_dingtalk_access_token

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.common_headers is not None:
            result['commonHeaders'] = self.common_headers
        if self.x_acs_dingtalk_access_token is not None:
            result['x-acs-dingtalk-access-token'] = self.x_acs_dingtalk_access_token
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('commonHeaders') is not None:
            self.common_headers = m.get('commonHeaders')
        if m.get('x-acs-dingtalk-access-token') is not None:
            self.x_acs_dingtalk_access_token = m.get('x-acs-dingtalk-access-token')
        return self


class ConsumePointRequest(TeaModel):
    def __init__(
        self,
        amount: int = None,
        biz_id: str = None,
        description: str = None,
        product_code: str = None,
    ):
        # This parameter is required.
        self.amount = amount
        # This parameter is required.
        self.biz_id = biz_id
        self.description = description
        # This parameter is required.
        self.product_code = product_code

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.amount is not None:
            result['amount'] = self.amount
        if self.biz_id is not None:
            result['bizId'] = self.biz_id
        if self.description is not None:
            result['description'] = self.description
        if self.product_code is not None:
            result['productCode'] = self.product_code
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('amount') is not None:
            self.amount = m.get('amount')
        if m.get('bizId') is not None:
            self.biz_id = m.get('bizId')
        if m.get('description') is not None:
            self.description = m.get('description')
        if m.get('productCode') is not None:
            self.product_code = m.get('productCode')
        return self


class ConsumePointResponseBody(TeaModel):
    def __init__(
        self,
        result: bool = None,
        success: bool = None,
    ):
        self.result = result
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.result is not None:
            result['result'] = self.result
        if self.success is not None:
            result['success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('result') is not None:
            self.result = m.get('result')
        if m.get('success') is not None:
            self.success = m.get('success')
        return self


class ConsumePointResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: ConsumePointResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ConsumePointResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CourseSchedulingComplimentNoticeHeaders(TeaModel):
    def __init__(
        self,
        common_headers: Dict[str, str] = None,
        x_acs_dingtalk_access_token: str = None,
    ):
        self.common_headers = common_headers
        self.x_acs_dingtalk_access_token = x_acs_dingtalk_access_token

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.common_headers is not None:
            result['commonHeaders'] = self.common_headers
        if self.x_acs_dingtalk_access_token is not None:
            result['x-acs-dingtalk-access-token'] = self.x_acs_dingtalk_access_token
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('commonHeaders') is not None:
            self.common_headers = m.get('commonHeaders')
        if m.get('x-acs-dingtalk-access-token') is not None:
            self.x_acs_dingtalk_access_token = m.get('x-acs-dingtalk-access-token')
        return self


class CourseSchedulingComplimentNoticeRequest(TeaModel):
    def __init__(
        self,
        op_user_id: str = None,
    ):
        # This parameter is required.
        self.op_user_id = op_user_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.op_user_id is not None:
            result['opUserId'] = self.op_user_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('opUserId') is not None:
            self.op_user_id = m.get('opUserId')
        return self


class CourseSchedulingComplimentNoticeResponseBody(TeaModel):
    def __init__(
        self,
        result: bool = None,
    ):
        self.result = result

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.result is not None:
            result['result'] = self.result
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('result') is not None:
            self.result = m.get('result')
        return self


class CourseSchedulingComplimentNoticeResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CourseSchedulingComplimentNoticeResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CourseSchedulingComplimentNoticeResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateAppOrderHeaders(TeaModel):
    def __init__(
        self,
        common_headers: Dict[str, str] = None,
        x_acs_dingtalk_access_token: str = None,
    ):
        self.common_headers = common_headers
        self.x_acs_dingtalk_access_token = x_acs_dingtalk_access_token

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.common_headers is not None:
            result['commonHeaders'] = self.common_headers
        if self.x_acs_dingtalk_access_token is not None:
            result['x-acs-dingtalk-access-token'] = self.x_acs_dingtalk_access_token
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('commonHeaders') is not None:
            self.common_headers = m.get('commonHeaders')
        if m.get('x-acs-dingtalk-access-token') is not None:
            self.x_acs_dingtalk_access_token = m.get('x-acs-dingtalk-access-token')
        return self


class CreateAppOrderRequestDetailList(TeaModel):
    def __init__(
        self,
        goods_id: str = None,
        goods_name: str = None,
        goods_price: int = None,
        goods_quantity: int = None,
    ):
        # This parameter is required.
        self.goods_id = goods_id
        # This parameter is required.
        self.goods_name = goods_name
        # This parameter is required.
        self.goods_price = goods_price
        # This parameter is required.
        self.goods_quantity = goods_quantity

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.goods_id is not None:
            result['goodsId'] = self.goods_id
        if self.goods_name is not None:
            result['goodsName'] = self.goods_name
        if self.goods_price is not None:
            result['goodsPrice'] = self.goods_price
        if self.goods_quantity is not None:
            result['goodsQuantity'] = self.goods_quantity
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('goodsId') is not None:
            self.goods_id = m.get('goodsId')
        if m.get('goodsName') is not None:
            self.goods_name = m.get('goodsName')
        if m.get('goodsPrice') is not None:
            self.goods_price = m.get('goodsPrice')
        if m.get('goodsQuantity') is not None:
            self.goods_quantity = m.get('goodsQuantity')
        return self


class CreateAppOrderRequest(TeaModel):
    def __init__(
        self,
        actual_amount: int = None,
        alipay_app_id: str = None,
        biz_code: int = None,
        detail_list: List[CreateAppOrderRequestDetailList] = None,
        label_amount: int = None,
        merchant_id: str = None,
        merchant_order_no: str = None,
        outer_user_id: str = None,
        signature: str = None,
        subject: str = None,
        timestamp: int = None,
    ):
        # This parameter is required.
        self.actual_amount = actual_amount
        # This parameter is required.
        self.alipay_app_id = alipay_app_id
        # This parameter is required.
        self.biz_code = biz_code
        # This parameter is required.
        self.detail_list = detail_list
        self.label_amount = label_amount
        # This parameter is required.
        self.merchant_id = merchant_id
        # This parameter is required.
        self.merchant_order_no = merchant_order_no
        # This parameter is required.
        self.outer_user_id = outer_user_id
        # This parameter is required.
        self.signature = signature
        # This parameter is required.
        self.subject = subject
        # This parameter is required.
        self.timestamp = timestamp

    def validate(self):
        if self.detail_list:
            for k in self.detail_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.actual_amount is not None:
            result['actualAmount'] = self.actual_amount
        if self.alipay_app_id is not None:
            result['alipayAppId'] = self.alipay_app_id
        if self.biz_code is not None:
            result['bizCode'] = self.biz_code
        result['detailList'] = []
        if self.detail_list is not None:
            for k in self.detail_list:
                result['detailList'].append(k.to_map() if k else None)
        if self.label_amount is not None:
            result['labelAmount'] = self.label_amount
        if self.merchant_id is not None:
            result['merchantId'] = self.merchant_id
        if self.merchant_order_no is not None:
            result['merchantOrderNo'] = self.merchant_order_no
        if self.outer_user_id is not None:
            result['outerUserId'] = self.outer_user_id
        if self.signature is not None:
            result['signature'] = self.signature
        if self.subject is not None:
            result['subject'] = self.subject
        if self.timestamp is not None:
            result['timestamp'] = self.timestamp
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('actualAmount') is not None:
            self.actual_amount = m.get('actualAmount')
        if m.get('alipayAppId') is not None:
            self.alipay_app_id = m.get('alipayAppId')
        if m.get('bizCode') is not None:
            self.biz_code = m.get('bizCode')
        self.detail_list = []
        if m.get('detailList') is not None:
            for k in m.get('detailList'):
                temp_model = CreateAppOrderRequestDetailList()
                self.detail_list.append(temp_model.from_map(k))
        if m.get('labelAmount') is not None:
            self.label_amount = m.get('labelAmount')
        if m.get('merchantId') is not None:
            self.merchant_id = m.get('merchantId')
        if m.get('merchantOrderNo') is not None:
            self.merchant_order_no = m.get('merchantOrderNo')
        if m.get('outerUserId') is not None:
            self.outer_user_id = m.get('outerUserId')
        if m.get('signature') is not None:
            self.signature = m.get('signature')
        if m.get('subject') is not None:
            self.subject = m.get('subject')
        if m.get('timestamp') is not None:
            self.timestamp = m.get('timestamp')
        return self


class CreateAppOrderResponseBody(TeaModel):
    def __init__(
        self,
        actual_amount: int = None,
        alipay_app_id: str = None,
        body: str = None,
        merchant_id: str = None,
        merchant_order_no: str = None,
        order_no: str = None,
    ):
        self.actual_amount = actual_amount
        self.alipay_app_id = alipay_app_id
        self.body = body
        self.merchant_id = merchant_id
        self.merchant_order_no = merchant_order_no
        self.order_no = order_no

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.actual_amount is not None:
            result['actualAmount'] = self.actual_amount
        if self.alipay_app_id is not None:
            result['alipayAppId'] = self.alipay_app_id
        if self.body is not None:
            result['body'] = self.body
        if self.merchant_id is not None:
            result['merchantId'] = self.merchant_id
        if self.merchant_order_no is not None:
            result['merchantOrderNo'] = self.merchant_order_no
        if self.order_no is not None:
            result['orderNo'] = self.order_no
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('actualAmount') is not None:
            self.actual_amount = m.get('actualAmount')
        if m.get('alipayAppId') is not None:
            self.alipay_app_id = m.get('alipayAppId')
        if m.get('body') is not None:
            self.body = m.get('body')
        if m.get('merchantId') is not None:
            self.merchant_id = m.get('merchantId')
        if m.get('merchantOrderNo') is not None:
            self.merchant_order_no = m.get('merchantOrderNo')
        if m.get('orderNo') is not None:
            self.order_no = m.get('orderNo')
        return self


class CreateAppOrderResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateAppOrderResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateAppOrderResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateCollegeContactDeptHeaders(TeaModel):
    def __init__(
        self,
        common_headers: Dict[str, str] = None,
        x_acs_dingtalk_access_token: str = None,
    ):
        self.common_headers = common_headers
        self.x_acs_dingtalk_access_token = x_acs_dingtalk_access_token

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.common_headers is not None:
            result['commonHeaders'] = self.common_headers
        if self.x_acs_dingtalk_access_token is not None:
            result['x-acs-dingtalk-access-token'] = self.x_acs_dingtalk_access_token
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('commonHeaders') is not None:
            self.common_headers = m.get('commonHeaders')
        if m.get('x-acs-dingtalk-access-token') is not None:
            self.x_acs_dingtalk_access_token = m.get('x-acs-dingtalk-access-token')
        return self


class CreateCollegeContactDeptRequestHideSceneConfig(TeaModel):
    def __init__(
        self,
        active: bool = None,
        chatbox_subtitle: bool = None,
        node_list: bool = None,
        profile: bool = None,
        search: bool = None,
    ):
        self.active = active
        self.chatbox_subtitle = chatbox_subtitle
        self.node_list = node_list
        self.profile = profile
        self.search = search

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.active is not None:
            result['active'] = self.active
        if self.chatbox_subtitle is not None:
            result['chatboxSubtitle'] = self.chatbox_subtitle
        if self.node_list is not None:
            result['nodeList'] = self.node_list
        if self.profile is not None:
            result['profile'] = self.profile
        if self.search is not None:
            result['search'] = self.search
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('active') is not None:
            self.active = m.get('active')
        if m.get('chatboxSubtitle') is not None:
            self.chatbox_subtitle = m.get('chatboxSubtitle')
        if m.get('nodeList') is not None:
            self.node_list = m.get('nodeList')
        if m.get('profile') is not None:
            self.profile = m.get('profile')
        if m.get('search') is not None:
            self.search = m.get('search')
        return self


class CreateCollegeContactDeptRequestOuterSceneConfig(TeaModel):
    def __init__(
        self,
        active: bool = None,
        chatbox_subtitle: bool = None,
        node_list: bool = None,
        profile: bool = None,
        search: bool = None,
    ):
        self.active = active
        self.chatbox_subtitle = chatbox_subtitle
        self.node_list = node_list
        self.profile = profile
        self.search = search

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.active is not None:
            result['active'] = self.active
        if self.chatbox_subtitle is not None:
            result['chatboxSubtitle'] = self.chatbox_subtitle
        if self.node_list is not None:
            result['nodeList'] = self.node_list
        if self.profile is not None:
            result['profile'] = self.profile
        if self.search is not None:
            result['search'] = self.search
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('active') is not None:
            self.active = m.get('active')
        if m.get('chatboxSubtitle') is not None:
            self.chatbox_subtitle = m.get('chatboxSubtitle')
        if m.get('nodeList') is not None:
            self.node_list = m.get('nodeList')
        if m.get('profile') is not None:
            self.profile = m.get('profile')
        if m.get('search') is not None:
            self.search = m.get('search')
        return self


class CreateCollegeContactDeptRequest(TeaModel):
    def __init__(
        self,
        auto_approve_apply: bool = None,
        brief: str = None,
        code: str = None,
        create_dept_group: bool = None,
        dept_code: str = None,
        dept_permits: List[int] = None,
        dept_type: str = None,
        emp_apply_join_dept: bool = None,
        extension: Dict[str, str] = None,
        hide_dept: bool = None,
        hide_scene_config: CreateCollegeContactDeptRequestHideSceneConfig = None,
        name: str = None,
        order: int = None,
        outer_dept: bool = None,
        outer_dept_only_self: bool = None,
        outer_permit_depts: List[int] = None,
        outer_permit_users: List[str] = None,
        outer_scene_config: CreateCollegeContactDeptRequestOuterSceneConfig = None,
        parent_id: int = None,
        source_identifier: str = None,
        stru_id: int = None,
        telephone: str = None,
        user_permits: List[str] = None,
    ):
        self.auto_approve_apply = auto_approve_apply
        self.brief = brief
        self.code = code
        self.create_dept_group = create_dept_group
        self.dept_code = dept_code
        self.dept_permits = dept_permits
        # This parameter is required.
        self.dept_type = dept_type
        self.emp_apply_join_dept = emp_apply_join_dept
        self.extension = extension
        self.hide_dept = hide_dept
        self.hide_scene_config = hide_scene_config
        # This parameter is required.
        self.name = name
        self.order = order
        self.outer_dept = outer_dept
        self.outer_dept_only_self = outer_dept_only_self
        self.outer_permit_depts = outer_permit_depts
        self.outer_permit_users = outer_permit_users
        self.outer_scene_config = outer_scene_config
        # This parameter is required.
        self.parent_id = parent_id
        self.source_identifier = source_identifier
        # This parameter is required.
        self.stru_id = stru_id
        self.telephone = telephone
        self.user_permits = user_permits

    def validate(self):
        if self.hide_scene_config:
            self.hide_scene_config.validate()
        if self.outer_scene_config:
            self.outer_scene_config.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.auto_approve_apply is not None:
            result['autoApproveApply'] = self.auto_approve_apply
        if self.brief is not None:
            result['brief'] = self.brief
        if self.code is not None:
            result['code'] = self.code
        if self.create_dept_group is not None:
            result['createDeptGroup'] = self.create_dept_group
        if self.dept_code is not None:
            result['deptCode'] = self.dept_code
        if self.dept_permits is not None:
            result['deptPermits'] = self.dept_permits
        if self.dept_type is not None:
            result['deptType'] = self.dept_type
        if self.emp_apply_join_dept is not None:
            result['empApplyJoinDept'] = self.emp_apply_join_dept
        if self.extension is not None:
            result['extension'] = self.extension
        if self.hide_dept is not None:
            result['hideDept'] = self.hide_dept
        if self.hide_scene_config is not None:
            result['hideSceneConfig'] = self.hide_scene_config.to_map()
        if self.name is not None:
            result['name'] = self.name
        if self.order is not None:
            result['order'] = self.order
        if self.outer_dept is not None:
            result['outerDept'] = self.outer_dept
        if self.outer_dept_only_self is not None:
            result['outerDeptOnlySelf'] = self.outer_dept_only_self
        if self.outer_permit_depts is not None:
            result['outerPermitDepts'] = self.outer_permit_depts
        if self.outer_permit_users is not None:
            result['outerPermitUsers'] = self.outer_permit_users
        if self.outer_scene_config is not None:
            result['outerSceneConfig'] = self.outer_scene_config.to_map()
        if self.parent_id is not None:
            result['parentId'] = self.parent_id
        if self.source_identifier is not None:
            result['sourceIdentifier'] = self.source_identifier
        if self.stru_id is not None:
            result['struId'] = self.stru_id
        if self.telephone is not None:
            result['telephone'] = self.telephone
        if self.user_permits is not None:
            result['userPermits'] = self.user_permits
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('autoApproveApply') is not None:
            self.auto_approve_apply = m.get('autoApproveApply')
        if m.get('brief') is not None:
            self.brief = m.get('brief')
        if m.get('code') is not None:
            self.code = m.get('code')
        if m.get('createDeptGroup') is not None:
            self.create_dept_group = m.get('createDeptGroup')
        if m.get('deptCode') is not None:
            self.dept_code = m.get('deptCode')
        if m.get('deptPermits') is not None:
            self.dept_permits = m.get('deptPermits')
        if m.get('deptType') is not None:
            self.dept_type = m.get('deptType')
        if m.get('empApplyJoinDept') is not None:
            self.emp_apply_join_dept = m.get('empApplyJoinDept')
        if m.get('extension') is not None:
            self.extension = m.get('extension')
        if m.get('hideDept') is not None:
            self.hide_dept = m.get('hideDept')
        if m.get('hideSceneConfig') is not None:
            temp_model = CreateCollegeContactDeptRequestHideSceneConfig()
            self.hide_scene_config = temp_model.from_map(m['hideSceneConfig'])
        if m.get('name') is not None:
            self.name = m.get('name')
        if m.get('order') is not None:
            self.order = m.get('order')
        if m.get('outerDept') is not None:
            self.outer_dept = m.get('outerDept')
        if m.get('outerDeptOnlySelf') is not None:
            self.outer_dept_only_self = m.get('outerDeptOnlySelf')
        if m.get('outerPermitDepts') is not None:
            self.outer_permit_depts = m.get('outerPermitDepts')
        if m.get('outerPermitUsers') is not None:
            self.outer_permit_users = m.get('outerPermitUsers')
        if m.get('outerSceneConfig') is not None:
            temp_model = CreateCollegeContactDeptRequestOuterSceneConfig()
            self.outer_scene_config = temp_model.from_map(m['outerSceneConfig'])
        if m.get('parentId') is not None:
            self.parent_id = m.get('parentId')
        if m.get('sourceIdentifier') is not None:
            self.source_identifier = m.get('sourceIdentifier')
        if m.get('struId') is not None:
            self.stru_id = m.get('struId')
        if m.get('telephone') is not None:
            self.telephone = m.get('telephone')
        if m.get('userPermits') is not None:
            self.user_permits = m.get('userPermits')
        return self


class CreateCollegeContactDeptResponseBodyResult(TeaModel):
    def __init__(
        self,
        dept_id: int = None,
    ):
        self.dept_id = dept_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dept_id is not None:
            result['deptId'] = self.dept_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('deptId') is not None:
            self.dept_id = m.get('deptId')
        return self


class CreateCollegeContactDeptResponseBody(TeaModel):
    def __init__(
        self,
        result: CreateCollegeContactDeptResponseBodyResult = None,
        success: bool = None,
    ):
        self.result = result
        self.success = success

    def validate(self):
        if self.result:
            self.result.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.result is not None:
            result['result'] = self.result.to_map()
        if self.success is not None:
            result['success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('result') is not None:
            temp_model = CreateCollegeContactDeptResponseBodyResult()
            self.result = temp_model.from_map(m['result'])
        if m.get('success') is not None:
            self.success = m.get('success')
        return self


class CreateCollegeContactDeptResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateCollegeContactDeptResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateCollegeContactDeptResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateCollegeContactSceneStruHeaders(TeaModel):
    def __init__(
        self,
        common_headers: Dict[str, str] = None,
        x_acs_dingtalk_access_token: str = None,
    ):
        self.common_headers = common_headers
        self.x_acs_dingtalk_access_token = x_acs_dingtalk_access_token

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.common_headers is not None:
            result['commonHeaders'] = self.common_headers
        if self.x_acs_dingtalk_access_token is not None:
            result['x-acs-dingtalk-access-token'] = self.x_acs_dingtalk_access_token
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('commonHeaders') is not None:
            self.common_headers = m.get('commonHeaders')
        if m.get('x-acs-dingtalk-access-token') is not None:
            self.x_acs_dingtalk_access_token = m.get('x-acs-dingtalk-access-token')
        return self


class CreateCollegeContactSceneStruRequest(TeaModel):
    def __init__(
        self,
        has_stru_fixed_dept: bool = None,
        order: int = None,
        source_identifier: str = None,
        stru_brief: str = None,
        stru_name: str = None,
        stru_type: str = None,
    ):
        # This parameter is required.
        self.has_stru_fixed_dept = has_stru_fixed_dept
        self.order = order
        self.source_identifier = source_identifier
        self.stru_brief = stru_brief
        # This parameter is required.
        self.stru_name = stru_name
        # This parameter is required.
        self.stru_type = stru_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.has_stru_fixed_dept is not None:
            result['hasStruFixedDept'] = self.has_stru_fixed_dept
        if self.order is not None:
            result['order'] = self.order
        if self.source_identifier is not None:
            result['sourceIdentifier'] = self.source_identifier
        if self.stru_brief is not None:
            result['struBrief'] = self.stru_brief
        if self.stru_name is not None:
            result['struName'] = self.stru_name
        if self.stru_type is not None:
            result['struType'] = self.stru_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('hasStruFixedDept') is not None:
            self.has_stru_fixed_dept = m.get('hasStruFixedDept')
        if m.get('order') is not None:
            self.order = m.get('order')
        if m.get('sourceIdentifier') is not None:
            self.source_identifier = m.get('sourceIdentifier')
        if m.get('struBrief') is not None:
            self.stru_brief = m.get('struBrief')
        if m.get('struName') is not None:
            self.stru_name = m.get('struName')
        if m.get('struType') is not None:
            self.stru_type = m.get('struType')
        return self


class CreateCollegeContactSceneStruResponseBodyResult(TeaModel):
    def __init__(
        self,
        stru_id: int = None,
        student_dept_id: int = None,
        teacher_dept_id: int = None,
    ):
        self.stru_id = stru_id
        self.student_dept_id = student_dept_id
        self.teacher_dept_id = teacher_dept_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.stru_id is not None:
            result['struId'] = self.stru_id
        if self.student_dept_id is not None:
            result['studentDeptId'] = self.student_dept_id
        if self.teacher_dept_id is not None:
            result['teacherDeptId'] = self.teacher_dept_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('struId') is not None:
            self.stru_id = m.get('struId')
        if m.get('studentDeptId') is not None:
            self.student_dept_id = m.get('studentDeptId')
        if m.get('teacherDeptId') is not None:
            self.teacher_dept_id = m.get('teacherDeptId')
        return self


class CreateCollegeContactSceneStruResponseBody(TeaModel):
    def __init__(
        self,
        result: CreateCollegeContactSceneStruResponseBodyResult = None,
        success: bool = None,
    ):
        self.result = result
        self.success = success

    def validate(self):
        if self.result:
            self.result.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.result is not None:
            result['result'] = self.result.to_map()
        if self.success is not None:
            result['success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('result') is not None:
            temp_model = CreateCollegeContactSceneStruResponseBodyResult()
            self.result = temp_model.from_map(m['result'])
        if m.get('success') is not None:
            self.success = m.get('success')
        return self


class CreateCollegeContactSceneStruResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateCollegeContactSceneStruResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateCollegeContactSceneStruResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateCourseHeaders(TeaModel):
    def __init__(
        self,
        common_headers: Dict[str, str] = None,
        x_acs_dingtalk_access_token: str = None,
    ):
        self.common_headers = common_headers
        self.x_acs_dingtalk_access_token = x_acs_dingtalk_access_token

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.common_headers is not None:
            result['commonHeaders'] = self.common_headers
        if self.x_acs_dingtalk_access_token is not None:
            result['x-acs-dingtalk-access-token'] = self.x_acs_dingtalk_access_token
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('commonHeaders') is not None:
            self.common_headers = m.get('commonHeaders')
        if m.get('x-acs-dingtalk-access-token') is not None:
            self.x_acs_dingtalk_access_token = m.get('x-acs-dingtalk-access-token')
        return self


class CreateCourseRequestTeacherList(TeaModel):
    def __init__(
        self,
        teacher_name: str = None,
        teacher_user_id: str = None,
    ):
        self.teacher_name = teacher_name
        self.teacher_user_id = teacher_user_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.teacher_name is not None:
            result['teacherName'] = self.teacher_name
        if self.teacher_user_id is not None:
            result['teacherUserId'] = self.teacher_user_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('teacherName') is not None:
            self.teacher_name = m.get('teacherName')
        if m.get('teacherUserId') is not None:
            self.teacher_user_id = m.get('teacherUserId')
        return self


class CreateCourseRequest(TeaModel):
    def __init__(
        self,
        attributes: str = None,
        class_id: str = None,
        class_name: str = None,
        class_room_id: str = None,
        class_room_name: str = None,
        class_type: int = None,
        corp_id: str = None,
        course_code: str = None,
        course_date: int = None,
        course_name: str = None,
        course_week: int = None,
        end_time: int = None,
        isv_code: str = None,
        isv_course_id: str = None,
        memo: str = None,
        school_year: str = None,
        semester: int = None,
        start_time: int = None,
        status: int = None,
        teach_week: int = None,
        teacher_list: List[CreateCourseRequestTeacherList] = None,
        timeslot_name: str = None,
        timeslot_num: int = None,
        type: int = None,
    ):
        self.attributes = attributes
        self.class_id = class_id
        self.class_name = class_name
        self.class_room_id = class_room_id
        self.class_room_name = class_room_name
        self.class_type = class_type
        self.corp_id = corp_id
        self.course_code = course_code
        self.course_date = course_date
        self.course_name = course_name
        self.course_week = course_week
        self.end_time = end_time
        self.isv_code = isv_code
        self.isv_course_id = isv_course_id
        self.memo = memo
        self.school_year = school_year
        self.semester = semester
        self.start_time = start_time
        self.status = status
        self.teach_week = teach_week
        self.teacher_list = teacher_list
        self.timeslot_name = timeslot_name
        self.timeslot_num = timeslot_num
        self.type = type

    def validate(self):
        if self.teacher_list:
            for k in self.teacher_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.attributes is not None:
            result['attributes'] = self.attributes
        if self.class_id is not None:
            result['classId'] = self.class_id
        if self.class_name is not None:
            result['className'] = self.class_name
        if self.class_room_id is not None:
            result['classRoomId'] = self.class_room_id
        if self.class_room_name is not None:
            result['classRoomName'] = self.class_room_name
        if self.class_type is not None:
            result['classType'] = self.class_type
        if self.corp_id is not None:
            result['corpId'] = self.corp_id
        if self.course_code is not None:
            result['courseCode'] = self.course_code
        if self.course_date is not None:
            result['courseDate'] = self.course_date
        if self.course_name is not None:
            result['courseName'] = self.course_name
        if self.course_week is not None:
            result['courseWeek'] = self.course_week
        if self.end_time is not None:
            result['endTime'] = self.end_time
        if self.isv_code is not None:
            result['isvCode'] = self.isv_code
        if self.isv_course_id is not None:
            result['isvCourseId'] = self.isv_course_id
        if self.memo is not None:
            result['memo'] = self.memo
        if self.school_year is not None:
            result['schoolYear'] = self.school_year
        if self.semester is not None:
            result['semester'] = self.semester
        if self.start_time is not None:
            result['startTime'] = self.start_time
        if self.status is not None:
            result['status'] = self.status
        if self.teach_week is not None:
            result['teachWeek'] = self.teach_week
        result['teacherList'] = []
        if self.teacher_list is not None:
            for k in self.teacher_list:
                result['teacherList'].append(k.to_map() if k else None)
        if self.timeslot_name is not None:
            result['timeslotName'] = self.timeslot_name
        if self.timeslot_num is not None:
            result['timeslotNum'] = self.timeslot_num
        if self.type is not None:
            result['type'] = self.type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('attributes') is not None:
            self.attributes = m.get('attributes')
        if m.get('classId') is not None:
            self.class_id = m.get('classId')
        if m.get('className') is not None:
            self.class_name = m.get('className')
        if m.get('classRoomId') is not None:
            self.class_room_id = m.get('classRoomId')
        if m.get('classRoomName') is not None:
            self.class_room_name = m.get('classRoomName')
        if m.get('classType') is not None:
            self.class_type = m.get('classType')
        if m.get('corpId') is not None:
            self.corp_id = m.get('corpId')
        if m.get('courseCode') is not None:
            self.course_code = m.get('courseCode')
        if m.get('courseDate') is not None:
            self.course_date = m.get('courseDate')
        if m.get('courseName') is not None:
            self.course_name = m.get('courseName')
        if m.get('courseWeek') is not None:
            self.course_week = m.get('courseWeek')
        if m.get('endTime') is not None:
            self.end_time = m.get('endTime')
        if m.get('isvCode') is not None:
            self.isv_code = m.get('isvCode')
        if m.get('isvCourseId') is not None:
            self.isv_course_id = m.get('isvCourseId')
        if m.get('memo') is not None:
            self.memo = m.get('memo')
        if m.get('schoolYear') is not None:
            self.school_year = m.get('schoolYear')
        if m.get('semester') is not None:
            self.semester = m.get('semester')
        if m.get('startTime') is not None:
            self.start_time = m.get('startTime')
        if m.get('status') is not None:
            self.status = m.get('status')
        if m.get('teachWeek') is not None:
            self.teach_week = m.get('teachWeek')
        self.teacher_list = []
        if m.get('teacherList') is not None:
            for k in m.get('teacherList'):
                temp_model = CreateCourseRequestTeacherList()
                self.teacher_list.append(temp_model.from_map(k))
        if m.get('timeslotName') is not None:
            self.timeslot_name = m.get('timeslotName')
        if m.get('timeslotNum') is not None:
            self.timeslot_num = m.get('timeslotNum')
        if m.get('type') is not None:
            self.type = m.get('type')
        return self


class CreateCourseResponseBody(TeaModel):
    def __init__(
        self,
        result: int = None,
        success: bool = None,
    ):
        self.result = result
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.result is not None:
            result['result'] = self.result
        if self.success is not None:
            result['success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('result') is not None:
            self.result = m.get('result')
        if m.get('success') is not None:
            self.success = m.get('success')
        return self


class CreateCourseResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateCourseResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateCourseResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateCustomClassHeaders(TeaModel):
    def __init__(
        self,
        common_headers: Dict[str, str] = None,
        x_acs_dingtalk_access_token: str = None,
    ):
        self.common_headers = common_headers
        self.x_acs_dingtalk_access_token = x_acs_dingtalk_access_token

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.common_headers is not None:
            result['commonHeaders'] = self.common_headers
        if self.x_acs_dingtalk_access_token is not None:
            result['x-acs-dingtalk-access-token'] = self.x_acs_dingtalk_access_token
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('commonHeaders') is not None:
            self.common_headers = m.get('commonHeaders')
        if m.get('x-acs-dingtalk-access-token') is not None:
            self.x_acs_dingtalk_access_token = m.get('x-acs-dingtalk-access-token')
        return self


class CreateCustomClassRequestCustomClass(TeaModel):
    def __init__(
        self,
        name: str = None,
    ):
        # This parameter is required.
        self.name = name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.name is not None:
            result['name'] = self.name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('name') is not None:
            self.name = m.get('name')
        return self


class CreateCustomClassRequest(TeaModel):
    def __init__(
        self,
        custom_class: CreateCustomClassRequestCustomClass = None,
        operator: str = None,
        super_id: int = None,
    ):
        # This parameter is required.
        self.custom_class = custom_class
        # This parameter is required.
        self.operator = operator
        # This parameter is required.
        self.super_id = super_id

    def validate(self):
        if self.custom_class:
            self.custom_class.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.custom_class is not None:
            result['customClass'] = self.custom_class.to_map()
        if self.operator is not None:
            result['operator'] = self.operator
        if self.super_id is not None:
            result['superId'] = self.super_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('customClass') is not None:
            temp_model = CreateCustomClassRequestCustomClass()
            self.custom_class = temp_model.from_map(m['customClass'])
        if m.get('operator') is not None:
            self.operator = m.get('operator')
        if m.get('superId') is not None:
            self.super_id = m.get('superId')
        return self


class CreateCustomClassResponseBodyResult(TeaModel):
    def __init__(
        self,
        dept_id: int = None,
    ):
        self.dept_id = dept_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dept_id is not None:
            result['deptId'] = self.dept_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('deptId') is not None:
            self.dept_id = m.get('deptId')
        return self


class CreateCustomClassResponseBody(TeaModel):
    def __init__(
        self,
        result: CreateCustomClassResponseBodyResult = None,
        success: bool = None,
    ):
        self.result = result
        self.success = success

    def validate(self):
        if self.result:
            self.result.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.result is not None:
            result['result'] = self.result.to_map()
        if self.success is not None:
            result['success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('result') is not None:
            temp_model = CreateCustomClassResponseBodyResult()
            self.result = temp_model.from_map(m['result'])
        if m.get('success') is not None:
            self.success = m.get('success')
        return self


class CreateCustomClassResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateCustomClassResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateCustomClassResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateCustomDeptHeaders(TeaModel):
    def __init__(
        self,
        common_headers: Dict[str, str] = None,
        x_acs_dingtalk_access_token: str = None,
    ):
        self.common_headers = common_headers
        self.x_acs_dingtalk_access_token = x_acs_dingtalk_access_token

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.common_headers is not None:
            result['commonHeaders'] = self.common_headers
        if self.x_acs_dingtalk_access_token is not None:
            result['x-acs-dingtalk-access-token'] = self.x_acs_dingtalk_access_token
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('commonHeaders') is not None:
            self.common_headers = m.get('commonHeaders')
        if m.get('x-acs-dingtalk-access-token') is not None:
            self.x_acs_dingtalk_access_token = m.get('x-acs-dingtalk-access-token')
        return self


class CreateCustomDeptRequestCustomDept(TeaModel):
    def __init__(
        self,
        name: str = None,
        type: str = None,
    ):
        # This parameter is required.
        self.name = name
        # This parameter is required.
        self.type = type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.name is not None:
            result['name'] = self.name
        if self.type is not None:
            result['type'] = self.type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('name') is not None:
            self.name = m.get('name')
        if m.get('type') is not None:
            self.type = m.get('type')
        return self


class CreateCustomDeptRequest(TeaModel):
    def __init__(
        self,
        custom_dept: CreateCustomDeptRequestCustomDept = None,
        operator: str = None,
        super_id: int = None,
    ):
        # This parameter is required.
        self.custom_dept = custom_dept
        # This parameter is required.
        self.operator = operator
        # This parameter is required.
        self.super_id = super_id

    def validate(self):
        if self.custom_dept:
            self.custom_dept.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.custom_dept is not None:
            result['customDept'] = self.custom_dept.to_map()
        if self.operator is not None:
            result['operator'] = self.operator
        if self.super_id is not None:
            result['superId'] = self.super_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('customDept') is not None:
            temp_model = CreateCustomDeptRequestCustomDept()
            self.custom_dept = temp_model.from_map(m['customDept'])
        if m.get('operator') is not None:
            self.operator = m.get('operator')
        if m.get('superId') is not None:
            self.super_id = m.get('superId')
        return self


class CreateCustomDeptResponseBodyResult(TeaModel):
    def __init__(
        self,
        dept_id: int = None,
    ):
        self.dept_id = dept_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dept_id is not None:
            result['deptId'] = self.dept_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('deptId') is not None:
            self.dept_id = m.get('deptId')
        return self


class CreateCustomDeptResponseBody(TeaModel):
    def __init__(
        self,
        result: CreateCustomDeptResponseBodyResult = None,
        success: bool = None,
    ):
        self.result = result
        self.success = success

    def validate(self):
        if self.result:
            self.result.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.result is not None:
            result['result'] = self.result.to_map()
        if self.success is not None:
            result['success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('result') is not None:
            temp_model = CreateCustomDeptResponseBodyResult()
            self.result = temp_model.from_map(m['result'])
        if m.get('success') is not None:
            self.success = m.get('success')
        return self


class CreateCustomDeptResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateCustomDeptResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateCustomDeptResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateEduAssetSpaceHeaders(TeaModel):
    def __init__(
        self,
        common_headers: Dict[str, str] = None,
        x_acs_dingtalk_access_token: str = None,
    ):
        self.common_headers = common_headers
        self.x_acs_dingtalk_access_token = x_acs_dingtalk_access_token

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.common_headers is not None:
            result['commonHeaders'] = self.common_headers
        if self.x_acs_dingtalk_access_token is not None:
            result['x-acs-dingtalk-access-token'] = self.x_acs_dingtalk_access_token
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('commonHeaders') is not None:
            self.common_headers = m.get('commonHeaders')
        if m.get('x-acs-dingtalk-access-token') is not None:
            self.x_acs_dingtalk_access_token = m.get('x-acs-dingtalk-access-token')
        return self


class CreateEduAssetSpaceRequest(TeaModel):
    def __init__(
        self,
        biz_code: str = None,
        space_desc: str = None,
        space_icon: str = None,
        space_name: str = None,
        user_id: str = None,
    ):
        # This parameter is required.
        self.biz_code = biz_code
        # This parameter is required.
        self.space_desc = space_desc
        # This parameter is required.
        self.space_icon = space_icon
        # This parameter is required.
        self.space_name = space_name
        # This parameter is required.
        self.user_id = user_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.biz_code is not None:
            result['bizCode'] = self.biz_code
        if self.space_desc is not None:
            result['spaceDesc'] = self.space_desc
        if self.space_icon is not None:
            result['spaceIcon'] = self.space_icon
        if self.space_name is not None:
            result['spaceName'] = self.space_name
        if self.user_id is not None:
            result['userId'] = self.user_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('bizCode') is not None:
            self.biz_code = m.get('bizCode')
        if m.get('spaceDesc') is not None:
            self.space_desc = m.get('spaceDesc')
        if m.get('spaceIcon') is not None:
            self.space_icon = m.get('spaceIcon')
        if m.get('spaceName') is not None:
            self.space_name = m.get('spaceName')
        if m.get('userId') is not None:
            self.user_id = m.get('userId')
        return self


class CreateEduAssetSpaceResponseBody(TeaModel):
    def __init__(
        self,
        create_time_millis: int = None,
        modify_time_millis: int = None,
        permission_mode: str = None,
        quota: int = None,
        space_id: str = None,
        space_name: str = None,
        space_type: str = None,
        used_quota: int = None,
    ):
        # This parameter is required.
        self.create_time_millis = create_time_millis
        # This parameter is required.
        self.modify_time_millis = modify_time_millis
        # This parameter is required.
        self.permission_mode = permission_mode
        # This parameter is required.
        self.quota = quota
        # This parameter is required.
        self.space_id = space_id
        # This parameter is required.
        self.space_name = space_name
        # This parameter is required.
        self.space_type = space_type
        # This parameter is required.
        self.used_quota = used_quota

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.create_time_millis is not None:
            result['createTimeMillis'] = self.create_time_millis
        if self.modify_time_millis is not None:
            result['modifyTimeMillis'] = self.modify_time_millis
        if self.permission_mode is not None:
            result['permissionMode'] = self.permission_mode
        if self.quota is not None:
            result['quota'] = self.quota
        if self.space_id is not None:
            result['spaceId'] = self.space_id
        if self.space_name is not None:
            result['spaceName'] = self.space_name
        if self.space_type is not None:
            result['spaceType'] = self.space_type
        if self.used_quota is not None:
            result['usedQuota'] = self.used_quota
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('createTimeMillis') is not None:
            self.create_time_millis = m.get('createTimeMillis')
        if m.get('modifyTimeMillis') is not None:
            self.modify_time_millis = m.get('modifyTimeMillis')
        if m.get('permissionMode') is not None:
            self.permission_mode = m.get('permissionMode')
        if m.get('quota') is not None:
            self.quota = m.get('quota')
        if m.get('spaceId') is not None:
            self.space_id = m.get('spaceId')
        if m.get('spaceName') is not None:
            self.space_name = m.get('spaceName')
        if m.get('spaceType') is not None:
            self.space_type = m.get('spaceType')
        if m.get('usedQuota') is not None:
            self.used_quota = m.get('usedQuota')
        return self


class CreateEduAssetSpaceResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateEduAssetSpaceResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateEduAssetSpaceResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateFulfilRecordHeaders(TeaModel):
    def __init__(
        self,
        common_headers: Dict[str, str] = None,
        x_acs_dingtalk_access_token: str = None,
    ):
        self.common_headers = common_headers
        self.x_acs_dingtalk_access_token = x_acs_dingtalk_access_token

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.common_headers is not None:
            result['commonHeaders'] = self.common_headers
        if self.x_acs_dingtalk_access_token is not None:
            result['x-acs-dingtalk-access-token'] = self.x_acs_dingtalk_access_token
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('commonHeaders') is not None:
            self.common_headers = m.get('commonHeaders')
        if m.get('x-acs-dingtalk-access-token') is not None:
            self.x_acs_dingtalk_access_token = m.get('x-acs-dingtalk-access-token')
        return self


class CreateFulfilRecordRequest(TeaModel):
    def __init__(
        self,
        biz_time: int = None,
        ext_info: str = None,
        face_id: str = None,
        scene: int = None,
        sn: str = None,
        user_id: str = None,
    ):
        # This parameter is required.
        self.biz_time = biz_time
        # This parameter is required.
        self.ext_info = ext_info
        # This parameter is required.
        self.face_id = face_id
        # This parameter is required.
        self.scene = scene
        # This parameter is required.
        self.sn = sn
        # This parameter is required.
        self.user_id = user_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.biz_time is not None:
            result['bizTime'] = self.biz_time
        if self.ext_info is not None:
            result['extInfo'] = self.ext_info
        if self.face_id is not None:
            result['faceId'] = self.face_id
        if self.scene is not None:
            result['scene'] = self.scene
        if self.sn is not None:
            result['sn'] = self.sn
        if self.user_id is not None:
            result['userId'] = self.user_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('bizTime') is not None:
            self.biz_time = m.get('bizTime')
        if m.get('extInfo') is not None:
            self.ext_info = m.get('extInfo')
        if m.get('faceId') is not None:
            self.face_id = m.get('faceId')
        if m.get('scene') is not None:
            self.scene = m.get('scene')
        if m.get('sn') is not None:
            self.sn = m.get('sn')
        if m.get('userId') is not None:
            self.user_id = m.get('userId')
        return self


class CreateFulfilRecordResponseBody(TeaModel):
    def __init__(
        self,
        success_info: str = None,
    ):
        self.success_info = success_info

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.success_info is not None:
            result['successInfo'] = self.success_info
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('successInfo') is not None:
            self.success_info = m.get('successInfo')
        return self


class CreateFulfilRecordResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateFulfilRecordResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateFulfilRecordResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateInviteUrlHeaders(TeaModel):
    def __init__(
        self,
        common_headers: Dict[str, str] = None,
        x_acs_dingtalk_access_token: str = None,
    ):
        self.common_headers = common_headers
        self.x_acs_dingtalk_access_token = x_acs_dingtalk_access_token

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.common_headers is not None:
            result['commonHeaders'] = self.common_headers
        if self.x_acs_dingtalk_access_token is not None:
            result['x-acs-dingtalk-access-token'] = self.x_acs_dingtalk_access_token
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('commonHeaders') is not None:
            self.common_headers = m.get('commonHeaders')
        if m.get('x-acs-dingtalk-access-token') is not None:
            self.x_acs_dingtalk_access_token = m.get('x-acs-dingtalk-access-token')
        return self


class CreateInviteUrlRequest(TeaModel):
    def __init__(
        self,
        auth_code: str = None,
        target_corp_id: str = None,
        target_operator: str = None,
    ):
        # This parameter is required.
        self.auth_code = auth_code
        # This parameter is required.
        self.target_corp_id = target_corp_id
        # This parameter is required.
        self.target_operator = target_operator

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.auth_code is not None:
            result['authCode'] = self.auth_code
        if self.target_corp_id is not None:
            result['targetCorpId'] = self.target_corp_id
        if self.target_operator is not None:
            result['targetOperator'] = self.target_operator
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('authCode') is not None:
            self.auth_code = m.get('authCode')
        if m.get('targetCorpId') is not None:
            self.target_corp_id = m.get('targetCorpId')
        if m.get('targetOperator') is not None:
            self.target_operator = m.get('targetOperator')
        return self


class CreateInviteUrlResponseBodyResult(TeaModel):
    def __init__(
        self,
        invite_url: str = None,
    ):
        # This parameter is required.
        self.invite_url = invite_url

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.invite_url is not None:
            result['inviteUrl'] = self.invite_url
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('inviteUrl') is not None:
            self.invite_url = m.get('inviteUrl')
        return self


class CreateInviteUrlResponseBody(TeaModel):
    def __init__(
        self,
        result: CreateInviteUrlResponseBodyResult = None,
        success: bool = None,
    ):
        # This parameter is required.
        self.result = result
        # This parameter is required.
        self.success = success

    def validate(self):
        if self.result:
            self.result.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.result is not None:
            result['result'] = self.result.to_map()
        if self.success is not None:
            result['success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('result') is not None:
            temp_model = CreateInviteUrlResponseBodyResult()
            self.result = temp_model.from_map(m['result'])
        if m.get('success') is not None:
            self.success = m.get('success')
        return self


class CreateInviteUrlResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateInviteUrlResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateInviteUrlResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateItemHeaders(TeaModel):
    def __init__(
        self,
        common_headers: Dict[str, str] = None,
        x_acs_dingtalk_access_token: str = None,
    ):
        self.common_headers = common_headers
        self.x_acs_dingtalk_access_token = x_acs_dingtalk_access_token

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.common_headers is not None:
            result['commonHeaders'] = self.common_headers
        if self.x_acs_dingtalk_access_token is not None:
            result['x-acs-dingtalk-access-token'] = self.x_acs_dingtalk_access_token
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('commonHeaders') is not None:
            self.common_headers = m.get('commonHeaders')
        if m.get('x-acs-dingtalk-access-token') is not None:
            self.x_acs_dingtalk_access_token = m.get('x-acs-dingtalk-access-token')
        return self


class CreateItemRequest(TeaModel):
    def __init__(
        self,
        description: str = None,
        effect_type: int = None,
        end_time: int = None,
        merchant_id: str = None,
        name: str = None,
        opt_user: str = None,
        period_type: int = None,
        price: int = None,
        scene: int = None,
        start_time: int = None,
        status: int = None,
        type: int = None,
    ):
        # This parameter is required.
        self.description = description
        # This parameter is required.
        self.effect_type = effect_type
        self.end_time = end_time
        # This parameter is required.
        self.merchant_id = merchant_id
        # This parameter is required.
        self.name = name
        # This parameter is required.
        self.opt_user = opt_user
        self.period_type = period_type
        # This parameter is required.
        self.price = price
        # This parameter is required.
        self.scene = scene
        self.start_time = start_time
        # This parameter is required.
        self.status = status
        # This parameter is required.
        self.type = type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.description is not None:
            result['description'] = self.description
        if self.effect_type is not None:
            result['effectType'] = self.effect_type
        if self.end_time is not None:
            result['endTime'] = self.end_time
        if self.merchant_id is not None:
            result['merchantId'] = self.merchant_id
        if self.name is not None:
            result['name'] = self.name
        if self.opt_user is not None:
            result['optUser'] = self.opt_user
        if self.period_type is not None:
            result['periodType'] = self.period_type
        if self.price is not None:
            result['price'] = self.price
        if self.scene is not None:
            result['scene'] = self.scene
        if self.start_time is not None:
            result['startTime'] = self.start_time
        if self.status is not None:
            result['status'] = self.status
        if self.type is not None:
            result['type'] = self.type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('description') is not None:
            self.description = m.get('description')
        if m.get('effectType') is not None:
            self.effect_type = m.get('effectType')
        if m.get('endTime') is not None:
            self.end_time = m.get('endTime')
        if m.get('merchantId') is not None:
            self.merchant_id = m.get('merchantId')
        if m.get('name') is not None:
            self.name = m.get('name')
        if m.get('optUser') is not None:
            self.opt_user = m.get('optUser')
        if m.get('periodType') is not None:
            self.period_type = m.get('periodType')
        if m.get('price') is not None:
            self.price = m.get('price')
        if m.get('scene') is not None:
            self.scene = m.get('scene')
        if m.get('startTime') is not None:
            self.start_time = m.get('startTime')
        if m.get('status') is not None:
            self.status = m.get('status')
        if m.get('type') is not None:
            self.type = m.get('type')
        return self


class CreateItemResponseBody(TeaModel):
    def __init__(
        self,
        corp_id: str = None,
        id: int = None,
        merchant_id: str = None,
        status: int = None,
    ):
        # This parameter is required.
        self.corp_id = corp_id
        # This parameter is required.
        self.id = id
        # This parameter is required.
        self.merchant_id = merchant_id
        # This parameter is required.
        self.status = status

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.corp_id is not None:
            result['corpId'] = self.corp_id
        if self.id is not None:
            result['id'] = self.id
        if self.merchant_id is not None:
            result['merchantId'] = self.merchant_id
        if self.status is not None:
            result['status'] = self.status
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('corpId') is not None:
            self.corp_id = m.get('corpId')
        if m.get('id') is not None:
            self.id = m.get('id')
        if m.get('merchantId') is not None:
            self.merchant_id = m.get('merchantId')
        if m.get('status') is not None:
            self.status = m.get('status')
        return self


class CreateItemResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateItemResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateItemResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateKitTaskHeaders(TeaModel):
    def __init__(
        self,
        common_headers: Dict[str, str] = None,
        x_acs_dingtalk_access_token: str = None,
    ):
        self.common_headers = common_headers
        self.x_acs_dingtalk_access_token = x_acs_dingtalk_access_token

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.common_headers is not None:
            result['commonHeaders'] = self.common_headers
        if self.x_acs_dingtalk_access_token is not None:
            result['x-acs-dingtalk-access-token'] = self.x_acs_dingtalk_access_token
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('commonHeaders') is not None:
            self.common_headers = m.get('commonHeaders')
        if m.get('x-acs-dingtalk-access-token') is not None:
            self.x_acs_dingtalk_access_token = m.get('x-acs-dingtalk-access-token')
        return self


class CreateKitTaskRequest(TeaModel):
    def __init__(
        self,
        action_time: int = None,
        biz_data: str = None,
        biz_type: str = None,
        corp_id: str = None,
        identifier: str = None,
        isv_code: str = None,
        memo: str = None,
    ):
        self.action_time = action_time
        self.biz_data = biz_data
        self.biz_type = biz_type
        self.corp_id = corp_id
        self.identifier = identifier
        self.isv_code = isv_code
        self.memo = memo

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.action_time is not None:
            result['actionTime'] = self.action_time
        if self.biz_data is not None:
            result['bizData'] = self.biz_data
        if self.biz_type is not None:
            result['bizType'] = self.biz_type
        if self.corp_id is not None:
            result['corpId'] = self.corp_id
        if self.identifier is not None:
            result['identifier'] = self.identifier
        if self.isv_code is not None:
            result['isvCode'] = self.isv_code
        if self.memo is not None:
            result['memo'] = self.memo
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('actionTime') is not None:
            self.action_time = m.get('actionTime')
        if m.get('bizData') is not None:
            self.biz_data = m.get('bizData')
        if m.get('bizType') is not None:
            self.biz_type = m.get('bizType')
        if m.get('corpId') is not None:
            self.corp_id = m.get('corpId')
        if m.get('identifier') is not None:
            self.identifier = m.get('identifier')
        if m.get('isvCode') is not None:
            self.isv_code = m.get('isvCode')
        if m.get('memo') is not None:
            self.memo = m.get('memo')
        return self


class CreateKitTaskResponseBody(TeaModel):
    def __init__(
        self,
        result: bool = None,
        success: bool = None,
    ):
        self.result = result
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.result is not None:
            result['result'] = self.result
        if self.success is not None:
            result['success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('result') is not None:
            self.result = m.get('result')
        if m.get('success') is not None:
            self.success = m.get('success')
        return self


class CreateKitTaskResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateKitTaskResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateKitTaskResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateOrderHeaders(TeaModel):
    def __init__(
        self,
        common_headers: Dict[str, str] = None,
        x_acs_dingtalk_access_token: str = None,
    ):
        self.common_headers = common_headers
        self.x_acs_dingtalk_access_token = x_acs_dingtalk_access_token

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.common_headers is not None:
            result['commonHeaders'] = self.common_headers
        if self.x_acs_dingtalk_access_token is not None:
            result['x-acs-dingtalk-access-token'] = self.x_acs_dingtalk_access_token
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('commonHeaders') is not None:
            self.common_headers = m.get('commonHeaders')
        if m.get('x-acs-dingtalk-access-token') is not None:
            self.x_acs_dingtalk_access_token = m.get('x-acs-dingtalk-access-token')
        return self


class CreateOrderRequestDetailList(TeaModel):
    def __init__(
        self,
        actual_amount: int = None,
        item_amount: int = None,
        item_name: str = None,
        scene: int = None,
    ):
        # This parameter is required.
        self.actual_amount = actual_amount
        # This parameter is required.
        self.item_amount = item_amount
        # This parameter is required.
        self.item_name = item_name
        # This parameter is required.
        self.scene = scene

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.actual_amount is not None:
            result['actualAmount'] = self.actual_amount
        if self.item_amount is not None:
            result['itemAmount'] = self.item_amount
        if self.item_name is not None:
            result['itemName'] = self.item_name
        if self.scene is not None:
            result['scene'] = self.scene
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('actualAmount') is not None:
            self.actual_amount = m.get('actualAmount')
        if m.get('itemAmount') is not None:
            self.item_amount = m.get('itemAmount')
        if m.get('itemName') is not None:
            self.item_name = m.get('itemName')
        if m.get('scene') is not None:
            self.scene = m.get('scene')
        return self


class CreateOrderRequest(TeaModel):
    def __init__(
        self,
        actual_amount: int = None,
        create_time: int = None,
        detail_list: List[CreateOrderRequestDetailList] = None,
        face_id: str = None,
        ftoken: str = None,
        signature: str = None,
        sn: str = None,
        terminal_params: str = None,
        timestamp: int = None,
        total_amount: int = None,
        user_id: str = None,
        version: str = None,
    ):
        # This parameter is required.
        self.actual_amount = actual_amount
        self.create_time = create_time
        # This parameter is required.
        self.detail_list = detail_list
        # This parameter is required.
        self.face_id = face_id
        # This parameter is required.
        self.ftoken = ftoken
        self.signature = signature
        # This parameter is required.
        self.sn = sn
        # This parameter is required.
        self.terminal_params = terminal_params
        self.timestamp = timestamp
        # This parameter is required.
        self.total_amount = total_amount
        # This parameter is required.
        self.user_id = user_id
        self.version = version

    def validate(self):
        if self.detail_list:
            for k in self.detail_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.actual_amount is not None:
            result['actualAmount'] = self.actual_amount
        if self.create_time is not None:
            result['createTime'] = self.create_time
        result['detailList'] = []
        if self.detail_list is not None:
            for k in self.detail_list:
                result['detailList'].append(k.to_map() if k else None)
        if self.face_id is not None:
            result['faceId'] = self.face_id
        if self.ftoken is not None:
            result['ftoken'] = self.ftoken
        if self.signature is not None:
            result['signature'] = self.signature
        if self.sn is not None:
            result['sn'] = self.sn
        if self.terminal_params is not None:
            result['terminalParams'] = self.terminal_params
        if self.timestamp is not None:
            result['timestamp'] = self.timestamp
        if self.total_amount is not None:
            result['totalAmount'] = self.total_amount
        if self.user_id is not None:
            result['userId'] = self.user_id
        if self.version is not None:
            result['version'] = self.version
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('actualAmount') is not None:
            self.actual_amount = m.get('actualAmount')
        if m.get('createTime') is not None:
            self.create_time = m.get('createTime')
        self.detail_list = []
        if m.get('detailList') is not None:
            for k in m.get('detailList'):
                temp_model = CreateOrderRequestDetailList()
                self.detail_list.append(temp_model.from_map(k))
        if m.get('faceId') is not None:
            self.face_id = m.get('faceId')
        if m.get('ftoken') is not None:
            self.ftoken = m.get('ftoken')
        if m.get('signature') is not None:
            self.signature = m.get('signature')
        if m.get('sn') is not None:
            self.sn = m.get('sn')
        if m.get('terminalParams') is not None:
            self.terminal_params = m.get('terminalParams')
        if m.get('timestamp') is not None:
            self.timestamp = m.get('timestamp')
        if m.get('totalAmount') is not None:
            self.total_amount = m.get('totalAmount')
        if m.get('userId') is not None:
            self.user_id = m.get('userId')
        if m.get('version') is not None:
            self.version = m.get('version')
        return self


class CreateOrderResponseBody(TeaModel):
    def __init__(
        self,
        order_no: str = None,
    ):
        self.order_no = order_no

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.order_no is not None:
            result['orderNo'] = self.order_no
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('orderNo') is not None:
            self.order_no = m.get('orderNo')
        return self


class CreateOrderResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateOrderResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateOrderResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateOrderFlowHeaders(TeaModel):
    def __init__(
        self,
        common_headers: Dict[str, str] = None,
        x_acs_dingtalk_access_token: str = None,
    ):
        self.common_headers = common_headers
        self.x_acs_dingtalk_access_token = x_acs_dingtalk_access_token

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.common_headers is not None:
            result['commonHeaders'] = self.common_headers
        if self.x_acs_dingtalk_access_token is not None:
            result['x-acs-dingtalk-access-token'] = self.x_acs_dingtalk_access_token
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('commonHeaders') is not None:
            self.common_headers = m.get('commonHeaders')
        if m.get('x-acs-dingtalk-access-token') is not None:
            self.x_acs_dingtalk_access_token = m.get('x-acs-dingtalk-access-token')
        return self


class CreateOrderFlowRequestDetailList(TeaModel):
    def __init__(
        self,
        actual_amount: int = None,
        item_amount: int = None,
        item_id: int = None,
        item_name: str = None,
        scene: int = None,
    ):
        # This parameter is required.
        self.actual_amount = actual_amount
        # This parameter is required.
        self.item_amount = item_amount
        self.item_id = item_id
        # This parameter is required.
        self.item_name = item_name
        # This parameter is required.
        self.scene = scene

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.actual_amount is not None:
            result['actualAmount'] = self.actual_amount
        if self.item_amount is not None:
            result['itemAmount'] = self.item_amount
        if self.item_id is not None:
            result['itemId'] = self.item_id
        if self.item_name is not None:
            result['itemName'] = self.item_name
        if self.scene is not None:
            result['scene'] = self.scene
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('actualAmount') is not None:
            self.actual_amount = m.get('actualAmount')
        if m.get('itemAmount') is not None:
            self.item_amount = m.get('itemAmount')
        if m.get('itemId') is not None:
            self.item_id = m.get('itemId')
        if m.get('itemName') is not None:
            self.item_name = m.get('itemName')
        if m.get('scene') is not None:
            self.scene = m.get('scene')
        return self


class CreateOrderFlowRequest(TeaModel):
    def __init__(
        self,
        actual_amount: int = None,
        alipay_uid: str = None,
        create_time: int = None,
        detail_list: List[CreateOrderFlowRequestDetailList] = None,
        face_id: str = None,
        guardian_user_id: str = None,
        merchant_id: str = None,
        order_no: str = None,
        signature: str = None,
        sn: str = None,
        timestamp: int = None,
        total_amount: int = None,
        user_id: str = None,
    ):
        # This parameter is required.
        self.actual_amount = actual_amount
        self.alipay_uid = alipay_uid
        self.create_time = create_time
        # This parameter is required.
        self.detail_list = detail_list
        self.face_id = face_id
        self.guardian_user_id = guardian_user_id
        # This parameter is required.
        self.merchant_id = merchant_id
        # This parameter is required.
        self.order_no = order_no
        self.signature = signature
        self.sn = sn
        self.timestamp = timestamp
        # This parameter is required.
        self.total_amount = total_amount
        # This parameter is required.
        self.user_id = user_id

    def validate(self):
        if self.detail_list:
            for k in self.detail_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.actual_amount is not None:
            result['actualAmount'] = self.actual_amount
        if self.alipay_uid is not None:
            result['alipayUid'] = self.alipay_uid
        if self.create_time is not None:
            result['createTime'] = self.create_time
        result['detailList'] = []
        if self.detail_list is not None:
            for k in self.detail_list:
                result['detailList'].append(k.to_map() if k else None)
        if self.face_id is not None:
            result['faceId'] = self.face_id
        if self.guardian_user_id is not None:
            result['guardianUserId'] = self.guardian_user_id
        if self.merchant_id is not None:
            result['merchantId'] = self.merchant_id
        if self.order_no is not None:
            result['orderNo'] = self.order_no
        if self.signature is not None:
            result['signature'] = self.signature
        if self.sn is not None:
            result['sn'] = self.sn
        if self.timestamp is not None:
            result['timestamp'] = self.timestamp
        if self.total_amount is not None:
            result['totalAmount'] = self.total_amount
        if self.user_id is not None:
            result['userId'] = self.user_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('actualAmount') is not None:
            self.actual_amount = m.get('actualAmount')
        if m.get('alipayUid') is not None:
            self.alipay_uid = m.get('alipayUid')
        if m.get('createTime') is not None:
            self.create_time = m.get('createTime')
        self.detail_list = []
        if m.get('detailList') is not None:
            for k in m.get('detailList'):
                temp_model = CreateOrderFlowRequestDetailList()
                self.detail_list.append(temp_model.from_map(k))
        if m.get('faceId') is not None:
            self.face_id = m.get('faceId')
        if m.get('guardianUserId') is not None:
            self.guardian_user_id = m.get('guardianUserId')
        if m.get('merchantId') is not None:
            self.merchant_id = m.get('merchantId')
        if m.get('orderNo') is not None:
            self.order_no = m.get('orderNo')
        if m.get('signature') is not None:
            self.signature = m.get('signature')
        if m.get('sn') is not None:
            self.sn = m.get('sn')
        if m.get('timestamp') is not None:
            self.timestamp = m.get('timestamp')
        if m.get('totalAmount') is not None:
            self.total_amount = m.get('totalAmount')
        if m.get('userId') is not None:
            self.user_id = m.get('userId')
        return self


class CreateOrderFlowResponseBody(TeaModel):
    def __init__(
        self,
        success: bool = None,
    ):
        # This parameter is required.
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.success is not None:
            result['success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('success') is not None:
            self.success = m.get('success')
        return self


class CreateOrderFlowResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateOrderFlowResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateOrderFlowResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreatePhysicalClassroomHeaders(TeaModel):
    def __init__(
        self,
        common_headers: Dict[str, str] = None,
        x_acs_dingtalk_access_token: str = None,
    ):
        self.common_headers = common_headers
        self.x_acs_dingtalk_access_token = x_acs_dingtalk_access_token

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.common_headers is not None:
            result['commonHeaders'] = self.common_headers
        if self.x_acs_dingtalk_access_token is not None:
            result['x-acs-dingtalk-access-token'] = self.x_acs_dingtalk_access_token
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('commonHeaders') is not None:
            self.common_headers = m.get('commonHeaders')
        if m.get('x-acs-dingtalk-access-token') is not None:
            self.x_acs_dingtalk_access_token = m.get('x-acs-dingtalk-access-token')
        return self


class CreatePhysicalClassroomRequest(TeaModel):
    def __init__(
        self,
        classroom_building: str = None,
        classroom_campus: str = None,
        classroom_floor: str = None,
        classroom_name: str = None,
        classroom_number: str = None,
        direct_broadcast: str = None,
        ext: str = None,
        op_user_id: str = None,
    ):
        # This parameter is required.
        self.classroom_building = classroom_building
        # This parameter is required.
        self.classroom_campus = classroom_campus
        # This parameter is required.
        self.classroom_floor = classroom_floor
        # This parameter is required.
        self.classroom_name = classroom_name
        # This parameter is required.
        self.classroom_number = classroom_number
        # This parameter is required.
        self.direct_broadcast = direct_broadcast
        self.ext = ext
        # This parameter is required.
        self.op_user_id = op_user_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.classroom_building is not None:
            result['classroomBuilding'] = self.classroom_building
        if self.classroom_campus is not None:
            result['classroomCampus'] = self.classroom_campus
        if self.classroom_floor is not None:
            result['classroomFloor'] = self.classroom_floor
        if self.classroom_name is not None:
            result['classroomName'] = self.classroom_name
        if self.classroom_number is not None:
            result['classroomNumber'] = self.classroom_number
        if self.direct_broadcast is not None:
            result['directBroadcast'] = self.direct_broadcast
        if self.ext is not None:
            result['ext'] = self.ext
        if self.op_user_id is not None:
            result['opUserId'] = self.op_user_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('classroomBuilding') is not None:
            self.classroom_building = m.get('classroomBuilding')
        if m.get('classroomCampus') is not None:
            self.classroom_campus = m.get('classroomCampus')
        if m.get('classroomFloor') is not None:
            self.classroom_floor = m.get('classroomFloor')
        if m.get('classroomName') is not None:
            self.classroom_name = m.get('classroomName')
        if m.get('classroomNumber') is not None:
            self.classroom_number = m.get('classroomNumber')
        if m.get('directBroadcast') is not None:
            self.direct_broadcast = m.get('directBroadcast')
        if m.get('ext') is not None:
            self.ext = m.get('ext')
        if m.get('opUserId') is not None:
            self.op_user_id = m.get('opUserId')
        return self


class CreatePhysicalClassroomResponseBody(TeaModel):
    def __init__(
        self,
        classroom_id: int = None,
    ):
        self.classroom_id = classroom_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.classroom_id is not None:
            result['classroomId'] = self.classroom_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('classroomId') is not None:
            self.classroom_id = m.get('classroomId')
        return self


class CreatePhysicalClassroomResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreatePhysicalClassroomResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreatePhysicalClassroomResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateRefundFlowHeaders(TeaModel):
    def __init__(
        self,
        common_headers: Dict[str, str] = None,
        x_acs_dingtalk_access_token: str = None,
    ):
        self.common_headers = common_headers
        self.x_acs_dingtalk_access_token = x_acs_dingtalk_access_token

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.common_headers is not None:
            result['commonHeaders'] = self.common_headers
        if self.x_acs_dingtalk_access_token is not None:
            result['x-acs-dingtalk-access-token'] = self.x_acs_dingtalk_access_token
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('commonHeaders') is not None:
            self.common_headers = m.get('commonHeaders')
        if m.get('x-acs-dingtalk-access-token') is not None:
            self.x_acs_dingtalk_access_token = m.get('x-acs-dingtalk-access-token')
        return self


class CreateRefundFlowRequest(TeaModel):
    def __init__(
        self,
        face_id: str = None,
        operator_id: str = None,
        operator_name: str = None,
        order_no: str = None,
        signature: str = None,
        sn: str = None,
        timestamp: int = None,
        user_id: str = None,
    ):
        # This parameter is required.
        self.face_id = face_id
        # This parameter is required.
        self.operator_id = operator_id
        # This parameter is required.
        self.operator_name = operator_name
        # This parameter is required.
        self.order_no = order_no
        self.signature = signature
        # This parameter is required.
        self.sn = sn
        self.timestamp = timestamp
        # This parameter is required.
        self.user_id = user_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.face_id is not None:
            result['faceId'] = self.face_id
        if self.operator_id is not None:
            result['operatorId'] = self.operator_id
        if self.operator_name is not None:
            result['operatorName'] = self.operator_name
        if self.order_no is not None:
            result['orderNo'] = self.order_no
        if self.signature is not None:
            result['signature'] = self.signature
        if self.sn is not None:
            result['sn'] = self.sn
        if self.timestamp is not None:
            result['timestamp'] = self.timestamp
        if self.user_id is not None:
            result['userId'] = self.user_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('faceId') is not None:
            self.face_id = m.get('faceId')
        if m.get('operatorId') is not None:
            self.operator_id = m.get('operatorId')
        if m.get('operatorName') is not None:
            self.operator_name = m.get('operatorName')
        if m.get('orderNo') is not None:
            self.order_no = m.get('orderNo')
        if m.get('signature') is not None:
            self.signature = m.get('signature')
        if m.get('sn') is not None:
            self.sn = m.get('sn')
        if m.get('timestamp') is not None:
            self.timestamp = m.get('timestamp')
        if m.get('userId') is not None:
            self.user_id = m.get('userId')
        return self


class CreateRefundFlowResponseBody(TeaModel):
    def __init__(
        self,
        success: bool = None,
    ):
        # This parameter is required.
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.success is not None:
            result['success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('success') is not None:
            self.success = m.get('success')
        return self


class CreateRefundFlowResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateRefundFlowResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateRefundFlowResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateRemoteClassCourseHeaders(TeaModel):
    def __init__(
        self,
        common_headers: Dict[str, str] = None,
        x_acs_dingtalk_access_token: str = None,
    ):
        self.common_headers = common_headers
        self.x_acs_dingtalk_access_token = x_acs_dingtalk_access_token

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.common_headers is not None:
            result['commonHeaders'] = self.common_headers
        if self.x_acs_dingtalk_access_token is not None:
            result['x-acs-dingtalk-access-token'] = self.x_acs_dingtalk_access_token
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('commonHeaders') is not None:
            self.common_headers = m.get('commonHeaders')
        if m.get('x-acs-dingtalk-access-token') is not None:
            self.x_acs_dingtalk_access_token = m.get('x-acs-dingtalk-access-token')
        return self


class CreateRemoteClassCourseRequestAttendParticipants(TeaModel):
    def __init__(
        self,
        corp_id: str = None,
        participant_id: str = None,
    ):
        # This parameter is required.
        self.corp_id = corp_id
        # This parameter is required.
        self.participant_id = participant_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.corp_id is not None:
            result['corpId'] = self.corp_id
        if self.participant_id is not None:
            result['participantId'] = self.participant_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('corpId') is not None:
            self.corp_id = m.get('corpId')
        if m.get('participantId') is not None:
            self.participant_id = m.get('participantId')
        return self


class CreateRemoteClassCourseRequestTeachingParticipant(TeaModel):
    def __init__(
        self,
        corp_id: str = None,
        participant_id: str = None,
    ):
        # This parameter is required.
        self.corp_id = corp_id
        # This parameter is required.
        self.participant_id = participant_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.corp_id is not None:
            result['corpId'] = self.corp_id
        if self.participant_id is not None:
            result['participantId'] = self.participant_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('corpId') is not None:
            self.corp_id = m.get('corpId')
        if m.get('participantId') is not None:
            self.participant_id = m.get('participantId')
        return self


class CreateRemoteClassCourseRequest(TeaModel):
    def __init__(
        self,
        attend_participants: List[CreateRemoteClassCourseRequestAttendParticipants] = None,
        auth_code: str = None,
        course_name: str = None,
        end_time: int = None,
        start_time: int = None,
        teaching_participant: CreateRemoteClassCourseRequestTeachingParticipant = None,
    ):
        # This parameter is required.
        self.attend_participants = attend_participants
        # This parameter is required.
        self.auth_code = auth_code
        # This parameter is required.
        self.course_name = course_name
        # This parameter is required.
        self.end_time = end_time
        # This parameter is required.
        self.start_time = start_time
        # This parameter is required.
        self.teaching_participant = teaching_participant

    def validate(self):
        if self.attend_participants:
            for k in self.attend_participants:
                if k:
                    k.validate()
        if self.teaching_participant:
            self.teaching_participant.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['attendParticipants'] = []
        if self.attend_participants is not None:
            for k in self.attend_participants:
                result['attendParticipants'].append(k.to_map() if k else None)
        if self.auth_code is not None:
            result['authCode'] = self.auth_code
        if self.course_name is not None:
            result['courseName'] = self.course_name
        if self.end_time is not None:
            result['endTime'] = self.end_time
        if self.start_time is not None:
            result['startTime'] = self.start_time
        if self.teaching_participant is not None:
            result['teachingParticipant'] = self.teaching_participant.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.attend_participants = []
        if m.get('attendParticipants') is not None:
            for k in m.get('attendParticipants'):
                temp_model = CreateRemoteClassCourseRequestAttendParticipants()
                self.attend_participants.append(temp_model.from_map(k))
        if m.get('authCode') is not None:
            self.auth_code = m.get('authCode')
        if m.get('courseName') is not None:
            self.course_name = m.get('courseName')
        if m.get('endTime') is not None:
            self.end_time = m.get('endTime')
        if m.get('startTime') is not None:
            self.start_time = m.get('startTime')
        if m.get('teachingParticipant') is not None:
            temp_model = CreateRemoteClassCourseRequestTeachingParticipant()
            self.teaching_participant = temp_model.from_map(m['teachingParticipant'])
        return self


class CreateRemoteClassCourseResponseBodyResult(TeaModel):
    def __init__(
        self,
        course_code: str = None,
    ):
        self.course_code = course_code

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.course_code is not None:
            result['courseCode'] = self.course_code
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('courseCode') is not None:
            self.course_code = m.get('courseCode')
        return self


class CreateRemoteClassCourseResponseBody(TeaModel):
    def __init__(
        self,
        result: CreateRemoteClassCourseResponseBodyResult = None,
        success: bool = None,
    ):
        self.result = result
        # This parameter is required.
        self.success = success

    def validate(self):
        if self.result:
            self.result.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.result is not None:
            result['result'] = self.result.to_map()
        if self.success is not None:
            result['success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('result') is not None:
            temp_model = CreateRemoteClassCourseResponseBodyResult()
            self.result = temp_model.from_map(m['result'])
        if m.get('success') is not None:
            self.success = m.get('success')
        return self


class CreateRemoteClassCourseResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateRemoteClassCourseResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateRemoteClassCourseResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateSectionConfigHeaders(TeaModel):
    def __init__(
        self,
        common_headers: Dict[str, str] = None,
        x_acs_dingtalk_access_token: str = None,
    ):
        self.common_headers = common_headers
        self.x_acs_dingtalk_access_token = x_acs_dingtalk_access_token

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.common_headers is not None:
            result['commonHeaders'] = self.common_headers
        if self.x_acs_dingtalk_access_token is not None:
            result['x-acs-dingtalk-access-token'] = self.x_acs_dingtalk_access_token
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('commonHeaders') is not None:
            self.common_headers = m.get('commonHeaders')
        if m.get('x-acs-dingtalk-access-token') is not None:
            self.x_acs_dingtalk_access_token = m.get('x-acs-dingtalk-access-token')
        return self


class CreateSectionConfigRequestSectionConfigsSectionEndDate(TeaModel):
    def __init__(
        self,
        day_of_month: int = None,
        month: int = None,
        year: int = None,
    ):
        # This parameter is required.
        self.day_of_month = day_of_month
        # This parameter is required.
        self.month = month
        # This parameter is required.
        self.year = year

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.day_of_month is not None:
            result['dayOfMonth'] = self.day_of_month
        if self.month is not None:
            result['month'] = self.month
        if self.year is not None:
            result['year'] = self.year
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('dayOfMonth') is not None:
            self.day_of_month = m.get('dayOfMonth')
        if m.get('month') is not None:
            self.month = m.get('month')
        if m.get('year') is not None:
            self.year = m.get('year')
        return self


class CreateSectionConfigRequestSectionConfigsSectionModelsSectionEndTime(TeaModel):
    def __init__(
        self,
        hour: int = None,
        min: int = None,
    ):
        # This parameter is required.
        self.hour = hour
        # This parameter is required.
        self.min = min

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.hour is not None:
            result['hour'] = self.hour
        if self.min is not None:
            result['min'] = self.min
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('hour') is not None:
            self.hour = m.get('hour')
        if m.get('min') is not None:
            self.min = m.get('min')
        return self


class CreateSectionConfigRequestSectionConfigsSectionModelsSectionStartTime(TeaModel):
    def __init__(
        self,
        hour: int = None,
        min: int = None,
    ):
        # This parameter is required.
        self.hour = hour
        # This parameter is required.
        self.min = min

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.hour is not None:
            result['hour'] = self.hour
        if self.min is not None:
            result['min'] = self.min
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('hour') is not None:
            self.hour = m.get('hour')
        if m.get('min') is not None:
            self.min = m.get('min')
        return self


class CreateSectionConfigRequestSectionConfigsSectionModels(TeaModel):
    def __init__(
        self,
        section_end_time: CreateSectionConfigRequestSectionConfigsSectionModelsSectionEndTime = None,
        section_index: int = None,
        section_name: str = None,
        section_start_time: CreateSectionConfigRequestSectionConfigsSectionModelsSectionStartTime = None,
        section_type: str = None,
    ):
        # This parameter is required.
        self.section_end_time = section_end_time
        # This parameter is required.
        self.section_index = section_index
        # This parameter is required.
        self.section_name = section_name
        # This parameter is required.
        self.section_start_time = section_start_time
        # This parameter is required.
        self.section_type = section_type

    def validate(self):
        if self.section_end_time:
            self.section_end_time.validate()
        if self.section_start_time:
            self.section_start_time.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.section_end_time is not None:
            result['sectionEndTime'] = self.section_end_time.to_map()
        if self.section_index is not None:
            result['sectionIndex'] = self.section_index
        if self.section_name is not None:
            result['sectionName'] = self.section_name
        if self.section_start_time is not None:
            result['sectionStartTime'] = self.section_start_time.to_map()
        if self.section_type is not None:
            result['sectionType'] = self.section_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('sectionEndTime') is not None:
            temp_model = CreateSectionConfigRequestSectionConfigsSectionModelsSectionEndTime()
            self.section_end_time = temp_model.from_map(m['sectionEndTime'])
        if m.get('sectionIndex') is not None:
            self.section_index = m.get('sectionIndex')
        if m.get('sectionName') is not None:
            self.section_name = m.get('sectionName')
        if m.get('sectionStartTime') is not None:
            temp_model = CreateSectionConfigRequestSectionConfigsSectionModelsSectionStartTime()
            self.section_start_time = temp_model.from_map(m['sectionStartTime'])
        if m.get('sectionType') is not None:
            self.section_type = m.get('sectionType')
        return self


class CreateSectionConfigRequestSectionConfigsSectionStartDate(TeaModel):
    def __init__(
        self,
        day_of_month: int = None,
        month: int = None,
        year: int = None,
    ):
        # This parameter is required.
        self.day_of_month = day_of_month
        # This parameter is required.
        self.month = month
        # This parameter is required.
        self.year = year

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.day_of_month is not None:
            result['dayOfMonth'] = self.day_of_month
        if self.month is not None:
            result['month'] = self.month
        if self.year is not None:
            result['year'] = self.year
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('dayOfMonth') is not None:
            self.day_of_month = m.get('dayOfMonth')
        if m.get('month') is not None:
            self.month = m.get('month')
        if m.get('year') is not None:
            self.year = m.get('year')
        return self


class CreateSectionConfigRequestSectionConfigsSemesterEndDate(TeaModel):
    def __init__(
        self,
        day_of_month: int = None,
        month: int = None,
        year: int = None,
    ):
        # This parameter is required.
        self.day_of_month = day_of_month
        # This parameter is required.
        self.month = month
        # This parameter is required.
        self.year = year

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.day_of_month is not None:
            result['dayOfMonth'] = self.day_of_month
        if self.month is not None:
            result['month'] = self.month
        if self.year is not None:
            result['year'] = self.year
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('dayOfMonth') is not None:
            self.day_of_month = m.get('dayOfMonth')
        if m.get('month') is not None:
            self.month = m.get('month')
        if m.get('year') is not None:
            self.year = m.get('year')
        return self


class CreateSectionConfigRequestSectionConfigsSemesterStartDate(TeaModel):
    def __init__(
        self,
        day_of_month: int = None,
        month: int = None,
        year: int = None,
    ):
        # This parameter is required.
        self.day_of_month = day_of_month
        # This parameter is required.
        self.month = month
        # This parameter is required.
        self.year = year

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.day_of_month is not None:
            result['dayOfMonth'] = self.day_of_month
        if self.month is not None:
            result['month'] = self.month
        if self.year is not None:
            result['year'] = self.year
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('dayOfMonth') is not None:
            self.day_of_month = m.get('dayOfMonth')
        if m.get('month') is not None:
            self.month = m.get('month')
        if m.get('year') is not None:
            self.year = m.get('year')
        return self


class CreateSectionConfigRequestSectionConfigs(TeaModel):
    def __init__(
        self,
        schedule_name: str = None,
        school_year: str = None,
        section_end_date: CreateSectionConfigRequestSectionConfigsSectionEndDate = None,
        section_models: List[CreateSectionConfigRequestSectionConfigsSectionModels] = None,
        section_start_date: CreateSectionConfigRequestSectionConfigsSectionStartDate = None,
        semester: int = None,
        semester_end_date: CreateSectionConfigRequestSectionConfigsSemesterEndDate = None,
        semester_start_date: CreateSectionConfigRequestSectionConfigsSemesterStartDate = None,
    ):
        # This parameter is required.
        self.schedule_name = schedule_name
        # This parameter is required.
        self.school_year = school_year
        # This parameter is required.
        self.section_end_date = section_end_date
        # This parameter is required.
        self.section_models = section_models
        # This parameter is required.
        self.section_start_date = section_start_date
        # This parameter is required.
        self.semester = semester
        # This parameter is required.
        self.semester_end_date = semester_end_date
        # This parameter is required.
        self.semester_start_date = semester_start_date

    def validate(self):
        if self.section_end_date:
            self.section_end_date.validate()
        if self.section_models:
            for k in self.section_models:
                if k:
                    k.validate()
        if self.section_start_date:
            self.section_start_date.validate()
        if self.semester_end_date:
            self.semester_end_date.validate()
        if self.semester_start_date:
            self.semester_start_date.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.schedule_name is not None:
            result['scheduleName'] = self.schedule_name
        if self.school_year is not None:
            result['schoolYear'] = self.school_year
        if self.section_end_date is not None:
            result['sectionEndDate'] = self.section_end_date.to_map()
        result['sectionModels'] = []
        if self.section_models is not None:
            for k in self.section_models:
                result['sectionModels'].append(k.to_map() if k else None)
        if self.section_start_date is not None:
            result['sectionStartDate'] = self.section_start_date.to_map()
        if self.semester is not None:
            result['semester'] = self.semester
        if self.semester_end_date is not None:
            result['semesterEndDate'] = self.semester_end_date.to_map()
        if self.semester_start_date is not None:
            result['semesterStartDate'] = self.semester_start_date.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('scheduleName') is not None:
            self.schedule_name = m.get('scheduleName')
        if m.get('schoolYear') is not None:
            self.school_year = m.get('schoolYear')
        if m.get('sectionEndDate') is not None:
            temp_model = CreateSectionConfigRequestSectionConfigsSectionEndDate()
            self.section_end_date = temp_model.from_map(m['sectionEndDate'])
        self.section_models = []
        if m.get('sectionModels') is not None:
            for k in m.get('sectionModels'):
                temp_model = CreateSectionConfigRequestSectionConfigsSectionModels()
                self.section_models.append(temp_model.from_map(k))
        if m.get('sectionStartDate') is not None:
            temp_model = CreateSectionConfigRequestSectionConfigsSectionStartDate()
            self.section_start_date = temp_model.from_map(m['sectionStartDate'])
        if m.get('semester') is not None:
            self.semester = m.get('semester')
        if m.get('semesterEndDate') is not None:
            temp_model = CreateSectionConfigRequestSectionConfigsSemesterEndDate()
            self.semester_end_date = temp_model.from_map(m['semesterEndDate'])
        if m.get('semesterStartDate') is not None:
            temp_model = CreateSectionConfigRequestSectionConfigsSemesterStartDate()
            self.semester_start_date = temp_model.from_map(m['semesterStartDate'])
        return self


class CreateSectionConfigRequest(TeaModel):
    def __init__(
        self,
        ext: str = None,
        section_configs: List[CreateSectionConfigRequestSectionConfigs] = None,
        op_user_id: str = None,
    ):
        self.ext = ext
        # This parameter is required.
        self.section_configs = section_configs
        # This parameter is required.
        self.op_user_id = op_user_id

    def validate(self):
        if self.section_configs:
            for k in self.section_configs:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.ext is not None:
            result['ext'] = self.ext
        result['sectionConfigs'] = []
        if self.section_configs is not None:
            for k in self.section_configs:
                result['sectionConfigs'].append(k.to_map() if k else None)
        if self.op_user_id is not None:
            result['opUserId'] = self.op_user_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ext') is not None:
            self.ext = m.get('ext')
        self.section_configs = []
        if m.get('sectionConfigs') is not None:
            for k in m.get('sectionConfigs'):
                temp_model = CreateSectionConfigRequestSectionConfigs()
                self.section_configs.append(temp_model.from_map(k))
        if m.get('opUserId') is not None:
            self.op_user_id = m.get('opUserId')
        return self


class CreateSectionConfigResponseBody(TeaModel):
    def __init__(
        self,
        result: bool = None,
    ):
        self.result = result

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.result is not None:
            result['result'] = self.result
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('result') is not None:
            self.result = m.get('result')
        return self


class CreateSectionConfigResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateSectionConfigResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateSectionConfigResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateSnsAppOrderHeaders(TeaModel):
    def __init__(
        self,
        common_headers: Dict[str, str] = None,
        x_acs_dingtalk_access_token: str = None,
    ):
        self.common_headers = common_headers
        self.x_acs_dingtalk_access_token = x_acs_dingtalk_access_token

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.common_headers is not None:
            result['commonHeaders'] = self.common_headers
        if self.x_acs_dingtalk_access_token is not None:
            result['x-acs-dingtalk-access-token'] = self.x_acs_dingtalk_access_token
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('commonHeaders') is not None:
            self.common_headers = m.get('commonHeaders')
        if m.get('x-acs-dingtalk-access-token') is not None:
            self.x_acs_dingtalk_access_token = m.get('x-acs-dingtalk-access-token')
        return self


class CreateSnsAppOrderRequestDetailList(TeaModel):
    def __init__(
        self,
        goods_id: str = None,
        goods_name: str = None,
        goods_price: int = None,
        goods_quantity: int = None,
    ):
        # This parameter is required.
        self.goods_id = goods_id
        # This parameter is required.
        self.goods_name = goods_name
        # This parameter is required.
        self.goods_price = goods_price
        # This parameter is required.
        self.goods_quantity = goods_quantity

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.goods_id is not None:
            result['goodsId'] = self.goods_id
        if self.goods_name is not None:
            result['goodsName'] = self.goods_name
        if self.goods_price is not None:
            result['goodsPrice'] = self.goods_price
        if self.goods_quantity is not None:
            result['goodsQuantity'] = self.goods_quantity
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('goodsId') is not None:
            self.goods_id = m.get('goodsId')
        if m.get('goodsName') is not None:
            self.goods_name = m.get('goodsName')
        if m.get('goodsPrice') is not None:
            self.goods_price = m.get('goodsPrice')
        if m.get('goodsQuantity') is not None:
            self.goods_quantity = m.get('goodsQuantity')
        return self


class CreateSnsAppOrderRequest(TeaModel):
    def __init__(
        self,
        actual_amount: int = None,
        alipay_app_id: str = None,
        biz_code: int = None,
        detail_list: List[CreateSnsAppOrderRequestDetailList] = None,
        label_amount: int = None,
        merchant_id: str = None,
        merchant_order_no: str = None,
        signature: str = None,
        subject: str = None,
        timestamp: int = None,
    ):
        # This parameter is required.
        self.actual_amount = actual_amount
        # This parameter is required.
        self.alipay_app_id = alipay_app_id
        # This parameter is required.
        self.biz_code = biz_code
        # This parameter is required.
        self.detail_list = detail_list
        self.label_amount = label_amount
        # This parameter is required.
        self.merchant_id = merchant_id
        # This parameter is required.
        self.merchant_order_no = merchant_order_no
        # This parameter is required.
        self.signature = signature
        # This parameter is required.
        self.subject = subject
        # This parameter is required.
        self.timestamp = timestamp

    def validate(self):
        if self.detail_list:
            for k in self.detail_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.actual_amount is not None:
            result['actualAmount'] = self.actual_amount
        if self.alipay_app_id is not None:
            result['alipayAppId'] = self.alipay_app_id
        if self.biz_code is not None:
            result['bizCode'] = self.biz_code
        result['detailList'] = []
        if self.detail_list is not None:
            for k in self.detail_list:
                result['detailList'].append(k.to_map() if k else None)
        if self.label_amount is not None:
            result['labelAmount'] = self.label_amount
        if self.merchant_id is not None:
            result['merchantId'] = self.merchant_id
        if self.merchant_order_no is not None:
            result['merchantOrderNo'] = self.merchant_order_no
        if self.signature is not None:
            result['signature'] = self.signature
        if self.subject is not None:
            result['subject'] = self.subject
        if self.timestamp is not None:
            result['timestamp'] = self.timestamp
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('actualAmount') is not None:
            self.actual_amount = m.get('actualAmount')
        if m.get('alipayAppId') is not None:
            self.alipay_app_id = m.get('alipayAppId')
        if m.get('bizCode') is not None:
            self.biz_code = m.get('bizCode')
        self.detail_list = []
        if m.get('detailList') is not None:
            for k in m.get('detailList'):
                temp_model = CreateSnsAppOrderRequestDetailList()
                self.detail_list.append(temp_model.from_map(k))
        if m.get('labelAmount') is not None:
            self.label_amount = m.get('labelAmount')
        if m.get('merchantId') is not None:
            self.merchant_id = m.get('merchantId')
        if m.get('merchantOrderNo') is not None:
            self.merchant_order_no = m.get('merchantOrderNo')
        if m.get('signature') is not None:
            self.signature = m.get('signature')
        if m.get('subject') is not None:
            self.subject = m.get('subject')
        if m.get('timestamp') is not None:
            self.timestamp = m.get('timestamp')
        return self


class CreateSnsAppOrderResponseBody(TeaModel):
    def __init__(
        self,
        actual_amount: int = None,
        alipay_app_id: str = None,
        body: str = None,
        merchant_id: str = None,
        merchant_order_no: str = None,
        order_no: str = None,
    ):
        self.actual_amount = actual_amount
        self.alipay_app_id = alipay_app_id
        self.body = body
        self.merchant_id = merchant_id
        self.merchant_order_no = merchant_order_no
        self.order_no = order_no

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.actual_amount is not None:
            result['actualAmount'] = self.actual_amount
        if self.alipay_app_id is not None:
            result['alipayAppId'] = self.alipay_app_id
        if self.body is not None:
            result['body'] = self.body
        if self.merchant_id is not None:
            result['merchantId'] = self.merchant_id
        if self.merchant_order_no is not None:
            result['merchantOrderNo'] = self.merchant_order_no
        if self.order_no is not None:
            result['orderNo'] = self.order_no
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('actualAmount') is not None:
            self.actual_amount = m.get('actualAmount')
        if m.get('alipayAppId') is not None:
            self.alipay_app_id = m.get('alipayAppId')
        if m.get('body') is not None:
            self.body = m.get('body')
        if m.get('merchantId') is not None:
            self.merchant_id = m.get('merchantId')
        if m.get('merchantOrderNo') is not None:
            self.merchant_order_no = m.get('merchantOrderNo')
        if m.get('orderNo') is not None:
            self.order_no = m.get('orderNo')
        return self


class CreateSnsAppOrderResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateSnsAppOrderResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateSnsAppOrderResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateStsTokenHeaders(TeaModel):
    def __init__(
        self,
        common_headers: Dict[str, str] = None,
        x_acs_dingtalk_access_token: str = None,
    ):
        self.common_headers = common_headers
        self.x_acs_dingtalk_access_token = x_acs_dingtalk_access_token

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.common_headers is not None:
            result['commonHeaders'] = self.common_headers
        if self.x_acs_dingtalk_access_token is not None:
            result['x-acs-dingtalk-access-token'] = self.x_acs_dingtalk_access_token
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('commonHeaders') is not None:
            self.common_headers = m.get('commonHeaders')
        if m.get('x-acs-dingtalk-access-token') is not None:
            self.x_acs_dingtalk_access_token = m.get('x-acs-dingtalk-access-token')
        return self


class CreateStsTokenRequest(TeaModel):
    def __init__(
        self,
        device_sn: str = None,
        sts_type: str = None,
    ):
        # This parameter is required.
        self.device_sn = device_sn
        # This parameter is required.
        self.sts_type = sts_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.device_sn is not None:
            result['deviceSn'] = self.device_sn
        if self.sts_type is not None:
            result['stsType'] = self.sts_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('deviceSn') is not None:
            self.device_sn = m.get('deviceSn')
        if m.get('stsType') is not None:
            self.sts_type = m.get('stsType')
        return self


class CreateStsTokenResponseBody(TeaModel):
    def __init__(
        self,
        access_key_id: str = None,
        access_key_secret: str = None,
        expiration: str = None,
        ext_info: str = None,
        security_token: str = None,
        status: str = None,
    ):
        self.access_key_id = access_key_id
        self.access_key_secret = access_key_secret
        self.expiration = expiration
        self.ext_info = ext_info
        self.security_token = security_token
        self.status = status

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.access_key_id is not None:
            result['accessKeyId'] = self.access_key_id
        if self.access_key_secret is not None:
            result['accessKeySecret'] = self.access_key_secret
        if self.expiration is not None:
            result['expiration'] = self.expiration
        if self.ext_info is not None:
            result['extInfo'] = self.ext_info
        if self.security_token is not None:
            result['securityToken'] = self.security_token
        if self.status is not None:
            result['status'] = self.status
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('accessKeyId') is not None:
            self.access_key_id = m.get('accessKeyId')
        if m.get('accessKeySecret') is not None:
            self.access_key_secret = m.get('accessKeySecret')
        if m.get('expiration') is not None:
            self.expiration = m.get('expiration')
        if m.get('extInfo') is not None:
            self.ext_info = m.get('extInfo')
        if m.get('securityToken') is not None:
            self.security_token = m.get('securityToken')
        if m.get('status') is not None:
            self.status = m.get('status')
        return self


class CreateStsTokenResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateStsTokenResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateStsTokenResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateStudentClassHeaders(TeaModel):
    def __init__(
        self,
        common_headers: Dict[str, str] = None,
        x_acs_dingtalk_access_token: str = None,
    ):
        self.common_headers = common_headers
        self.x_acs_dingtalk_access_token = x_acs_dingtalk_access_token

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.common_headers is not None:
            result['commonHeaders'] = self.common_headers
        if self.x_acs_dingtalk_access_token is not None:
            result['x-acs-dingtalk-access-token'] = self.x_acs_dingtalk_access_token
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('commonHeaders') is not None:
            self.common_headers = m.get('commonHeaders')
        if m.get('x-acs-dingtalk-access-token') is not None:
            self.x_acs_dingtalk_access_token = m.get('x-acs-dingtalk-access-token')
        return self


class CreateStudentClassRequest(TeaModel):
    def __init__(
        self,
        attributes: str = None,
        class_id: str = None,
        class_name: str = None,
        class_type: int = None,
        corp_id: str = None,
        isv_code: str = None,
        student_name: str = None,
        student_user_id: str = None,
    ):
        self.attributes = attributes
        self.class_id = class_id
        self.class_name = class_name
        self.class_type = class_type
        self.corp_id = corp_id
        self.isv_code = isv_code
        self.student_name = student_name
        self.student_user_id = student_user_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.attributes is not None:
            result['attributes'] = self.attributes
        if self.class_id is not None:
            result['classId'] = self.class_id
        if self.class_name is not None:
            result['className'] = self.class_name
        if self.class_type is not None:
            result['classType'] = self.class_type
        if self.corp_id is not None:
            result['corpId'] = self.corp_id
        if self.isv_code is not None:
            result['isvCode'] = self.isv_code
        if self.student_name is not None:
            result['studentName'] = self.student_name
        if self.student_user_id is not None:
            result['studentUserId'] = self.student_user_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('attributes') is not None:
            self.attributes = m.get('attributes')
        if m.get('classId') is not None:
            self.class_id = m.get('classId')
        if m.get('className') is not None:
            self.class_name = m.get('className')
        if m.get('classType') is not None:
            self.class_type = m.get('classType')
        if m.get('corpId') is not None:
            self.corp_id = m.get('corpId')
        if m.get('isvCode') is not None:
            self.isv_code = m.get('isvCode')
        if m.get('studentName') is not None:
            self.student_name = m.get('studentName')
        if m.get('studentUserId') is not None:
            self.student_user_id = m.get('studentUserId')
        return self


class CreateStudentClassResponseBody(TeaModel):
    def __init__(
        self,
        result: int = None,
        success: bool = None,
    ):
        self.result = result
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.result is not None:
            result['result'] = self.result
        if self.success is not None:
            result['success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('result') is not None:
            self.result = m.get('result')
        if m.get('success') is not None:
            self.success = m.get('success')
        return self


class CreateStudentClassResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateStudentClassResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateStudentClassResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateTeacherCourseHeaders(TeaModel):
    def __init__(
        self,
        common_headers: Dict[str, str] = None,
        x_acs_dingtalk_access_token: str = None,
    ):
        self.common_headers = common_headers
        self.x_acs_dingtalk_access_token = x_acs_dingtalk_access_token

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.common_headers is not None:
            result['commonHeaders'] = self.common_headers
        if self.x_acs_dingtalk_access_token is not None:
            result['x-acs-dingtalk-access-token'] = self.x_acs_dingtalk_access_token
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('commonHeaders') is not None:
            self.common_headers = m.get('commonHeaders')
        if m.get('x-acs-dingtalk-access-token') is not None:
            self.x_acs_dingtalk_access_token = m.get('x-acs-dingtalk-access-token')
        return self


class CreateTeacherCourseRequest(TeaModel):
    def __init__(
        self,
        attributes: str = None,
        corp_id: str = None,
        isv_code: str = None,
        isv_course_id: str = None,
        teacher_name: str = None,
        teacher_user_id: str = None,
    ):
        self.attributes = attributes
        self.corp_id = corp_id
        self.isv_code = isv_code
        self.isv_course_id = isv_course_id
        self.teacher_name = teacher_name
        self.teacher_user_id = teacher_user_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.attributes is not None:
            result['attributes'] = self.attributes
        if self.corp_id is not None:
            result['corpId'] = self.corp_id
        if self.isv_code is not None:
            result['isvCode'] = self.isv_code
        if self.isv_course_id is not None:
            result['isvCourseId'] = self.isv_course_id
        if self.teacher_name is not None:
            result['teacherName'] = self.teacher_name
        if self.teacher_user_id is not None:
            result['teacherUserId'] = self.teacher_user_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('attributes') is not None:
            self.attributes = m.get('attributes')
        if m.get('corpId') is not None:
            self.corp_id = m.get('corpId')
        if m.get('isvCode') is not None:
            self.isv_code = m.get('isvCode')
        if m.get('isvCourseId') is not None:
            self.isv_course_id = m.get('isvCourseId')
        if m.get('teacherName') is not None:
            self.teacher_name = m.get('teacherName')
        if m.get('teacherUserId') is not None:
            self.teacher_user_id = m.get('teacherUserId')
        return self


class CreateTeacherCourseResponseBody(TeaModel):
    def __init__(
        self,
        result: int = None,
        success: bool = None,
    ):
        self.result = result
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.result is not None:
            result['result'] = self.result
        if self.success is not None:
            result['success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('result') is not None:
            self.result = m.get('result')
        if m.get('success') is not None:
            self.success = m.get('success')
        return self


class CreateTeacherCourseResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateTeacherCourseResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateTeacherCourseResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateTimerCardHeaders(TeaModel):
    def __init__(
        self,
        common_headers: Dict[str, str] = None,
        x_acs_dingtalk_access_token: str = None,
    ):
        self.common_headers = common_headers
        self.x_acs_dingtalk_access_token = x_acs_dingtalk_access_token

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.common_headers is not None:
            result['commonHeaders'] = self.common_headers
        if self.x_acs_dingtalk_access_token is not None:
            result['x-acs-dingtalk-access-token'] = self.x_acs_dingtalk_access_token
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('commonHeaders') is not None:
            self.common_headers = m.get('commonHeaders')
        if m.get('x-acs-dingtalk-access-token') is not None:
            self.x_acs_dingtalk_access_token = m.get('x-acs-dingtalk-access-token')
        return self


class CreateTimerCardRequest(TeaModel):
    def __init__(
        self,
        action_time: int = None,
        biz_data: str = None,
        biz_type: str = None,
        corp_id: str = None,
        identifier: str = None,
        isv_code: str = None,
        memo: str = None,
    ):
        self.action_time = action_time
        self.biz_data = biz_data
        self.biz_type = biz_type
        self.corp_id = corp_id
        self.identifier = identifier
        self.isv_code = isv_code
        self.memo = memo

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.action_time is not None:
            result['actionTime'] = self.action_time
        if self.biz_data is not None:
            result['bizData'] = self.biz_data
        if self.biz_type is not None:
            result['bizType'] = self.biz_type
        if self.corp_id is not None:
            result['corpId'] = self.corp_id
        if self.identifier is not None:
            result['identifier'] = self.identifier
        if self.isv_code is not None:
            result['isvCode'] = self.isv_code
        if self.memo is not None:
            result['memo'] = self.memo
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('actionTime') is not None:
            self.action_time = m.get('actionTime')
        if m.get('bizData') is not None:
            self.biz_data = m.get('bizData')
        if m.get('bizType') is not None:
            self.biz_type = m.get('bizType')
        if m.get('corpId') is not None:
            self.corp_id = m.get('corpId')
        if m.get('identifier') is not None:
            self.identifier = m.get('identifier')
        if m.get('isvCode') is not None:
            self.isv_code = m.get('isvCode')
        if m.get('memo') is not None:
            self.memo = m.get('memo')
        return self


class CreateTimerCardResponseBody(TeaModel):
    def __init__(
        self,
        result: bool = None,
        sucess: bool = None,
    ):
        self.result = result
        self.sucess = sucess

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.result is not None:
            result['result'] = self.result
        if self.sucess is not None:
            result['sucess'] = self.sucess
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('result') is not None:
            self.result = m.get('result')
        if m.get('sucess') is not None:
            self.sucess = m.get('sucess')
        return self


class CreateTimerCardResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateTimerCardResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateTimerCardResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateTokenHeaders(TeaModel):
    def __init__(
        self,
        common_headers: Dict[str, str] = None,
        x_acs_dingtalk_access_token: str = None,
    ):
        self.common_headers = common_headers
        self.x_acs_dingtalk_access_token = x_acs_dingtalk_access_token

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.common_headers is not None:
            result['commonHeaders'] = self.common_headers
        if self.x_acs_dingtalk_access_token is not None:
            result['x-acs-dingtalk-access-token'] = self.x_acs_dingtalk_access_token
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('commonHeaders') is not None:
            self.common_headers = m.get('commonHeaders')
        if m.get('x-acs-dingtalk-access-token') is not None:
            self.x_acs_dingtalk_access_token = m.get('x-acs-dingtalk-access-token')
        return self


class CreateTokenRequest(TeaModel):
    def __init__(
        self,
        sn: str = None,
        type: str = None,
    ):
        self.sn = sn
        self.type = type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.sn is not None:
            result['sn'] = self.sn
        if self.type is not None:
            result['type'] = self.type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('sn') is not None:
            self.sn = m.get('sn')
        if m.get('type') is not None:
            self.type = m.get('type')
        return self


class CreateTokenResponseBody(TeaModel):
    def __init__(
        self,
        access_key_id: str = None,
        access_key_secret: str = None,
        expiration: str = None,
        ext_info: str = None,
        security_token: str = None,
        status: str = None,
    ):
        self.access_key_id = access_key_id
        self.access_key_secret = access_key_secret
        self.expiration = expiration
        self.ext_info = ext_info
        self.security_token = security_token
        self.status = status

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.access_key_id is not None:
            result['accessKeyId'] = self.access_key_id
        if self.access_key_secret is not None:
            result['accessKeySecret'] = self.access_key_secret
        if self.expiration is not None:
            result['expiration'] = self.expiration
        if self.ext_info is not None:
            result['extInfo'] = self.ext_info
        if self.security_token is not None:
            result['securityToken'] = self.security_token
        if self.status is not None:
            result['status'] = self.status
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('accessKeyId') is not None:
            self.access_key_id = m.get('accessKeyId')
        if m.get('accessKeySecret') is not None:
            self.access_key_secret = m.get('accessKeySecret')
        if m.get('expiration') is not None:
            self.expiration = m.get('expiration')
        if m.get('extInfo') is not None:
            self.ext_info = m.get('extInfo')
        if m.get('securityToken') is not None:
            self.security_token = m.get('securityToken')
        if m.get('status') is not None:
            self.status = m.get('status')
        return self


class CreateTokenResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateTokenResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateTokenResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateTransferRecordHeaders(TeaModel):
    def __init__(
        self,
        common_headers: Dict[str, str] = None,
        x_acs_dingtalk_access_token: str = None,
    ):
        self.common_headers = common_headers
        self.x_acs_dingtalk_access_token = x_acs_dingtalk_access_token

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.common_headers is not None:
            result['commonHeaders'] = self.common_headers
        if self.x_acs_dingtalk_access_token is not None:
            result['x-acs-dingtalk-access-token'] = self.x_acs_dingtalk_access_token
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('commonHeaders') is not None:
            self.common_headers = m.get('commonHeaders')
        if m.get('x-acs-dingtalk-access-token') is not None:
            self.x_acs_dingtalk_access_token = m.get('x-acs-dingtalk-access-token')
        return self


class CreateTransferRecordRequest(TeaModel):
    def __init__(
        self,
        attributes: str = None,
        class_id: str = None,
        class_name: str = None,
        corp_id: str = None,
        isv_code: str = None,
        isv_record_id: str = None,
        src_course_code: str = None,
        src_course_date: int = None,
        src_course_name: str = None,
        src_isv_course_id: str = None,
        src_timeslot_name: str = None,
        src_timeslot_num: int = None,
        tar_course_code: str = None,
        tar_course_date: int = None,
        tar_course_name: str = None,
        tar_isv_course_id: str = None,
        tar_timeslot_name: str = None,
        tar_timeslot_num: int = None,
    ):
        self.attributes = attributes
        self.class_id = class_id
        self.class_name = class_name
        self.corp_id = corp_id
        self.isv_code = isv_code
        self.isv_record_id = isv_record_id
        self.src_course_code = src_course_code
        self.src_course_date = src_course_date
        self.src_course_name = src_course_name
        self.src_isv_course_id = src_isv_course_id
        self.src_timeslot_name = src_timeslot_name
        self.src_timeslot_num = src_timeslot_num
        self.tar_course_code = tar_course_code
        self.tar_course_date = tar_course_date
        self.tar_course_name = tar_course_name
        self.tar_isv_course_id = tar_isv_course_id
        self.tar_timeslot_name = tar_timeslot_name
        self.tar_timeslot_num = tar_timeslot_num

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.attributes is not None:
            result['attributes'] = self.attributes
        if self.class_id is not None:
            result['classId'] = self.class_id
        if self.class_name is not None:
            result['className'] = self.class_name
        if self.corp_id is not None:
            result['corpId'] = self.corp_id
        if self.isv_code is not None:
            result['isvCode'] = self.isv_code
        if self.isv_record_id is not None:
            result['isvRecordId'] = self.isv_record_id
        if self.src_course_code is not None:
            result['srcCourseCode'] = self.src_course_code
        if self.src_course_date is not None:
            result['srcCourseDate'] = self.src_course_date
        if self.src_course_name is not None:
            result['srcCourseName'] = self.src_course_name
        if self.src_isv_course_id is not None:
            result['srcIsvCourseId'] = self.src_isv_course_id
        if self.src_timeslot_name is not None:
            result['srcTimeslotName'] = self.src_timeslot_name
        if self.src_timeslot_num is not None:
            result['srcTimeslotNum'] = self.src_timeslot_num
        if self.tar_course_code is not None:
            result['tarCourseCode'] = self.tar_course_code
        if self.tar_course_date is not None:
            result['tarCourseDate'] = self.tar_course_date
        if self.tar_course_name is not None:
            result['tarCourseName'] = self.tar_course_name
        if self.tar_isv_course_id is not None:
            result['tarIsvCourseId'] = self.tar_isv_course_id
        if self.tar_timeslot_name is not None:
            result['tarTimeslotName'] = self.tar_timeslot_name
        if self.tar_timeslot_num is not None:
            result['tarTimeslotNum'] = self.tar_timeslot_num
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('attributes') is not None:
            self.attributes = m.get('attributes')
        if m.get('classId') is not None:
            self.class_id = m.get('classId')
        if m.get('className') is not None:
            self.class_name = m.get('className')
        if m.get('corpId') is not None:
            self.corp_id = m.get('corpId')
        if m.get('isvCode') is not None:
            self.isv_code = m.get('isvCode')
        if m.get('isvRecordId') is not None:
            self.isv_record_id = m.get('isvRecordId')
        if m.get('srcCourseCode') is not None:
            self.src_course_code = m.get('srcCourseCode')
        if m.get('srcCourseDate') is not None:
            self.src_course_date = m.get('srcCourseDate')
        if m.get('srcCourseName') is not None:
            self.src_course_name = m.get('srcCourseName')
        if m.get('srcIsvCourseId') is not None:
            self.src_isv_course_id = m.get('srcIsvCourseId')
        if m.get('srcTimeslotName') is not None:
            self.src_timeslot_name = m.get('srcTimeslotName')
        if m.get('srcTimeslotNum') is not None:
            self.src_timeslot_num = m.get('srcTimeslotNum')
        if m.get('tarCourseCode') is not None:
            self.tar_course_code = m.get('tarCourseCode')
        if m.get('tarCourseDate') is not None:
            self.tar_course_date = m.get('tarCourseDate')
        if m.get('tarCourseName') is not None:
            self.tar_course_name = m.get('tarCourseName')
        if m.get('tarIsvCourseId') is not None:
            self.tar_isv_course_id = m.get('tarIsvCourseId')
        if m.get('tarTimeslotName') is not None:
            self.tar_timeslot_name = m.get('tarTimeslotName')
        if m.get('tarTimeslotNum') is not None:
            self.tar_timeslot_num = m.get('tarTimeslotNum')
        return self


class CreateTransferRecordResponseBody(TeaModel):
    def __init__(
        self,
        result: int = None,
        success: bool = None,
    ):
        self.result = result
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.result is not None:
            result['result'] = self.result
        if self.success is not None:
            result['success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('result') is not None:
            self.result = m.get('result')
        if m.get('success') is not None:
            self.success = m.get('success')
        return self


class CreateTransferRecordResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateTransferRecordResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateTransferRecordResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateUniversityCourseGroupHeaders(TeaModel):
    def __init__(
        self,
        common_headers: Dict[str, str] = None,
        x_acs_dingtalk_access_token: str = None,
    ):
        self.common_headers = common_headers
        self.x_acs_dingtalk_access_token = x_acs_dingtalk_access_token

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.common_headers is not None:
            result['commonHeaders'] = self.common_headers
        if self.x_acs_dingtalk_access_token is not None:
            result['x-acs-dingtalk-access-token'] = self.x_acs_dingtalk_access_token
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('commonHeaders') is not None:
            self.common_headers = m.get('commonHeaders')
        if m.get('x-acs-dingtalk-access-token') is not None:
            self.x_acs_dingtalk_access_token = m.get('x-acs-dingtalk-access-token')
        return self


class CreateUniversityCourseGroupRequestCourserGroupItemModelsCourserGroupItemEndDate(TeaModel):
    def __init__(
        self,
        day_of_month: int = None,
        month: int = None,
        year: int = None,
    ):
        # This parameter is required.
        self.day_of_month = day_of_month
        # This parameter is required.
        self.month = month
        # This parameter is required.
        self.year = year

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.day_of_month is not None:
            result['dayOfMonth'] = self.day_of_month
        if self.month is not None:
            result['month'] = self.month
        if self.year is not None:
            result['year'] = self.year
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('dayOfMonth') is not None:
            self.day_of_month = m.get('dayOfMonth')
        if m.get('month') is not None:
            self.month = m.get('month')
        if m.get('year') is not None:
            self.year = m.get('year')
        return self


class CreateUniversityCourseGroupRequestCourserGroupItemModelsCourserGroupItemStartDate(TeaModel):
    def __init__(
        self,
        day_of_month: int = None,
        month: int = None,
        year: int = None,
    ):
        # This parameter is required.
        self.day_of_month = day_of_month
        # This parameter is required.
        self.month = month
        # This parameter is required.
        self.year = year

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.day_of_month is not None:
            result['dayOfMonth'] = self.day_of_month
        if self.month is not None:
            result['month'] = self.month
        if self.year is not None:
            result['year'] = self.year
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('dayOfMonth') is not None:
            self.day_of_month = m.get('dayOfMonth')
        if m.get('month') is not None:
            self.month = m.get('month')
        if m.get('year') is not None:
            self.year = m.get('year')
        return self


class CreateUniversityCourseGroupRequestCourserGroupItemModels(TeaModel):
    def __init__(
        self,
        class_period_type: int = None,
        classroom_id: int = None,
        course_type: int = None,
        courser_group_item_end_date: CreateUniversityCourseGroupRequestCourserGroupItemModelsCourserGroupItemEndDate = None,
        courser_group_item_start_date: CreateUniversityCourseGroupRequestCourserGroupItemModelsCourserGroupItemStartDate = None,
        day_of_week: int = None,
        section_index: List[int] = None,
    ):
        # This parameter is required.
        self.class_period_type = class_period_type
        # This parameter is required.
        self.classroom_id = classroom_id
        # This parameter is required.
        self.course_type = course_type
        # This parameter is required.
        self.courser_group_item_end_date = courser_group_item_end_date
        # This parameter is required.
        self.courser_group_item_start_date = courser_group_item_start_date
        # This parameter is required.
        self.day_of_week = day_of_week
        # This parameter is required.
        self.section_index = section_index

    def validate(self):
        if self.courser_group_item_end_date:
            self.courser_group_item_end_date.validate()
        if self.courser_group_item_start_date:
            self.courser_group_item_start_date.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.class_period_type is not None:
            result['classPeriodType'] = self.class_period_type
        if self.classroom_id is not None:
            result['classroomId'] = self.classroom_id
        if self.course_type is not None:
            result['courseType'] = self.course_type
        if self.courser_group_item_end_date is not None:
            result['courserGroupItemEndDate'] = self.courser_group_item_end_date.to_map()
        if self.courser_group_item_start_date is not None:
            result['courserGroupItemStartDate'] = self.courser_group_item_start_date.to_map()
        if self.day_of_week is not None:
            result['dayOfWeek'] = self.day_of_week
        if self.section_index is not None:
            result['sectionIndex'] = self.section_index
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('classPeriodType') is not None:
            self.class_period_type = m.get('classPeriodType')
        if m.get('classroomId') is not None:
            self.classroom_id = m.get('classroomId')
        if m.get('courseType') is not None:
            self.course_type = m.get('courseType')
        if m.get('courserGroupItemEndDate') is not None:
            temp_model = CreateUniversityCourseGroupRequestCourserGroupItemModelsCourserGroupItemEndDate()
            self.courser_group_item_end_date = temp_model.from_map(m['courserGroupItemEndDate'])
        if m.get('courserGroupItemStartDate') is not None:
            temp_model = CreateUniversityCourseGroupRequestCourserGroupItemModelsCourserGroupItemStartDate()
            self.courser_group_item_start_date = temp_model.from_map(m['courserGroupItemStartDate'])
        if m.get('dayOfWeek') is not None:
            self.day_of_week = m.get('dayOfWeek')
        if m.get('sectionIndex') is not None:
            self.section_index = m.get('sectionIndex')
        return self


class CreateUniversityCourseGroupRequestTeacherInfos(TeaModel):
    def __init__(
        self,
        participant_role: str = None,
        user_id: str = None,
    ):
        self.participant_role = participant_role
        self.user_id = user_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.participant_role is not None:
            result['participantRole'] = self.participant_role
        if self.user_id is not None:
            result['userId'] = self.user_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('participantRole') is not None:
            self.participant_role = m.get('participantRole')
        if m.get('userId') is not None:
            self.user_id = m.get('userId')
        return self


class CreateUniversityCourseGroupRequest(TeaModel):
    def __init__(
        self,
        course_group_introduce: str = None,
        course_group_name: str = None,
        courser_group_item_models: List[CreateUniversityCourseGroupRequestCourserGroupItemModels] = None,
        ext: str = None,
        isv_course_group_code: str = None,
        period_code: str = None,
        school_year: str = None,
        semester: int = None,
        subject_name: str = None,
        teacher_infos: List[CreateUniversityCourseGroupRequestTeacherInfos] = None,
        op_user_id: str = None,
    ):
        # This parameter is required.
        self.course_group_introduce = course_group_introduce
        # This parameter is required.
        self.course_group_name = course_group_name
        # This parameter is required.
        self.courser_group_item_models = courser_group_item_models
        self.ext = ext
        # This parameter is required.
        self.isv_course_group_code = isv_course_group_code
        # This parameter is required.
        self.period_code = period_code
        # This parameter is required.
        self.school_year = school_year
        # This parameter is required.
        self.semester = semester
        # This parameter is required.
        self.subject_name = subject_name
        # This parameter is required.
        self.teacher_infos = teacher_infos
        # This parameter is required.
        self.op_user_id = op_user_id

    def validate(self):
        if self.courser_group_item_models:
            for k in self.courser_group_item_models:
                if k:
                    k.validate()
        if self.teacher_infos:
            for k in self.teacher_infos:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.course_group_introduce is not None:
            result['courseGroupIntroduce'] = self.course_group_introduce
        if self.course_group_name is not None:
            result['courseGroupName'] = self.course_group_name
        result['courserGroupItemModels'] = []
        if self.courser_group_item_models is not None:
            for k in self.courser_group_item_models:
                result['courserGroupItemModels'].append(k.to_map() if k else None)
        if self.ext is not None:
            result['ext'] = self.ext
        if self.isv_course_group_code is not None:
            result['isvCourseGroupCode'] = self.isv_course_group_code
        if self.period_code is not None:
            result['periodCode'] = self.period_code
        if self.school_year is not None:
            result['schoolYear'] = self.school_year
        if self.semester is not None:
            result['semester'] = self.semester
        if self.subject_name is not None:
            result['subjectName'] = self.subject_name
        result['teacherInfos'] = []
        if self.teacher_infos is not None:
            for k in self.teacher_infos:
                result['teacherInfos'].append(k.to_map() if k else None)
        if self.op_user_id is not None:
            result['opUserId'] = self.op_user_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('courseGroupIntroduce') is not None:
            self.course_group_introduce = m.get('courseGroupIntroduce')
        if m.get('courseGroupName') is not None:
            self.course_group_name = m.get('courseGroupName')
        self.courser_group_item_models = []
        if m.get('courserGroupItemModels') is not None:
            for k in m.get('courserGroupItemModels'):
                temp_model = CreateUniversityCourseGroupRequestCourserGroupItemModels()
                self.courser_group_item_models.append(temp_model.from_map(k))
        if m.get('ext') is not None:
            self.ext = m.get('ext')
        if m.get('isvCourseGroupCode') is not None:
            self.isv_course_group_code = m.get('isvCourseGroupCode')
        if m.get('periodCode') is not None:
            self.period_code = m.get('periodCode')
        if m.get('schoolYear') is not None:
            self.school_year = m.get('schoolYear')
        if m.get('semester') is not None:
            self.semester = m.get('semester')
        if m.get('subjectName') is not None:
            self.subject_name = m.get('subjectName')
        self.teacher_infos = []
        if m.get('teacherInfos') is not None:
            for k in m.get('teacherInfos'):
                temp_model = CreateUniversityCourseGroupRequestTeacherInfos()
                self.teacher_infos.append(temp_model.from_map(k))
        if m.get('opUserId') is not None:
            self.op_user_id = m.get('opUserId')
        return self


class CreateUniversityCourseGroupResponseBodyCourseGroupInfo(TeaModel):
    def __init__(
        self,
        course_group_code: str = None,
    ):
        self.course_group_code = course_group_code

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.course_group_code is not None:
            result['courseGroupCode'] = self.course_group_code
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('courseGroupCode') is not None:
            self.course_group_code = m.get('courseGroupCode')
        return self


class CreateUniversityCourseGroupResponseBody(TeaModel):
    def __init__(
        self,
        course_group_info: CreateUniversityCourseGroupResponseBodyCourseGroupInfo = None,
    ):
        self.course_group_info = course_group_info

    def validate(self):
        if self.course_group_info:
            self.course_group_info.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.course_group_info is not None:
            result['courseGroupInfo'] = self.course_group_info.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('courseGroupInfo') is not None:
            temp_model = CreateUniversityCourseGroupResponseBodyCourseGroupInfo()
            self.course_group_info = temp_model.from_map(m['courseGroupInfo'])
        return self


class CreateUniversityCourseGroupResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateUniversityCourseGroupResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateUniversityCourseGroupResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateUniversityStudentHeaders(TeaModel):
    def __init__(
        self,
        common_headers: Dict[str, str] = None,
        x_acs_dingtalk_access_token: str = None,
    ):
        self.common_headers = common_headers
        self.x_acs_dingtalk_access_token = x_acs_dingtalk_access_token

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.common_headers is not None:
            result['commonHeaders'] = self.common_headers
        if self.x_acs_dingtalk_access_token is not None:
            result['x-acs-dingtalk-access-token'] = self.x_acs_dingtalk_access_token
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('commonHeaders') is not None:
            self.common_headers = m.get('commonHeaders')
        if m.get('x-acs-dingtalk-access-token') is not None:
            self.x_acs_dingtalk_access_token = m.get('x-acs-dingtalk-access-token')
        return self


class CreateUniversityStudentRequest(TeaModel):
    def __init__(
        self,
        class_id: int = None,
        gender: str = None,
        identity_number: str = None,
        mobile: str = None,
        name: str = None,
        student_number: str = None,
        op_user_id: str = None,
    ):
        # This parameter is required.
        self.class_id = class_id
        # This parameter is required.
        self.gender = gender
        self.identity_number = identity_number
        # This parameter is required.
        self.mobile = mobile
        # This parameter is required.
        self.name = name
        # This parameter is required.
        self.student_number = student_number
        # This parameter is required.
        self.op_user_id = op_user_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.class_id is not None:
            result['classId'] = self.class_id
        if self.gender is not None:
            result['gender'] = self.gender
        if self.identity_number is not None:
            result['identityNumber'] = self.identity_number
        if self.mobile is not None:
            result['mobile'] = self.mobile
        if self.name is not None:
            result['name'] = self.name
        if self.student_number is not None:
            result['studentNumber'] = self.student_number
        if self.op_user_id is not None:
            result['opUserId'] = self.op_user_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('classId') is not None:
            self.class_id = m.get('classId')
        if m.get('gender') is not None:
            self.gender = m.get('gender')
        if m.get('identityNumber') is not None:
            self.identity_number = m.get('identityNumber')
        if m.get('mobile') is not None:
            self.mobile = m.get('mobile')
        if m.get('name') is not None:
            self.name = m.get('name')
        if m.get('studentNumber') is not None:
            self.student_number = m.get('studentNumber')
        if m.get('opUserId') is not None:
            self.op_user_id = m.get('opUserId')
        return self


class CreateUniversityStudentResponseBody(TeaModel):
    def __init__(
        self,
        result: bool = None,
    ):
        # This parameter is required.
        self.result = result

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.result is not None:
            result['result'] = self.result
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('result') is not None:
            self.result = m.get('result')
        return self


class CreateUniversityStudentResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateUniversityStudentResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateUniversityStudentResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateUniversityTeacherHeaders(TeaModel):
    def __init__(
        self,
        common_headers: Dict[str, str] = None,
        x_acs_dingtalk_access_token: str = None,
    ):
        self.common_headers = common_headers
        self.x_acs_dingtalk_access_token = x_acs_dingtalk_access_token

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.common_headers is not None:
            result['commonHeaders'] = self.common_headers
        if self.x_acs_dingtalk_access_token is not None:
            result['x-acs-dingtalk-access-token'] = self.x_acs_dingtalk_access_token
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('commonHeaders') is not None:
            self.common_headers = m.get('commonHeaders')
        if m.get('x-acs-dingtalk-access-token') is not None:
            self.x_acs_dingtalk_access_token = m.get('x-acs-dingtalk-access-token')
        return self


class CreateUniversityTeacherRequest(TeaModel):
    def __init__(
        self,
        class_id: int = None,
        op_user_id: str = None,
        role: str = None,
        teacher_user_id: str = None,
    ):
        # This parameter is required.
        self.class_id = class_id
        # This parameter is required.
        self.op_user_id = op_user_id
        # This parameter is required.
        self.role = role
        # This parameter is required.
        self.teacher_user_id = teacher_user_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.class_id is not None:
            result['classId'] = self.class_id
        if self.op_user_id is not None:
            result['opUserId'] = self.op_user_id
        if self.role is not None:
            result['role'] = self.role
        if self.teacher_user_id is not None:
            result['teacherUserId'] = self.teacher_user_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('classId') is not None:
            self.class_id = m.get('classId')
        if m.get('opUserId') is not None:
            self.op_user_id = m.get('opUserId')
        if m.get('role') is not None:
            self.role = m.get('role')
        if m.get('teacherUserId') is not None:
            self.teacher_user_id = m.get('teacherUserId')
        return self


class CreateUniversityTeacherResponseBody(TeaModel):
    def __init__(
        self,
        result: bool = None,
    ):
        # This parameter is required.
        self.result = result

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.result is not None:
            result['result'] = self.result
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('result') is not None:
            self.result = m.get('result')
        return self


class CreateUniversityTeacherResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateUniversityTeacherResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateUniversityTeacherResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeactivateDeviceHeaders(TeaModel):
    def __init__(
        self,
        common_headers: Dict[str, str] = None,
        x_acs_dingtalk_access_token: str = None,
    ):
        self.common_headers = common_headers
        self.x_acs_dingtalk_access_token = x_acs_dingtalk_access_token

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.common_headers is not None:
            result['commonHeaders'] = self.common_headers
        if self.x_acs_dingtalk_access_token is not None:
            result['x-acs-dingtalk-access-token'] = self.x_acs_dingtalk_access_token
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('commonHeaders') is not None:
            self.common_headers = m.get('commonHeaders')
        if m.get('x-acs-dingtalk-access-token') is not None:
            self.x_acs_dingtalk_access_token = m.get('x-acs-dingtalk-access-token')
        return self


class DeactivateDeviceRequest(TeaModel):
    def __init__(
        self,
        model: str = None,
        sn: str = None,
        type: str = None,
    ):
        # This parameter is required.
        self.model = model
        # This parameter is required.
        self.sn = sn
        # This parameter is required.
        self.type = type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.model is not None:
            result['model'] = self.model
        if self.sn is not None:
            result['sn'] = self.sn
        if self.type is not None:
            result['type'] = self.type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('model') is not None:
            self.model = m.get('model')
        if m.get('sn') is not None:
            self.sn = m.get('sn')
        if m.get('type') is not None:
            self.type = m.get('type')
        return self


class DeactivateDeviceResponseBody(TeaModel):
    def __init__(
        self,
        activate_times: int = None,
    ):
        self.activate_times = activate_times

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.activate_times is not None:
            result['activateTimes'] = self.activate_times
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('activateTimes') is not None:
            self.activate_times = m.get('activateTimes')
        return self


class DeactivateDeviceResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeactivateDeviceResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeactivateDeviceResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeductPointHeaders(TeaModel):
    def __init__(
        self,
        common_headers: Dict[str, str] = None,
        x_acs_dingtalk_access_token: str = None,
    ):
        self.common_headers = common_headers
        self.x_acs_dingtalk_access_token = x_acs_dingtalk_access_token

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.common_headers is not None:
            result['commonHeaders'] = self.common_headers
        if self.x_acs_dingtalk_access_token is not None:
            result['x-acs-dingtalk-access-token'] = self.x_acs_dingtalk_access_token
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('commonHeaders') is not None:
            self.common_headers = m.get('commonHeaders')
        if m.get('x-acs-dingtalk-access-token') is not None:
            self.x_acs_dingtalk_access_token = m.get('x-acs-dingtalk-access-token')
        return self


class DeductPointRequest(TeaModel):
    def __init__(
        self,
        biz_id: str = None,
        deduct_desc: str = None,
        deduct_detail_url: str = None,
        deduct_num: int = None,
        point_type: str = None,
    ):
        # This parameter is required.
        self.biz_id = biz_id
        # This parameter is required.
        self.deduct_desc = deduct_desc
        # This parameter is required.
        self.deduct_detail_url = deduct_detail_url
        # This parameter is required.
        self.deduct_num = deduct_num
        # This parameter is required.
        self.point_type = point_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.biz_id is not None:
            result['bizId'] = self.biz_id
        if self.deduct_desc is not None:
            result['deductDesc'] = self.deduct_desc
        if self.deduct_detail_url is not None:
            result['deductDetailUrl'] = self.deduct_detail_url
        if self.deduct_num is not None:
            result['deductNum'] = self.deduct_num
        if self.point_type is not None:
            result['pointType'] = self.point_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('bizId') is not None:
            self.biz_id = m.get('bizId')
        if m.get('deductDesc') is not None:
            self.deduct_desc = m.get('deductDesc')
        if m.get('deductDetailUrl') is not None:
            self.deduct_detail_url = m.get('deductDetailUrl')
        if m.get('deductNum') is not None:
            self.deduct_num = m.get('deductNum')
        if m.get('pointType') is not None:
            self.point_type = m.get('pointType')
        return self


class DeductPointResponseBody(TeaModel):
    def __init__(
        self,
        result: bool = None,
        success: bool = None,
    ):
        self.result = result
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.result is not None:
            result['result'] = self.result
        if self.success is not None:
            result['success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('result') is not None:
            self.result = m.get('result')
        if m.get('success') is not None:
            self.success = m.get('success')
        return self


class DeductPointResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeductPointResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeductPointResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteCollegeAlumniDeptHeaders(TeaModel):
    def __init__(
        self,
        common_headers: Dict[str, str] = None,
        x_acs_dingtalk_access_token: str = None,
    ):
        self.common_headers = common_headers
        self.x_acs_dingtalk_access_token = x_acs_dingtalk_access_token

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.common_headers is not None:
            result['commonHeaders'] = self.common_headers
        if self.x_acs_dingtalk_access_token is not None:
            result['x-acs-dingtalk-access-token'] = self.x_acs_dingtalk_access_token
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('commonHeaders') is not None:
            self.common_headers = m.get('commonHeaders')
        if m.get('x-acs-dingtalk-access-token') is not None:
            self.x_acs_dingtalk_access_token = m.get('x-acs-dingtalk-access-token')
        return self


class DeleteCollegeAlumniDeptRequest(TeaModel):
    def __init__(
        self,
        dept_id: int = None,
        operator: str = None,
    ):
        # This parameter is required.
        self.dept_id = dept_id
        # This parameter is required.
        self.operator = operator

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dept_id is not None:
            result['deptId'] = self.dept_id
        if self.operator is not None:
            result['operator'] = self.operator
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('deptId') is not None:
            self.dept_id = m.get('deptId')
        if m.get('operator') is not None:
            self.operator = m.get('operator')
        return self


class DeleteCollegeAlumniDeptResponseBody(TeaModel):
    def __init__(
        self,
        success: bool = None,
    ):
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.success is not None:
            result['success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('success') is not None:
            self.success = m.get('success')
        return self


class DeleteCollegeAlumniDeptResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteCollegeAlumniDeptResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteCollegeAlumniDeptResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteCollegeAlumniUserInfoHeaders(TeaModel):
    def __init__(
        self,
        common_headers: Dict[str, str] = None,
        x_acs_dingtalk_access_token: str = None,
    ):
        self.common_headers = common_headers
        self.x_acs_dingtalk_access_token = x_acs_dingtalk_access_token

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.common_headers is not None:
            result['commonHeaders'] = self.common_headers
        if self.x_acs_dingtalk_access_token is not None:
            result['x-acs-dingtalk-access-token'] = self.x_acs_dingtalk_access_token
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('commonHeaders') is not None:
            self.common_headers = m.get('commonHeaders')
        if m.get('x-acs-dingtalk-access-token') is not None:
            self.x_acs_dingtalk_access_token = m.get('x-acs-dingtalk-access-token')
        return self


class DeleteCollegeAlumniUserInfoRequest(TeaModel):
    def __init__(
        self,
        dept_id: int = None,
        operator: str = None,
        user_ids: List[str] = None,
    ):
        # This parameter is required.
        self.dept_id = dept_id
        # This parameter is required.
        self.operator = operator
        # This parameter is required.
        self.user_ids = user_ids

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dept_id is not None:
            result['deptId'] = self.dept_id
        if self.operator is not None:
            result['operator'] = self.operator
        if self.user_ids is not None:
            result['userIds'] = self.user_ids
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('deptId') is not None:
            self.dept_id = m.get('deptId')
        if m.get('operator') is not None:
            self.operator = m.get('operator')
        if m.get('userIds') is not None:
            self.user_ids = m.get('userIds')
        return self


class DeleteCollegeAlumniUserInfoResponseBody(TeaModel):
    def __init__(
        self,
        success: bool = None,
    ):
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.success is not None:
            result['success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('success') is not None:
            self.success = m.get('success')
        return self


class DeleteCollegeAlumniUserInfoResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteCollegeAlumniUserInfoResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteCollegeAlumniUserInfoResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteCollegeContactSceneStruHeaders(TeaModel):
    def __init__(
        self,
        common_headers: Dict[str, str] = None,
        x_acs_dingtalk_access_token: str = None,
    ):
        self.common_headers = common_headers
        self.x_acs_dingtalk_access_token = x_acs_dingtalk_access_token

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.common_headers is not None:
            result['commonHeaders'] = self.common_headers
        if self.x_acs_dingtalk_access_token is not None:
            result['x-acs-dingtalk-access-token'] = self.x_acs_dingtalk_access_token
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('commonHeaders') is not None:
            self.common_headers = m.get('commonHeaders')
        if m.get('x-acs-dingtalk-access-token') is not None:
            self.x_acs_dingtalk_access_token = m.get('x-acs-dingtalk-access-token')
        return self


class DeleteCollegeContactSceneStruRequest(TeaModel):
    def __init__(
        self,
        stru_id: int = None,
    ):
        # This parameter is required.
        self.stru_id = stru_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.stru_id is not None:
            result['struId'] = self.stru_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('struId') is not None:
            self.stru_id = m.get('struId')
        return self


class DeleteCollegeContactSceneStruResponseBody(TeaModel):
    def __init__(
        self,
        success: bool = None,
    ):
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.success is not None:
            result['success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('success') is not None:
            self.success = m.get('success')
        return self


class DeleteCollegeContactSceneStruResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteCollegeContactSceneStruResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteCollegeContactSceneStruResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteDeptHeaders(TeaModel):
    def __init__(
        self,
        common_headers: Dict[str, str] = None,
        x_acs_dingtalk_access_token: str = None,
    ):
        self.common_headers = common_headers
        self.x_acs_dingtalk_access_token = x_acs_dingtalk_access_token

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.common_headers is not None:
            result['commonHeaders'] = self.common_headers
        if self.x_acs_dingtalk_access_token is not None:
            result['x-acs-dingtalk-access-token'] = self.x_acs_dingtalk_access_token
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('commonHeaders') is not None:
            self.common_headers = m.get('commonHeaders')
        if m.get('x-acs-dingtalk-access-token') is not None:
            self.x_acs_dingtalk_access_token = m.get('x-acs-dingtalk-access-token')
        return self


class DeleteDeptRequest(TeaModel):
    def __init__(
        self,
        operator: str = None,
    ):
        # This parameter is required.
        self.operator = operator

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.operator is not None:
            result['operator'] = self.operator
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('operator') is not None:
            self.operator = m.get('operator')
        return self


class DeleteDeptResponseBody(TeaModel):
    def __init__(
        self,
        success: bool = None,
    ):
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.success is not None:
            result['success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('success') is not None:
            self.success = m.get('success')
        return self


class DeleteDeptResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteDeptResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteDeptResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteDeviceHeaders(TeaModel):
    def __init__(
        self,
        common_headers: Dict[str, str] = None,
        x_acs_dingtalk_access_token: str = None,
    ):
        self.common_headers = common_headers
        self.x_acs_dingtalk_access_token = x_acs_dingtalk_access_token

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.common_headers is not None:
            result['commonHeaders'] = self.common_headers
        if self.x_acs_dingtalk_access_token is not None:
            result['x-acs-dingtalk-access-token'] = self.x_acs_dingtalk_access_token
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('commonHeaders') is not None:
            self.common_headers = m.get('commonHeaders')
        if m.get('x-acs-dingtalk-access-token') is not None:
            self.x_acs_dingtalk_access_token = m.get('x-acs-dingtalk-access-token')
        return self


class DeleteDeviceRequest(TeaModel):
    def __init__(
        self,
        sn: str = None,
    ):
        # This parameter is required.
        self.sn = sn

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.sn is not None:
            result['sn'] = self.sn
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('sn') is not None:
            self.sn = m.get('sn')
        return self


class DeleteDeviceResponseBody(TeaModel):
    def __init__(
        self,
        result: bool = None,
    ):
        self.result = result

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.result is not None:
            result['result'] = self.result
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('result') is not None:
            self.result = m.get('result')
        return self


class DeleteDeviceResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteDeviceResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteDeviceResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteDeviceOrgHeaders(TeaModel):
    def __init__(
        self,
        common_headers: Dict[str, str] = None,
        x_acs_dingtalk_access_token: str = None,
    ):
        self.common_headers = common_headers
        self.x_acs_dingtalk_access_token = x_acs_dingtalk_access_token

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.common_headers is not None:
            result['commonHeaders'] = self.common_headers
        if self.x_acs_dingtalk_access_token is not None:
            result['x-acs-dingtalk-access-token'] = self.x_acs_dingtalk_access_token
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('commonHeaders') is not None:
            self.common_headers = m.get('commonHeaders')
        if m.get('x-acs-dingtalk-access-token') is not None:
            self.x_acs_dingtalk_access_token = m.get('x-acs-dingtalk-access-token')
        return self


class DeleteDeviceOrgRequest(TeaModel):
    def __init__(
        self,
        auth_code: str = None,
        device_code: str = None,
    ):
        # This parameter is required.
        self.auth_code = auth_code
        # This parameter is required.
        self.device_code = device_code

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.auth_code is not None:
            result['authCode'] = self.auth_code
        if self.device_code is not None:
            result['deviceCode'] = self.device_code
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('authCode') is not None:
            self.auth_code = m.get('authCode')
        if m.get('deviceCode') is not None:
            self.device_code = m.get('deviceCode')
        return self


class DeleteDeviceOrgResponseBody(TeaModel):
    def __init__(
        self,
        success: bool = None,
    ):
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.success is not None:
            result['success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('success') is not None:
            self.success = m.get('success')
        return self


class DeleteDeviceOrgResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteDeviceOrgResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteDeviceOrgResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteEvaluatePerformanceHeaders(TeaModel):
    def __init__(
        self,
        common_headers: Dict[str, str] = None,
        x_acs_dingtalk_access_token: str = None,
    ):
        self.common_headers = common_headers
        self.x_acs_dingtalk_access_token = x_acs_dingtalk_access_token

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.common_headers is not None:
            result['commonHeaders'] = self.common_headers
        if self.x_acs_dingtalk_access_token is not None:
            result['x-acs-dingtalk-access-token'] = self.x_acs_dingtalk_access_token
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('commonHeaders') is not None:
            self.common_headers = m.get('commonHeaders')
        if m.get('x-acs-dingtalk-access-token') is not None:
            self.x_acs_dingtalk_access_token = m.get('x-acs-dingtalk-access-token')
        return self


class DeleteEvaluatePerformanceRequest(TeaModel):
    def __init__(
        self,
        evaluation_id_list: List[str] = None,
    ):
        self.evaluation_id_list = evaluation_id_list

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.evaluation_id_list is not None:
            result['evaluationIdList'] = self.evaluation_id_list
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('evaluationIdList') is not None:
            self.evaluation_id_list = m.get('evaluationIdList')
        return self


class DeleteEvaluatePerformanceResponseBody(TeaModel):
    def __init__(
        self,
        success: bool = None,
    ):
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.success is not None:
            result['success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('success') is not None:
            self.success = m.get('success')
        return self


class DeleteEvaluatePerformanceResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteEvaluatePerformanceResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteEvaluatePerformanceResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteGuardianHeaders(TeaModel):
    def __init__(
        self,
        common_headers: Dict[str, str] = None,
        x_acs_dingtalk_access_token: str = None,
    ):
        self.common_headers = common_headers
        self.x_acs_dingtalk_access_token = x_acs_dingtalk_access_token

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.common_headers is not None:
            result['commonHeaders'] = self.common_headers
        if self.x_acs_dingtalk_access_token is not None:
            result['x-acs-dingtalk-access-token'] = self.x_acs_dingtalk_access_token
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('commonHeaders') is not None:
            self.common_headers = m.get('commonHeaders')
        if m.get('x-acs-dingtalk-access-token') is not None:
            self.x_acs_dingtalk_access_token = m.get('x-acs-dingtalk-access-token')
        return self


class DeleteGuardianRequest(TeaModel):
    def __init__(
        self,
        operator: str = None,
        stu_id: str = None,
    ):
        # This parameter is required.
        self.operator = operator
        # This parameter is required.
        self.stu_id = stu_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.operator is not None:
            result['operator'] = self.operator
        if self.stu_id is not None:
            result['stuId'] = self.stu_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('operator') is not None:
            self.operator = m.get('operator')
        if m.get('stuId') is not None:
            self.stu_id = m.get('stuId')
        return self


class DeleteGuardianResponseBody(TeaModel):
    def __init__(
        self,
        success: bool = None,
    ):
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.success is not None:
            result['success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('success') is not None:
            self.success = m.get('success')
        return self


class DeleteGuardianResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteGuardianResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteGuardianResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteOrgRelationHeaders(TeaModel):
    def __init__(
        self,
        common_headers: Dict[str, str] = None,
        x_acs_dingtalk_access_token: str = None,
    ):
        self.common_headers = common_headers
        self.x_acs_dingtalk_access_token = x_acs_dingtalk_access_token

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.common_headers is not None:
            result['commonHeaders'] = self.common_headers
        if self.x_acs_dingtalk_access_token is not None:
            result['x-acs-dingtalk-access-token'] = self.x_acs_dingtalk_access_token
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('commonHeaders') is not None:
            self.common_headers = m.get('commonHeaders')
        if m.get('x-acs-dingtalk-access-token') is not None:
            self.x_acs_dingtalk_access_token = m.get('x-acs-dingtalk-access-token')
        return self


class DeleteOrgRelationRequest(TeaModel):
    def __init__(
        self,
        auth_code: str = None,
        target_corp_id: str = None,
    ):
        # This parameter is required.
        self.auth_code = auth_code
        # This parameter is required.
        self.target_corp_id = target_corp_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.auth_code is not None:
            result['authCode'] = self.auth_code
        if self.target_corp_id is not None:
            result['targetCorpId'] = self.target_corp_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('authCode') is not None:
            self.auth_code = m.get('authCode')
        if m.get('targetCorpId') is not None:
            self.target_corp_id = m.get('targetCorpId')
        return self


class DeleteOrgRelationResponseBody(TeaModel):
    def __init__(
        self,
        success: bool = None,
    ):
        # This parameter is required.
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.success is not None:
            result['success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('success') is not None:
            self.success = m.get('success')
        return self


class DeleteOrgRelationResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteOrgRelationResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteOrgRelationResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeletePhysicalClassroomHeaders(TeaModel):
    def __init__(
        self,
        common_headers: Dict[str, str] = None,
        x_acs_dingtalk_access_token: str = None,
    ):
        self.common_headers = common_headers
        self.x_acs_dingtalk_access_token = x_acs_dingtalk_access_token

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.common_headers is not None:
            result['commonHeaders'] = self.common_headers
        if self.x_acs_dingtalk_access_token is not None:
            result['x-acs-dingtalk-access-token'] = self.x_acs_dingtalk_access_token
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('commonHeaders') is not None:
            self.common_headers = m.get('commonHeaders')
        if m.get('x-acs-dingtalk-access-token') is not None:
            self.x_acs_dingtalk_access_token = m.get('x-acs-dingtalk-access-token')
        return self


class DeletePhysicalClassroomRequest(TeaModel):
    def __init__(
        self,
        classroom_id: int = None,
        op_user_id: str = None,
    ):
        # This parameter is required.
        self.classroom_id = classroom_id
        # This parameter is required.
        self.op_user_id = op_user_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.classroom_id is not None:
            result['classroomId'] = self.classroom_id
        if self.op_user_id is not None:
            result['opUserId'] = self.op_user_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('classroomId') is not None:
            self.classroom_id = m.get('classroomId')
        if m.get('opUserId') is not None:
            self.op_user_id = m.get('opUserId')
        return self


class DeletePhysicalClassroomResponseBody(TeaModel):
    def __init__(
        self,
        result: bool = None,
    ):
        self.result = result

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.result is not None:
            result['result'] = self.result
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('result') is not None:
            self.result = m.get('result')
        return self


class DeletePhysicalClassroomResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeletePhysicalClassroomResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeletePhysicalClassroomResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteRemoteClassCourseHeaders(TeaModel):
    def __init__(
        self,
        common_headers: Dict[str, str] = None,
        x_acs_dingtalk_access_token: str = None,
    ):
        self.common_headers = common_headers
        self.x_acs_dingtalk_access_token = x_acs_dingtalk_access_token

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.common_headers is not None:
            result['commonHeaders'] = self.common_headers
        if self.x_acs_dingtalk_access_token is not None:
            result['x-acs-dingtalk-access-token'] = self.x_acs_dingtalk_access_token
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('commonHeaders') is not None:
            self.common_headers = m.get('commonHeaders')
        if m.get('x-acs-dingtalk-access-token') is not None:
            self.x_acs_dingtalk_access_token = m.get('x-acs-dingtalk-access-token')
        return self


class DeleteRemoteClassCourseRequest(TeaModel):
    def __init__(
        self,
        auth_code: str = None,
    ):
        # This parameter is required.
        self.auth_code = auth_code

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.auth_code is not None:
            result['authCode'] = self.auth_code
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('authCode') is not None:
            self.auth_code = m.get('authCode')
        return self


class DeleteRemoteClassCourseResponseBody(TeaModel):
    def __init__(
        self,
        success: bool = None,
    ):
        # This parameter is required.
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.success is not None:
            result['success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('success') is not None:
            self.success = m.get('success')
        return self


class DeleteRemoteClassCourseResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteRemoteClassCourseResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteRemoteClassCourseResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteSchoolReportHeaders(TeaModel):
    def __init__(
        self,
        common_headers: Dict[str, str] = None,
        x_acs_dingtalk_access_token: str = None,
    ):
        self.common_headers = common_headers
        self.x_acs_dingtalk_access_token = x_acs_dingtalk_access_token

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.common_headers is not None:
            result['commonHeaders'] = self.common_headers
        if self.x_acs_dingtalk_access_token is not None:
            result['x-acs-dingtalk-access-token'] = self.x_acs_dingtalk_access_token
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('commonHeaders') is not None:
            self.common_headers = m.get('commonHeaders')
        if m.get('x-acs-dingtalk-access-token') is not None:
            self.x_acs_dingtalk_access_token = m.get('x-acs-dingtalk-access-token')
        return self


class DeleteSchoolReportRequest(TeaModel):
    def __init__(
        self,
        biz_code: str = None,
        school_report_id: int = None,
        teacher_id: str = None,
    ):
        # This parameter is required.
        self.biz_code = biz_code
        # This parameter is required.
        self.school_report_id = school_report_id
        # This parameter is required.
        self.teacher_id = teacher_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.biz_code is not None:
            result['bizCode'] = self.biz_code
        if self.school_report_id is not None:
            result['schoolReportId'] = self.school_report_id
        if self.teacher_id is not None:
            result['teacherId'] = self.teacher_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('bizCode') is not None:
            self.biz_code = m.get('bizCode')
        if m.get('schoolReportId') is not None:
            self.school_report_id = m.get('schoolReportId')
        if m.get('teacherId') is not None:
            self.teacher_id = m.get('teacherId')
        return self


class DeleteSchoolReportResponseBodyResult(TeaModel):
    def __init__(
        self,
        school_report_id: int = None,
    ):
        self.school_report_id = school_report_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.school_report_id is not None:
            result['schoolReportId'] = self.school_report_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('schoolReportId') is not None:
            self.school_report_id = m.get('schoolReportId')
        return self


class DeleteSchoolReportResponseBody(TeaModel):
    def __init__(
        self,
        result: DeleteSchoolReportResponseBodyResult = None,
        success: bool = None,
    ):
        self.result = result
        self.success = success

    def validate(self):
        if self.result:
            self.result.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.result is not None:
            result['result'] = self.result.to_map()
        if self.success is not None:
            result['success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('result') is not None:
            temp_model = DeleteSchoolReportResponseBodyResult()
            self.result = temp_model.from_map(m['result'])
        if m.get('success') is not None:
            self.success = m.get('success')
        return self


class DeleteSchoolReportResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteSchoolReportResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteSchoolReportResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteStudentHeaders(TeaModel):
    def __init__(
        self,
        common_headers: Dict[str, str] = None,
        x_acs_dingtalk_access_token: str = None,
    ):
        self.common_headers = common_headers
        self.x_acs_dingtalk_access_token = x_acs_dingtalk_access_token

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.common_headers is not None:
            result['commonHeaders'] = self.common_headers
        if self.x_acs_dingtalk_access_token is not None:
            result['x-acs-dingtalk-access-token'] = self.x_acs_dingtalk_access_token
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('commonHeaders') is not None:
            self.common_headers = m.get('commonHeaders')
        if m.get('x-acs-dingtalk-access-token') is not None:
            self.x_acs_dingtalk_access_token = m.get('x-acs-dingtalk-access-token')
        return self


class DeleteStudentRequest(TeaModel):
    def __init__(
        self,
        operator: str = None,
    ):
        # This parameter is required.
        self.operator = operator

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.operator is not None:
            result['operator'] = self.operator
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('operator') is not None:
            self.operator = m.get('operator')
        return self


class DeleteStudentResponseBody(TeaModel):
    def __init__(
        self,
        success: bool = None,
    ):
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.success is not None:
            result['success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('success') is not None:
            self.success = m.get('success')
        return self


class DeleteStudentResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteStudentResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteStudentResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteTeacherHeaders(TeaModel):
    def __init__(
        self,
        common_headers: Dict[str, str] = None,
        x_acs_dingtalk_access_token: str = None,
    ):
        self.common_headers = common_headers
        self.x_acs_dingtalk_access_token = x_acs_dingtalk_access_token

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.common_headers is not None:
            result['commonHeaders'] = self.common_headers
        if self.x_acs_dingtalk_access_token is not None:
            result['x-acs-dingtalk-access-token'] = self.x_acs_dingtalk_access_token
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('commonHeaders') is not None:
            self.common_headers = m.get('commonHeaders')
        if m.get('x-acs-dingtalk-access-token') is not None:
            self.x_acs_dingtalk_access_token = m.get('x-acs-dingtalk-access-token')
        return self


class DeleteTeacherRequest(TeaModel):
    def __init__(
        self,
        adviser: int = None,
        operator: str = None,
    ):
        # This parameter is required.
        self.adviser = adviser
        # This parameter is required.
        self.operator = operator

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.adviser is not None:
            result['adviser'] = self.adviser
        if self.operator is not None:
            result['operator'] = self.operator
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('adviser') is not None:
            self.adviser = m.get('adviser')
        if m.get('operator') is not None:
            self.operator = m.get('operator')
        return self


class DeleteTeacherResponseBody(TeaModel):
    def __init__(
        self,
        success: bool = None,
    ):
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.success is not None:
            result['success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('success') is not None:
            self.success = m.get('success')
        return self


class DeleteTeacherResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteTeacherResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteTeacherResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteUniversityCourseGroupHeaders(TeaModel):
    def __init__(
        self,
        common_headers: Dict[str, str] = None,
        x_acs_dingtalk_access_token: str = None,
    ):
        self.common_headers = common_headers
        self.x_acs_dingtalk_access_token = x_acs_dingtalk_access_token

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.common_headers is not None:
            result['commonHeaders'] = self.common_headers
        if self.x_acs_dingtalk_access_token is not None:
            result['x-acs-dingtalk-access-token'] = self.x_acs_dingtalk_access_token
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('commonHeaders') is not None:
            self.common_headers = m.get('commonHeaders')
        if m.get('x-acs-dingtalk-access-token') is not None:
            self.x_acs_dingtalk_access_token = m.get('x-acs-dingtalk-access-token')
        return self


class DeleteUniversityCourseGroupRequest(TeaModel):
    def __init__(
        self,
        course_group_code: str = None,
        op_user_id: str = None,
    ):
        # This parameter is required.
        self.course_group_code = course_group_code
        # This parameter is required.
        self.op_user_id = op_user_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.course_group_code is not None:
            result['courseGroupCode'] = self.course_group_code
        if self.op_user_id is not None:
            result['opUserId'] = self.op_user_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('courseGroupCode') is not None:
            self.course_group_code = m.get('courseGroupCode')
        if m.get('opUserId') is not None:
            self.op_user_id = m.get('opUserId')
        return self


class DeleteUniversityCourseGroupResponseBody(TeaModel):
    def __init__(
        self,
        result: bool = None,
    ):
        # This parameter is required.
        self.result = result

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.result is not None:
            result['result'] = self.result
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('result') is not None:
            self.result = m.get('result')
        return self


class DeleteUniversityCourseGroupResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteUniversityCourseGroupResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteUniversityCourseGroupResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteUniversityStudentHeaders(TeaModel):
    def __init__(
        self,
        common_headers: Dict[str, str] = None,
        x_acs_dingtalk_access_token: str = None,
    ):
        self.common_headers = common_headers
        self.x_acs_dingtalk_access_token = x_acs_dingtalk_access_token

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.common_headers is not None:
            result['commonHeaders'] = self.common_headers
        if self.x_acs_dingtalk_access_token is not None:
            result['x-acs-dingtalk-access-token'] = self.x_acs_dingtalk_access_token
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('commonHeaders') is not None:
            self.common_headers = m.get('commonHeaders')
        if m.get('x-acs-dingtalk-access-token') is not None:
            self.x_acs_dingtalk_access_token = m.get('x-acs-dingtalk-access-token')
        return self


class DeleteUniversityStudentRequest(TeaModel):
    def __init__(
        self,
        class_id: int = None,
        op_user_id: str = None,
        student_user_id: str = None,
    ):
        # This parameter is required.
        self.class_id = class_id
        # This parameter is required.
        self.op_user_id = op_user_id
        # This parameter is required.
        self.student_user_id = student_user_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.class_id is not None:
            result['classId'] = self.class_id
        if self.op_user_id is not None:
            result['opUserId'] = self.op_user_id
        if self.student_user_id is not None:
            result['studentUserId'] = self.student_user_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('classId') is not None:
            self.class_id = m.get('classId')
        if m.get('opUserId') is not None:
            self.op_user_id = m.get('opUserId')
        if m.get('studentUserId') is not None:
            self.student_user_id = m.get('studentUserId')
        return self


class DeleteUniversityStudentResponseBody(TeaModel):
    def __init__(
        self,
        result: bool = None,
    ):
        # This parameter is required.
        self.result = result

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.result is not None:
            result['result'] = self.result
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('result') is not None:
            self.result = m.get('result')
        return self


class DeleteUniversityStudentResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteUniversityStudentResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteUniversityStudentResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteUniversityTeacherHeaders(TeaModel):
    def __init__(
        self,
        common_headers: Dict[str, str] = None,
        x_acs_dingtalk_access_token: str = None,
    ):
        self.common_headers = common_headers
        self.x_acs_dingtalk_access_token = x_acs_dingtalk_access_token

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.common_headers is not None:
            result['commonHeaders'] = self.common_headers
        if self.x_acs_dingtalk_access_token is not None:
            result['x-acs-dingtalk-access-token'] = self.x_acs_dingtalk_access_token
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('commonHeaders') is not None:
            self.common_headers = m.get('commonHeaders')
        if m.get('x-acs-dingtalk-access-token') is not None:
            self.x_acs_dingtalk_access_token = m.get('x-acs-dingtalk-access-token')
        return self


class DeleteUniversityTeacherRequest(TeaModel):
    def __init__(
        self,
        class_id: int = None,
        op_user_id: str = None,
        role: str = None,
        teacher_user_id: str = None,
    ):
        # This parameter is required.
        self.class_id = class_id
        # This parameter is required.
        self.op_user_id = op_user_id
        # This parameter is required.
        self.role = role
        # This parameter is required.
        self.teacher_user_id = teacher_user_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.class_id is not None:
            result['classId'] = self.class_id
        if self.op_user_id is not None:
            result['opUserId'] = self.op_user_id
        if self.role is not None:
            result['role'] = self.role
        if self.teacher_user_id is not None:
            result['teacherUserId'] = self.teacher_user_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('classId') is not None:
            self.class_id = m.get('classId')
        if m.get('opUserId') is not None:
            self.op_user_id = m.get('opUserId')
        if m.get('role') is not None:
            self.role = m.get('role')
        if m.get('teacherUserId') is not None:
            self.teacher_user_id = m.get('teacherUserId')
        return self


class DeleteUniversityTeacherResponseBody(TeaModel):
    def __init__(
        self,
        result: bool = None,
    ):
        # This parameter is required.
        self.result = result

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.result is not None:
            result['result'] = self.result
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('result') is not None:
            self.result = m.get('result')
        return self


class DeleteUniversityTeacherResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteUniversityTeacherResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteUniversityTeacherResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeviceHeartbeatHeaders(TeaModel):
    def __init__(
        self,
        common_headers: Dict[str, str] = None,
        x_acs_dingtalk_access_token: str = None,
    ):
        self.common_headers = common_headers
        self.x_acs_dingtalk_access_token = x_acs_dingtalk_access_token

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.common_headers is not None:
            result['commonHeaders'] = self.common_headers
        if self.x_acs_dingtalk_access_token is not None:
            result['x-acs-dingtalk-access-token'] = self.x_acs_dingtalk_access_token
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('commonHeaders') is not None:
            self.common_headers = m.get('commonHeaders')
        if m.get('x-acs-dingtalk-access-token') is not None:
            self.x_acs_dingtalk_access_token = m.get('x-acs-dingtalk-access-token')
        return self


class DeviceHeartbeatRequest(TeaModel):
    def __init__(
        self,
        sn: str = None,
    ):
        # This parameter is required.
        self.sn = sn

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.sn is not None:
            result['sn'] = self.sn
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('sn') is not None:
            self.sn = m.get('sn')
        return self


class DeviceHeartbeatResponseBody(TeaModel):
    def __init__(
        self,
        command: int = None,
    ):
        # This parameter is required.
        self.command = command

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.command is not None:
            result['command'] = self.command
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('command') is not None:
            self.command = m.get('command')
        return self


class DeviceHeartbeatResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeviceHeartbeatResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeviceHeartbeatResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DisableCollegeContactSceneStruHeaders(TeaModel):
    def __init__(
        self,
        common_headers: Dict[str, str] = None,
        x_acs_dingtalk_access_token: str = None,
    ):
        self.common_headers = common_headers
        self.x_acs_dingtalk_access_token = x_acs_dingtalk_access_token

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.common_headers is not None:
            result['commonHeaders'] = self.common_headers
        if self.x_acs_dingtalk_access_token is not None:
            result['x-acs-dingtalk-access-token'] = self.x_acs_dingtalk_access_token
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('commonHeaders') is not None:
            self.common_headers = m.get('commonHeaders')
        if m.get('x-acs-dingtalk-access-token') is not None:
            self.x_acs_dingtalk_access_token = m.get('x-acs-dingtalk-access-token')
        return self


class DisableCollegeContactSceneStruRequest(TeaModel):
    def __init__(
        self,
        stru_id: int = None,
    ):
        # This parameter is required.
        self.stru_id = stru_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.stru_id is not None:
            result['struId'] = self.stru_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('struId') is not None:
            self.stru_id = m.get('struId')
        return self


class DisableCollegeContactSceneStruResponseBody(TeaModel):
    def __init__(
        self,
        success: bool = None,
    ):
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.success is not None:
            result['success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('success') is not None:
            self.success = m.get('success')
        return self


class DisableCollegeContactSceneStruResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DisableCollegeContactSceneStruResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DisableCollegeContactSceneStruResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class EduAIGCCallbackHeaders(TeaModel):
    def __init__(
        self,
        common_headers: Dict[str, str] = None,
        x_acs_dingtalk_access_token: str = None,
    ):
        self.common_headers = common_headers
        self.x_acs_dingtalk_access_token = x_acs_dingtalk_access_token

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.common_headers is not None:
            result['commonHeaders'] = self.common_headers
        if self.x_acs_dingtalk_access_token is not None:
            result['x-acs-dingtalk-access-token'] = self.x_acs_dingtalk_access_token
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('commonHeaders') is not None:
            self.common_headers = m.get('commonHeaders')
        if m.get('x-acs-dingtalk-access-token') is not None:
            self.x_acs_dingtalk_access_token = m.get('x-acs-dingtalk-access-token')
        return self


class EduAIGCCallbackRequest(TeaModel):
    def __init__(
        self,
        channel_code: str = None,
        commit_time: int = None,
        complete_time: int = None,
        content: str = None,
        content_size: int = None,
        content_type: str = None,
        ext: str = None,
        prompt: str = None,
        remark: str = None,
    ):
        # This parameter is required.
        self.channel_code = channel_code
        self.commit_time = commit_time
        self.complete_time = complete_time
        # This parameter is required.
        self.content = content
        # This parameter is required.
        self.content_size = content_size
        # This parameter is required.
        self.content_type = content_type
        self.ext = ext
        # This parameter is required.
        self.prompt = prompt
        self.remark = remark

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.channel_code is not None:
            result['channelCode'] = self.channel_code
        if self.commit_time is not None:
            result['commitTime'] = self.commit_time
        if self.complete_time is not None:
            result['completeTime'] = self.complete_time
        if self.content is not None:
            result['content'] = self.content
        if self.content_size is not None:
            result['contentSize'] = self.content_size
        if self.content_type is not None:
            result['contentType'] = self.content_type
        if self.ext is not None:
            result['ext'] = self.ext
        if self.prompt is not None:
            result['prompt'] = self.prompt
        if self.remark is not None:
            result['remark'] = self.remark
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('channelCode') is not None:
            self.channel_code = m.get('channelCode')
        if m.get('commitTime') is not None:
            self.commit_time = m.get('commitTime')
        if m.get('completeTime') is not None:
            self.complete_time = m.get('completeTime')
        if m.get('content') is not None:
            self.content = m.get('content')
        if m.get('contentSize') is not None:
            self.content_size = m.get('contentSize')
        if m.get('contentType') is not None:
            self.content_type = m.get('contentType')
        if m.get('ext') is not None:
            self.ext = m.get('ext')
        if m.get('prompt') is not None:
            self.prompt = m.get('prompt')
        if m.get('remark') is not None:
            self.remark = m.get('remark')
        return self


class EduAIGCCallbackResponseBody(TeaModel):
    def __init__(
        self,
        success: bool = None,
    ):
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.success is not None:
            result['success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('success') is not None:
            self.success = m.get('success')
        return self


class EduAIGCCallbackResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: EduAIGCCallbackResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = EduAIGCCallbackResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class EduAIModelCompleteHeaders(TeaModel):
    def __init__(
        self,
        common_headers: Dict[str, str] = None,
        x_acs_dingtalk_access_token: str = None,
    ):
        self.common_headers = common_headers
        self.x_acs_dingtalk_access_token = x_acs_dingtalk_access_token

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.common_headers is not None:
            result['commonHeaders'] = self.common_headers
        if self.x_acs_dingtalk_access_token is not None:
            result['x-acs-dingtalk-access-token'] = self.x_acs_dingtalk_access_token
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('commonHeaders') is not None:
            self.common_headers = m.get('commonHeaders')
        if m.get('x-acs-dingtalk-access-token') is not None:
            self.x_acs_dingtalk_access_token = m.get('x-acs-dingtalk-access-token')
        return self


class EduAIModelCompleteRequest(TeaModel):
    def __init__(
        self,
        max_tokens: int = None,
        model: str = None,
        prompt: str = None,
        scene: str = None,
        temperature: float = None,
        top_p: float = None,
        user_id: str = None,
    ):
        self.max_tokens = max_tokens
        # This parameter is required.
        self.model = model
        # This parameter is required.
        self.prompt = prompt
        # This parameter is required.
        self.scene = scene
        self.temperature = temperature
        self.top_p = top_p
        # This parameter is required.
        self.user_id = user_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.max_tokens is not None:
            result['maxTokens'] = self.max_tokens
        if self.model is not None:
            result['model'] = self.model
        if self.prompt is not None:
            result['prompt'] = self.prompt
        if self.scene is not None:
            result['scene'] = self.scene
        if self.temperature is not None:
            result['temperature'] = self.temperature
        if self.top_p is not None:
            result['top_p'] = self.top_p
        if self.user_id is not None:
            result['userId'] = self.user_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('maxTokens') is not None:
            self.max_tokens = m.get('maxTokens')
        if m.get('model') is not None:
            self.model = m.get('model')
        if m.get('prompt') is not None:
            self.prompt = m.get('prompt')
        if m.get('scene') is not None:
            self.scene = m.get('scene')
        if m.get('temperature') is not None:
            self.temperature = m.get('temperature')
        if m.get('top_p') is not None:
            self.top_p = m.get('top_p')
        if m.get('userId') is not None:
            self.user_id = m.get('userId')
        return self


class EduAIModelCompleteResponseBodyResult(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        result: Dict[str, Any] = None,
    ):
        self.request_id = request_id
        self.result = result

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['requestId'] = self.request_id
        if self.result is not None:
            result['result'] = self.result
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('requestId') is not None:
            self.request_id = m.get('requestId')
        if m.get('result') is not None:
            self.result = m.get('result')
        return self


class EduAIModelCompleteResponseBody(TeaModel):
    def __init__(
        self,
        result: EduAIModelCompleteResponseBodyResult = None,
        success: bool = None,
    ):
        self.result = result
        self.success = success

    def validate(self):
        if self.result:
            self.result.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.result is not None:
            result['result'] = self.result.to_map()
        if self.success is not None:
            result['success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('result') is not None:
            temp_model = EduAIModelCompleteResponseBodyResult()
            self.result = temp_model.from_map(m['result'])
        if m.get('success') is not None:
            self.success = m.get('success')
        return self


class EduAIModelCompleteResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: EduAIModelCompleteResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = EduAIModelCompleteResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class EduFindUserRolesByUserIdHeaders(TeaModel):
    def __init__(
        self,
        common_headers: Dict[str, str] = None,
        x_acs_dingtalk_access_token: str = None,
    ):
        self.common_headers = common_headers
        self.x_acs_dingtalk_access_token = x_acs_dingtalk_access_token

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.common_headers is not None:
            result['commonHeaders'] = self.common_headers
        if self.x_acs_dingtalk_access_token is not None:
            result['x-acs-dingtalk-access-token'] = self.x_acs_dingtalk_access_token
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('commonHeaders') is not None:
            self.common_headers = m.get('commonHeaders')
        if m.get('x-acs-dingtalk-access-token') is not None:
            self.x_acs_dingtalk_access_token = m.get('x-acs-dingtalk-access-token')
        return self


class EduFindUserRolesByUserIdRequest(TeaModel):
    def __init__(
        self,
        class_id: int = None,
        corp_id: str = None,
        has_org_role: bool = None,
        user_id: str = None,
    ):
        self.class_id = class_id
        self.corp_id = corp_id
        self.has_org_role = has_org_role
        self.user_id = user_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.class_id is not None:
            result['classId'] = self.class_id
        if self.corp_id is not None:
            result['corpId'] = self.corp_id
        if self.has_org_role is not None:
            result['hasOrgRole'] = self.has_org_role
        if self.user_id is not None:
            result['userId'] = self.user_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('classId') is not None:
            self.class_id = m.get('classId')
        if m.get('corpId') is not None:
            self.corp_id = m.get('corpId')
        if m.get('hasOrgRole') is not None:
            self.has_org_role = m.get('hasOrgRole')
        if m.get('userId') is not None:
            self.user_id = m.get('userId')
        return self


class EduFindUserRolesByUserIdResponseBody(TeaModel):
    def __init__(
        self,
        result: List[str] = None,
    ):
        self.result = result

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.result is not None:
            result['result'] = self.result
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('result') is not None:
            self.result = m.get('result')
        return self


class EduFindUserRolesByUserIdResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: EduFindUserRolesByUserIdResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = EduFindUserRolesByUserIdResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class EduGetFileSpaceHeaders(TeaModel):
    def __init__(
        self,
        common_headers: Dict[str, str] = None,
        x_acs_dingtalk_access_token: str = None,
    ):
        self.common_headers = common_headers
        self.x_acs_dingtalk_access_token = x_acs_dingtalk_access_token

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.common_headers is not None:
            result['commonHeaders'] = self.common_headers
        if self.x_acs_dingtalk_access_token is not None:
            result['x-acs-dingtalk-access-token'] = self.x_acs_dingtalk_access_token
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('commonHeaders') is not None:
            self.common_headers = m.get('commonHeaders')
        if m.get('x-acs-dingtalk-access-token') is not None:
            self.x_acs_dingtalk_access_token = m.get('x-acs-dingtalk-access-token')
        return self


class EduGetFileSpaceRequest(TeaModel):
    def __init__(
        self,
        channel_code: str = None,
    ):
        self.channel_code = channel_code

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.channel_code is not None:
            result['channelCode'] = self.channel_code
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('channelCode') is not None:
            self.channel_code = m.get('channelCode')
        return self


class EduGetFileSpaceResponseBodyResult(TeaModel):
    def __init__(
        self,
        folder_id: str = None,
        space_id: str = None,
    ):
        self.folder_id = folder_id
        self.space_id = space_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.folder_id is not None:
            result['folderId'] = self.folder_id
        if self.space_id is not None:
            result['spaceId'] = self.space_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('folderId') is not None:
            self.folder_id = m.get('folderId')
        if m.get('spaceId') is not None:
            self.space_id = m.get('spaceId')
        return self


class EduGetFileSpaceResponseBody(TeaModel):
    def __init__(
        self,
        result: EduGetFileSpaceResponseBodyResult = None,
        success: bool = None,
    ):
        self.result = result
        self.success = success

    def validate(self):
        if self.result:
            self.result.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.result is not None:
            result['result'] = self.result.to_map()
        if self.success is not None:
            result['success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('result') is not None:
            temp_model = EduGetFileSpaceResponseBodyResult()
            self.result = temp_model.from_map(m['result'])
        if m.get('success') is not None:
            self.success = m.get('success')
        return self


class EduGetFileSpaceResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: EduGetFileSpaceResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = EduGetFileSpaceResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class EduListUserByFromUserIdsHeaders(TeaModel):
    def __init__(
        self,
        common_headers: Dict[str, str] = None,
        x_acs_dingtalk_access_token: str = None,
    ):
        self.common_headers = common_headers
        self.x_acs_dingtalk_access_token = x_acs_dingtalk_access_token

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.common_headers is not None:
            result['commonHeaders'] = self.common_headers
        if self.x_acs_dingtalk_access_token is not None:
            result['x-acs-dingtalk-access-token'] = self.x_acs_dingtalk_access_token
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('commonHeaders') is not None:
            self.common_headers = m.get('commonHeaders')
        if m.get('x-acs-dingtalk-access-token') is not None:
            self.x_acs_dingtalk_access_token = m.get('x-acs-dingtalk-access-token')
        return self


class EduListUserByFromUserIdsRequest(TeaModel):
    def __init__(
        self,
        class_id: int = None,
        corp_id: str = None,
        guardian_user_id: str = None,
    ):
        self.class_id = class_id
        self.corp_id = corp_id
        self.guardian_user_id = guardian_user_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.class_id is not None:
            result['classId'] = self.class_id
        if self.corp_id is not None:
            result['corpId'] = self.corp_id
        if self.guardian_user_id is not None:
            result['guardianUserId'] = self.guardian_user_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('classId') is not None:
            self.class_id = m.get('classId')
        if m.get('corpId') is not None:
            self.corp_id = m.get('corpId')
        if m.get('guardianUserId') is not None:
            self.guardian_user_id = m.get('guardianUserId')
        return self


class EduListUserByFromUserIdsResponseBodyResult(TeaModel):
    def __init__(
        self,
        campus_id: int = None,
        class_id: int = None,
        grade_id: int = None,
        name: str = None,
        period_id: int = None,
        role: str = None,
        user_id: str = None,
    ):
        self.campus_id = campus_id
        self.class_id = class_id
        self.grade_id = grade_id
        self.name = name
        self.period_id = period_id
        self.role = role
        self.user_id = user_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.campus_id is not None:
            result['campusId'] = self.campus_id
        if self.class_id is not None:
            result['classId'] = self.class_id
        if self.grade_id is not None:
            result['gradeId'] = self.grade_id
        if self.name is not None:
            result['name'] = self.name
        if self.period_id is not None:
            result['periodId'] = self.period_id
        if self.role is not None:
            result['role'] = self.role
        if self.user_id is not None:
            result['userId'] = self.user_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('campusId') is not None:
            self.campus_id = m.get('campusId')
        if m.get('classId') is not None:
            self.class_id = m.get('classId')
        if m.get('gradeId') is not None:
            self.grade_id = m.get('gradeId')
        if m.get('name') is not None:
            self.name = m.get('name')
        if m.get('periodId') is not None:
            self.period_id = m.get('periodId')
        if m.get('role') is not None:
            self.role = m.get('role')
        if m.get('userId') is not None:
            self.user_id = m.get('userId')
        return self


class EduListUserByFromUserIdsResponseBody(TeaModel):
    def __init__(
        self,
        result: List[EduListUserByFromUserIdsResponseBodyResult] = None,
    ):
        self.result = result

    def validate(self):
        if self.result:
            for k in self.result:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['result'] = []
        if self.result is not None:
            for k in self.result:
                result['result'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.result = []
        if m.get('result') is not None:
            for k in m.get('result'):
                temp_model = EduListUserByFromUserIdsResponseBodyResult()
                self.result.append(temp_model.from_map(k))
        return self


class EduListUserByFromUserIdsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: EduListUserByFromUserIdsResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = EduListUserByFromUserIdsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class EduTeacherListHeaders(TeaModel):
    def __init__(
        self,
        common_headers: Dict[str, str] = None,
        x_acs_dingtalk_access_token: str = None,
    ):
        self.common_headers = common_headers
        self.x_acs_dingtalk_access_token = x_acs_dingtalk_access_token

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.common_headers is not None:
            result['commonHeaders'] = self.common_headers
        if self.x_acs_dingtalk_access_token is not None:
            result['x-acs-dingtalk-access-token'] = self.x_acs_dingtalk_access_token
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('commonHeaders') is not None:
            self.common_headers = m.get('commonHeaders')
        if m.get('x-acs-dingtalk-access-token') is not None:
            self.x_acs_dingtalk_access_token = m.get('x-acs-dingtalk-access-token')
        return self


class EduTeacherListRequest(TeaModel):
    def __init__(
        self,
        page_number: int = None,
        page_size: int = None,
    ):
        # This parameter is required.
        self.page_number = page_number
        # This parameter is required.
        self.page_size = page_size

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page_number is not None:
            result['pageNumber'] = self.page_number
        if self.page_size is not None:
            result['pageSize'] = self.page_size
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('pageNumber') is not None:
            self.page_number = m.get('pageNumber')
        if m.get('pageSize') is not None:
            self.page_size = m.get('pageSize')
        return self


class EduTeacherListResponseBodyResultTeacherDetails(TeaModel):
    def __init__(
        self,
        name: str = None,
        role: str = None,
        union_id: str = None,
        user_id: str = None,
    ):
        # This parameter is required.
        self.name = name
        # This parameter is required.
        self.role = role
        # This parameter is required.
        self.union_id = union_id
        # This parameter is required.
        self.user_id = user_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.name is not None:
            result['name'] = self.name
        if self.role is not None:
            result['role'] = self.role
        if self.union_id is not None:
            result['unionId'] = self.union_id
        if self.user_id is not None:
            result['userId'] = self.user_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('name') is not None:
            self.name = m.get('name')
        if m.get('role') is not None:
            self.role = m.get('role')
        if m.get('unionId') is not None:
            self.union_id = m.get('unionId')
        if m.get('userId') is not None:
            self.user_id = m.get('userId')
        return self


class EduTeacherListResponseBodyResult(TeaModel):
    def __init__(
        self,
        has_more: bool = None,
        teacher_details: List[EduTeacherListResponseBodyResultTeacherDetails] = None,
    ):
        # This parameter is required.
        self.has_more = has_more
        self.teacher_details = teacher_details

    def validate(self):
        if self.teacher_details:
            for k in self.teacher_details:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.has_more is not None:
            result['hasMore'] = self.has_more
        result['teacherDetails'] = []
        if self.teacher_details is not None:
            for k in self.teacher_details:
                result['teacherDetails'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('hasMore') is not None:
            self.has_more = m.get('hasMore')
        self.teacher_details = []
        if m.get('teacherDetails') is not None:
            for k in m.get('teacherDetails'):
                temp_model = EduTeacherListResponseBodyResultTeacherDetails()
                self.teacher_details.append(temp_model.from_map(k))
        return self


class EduTeacherListResponseBody(TeaModel):
    def __init__(
        self,
        result: EduTeacherListResponseBodyResult = None,
    ):
        # This parameter is required.
        self.result = result

    def validate(self):
        if self.result:
            self.result.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.result is not None:
            result['result'] = self.result.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('result') is not None:
            temp_model = EduTeacherListResponseBodyResult()
            self.result = temp_model.from_map(m['result'])
        return self


class EduTeacherListResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: EduTeacherListResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = EduTeacherListResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class EnableCollegeContactSceneStruHeaders(TeaModel):
    def __init__(
        self,
        common_headers: Dict[str, str] = None,
        x_acs_dingtalk_access_token: str = None,
    ):
        self.common_headers = common_headers
        self.x_acs_dingtalk_access_token = x_acs_dingtalk_access_token

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.common_headers is not None:
            result['commonHeaders'] = self.common_headers
        if self.x_acs_dingtalk_access_token is not None:
            result['x-acs-dingtalk-access-token'] = self.x_acs_dingtalk_access_token
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('commonHeaders') is not None:
            self.common_headers = m.get('commonHeaders')
        if m.get('x-acs-dingtalk-access-token') is not None:
            self.x_acs_dingtalk_access_token = m.get('x-acs-dingtalk-access-token')
        return self


class EnableCollegeContactSceneStruRequest(TeaModel):
    def __init__(
        self,
        stru_id: int = None,
    ):
        # This parameter is required.
        self.stru_id = stru_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.stru_id is not None:
            result['struId'] = self.stru_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('struId') is not None:
            self.stru_id = m.get('struId')
        return self


class EnableCollegeContactSceneStruResponseBody(TeaModel):
    def __init__(
        self,
        success: bool = None,
    ):
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.success is not None:
            result['success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('success') is not None:
            self.success = m.get('success')
        return self


class EnableCollegeContactSceneStruResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: EnableCollegeContactSceneStruResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = EnableCollegeContactSceneStruResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class EndCourseHeaders(TeaModel):
    def __init__(
        self,
        common_headers: Dict[str, str] = None,
        x_acs_dingtalk_access_token: str = None,
    ):
        self.common_headers = common_headers
        self.x_acs_dingtalk_access_token = x_acs_dingtalk_access_token

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.common_headers is not None:
            result['commonHeaders'] = self.common_headers
        if self.x_acs_dingtalk_access_token is not None:
            result['x-acs-dingtalk-access-token'] = self.x_acs_dingtalk_access_token
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('commonHeaders') is not None:
            self.common_headers = m.get('commonHeaders')
        if m.get('x-acs-dingtalk-access-token') is not None:
            self.x_acs_dingtalk_access_token = m.get('x-acs-dingtalk-access-token')
        return self


class EndCourseRequestLivePlayInfoList(TeaModel):
    def __init__(
        self,
        live_input_url: str = None,
        live_output_flv_url: str = None,
        live_output_hls_url: str = None,
        live_type: int = None,
        replay_url: str = None,
    ):
        self.live_input_url = live_input_url
        self.live_output_flv_url = live_output_flv_url
        self.live_output_hls_url = live_output_hls_url
        self.live_type = live_type
        self.replay_url = replay_url

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.live_input_url is not None:
            result['liveInputUrl'] = self.live_input_url
        if self.live_output_flv_url is not None:
            result['liveOutputFlvUrl'] = self.live_output_flv_url
        if self.live_output_hls_url is not None:
            result['liveOutputHlsUrl'] = self.live_output_hls_url
        if self.live_type is not None:
            result['liveType'] = self.live_type
        if self.replay_url is not None:
            result['replayUrl'] = self.replay_url
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('liveInputUrl') is not None:
            self.live_input_url = m.get('liveInputUrl')
        if m.get('liveOutputFlvUrl') is not None:
            self.live_output_flv_url = m.get('liveOutputFlvUrl')
        if m.get('liveOutputHlsUrl') is not None:
            self.live_output_hls_url = m.get('liveOutputHlsUrl')
        if m.get('liveType') is not None:
            self.live_type = m.get('liveType')
        if m.get('replayUrl') is not None:
            self.replay_url = m.get('replayUrl')
        return self


class EndCourseRequest(TeaModel):
    def __init__(
        self,
        course_code: str = None,
        ext: str = None,
        isv_code: str = None,
        live_play_info_list: List[EndCourseRequestLivePlayInfoList] = None,
        op_user_id: str = None,
    ):
        self.course_code = course_code
        self.ext = ext
        self.isv_code = isv_code
        self.live_play_info_list = live_play_info_list
        self.op_user_id = op_user_id

    def validate(self):
        if self.live_play_info_list:
            for k in self.live_play_info_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.course_code is not None:
            result['courseCode'] = self.course_code
        if self.ext is not None:
            result['ext'] = self.ext
        if self.isv_code is not None:
            result['isvCode'] = self.isv_code
        result['livePlayInfoList'] = []
        if self.live_play_info_list is not None:
            for k in self.live_play_info_list:
                result['livePlayInfoList'].append(k.to_map() if k else None)
        if self.op_user_id is not None:
            result['opUserId'] = self.op_user_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('courseCode') is not None:
            self.course_code = m.get('courseCode')
        if m.get('ext') is not None:
            self.ext = m.get('ext')
        if m.get('isvCode') is not None:
            self.isv_code = m.get('isvCode')
        self.live_play_info_list = []
        if m.get('livePlayInfoList') is not None:
            for k in m.get('livePlayInfoList'):
                temp_model = EndCourseRequestLivePlayInfoList()
                self.live_play_info_list.append(temp_model.from_map(k))
        if m.get('opUserId') is not None:
            self.op_user_id = m.get('opUserId')
        return self


class EndCourseResponseBodyUniversityCourseCommonResponse(TeaModel):
    def __init__(
        self,
        course_code: str = None,
        success: bool = None,
    ):
        # This parameter is required.
        self.course_code = course_code
        # This parameter is required.
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.course_code is not None:
            result['courseCode'] = self.course_code
        if self.success is not None:
            result['success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('courseCode') is not None:
            self.course_code = m.get('courseCode')
        if m.get('success') is not None:
            self.success = m.get('success')
        return self


class EndCourseResponseBody(TeaModel):
    def __init__(
        self,
        university_course_common_response: EndCourseResponseBodyUniversityCourseCommonResponse = None,
    ):
        # This parameter is required.
        self.university_course_common_response = university_course_common_response

    def validate(self):
        if self.university_course_common_response:
            self.university_course_common_response.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.university_course_common_response is not None:
            result['universityCourseCommonResponse'] = self.university_course_common_response.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('universityCourseCommonResponse') is not None:
            temp_model = EndCourseResponseBodyUniversityCourseCommonResponse()
            self.university_course_common_response = temp_model.from_map(m['universityCourseCommonResponse'])
        return self


class EndCourseResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: EndCourseResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = EndCourseResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetBindChildInfoHeaders(TeaModel):
    def __init__(
        self,
        common_headers: Dict[str, str] = None,
        x_acs_dingtalk_access_token: str = None,
    ):
        self.common_headers = common_headers
        self.x_acs_dingtalk_access_token = x_acs_dingtalk_access_token

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.common_headers is not None:
            result['commonHeaders'] = self.common_headers
        if self.x_acs_dingtalk_access_token is not None:
            result['x-acs-dingtalk-access-token'] = self.x_acs_dingtalk_access_token
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('commonHeaders') is not None:
            self.common_headers = m.get('commonHeaders')
        if m.get('x-acs-dingtalk-access-token') is not None:
            self.x_acs_dingtalk_access_token = m.get('x-acs-dingtalk-access-token')
        return self


class GetBindChildInfoRequest(TeaModel):
    def __init__(
        self,
        school_corp_id: str = None,
        student_user_id: str = None,
        union_id: str = None,
    ):
        # This parameter is required.
        self.school_corp_id = school_corp_id
        # This parameter is required.
        self.student_user_id = student_user_id
        # This parameter is required.
        self.union_id = union_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.school_corp_id is not None:
            result['schoolCorpId'] = self.school_corp_id
        if self.student_user_id is not None:
            result['studentUserId'] = self.student_user_id
        if self.union_id is not None:
            result['unionId'] = self.union_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('schoolCorpId') is not None:
            self.school_corp_id = m.get('schoolCorpId')
        if m.get('studentUserId') is not None:
            self.student_user_id = m.get('studentUserId')
        if m.get('unionId') is not None:
            self.union_id = m.get('unionId')
        return self


class GetBindChildInfoResponseBody(TeaModel):
    def __init__(
        self,
        child_user_id: str = None,
        current_user_id: str = None,
        family_corp_id: str = None,
    ):
        self.child_user_id = child_user_id
        self.current_user_id = current_user_id
        self.family_corp_id = family_corp_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.child_user_id is not None:
            result['childUserId'] = self.child_user_id
        if self.current_user_id is not None:
            result['currentUserId'] = self.current_user_id
        if self.family_corp_id is not None:
            result['familyCorpId'] = self.family_corp_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('childUserId') is not None:
            self.child_user_id = m.get('childUserId')
        if m.get('currentUserId') is not None:
            self.current_user_id = m.get('currentUserId')
        if m.get('familyCorpId') is not None:
            self.family_corp_id = m.get('familyCorpId')
        return self


class GetBindChildInfoResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: GetBindChildInfoResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetBindChildInfoResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetChildrenHeaders(TeaModel):
    def __init__(
        self,
        common_headers: Dict[str, str] = None,
        x_acs_dingtalk_access_token: str = None,
    ):
        self.common_headers = common_headers
        self.x_acs_dingtalk_access_token = x_acs_dingtalk_access_token

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.common_headers is not None:
            result['commonHeaders'] = self.common_headers
        if self.x_acs_dingtalk_access_token is not None:
            result['x-acs-dingtalk-access-token'] = self.x_acs_dingtalk_access_token
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('commonHeaders') is not None:
            self.common_headers = m.get('commonHeaders')
        if m.get('x-acs-dingtalk-access-token') is not None:
            self.x_acs_dingtalk_access_token = m.get('x-acs-dingtalk-access-token')
        return self


class GetChildrenResponseBodyResultBindStudents(TeaModel):
    def __init__(
        self,
        grade_level: int = None,
        identity_id: str = None,
        period_code: str = None,
    ):
        self.grade_level = grade_level
        self.identity_id = identity_id
        self.period_code = period_code

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.grade_level is not None:
            result['gradeLevel'] = self.grade_level
        if self.identity_id is not None:
            result['identityId'] = self.identity_id
        if self.period_code is not None:
            result['periodCode'] = self.period_code
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('gradeLevel') is not None:
            self.grade_level = m.get('gradeLevel')
        if m.get('identityId') is not None:
            self.identity_id = m.get('identityId')
        if m.get('periodCode') is not None:
            self.period_code = m.get('periodCode')
        return self


class GetChildrenResponseBodyResult(TeaModel):
    def __init__(
        self,
        bind_students: List[GetChildrenResponseBodyResultBindStudents] = None,
        city: str = None,
        district: str = None,
        grade_level: int = None,
        name: str = None,
        period_code: str = None,
        province: str = None,
        region_id: str = None,
    ):
        self.bind_students = bind_students
        self.city = city
        self.district = district
        self.grade_level = grade_level
        # This parameter is required.
        self.name = name
        self.period_code = period_code
        self.province = province
        self.region_id = region_id

    def validate(self):
        if self.bind_students:
            for k in self.bind_students:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['bindStudents'] = []
        if self.bind_students is not None:
            for k in self.bind_students:
                result['bindStudents'].append(k.to_map() if k else None)
        if self.city is not None:
            result['city'] = self.city
        if self.district is not None:
            result['district'] = self.district
        if self.grade_level is not None:
            result['gradeLevel'] = self.grade_level
        if self.name is not None:
            result['name'] = self.name
        if self.period_code is not None:
            result['periodCode'] = self.period_code
        if self.province is not None:
            result['province'] = self.province
        if self.region_id is not None:
            result['regionId'] = self.region_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.bind_students = []
        if m.get('bindStudents') is not None:
            for k in m.get('bindStudents'):
                temp_model = GetChildrenResponseBodyResultBindStudents()
                self.bind_students.append(temp_model.from_map(k))
        if m.get('city') is not None:
            self.city = m.get('city')
        if m.get('district') is not None:
            self.district = m.get('district')
        if m.get('gradeLevel') is not None:
            self.grade_level = m.get('gradeLevel')
        if m.get('name') is not None:
            self.name = m.get('name')
        if m.get('periodCode') is not None:
            self.period_code = m.get('periodCode')
        if m.get('province') is not None:
            self.province = m.get('province')
        if m.get('regionId') is not None:
            self.region_id = m.get('regionId')
        return self


class GetChildrenResponseBody(TeaModel):
    def __init__(
        self,
        result: List[GetChildrenResponseBodyResult] = None,
        success: bool = None,
    ):
        self.result = result
        # This parameter is required.
        self.success = success

    def validate(self):
        if self.result:
            for k in self.result:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['result'] = []
        if self.result is not None:
            for k in self.result:
                result['result'].append(k.to_map() if k else None)
        if self.success is not None:
            result['success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.result = []
        if m.get('result') is not None:
            for k in m.get('result'):
                temp_model = GetChildrenResponseBodyResult()
                self.result.append(temp_model.from_map(k))
        if m.get('success') is not None:
            self.success = m.get('success')
        return self


class GetChildrenResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: GetChildrenResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetChildrenResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetCollegeAlumniDeptsHeaders(TeaModel):
    def __init__(
        self,
        common_headers: Dict[str, str] = None,
        x_acs_dingtalk_access_token: str = None,
    ):
        self.common_headers = common_headers
        self.x_acs_dingtalk_access_token = x_acs_dingtalk_access_token

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.common_headers is not None:
            result['commonHeaders'] = self.common_headers
        if self.x_acs_dingtalk_access_token is not None:
            result['x-acs-dingtalk-access-token'] = self.x_acs_dingtalk_access_token
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('commonHeaders') is not None:
            self.common_headers = m.get('commonHeaders')
        if m.get('x-acs-dingtalk-access-token') is not None:
            self.x_acs_dingtalk_access_token = m.get('x-acs-dingtalk-access-token')
        return self


class GetCollegeAlumniDeptsRequest(TeaModel):
    def __init__(
        self,
        dept_id: int = None,
        operator: str = None,
    ):
        # This parameter is required.
        self.dept_id = dept_id
        # This parameter is required.
        self.operator = operator

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dept_id is not None:
            result['deptId'] = self.dept_id
        if self.operator is not None:
            result['operator'] = self.operator
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('deptId') is not None:
            self.dept_id = m.get('deptId')
        if m.get('operator') is not None:
            self.operator = m.get('operator')
        return self


class GetCollegeAlumniDeptsResponseBodyResult(TeaModel):
    def __init__(
        self,
        corp_id: str = None,
        dept_id: int = None,
        dept_type: str = None,
        has_sub_dept: bool = None,
        name: str = None,
        super_id: int = None,
    ):
        self.corp_id = corp_id
        self.dept_id = dept_id
        self.dept_type = dept_type
        self.has_sub_dept = has_sub_dept
        self.name = name
        self.super_id = super_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.corp_id is not None:
            result['corpId'] = self.corp_id
        if self.dept_id is not None:
            result['deptId'] = self.dept_id
        if self.dept_type is not None:
            result['deptType'] = self.dept_type
        if self.has_sub_dept is not None:
            result['hasSubDept'] = self.has_sub_dept
        if self.name is not None:
            result['name'] = self.name
        if self.super_id is not None:
            result['superId'] = self.super_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('corpId') is not None:
            self.corp_id = m.get('corpId')
        if m.get('deptId') is not None:
            self.dept_id = m.get('deptId')
        if m.get('deptType') is not None:
            self.dept_type = m.get('deptType')
        if m.get('hasSubDept') is not None:
            self.has_sub_dept = m.get('hasSubDept')
        if m.get('name') is not None:
            self.name = m.get('name')
        if m.get('superId') is not None:
            self.super_id = m.get('superId')
        return self


class GetCollegeAlumniDeptsResponseBody(TeaModel):
    def __init__(
        self,
        result: List[GetCollegeAlumniDeptsResponseBodyResult] = None,
        success: bool = None,
    ):
        self.result = result
        self.success = success

    def validate(self):
        if self.result:
            for k in self.result:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['result'] = []
        if self.result is not None:
            for k in self.result:
                result['result'].append(k.to_map() if k else None)
        if self.success is not None:
            result['success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.result = []
        if m.get('result') is not None:
            for k in m.get('result'):
                temp_model = GetCollegeAlumniDeptsResponseBodyResult()
                self.result.append(temp_model.from_map(k))
        if m.get('success') is not None:
            self.success = m.get('success')
        return self


class GetCollegeAlumniDeptsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: GetCollegeAlumniDeptsResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetCollegeAlumniDeptsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetCollegeAlumniUserInfoHeaders(TeaModel):
    def __init__(
        self,
        common_headers: Dict[str, str] = None,
        x_acs_dingtalk_access_token: str = None,
    ):
        self.common_headers = common_headers
        self.x_acs_dingtalk_access_token = x_acs_dingtalk_access_token

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.common_headers is not None:
            result['commonHeaders'] = self.common_headers
        if self.x_acs_dingtalk_access_token is not None:
            result['x-acs-dingtalk-access-token'] = self.x_acs_dingtalk_access_token
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('commonHeaders') is not None:
            self.common_headers = m.get('commonHeaders')
        if m.get('x-acs-dingtalk-access-token') is not None:
            self.x_acs_dingtalk_access_token = m.get('x-acs-dingtalk-access-token')
        return self


class GetCollegeAlumniUserInfoRequest(TeaModel):
    def __init__(
        self,
        operator: str = None,
        user_id: str = None,
    ):
        # This parameter is required.
        self.operator = operator
        # This parameter is required.
        self.user_id = user_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.operator is not None:
            result['operator'] = self.operator
        if self.user_id is not None:
            result['userId'] = self.user_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('operator') is not None:
            self.operator = m.get('operator')
        if m.get('userId') is not None:
            self.user_id = m.get('userId')
        return self


class GetCollegeAlumniUserInfoResponseBodyResultDepts(TeaModel):
    def __init__(
        self,
        corp_id: str = None,
        dept_id: int = None,
        has_sub_dept: bool = None,
        is_industry_dept: bool = None,
        name: str = None,
    ):
        self.corp_id = corp_id
        self.dept_id = dept_id
        self.has_sub_dept = has_sub_dept
        self.is_industry_dept = is_industry_dept
        self.name = name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.corp_id is not None:
            result['corpId'] = self.corp_id
        if self.dept_id is not None:
            result['deptId'] = self.dept_id
        if self.has_sub_dept is not None:
            result['hasSubDept'] = self.has_sub_dept
        if self.is_industry_dept is not None:
            result['isIndustryDept'] = self.is_industry_dept
        if self.name is not None:
            result['name'] = self.name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('corpId') is not None:
            self.corp_id = m.get('corpId')
        if m.get('deptId') is not None:
            self.dept_id = m.get('deptId')
        if m.get('hasSubDept') is not None:
            self.has_sub_dept = m.get('hasSubDept')
        if m.get('isIndustryDept') is not None:
            self.is_industry_dept = m.get('isIndustryDept')
        if m.get('name') is not None:
            self.name = m.get('name')
        return self


class GetCollegeAlumniUserInfoResponseBodyResult(TeaModel):
    def __init__(
        self,
        address: str = None,
        avatar: str = None,
        corp_id: str = None,
        depts: List[GetCollegeAlumniUserInfoResponseBodyResultDepts] = None,
        email: str = None,
        intake: str = None,
        invite_id: int = None,
        mobile: str = None,
        name: str = None,
        outtake: str = None,
        student_number: str = None,
        user_id: str = None,
    ):
        self.address = address
        self.avatar = avatar
        self.corp_id = corp_id
        self.depts = depts
        self.email = email
        self.intake = intake
        self.invite_id = invite_id
        self.mobile = mobile
        self.name = name
        self.outtake = outtake
        self.student_number = student_number
        self.user_id = user_id

    def validate(self):
        if self.depts:
            for k in self.depts:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.address is not None:
            result['address'] = self.address
        if self.avatar is not None:
            result['avatar'] = self.avatar
        if self.corp_id is not None:
            result['corpId'] = self.corp_id
        result['depts'] = []
        if self.depts is not None:
            for k in self.depts:
                result['depts'].append(k.to_map() if k else None)
        if self.email is not None:
            result['email'] = self.email
        if self.intake is not None:
            result['intake'] = self.intake
        if self.invite_id is not None:
            result['inviteId'] = self.invite_id
        if self.mobile is not None:
            result['mobile'] = self.mobile
        if self.name is not None:
            result['name'] = self.name
        if self.outtake is not None:
            result['outtake'] = self.outtake
        if self.student_number is not None:
            result['studentNumber'] = self.student_number
        if self.user_id is not None:
            result['userId'] = self.user_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('address') is not None:
            self.address = m.get('address')
        if m.get('avatar') is not None:
            self.avatar = m.get('avatar')
        if m.get('corpId') is not None:
            self.corp_id = m.get('corpId')
        self.depts = []
        if m.get('depts') is not None:
            for k in m.get('depts'):
                temp_model = GetCollegeAlumniUserInfoResponseBodyResultDepts()
                self.depts.append(temp_model.from_map(k))
        if m.get('email') is not None:
            self.email = m.get('email')
        if m.get('intake') is not None:
            self.intake = m.get('intake')
        if m.get('inviteId') is not None:
            self.invite_id = m.get('inviteId')
        if m.get('mobile') is not None:
            self.mobile = m.get('mobile')
        if m.get('name') is not None:
            self.name = m.get('name')
        if m.get('outtake') is not None:
            self.outtake = m.get('outtake')
        if m.get('studentNumber') is not None:
            self.student_number = m.get('studentNumber')
        if m.get('userId') is not None:
            self.user_id = m.get('userId')
        return self


class GetCollegeAlumniUserInfoResponseBody(TeaModel):
    def __init__(
        self,
        result: GetCollegeAlumniUserInfoResponseBodyResult = None,
        success: bool = None,
    ):
        self.result = result
        self.success = success

    def validate(self):
        if self.result:
            self.result.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.result is not None:
            result['result'] = self.result.to_map()
        if self.success is not None:
            result['success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('result') is not None:
            temp_model = GetCollegeAlumniUserInfoResponseBodyResult()
            self.result = temp_model.from_map(m['result'])
        if m.get('success') is not None:
            self.success = m.get('success')
        return self


class GetCollegeAlumniUserInfoResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: GetCollegeAlumniUserInfoResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetCollegeAlumniUserInfoResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetCollegeContactDeptDetailHeaders(TeaModel):
    def __init__(
        self,
        common_headers: Dict[str, str] = None,
        x_acs_dingtalk_access_token: str = None,
    ):
        self.common_headers = common_headers
        self.x_acs_dingtalk_access_token = x_acs_dingtalk_access_token

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.common_headers is not None:
            result['commonHeaders'] = self.common_headers
        if self.x_acs_dingtalk_access_token is not None:
            result['x-acs-dingtalk-access-token'] = self.x_acs_dingtalk_access_token
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('commonHeaders') is not None:
            self.common_headers = m.get('commonHeaders')
        if m.get('x-acs-dingtalk-access-token') is not None:
            self.x_acs_dingtalk_access_token = m.get('x-acs-dingtalk-access-token')
        return self


class GetCollegeContactDeptDetailRequest(TeaModel):
    def __init__(
        self,
        dept_id: int = None,
        language: str = None,
    ):
        # This parameter is required.
        self.dept_id = dept_id
        self.language = language

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dept_id is not None:
            result['deptId'] = self.dept_id
        if self.language is not None:
            result['language'] = self.language
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('deptId') is not None:
            self.dept_id = m.get('deptId')
        if m.get('language') is not None:
            self.language = m.get('language')
        return self


class GetCollegeContactDeptDetailResponseBodyResultHideSceneConfig(TeaModel):
    def __init__(
        self,
        active: bool = None,
        chatbox_subtitle: bool = None,
        node_list: bool = None,
        profile: bool = None,
        search: bool = None,
    ):
        self.active = active
        self.chatbox_subtitle = chatbox_subtitle
        self.node_list = node_list
        self.profile = profile
        self.search = search

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.active is not None:
            result['active'] = self.active
        if self.chatbox_subtitle is not None:
            result['chatboxSubtitle'] = self.chatbox_subtitle
        if self.node_list is not None:
            result['nodeList'] = self.node_list
        if self.profile is not None:
            result['profile'] = self.profile
        if self.search is not None:
            result['search'] = self.search
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('active') is not None:
            self.active = m.get('active')
        if m.get('chatboxSubtitle') is not None:
            self.chatbox_subtitle = m.get('chatboxSubtitle')
        if m.get('nodeList') is not None:
            self.node_list = m.get('nodeList')
        if m.get('profile') is not None:
            self.profile = m.get('profile')
        if m.get('search') is not None:
            self.search = m.get('search')
        return self


class GetCollegeContactDeptDetailResponseBodyResultOuterSceneConfig(TeaModel):
    def __init__(
        self,
        active: bool = None,
        chatbox_subtitle: bool = None,
        node_list: bool = None,
        profile: bool = None,
        search: bool = None,
    ):
        self.active = active
        self.chatbox_subtitle = chatbox_subtitle
        self.node_list = node_list
        self.profile = profile
        self.search = search

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.active is not None:
            result['active'] = self.active
        if self.chatbox_subtitle is not None:
            result['chatboxSubtitle'] = self.chatbox_subtitle
        if self.node_list is not None:
            result['nodeList'] = self.node_list
        if self.profile is not None:
            result['profile'] = self.profile
        if self.search is not None:
            result['search'] = self.search
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('active') is not None:
            self.active = m.get('active')
        if m.get('chatboxSubtitle') is not None:
            self.chatbox_subtitle = m.get('chatboxSubtitle')
        if m.get('nodeList') is not None:
            self.node_list = m.get('nodeList')
        if m.get('profile') is not None:
            self.profile = m.get('profile')
        if m.get('search') is not None:
            self.search = m.get('search')
        return self


class GetCollegeContactDeptDetailResponseBodyResult(TeaModel):
    def __init__(
        self,
        auto_add_user: bool = None,
        auto_approve_apply: bool = None,
        brief: str = None,
        code: str = None,
        create_dept_group: bool = None,
        dept_code: str = None,
        dept_group_chat_id: str = None,
        dept_id: int = None,
        dept_manager_userid_list: List[str] = None,
        dept_permits: List[int] = None,
        dept_type: str = None,
        emp_apply_join_dept: bool = None,
        extension: str = None,
        from_union_org: bool = None,
        group_contain_sub_dept: bool = None,
        hide_dept: bool = None,
        hide_scene_config: GetCollegeContactDeptDetailResponseBodyResultHideSceneConfig = None,
        name: str = None,
        order: int = None,
        org_dept_owner: str = None,
        outer_dept: bool = None,
        outer_permit_depts: List[int] = None,
        outer_permit_users: List[str] = None,
        outer_scene_config: GetCollegeContactDeptDetailResponseBodyResultOuterSceneConfig = None,
        parent_id: int = None,
        source_identifier: str = None,
        stru_id: int = None,
        tags: str = None,
        telephone: str = None,
        user_permits: List[str] = None,
    ):
        self.auto_add_user = auto_add_user
        self.auto_approve_apply = auto_approve_apply
        self.brief = brief
        self.code = code
        self.create_dept_group = create_dept_group
        self.dept_code = dept_code
        self.dept_group_chat_id = dept_group_chat_id
        self.dept_id = dept_id
        self.dept_manager_userid_list = dept_manager_userid_list
        self.dept_permits = dept_permits
        self.dept_type = dept_type
        self.emp_apply_join_dept = emp_apply_join_dept
        self.extension = extension
        self.from_union_org = from_union_org
        self.group_contain_sub_dept = group_contain_sub_dept
        self.hide_dept = hide_dept
        self.hide_scene_config = hide_scene_config
        self.name = name
        self.order = order
        self.org_dept_owner = org_dept_owner
        self.outer_dept = outer_dept
        self.outer_permit_depts = outer_permit_depts
        self.outer_permit_users = outer_permit_users
        self.outer_scene_config = outer_scene_config
        self.parent_id = parent_id
        self.source_identifier = source_identifier
        self.stru_id = stru_id
        self.tags = tags
        self.telephone = telephone
        self.user_permits = user_permits

    def validate(self):
        if self.hide_scene_config:
            self.hide_scene_config.validate()
        if self.outer_scene_config:
            self.outer_scene_config.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.auto_add_user is not None:
            result['autoAddUser'] = self.auto_add_user
        if self.auto_approve_apply is not None:
            result['autoApproveApply'] = self.auto_approve_apply
        if self.brief is not None:
            result['brief'] = self.brief
        if self.code is not None:
            result['code'] = self.code
        if self.create_dept_group is not None:
            result['createDeptGroup'] = self.create_dept_group
        if self.dept_code is not None:
            result['deptCode'] = self.dept_code
        if self.dept_group_chat_id is not None:
            result['deptGroupChatId'] = self.dept_group_chat_id
        if self.dept_id is not None:
            result['deptId'] = self.dept_id
        if self.dept_manager_userid_list is not None:
            result['deptManagerUseridList'] = self.dept_manager_userid_list
        if self.dept_permits is not None:
            result['deptPermits'] = self.dept_permits
        if self.dept_type is not None:
            result['deptType'] = self.dept_type
        if self.emp_apply_join_dept is not None:
            result['empApplyJoinDept'] = self.emp_apply_join_dept
        if self.extension is not None:
            result['extension'] = self.extension
        if self.from_union_org is not None:
            result['fromUnionOrg'] = self.from_union_org
        if self.group_contain_sub_dept is not None:
            result['groupContainSubDept'] = self.group_contain_sub_dept
        if self.hide_dept is not None:
            result['hideDept'] = self.hide_dept
        if self.hide_scene_config is not None:
            result['hideSceneConfig'] = self.hide_scene_config.to_map()
        if self.name is not None:
            result['name'] = self.name
        if self.order is not None:
            result['order'] = self.order
        if self.org_dept_owner is not None:
            result['orgDeptOwner'] = self.org_dept_owner
        if self.outer_dept is not None:
            result['outerDept'] = self.outer_dept
        if self.outer_permit_depts is not None:
            result['outerPermitDepts'] = self.outer_permit_depts
        if self.outer_permit_users is not None:
            result['outerPermitUsers'] = self.outer_permit_users
        if self.outer_scene_config is not None:
            result['outerSceneConfig'] = self.outer_scene_config.to_map()
        if self.parent_id is not None:
            result['parentId'] = self.parent_id
        if self.source_identifier is not None:
            result['sourceIdentifier'] = self.source_identifier
        if self.stru_id is not None:
            result['struId'] = self.stru_id
        if self.tags is not None:
            result['tags'] = self.tags
        if self.telephone is not None:
            result['telephone'] = self.telephone
        if self.user_permits is not None:
            result['userPermits'] = self.user_permits
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('autoAddUser') is not None:
            self.auto_add_user = m.get('autoAddUser')
        if m.get('autoApproveApply') is not None:
            self.auto_approve_apply = m.get('autoApproveApply')
        if m.get('brief') is not None:
            self.brief = m.get('brief')
        if m.get('code') is not None:
            self.code = m.get('code')
        if m.get('createDeptGroup') is not None:
            self.create_dept_group = m.get('createDeptGroup')
        if m.get('deptCode') is not None:
            self.dept_code = m.get('deptCode')
        if m.get('deptGroupChatId') is not None:
            self.dept_group_chat_id = m.get('deptGroupChatId')
        if m.get('deptId') is not None:
            self.dept_id = m.get('deptId')
        if m.get('deptManagerUseridList') is not None:
            self.dept_manager_userid_list = m.get('deptManagerUseridList')
        if m.get('deptPermits') is not None:
            self.dept_permits = m.get('deptPermits')
        if m.get('deptType') is not None:
            self.dept_type = m.get('deptType')
        if m.get('empApplyJoinDept') is not None:
            self.emp_apply_join_dept = m.get('empApplyJoinDept')
        if m.get('extension') is not None:
            self.extension = m.get('extension')
        if m.get('fromUnionOrg') is not None:
            self.from_union_org = m.get('fromUnionOrg')
        if m.get('groupContainSubDept') is not None:
            self.group_contain_sub_dept = m.get('groupContainSubDept')
        if m.get('hideDept') is not None:
            self.hide_dept = m.get('hideDept')
        if m.get('hideSceneConfig') is not None:
            temp_model = GetCollegeContactDeptDetailResponseBodyResultHideSceneConfig()
            self.hide_scene_config = temp_model.from_map(m['hideSceneConfig'])
        if m.get('name') is not None:
            self.name = m.get('name')
        if m.get('order') is not None:
            self.order = m.get('order')
        if m.get('orgDeptOwner') is not None:
            self.org_dept_owner = m.get('orgDeptOwner')
        if m.get('outerDept') is not None:
            self.outer_dept = m.get('outerDept')
        if m.get('outerPermitDepts') is not None:
            self.outer_permit_depts = m.get('outerPermitDepts')
        if m.get('outerPermitUsers') is not None:
            self.outer_permit_users = m.get('outerPermitUsers')
        if m.get('outerSceneConfig') is not None:
            temp_model = GetCollegeContactDeptDetailResponseBodyResultOuterSceneConfig()
            self.outer_scene_config = temp_model.from_map(m['outerSceneConfig'])
        if m.get('parentId') is not None:
            self.parent_id = m.get('parentId')
        if m.get('sourceIdentifier') is not None:
            self.source_identifier = m.get('sourceIdentifier')
        if m.get('struId') is not None:
            self.stru_id = m.get('struId')
        if m.get('tags') is not None:
            self.tags = m.get('tags')
        if m.get('telephone') is not None:
            self.telephone = m.get('telephone')
        if m.get('userPermits') is not None:
            self.user_permits = m.get('userPermits')
        return self


class GetCollegeContactDeptDetailResponseBody(TeaModel):
    def __init__(
        self,
        result: GetCollegeContactDeptDetailResponseBodyResult = None,
        success: bool = None,
    ):
        self.result = result
        self.success = success

    def validate(self):
        if self.result:
            self.result.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.result is not None:
            result['result'] = self.result.to_map()
        if self.success is not None:
            result['success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('result') is not None:
            temp_model = GetCollegeContactDeptDetailResponseBodyResult()
            self.result = temp_model.from_map(m['result'])
        if m.get('success') is not None:
            self.success = m.get('success')
        return self


class GetCollegeContactDeptDetailResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: GetCollegeContactDeptDetailResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetCollegeContactDeptDetailResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetCollegeContactStandardStruDeptDetailHeaders(TeaModel):
    def __init__(
        self,
        common_headers: Dict[str, str] = None,
        x_acs_dingtalk_access_token: str = None,
    ):
        self.common_headers = common_headers
        self.x_acs_dingtalk_access_token = x_acs_dingtalk_access_token

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.common_headers is not None:
            result['commonHeaders'] = self.common_headers
        if self.x_acs_dingtalk_access_token is not None:
            result['x-acs-dingtalk-access-token'] = self.x_acs_dingtalk_access_token
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('commonHeaders') is not None:
            self.common_headers = m.get('commonHeaders')
        if m.get('x-acs-dingtalk-access-token') is not None:
            self.x_acs_dingtalk_access_token = m.get('x-acs-dingtalk-access-token')
        return self


class GetCollegeContactStandardStruDeptDetailRequest(TeaModel):
    def __init__(
        self,
        language: str = None,
    ):
        self.language = language

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.language is not None:
            result['language'] = self.language
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('language') is not None:
            self.language = m.get('language')
        return self


class GetCollegeContactStandardStruDeptDetailResponseBodyResult(TeaModel):
    def __init__(
        self,
        stru_id: int = None,
        student_dept_id: int = None,
        teacher_dept_id: int = None,
    ):
        self.stru_id = stru_id
        self.student_dept_id = student_dept_id
        self.teacher_dept_id = teacher_dept_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.stru_id is not None:
            result['struId'] = self.stru_id
        if self.student_dept_id is not None:
            result['studentDeptId'] = self.student_dept_id
        if self.teacher_dept_id is not None:
            result['teacherDeptId'] = self.teacher_dept_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('struId') is not None:
            self.stru_id = m.get('struId')
        if m.get('studentDeptId') is not None:
            self.student_dept_id = m.get('studentDeptId')
        if m.get('teacherDeptId') is not None:
            self.teacher_dept_id = m.get('teacherDeptId')
        return self


class GetCollegeContactStandardStruDeptDetailResponseBody(TeaModel):
    def __init__(
        self,
        result: GetCollegeContactStandardStruDeptDetailResponseBodyResult = None,
        success: bool = None,
    ):
        self.result = result
        self.success = success

    def validate(self):
        if self.result:
            self.result.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.result is not None:
            result['result'] = self.result.to_map()
        if self.success is not None:
            result['success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('result') is not None:
            temp_model = GetCollegeContactStandardStruDeptDetailResponseBodyResult()
            self.result = temp_model.from_map(m['result'])
        if m.get('success') is not None:
            self.success = m.get('success')
        return self


class GetCollegeContactStandardStruDeptDetailResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: GetCollegeContactStandardStruDeptDetailResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetCollegeContactStandardStruDeptDetailResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetDefaultChildHeaders(TeaModel):
    def __init__(
        self,
        common_headers: Dict[str, str] = None,
        x_acs_dingtalk_access_token: str = None,
    ):
        self.common_headers = common_headers
        self.x_acs_dingtalk_access_token = x_acs_dingtalk_access_token

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.common_headers is not None:
            result['commonHeaders'] = self.common_headers
        if self.x_acs_dingtalk_access_token is not None:
            result['x-acs-dingtalk-access-token'] = self.x_acs_dingtalk_access_token
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('commonHeaders') is not None:
            self.common_headers = m.get('commonHeaders')
        if m.get('x-acs-dingtalk-access-token') is not None:
            self.x_acs_dingtalk_access_token = m.get('x-acs-dingtalk-access-token')
        return self


class GetDefaultChildResponseBodyBindStudents(TeaModel):
    def __init__(
        self,
        class_id: int = None,
        corp_id: str = None,
        period: str = None,
        staff_id: str = None,
    ):
        self.class_id = class_id
        # This parameter is required.
        self.corp_id = corp_id
        self.period = period
        # This parameter is required.
        self.staff_id = staff_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.class_id is not None:
            result['classId'] = self.class_id
        if self.corp_id is not None:
            result['corpId'] = self.corp_id
        if self.period is not None:
            result['period'] = self.period
        if self.staff_id is not None:
            result['staffId'] = self.staff_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('classId') is not None:
            self.class_id = m.get('classId')
        if m.get('corpId') is not None:
            self.corp_id = m.get('corpId')
        if m.get('period') is not None:
            self.period = m.get('period')
        if m.get('staffId') is not None:
            self.staff_id = m.get('staffId')
        return self


class GetDefaultChildResponseBody(TeaModel):
    def __init__(
        self,
        avatar: str = None,
        bind_students: List[GetDefaultChildResponseBodyBindStudents] = None,
        grade: int = None,
        name: str = None,
        nick: str = None,
        period: str = None,
        union_id: str = None,
    ):
        self.avatar = avatar
        self.bind_students = bind_students
        self.grade = grade
        # This parameter is required.
        self.name = name
        self.nick = nick
        self.period = period
        # This parameter is required.
        self.union_id = union_id

    def validate(self):
        if self.bind_students:
            for k in self.bind_students:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.avatar is not None:
            result['avatar'] = self.avatar
        result['bindStudents'] = []
        if self.bind_students is not None:
            for k in self.bind_students:
                result['bindStudents'].append(k.to_map() if k else None)
        if self.grade is not None:
            result['grade'] = self.grade
        if self.name is not None:
            result['name'] = self.name
        if self.nick is not None:
            result['nick'] = self.nick
        if self.period is not None:
            result['period'] = self.period
        if self.union_id is not None:
            result['unionId'] = self.union_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('avatar') is not None:
            self.avatar = m.get('avatar')
        self.bind_students = []
        if m.get('bindStudents') is not None:
            for k in m.get('bindStudents'):
                temp_model = GetDefaultChildResponseBodyBindStudents()
                self.bind_students.append(temp_model.from_map(k))
        if m.get('grade') is not None:
            self.grade = m.get('grade')
        if m.get('name') is not None:
            self.name = m.get('name')
        if m.get('nick') is not None:
            self.nick = m.get('nick')
        if m.get('period') is not None:
            self.period = m.get('period')
        if m.get('unionId') is not None:
            self.union_id = m.get('unionId')
        return self


class GetDefaultChildResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: GetDefaultChildResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetDefaultChildResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetEduUserIdentityHeaders(TeaModel):
    def __init__(
        self,
        common_headers: Dict[str, str] = None,
        x_acs_dingtalk_access_token: str = None,
    ):
        self.common_headers = common_headers
        self.x_acs_dingtalk_access_token = x_acs_dingtalk_access_token

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.common_headers is not None:
            result['commonHeaders'] = self.common_headers
        if self.x_acs_dingtalk_access_token is not None:
            result['x-acs-dingtalk-access-token'] = self.x_acs_dingtalk_access_token
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('commonHeaders') is not None:
            self.common_headers = m.get('commonHeaders')
        if m.get('x-acs-dingtalk-access-token') is not None:
            self.x_acs_dingtalk_access_token = m.get('x-acs-dingtalk-access-token')
        return self


class GetEduUserIdentityRequest(TeaModel):
    def __init__(
        self,
        union_id: str = None,
    ):
        # This parameter is required.
        self.union_id = union_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.union_id is not None:
            result['unionId'] = self.union_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('unionId') is not None:
            self.union_id = m.get('unionId')
        return self


class GetEduUserIdentityResponseBodyData(TeaModel):
    def __init__(
        self,
        match_guardian_rule: bool = None,
        match_teacher_rule: bool = None,
        union_id: str = None,
    ):
        self.match_guardian_rule = match_guardian_rule
        self.match_teacher_rule = match_teacher_rule
        self.union_id = union_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.match_guardian_rule is not None:
            result['matchGuardianRule'] = self.match_guardian_rule
        if self.match_teacher_rule is not None:
            result['matchTeacherRule'] = self.match_teacher_rule
        if self.union_id is not None:
            result['unionId'] = self.union_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('matchGuardianRule') is not None:
            self.match_guardian_rule = m.get('matchGuardianRule')
        if m.get('matchTeacherRule') is not None:
            self.match_teacher_rule = m.get('matchTeacherRule')
        if m.get('unionId') is not None:
            self.union_id = m.get('unionId')
        return self


class GetEduUserIdentityResponseBody(TeaModel):
    def __init__(
        self,
        data: GetEduUserIdentityResponseBodyData = None,
        success: bool = None,
    ):
        self.data = data
        # This parameter is required.
        self.success = success

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data is not None:
            result['data'] = self.data.to_map()
        if self.success is not None:
            result['success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('data') is not None:
            temp_model = GetEduUserIdentityResponseBodyData()
            self.data = temp_model.from_map(m['data'])
        if m.get('success') is not None:
            self.success = m.get('success')
        return self


class GetEduUserIdentityResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: GetEduUserIdentityResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetEduUserIdentityResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetFileDownloadInfoHeaders(TeaModel):
    def __init__(
        self,
        common_headers: Dict[str, str] = None,
        x_acs_dingtalk_access_token: str = None,
    ):
        self.common_headers = common_headers
        self.x_acs_dingtalk_access_token = x_acs_dingtalk_access_token

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.common_headers is not None:
            result['commonHeaders'] = self.common_headers
        if self.x_acs_dingtalk_access_token is not None:
            result['x-acs-dingtalk-access-token'] = self.x_acs_dingtalk_access_token
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('commonHeaders') is not None:
            self.common_headers = m.get('commonHeaders')
        if m.get('x-acs-dingtalk-access-token') is not None:
            self.x_acs_dingtalk_access_token = m.get('x-acs-dingtalk-access-token')
        return self


class GetFileDownloadInfoRequest(TeaModel):
    def __init__(
        self,
        file_id_list: List[str] = None,
        space_id: int = None,
    ):
        # This parameter is required.
        self.file_id_list = file_id_list
        # This parameter is required.
        self.space_id = space_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.file_id_list is not None:
            result['fileIdList'] = self.file_id_list
        if self.space_id is not None:
            result['spaceId'] = self.space_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('fileIdList') is not None:
            self.file_id_list = m.get('fileIdList')
        if m.get('spaceId') is not None:
            self.space_id = m.get('spaceId')
        return self


class GetFileDownloadInfoResponseBody(TeaModel):
    def __init__(
        self,
        result: Dict[str, ResultValue] = None,
        success: bool = None,
    ):
        self.result = result
        self.success = success

    def validate(self):
        if self.result:
            for v in self.result.values():
                if v:
                    v.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['result'] = {}
        if self.result is not None:
            for k, v in self.result.items():
                result['result'][k] = v.to_map()
        if self.success is not None:
            result['success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.result = {}
        if m.get('result') is not None:
            for k, v in m.get('result').items():
                temp_model = ResultValue()
                self.result[k] = temp_model.from_map(v)
        if m.get('success') is not None:
            self.success = m.get('success')
        return self


class GetFileDownloadInfoResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: GetFileDownloadInfoResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetFileDownloadInfoResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetFileDownloadInfoByPackageIdHeaders(TeaModel):
    def __init__(
        self,
        common_headers: Dict[str, str] = None,
        x_acs_dingtalk_access_token: str = None,
    ):
        self.common_headers = common_headers
        self.x_acs_dingtalk_access_token = x_acs_dingtalk_access_token

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.common_headers is not None:
            result['commonHeaders'] = self.common_headers
        if self.x_acs_dingtalk_access_token is not None:
            result['x-acs-dingtalk-access-token'] = self.x_acs_dingtalk_access_token
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('commonHeaders') is not None:
            self.common_headers = m.get('commonHeaders')
        if m.get('x-acs-dingtalk-access-token') is not None:
            self.x_acs_dingtalk_access_token = m.get('x-acs-dingtalk-access-token')
        return self


class GetFileDownloadInfoByPackageIdRequest(TeaModel):
    def __init__(
        self,
        package_id: str = None,
    ):
        # This parameter is required.
        self.package_id = package_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.package_id is not None:
            result['packageId'] = self.package_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('packageId') is not None:
            self.package_id = m.get('packageId')
        return self


class GetFileDownloadInfoByPackageIdResponseBodyResult(TeaModel):
    def __init__(
        self,
        file_id: str = None,
        media_id: str = None,
        space_id: int = None,
    ):
        self.file_id = file_id
        self.media_id = media_id
        self.space_id = space_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.file_id is not None:
            result['fileId'] = self.file_id
        if self.media_id is not None:
            result['mediaId'] = self.media_id
        if self.space_id is not None:
            result['spaceId'] = self.space_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('fileId') is not None:
            self.file_id = m.get('fileId')
        if m.get('mediaId') is not None:
            self.media_id = m.get('mediaId')
        if m.get('spaceId') is not None:
            self.space_id = m.get('spaceId')
        return self


class GetFileDownloadInfoByPackageIdResponseBody(TeaModel):
    def __init__(
        self,
        result: List[GetFileDownloadInfoByPackageIdResponseBodyResult] = None,
        success: bool = None,
    ):
        self.result = result
        self.success = success

    def validate(self):
        if self.result:
            for k in self.result:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['result'] = []
        if self.result is not None:
            for k in self.result:
                result['result'].append(k.to_map() if k else None)
        if self.success is not None:
            result['success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.result = []
        if m.get('result') is not None:
            for k in m.get('result'):
                temp_model = GetFileDownloadInfoByPackageIdResponseBodyResult()
                self.result.append(temp_model.from_map(k))
        if m.get('success') is not None:
            self.success = m.get('success')
        return self


class GetFileDownloadInfoByPackageIdResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: GetFileDownloadInfoByPackageIdResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetFileDownloadInfoByPackageIdResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetImageTempDownloadUrlHeaders(TeaModel):
    def __init__(
        self,
        common_headers: Dict[str, str] = None,
        x_acs_dingtalk_access_token: str = None,
    ):
        self.common_headers = common_headers
        self.x_acs_dingtalk_access_token = x_acs_dingtalk_access_token

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.common_headers is not None:
            result['commonHeaders'] = self.common_headers
        if self.x_acs_dingtalk_access_token is not None:
            result['x-acs-dingtalk-access-token'] = self.x_acs_dingtalk_access_token
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('commonHeaders') is not None:
            self.common_headers = m.get('commonHeaders')
        if m.get('x-acs-dingtalk-access-token') is not None:
            self.x_acs_dingtalk_access_token = m.get('x-acs-dingtalk-access-token')
        return self


class GetImageTempDownloadUrlRequest(TeaModel):
    def __init__(
        self,
        media_id: str = None,
        source_type: str = None,
    ):
        # This parameter is required.
        self.media_id = media_id
        # This parameter is required.
        self.source_type = source_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.media_id is not None:
            result['mediaId'] = self.media_id
        if self.source_type is not None:
            result['sourceType'] = self.source_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('mediaId') is not None:
            self.media_id = m.get('mediaId')
        if m.get('sourceType') is not None:
            self.source_type = m.get('sourceType')
        return self


class GetImageTempDownloadUrlResponseBodyResult(TeaModel):
    def __init__(
        self,
        extension: str = None,
        file_name: str = None,
        file_size: int = None,
        url: str = None,
    ):
        self.extension = extension
        self.file_name = file_name
        self.file_size = file_size
        self.url = url

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.extension is not None:
            result['extension'] = self.extension
        if self.file_name is not None:
            result['fileName'] = self.file_name
        if self.file_size is not None:
            result['fileSize'] = self.file_size
        if self.url is not None:
            result['url'] = self.url
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('extension') is not None:
            self.extension = m.get('extension')
        if m.get('fileName') is not None:
            self.file_name = m.get('fileName')
        if m.get('fileSize') is not None:
            self.file_size = m.get('fileSize')
        if m.get('url') is not None:
            self.url = m.get('url')
        return self


class GetImageTempDownloadUrlResponseBody(TeaModel):
    def __init__(
        self,
        result: GetImageTempDownloadUrlResponseBodyResult = None,
        success: bool = None,
    ):
        self.result = result
        self.success = success

    def validate(self):
        if self.result:
            self.result.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.result is not None:
            result['result'] = self.result.to_map()
        if self.success is not None:
            result['success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('result') is not None:
            temp_model = GetImageTempDownloadUrlResponseBodyResult()
            self.result = temp_model.from_map(m['result'])
        if m.get('success') is not None:
            self.success = m.get('success')
        return self


class GetImageTempDownloadUrlResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: GetImageTempDownloadUrlResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetImageTempDownloadUrlResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetOpenCourseDetailHeaders(TeaModel):
    def __init__(
        self,
        common_headers: Dict[str, str] = None,
        x_acs_dingtalk_access_token: str = None,
    ):
        self.common_headers = common_headers
        self.x_acs_dingtalk_access_token = x_acs_dingtalk_access_token

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.common_headers is not None:
            result['commonHeaders'] = self.common_headers
        if self.x_acs_dingtalk_access_token is not None:
            result['x-acs-dingtalk-access-token'] = self.x_acs_dingtalk_access_token
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('commonHeaders') is not None:
            self.common_headers = m.get('commonHeaders')
        if m.get('x-acs-dingtalk-access-token') is not None:
            self.x_acs_dingtalk_access_token = m.get('x-acs-dingtalk-access-token')
        return self


class GetOpenCourseDetailResponseBodyPushModel(TeaModel):
    def __init__(
        self,
        push_org_name_list: List[str] = None,
        push_role_name_list: List[str] = None,
    ):
        # This parameter is required.
        self.push_org_name_list = push_org_name_list
        # This parameter is required.
        self.push_role_name_list = push_role_name_list

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.push_org_name_list is not None:
            result['pushOrgNameList'] = self.push_org_name_list
        if self.push_role_name_list is not None:
            result['pushRoleNameList'] = self.push_role_name_list
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('pushOrgNameList') is not None:
            self.push_org_name_list = m.get('pushOrgNameList')
        if m.get('pushRoleNameList') is not None:
            self.push_role_name_list = m.get('pushRoleNameList')
        return self


class GetOpenCourseDetailResponseBody(TeaModel):
    def __init__(
        self,
        course_id: str = None,
        course_type: int = None,
        cover_url: str = None,
        introduction: str = None,
        push_model: GetOpenCourseDetailResponseBodyPushModel = None,
        start_time: int = None,
        teacher_id: str = None,
        teacher_name: str = None,
        title: str = None,
    ):
        # This parameter is required.
        self.course_id = course_id
        # This parameter is required.
        self.course_type = course_type
        # This parameter is required.
        self.cover_url = cover_url
        # This parameter is required.
        self.introduction = introduction
        # This parameter is required.
        self.push_model = push_model
        # This parameter is required.
        self.start_time = start_time
        # This parameter is required.
        self.teacher_id = teacher_id
        # This parameter is required.
        self.teacher_name = teacher_name
        # This parameter is required.
        self.title = title

    def validate(self):
        if self.push_model:
            self.push_model.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.course_id is not None:
            result['courseId'] = self.course_id
        if self.course_type is not None:
            result['courseType'] = self.course_type
        if self.cover_url is not None:
            result['coverUrl'] = self.cover_url
        if self.introduction is not None:
            result['introduction'] = self.introduction
        if self.push_model is not None:
            result['pushModel'] = self.push_model.to_map()
        if self.start_time is not None:
            result['startTime'] = self.start_time
        if self.teacher_id is not None:
            result['teacherId'] = self.teacher_id
        if self.teacher_name is not None:
            result['teacherName'] = self.teacher_name
        if self.title is not None:
            result['title'] = self.title
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('courseId') is not None:
            self.course_id = m.get('courseId')
        if m.get('courseType') is not None:
            self.course_type = m.get('courseType')
        if m.get('coverUrl') is not None:
            self.cover_url = m.get('coverUrl')
        if m.get('introduction') is not None:
            self.introduction = m.get('introduction')
        if m.get('pushModel') is not None:
            temp_model = GetOpenCourseDetailResponseBodyPushModel()
            self.push_model = temp_model.from_map(m['pushModel'])
        if m.get('startTime') is not None:
            self.start_time = m.get('startTime')
        if m.get('teacherId') is not None:
            self.teacher_id = m.get('teacherId')
        if m.get('teacherName') is not None:
            self.teacher_name = m.get('teacherName')
        if m.get('title') is not None:
            self.title = m.get('title')
        return self


class GetOpenCourseDetailResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: GetOpenCourseDetailResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetOpenCourseDetailResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetOpenCoursesHeaders(TeaModel):
    def __init__(
        self,
        common_headers: Dict[str, str] = None,
        x_acs_dingtalk_access_token: str = None,
    ):
        self.common_headers = common_headers
        self.x_acs_dingtalk_access_token = x_acs_dingtalk_access_token

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.common_headers is not None:
            result['commonHeaders'] = self.common_headers
        if self.x_acs_dingtalk_access_token is not None:
            result['x-acs-dingtalk-access-token'] = self.x_acs_dingtalk_access_token
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('commonHeaders') is not None:
            self.common_headers = m.get('commonHeaders')
        if m.get('x-acs-dingtalk-access-token') is not None:
            self.x_acs_dingtalk_access_token = m.get('x-acs-dingtalk-access-token')
        return self


class GetOpenCoursesRequest(TeaModel):
    def __init__(
        self,
        page_number: int = None,
        page_size: int = None,
    ):
        # This parameter is required.
        self.page_number = page_number
        # This parameter is required.
        self.page_size = page_size

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page_number is not None:
            result['pageNumber'] = self.page_number
        if self.page_size is not None:
            result['pageSize'] = self.page_size
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('pageNumber') is not None:
            self.page_number = m.get('pageNumber')
        if m.get('pageSize') is not None:
            self.page_size = m.get('pageSize')
        return self


class GetOpenCoursesResponseBodyCourseList(TeaModel):
    def __init__(
        self,
        course_id: str = None,
        cover_url: str = None,
        feed_type: int = None,
        jump_url: str = None,
        start_time: int = None,
        teacher_id: str = None,
        teacher_name: str = None,
        title: str = None,
    ):
        # This parameter is required.
        self.course_id = course_id
        # This parameter is required.
        self.cover_url = cover_url
        # This parameter is required.
        self.feed_type = feed_type
        # This parameter is required.
        self.jump_url = jump_url
        # This parameter is required.
        self.start_time = start_time
        # This parameter is required.
        self.teacher_id = teacher_id
        # This parameter is required.
        self.teacher_name = teacher_name
        # This parameter is required.
        self.title = title

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.course_id is not None:
            result['courseId'] = self.course_id
        if self.cover_url is not None:
            result['coverUrl'] = self.cover_url
        if self.feed_type is not None:
            result['feedType'] = self.feed_type
        if self.jump_url is not None:
            result['jumpUrl'] = self.jump_url
        if self.start_time is not None:
            result['startTime'] = self.start_time
        if self.teacher_id is not None:
            result['teacherId'] = self.teacher_id
        if self.teacher_name is not None:
            result['teacherName'] = self.teacher_name
        if self.title is not None:
            result['title'] = self.title
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('courseId') is not None:
            self.course_id = m.get('courseId')
        if m.get('coverUrl') is not None:
            self.cover_url = m.get('coverUrl')
        if m.get('feedType') is not None:
            self.feed_type = m.get('feedType')
        if m.get('jumpUrl') is not None:
            self.jump_url = m.get('jumpUrl')
        if m.get('startTime') is not None:
            self.start_time = m.get('startTime')
        if m.get('teacherId') is not None:
            self.teacher_id = m.get('teacherId')
        if m.get('teacherName') is not None:
            self.teacher_name = m.get('teacherName')
        if m.get('title') is not None:
            self.title = m.get('title')
        return self


class GetOpenCoursesResponseBody(TeaModel):
    def __init__(
        self,
        course_list: List[GetOpenCoursesResponseBodyCourseList] = None,
        total_count: int = None,
    ):
        # This parameter is required.
        self.course_list = course_list
        # This parameter is required.
        self.total_count = total_count

    def validate(self):
        if self.course_list:
            for k in self.course_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['courseList'] = []
        if self.course_list is not None:
            for k in self.course_list:
                result['courseList'].append(k.to_map() if k else None)
        if self.total_count is not None:
            result['totalCount'] = self.total_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.course_list = []
        if m.get('courseList') is not None:
            for k in m.get('courseList'):
                temp_model = GetOpenCoursesResponseBodyCourseList()
                self.course_list.append(temp_model.from_map(k))
        if m.get('totalCount') is not None:
            self.total_count = m.get('totalCount')
        return self


class GetOpenCoursesResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: GetOpenCoursesResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetOpenCoursesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetPointActionRecordHeaders(TeaModel):
    def __init__(
        self,
        common_headers: Dict[str, str] = None,
        x_acs_dingtalk_access_token: str = None,
    ):
        self.common_headers = common_headers
        self.x_acs_dingtalk_access_token = x_acs_dingtalk_access_token

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.common_headers is not None:
            result['commonHeaders'] = self.common_headers
        if self.x_acs_dingtalk_access_token is not None:
            result['x-acs-dingtalk-access-token'] = self.x_acs_dingtalk_access_token
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('commonHeaders') is not None:
            self.common_headers = m.get('commonHeaders')
        if m.get('x-acs-dingtalk-access-token') is not None:
            self.x_acs_dingtalk_access_token = m.get('x-acs-dingtalk-access-token')
        return self


class GetPointActionRecordRequestBody(TeaModel):
    def __init__(
        self,
        biz_id: str = None,
        owner_id: str = None,
        point_type: str = None,
    ):
        self.biz_id = biz_id
        self.owner_id = owner_id
        self.point_type = point_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.biz_id is not None:
            result['bizId'] = self.biz_id
        if self.owner_id is not None:
            result['ownerId'] = self.owner_id
        if self.point_type is not None:
            result['pointType'] = self.point_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('bizId') is not None:
            self.biz_id = m.get('bizId')
        if m.get('ownerId') is not None:
            self.owner_id = m.get('ownerId')
        if m.get('pointType') is not None:
            self.point_type = m.get('pointType')
        return self


class GetPointActionRecordRequest(TeaModel):
    def __init__(
        self,
        body: GetPointActionRecordRequestBody = None,
    ):
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('body') is not None:
            temp_model = GetPointActionRecordRequestBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetPointActionRecordShrinkRequest(TeaModel):
    def __init__(
        self,
        body_shrink: str = None,
    ):
        self.body_shrink = body_shrink

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.body_shrink is not None:
            result['body'] = self.body_shrink
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('body') is not None:
            self.body_shrink = m.get('body')
        return self


class GetPointActionRecordResponseBodyResult(TeaModel):
    def __init__(
        self,
        action_time: str = None,
        quantity: int = None,
        status: str = None,
    ):
        self.action_time = action_time
        self.quantity = quantity
        self.status = status

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.action_time is not None:
            result['actionTime'] = self.action_time
        if self.quantity is not None:
            result['quantity'] = self.quantity
        if self.status is not None:
            result['status'] = self.status
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('actionTime') is not None:
            self.action_time = m.get('actionTime')
        if m.get('quantity') is not None:
            self.quantity = m.get('quantity')
        if m.get('status') is not None:
            self.status = m.get('status')
        return self


class GetPointActionRecordResponseBody(TeaModel):
    def __init__(
        self,
        result: GetPointActionRecordResponseBodyResult = None,
        success: bool = None,
    ):
        self.result = result
        self.success = success

    def validate(self):
        if self.result:
            self.result.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.result is not None:
            result['result'] = self.result.to_map()
        if self.success is not None:
            result['success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('result') is not None:
            temp_model = GetPointActionRecordResponseBodyResult()
            self.result = temp_model.from_map(m['result'])
        if m.get('success') is not None:
            self.success = m.get('success')
        return self


class GetPointActionRecordResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: GetPointActionRecordResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetPointActionRecordResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetPointInfoHeaders(TeaModel):
    def __init__(
        self,
        common_headers: Dict[str, str] = None,
        x_acs_dingtalk_access_token: str = None,
    ):
        self.common_headers = common_headers
        self.x_acs_dingtalk_access_token = x_acs_dingtalk_access_token

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.common_headers is not None:
            result['commonHeaders'] = self.common_headers
        if self.x_acs_dingtalk_access_token is not None:
            result['x-acs-dingtalk-access-token'] = self.x_acs_dingtalk_access_token
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('commonHeaders') is not None:
            self.common_headers = m.get('commonHeaders')
        if m.get('x-acs-dingtalk-access-token') is not None:
            self.x_acs_dingtalk_access_token = m.get('x-acs-dingtalk-access-token')
        return self


class GetPointInfoRequest(TeaModel):
    def __init__(
        self,
        point_type: str = None,
    ):
        # This parameter is required.
        self.point_type = point_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.point_type is not None:
            result['pointType'] = self.point_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('pointType') is not None:
            self.point_type = m.get('pointType')
        return self


class GetPointInfoResponseBodyResult(TeaModel):
    def __init__(
        self,
        available_quota: int = None,
        end_time: str = None,
        start_time: str = None,
    ):
        self.available_quota = available_quota
        self.end_time = end_time
        self.start_time = start_time

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.available_quota is not None:
            result['availableQuota'] = self.available_quota
        if self.end_time is not None:
            result['endTime'] = self.end_time
        if self.start_time is not None:
            result['startTime'] = self.start_time
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('availableQuota') is not None:
            self.available_quota = m.get('availableQuota')
        if m.get('endTime') is not None:
            self.end_time = m.get('endTime')
        if m.get('startTime') is not None:
            self.start_time = m.get('startTime')
        return self


class GetPointInfoResponseBody(TeaModel):
    def __init__(
        self,
        result: GetPointInfoResponseBodyResult = None,
        success: bool = None,
    ):
        self.result = result
        self.success = success

    def validate(self):
        if self.result:
            self.result.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.result is not None:
            result['result'] = self.result.to_map()
        if self.success is not None:
            result['success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('result') is not None:
            temp_model = GetPointInfoResponseBodyResult()
            self.result = temp_model.from_map(m['result'])
        if m.get('success') is not None:
            self.success = m.get('success')
        return self


class GetPointInfoResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: GetPointInfoResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetPointInfoResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetRemoteClassCourseHeaders(TeaModel):
    def __init__(
        self,
        common_headers: Dict[str, str] = None,
        x_acs_dingtalk_access_token: str = None,
    ):
        self.common_headers = common_headers
        self.x_acs_dingtalk_access_token = x_acs_dingtalk_access_token

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.common_headers is not None:
            result['commonHeaders'] = self.common_headers
        if self.x_acs_dingtalk_access_token is not None:
            result['x-acs-dingtalk-access-token'] = self.x_acs_dingtalk_access_token
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('commonHeaders') is not None:
            self.common_headers = m.get('commonHeaders')
        if m.get('x-acs-dingtalk-access-token') is not None:
            self.x_acs_dingtalk_access_token = m.get('x-acs-dingtalk-access-token')
        return self


class GetRemoteClassCourseRequest(TeaModel):
    def __init__(
        self,
        operator: str = None,
    ):
        # This parameter is required.
        self.operator = operator

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.operator is not None:
            result['operator'] = self.operator
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('operator') is not None:
            self.operator = m.get('operator')
        return self


class GetRemoteClassCourseResponseBodyResultAttendParticipants(TeaModel):
    def __init__(
        self,
        corp_id: str = None,
        org_name: str = None,
        participant_id: str = None,
        participant_name: str = None,
    ):
        self.corp_id = corp_id
        self.org_name = org_name
        self.participant_id = participant_id
        self.participant_name = participant_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.corp_id is not None:
            result['corpId'] = self.corp_id
        if self.org_name is not None:
            result['orgName'] = self.org_name
        if self.participant_id is not None:
            result['participantId'] = self.participant_id
        if self.participant_name is not None:
            result['participantName'] = self.participant_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('corpId') is not None:
            self.corp_id = m.get('corpId')
        if m.get('orgName') is not None:
            self.org_name = m.get('orgName')
        if m.get('participantId') is not None:
            self.participant_id = m.get('participantId')
        if m.get('participantName') is not None:
            self.participant_name = m.get('participantName')
        return self


class GetRemoteClassCourseResponseBodyResultRecordInfos(TeaModel):
    def __init__(
        self,
        start_time: str = None,
        stop_time: str = None,
        url: str = None,
    ):
        self.start_time = start_time
        self.stop_time = stop_time
        self.url = url

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.start_time is not None:
            result['startTime'] = self.start_time
        if self.stop_time is not None:
            result['stopTime'] = self.stop_time
        if self.url is not None:
            result['url'] = self.url
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('startTime') is not None:
            self.start_time = m.get('startTime')
        if m.get('stopTime') is not None:
            self.stop_time = m.get('stopTime')
        if m.get('url') is not None:
            self.url = m.get('url')
        return self


class GetRemoteClassCourseResponseBodyResultTeachingParticipant(TeaModel):
    def __init__(
        self,
        corp_id: str = None,
        org_name: str = None,
        participant_id: str = None,
        participant_name: str = None,
    ):
        self.corp_id = corp_id
        self.org_name = org_name
        self.participant_id = participant_id
        self.participant_name = participant_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.corp_id is not None:
            result['corpId'] = self.corp_id
        if self.org_name is not None:
            result['orgName'] = self.org_name
        if self.participant_id is not None:
            result['participantId'] = self.participant_id
        if self.participant_name is not None:
            result['participantName'] = self.participant_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('corpId') is not None:
            self.corp_id = m.get('corpId')
        if m.get('orgName') is not None:
            self.org_name = m.get('orgName')
        if m.get('participantId') is not None:
            self.participant_id = m.get('participantId')
        if m.get('participantName') is not None:
            self.participant_name = m.get('participantName')
        return self


class GetRemoteClassCourseResponseBodyResult(TeaModel):
    def __init__(
        self,
        attend_participants: List[GetRemoteClassCourseResponseBodyResultAttendParticipants] = None,
        can_edit: bool = None,
        course_code: str = None,
        course_name: str = None,
        end_time: int = None,
        live_url: str = None,
        record_infos: List[GetRemoteClassCourseResponseBodyResultRecordInfos] = None,
        room_status: int = None,
        start_time: int = None,
        status: int = None,
        teaching_participant: GetRemoteClassCourseResponseBodyResultTeachingParticipant = None,
    ):
        self.attend_participants = attend_participants
        self.can_edit = can_edit
        self.course_code = course_code
        self.course_name = course_name
        self.end_time = end_time
        self.live_url = live_url
        self.record_infos = record_infos
        self.room_status = room_status
        self.start_time = start_time
        self.status = status
        self.teaching_participant = teaching_participant

    def validate(self):
        if self.attend_participants:
            for k in self.attend_participants:
                if k:
                    k.validate()
        if self.record_infos:
            for k in self.record_infos:
                if k:
                    k.validate()
        if self.teaching_participant:
            self.teaching_participant.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['attendParticipants'] = []
        if self.attend_participants is not None:
            for k in self.attend_participants:
                result['attendParticipants'].append(k.to_map() if k else None)
        if self.can_edit is not None:
            result['canEdit'] = self.can_edit
        if self.course_code is not None:
            result['courseCode'] = self.course_code
        if self.course_name is not None:
            result['courseName'] = self.course_name
        if self.end_time is not None:
            result['endTime'] = self.end_time
        if self.live_url is not None:
            result['liveUrl'] = self.live_url
        result['recordInfos'] = []
        if self.record_infos is not None:
            for k in self.record_infos:
                result['recordInfos'].append(k.to_map() if k else None)
        if self.room_status is not None:
            result['roomStatus'] = self.room_status
        if self.start_time is not None:
            result['startTime'] = self.start_time
        if self.status is not None:
            result['status'] = self.status
        if self.teaching_participant is not None:
            result['teachingParticipant'] = self.teaching_participant.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.attend_participants = []
        if m.get('attendParticipants') is not None:
            for k in m.get('attendParticipants'):
                temp_model = GetRemoteClassCourseResponseBodyResultAttendParticipants()
                self.attend_participants.append(temp_model.from_map(k))
        if m.get('canEdit') is not None:
            self.can_edit = m.get('canEdit')
        if m.get('courseCode') is not None:
            self.course_code = m.get('courseCode')
        if m.get('courseName') is not None:
            self.course_name = m.get('courseName')
        if m.get('endTime') is not None:
            self.end_time = m.get('endTime')
        if m.get('liveUrl') is not None:
            self.live_url = m.get('liveUrl')
        self.record_infos = []
        if m.get('recordInfos') is not None:
            for k in m.get('recordInfos'):
                temp_model = GetRemoteClassCourseResponseBodyResultRecordInfos()
                self.record_infos.append(temp_model.from_map(k))
        if m.get('roomStatus') is not None:
            self.room_status = m.get('roomStatus')
        if m.get('startTime') is not None:
            self.start_time = m.get('startTime')
        if m.get('status') is not None:
            self.status = m.get('status')
        if m.get('teachingParticipant') is not None:
            temp_model = GetRemoteClassCourseResponseBodyResultTeachingParticipant()
            self.teaching_participant = temp_model.from_map(m['teachingParticipant'])
        return self


class GetRemoteClassCourseResponseBody(TeaModel):
    def __init__(
        self,
        result: GetRemoteClassCourseResponseBodyResult = None,
        success: bool = None,
    ):
        self.result = result
        # This parameter is required.
        self.success = success

    def validate(self):
        if self.result:
            self.result.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.result is not None:
            result['result'] = self.result.to_map()
        if self.success is not None:
            result['success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('result') is not None:
            temp_model = GetRemoteClassCourseResponseBodyResult()
            self.result = temp_model.from_map(m['result'])
        if m.get('success') is not None:
            self.success = m.get('success')
        return self


class GetRemoteClassCourseResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: GetRemoteClassCourseResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetRemoteClassCourseResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetShareRoleMembersHeaders(TeaModel):
    def __init__(
        self,
        common_headers: Dict[str, str] = None,
        x_acs_dingtalk_access_token: str = None,
    ):
        self.common_headers = common_headers
        self.x_acs_dingtalk_access_token = x_acs_dingtalk_access_token

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.common_headers is not None:
            result['commonHeaders'] = self.common_headers
        if self.x_acs_dingtalk_access_token is not None:
            result['x-acs-dingtalk-access-token'] = self.x_acs_dingtalk_access_token
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('commonHeaders') is not None:
            self.common_headers = m.get('commonHeaders')
        if m.get('x-acs-dingtalk-access-token') is not None:
            self.x_acs_dingtalk_access_token = m.get('x-acs-dingtalk-access-token')
        return self


class GetShareRoleMembersResponseBodyResult(TeaModel):
    def __init__(
        self,
        corp_id: str = None,
        member_user_id_list_in_trunk_org: List[str] = None,
    ):
        # This parameter is required.
        self.corp_id = corp_id
        # This parameter is required.
        self.member_user_id_list_in_trunk_org = member_user_id_list_in_trunk_org

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.corp_id is not None:
            result['corpId'] = self.corp_id
        if self.member_user_id_list_in_trunk_org is not None:
            result['memberUserIdListInTrunkOrg'] = self.member_user_id_list_in_trunk_org
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('corpId') is not None:
            self.corp_id = m.get('corpId')
        if m.get('memberUserIdListInTrunkOrg') is not None:
            self.member_user_id_list_in_trunk_org = m.get('memberUserIdListInTrunkOrg')
        return self


class GetShareRoleMembersResponseBody(TeaModel):
    def __init__(
        self,
        result: List[GetShareRoleMembersResponseBodyResult] = None,
    ):
        # This parameter is required.
        self.result = result

    def validate(self):
        if self.result:
            for k in self.result:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['result'] = []
        if self.result is not None:
            for k in self.result:
                result['result'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.result = []
        if m.get('result') is not None:
            for k in m.get('result'):
                temp_model = GetShareRoleMembersResponseBodyResult()
                self.result.append(temp_model.from_map(k))
        return self


class GetShareRoleMembersResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: GetShareRoleMembersResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetShareRoleMembersResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetShareRolesHeaders(TeaModel):
    def __init__(
        self,
        common_headers: Dict[str, str] = None,
        x_acs_dingtalk_access_token: str = None,
    ):
        self.common_headers = common_headers
        self.x_acs_dingtalk_access_token = x_acs_dingtalk_access_token

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.common_headers is not None:
            result['commonHeaders'] = self.common_headers
        if self.x_acs_dingtalk_access_token is not None:
            result['x-acs-dingtalk-access-token'] = self.x_acs_dingtalk_access_token
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('commonHeaders') is not None:
            self.common_headers = m.get('commonHeaders')
        if m.get('x-acs-dingtalk-access-token') is not None:
            self.x_acs_dingtalk_access_token = m.get('x-acs-dingtalk-access-token')
        return self


class GetShareRolesResponseBodyResult(TeaModel):
    def __init__(
        self,
        share_role_code: str = None,
        share_role_name: str = None,
    ):
        self.share_role_code = share_role_code
        self.share_role_name = share_role_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.share_role_code is not None:
            result['shareRoleCode'] = self.share_role_code
        if self.share_role_name is not None:
            result['shareRoleName'] = self.share_role_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('shareRoleCode') is not None:
            self.share_role_code = m.get('shareRoleCode')
        if m.get('shareRoleName') is not None:
            self.share_role_name = m.get('shareRoleName')
        return self


class GetShareRolesResponseBody(TeaModel):
    def __init__(
        self,
        result: List[GetShareRolesResponseBodyResult] = None,
    ):
        self.result = result

    def validate(self):
        if self.result:
            for k in self.result:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['result'] = []
        if self.result is not None:
            for k in self.result:
                result['result'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.result = []
        if m.get('result') is not None:
            for k in m.get('result'):
                temp_model = GetShareRolesResponseBodyResult()
                self.result.append(temp_model.from_map(k))
        return self


class GetShareRolesResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: GetShareRolesResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetShareRolesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetTaskListHeaders(TeaModel):
    def __init__(
        self,
        common_headers: Dict[str, str] = None,
        x_acs_dingtalk_access_token: str = None,
    ):
        self.common_headers = common_headers
        self.x_acs_dingtalk_access_token = x_acs_dingtalk_access_token

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.common_headers is not None:
            result['commonHeaders'] = self.common_headers
        if self.x_acs_dingtalk_access_token is not None:
            result['x-acs-dingtalk-access-token'] = self.x_acs_dingtalk_access_token
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('commonHeaders') is not None:
            self.common_headers = m.get('commonHeaders')
        if m.get('x-acs-dingtalk-access-token') is not None:
            self.x_acs_dingtalk_access_token = m.get('x-acs-dingtalk-access-token')
        return self


class GetTaskListRequest(TeaModel):
    def __init__(
        self,
        operator: str = None,
        page_number: int = None,
        page_size: int = None,
        task_year: int = None,
    ):
        # This parameter is required.
        self.operator = operator
        # This parameter is required.
        self.page_number = page_number
        # This parameter is required.
        self.page_size = page_size
        self.task_year = task_year

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.operator is not None:
            result['operator'] = self.operator
        if self.page_number is not None:
            result['pageNumber'] = self.page_number
        if self.page_size is not None:
            result['pageSize'] = self.page_size
        if self.task_year is not None:
            result['taskYear'] = self.task_year
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('operator') is not None:
            self.operator = m.get('operator')
        if m.get('pageNumber') is not None:
            self.page_number = m.get('pageNumber')
        if m.get('pageSize') is not None:
            self.page_size = m.get('pageSize')
        if m.get('taskYear') is not None:
            self.task_year = m.get('taskYear')
        return self


class GetTaskListResponseBodyTaskList(TeaModel):
    def __init__(
        self,
        name: str = None,
        task_id: int = None,
        task_year: int = None,
    ):
        self.name = name
        self.task_id = task_id
        self.task_year = task_year

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.name is not None:
            result['name'] = self.name
        if self.task_id is not None:
            result['taskId'] = self.task_id
        if self.task_year is not None:
            result['taskYear'] = self.task_year
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('name') is not None:
            self.name = m.get('name')
        if m.get('taskId') is not None:
            self.task_id = m.get('taskId')
        if m.get('taskYear') is not None:
            self.task_year = m.get('taskYear')
        return self


class GetTaskListResponseBody(TeaModel):
    def __init__(
        self,
        count: int = None,
        task_list: List[GetTaskListResponseBodyTaskList] = None,
    ):
        self.count = count
        self.task_list = task_list

    def validate(self):
        if self.task_list:
            for k in self.task_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.count is not None:
            result['count'] = self.count
        result['taskList'] = []
        if self.task_list is not None:
            for k in self.task_list:
                result['taskList'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('count') is not None:
            self.count = m.get('count')
        self.task_list = []
        if m.get('taskList') is not None:
            for k in m.get('taskList'):
                temp_model = GetTaskListResponseBodyTaskList()
                self.task_list.append(temp_model.from_map(k))
        return self


class GetTaskListResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: GetTaskListResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetTaskListResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetTaskStudentListHeaders(TeaModel):
    def __init__(
        self,
        common_headers: Dict[str, str] = None,
        x_acs_dingtalk_access_token: str = None,
    ):
        self.common_headers = common_headers
        self.x_acs_dingtalk_access_token = x_acs_dingtalk_access_token

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.common_headers is not None:
            result['commonHeaders'] = self.common_headers
        if self.x_acs_dingtalk_access_token is not None:
            result['x-acs-dingtalk-access-token'] = self.x_acs_dingtalk_access_token
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('commonHeaders') is not None:
            self.common_headers = m.get('commonHeaders')
        if m.get('x-acs-dingtalk-access-token') is not None:
            self.x_acs_dingtalk_access_token = m.get('x-acs-dingtalk-access-token')
        return self


class GetTaskStudentListRequest(TeaModel):
    def __init__(
        self,
        operator: str = None,
        page_number: int = None,
        page_size: int = None,
        task_id: int = None,
    ):
        # This parameter is required.
        self.operator = operator
        # This parameter is required.
        self.page_number = page_number
        # This parameter is required.
        self.page_size = page_size
        # This parameter is required.
        self.task_id = task_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.operator is not None:
            result['operator'] = self.operator
        if self.page_number is not None:
            result['pageNumber'] = self.page_number
        if self.page_size is not None:
            result['pageSize'] = self.page_size
        if self.task_id is not None:
            result['taskId'] = self.task_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('operator') is not None:
            self.operator = m.get('operator')
        if m.get('pageNumber') is not None:
            self.page_number = m.get('pageNumber')
        if m.get('pageSize') is not None:
            self.page_size = m.get('pageSize')
        if m.get('taskId') is not None:
            self.task_id = m.get('taskId')
        return self


class GetTaskStudentListResponseBodyStudentList(TeaModel):
    def __init__(
        self,
        name: str = None,
        sexuality: str = None,
        student_id: int = None,
    ):
        self.name = name
        self.sexuality = sexuality
        self.student_id = student_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.name is not None:
            result['name'] = self.name
        if self.sexuality is not None:
            result['sexuality'] = self.sexuality
        if self.student_id is not None:
            result['studentId'] = self.student_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('name') is not None:
            self.name = m.get('name')
        if m.get('sexuality') is not None:
            self.sexuality = m.get('sexuality')
        if m.get('studentId') is not None:
            self.student_id = m.get('studentId')
        return self


class GetTaskStudentListResponseBody(TeaModel):
    def __init__(
        self,
        count: int = None,
        student_list: List[GetTaskStudentListResponseBodyStudentList] = None,
        task_id: int = None,
    ):
        self.count = count
        self.student_list = student_list
        self.task_id = task_id

    def validate(self):
        if self.student_list:
            for k in self.student_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.count is not None:
            result['count'] = self.count
        result['studentList'] = []
        if self.student_list is not None:
            for k in self.student_list:
                result['studentList'].append(k.to_map() if k else None)
        if self.task_id is not None:
            result['taskId'] = self.task_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('count') is not None:
            self.count = m.get('count')
        self.student_list = []
        if m.get('studentList') is not None:
            for k in m.get('studentList'):
                temp_model = GetTaskStudentListResponseBodyStudentList()
                self.student_list.append(temp_model.from_map(k))
        if m.get('taskId') is not None:
            self.task_id = m.get('taskId')
        return self


class GetTaskStudentListResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: GetTaskStudentListResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetTaskStudentListResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class InitCoursesOfClassHeaders(TeaModel):
    def __init__(
        self,
        common_headers: Dict[str, str] = None,
        x_acs_dingtalk_access_token: str = None,
    ):
        self.common_headers = common_headers
        self.x_acs_dingtalk_access_token = x_acs_dingtalk_access_token

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.common_headers is not None:
            result['commonHeaders'] = self.common_headers
        if self.x_acs_dingtalk_access_token is not None:
            result['x-acs-dingtalk-access-token'] = self.x_acs_dingtalk_access_token
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('commonHeaders') is not None:
            self.common_headers = m.get('commonHeaders')
        if m.get('x-acs-dingtalk-access-token') is not None:
            self.x_acs_dingtalk_access_token = m.get('x-acs-dingtalk-access-token')
        return self


class InitCoursesOfClassRequestCoursesDateModel(TeaModel):
    def __init__(
        self,
        day_of_month: int = None,
        month: int = None,
        year: int = None,
    ):
        # This parameter is required.
        self.day_of_month = day_of_month
        # This parameter is required.
        self.month = month
        # This parameter is required.
        self.year = year

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.day_of_month is not None:
            result['dayOfMonth'] = self.day_of_month
        if self.month is not None:
            result['month'] = self.month
        if self.year is not None:
            result['year'] = self.year
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('dayOfMonth') is not None:
            self.day_of_month = m.get('dayOfMonth')
        if m.get('month') is not None:
            self.month = m.get('month')
        if m.get('year') is not None:
            self.year = m.get('year')
        return self


class InitCoursesOfClassRequestCoursesSectionModel(TeaModel):
    def __init__(
        self,
        section_index: int = None,
        section_name: str = None,
    ):
        # This parameter is required.
        self.section_index = section_index
        # This parameter is required.
        self.section_name = section_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.section_index is not None:
            result['sectionIndex'] = self.section_index
        if self.section_name is not None:
            result['sectionName'] = self.section_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('sectionIndex') is not None:
            self.section_index = m.get('sectionIndex')
        if m.get('sectionName') is not None:
            self.section_name = m.get('sectionName')
        return self


class InitCoursesOfClassRequestCourses(TeaModel):
    def __init__(
        self,
        course_name: str = None,
        creator_name: str = None,
        date_model: InitCoursesOfClassRequestCoursesDateModel = None,
        location: str = None,
        section_model: InitCoursesOfClassRequestCoursesSectionModel = None,
        teacher_staff_ids: List[str] = None,
    ):
        self.course_name = course_name
        self.creator_name = creator_name
        # This parameter is required.
        self.date_model = date_model
        self.location = location
        # This parameter is required.
        self.section_model = section_model
        self.teacher_staff_ids = teacher_staff_ids

    def validate(self):
        if self.date_model:
            self.date_model.validate()
        if self.section_model:
            self.section_model.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.course_name is not None:
            result['courseName'] = self.course_name
        if self.creator_name is not None:
            result['creatorName'] = self.creator_name
        if self.date_model is not None:
            result['dateModel'] = self.date_model.to_map()
        if self.location is not None:
            result['location'] = self.location
        if self.section_model is not None:
            result['sectionModel'] = self.section_model.to_map()
        if self.teacher_staff_ids is not None:
            result['teacherStaffIds'] = self.teacher_staff_ids
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('courseName') is not None:
            self.course_name = m.get('courseName')
        if m.get('creatorName') is not None:
            self.creator_name = m.get('creatorName')
        if m.get('dateModel') is not None:
            temp_model = InitCoursesOfClassRequestCoursesDateModel()
            self.date_model = temp_model.from_map(m['dateModel'])
        if m.get('location') is not None:
            self.location = m.get('location')
        if m.get('sectionModel') is not None:
            temp_model = InitCoursesOfClassRequestCoursesSectionModel()
            self.section_model = temp_model.from_map(m['sectionModel'])
        if m.get('teacherStaffIds') is not None:
            self.teacher_staff_ids = m.get('teacherStaffIds')
        return self


class InitCoursesOfClassRequestSectionConfigEnd(TeaModel):
    def __init__(
        self,
        day_of_month: int = None,
        month: int = None,
        year: int = None,
    ):
        # This parameter is required.
        self.day_of_month = day_of_month
        # This parameter is required.
        self.month = month
        # This parameter is required.
        self.year = year

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.day_of_month is not None:
            result['dayOfMonth'] = self.day_of_month
        if self.month is not None:
            result['month'] = self.month
        if self.year is not None:
            result['year'] = self.year
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('dayOfMonth') is not None:
            self.day_of_month = m.get('dayOfMonth')
        if m.get('month') is not None:
            self.month = m.get('month')
        if m.get('year') is not None:
            self.year = m.get('year')
        return self


class InitCoursesOfClassRequestSectionConfigSectionModelsEnd(TeaModel):
    def __init__(
        self,
        hour: int = None,
        min: int = None,
    ):
        # This parameter is required.
        self.hour = hour
        # This parameter is required.
        self.min = min

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.hour is not None:
            result['hour'] = self.hour
        if self.min is not None:
            result['min'] = self.min
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('hour') is not None:
            self.hour = m.get('hour')
        if m.get('min') is not None:
            self.min = m.get('min')
        return self


class InitCoursesOfClassRequestSectionConfigSectionModelsStart(TeaModel):
    def __init__(
        self,
        hour: int = None,
        min: int = None,
    ):
        # This parameter is required.
        self.hour = hour
        # This parameter is required.
        self.min = min

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.hour is not None:
            result['hour'] = self.hour
        if self.min is not None:
            result['min'] = self.min
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('hour') is not None:
            self.hour = m.get('hour')
        if m.get('min') is not None:
            self.min = m.get('min')
        return self


class InitCoursesOfClassRequestSectionConfigSectionModels(TeaModel):
    def __init__(
        self,
        end: InitCoursesOfClassRequestSectionConfigSectionModelsEnd = None,
        section_index: int = None,
        section_type: str = None,
        start: InitCoursesOfClassRequestSectionConfigSectionModelsStart = None,
    ):
        # This parameter is required.
        self.end = end
        # This parameter is required.
        self.section_index = section_index
        self.section_type = section_type
        # This parameter is required.
        self.start = start

    def validate(self):
        if self.end:
            self.end.validate()
        if self.start:
            self.start.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.end is not None:
            result['end'] = self.end.to_map()
        if self.section_index is not None:
            result['sectionIndex'] = self.section_index
        if self.section_type is not None:
            result['sectionType'] = self.section_type
        if self.start is not None:
            result['start'] = self.start.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('end') is not None:
            temp_model = InitCoursesOfClassRequestSectionConfigSectionModelsEnd()
            self.end = temp_model.from_map(m['end'])
        if m.get('sectionIndex') is not None:
            self.section_index = m.get('sectionIndex')
        if m.get('sectionType') is not None:
            self.section_type = m.get('sectionType')
        if m.get('start') is not None:
            temp_model = InitCoursesOfClassRequestSectionConfigSectionModelsStart()
            self.start = temp_model.from_map(m['start'])
        return self


class InitCoursesOfClassRequestSectionConfigStart(TeaModel):
    def __init__(
        self,
        day_of_month: int = None,
        month: int = None,
        year: int = None,
    ):
        # This parameter is required.
        self.day_of_month = day_of_month
        # This parameter is required.
        self.month = month
        # This parameter is required.
        self.year = year

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.day_of_month is not None:
            result['dayOfMonth'] = self.day_of_month
        if self.month is not None:
            result['month'] = self.month
        if self.year is not None:
            result['year'] = self.year
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('dayOfMonth') is not None:
            self.day_of_month = m.get('dayOfMonth')
        if m.get('month') is not None:
            self.month = m.get('month')
        if m.get('year') is not None:
            self.year = m.get('year')
        return self


class InitCoursesOfClassRequestSectionConfig(TeaModel):
    def __init__(
        self,
        end: InitCoursesOfClassRequestSectionConfigEnd = None,
        section_models: List[InitCoursesOfClassRequestSectionConfigSectionModels] = None,
        start: InitCoursesOfClassRequestSectionConfigStart = None,
    ):
        # This parameter is required.
        self.end = end
        # This parameter is required.
        self.section_models = section_models
        # This parameter is required.
        self.start = start

    def validate(self):
        if self.end:
            self.end.validate()
        if self.section_models:
            for k in self.section_models:
                if k:
                    k.validate()
        if self.start:
            self.start.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.end is not None:
            result['end'] = self.end.to_map()
        result['sectionModels'] = []
        if self.section_models is not None:
            for k in self.section_models:
                result['sectionModels'].append(k.to_map() if k else None)
        if self.start is not None:
            result['start'] = self.start.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('end') is not None:
            temp_model = InitCoursesOfClassRequestSectionConfigEnd()
            self.end = temp_model.from_map(m['end'])
        self.section_models = []
        if m.get('sectionModels') is not None:
            for k in m.get('sectionModels'):
                temp_model = InitCoursesOfClassRequestSectionConfigSectionModels()
                self.section_models.append(temp_model.from_map(k))
        if m.get('start') is not None:
            temp_model = InitCoursesOfClassRequestSectionConfigStart()
            self.start = temp_model.from_map(m['start'])
        return self


class InitCoursesOfClassRequest(TeaModel):
    def __init__(
        self,
        courses: List[InitCoursesOfClassRequestCourses] = None,
        section_config: InitCoursesOfClassRequestSectionConfig = None,
        op_user_id: str = None,
    ):
        # This parameter is required.
        self.courses = courses
        # This parameter is required.
        self.section_config = section_config
        # This parameter is required.
        self.op_user_id = op_user_id

    def validate(self):
        if self.courses:
            for k in self.courses:
                if k:
                    k.validate()
        if self.section_config:
            self.section_config.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['courses'] = []
        if self.courses is not None:
            for k in self.courses:
                result['courses'].append(k.to_map() if k else None)
        if self.section_config is not None:
            result['sectionConfig'] = self.section_config.to_map()
        if self.op_user_id is not None:
            result['opUserId'] = self.op_user_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.courses = []
        if m.get('courses') is not None:
            for k in m.get('courses'):
                temp_model = InitCoursesOfClassRequestCourses()
                self.courses.append(temp_model.from_map(k))
        if m.get('sectionConfig') is not None:
            temp_model = InitCoursesOfClassRequestSectionConfig()
            self.section_config = temp_model.from_map(m['sectionConfig'])
        if m.get('opUserId') is not None:
            self.op_user_id = m.get('opUserId')
        return self


class InitCoursesOfClassResponseBody(TeaModel):
    def __init__(
        self,
        result: bool = None,
    ):
        self.result = result

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.result is not None:
            result['result'] = self.result
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('result') is not None:
            self.result = m.get('result')
        return self


class InitCoursesOfClassResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: InitCoursesOfClassResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = InitCoursesOfClassResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class InitDeviceHeaders(TeaModel):
    def __init__(
        self,
        common_headers: Dict[str, str] = None,
        x_acs_dingtalk_access_token: str = None,
    ):
        self.common_headers = common_headers
        self.x_acs_dingtalk_access_token = x_acs_dingtalk_access_token

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.common_headers is not None:
            result['commonHeaders'] = self.common_headers
        if self.x_acs_dingtalk_access_token is not None:
            result['x-acs-dingtalk-access-token'] = self.x_acs_dingtalk_access_token
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('commonHeaders') is not None:
            self.common_headers = m.get('commonHeaders')
        if m.get('x-acs-dingtalk-access-token') is not None:
            self.x_acs_dingtalk_access_token = m.get('x-acs-dingtalk-access-token')
        return self


class InitDeviceRequest(TeaModel):
    def __init__(
        self,
        encrypt_pub_key: str = None,
        signature: str = None,
        sn: str = None,
        timestamp: int = None,
        version: str = None,
    ):
        # This parameter is required.
        self.encrypt_pub_key = encrypt_pub_key
        # This parameter is required.
        self.signature = signature
        # This parameter is required.
        self.sn = sn
        # This parameter is required.
        self.timestamp = timestamp
        self.version = version

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.encrypt_pub_key is not None:
            result['encryptPubKey'] = self.encrypt_pub_key
        if self.signature is not None:
            result['signature'] = self.signature
        if self.sn is not None:
            result['sn'] = self.sn
        if self.timestamp is not None:
            result['timestamp'] = self.timestamp
        if self.version is not None:
            result['version'] = self.version
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('encryptPubKey') is not None:
            self.encrypt_pub_key = m.get('encryptPubKey')
        if m.get('signature') is not None:
            self.signature = m.get('signature')
        if m.get('sn') is not None:
            self.sn = m.get('sn')
        if m.get('timestamp') is not None:
            self.timestamp = m.get('timestamp')
        if m.get('version') is not None:
            self.version = m.get('version')
        return self


class InitDeviceResponseBody(TeaModel):
    def __init__(
        self,
        success_info: str = None,
    ):
        # This parameter is required.
        self.success_info = success_info

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.success_info is not None:
            result['successInfo'] = self.success_info
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('successInfo') is not None:
            self.success_info = m.get('successInfo')
        return self


class InitDeviceResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: InitDeviceResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = InitDeviceResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class InitVPaasDeviceHeaders(TeaModel):
    def __init__(
        self,
        common_headers: Dict[str, str] = None,
        x_acs_dingtalk_access_token: str = None,
    ):
        self.common_headers = common_headers
        self.x_acs_dingtalk_access_token = x_acs_dingtalk_access_token

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.common_headers is not None:
            result['commonHeaders'] = self.common_headers
        if self.x_acs_dingtalk_access_token is not None:
            result['x-acs-dingtalk-access-token'] = self.x_acs_dingtalk_access_token
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('commonHeaders') is not None:
            self.common_headers = m.get('commonHeaders')
        if m.get('x-acs-dingtalk-access-token') is not None:
            self.x_acs_dingtalk_access_token = m.get('x-acs-dingtalk-access-token')
        return self


class InitVPaasDeviceRequest(TeaModel):
    def __init__(
        self,
        sn: str = None,
        timestamp: int = None,
        type: str = None,
    ):
        # This parameter is required.
        self.sn = sn
        self.timestamp = timestamp
        # This parameter is required.
        self.type = type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.sn is not None:
            result['sn'] = self.sn
        if self.timestamp is not None:
            result['timestamp'] = self.timestamp
        if self.type is not None:
            result['type'] = self.type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('sn') is not None:
            self.sn = m.get('sn')
        if m.get('timestamp') is not None:
            self.timestamp = m.get('timestamp')
        if m.get('type') is not None:
            self.type = m.get('type')
        return self


class InitVPaasDeviceResponseBody(TeaModel):
    def __init__(
        self,
        pspk: str = None,
    ):
        self.pspk = pspk

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.pspk is not None:
            result['pspk'] = self.pspk
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('pspk') is not None:
            self.pspk = m.get('pspk')
        return self


class InitVPaasDeviceResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: InitVPaasDeviceResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = InitVPaasDeviceResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class InsertSectionConfigHeaders(TeaModel):
    def __init__(
        self,
        common_headers: Dict[str, str] = None,
        x_acs_dingtalk_access_token: str = None,
    ):
        self.common_headers = common_headers
        self.x_acs_dingtalk_access_token = x_acs_dingtalk_access_token

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.common_headers is not None:
            result['commonHeaders'] = self.common_headers
        if self.x_acs_dingtalk_access_token is not None:
            result['x-acs-dingtalk-access-token'] = self.x_acs_dingtalk_access_token
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('commonHeaders') is not None:
            self.common_headers = m.get('commonHeaders')
        if m.get('x-acs-dingtalk-access-token') is not None:
            self.x_acs_dingtalk_access_token = m.get('x-acs-dingtalk-access-token')
        return self


class InsertSectionConfigRequestEnd(TeaModel):
    def __init__(
        self,
        day_of_month: int = None,
        month: int = None,
        year: int = None,
    ):
        self.day_of_month = day_of_month
        self.month = month
        self.year = year

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.day_of_month is not None:
            result['dayOfMonth'] = self.day_of_month
        if self.month is not None:
            result['month'] = self.month
        if self.year is not None:
            result['year'] = self.year
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('dayOfMonth') is not None:
            self.day_of_month = m.get('dayOfMonth')
        if m.get('month') is not None:
            self.month = m.get('month')
        if m.get('year') is not None:
            self.year = m.get('year')
        return self


class InsertSectionConfigRequestSectionModelsEnd(TeaModel):
    def __init__(
        self,
        hour: int = None,
        min: int = None,
    ):
        self.hour = hour
        self.min = min

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.hour is not None:
            result['hour'] = self.hour
        if self.min is not None:
            result['min'] = self.min
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('hour') is not None:
            self.hour = m.get('hour')
        if m.get('min') is not None:
            self.min = m.get('min')
        return self


class InsertSectionConfigRequestSectionModelsStart(TeaModel):
    def __init__(
        self,
        hour: int = None,
        min: int = None,
    ):
        self.hour = hour
        self.min = min

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.hour is not None:
            result['hour'] = self.hour
        if self.min is not None:
            result['min'] = self.min
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('hour') is not None:
            self.hour = m.get('hour')
        if m.get('min') is not None:
            self.min = m.get('min')
        return self


class InsertSectionConfigRequestSectionModels(TeaModel):
    def __init__(
        self,
        end: InsertSectionConfigRequestSectionModelsEnd = None,
        section_index: int = None,
        section_name: str = None,
        section_type: str = None,
        start: InsertSectionConfigRequestSectionModelsStart = None,
    ):
        self.end = end
        self.section_index = section_index
        self.section_name = section_name
        self.section_type = section_type
        self.start = start

    def validate(self):
        if self.end:
            self.end.validate()
        if self.start:
            self.start.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.end is not None:
            result['end'] = self.end.to_map()
        if self.section_index is not None:
            result['sectionIndex'] = self.section_index
        if self.section_name is not None:
            result['sectionName'] = self.section_name
        if self.section_type is not None:
            result['sectionType'] = self.section_type
        if self.start is not None:
            result['start'] = self.start.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('end') is not None:
            temp_model = InsertSectionConfigRequestSectionModelsEnd()
            self.end = temp_model.from_map(m['end'])
        if m.get('sectionIndex') is not None:
            self.section_index = m.get('sectionIndex')
        if m.get('sectionName') is not None:
            self.section_name = m.get('sectionName')
        if m.get('sectionType') is not None:
            self.section_type = m.get('sectionType')
        if m.get('start') is not None:
            temp_model = InsertSectionConfigRequestSectionModelsStart()
            self.start = temp_model.from_map(m['start'])
        return self


class InsertSectionConfigRequestStart(TeaModel):
    def __init__(
        self,
        day_of_month: int = None,
        month: int = None,
        year: int = None,
    ):
        self.day_of_month = day_of_month
        self.month = month
        self.year = year

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.day_of_month is not None:
            result['dayOfMonth'] = self.day_of_month
        if self.month is not None:
            result['month'] = self.month
        if self.year is not None:
            result['year'] = self.year
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('dayOfMonth') is not None:
            self.day_of_month = m.get('dayOfMonth')
        if m.get('month') is not None:
            self.month = m.get('month')
        if m.get('year') is not None:
            self.year = m.get('year')
        return self


class InsertSectionConfigRequest(TeaModel):
    def __init__(
        self,
        end: InsertSectionConfigRequestEnd = None,
        schedule_name: str = None,
        section_models: List[InsertSectionConfigRequestSectionModels] = None,
        start: InsertSectionConfigRequestStart = None,
        op_user_id: str = None,
    ):
        self.end = end
        self.schedule_name = schedule_name
        self.section_models = section_models
        self.start = start
        self.op_user_id = op_user_id

    def validate(self):
        if self.end:
            self.end.validate()
        if self.section_models:
            for k in self.section_models:
                if k:
                    k.validate()
        if self.start:
            self.start.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.end is not None:
            result['end'] = self.end.to_map()
        if self.schedule_name is not None:
            result['scheduleName'] = self.schedule_name
        result['sectionModels'] = []
        if self.section_models is not None:
            for k in self.section_models:
                result['sectionModels'].append(k.to_map() if k else None)
        if self.start is not None:
            result['start'] = self.start.to_map()
        if self.op_user_id is not None:
            result['opUserId'] = self.op_user_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('end') is not None:
            temp_model = InsertSectionConfigRequestEnd()
            self.end = temp_model.from_map(m['end'])
        if m.get('scheduleName') is not None:
            self.schedule_name = m.get('scheduleName')
        self.section_models = []
        if m.get('sectionModels') is not None:
            for k in m.get('sectionModels'):
                temp_model = InsertSectionConfigRequestSectionModels()
                self.section_models.append(temp_model.from_map(k))
        if m.get('start') is not None:
            temp_model = InsertSectionConfigRequestStart()
            self.start = temp_model.from_map(m['start'])
        if m.get('opUserId') is not None:
            self.op_user_id = m.get('opUserId')
        return self


class InsertSectionConfigResponseBody(TeaModel):
    def __init__(
        self,
        result: bool = None,
    ):
        self.result = result

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.result is not None:
            result['result'] = self.result
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('result') is not None:
            self.result = m.get('result')
        return self


class InsertSectionConfigResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: InsertSectionConfigResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = InsertSectionConfigResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class InvalidCourseHeaders(TeaModel):
    def __init__(
        self,
        common_headers: Dict[str, str] = None,
        x_acs_dingtalk_access_token: str = None,
    ):
        self.common_headers = common_headers
        self.x_acs_dingtalk_access_token = x_acs_dingtalk_access_token

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.common_headers is not None:
            result['commonHeaders'] = self.common_headers
        if self.x_acs_dingtalk_access_token is not None:
            result['x-acs-dingtalk-access-token'] = self.x_acs_dingtalk_access_token
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('commonHeaders') is not None:
            self.common_headers = m.get('commonHeaders')
        if m.get('x-acs-dingtalk-access-token') is not None:
            self.x_acs_dingtalk_access_token = m.get('x-acs-dingtalk-access-token')
        return self


class InvalidCourseRequest(TeaModel):
    def __init__(
        self,
        class_id: str = None,
        corp_id: str = None,
        isv_code: str = None,
        isv_course_id: str = None,
    ):
        self.class_id = class_id
        self.corp_id = corp_id
        self.isv_code = isv_code
        self.isv_course_id = isv_course_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.class_id is not None:
            result['classId'] = self.class_id
        if self.corp_id is not None:
            result['corpId'] = self.corp_id
        if self.isv_code is not None:
            result['isvCode'] = self.isv_code
        if self.isv_course_id is not None:
            result['isvCourseId'] = self.isv_course_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('classId') is not None:
            self.class_id = m.get('classId')
        if m.get('corpId') is not None:
            self.corp_id = m.get('corpId')
        if m.get('isvCode') is not None:
            self.isv_code = m.get('isvCode')
        if m.get('isvCourseId') is not None:
            self.isv_course_id = m.get('isvCourseId')
        return self


class InvalidCourseResponseBody(TeaModel):
    def __init__(
        self,
        result: bool = None,
        success: bool = None,
    ):
        self.result = result
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.result is not None:
            result['result'] = self.result
        if self.success is not None:
            result['success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('result') is not None:
            self.result = m.get('result')
        if m.get('success') is not None:
            self.success = m.get('success')
        return self


class InvalidCourseResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: InvalidCourseResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = InvalidCourseResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class InvalidKitHeaders(TeaModel):
    def __init__(
        self,
        common_headers: Dict[str, str] = None,
        x_acs_dingtalk_access_token: str = None,
    ):
        self.common_headers = common_headers
        self.x_acs_dingtalk_access_token = x_acs_dingtalk_access_token

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.common_headers is not None:
            result['commonHeaders'] = self.common_headers
        if self.x_acs_dingtalk_access_token is not None:
            result['x-acs-dingtalk-access-token'] = self.x_acs_dingtalk_access_token
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('commonHeaders') is not None:
            self.common_headers = m.get('commonHeaders')
        if m.get('x-acs-dingtalk-access-token') is not None:
            self.x_acs_dingtalk_access_token = m.get('x-acs-dingtalk-access-token')
        return self


class InvalidKitRequest(TeaModel):
    def __init__(
        self,
        corp_id: str = None,
        isv_code: str = None,
        isv_product_scene: str = None,
        open_user_id: str = None,
    ):
        self.corp_id = corp_id
        self.isv_code = isv_code
        self.isv_product_scene = isv_product_scene
        self.open_user_id = open_user_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.corp_id is not None:
            result['corpId'] = self.corp_id
        if self.isv_code is not None:
            result['isvCode'] = self.isv_code
        if self.isv_product_scene is not None:
            result['isvProductScene'] = self.isv_product_scene
        if self.open_user_id is not None:
            result['openUserId'] = self.open_user_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('corpId') is not None:
            self.corp_id = m.get('corpId')
        if m.get('isvCode') is not None:
            self.isv_code = m.get('isvCode')
        if m.get('isvProductScene') is not None:
            self.isv_product_scene = m.get('isvProductScene')
        if m.get('openUserId') is not None:
            self.open_user_id = m.get('openUserId')
        return self


class InvalidKitResponseBody(TeaModel):
    def __init__(
        self,
        result: bool = None,
        success: bool = None,
    ):
        self.result = result
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.result is not None:
            result['result'] = self.result
        if self.success is not None:
            result['success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('result') is not None:
            self.result = m.get('result')
        if m.get('success') is not None:
            self.success = m.get('success')
        return self


class InvalidKitResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: InvalidKitResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = InvalidKitResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class InvalidStudentClassHeaders(TeaModel):
    def __init__(
        self,
        common_headers: Dict[str, str] = None,
        x_acs_dingtalk_access_token: str = None,
    ):
        self.common_headers = common_headers
        self.x_acs_dingtalk_access_token = x_acs_dingtalk_access_token

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.common_headers is not None:
            result['commonHeaders'] = self.common_headers
        if self.x_acs_dingtalk_access_token is not None:
            result['x-acs-dingtalk-access-token'] = self.x_acs_dingtalk_access_token
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('commonHeaders') is not None:
            self.common_headers = m.get('commonHeaders')
        if m.get('x-acs-dingtalk-access-token') is not None:
            self.x_acs_dingtalk_access_token = m.get('x-acs-dingtalk-access-token')
        return self


class InvalidStudentClassRequest(TeaModel):
    def __init__(
        self,
        class_id: str = None,
        class_type: int = None,
        corp_id: str = None,
        isv_code: str = None,
        student_user_ids: List[str] = None,
    ):
        self.class_id = class_id
        self.class_type = class_type
        self.corp_id = corp_id
        self.isv_code = isv_code
        self.student_user_ids = student_user_ids

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.class_id is not None:
            result['classId'] = self.class_id
        if self.class_type is not None:
            result['classType'] = self.class_type
        if self.corp_id is not None:
            result['corpId'] = self.corp_id
        if self.isv_code is not None:
            result['isvCode'] = self.isv_code
        if self.student_user_ids is not None:
            result['studentUserIds'] = self.student_user_ids
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('classId') is not None:
            self.class_id = m.get('classId')
        if m.get('classType') is not None:
            self.class_type = m.get('classType')
        if m.get('corpId') is not None:
            self.corp_id = m.get('corpId')
        if m.get('isvCode') is not None:
            self.isv_code = m.get('isvCode')
        if m.get('studentUserIds') is not None:
            self.student_user_ids = m.get('studentUserIds')
        return self


class InvalidStudentClassResponseBody(TeaModel):
    def __init__(
        self,
        result: bool = None,
        success: bool = None,
    ):
        self.result = result
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.result is not None:
            result['result'] = self.result
        if self.success is not None:
            result['success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('result') is not None:
            self.result = m.get('result')
        if m.get('success') is not None:
            self.success = m.get('success')
        return self


class InvalidStudentClassResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: InvalidStudentClassResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = InvalidStudentClassResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class InvalidTeacherCourseHeaders(TeaModel):
    def __init__(
        self,
        common_headers: Dict[str, str] = None,
        x_acs_dingtalk_access_token: str = None,
    ):
        self.common_headers = common_headers
        self.x_acs_dingtalk_access_token = x_acs_dingtalk_access_token

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.common_headers is not None:
            result['commonHeaders'] = self.common_headers
        if self.x_acs_dingtalk_access_token is not None:
            result['x-acs-dingtalk-access-token'] = self.x_acs_dingtalk_access_token
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('commonHeaders') is not None:
            self.common_headers = m.get('commonHeaders')
        if m.get('x-acs-dingtalk-access-token') is not None:
            self.x_acs_dingtalk_access_token = m.get('x-acs-dingtalk-access-token')
        return self


class InvalidTeacherCourseRequest(TeaModel):
    def __init__(
        self,
        corp_id: str = None,
        isv_code: str = None,
        need_delete_course_id_list: List[str] = None,
        teacher_user_id: str = None,
    ):
        self.corp_id = corp_id
        self.isv_code = isv_code
        self.need_delete_course_id_list = need_delete_course_id_list
        self.teacher_user_id = teacher_user_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.corp_id is not None:
            result['corpId'] = self.corp_id
        if self.isv_code is not None:
            result['isvCode'] = self.isv_code
        if self.need_delete_course_id_list is not None:
            result['needDeleteCourseIdList'] = self.need_delete_course_id_list
        if self.teacher_user_id is not None:
            result['teacherUserId'] = self.teacher_user_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('corpId') is not None:
            self.corp_id = m.get('corpId')
        if m.get('isvCode') is not None:
            self.isv_code = m.get('isvCode')
        if m.get('needDeleteCourseIdList') is not None:
            self.need_delete_course_id_list = m.get('needDeleteCourseIdList')
        if m.get('teacherUserId') is not None:
            self.teacher_user_id = m.get('teacherUserId')
        return self


class InvalidTeacherCourseResponseBody(TeaModel):
    def __init__(
        self,
        result: bool = None,
        success: bool = None,
    ):
        self.result = result
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.result is not None:
            result['result'] = self.result
        if self.success is not None:
            result['success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('result') is not None:
            self.result = m.get('result')
        if m.get('success') is not None:
            self.success = m.get('success')
        return self


class InvalidTeacherCourseResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: InvalidTeacherCourseResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = InvalidTeacherCourseResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class IsYuwenCertifiedTeacherHeaders(TeaModel):
    def __init__(
        self,
        common_headers: Dict[str, str] = None,
        x_acs_dingtalk_access_token: str = None,
    ):
        self.common_headers = common_headers
        self.x_acs_dingtalk_access_token = x_acs_dingtalk_access_token

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.common_headers is not None:
            result['commonHeaders'] = self.common_headers
        if self.x_acs_dingtalk_access_token is not None:
            result['x-acs-dingtalk-access-token'] = self.x_acs_dingtalk_access_token
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('commonHeaders') is not None:
            self.common_headers = m.get('commonHeaders')
        if m.get('x-acs-dingtalk-access-token') is not None:
            self.x_acs_dingtalk_access_token = m.get('x-acs-dingtalk-access-token')
        return self


class IsYuwenCertifiedTeacherRequest(TeaModel):
    def __init__(
        self,
        biz_code: str = None,
        user_id: str = None,
    ):
        # This parameter is required.
        self.biz_code = biz_code
        # This parameter is required.
        self.user_id = user_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.biz_code is not None:
            result['bizCode'] = self.biz_code
        if self.user_id is not None:
            result['userId'] = self.user_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('bizCode') is not None:
            self.biz_code = m.get('bizCode')
        if m.get('userId') is not None:
            self.user_id = m.get('userId')
        return self


class IsYuwenCertifiedTeacherResponseBody(TeaModel):
    def __init__(
        self,
        result: bool = None,
        success: bool = None,
    ):
        self.result = result
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.result is not None:
            result['result'] = self.result
        if self.success is not None:
            result['success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('result') is not None:
            self.result = m.get('result')
        if m.get('success') is not None:
            self.success = m.get('success')
        return self


class IsYuwenCertifiedTeacherResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: IsYuwenCertifiedTeacherResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = IsYuwenCertifiedTeacherResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class IsvDataWriteHeaders(TeaModel):
    def __init__(
        self,
        common_headers: Dict[str, str] = None,
        x_acs_dingtalk_access_token: str = None,
    ):
        self.common_headers = common_headers
        self.x_acs_dingtalk_access_token = x_acs_dingtalk_access_token

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.common_headers is not None:
            result['commonHeaders'] = self.common_headers
        if self.x_acs_dingtalk_access_token is not None:
            result['x-acs-dingtalk-access-token'] = self.x_acs_dingtalk_access_token
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('commonHeaders') is not None:
            self.common_headers = m.get('commonHeaders')
        if m.get('x-acs-dingtalk-access-token') is not None:
            self.x_acs_dingtalk_access_token = m.get('x-acs-dingtalk-access-token')
        return self


class IsvDataWriteRequestRowValueList(TeaModel):
    def __init__(
        self,
        name: str = None,
        value: str = None,
    ):
        self.name = name
        self.value = value

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.name is not None:
            result['name'] = self.name
        if self.value is not None:
            result['value'] = self.value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('name') is not None:
            self.name = m.get('name')
        if m.get('value') is not None:
            self.value = m.get('value')
        return self


class IsvDataWriteRequest(TeaModel):
    def __init__(
        self,
        object_code: str = None,
        row_value_list: List[List[IsvDataWriteRequestRowValueList]] = None,
    ):
        self.object_code = object_code
        self.row_value_list = row_value_list

    def validate(self):
        if self.row_value_list:
            for k in self.row_value_list:
                for k1 in k:
                    if k1:
                        k1.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.object_code is not None:
            result['objectCode'] = self.object_code
        result['rowValueList'] = []
        if self.row_value_list is not None:
            for k in self.row_value_list:
                l1 = []
                for k1 in k:
                    l1.append(k1.to_map() if k1 else None)
                result['rowValueList'].append(l1)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('objectCode') is not None:
            self.object_code = m.get('objectCode')
        self.row_value_list = []
        if m.get('rowValueList') is not None:
            for k in m.get('rowValueList'):
                l1 = []
                for k1 in k:
                    temp_model = IsvDataWriteRequestRowValueList()
                    l1.append(temp_model.from_map(k1))
                self.row_value_list.append(l1)
        return self


class IsvDataWriteResponseBodyResult(TeaModel):
    def __init__(
        self,
        need_retry: bool = None,
        success: bool = None,
    ):
        self.need_retry = need_retry
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.need_retry is not None:
            result['needRetry'] = self.need_retry
        if self.success is not None:
            result['success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('needRetry') is not None:
            self.need_retry = m.get('needRetry')
        if m.get('success') is not None:
            self.success = m.get('success')
        return self


class IsvDataWriteResponseBody(TeaModel):
    def __init__(
        self,
        result: IsvDataWriteResponseBodyResult = None,
        success: bool = None,
    ):
        self.result = result
        self.success = success

    def validate(self):
        if self.result:
            self.result.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.result is not None:
            result['result'] = self.result.to_map()
        if self.success is not None:
            result['success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('result') is not None:
            temp_model = IsvDataWriteResponseBodyResult()
            self.result = temp_model.from_map(m['result'])
        if m.get('success') is not None:
            self.success = m.get('success')
        return self


class IsvDataWriteResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: IsvDataWriteResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = IsvDataWriteResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class IsvMetadataQueryHeaders(TeaModel):
    def __init__(
        self,
        common_headers: Dict[str, str] = None,
        x_acs_dingtalk_access_token: str = None,
    ):
        self.common_headers = common_headers
        self.x_acs_dingtalk_access_token = x_acs_dingtalk_access_token

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.common_headers is not None:
            result['commonHeaders'] = self.common_headers
        if self.x_acs_dingtalk_access_token is not None:
            result['x-acs-dingtalk-access-token'] = self.x_acs_dingtalk_access_token
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('commonHeaders') is not None:
            self.common_headers = m.get('commonHeaders')
        if m.get('x-acs-dingtalk-access-token') is not None:
            self.x_acs_dingtalk_access_token = m.get('x-acs-dingtalk-access-token')
        return self


class IsvMetadataQueryRequest(TeaModel):
    def __init__(
        self,
        object_code: str = None,
    ):
        self.object_code = object_code

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.object_code is not None:
            result['objectCode'] = self.object_code
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('objectCode') is not None:
            self.object_code = m.get('objectCode')
        return self


class IsvMetadataQueryResponseBodyResultFields(TeaModel):
    def __init__(
        self,
        description: str = None,
        field_key: str = None,
        field_name: str = None,
        field_type: str = None,
        primary_key: bool = None,
        required: bool = None,
    ):
        self.description = description
        self.field_key = field_key
        self.field_name = field_name
        self.field_type = field_type
        self.primary_key = primary_key
        self.required = required

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.description is not None:
            result['description'] = self.description
        if self.field_key is not None:
            result['fieldKey'] = self.field_key
        if self.field_name is not None:
            result['fieldName'] = self.field_name
        if self.field_type is not None:
            result['fieldType'] = self.field_type
        if self.primary_key is not None:
            result['primaryKey'] = self.primary_key
        if self.required is not None:
            result['required'] = self.required
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('description') is not None:
            self.description = m.get('description')
        if m.get('fieldKey') is not None:
            self.field_key = m.get('fieldKey')
        if m.get('fieldName') is not None:
            self.field_name = m.get('fieldName')
        if m.get('fieldType') is not None:
            self.field_type = m.get('fieldType')
        if m.get('primaryKey') is not None:
            self.primary_key = m.get('primaryKey')
        if m.get('required') is not None:
            self.required = m.get('required')
        return self


class IsvMetadataQueryResponseBodyResult(TeaModel):
    def __init__(
        self,
        fields: List[IsvMetadataQueryResponseBodyResultFields] = None,
        table_code: str = None,
        table_exist: bool = None,
    ):
        self.fields = fields
        self.table_code = table_code
        self.table_exist = table_exist

    def validate(self):
        if self.fields:
            for k in self.fields:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['fields'] = []
        if self.fields is not None:
            for k in self.fields:
                result['fields'].append(k.to_map() if k else None)
        if self.table_code is not None:
            result['tableCode'] = self.table_code
        if self.table_exist is not None:
            result['tableExist'] = self.table_exist
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.fields = []
        if m.get('fields') is not None:
            for k in m.get('fields'):
                temp_model = IsvMetadataQueryResponseBodyResultFields()
                self.fields.append(temp_model.from_map(k))
        if m.get('tableCode') is not None:
            self.table_code = m.get('tableCode')
        if m.get('tableExist') is not None:
            self.table_exist = m.get('tableExist')
        return self


class IsvMetadataQueryResponseBody(TeaModel):
    def __init__(
        self,
        result: IsvMetadataQueryResponseBodyResult = None,
        success: bool = None,
    ):
        self.result = result
        self.success = success

    def validate(self):
        if self.result:
            self.result.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.result is not None:
            result['result'] = self.result.to_map()
        if self.success is not None:
            result['success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('result') is not None:
            temp_model = IsvMetadataQueryResponseBodyResult()
            self.result = temp_model.from_map(m['result'])
        if m.get('success') is not None:
            self.success = m.get('success')
        return self


class IsvMetadataQueryResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: IsvMetadataQueryResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = IsvMetadataQueryResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListCollegeContactDeptTypeConfigHeaders(TeaModel):
    def __init__(
        self,
        common_headers: Dict[str, str] = None,
        x_acs_dingtalk_access_token: str = None,
    ):
        self.common_headers = common_headers
        self.x_acs_dingtalk_access_token = x_acs_dingtalk_access_token

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.common_headers is not None:
            result['commonHeaders'] = self.common_headers
        if self.x_acs_dingtalk_access_token is not None:
            result['x-acs-dingtalk-access-token'] = self.x_acs_dingtalk_access_token
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('commonHeaders') is not None:
            self.common_headers = m.get('commonHeaders')
        if m.get('x-acs-dingtalk-access-token') is not None:
            self.x_acs_dingtalk_access_token = m.get('x-acs-dingtalk-access-token')
        return self


class ListCollegeContactDeptTypeConfigRequest(TeaModel):
    def __init__(
        self,
        language: str = None,
    ):
        self.language = language

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.language is not None:
            result['language'] = self.language
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('language') is not None:
            self.language = m.get('language')
        return self


class ListCollegeContactDeptTypeConfigResponseBodyResult(TeaModel):
    def __init__(
        self,
        dept_type: str = None,
        name: str = None,
        user_def: bool = None,
    ):
        self.dept_type = dept_type
        self.name = name
        self.user_def = user_def

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dept_type is not None:
            result['deptType'] = self.dept_type
        if self.name is not None:
            result['name'] = self.name
        if self.user_def is not None:
            result['userDef'] = self.user_def
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('deptType') is not None:
            self.dept_type = m.get('deptType')
        if m.get('name') is not None:
            self.name = m.get('name')
        if m.get('userDef') is not None:
            self.user_def = m.get('userDef')
        return self


class ListCollegeContactDeptTypeConfigResponseBody(TeaModel):
    def __init__(
        self,
        result: List[ListCollegeContactDeptTypeConfigResponseBodyResult] = None,
        success: bool = None,
    ):
        self.result = result
        self.success = success

    def validate(self):
        if self.result:
            for k in self.result:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['result'] = []
        if self.result is not None:
            for k in self.result:
                result['result'].append(k.to_map() if k else None)
        if self.success is not None:
            result['success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.result = []
        if m.get('result') is not None:
            for k in m.get('result'):
                temp_model = ListCollegeContactDeptTypeConfigResponseBodyResult()
                self.result.append(temp_model.from_map(k))
        if m.get('success') is not None:
            self.success = m.get('success')
        return self


class ListCollegeContactDeptTypeConfigResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: ListCollegeContactDeptTypeConfigResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ListCollegeContactDeptTypeConfigResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListCollegeContactSceneStrusHeaders(TeaModel):
    def __init__(
        self,
        common_headers: Dict[str, str] = None,
        x_acs_dingtalk_access_token: str = None,
    ):
        self.common_headers = common_headers
        self.x_acs_dingtalk_access_token = x_acs_dingtalk_access_token

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.common_headers is not None:
            result['commonHeaders'] = self.common_headers
        if self.x_acs_dingtalk_access_token is not None:
            result['x-acs-dingtalk-access-token'] = self.x_acs_dingtalk_access_token
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('commonHeaders') is not None:
            self.common_headers = m.get('commonHeaders')
        if m.get('x-acs-dingtalk-access-token') is not None:
            self.x_acs_dingtalk_access_token = m.get('x-acs-dingtalk-access-token')
        return self


class ListCollegeContactSceneStrusRequest(TeaModel):
    def __init__(
        self,
        language: str = None,
    ):
        self.language = language

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.language is not None:
            result['language'] = self.language
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('language') is not None:
            self.language = m.get('language')
        return self


class ListCollegeContactSceneStrusResponseBodyResult(TeaModel):
    def __init__(
        self,
        enable: bool = None,
        has_stru_fixed_dept: bool = None,
        stru_brief: str = None,
        stru_id: int = None,
        stru_name: str = None,
        stru_type: str = None,
        student_dept_id: int = None,
        teacher_dept_id: int = None,
    ):
        self.enable = enable
        self.has_stru_fixed_dept = has_stru_fixed_dept
        self.stru_brief = stru_brief
        self.stru_id = stru_id
        self.stru_name = stru_name
        self.stru_type = stru_type
        self.student_dept_id = student_dept_id
        self.teacher_dept_id = teacher_dept_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.enable is not None:
            result['enable'] = self.enable
        if self.has_stru_fixed_dept is not None:
            result['hasStruFixedDept'] = self.has_stru_fixed_dept
        if self.stru_brief is not None:
            result['struBrief'] = self.stru_brief
        if self.stru_id is not None:
            result['struId'] = self.stru_id
        if self.stru_name is not None:
            result['struName'] = self.stru_name
        if self.stru_type is not None:
            result['struType'] = self.stru_type
        if self.student_dept_id is not None:
            result['studentDeptId'] = self.student_dept_id
        if self.teacher_dept_id is not None:
            result['teacherDeptId'] = self.teacher_dept_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('enable') is not None:
            self.enable = m.get('enable')
        if m.get('hasStruFixedDept') is not None:
            self.has_stru_fixed_dept = m.get('hasStruFixedDept')
        if m.get('struBrief') is not None:
            self.stru_brief = m.get('struBrief')
        if m.get('struId') is not None:
            self.stru_id = m.get('struId')
        if m.get('struName') is not None:
            self.stru_name = m.get('struName')
        if m.get('struType') is not None:
            self.stru_type = m.get('struType')
        if m.get('studentDeptId') is not None:
            self.student_dept_id = m.get('studentDeptId')
        if m.get('teacherDeptId') is not None:
            self.teacher_dept_id = m.get('teacherDeptId')
        return self


class ListCollegeContactSceneStrusResponseBody(TeaModel):
    def __init__(
        self,
        result: List[ListCollegeContactSceneStrusResponseBodyResult] = None,
        success: bool = None,
    ):
        self.result = result
        self.success = success

    def validate(self):
        if self.result:
            for k in self.result:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['result'] = []
        if self.result is not None:
            for k in self.result:
                result['result'].append(k.to_map() if k else None)
        if self.success is not None:
            result['success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.result = []
        if m.get('result') is not None:
            for k in m.get('result'):
                temp_model = ListCollegeContactSceneStrusResponseBodyResult()
                self.result.append(temp_model.from_map(k))
        if m.get('success') is not None:
            self.success = m.get('success')
        return self


class ListCollegeContactSceneStrusResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: ListCollegeContactSceneStrusResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ListCollegeContactSceneStrusResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListCollegeContactSubDeptsHeaders(TeaModel):
    def __init__(
        self,
        common_headers: Dict[str, str] = None,
        x_acs_dingtalk_access_token: str = None,
    ):
        self.common_headers = common_headers
        self.x_acs_dingtalk_access_token = x_acs_dingtalk_access_token

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.common_headers is not None:
            result['commonHeaders'] = self.common_headers
        if self.x_acs_dingtalk_access_token is not None:
            result['x-acs-dingtalk-access-token'] = self.x_acs_dingtalk_access_token
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('commonHeaders') is not None:
            self.common_headers = m.get('commonHeaders')
        if m.get('x-acs-dingtalk-access-token') is not None:
            self.x_acs_dingtalk_access_token = m.get('x-acs-dingtalk-access-token')
        return self


class ListCollegeContactSubDeptsRequest(TeaModel):
    def __init__(
        self,
        dept_id: int = None,
        language: str = None,
    ):
        # This parameter is required.
        self.dept_id = dept_id
        self.language = language

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dept_id is not None:
            result['deptId'] = self.dept_id
        if self.language is not None:
            result['language'] = self.language
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('deptId') is not None:
            self.dept_id = m.get('deptId')
        if m.get('language') is not None:
            self.language = m.get('language')
        return self


class ListCollegeContactSubDeptsResponseBodyResult(TeaModel):
    def __init__(
        self,
        auto_add_user: bool = None,
        create_dept_group: bool = None,
        dept_code: str = None,
        dept_id: int = None,
        dept_type: str = None,
        extension: str = None,
        from_union_org: bool = None,
        name: str = None,
        parent_id: int = None,
        source_identifier: str = None,
        stru_id: int = None,
        tags: str = None,
    ):
        self.auto_add_user = auto_add_user
        self.create_dept_group = create_dept_group
        self.dept_code = dept_code
        self.dept_id = dept_id
        self.dept_type = dept_type
        self.extension = extension
        self.from_union_org = from_union_org
        self.name = name
        self.parent_id = parent_id
        self.source_identifier = source_identifier
        self.stru_id = stru_id
        self.tags = tags

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.auto_add_user is not None:
            result['autoAddUser'] = self.auto_add_user
        if self.create_dept_group is not None:
            result['createDeptGroup'] = self.create_dept_group
        if self.dept_code is not None:
            result['deptCode'] = self.dept_code
        if self.dept_id is not None:
            result['deptId'] = self.dept_id
        if self.dept_type is not None:
            result['deptType'] = self.dept_type
        if self.extension is not None:
            result['extension'] = self.extension
        if self.from_union_org is not None:
            result['fromUnionOrg'] = self.from_union_org
        if self.name is not None:
            result['name'] = self.name
        if self.parent_id is not None:
            result['parentId'] = self.parent_id
        if self.source_identifier is not None:
            result['sourceIdentifier'] = self.source_identifier
        if self.stru_id is not None:
            result['struId'] = self.stru_id
        if self.tags is not None:
            result['tags'] = self.tags
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('autoAddUser') is not None:
            self.auto_add_user = m.get('autoAddUser')
        if m.get('createDeptGroup') is not None:
            self.create_dept_group = m.get('createDeptGroup')
        if m.get('deptCode') is not None:
            self.dept_code = m.get('deptCode')
        if m.get('deptId') is not None:
            self.dept_id = m.get('deptId')
        if m.get('deptType') is not None:
            self.dept_type = m.get('deptType')
        if m.get('extension') is not None:
            self.extension = m.get('extension')
        if m.get('fromUnionOrg') is not None:
            self.from_union_org = m.get('fromUnionOrg')
        if m.get('name') is not None:
            self.name = m.get('name')
        if m.get('parentId') is not None:
            self.parent_id = m.get('parentId')
        if m.get('sourceIdentifier') is not None:
            self.source_identifier = m.get('sourceIdentifier')
        if m.get('struId') is not None:
            self.stru_id = m.get('struId')
        if m.get('tags') is not None:
            self.tags = m.get('tags')
        return self


class ListCollegeContactSubDeptsResponseBody(TeaModel):
    def __init__(
        self,
        result: List[ListCollegeContactSubDeptsResponseBodyResult] = None,
        success: bool = None,
    ):
        self.result = result
        self.success = success

    def validate(self):
        if self.result:
            for k in self.result:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['result'] = []
        if self.result is not None:
            for k in self.result:
                result['result'].append(k.to_map() if k else None)
        if self.success is not None:
            result['success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.result = []
        if m.get('result') is not None:
            for k in m.get('result'):
                temp_model = ListCollegeContactSubDeptsResponseBodyResult()
                self.result.append(temp_model.from_map(k))
        if m.get('success') is not None:
            self.success = m.get('success')
        return self


class ListCollegeContactSubDeptsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: ListCollegeContactSubDeptsResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ListCollegeContactSubDeptsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListOrderHeaders(TeaModel):
    def __init__(
        self,
        common_headers: Dict[str, str] = None,
        x_acs_dingtalk_access_token: str = None,
    ):
        self.common_headers = common_headers
        self.x_acs_dingtalk_access_token = x_acs_dingtalk_access_token

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.common_headers is not None:
            result['commonHeaders'] = self.common_headers
        if self.x_acs_dingtalk_access_token is not None:
            result['x-acs-dingtalk-access-token'] = self.x_acs_dingtalk_access_token
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('commonHeaders') is not None:
            self.common_headers = m.get('commonHeaders')
        if m.get('x-acs-dingtalk-access-token') is not None:
            self.x_acs_dingtalk_access_token = m.get('x-acs-dingtalk-access-token')
        return self


class ListOrderRequest(TeaModel):
    def __init__(
        self,
        create_time_end: int = None,
        create_time_start: int = None,
        merchant_id: str = None,
        order_no: str = None,
        page_number: int = None,
        page_size: int = None,
        scene: int = None,
        status: int = None,
        trade_no: str = None,
        user_id: str = None,
    ):
        self.create_time_end = create_time_end
        self.create_time_start = create_time_start
        # This parameter is required.
        self.merchant_id = merchant_id
        self.order_no = order_no
        # This parameter is required.
        self.page_number = page_number
        # This parameter is required.
        self.page_size = page_size
        self.scene = scene
        self.status = status
        self.trade_no = trade_no
        self.user_id = user_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.create_time_end is not None:
            result['createTimeEnd'] = self.create_time_end
        if self.create_time_start is not None:
            result['createTimeStart'] = self.create_time_start
        if self.merchant_id is not None:
            result['merchantId'] = self.merchant_id
        if self.order_no is not None:
            result['orderNo'] = self.order_no
        if self.page_number is not None:
            result['pageNumber'] = self.page_number
        if self.page_size is not None:
            result['pageSize'] = self.page_size
        if self.scene is not None:
            result['scene'] = self.scene
        if self.status is not None:
            result['status'] = self.status
        if self.trade_no is not None:
            result['tradeNo'] = self.trade_no
        if self.user_id is not None:
            result['userId'] = self.user_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('createTimeEnd') is not None:
            self.create_time_end = m.get('createTimeEnd')
        if m.get('createTimeStart') is not None:
            self.create_time_start = m.get('createTimeStart')
        if m.get('merchantId') is not None:
            self.merchant_id = m.get('merchantId')
        if m.get('orderNo') is not None:
            self.order_no = m.get('orderNo')
        if m.get('pageNumber') is not None:
            self.page_number = m.get('pageNumber')
        if m.get('pageSize') is not None:
            self.page_size = m.get('pageSize')
        if m.get('scene') is not None:
            self.scene = m.get('scene')
        if m.get('status') is not None:
            self.status = m.get('status')
        if m.get('tradeNo') is not None:
            self.trade_no = m.get('tradeNo')
        if m.get('userId') is not None:
            self.user_id = m.get('userId')
        return self


class ListOrderResponseBodyList(TeaModel):
    def __init__(
        self,
        actual_amount: int = None,
        buyer_id: str = None,
        corp_id: str = None,
        create_time: int = None,
        end_time: int = None,
        order_no: str = None,
        pay_time: int = None,
        refund_no: str = None,
        scene: int = None,
        start_time: int = None,
        status: int = None,
        trade_no: str = None,
        user_id: str = None,
    ):
        # This parameter is required.
        self.actual_amount = actual_amount
        # This parameter is required.
        self.buyer_id = buyer_id
        # This parameter is required.
        self.corp_id = corp_id
        # This parameter is required.
        self.create_time = create_time
        # This parameter is required.
        self.end_time = end_time
        # This parameter is required.
        self.order_no = order_no
        # This parameter is required.
        self.pay_time = pay_time
        self.refund_no = refund_no
        # This parameter is required.
        self.scene = scene
        # This parameter is required.
        self.start_time = start_time
        # This parameter is required.
        self.status = status
        # This parameter is required.
        self.trade_no = trade_no
        # This parameter is required.
        self.user_id = user_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.actual_amount is not None:
            result['actualAmount'] = self.actual_amount
        if self.buyer_id is not None:
            result['buyerId'] = self.buyer_id
        if self.corp_id is not None:
            result['corpId'] = self.corp_id
        if self.create_time is not None:
            result['createTime'] = self.create_time
        if self.end_time is not None:
            result['endTime'] = self.end_time
        if self.order_no is not None:
            result['orderNo'] = self.order_no
        if self.pay_time is not None:
            result['payTime'] = self.pay_time
        if self.refund_no is not None:
            result['refundNo'] = self.refund_no
        if self.scene is not None:
            result['scene'] = self.scene
        if self.start_time is not None:
            result['startTime'] = self.start_time
        if self.status is not None:
            result['status'] = self.status
        if self.trade_no is not None:
            result['tradeNo'] = self.trade_no
        if self.user_id is not None:
            result['userId'] = self.user_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('actualAmount') is not None:
            self.actual_amount = m.get('actualAmount')
        if m.get('buyerId') is not None:
            self.buyer_id = m.get('buyerId')
        if m.get('corpId') is not None:
            self.corp_id = m.get('corpId')
        if m.get('createTime') is not None:
            self.create_time = m.get('createTime')
        if m.get('endTime') is not None:
            self.end_time = m.get('endTime')
        if m.get('orderNo') is not None:
            self.order_no = m.get('orderNo')
        if m.get('payTime') is not None:
            self.pay_time = m.get('payTime')
        if m.get('refundNo') is not None:
            self.refund_no = m.get('refundNo')
        if m.get('scene') is not None:
            self.scene = m.get('scene')
        if m.get('startTime') is not None:
            self.start_time = m.get('startTime')
        if m.get('status') is not None:
            self.status = m.get('status')
        if m.get('tradeNo') is not None:
            self.trade_no = m.get('tradeNo')
        if m.get('userId') is not None:
            self.user_id = m.get('userId')
        return self


class ListOrderResponseBody(TeaModel):
    def __init__(
        self,
        list: List[ListOrderResponseBodyList] = None,
        total: int = None,
    ):
        # This parameter is required.
        self.list = list
        self.total = total

    def validate(self):
        if self.list:
            for k in self.list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['list'] = []
        if self.list is not None:
            for k in self.list:
                result['list'].append(k.to_map() if k else None)
        if self.total is not None:
            result['total'] = self.total
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.list = []
        if m.get('list') is not None:
            for k in m.get('list'):
                temp_model = ListOrderResponseBodyList()
                self.list.append(temp_model.from_map(k))
        if m.get('total') is not None:
            self.total = m.get('total')
        return self


class ListOrderResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: ListOrderResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ListOrderResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class MoveStudentHeaders(TeaModel):
    def __init__(
        self,
        common_headers: Dict[str, str] = None,
        x_acs_dingtalk_access_token: str = None,
    ):
        self.common_headers = common_headers
        self.x_acs_dingtalk_access_token = x_acs_dingtalk_access_token

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.common_headers is not None:
            result['commonHeaders'] = self.common_headers
        if self.x_acs_dingtalk_access_token is not None:
            result['x-acs-dingtalk-access-token'] = self.x_acs_dingtalk_access_token
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('commonHeaders') is not None:
            self.common_headers = m.get('commonHeaders')
        if m.get('x-acs-dingtalk-access-token') is not None:
            self.x_acs_dingtalk_access_token = m.get('x-acs-dingtalk-access-token')
        return self


class MoveStudentRequest(TeaModel):
    def __init__(
        self,
        operator: str = None,
        origin_class_id: int = None,
        target_class_id: int = None,
        user_id: str = None,
    ):
        # This parameter is required.
        self.operator = operator
        # This parameter is required.
        self.origin_class_id = origin_class_id
        # This parameter is required.
        self.target_class_id = target_class_id
        # This parameter is required.
        self.user_id = user_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.operator is not None:
            result['operator'] = self.operator
        if self.origin_class_id is not None:
            result['originClassId'] = self.origin_class_id
        if self.target_class_id is not None:
            result['targetClassId'] = self.target_class_id
        if self.user_id is not None:
            result['userId'] = self.user_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('operator') is not None:
            self.operator = m.get('operator')
        if m.get('originClassId') is not None:
            self.origin_class_id = m.get('originClassId')
        if m.get('targetClassId') is not None:
            self.target_class_id = m.get('targetClassId')
        if m.get('userId') is not None:
            self.user_id = m.get('userId')
        return self


class MoveStudentResponseBody(TeaModel):
    def __init__(
        self,
        success: bool = None,
    ):
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.success is not None:
            result['success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('success') is not None:
            self.success = m.get('success')
        return self


class MoveStudentResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: MoveStudentResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = MoveStudentResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class OpenKitHeaders(TeaModel):
    def __init__(
        self,
        common_headers: Dict[str, str] = None,
        x_acs_dingtalk_access_token: str = None,
    ):
        self.common_headers = common_headers
        self.x_acs_dingtalk_access_token = x_acs_dingtalk_access_token

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.common_headers is not None:
            result['commonHeaders'] = self.common_headers
        if self.x_acs_dingtalk_access_token is not None:
            result['x-acs-dingtalk-access-token'] = self.x_acs_dingtalk_access_token
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('commonHeaders') is not None:
            self.common_headers = m.get('commonHeaders')
        if m.get('x-acs-dingtalk-access-token') is not None:
            self.x_acs_dingtalk_access_token = m.get('x-acs-dingtalk-access-token')
        return self


class OpenKitRequest(TeaModel):
    def __init__(
        self,
        attributes: str = None,
        corp_id: str = None,
        isv_code: str = None,
        isv_product_scene: str = None,
        open_end_time: int = None,
        open_start_time: int = None,
        open_user_id: str = None,
    ):
        self.attributes = attributes
        self.corp_id = corp_id
        self.isv_code = isv_code
        self.isv_product_scene = isv_product_scene
        self.open_end_time = open_end_time
        self.open_start_time = open_start_time
        self.open_user_id = open_user_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.attributes is not None:
            result['attributes'] = self.attributes
        if self.corp_id is not None:
            result['corpId'] = self.corp_id
        if self.isv_code is not None:
            result['isvCode'] = self.isv_code
        if self.isv_product_scene is not None:
            result['isvProductScene'] = self.isv_product_scene
        if self.open_end_time is not None:
            result['openEndTime'] = self.open_end_time
        if self.open_start_time is not None:
            result['openStartTime'] = self.open_start_time
        if self.open_user_id is not None:
            result['openUserId'] = self.open_user_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('attributes') is not None:
            self.attributes = m.get('attributes')
        if m.get('corpId') is not None:
            self.corp_id = m.get('corpId')
        if m.get('isvCode') is not None:
            self.isv_code = m.get('isvCode')
        if m.get('isvProductScene') is not None:
            self.isv_product_scene = m.get('isvProductScene')
        if m.get('openEndTime') is not None:
            self.open_end_time = m.get('openEndTime')
        if m.get('openStartTime') is not None:
            self.open_start_time = m.get('openStartTime')
        if m.get('openUserId') is not None:
            self.open_user_id = m.get('openUserId')
        return self


class OpenKitResponseBody(TeaModel):
    def __init__(
        self,
        result: bool = None,
        success: bool = None,
    ):
        self.result = result
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.result is not None:
            result['result'] = self.result
        if self.success is not None:
            result['success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('result') is not None:
            self.result = m.get('result')
        if m.get('success') is not None:
            self.success = m.get('success')
        return self


class OpenKitResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: OpenKitResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = OpenKitResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class OrderInfoHeaders(TeaModel):
    def __init__(
        self,
        common_headers: Dict[str, str] = None,
        x_acs_dingtalk_access_token: str = None,
    ):
        self.common_headers = common_headers
        self.x_acs_dingtalk_access_token = x_acs_dingtalk_access_token

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.common_headers is not None:
            result['commonHeaders'] = self.common_headers
        if self.x_acs_dingtalk_access_token is not None:
            result['x-acs-dingtalk-access-token'] = self.x_acs_dingtalk_access_token
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('commonHeaders') is not None:
            self.common_headers = m.get('commonHeaders')
        if m.get('x-acs-dingtalk-access-token') is not None:
            self.x_acs_dingtalk_access_token = m.get('x-acs-dingtalk-access-token')
        return self


class OrderInfoRequest(TeaModel):
    def __init__(
        self,
        order_no: str = None,
    ):
        self.order_no = order_no

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.order_no is not None:
            result['orderNo'] = self.order_no
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('orderNo') is not None:
            self.order_no = m.get('orderNo')
        return self


class OrderInfoResponseBodyResultItemList(TeaModel):
    def __init__(
        self,
        item_name: str = None,
        item_num: str = None,
    ):
        # This parameter is required.
        self.item_name = item_name
        self.item_num = item_num

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.item_name is not None:
            result['itemName'] = self.item_name
        if self.item_num is not None:
            result['itemNum'] = self.item_num
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('itemName') is not None:
            self.item_name = m.get('itemName')
        if m.get('itemNum') is not None:
            self.item_num = m.get('itemNum')
        return self


class OrderInfoResponseBodyResult(TeaModel):
    def __init__(
        self,
        address: str = None,
        item_list: List[OrderInfoResponseBodyResultItemList] = None,
        order_no: str = None,
        receiver_phone_suffix: str = None,
        shop_name: str = None,
        user_id: int = None,
    ):
        self.address = address
        self.item_list = item_list
        self.order_no = order_no
        self.receiver_phone_suffix = receiver_phone_suffix
        self.shop_name = shop_name
        self.user_id = user_id

    def validate(self):
        if self.item_list:
            for k in self.item_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.address is not None:
            result['address'] = self.address
        result['itemList'] = []
        if self.item_list is not None:
            for k in self.item_list:
                result['itemList'].append(k.to_map() if k else None)
        if self.order_no is not None:
            result['orderNo'] = self.order_no
        if self.receiver_phone_suffix is not None:
            result['receiverPhoneSuffix'] = self.receiver_phone_suffix
        if self.shop_name is not None:
            result['shopName'] = self.shop_name
        if self.user_id is not None:
            result['userId'] = self.user_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('address') is not None:
            self.address = m.get('address')
        self.item_list = []
        if m.get('itemList') is not None:
            for k in m.get('itemList'):
                temp_model = OrderInfoResponseBodyResultItemList()
                self.item_list.append(temp_model.from_map(k))
        if m.get('orderNo') is not None:
            self.order_no = m.get('orderNo')
        if m.get('receiverPhoneSuffix') is not None:
            self.receiver_phone_suffix = m.get('receiverPhoneSuffix')
        if m.get('shopName') is not None:
            self.shop_name = m.get('shopName')
        if m.get('userId') is not None:
            self.user_id = m.get('userId')
        return self


class OrderInfoResponseBody(TeaModel):
    def __init__(
        self,
        result: OrderInfoResponseBodyResult = None,
        success: bool = None,
    ):
        self.result = result
        self.success = success

    def validate(self):
        if self.result:
            self.result.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.result is not None:
            result['result'] = self.result.to_map()
        if self.success is not None:
            result['success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('result') is not None:
            temp_model = OrderInfoResponseBodyResult()
            self.result = temp_model.from_map(m['result'])
        if m.get('success') is not None:
            self.success = m.get('success')
        return self


class OrderInfoResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: OrderInfoResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = OrderInfoResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class PageQueryClassCourseHeaders(TeaModel):
    def __init__(
        self,
        common_headers: Dict[str, str] = None,
        x_acs_dingtalk_access_token: str = None,
    ):
        self.common_headers = common_headers
        self.x_acs_dingtalk_access_token = x_acs_dingtalk_access_token

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.common_headers is not None:
            result['commonHeaders'] = self.common_headers
        if self.x_acs_dingtalk_access_token is not None:
            result['x-acs-dingtalk-access-token'] = self.x_acs_dingtalk_access_token
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('commonHeaders') is not None:
            self.common_headers = m.get('commonHeaders')
        if m.get('x-acs-dingtalk-access-token') is not None:
            self.x_acs_dingtalk_access_token = m.get('x-acs-dingtalk-access-token')
        return self


class PageQueryClassCourseRequest(TeaModel):
    def __init__(
        self,
        class_id: str = None,
        corp_id: str = None,
        end_course_date: int = None,
        isv_code: str = None,
        page_number: int = None,
        page_size: int = None,
        start_course_date: int = None,
    ):
        self.class_id = class_id
        self.corp_id = corp_id
        self.end_course_date = end_course_date
        self.isv_code = isv_code
        self.page_number = page_number
        self.page_size = page_size
        self.start_course_date = start_course_date

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.class_id is not None:
            result['classId'] = self.class_id
        if self.corp_id is not None:
            result['corpId'] = self.corp_id
        if self.end_course_date is not None:
            result['endCourseDate'] = self.end_course_date
        if self.isv_code is not None:
            result['isvCode'] = self.isv_code
        if self.page_number is not None:
            result['pageNumber'] = self.page_number
        if self.page_size is not None:
            result['pageSize'] = self.page_size
        if self.start_course_date is not None:
            result['startCourseDate'] = self.start_course_date
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('classId') is not None:
            self.class_id = m.get('classId')
        if m.get('corpId') is not None:
            self.corp_id = m.get('corpId')
        if m.get('endCourseDate') is not None:
            self.end_course_date = m.get('endCourseDate')
        if m.get('isvCode') is not None:
            self.isv_code = m.get('isvCode')
        if m.get('pageNumber') is not None:
            self.page_number = m.get('pageNumber')
        if m.get('pageSize') is not None:
            self.page_size = m.get('pageSize')
        if m.get('startCourseDate') is not None:
            self.start_course_date = m.get('startCourseDate')
        return self


class PageQueryClassCourseResponseBodyResult(TeaModel):
    def __init__(
        self,
        attributes: str = None,
        class_id: str = None,
        class_name: str = None,
        class_room_id: str = None,
        class_room_name: str = None,
        class_type: int = None,
        corp_id: str = None,
        course_code: str = None,
        course_date: str = None,
        course_name: str = None,
        course_week: int = None,
        end_time: str = None,
        isv_code: str = None,
        isv_course_id: str = None,
        memo: str = None,
        school_year: str = None,
        semester: int = None,
        start_time: str = None,
        status: int = None,
        teach_week: int = None,
        timeslot_name: str = None,
        timeslot_num: int = None,
        type: int = None,
    ):
        self.attributes = attributes
        self.class_id = class_id
        self.class_name = class_name
        self.class_room_id = class_room_id
        self.class_room_name = class_room_name
        self.class_type = class_type
        self.corp_id = corp_id
        self.course_code = course_code
        self.course_date = course_date
        self.course_name = course_name
        self.course_week = course_week
        self.end_time = end_time
        self.isv_code = isv_code
        self.isv_course_id = isv_course_id
        self.memo = memo
        self.school_year = school_year
        self.semester = semester
        self.start_time = start_time
        self.status = status
        self.teach_week = teach_week
        self.timeslot_name = timeslot_name
        self.timeslot_num = timeslot_num
        self.type = type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.attributes is not None:
            result['attributes'] = self.attributes
        if self.class_id is not None:
            result['classId'] = self.class_id
        if self.class_name is not None:
            result['className'] = self.class_name
        if self.class_room_id is not None:
            result['classRoomId'] = self.class_room_id
        if self.class_room_name is not None:
            result['classRoomName'] = self.class_room_name
        if self.class_type is not None:
            result['classType'] = self.class_type
        if self.corp_id is not None:
            result['corpId'] = self.corp_id
        if self.course_code is not None:
            result['courseCode'] = self.course_code
        if self.course_date is not None:
            result['courseDate'] = self.course_date
        if self.course_name is not None:
            result['courseName'] = self.course_name
        if self.course_week is not None:
            result['courseWeek'] = self.course_week
        if self.end_time is not None:
            result['endTime'] = self.end_time
        if self.isv_code is not None:
            result['isvCode'] = self.isv_code
        if self.isv_course_id is not None:
            result['isvCourseId'] = self.isv_course_id
        if self.memo is not None:
            result['memo'] = self.memo
        if self.school_year is not None:
            result['schoolYear'] = self.school_year
        if self.semester is not None:
            result['semester'] = self.semester
        if self.start_time is not None:
            result['startTime'] = self.start_time
        if self.status is not None:
            result['status'] = self.status
        if self.teach_week is not None:
            result['teachWeek'] = self.teach_week
        if self.timeslot_name is not None:
            result['timeslotName'] = self.timeslot_name
        if self.timeslot_num is not None:
            result['timeslotNum'] = self.timeslot_num
        if self.type is not None:
            result['type'] = self.type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('attributes') is not None:
            self.attributes = m.get('attributes')
        if m.get('classId') is not None:
            self.class_id = m.get('classId')
        if m.get('className') is not None:
            self.class_name = m.get('className')
        if m.get('classRoomId') is not None:
            self.class_room_id = m.get('classRoomId')
        if m.get('classRoomName') is not None:
            self.class_room_name = m.get('classRoomName')
        if m.get('classType') is not None:
            self.class_type = m.get('classType')
        if m.get('corpId') is not None:
            self.corp_id = m.get('corpId')
        if m.get('courseCode') is not None:
            self.course_code = m.get('courseCode')
        if m.get('courseDate') is not None:
            self.course_date = m.get('courseDate')
        if m.get('courseName') is not None:
            self.course_name = m.get('courseName')
        if m.get('courseWeek') is not None:
            self.course_week = m.get('courseWeek')
        if m.get('endTime') is not None:
            self.end_time = m.get('endTime')
        if m.get('isvCode') is not None:
            self.isv_code = m.get('isvCode')
        if m.get('isvCourseId') is not None:
            self.isv_course_id = m.get('isvCourseId')
        if m.get('memo') is not None:
            self.memo = m.get('memo')
        if m.get('schoolYear') is not None:
            self.school_year = m.get('schoolYear')
        if m.get('semester') is not None:
            self.semester = m.get('semester')
        if m.get('startTime') is not None:
            self.start_time = m.get('startTime')
        if m.get('status') is not None:
            self.status = m.get('status')
        if m.get('teachWeek') is not None:
            self.teach_week = m.get('teachWeek')
        if m.get('timeslotName') is not None:
            self.timeslot_name = m.get('timeslotName')
        if m.get('timeslotNum') is not None:
            self.timeslot_num = m.get('timeslotNum')
        if m.get('type') is not None:
            self.type = m.get('type')
        return self


class PageQueryClassCourseResponseBody(TeaModel):
    def __init__(
        self,
        result: List[PageQueryClassCourseResponseBodyResult] = None,
        success: bool = None,
    ):
        self.result = result
        self.success = success

    def validate(self):
        if self.result:
            for k in self.result:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['result'] = []
        if self.result is not None:
            for k in self.result:
                result['result'].append(k.to_map() if k else None)
        if self.success is not None:
            result['success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.result = []
        if m.get('result') is not None:
            for k in m.get('result'):
                temp_model = PageQueryClassCourseResponseBodyResult()
                self.result.append(temp_model.from_map(k))
        if m.get('success') is not None:
            self.success = m.get('success')
        return self


class PageQueryClassCourseResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: PageQueryClassCourseResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = PageQueryClassCourseResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class PageQueryDevicesHeaders(TeaModel):
    def __init__(
        self,
        common_headers: Dict[str, str] = None,
        x_acs_dingtalk_access_token: str = None,
    ):
        self.common_headers = common_headers
        self.x_acs_dingtalk_access_token = x_acs_dingtalk_access_token

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.common_headers is not None:
            result['commonHeaders'] = self.common_headers
        if self.x_acs_dingtalk_access_token is not None:
            result['x-acs-dingtalk-access-token'] = self.x_acs_dingtalk_access_token
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('commonHeaders') is not None:
            self.common_headers = m.get('commonHeaders')
        if m.get('x-acs-dingtalk-access-token') is not None:
            self.x_acs_dingtalk_access_token = m.get('x-acs-dingtalk-access-token')
        return self


class PageQueryDevicesRequest(TeaModel):
    def __init__(
        self,
        max_results: int = None,
        next_token: str = None,
        type: str = None,
    ):
        # This parameter is required.
        self.max_results = max_results
        # This parameter is required.
        self.next_token = next_token
        # This parameter is required.
        self.type = type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.max_results is not None:
            result['maxResults'] = self.max_results
        if self.next_token is not None:
            result['nextToken'] = self.next_token
        if self.type is not None:
            result['type'] = self.type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('maxResults') is not None:
            self.max_results = m.get('maxResults')
        if m.get('nextToken') is not None:
            self.next_token = m.get('nextToken')
        if m.get('type') is not None:
            self.type = m.get('type')
        return self


class PageQueryDevicesResponseBodyList(TeaModel):
    def __init__(
        self,
        gmt_expiry: int = None,
        model: str = None,
        name: str = None,
        sn: str = None,
        type: str = None,
    ):
        self.gmt_expiry = gmt_expiry
        self.model = model
        self.name = name
        self.sn = sn
        self.type = type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.gmt_expiry is not None:
            result['gmtExpiry'] = self.gmt_expiry
        if self.model is not None:
            result['model'] = self.model
        if self.name is not None:
            result['name'] = self.name
        if self.sn is not None:
            result['sn'] = self.sn
        if self.type is not None:
            result['type'] = self.type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('gmtExpiry') is not None:
            self.gmt_expiry = m.get('gmtExpiry')
        if m.get('model') is not None:
            self.model = m.get('model')
        if m.get('name') is not None:
            self.name = m.get('name')
        if m.get('sn') is not None:
            self.sn = m.get('sn')
        if m.get('type') is not None:
            self.type = m.get('type')
        return self


class PageQueryDevicesResponseBody(TeaModel):
    def __init__(
        self,
        list: List[PageQueryDevicesResponseBodyList] = None,
        next_token: str = None,
        total_count: int = None,
    ):
        self.list = list
        self.next_token = next_token
        self.total_count = total_count

    def validate(self):
        if self.list:
            for k in self.list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['list'] = []
        if self.list is not None:
            for k in self.list:
                result['list'].append(k.to_map() if k else None)
        if self.next_token is not None:
            result['nextToken'] = self.next_token
        if self.total_count is not None:
            result['totalCount'] = self.total_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.list = []
        if m.get('list') is not None:
            for k in m.get('list'):
                temp_model = PageQueryDevicesResponseBodyList()
                self.list.append(temp_model.from_map(k))
        if m.get('nextToken') is not None:
            self.next_token = m.get('nextToken')
        if m.get('totalCount') is not None:
            self.total_count = m.get('totalCount')
        return self


class PageQueryDevicesResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: PageQueryDevicesResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = PageQueryDevicesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class PageQueryKitOpenRecordHeaders(TeaModel):
    def __init__(
        self,
        common_headers: Dict[str, str] = None,
        x_acs_dingtalk_access_token: str = None,
    ):
        self.common_headers = common_headers
        self.x_acs_dingtalk_access_token = x_acs_dingtalk_access_token

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.common_headers is not None:
            result['commonHeaders'] = self.common_headers
        if self.x_acs_dingtalk_access_token is not None:
            result['x-acs-dingtalk-access-token'] = self.x_acs_dingtalk_access_token
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('commonHeaders') is not None:
            self.common_headers = m.get('commonHeaders')
        if m.get('x-acs-dingtalk-access-token') is not None:
            self.x_acs_dingtalk_access_token = m.get('x-acs-dingtalk-access-token')
        return self


class PageQueryKitOpenRecordRequest(TeaModel):
    def __init__(
        self,
        isv_code: str = None,
        isv_product_scene: str = None,
        page_number: int = None,
        page_size: int = None,
    ):
        self.isv_code = isv_code
        self.isv_product_scene = isv_product_scene
        self.page_number = page_number
        self.page_size = page_size

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.isv_code is not None:
            result['isvCode'] = self.isv_code
        if self.isv_product_scene is not None:
            result['isvProductScene'] = self.isv_product_scene
        if self.page_number is not None:
            result['pageNumber'] = self.page_number
        if self.page_size is not None:
            result['pageSize'] = self.page_size
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('isvCode') is not None:
            self.isv_code = m.get('isvCode')
        if m.get('isvProductScene') is not None:
            self.isv_product_scene = m.get('isvProductScene')
        if m.get('pageNumber') is not None:
            self.page_number = m.get('pageNumber')
        if m.get('pageSize') is not None:
            self.page_size = m.get('pageSize')
        return self


class PageQueryKitOpenRecordResponseBodyResult(TeaModel):
    def __init__(
        self,
        attributes: str = None,
        corp_id: str = None,
        isv_code: str = None,
        isv_product_scene: str = None,
        open_end_time: str = None,
        open_start_time: str = None,
        open_user_id: str = None,
    ):
        self.attributes = attributes
        self.corp_id = corp_id
        self.isv_code = isv_code
        self.isv_product_scene = isv_product_scene
        self.open_end_time = open_end_time
        self.open_start_time = open_start_time
        self.open_user_id = open_user_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.attributes is not None:
            result['attributes'] = self.attributes
        if self.corp_id is not None:
            result['corpId'] = self.corp_id
        if self.isv_code is not None:
            result['isvCode'] = self.isv_code
        if self.isv_product_scene is not None:
            result['isvProductScene'] = self.isv_product_scene
        if self.open_end_time is not None:
            result['openEndTime'] = self.open_end_time
        if self.open_start_time is not None:
            result['openStartTime'] = self.open_start_time
        if self.open_user_id is not None:
            result['openUserId'] = self.open_user_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('attributes') is not None:
            self.attributes = m.get('attributes')
        if m.get('corpId') is not None:
            self.corp_id = m.get('corpId')
        if m.get('isvCode') is not None:
            self.isv_code = m.get('isvCode')
        if m.get('isvProductScene') is not None:
            self.isv_product_scene = m.get('isvProductScene')
        if m.get('openEndTime') is not None:
            self.open_end_time = m.get('openEndTime')
        if m.get('openStartTime') is not None:
            self.open_start_time = m.get('openStartTime')
        if m.get('openUserId') is not None:
            self.open_user_id = m.get('openUserId')
        return self


class PageQueryKitOpenRecordResponseBody(TeaModel):
    def __init__(
        self,
        result: List[PageQueryKitOpenRecordResponseBodyResult] = None,
        success: bool = None,
    ):
        self.result = result
        self.success = success

    def validate(self):
        if self.result:
            for k in self.result:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['result'] = []
        if self.result is not None:
            for k in self.result:
                result['result'].append(k.to_map() if k else None)
        if self.success is not None:
            result['success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.result = []
        if m.get('result') is not None:
            for k in m.get('result'):
                temp_model = PageQueryKitOpenRecordResponseBodyResult()
                self.result.append(temp_model.from_map(k))
        if m.get('success') is not None:
            self.success = m.get('success')
        return self


class PageQueryKitOpenRecordResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: PageQueryKitOpenRecordResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = PageQueryKitOpenRecordResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class PayOrderHeaders(TeaModel):
    def __init__(
        self,
        common_headers: Dict[str, str] = None,
        x_acs_dingtalk_access_token: str = None,
    ):
        self.common_headers = common_headers
        self.x_acs_dingtalk_access_token = x_acs_dingtalk_access_token

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.common_headers is not None:
            result['commonHeaders'] = self.common_headers
        if self.x_acs_dingtalk_access_token is not None:
            result['x-acs-dingtalk-access-token'] = self.x_acs_dingtalk_access_token
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('commonHeaders') is not None:
            self.common_headers = m.get('commonHeaders')
        if m.get('x-acs-dingtalk-access-token') is not None:
            self.x_acs_dingtalk_access_token = m.get('x-acs-dingtalk-access-token')
        return self


class PayOrderRequest(TeaModel):
    def __init__(
        self,
        face_id: str = None,
        order_no: str = None,
        signature: str = None,
        sn: str = None,
        timestamp: int = None,
        user_id: str = None,
        version: str = None,
    ):
        # This parameter is required.
        self.face_id = face_id
        # This parameter is required.
        self.order_no = order_no
        self.signature = signature
        # This parameter is required.
        self.sn = sn
        self.timestamp = timestamp
        # This parameter is required.
        self.user_id = user_id
        self.version = version

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.face_id is not None:
            result['faceId'] = self.face_id
        if self.order_no is not None:
            result['orderNo'] = self.order_no
        if self.signature is not None:
            result['signature'] = self.signature
        if self.sn is not None:
            result['sn'] = self.sn
        if self.timestamp is not None:
            result['timestamp'] = self.timestamp
        if self.user_id is not None:
            result['userId'] = self.user_id
        if self.version is not None:
            result['version'] = self.version
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('faceId') is not None:
            self.face_id = m.get('faceId')
        if m.get('orderNo') is not None:
            self.order_no = m.get('orderNo')
        if m.get('signature') is not None:
            self.signature = m.get('signature')
        if m.get('sn') is not None:
            self.sn = m.get('sn')
        if m.get('timestamp') is not None:
            self.timestamp = m.get('timestamp')
        if m.get('userId') is not None:
            self.user_id = m.get('userId')
        if m.get('version') is not None:
            self.version = m.get('version')
        return self


class PayOrderResponseBody(TeaModel):
    def __init__(
        self,
        success: bool = None,
    ):
        # This parameter is required.
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.success is not None:
            result['success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('success') is not None:
            self.success = m.get('success')
        return self


class PayOrderResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: PayOrderResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = PayOrderResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class PollingConfirmStatusHeaders(TeaModel):
    def __init__(
        self,
        common_headers: Dict[str, str] = None,
        x_acs_dingtalk_access_token: str = None,
    ):
        self.common_headers = common_headers
        self.x_acs_dingtalk_access_token = x_acs_dingtalk_access_token

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.common_headers is not None:
            result['commonHeaders'] = self.common_headers
        if self.x_acs_dingtalk_access_token is not None:
            result['x-acs-dingtalk-access-token'] = self.x_acs_dingtalk_access_token
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('commonHeaders') is not None:
            self.common_headers = m.get('commonHeaders')
        if m.get('x-acs-dingtalk-access-token') is not None:
            self.x_acs_dingtalk_access_token = m.get('x-acs-dingtalk-access-token')
        return self


class PollingConfirmStatusRequest(TeaModel):
    def __init__(
        self,
        course_code: str = None,
        ext: str = None,
        isv_code: str = None,
        op_user_id: str = None,
    ):
        self.course_code = course_code
        self.ext = ext
        self.isv_code = isv_code
        self.op_user_id = op_user_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.course_code is not None:
            result['courseCode'] = self.course_code
        if self.ext is not None:
            result['ext'] = self.ext
        if self.isv_code is not None:
            result['isvCode'] = self.isv_code
        if self.op_user_id is not None:
            result['opUserId'] = self.op_user_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('courseCode') is not None:
            self.course_code = m.get('courseCode')
        if m.get('ext') is not None:
            self.ext = m.get('ext')
        if m.get('isvCode') is not None:
            self.isv_code = m.get('isvCode')
        if m.get('opUserId') is not None:
            self.op_user_id = m.get('opUserId')
        return self


class PollingConfirmStatusResponseBodyUniversityPollingCourseStatusResponseLivePlayInfoList(TeaModel):
    def __init__(
        self,
        live_input_url: str = None,
        live_output_url: str = None,
        live_type: int = None,
        replay_url: str = None,
    ):
        # This parameter is required.
        self.live_input_url = live_input_url
        # This parameter is required.
        self.live_output_url = live_output_url
        # This parameter is required.
        self.live_type = live_type
        # This parameter is required.
        self.replay_url = replay_url

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.live_input_url is not None:
            result['liveInputUrl'] = self.live_input_url
        if self.live_output_url is not None:
            result['liveOutputUrl'] = self.live_output_url
        if self.live_type is not None:
            result['liveType'] = self.live_type
        if self.replay_url is not None:
            result['replayUrl'] = self.replay_url
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('liveInputUrl') is not None:
            self.live_input_url = m.get('liveInputUrl')
        if m.get('liveOutputUrl') is not None:
            self.live_output_url = m.get('liveOutputUrl')
        if m.get('liveType') is not None:
            self.live_type = m.get('liveType')
        if m.get('replayUrl') is not None:
            self.replay_url = m.get('replayUrl')
        return self


class PollingConfirmStatusResponseBodyUniversityPollingCourseStatusResponse(TeaModel):
    def __init__(
        self,
        confirm_status: bool = None,
        course_code: str = None,
        live_play_info_list: List[PollingConfirmStatusResponseBodyUniversityPollingCourseStatusResponseLivePlayInfoList] = None,
    ):
        # This parameter is required.
        self.confirm_status = confirm_status
        # This parameter is required.
        self.course_code = course_code
        # This parameter is required.
        self.live_play_info_list = live_play_info_list

    def validate(self):
        if self.live_play_info_list:
            for k in self.live_play_info_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.confirm_status is not None:
            result['confirmStatus'] = self.confirm_status
        if self.course_code is not None:
            result['courseCode'] = self.course_code
        result['livePlayInfoList'] = []
        if self.live_play_info_list is not None:
            for k in self.live_play_info_list:
                result['livePlayInfoList'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('confirmStatus') is not None:
            self.confirm_status = m.get('confirmStatus')
        if m.get('courseCode') is not None:
            self.course_code = m.get('courseCode')
        self.live_play_info_list = []
        if m.get('livePlayInfoList') is not None:
            for k in m.get('livePlayInfoList'):
                temp_model = PollingConfirmStatusResponseBodyUniversityPollingCourseStatusResponseLivePlayInfoList()
                self.live_play_info_list.append(temp_model.from_map(k))
        return self


class PollingConfirmStatusResponseBody(TeaModel):
    def __init__(
        self,
        university_polling_course_status_response: PollingConfirmStatusResponseBodyUniversityPollingCourseStatusResponse = None,
    ):
        # This parameter is required.
        self.university_polling_course_status_response = university_polling_course_status_response

    def validate(self):
        if self.university_polling_course_status_response:
            self.university_polling_course_status_response.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.university_polling_course_status_response is not None:
            result['universityPollingCourseStatusResponse'] = self.university_polling_course_status_response.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('universityPollingCourseStatusResponse') is not None:
            temp_model = PollingConfirmStatusResponseBodyUniversityPollingCourseStatusResponse()
            self.university_polling_course_status_response = temp_model.from_map(m['universityPollingCourseStatusResponse'])
        return self


class PollingConfirmStatusResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: PollingConfirmStatusResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = PollingConfirmStatusResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class PreDialHeaders(TeaModel):
    def __init__(
        self,
        common_headers: Dict[str, str] = None,
        x_acs_dingtalk_access_token: str = None,
    ):
        self.common_headers = common_headers
        self.x_acs_dingtalk_access_token = x_acs_dingtalk_access_token

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.common_headers is not None:
            result['commonHeaders'] = self.common_headers
        if self.x_acs_dingtalk_access_token is not None:
            result['x-acs-dingtalk-access-token'] = self.x_acs_dingtalk_access_token
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('commonHeaders') is not None:
            self.common_headers = m.get('commonHeaders')
        if m.get('x-acs-dingtalk-access-token') is not None:
            self.x_acs_dingtalk_access_token = m.get('x-acs-dingtalk-access-token')
        return self


class PreDialRequest(TeaModel):
    def __init__(
        self,
        caller_user_id: str = None,
        receiver_user_id: str = None,
        sn: str = None,
        type: str = None,
    ):
        # This parameter is required.
        self.caller_user_id = caller_user_id
        # This parameter is required.
        self.receiver_user_id = receiver_user_id
        # This parameter is required.
        self.sn = sn
        # This parameter is required.
        self.type = type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.caller_user_id is not None:
            result['callerUserId'] = self.caller_user_id
        if self.receiver_user_id is not None:
            result['receiverUserId'] = self.receiver_user_id
        if self.sn is not None:
            result['sn'] = self.sn
        if self.type is not None:
            result['type'] = self.type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('callerUserId') is not None:
            self.caller_user_id = m.get('callerUserId')
        if m.get('receiverUserId') is not None:
            self.receiver_user_id = m.get('receiverUserId')
        if m.get('sn') is not None:
            self.sn = m.get('sn')
        if m.get('type') is not None:
            self.type = m.get('type')
        return self


class PreDialResponseBody(TeaModel):
    def __init__(
        self,
        result: bool = None,
    ):
        self.result = result

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.result is not None:
            result['result'] = self.result
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('result') is not None:
            self.result = m.get('result')
        return self


class PreDialResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: PreDialResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = PreDialResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ProvidePointHeaders(TeaModel):
    def __init__(
        self,
        common_headers: Dict[str, str] = None,
        x_acs_dingtalk_access_token: str = None,
    ):
        self.common_headers = common_headers
        self.x_acs_dingtalk_access_token = x_acs_dingtalk_access_token

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.common_headers is not None:
            result['commonHeaders'] = self.common_headers
        if self.x_acs_dingtalk_access_token is not None:
            result['x-acs-dingtalk-access-token'] = self.x_acs_dingtalk_access_token
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('commonHeaders') is not None:
            self.common_headers = m.get('commonHeaders')
        if m.get('x-acs-dingtalk-access-token') is not None:
            self.x_acs_dingtalk_access_token = m.get('x-acs-dingtalk-access-token')
        return self


class ProvidePointRequest(TeaModel):
    def __init__(
        self,
        action_code: str = None,
        biz_id: str = None,
        point_type: str = None,
    ):
        # This parameter is required.
        self.action_code = action_code
        # This parameter is required.
        self.biz_id = biz_id
        # This parameter is required.
        self.point_type = point_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.action_code is not None:
            result['actionCode'] = self.action_code
        if self.biz_id is not None:
            result['bizId'] = self.biz_id
        if self.point_type is not None:
            result['pointType'] = self.point_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('actionCode') is not None:
            self.action_code = m.get('actionCode')
        if m.get('bizId') is not None:
            self.biz_id = m.get('bizId')
        if m.get('pointType') is not None:
            self.point_type = m.get('pointType')
        return self


class ProvidePointResponseBodyResult(TeaModel):
    def __init__(
        self,
        available_quota: int = None,
        provide_num: int = None,
        provide_success: bool = None,
    ):
        self.available_quota = available_quota
        self.provide_num = provide_num
        self.provide_success = provide_success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.available_quota is not None:
            result['availableQuota'] = self.available_quota
        if self.provide_num is not None:
            result['provideNum'] = self.provide_num
        if self.provide_success is not None:
            result['provideSuccess'] = self.provide_success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('availableQuota') is not None:
            self.available_quota = m.get('availableQuota')
        if m.get('provideNum') is not None:
            self.provide_num = m.get('provideNum')
        if m.get('provideSuccess') is not None:
            self.provide_success = m.get('provideSuccess')
        return self


class ProvidePointResponseBody(TeaModel):
    def __init__(
        self,
        result: ProvidePointResponseBodyResult = None,
        success: bool = None,
    ):
        self.result = result
        self.success = success

    def validate(self):
        if self.result:
            self.result.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.result is not None:
            result['result'] = self.result.to_map()
        if self.success is not None:
            result['success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('result') is not None:
            temp_model = ProvidePointResponseBodyResult()
            self.result = temp_model.from_map(m['result'])
        if m.get('success') is not None:
            self.success = m.get('success')
        return self


class ProvidePointResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: ProvidePointResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ProvidePointResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class PublishSchoolReportHeaders(TeaModel):
    def __init__(
        self,
        common_headers: Dict[str, str] = None,
        x_acs_dingtalk_access_token: str = None,
    ):
        self.common_headers = common_headers
        self.x_acs_dingtalk_access_token = x_acs_dingtalk_access_token

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.common_headers is not None:
            result['commonHeaders'] = self.common_headers
        if self.x_acs_dingtalk_access_token is not None:
            result['x-acs-dingtalk-access-token'] = self.x_acs_dingtalk_access_token
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('commonHeaders') is not None:
            self.common_headers = m.get('commonHeaders')
        if m.get('x-acs-dingtalk-access-token') is not None:
            self.x_acs_dingtalk_access_token = m.get('x-acs-dingtalk-access-token')
        return self


class PublishSchoolReportRequestClassDetailItemsStudentDetailListSubjectList(TeaModel):
    def __init__(
        self,
        grade_rank: int = None,
        level_score: str = None,
        name: str = None,
        score: float = None,
    ):
        self.grade_rank = grade_rank
        self.level_score = level_score
        self.name = name
        self.score = score

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.grade_rank is not None:
            result['gradeRank'] = self.grade_rank
        if self.level_score is not None:
            result['levelScore'] = self.level_score
        if self.name is not None:
            result['name'] = self.name
        if self.score is not None:
            result['score'] = self.score
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('gradeRank') is not None:
            self.grade_rank = m.get('gradeRank')
        if m.get('levelScore') is not None:
            self.level_score = m.get('levelScore')
        if m.get('name') is not None:
            self.name = m.get('name')
        if m.get('score') is not None:
            self.score = m.get('score')
        return self


class PublishSchoolReportRequestClassDetailItemsStudentDetailList(TeaModel):
    def __init__(
        self,
        student_id: str = None,
        student_name: str = None,
        subject_list: List[PublishSchoolReportRequestClassDetailItemsStudentDetailListSubjectList] = None,
    ):
        self.student_id = student_id
        self.student_name = student_name
        self.subject_list = subject_list

    def validate(self):
        if self.subject_list:
            for k in self.subject_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.student_id is not None:
            result['studentId'] = self.student_id
        if self.student_name is not None:
            result['studentName'] = self.student_name
        result['subjectList'] = []
        if self.subject_list is not None:
            for k in self.subject_list:
                result['subjectList'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('studentId') is not None:
            self.student_id = m.get('studentId')
        if m.get('studentName') is not None:
            self.student_name = m.get('studentName')
        self.subject_list = []
        if m.get('subjectList') is not None:
            for k in m.get('subjectList'):
                temp_model = PublishSchoolReportRequestClassDetailItemsStudentDetailListSubjectList()
                self.subject_list.append(temp_model.from_map(k))
        return self


class PublishSchoolReportRequestClassDetailItems(TeaModel):
    def __init__(
        self,
        class_id: str = None,
        class_name: str = None,
        student_detail_list: List[PublishSchoolReportRequestClassDetailItemsStudentDetailList] = None,
    ):
        self.class_id = class_id
        self.class_name = class_name
        self.student_detail_list = student_detail_list

    def validate(self):
        if self.student_detail_list:
            for k in self.student_detail_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.class_id is not None:
            result['classId'] = self.class_id
        if self.class_name is not None:
            result['className'] = self.class_name
        result['studentDetailList'] = []
        if self.student_detail_list is not None:
            for k in self.student_detail_list:
                result['studentDetailList'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('classId') is not None:
            self.class_id = m.get('classId')
        if m.get('className') is not None:
            self.class_name = m.get('className')
        self.student_detail_list = []
        if m.get('studentDetailList') is not None:
            for k in m.get('studentDetailList'):
                temp_model = PublishSchoolReportRequestClassDetailItemsStudentDetailList()
                self.student_detail_list.append(temp_model.from_map(k))
        return self


class PublishSchoolReportRequestSubjectList(TeaModel):
    def __init__(
        self,
        name: str = None,
    ):
        self.name = name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.name is not None:
            result['name'] = self.name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('name') is not None:
            self.name = m.get('name')
        return self


class PublishSchoolReportRequest(TeaModel):
    def __init__(
        self,
        biz_code: str = None,
        class_detail_items: List[PublishSchoolReportRequestClassDetailItems] = None,
        exam_class: str = None,
        exam_title: str = None,
        identifier: str = None,
        publish_scope: str = None,
        score_type: str = None,
        share: bool = None,
        show_rank: bool = None,
        show_statistics_score: bool = None,
        sub_score_type: str = None,
        subject_list: List[PublishSchoolReportRequestSubjectList] = None,
        subjects: str = None,
        teacher_id: str = None,
        teacher_name: str = None,
    ):
        # This parameter is required.
        self.biz_code = biz_code
        self.class_detail_items = class_detail_items
        # This parameter is required.
        self.exam_class = exam_class
        # This parameter is required.
        self.exam_title = exam_title
        # This parameter is required.
        self.identifier = identifier
        # This parameter is required.
        self.publish_scope = publish_scope
        # This parameter is required.
        self.score_type = score_type
        # This parameter is required.
        self.share = share
        # This parameter is required.
        self.show_rank = show_rank
        # This parameter is required.
        self.show_statistics_score = show_statistics_score
        # This parameter is required.
        self.sub_score_type = sub_score_type
        # This parameter is required.
        self.subject_list = subject_list
        # This parameter is required.
        self.subjects = subjects
        # This parameter is required.
        self.teacher_id = teacher_id
        # This parameter is required.
        self.teacher_name = teacher_name

    def validate(self):
        if self.class_detail_items:
            for k in self.class_detail_items:
                if k:
                    k.validate()
        if self.subject_list:
            for k in self.subject_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.biz_code is not None:
            result['bizCode'] = self.biz_code
        result['classDetailItems'] = []
        if self.class_detail_items is not None:
            for k in self.class_detail_items:
                result['classDetailItems'].append(k.to_map() if k else None)
        if self.exam_class is not None:
            result['examClass'] = self.exam_class
        if self.exam_title is not None:
            result['examTitle'] = self.exam_title
        if self.identifier is not None:
            result['identifier'] = self.identifier
        if self.publish_scope is not None:
            result['publishScope'] = self.publish_scope
        if self.score_type is not None:
            result['scoreType'] = self.score_type
        if self.share is not None:
            result['share'] = self.share
        if self.show_rank is not None:
            result['showRank'] = self.show_rank
        if self.show_statistics_score is not None:
            result['showStatisticsScore'] = self.show_statistics_score
        if self.sub_score_type is not None:
            result['subScoreType'] = self.sub_score_type
        result['subjectList'] = []
        if self.subject_list is not None:
            for k in self.subject_list:
                result['subjectList'].append(k.to_map() if k else None)
        if self.subjects is not None:
            result['subjects'] = self.subjects
        if self.teacher_id is not None:
            result['teacherId'] = self.teacher_id
        if self.teacher_name is not None:
            result['teacherName'] = self.teacher_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('bizCode') is not None:
            self.biz_code = m.get('bizCode')
        self.class_detail_items = []
        if m.get('classDetailItems') is not None:
            for k in m.get('classDetailItems'):
                temp_model = PublishSchoolReportRequestClassDetailItems()
                self.class_detail_items.append(temp_model.from_map(k))
        if m.get('examClass') is not None:
            self.exam_class = m.get('examClass')
        if m.get('examTitle') is not None:
            self.exam_title = m.get('examTitle')
        if m.get('identifier') is not None:
            self.identifier = m.get('identifier')
        if m.get('publishScope') is not None:
            self.publish_scope = m.get('publishScope')
        if m.get('scoreType') is not None:
            self.score_type = m.get('scoreType')
        if m.get('share') is not None:
            self.share = m.get('share')
        if m.get('showRank') is not None:
            self.show_rank = m.get('showRank')
        if m.get('showStatisticsScore') is not None:
            self.show_statistics_score = m.get('showStatisticsScore')
        if m.get('subScoreType') is not None:
            self.sub_score_type = m.get('subScoreType')
        self.subject_list = []
        if m.get('subjectList') is not None:
            for k in m.get('subjectList'):
                temp_model = PublishSchoolReportRequestSubjectList()
                self.subject_list.append(temp_model.from_map(k))
        if m.get('subjects') is not None:
            self.subjects = m.get('subjects')
        if m.get('teacherId') is not None:
            self.teacher_id = m.get('teacherId')
        if m.get('teacherName') is not None:
            self.teacher_name = m.get('teacherName')
        return self


class PublishSchoolReportResponseBodyResult(TeaModel):
    def __init__(
        self,
        school_report_id: int = None,
    ):
        self.school_report_id = school_report_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.school_report_id is not None:
            result['schoolReportId'] = self.school_report_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('schoolReportId') is not None:
            self.school_report_id = m.get('schoolReportId')
        return self


class PublishSchoolReportResponseBody(TeaModel):
    def __init__(
        self,
        result: PublishSchoolReportResponseBodyResult = None,
        success: bool = None,
    ):
        self.result = result
        self.success = success

    def validate(self):
        if self.result:
            self.result.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.result is not None:
            result['result'] = self.result.to_map()
        if self.success is not None:
            result['success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('result') is not None:
            temp_model = PublishSchoolReportResponseBodyResult()
            self.result = temp_model.from_map(m['result'])
        if m.get('success') is not None:
            self.success = m.get('success')
        return self


class PublishSchoolReportResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: PublishSchoolReportResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = PublishSchoolReportResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class QueryAllSubjectsFromClassScheduleHeaders(TeaModel):
    def __init__(
        self,
        common_headers: Dict[str, str] = None,
        x_acs_dingtalk_access_token: str = None,
    ):
        self.common_headers = common_headers
        self.x_acs_dingtalk_access_token = x_acs_dingtalk_access_token

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.common_headers is not None:
            result['commonHeaders'] = self.common_headers
        if self.x_acs_dingtalk_access_token is not None:
            result['x-acs-dingtalk-access-token'] = self.x_acs_dingtalk_access_token
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('commonHeaders') is not None:
            self.common_headers = m.get('commonHeaders')
        if m.get('x-acs-dingtalk-access-token') is not None:
            self.x_acs_dingtalk_access_token = m.get('x-acs-dingtalk-access-token')
        return self


class QueryAllSubjectsFromClassScheduleRequest(TeaModel):
    def __init__(
        self,
        class_ids: List[int] = None,
        op_user_id: str = None,
        period_code: str = None,
    ):
        self.class_ids = class_ids
        # This parameter is required.
        self.op_user_id = op_user_id
        self.period_code = period_code

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.class_ids is not None:
            result['classIds'] = self.class_ids
        if self.op_user_id is not None:
            result['opUserId'] = self.op_user_id
        if self.period_code is not None:
            result['periodCode'] = self.period_code
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('classIds') is not None:
            self.class_ids = m.get('classIds')
        if m.get('opUserId') is not None:
            self.op_user_id = m.get('opUserId')
        if m.get('periodCode') is not None:
            self.period_code = m.get('periodCode')
        return self


class QueryAllSubjectsFromClassScheduleShrinkRequest(TeaModel):
    def __init__(
        self,
        class_ids_shrink: str = None,
        op_user_id: str = None,
        period_code: str = None,
    ):
        self.class_ids_shrink = class_ids_shrink
        # This parameter is required.
        self.op_user_id = op_user_id
        self.period_code = period_code

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.class_ids_shrink is not None:
            result['classIds'] = self.class_ids_shrink
        if self.op_user_id is not None:
            result['opUserId'] = self.op_user_id
        if self.period_code is not None:
            result['periodCode'] = self.period_code
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('classIds') is not None:
            self.class_ids_shrink = m.get('classIds')
        if m.get('opUserId') is not None:
            self.op_user_id = m.get('opUserId')
        if m.get('periodCode') is not None:
            self.period_code = m.get('periodCode')
        return self


class QueryAllSubjectsFromClassScheduleResponseBodyResultExtTeacherList(TeaModel):
    def __init__(
        self,
        avator: str = None,
        name: str = None,
        uid: int = None,
        user_id: str = None,
    ):
        # This parameter is required.
        self.avator = avator
        # This parameter is required.
        self.name = name
        # This parameter is required.
        self.uid = uid
        # This parameter is required.
        self.user_id = user_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.avator is not None:
            result['avator'] = self.avator
        if self.name is not None:
            result['name'] = self.name
        if self.uid is not None:
            result['uid'] = self.uid
        if self.user_id is not None:
            result['userId'] = self.user_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('avator') is not None:
            self.avator = m.get('avator')
        if m.get('name') is not None:
            self.name = m.get('name')
        if m.get('uid') is not None:
            self.uid = m.get('uid')
        if m.get('userId') is not None:
            self.user_id = m.get('userId')
        return self


class QueryAllSubjectsFromClassScheduleResponseBodyResultExt(TeaModel):
    def __init__(
        self,
        background_color: str = None,
        class_id: int = None,
        font_color: str = None,
        teacher_list: List[QueryAllSubjectsFromClassScheduleResponseBodyResultExtTeacherList] = None,
    ):
        self.background_color = background_color
        self.class_id = class_id
        self.font_color = font_color
        self.teacher_list = teacher_list

    def validate(self):
        if self.teacher_list:
            for k in self.teacher_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.background_color is not None:
            result['backgroundColor'] = self.background_color
        if self.class_id is not None:
            result['classId'] = self.class_id
        if self.font_color is not None:
            result['fontColor'] = self.font_color
        result['teacherList'] = []
        if self.teacher_list is not None:
            for k in self.teacher_list:
                result['teacherList'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('backgroundColor') is not None:
            self.background_color = m.get('backgroundColor')
        if m.get('classId') is not None:
            self.class_id = m.get('classId')
        if m.get('fontColor') is not None:
            self.font_color = m.get('fontColor')
        self.teacher_list = []
        if m.get('teacherList') is not None:
            for k in m.get('teacherList'):
                temp_model = QueryAllSubjectsFromClassScheduleResponseBodyResultExtTeacherList()
                self.teacher_list.append(temp_model.from_map(k))
        return self


class QueryAllSubjectsFromClassScheduleResponseBodyResult(TeaModel):
    def __init__(
        self,
        creator_org_id: int = None,
        ext: QueryAllSubjectsFromClassScheduleResponseBodyResultExt = None,
        period_code: str = None,
        subject_code: str = None,
        subject_name: str = None,
    ):
        self.creator_org_id = creator_org_id
        self.ext = ext
        self.period_code = period_code
        self.subject_code = subject_code
        self.subject_name = subject_name

    def validate(self):
        if self.ext:
            self.ext.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.creator_org_id is not None:
            result['creatorOrgId'] = self.creator_org_id
        if self.ext is not None:
            result['ext'] = self.ext.to_map()
        if self.period_code is not None:
            result['periodCode'] = self.period_code
        if self.subject_code is not None:
            result['subjectCode'] = self.subject_code
        if self.subject_name is not None:
            result['subjectName'] = self.subject_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('creatorOrgId') is not None:
            self.creator_org_id = m.get('creatorOrgId')
        if m.get('ext') is not None:
            temp_model = QueryAllSubjectsFromClassScheduleResponseBodyResultExt()
            self.ext = temp_model.from_map(m['ext'])
        if m.get('periodCode') is not None:
            self.period_code = m.get('periodCode')
        if m.get('subjectCode') is not None:
            self.subject_code = m.get('subjectCode')
        if m.get('subjectName') is not None:
            self.subject_name = m.get('subjectName')
        return self


class QueryAllSubjectsFromClassScheduleResponseBody(TeaModel):
    def __init__(
        self,
        result: List[QueryAllSubjectsFromClassScheduleResponseBodyResult] = None,
    ):
        self.result = result

    def validate(self):
        if self.result:
            for k in self.result:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['result'] = []
        if self.result is not None:
            for k in self.result:
                result['result'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.result = []
        if m.get('result') is not None:
            for k in m.get('result'):
                temp_model = QueryAllSubjectsFromClassScheduleResponseBodyResult()
                self.result.append(temp_model.from_map(k))
        return self


class QueryAllSubjectsFromClassScheduleResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: QueryAllSubjectsFromClassScheduleResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = QueryAllSubjectsFromClassScheduleResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class QueryClassScheduleHeaders(TeaModel):
    def __init__(
        self,
        common_headers: Dict[str, str] = None,
        x_acs_dingtalk_access_token: str = None,
    ):
        self.common_headers = common_headers
        self.x_acs_dingtalk_access_token = x_acs_dingtalk_access_token

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.common_headers is not None:
            result['commonHeaders'] = self.common_headers
        if self.x_acs_dingtalk_access_token is not None:
            result['x-acs-dingtalk-access-token'] = self.x_acs_dingtalk_access_token
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('commonHeaders') is not None:
            self.common_headers = m.get('commonHeaders')
        if m.get('x-acs-dingtalk-access-token') is not None:
            self.x_acs_dingtalk_access_token = m.get('x-acs-dingtalk-access-token')
        return self


class QueryClassScheduleRequest(TeaModel):
    def __init__(
        self,
        section_index_list: List[int] = None,
        subscriber_ids: List[str] = None,
        end_time: int = None,
        op_user_id: str = None,
        start_time: int = None,
        subscriber_type: str = None,
    ):
        # This parameter is required.
        self.section_index_list = section_index_list
        # This parameter is required.
        self.subscriber_ids = subscriber_ids
        self.end_time = end_time
        # This parameter is required.
        self.op_user_id = op_user_id
        self.start_time = start_time
        self.subscriber_type = subscriber_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.section_index_list is not None:
            result['sectionIndexList'] = self.section_index_list
        if self.subscriber_ids is not None:
            result['subscriberIds'] = self.subscriber_ids
        if self.end_time is not None:
            result['endTime'] = self.end_time
        if self.op_user_id is not None:
            result['opUserId'] = self.op_user_id
        if self.start_time is not None:
            result['startTime'] = self.start_time
        if self.subscriber_type is not None:
            result['subscriberType'] = self.subscriber_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('sectionIndexList') is not None:
            self.section_index_list = m.get('sectionIndexList')
        if m.get('subscriberIds') is not None:
            self.subscriber_ids = m.get('subscriberIds')
        if m.get('endTime') is not None:
            self.end_time = m.get('endTime')
        if m.get('opUserId') is not None:
            self.op_user_id = m.get('opUserId')
        if m.get('startTime') is not None:
            self.start_time = m.get('startTime')
        if m.get('subscriberType') is not None:
            self.subscriber_type = m.get('subscriberType')
        return self


class QueryClassScheduleResponseBodyConfigEnd(TeaModel):
    def __init__(
        self,
        day_of_month: int = None,
        month: int = None,
        year: int = None,
    ):
        self.day_of_month = day_of_month
        self.month = month
        self.year = year

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.day_of_month is not None:
            result['dayOfMonth'] = self.day_of_month
        if self.month is not None:
            result['month'] = self.month
        if self.year is not None:
            result['year'] = self.year
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('dayOfMonth') is not None:
            self.day_of_month = m.get('dayOfMonth')
        if m.get('month') is not None:
            self.month = m.get('month')
        if m.get('year') is not None:
            self.year = m.get('year')
        return self


class QueryClassScheduleResponseBodyConfigSectionModelsEnd(TeaModel):
    def __init__(
        self,
        hour: int = None,
        min: int = None,
    ):
        self.hour = hour
        self.min = min

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.hour is not None:
            result['hour'] = self.hour
        if self.min is not None:
            result['min'] = self.min
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('hour') is not None:
            self.hour = m.get('hour')
        if m.get('min') is not None:
            self.min = m.get('min')
        return self


class QueryClassScheduleResponseBodyConfigSectionModelsStart(TeaModel):
    def __init__(
        self,
        hour: int = None,
        min: int = None,
    ):
        self.hour = hour
        self.min = min

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.hour is not None:
            result['hour'] = self.hour
        if self.min is not None:
            result['min'] = self.min
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('hour') is not None:
            self.hour = m.get('hour')
        if m.get('min') is not None:
            self.min = m.get('min')
        return self


class QueryClassScheduleResponseBodyConfigSectionModels(TeaModel):
    def __init__(
        self,
        end: QueryClassScheduleResponseBodyConfigSectionModelsEnd = None,
        section_index: int = None,
        section_name: str = None,
        section_type: str = None,
        start: QueryClassScheduleResponseBodyConfigSectionModelsStart = None,
    ):
        self.end = end
        self.section_index = section_index
        self.section_name = section_name
        self.section_type = section_type
        self.start = start

    def validate(self):
        if self.end:
            self.end.validate()
        if self.start:
            self.start.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.end is not None:
            result['end'] = self.end.to_map()
        if self.section_index is not None:
            result['sectionIndex'] = self.section_index
        if self.section_name is not None:
            result['sectionName'] = self.section_name
        if self.section_type is not None:
            result['sectionType'] = self.section_type
        if self.start is not None:
            result['start'] = self.start.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('end') is not None:
            temp_model = QueryClassScheduleResponseBodyConfigSectionModelsEnd()
            self.end = temp_model.from_map(m['end'])
        if m.get('sectionIndex') is not None:
            self.section_index = m.get('sectionIndex')
        if m.get('sectionName') is not None:
            self.section_name = m.get('sectionName')
        if m.get('sectionType') is not None:
            self.section_type = m.get('sectionType')
        if m.get('start') is not None:
            temp_model = QueryClassScheduleResponseBodyConfigSectionModelsStart()
            self.start = temp_model.from_map(m['start'])
        return self


class QueryClassScheduleResponseBodyConfigStart(TeaModel):
    def __init__(
        self,
        day_of_month: int = None,
        month: int = None,
        year: int = None,
    ):
        self.day_of_month = day_of_month
        self.month = month
        self.year = year

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.day_of_month is not None:
            result['dayOfMonth'] = self.day_of_month
        if self.month is not None:
            result['month'] = self.month
        if self.year is not None:
            result['year'] = self.year
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('dayOfMonth') is not None:
            self.day_of_month = m.get('dayOfMonth')
        if m.get('month') is not None:
            self.month = m.get('month')
        if m.get('year') is not None:
            self.year = m.get('year')
        return self


class QueryClassScheduleResponseBodyConfig(TeaModel):
    def __init__(
        self,
        end: QueryClassScheduleResponseBodyConfigEnd = None,
        section_models: List[QueryClassScheduleResponseBodyConfigSectionModels] = None,
        start: QueryClassScheduleResponseBodyConfigStart = None,
    ):
        self.end = end
        self.section_models = section_models
        self.start = start

    def validate(self):
        if self.end:
            self.end.validate()
        if self.section_models:
            for k in self.section_models:
                if k:
                    k.validate()
        if self.start:
            self.start.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.end is not None:
            result['end'] = self.end.to_map()
        result['sectionModels'] = []
        if self.section_models is not None:
            for k in self.section_models:
                result['sectionModels'].append(k.to_map() if k else None)
        if self.start is not None:
            result['start'] = self.start.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('end') is not None:
            temp_model = QueryClassScheduleResponseBodyConfigEnd()
            self.end = temp_model.from_map(m['end'])
        self.section_models = []
        if m.get('sectionModels') is not None:
            for k in m.get('sectionModels'):
                temp_model = QueryClassScheduleResponseBodyConfigSectionModels()
                self.section_models.append(temp_model.from_map(k))
        if m.get('start') is not None:
            temp_model = QueryClassScheduleResponseBodyConfigStart()
            self.start = temp_model.from_map(m['start'])
        return self


class QueryClassScheduleResponseBodyCourseDTOSClassrooms(TeaModel):
    def __init__(
        self,
        interact_info: str = None,
        target_id: str = None,
    ):
        self.interact_info = interact_info
        self.target_id = target_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.interact_info is not None:
            result['interactInfo'] = self.interact_info
        if self.target_id is not None:
            result['targetId'] = self.target_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('interactInfo') is not None:
            self.interact_info = m.get('interactInfo')
        if m.get('targetId') is not None:
            self.target_id = m.get('targetId')
        return self


class QueryClassScheduleResponseBodyCourseDTOSEduUserModels(TeaModel):
    def __init__(
        self,
        name: str = None,
        uid: int = None,
        user_id: str = None,
    ):
        self.name = name
        self.uid = uid
        self.user_id = user_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.name is not None:
            result['name'] = self.name
        if self.uid is not None:
            result['uid'] = self.uid
        if self.user_id is not None:
            result['userId'] = self.user_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('name') is not None:
            self.name = m.get('name')
        if m.get('uid') is not None:
            self.uid = m.get('uid')
        if m.get('userId') is not None:
            self.user_id = m.get('userId')
        return self


class QueryClassScheduleResponseBodyCourseDTOS(TeaModel):
    def __init__(
        self,
        class_id: int = None,
        classrooms: List[QueryClassScheduleResponseBodyCourseDTOSClassrooms] = None,
        code: str = None,
        course_group_code: str = None,
        cover_url: str = None,
        creator_corp_id: str = None,
        creator_user_id: str = None,
        creator_user_name: str = None,
        edu_user_models: List[QueryClassScheduleResponseBodyCourseDTOSEduUserModels] = None,
        end_time: int = None,
        ext_info: str = None,
        introduce: str = None,
        name: str = None,
        section_index: int = None,
        section_name: str = None,
        start_time: int = None,
        status: int = None,
        subject_code: str = None,
        teacher_corp_id: str = None,
        teacher_user_id: str = None,
        teacher_user_name: str = None,
    ):
        self.class_id = class_id
        self.classrooms = classrooms
        self.code = code
        self.course_group_code = course_group_code
        self.cover_url = cover_url
        self.creator_corp_id = creator_corp_id
        self.creator_user_id = creator_user_id
        self.creator_user_name = creator_user_name
        self.edu_user_models = edu_user_models
        self.end_time = end_time
        self.ext_info = ext_info
        self.introduce = introduce
        self.name = name
        self.section_index = section_index
        self.section_name = section_name
        self.start_time = start_time
        self.status = status
        self.subject_code = subject_code
        self.teacher_corp_id = teacher_corp_id
        self.teacher_user_id = teacher_user_id
        self.teacher_user_name = teacher_user_name

    def validate(self):
        if self.classrooms:
            for k in self.classrooms:
                if k:
                    k.validate()
        if self.edu_user_models:
            for k in self.edu_user_models:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.class_id is not None:
            result['classId'] = self.class_id
        result['classrooms'] = []
        if self.classrooms is not None:
            for k in self.classrooms:
                result['classrooms'].append(k.to_map() if k else None)
        if self.code is not None:
            result['code'] = self.code
        if self.course_group_code is not None:
            result['courseGroupCode'] = self.course_group_code
        if self.cover_url is not None:
            result['coverUrl'] = self.cover_url
        if self.creator_corp_id is not None:
            result['creatorCorpId'] = self.creator_corp_id
        if self.creator_user_id is not None:
            result['creatorUserId'] = self.creator_user_id
        if self.creator_user_name is not None:
            result['creatorUserName'] = self.creator_user_name
        result['eduUserModels'] = []
        if self.edu_user_models is not None:
            for k in self.edu_user_models:
                result['eduUserModels'].append(k.to_map() if k else None)
        if self.end_time is not None:
            result['endTime'] = self.end_time
        if self.ext_info is not None:
            result['extInfo'] = self.ext_info
        if self.introduce is not None:
            result['introduce'] = self.introduce
        if self.name is not None:
            result['name'] = self.name
        if self.section_index is not None:
            result['sectionIndex'] = self.section_index
        if self.section_name is not None:
            result['sectionName'] = self.section_name
        if self.start_time is not None:
            result['startTime'] = self.start_time
        if self.status is not None:
            result['status'] = self.status
        if self.subject_code is not None:
            result['subjectCode'] = self.subject_code
        if self.teacher_corp_id is not None:
            result['teacherCorpId'] = self.teacher_corp_id
        if self.teacher_user_id is not None:
            result['teacherUserId'] = self.teacher_user_id
        if self.teacher_user_name is not None:
            result['teacherUserName'] = self.teacher_user_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('classId') is not None:
            self.class_id = m.get('classId')
        self.classrooms = []
        if m.get('classrooms') is not None:
            for k in m.get('classrooms'):
                temp_model = QueryClassScheduleResponseBodyCourseDTOSClassrooms()
                self.classrooms.append(temp_model.from_map(k))
        if m.get('code') is not None:
            self.code = m.get('code')
        if m.get('courseGroupCode') is not None:
            self.course_group_code = m.get('courseGroupCode')
        if m.get('coverUrl') is not None:
            self.cover_url = m.get('coverUrl')
        if m.get('creatorCorpId') is not None:
            self.creator_corp_id = m.get('creatorCorpId')
        if m.get('creatorUserId') is not None:
            self.creator_user_id = m.get('creatorUserId')
        if m.get('creatorUserName') is not None:
            self.creator_user_name = m.get('creatorUserName')
        self.edu_user_models = []
        if m.get('eduUserModels') is not None:
            for k in m.get('eduUserModels'):
                temp_model = QueryClassScheduleResponseBodyCourseDTOSEduUserModels()
                self.edu_user_models.append(temp_model.from_map(k))
        if m.get('endTime') is not None:
            self.end_time = m.get('endTime')
        if m.get('extInfo') is not None:
            self.ext_info = m.get('extInfo')
        if m.get('introduce') is not None:
            self.introduce = m.get('introduce')
        if m.get('name') is not None:
            self.name = m.get('name')
        if m.get('sectionIndex') is not None:
            self.section_index = m.get('sectionIndex')
        if m.get('sectionName') is not None:
            self.section_name = m.get('sectionName')
        if m.get('startTime') is not None:
            self.start_time = m.get('startTime')
        if m.get('status') is not None:
            self.status = m.get('status')
        if m.get('subjectCode') is not None:
            self.subject_code = m.get('subjectCode')
        if m.get('teacherCorpId') is not None:
            self.teacher_corp_id = m.get('teacherCorpId')
        if m.get('teacherUserId') is not None:
            self.teacher_user_id = m.get('teacherUserId')
        if m.get('teacherUserName') is not None:
            self.teacher_user_name = m.get('teacherUserName')
        return self


class QueryClassScheduleResponseBody(TeaModel):
    def __init__(
        self,
        config: QueryClassScheduleResponseBodyConfig = None,
        course_dtos: List[QueryClassScheduleResponseBodyCourseDTOS] = None,
    ):
        self.config = config
        self.course_dtos = course_dtos

    def validate(self):
        if self.config:
            self.config.validate()
        if self.course_dtos:
            for k in self.course_dtos:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.config is not None:
            result['config'] = self.config.to_map()
        result['courseDTOS'] = []
        if self.course_dtos is not None:
            for k in self.course_dtos:
                result['courseDTOS'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('config') is not None:
            temp_model = QueryClassScheduleResponseBodyConfig()
            self.config = temp_model.from_map(m['config'])
        self.course_dtos = []
        if m.get('courseDTOS') is not None:
            for k in m.get('courseDTOS'):
                temp_model = QueryClassScheduleResponseBodyCourseDTOS()
                self.course_dtos.append(temp_model.from_map(k))
        return self


class QueryClassScheduleResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: QueryClassScheduleResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = QueryClassScheduleResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class QueryClassScheduleByTimeSchoolHeaders(TeaModel):
    def __init__(
        self,
        common_headers: Dict[str, str] = None,
        x_acs_dingtalk_access_token: str = None,
    ):
        self.common_headers = common_headers
        self.x_acs_dingtalk_access_token = x_acs_dingtalk_access_token

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.common_headers is not None:
            result['commonHeaders'] = self.common_headers
        if self.x_acs_dingtalk_access_token is not None:
            result['x-acs-dingtalk-access-token'] = self.x_acs_dingtalk_access_token
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('commonHeaders') is not None:
            self.common_headers = m.get('commonHeaders')
        if m.get('x-acs-dingtalk-access-token') is not None:
            self.x_acs_dingtalk_access_token = m.get('x-acs-dingtalk-access-token')
        return self


class QueryClassScheduleByTimeSchoolRequest(TeaModel):
    def __init__(
        self,
        end_time: int = None,
        op_user_id: str = None,
        start_time: int = None,
    ):
        # This parameter is required.
        self.end_time = end_time
        # This parameter is required.
        self.op_user_id = op_user_id
        # This parameter is required.
        self.start_time = start_time

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.end_time is not None:
            result['endTime'] = self.end_time
        if self.op_user_id is not None:
            result['opUserId'] = self.op_user_id
        if self.start_time is not None:
            result['startTime'] = self.start_time
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('endTime') is not None:
            self.end_time = m.get('endTime')
        if m.get('opUserId') is not None:
            self.op_user_id = m.get('opUserId')
        if m.get('startTime') is not None:
            self.start_time = m.get('startTime')
        return self


class QueryClassScheduleByTimeSchoolResponseBodyResultClassrooms(TeaModel):
    def __init__(
        self,
        interact_info: str = None,
        target_id: str = None,
    ):
        self.interact_info = interact_info
        self.target_id = target_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.interact_info is not None:
            result['interactInfo'] = self.interact_info
        if self.target_id is not None:
            result['targetId'] = self.target_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('interactInfo') is not None:
            self.interact_info = m.get('interactInfo')
        if m.get('targetId') is not None:
            self.target_id = m.get('targetId')
        return self


class QueryClassScheduleByTimeSchoolResponseBodyResultEduUserModels(TeaModel):
    def __init__(
        self,
        name: str = None,
        uid: int = None,
        user_id: str = None,
    ):
        self.name = name
        self.uid = uid
        self.user_id = user_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.name is not None:
            result['name'] = self.name
        if self.uid is not None:
            result['uid'] = self.uid
        if self.user_id is not None:
            result['userId'] = self.user_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('name') is not None:
            self.name = m.get('name')
        if m.get('uid') is not None:
            self.uid = m.get('uid')
        if m.get('userId') is not None:
            self.user_id = m.get('userId')
        return self


class QueryClassScheduleByTimeSchoolResponseBodyResult(TeaModel):
    def __init__(
        self,
        biz_key: str = None,
        class_id: int = None,
        classrooms: List[QueryClassScheduleByTimeSchoolResponseBodyResultClassrooms] = None,
        code: str = None,
        course_group_code: str = None,
        cover_url: str = None,
        creator_corp_id: str = None,
        creator_user_id: str = None,
        creator_user_name: str = None,
        edu_user_models: List[QueryClassScheduleByTimeSchoolResponseBodyResultEduUserModels] = None,
        end_time: int = None,
        ext_info: str = None,
        introduce: str = None,
        name: str = None,
        section_index: int = None,
        section_name: str = None,
        start_time: int = None,
        status: int = None,
        subject_code: str = None,
        teacher_corp_id: str = None,
        teacher_user_id: str = None,
        teacher_user_name: str = None,
    ):
        self.biz_key = biz_key
        self.class_id = class_id
        self.classrooms = classrooms
        self.code = code
        self.course_group_code = course_group_code
        self.cover_url = cover_url
        self.creator_corp_id = creator_corp_id
        self.creator_user_id = creator_user_id
        self.creator_user_name = creator_user_name
        self.edu_user_models = edu_user_models
        self.end_time = end_time
        self.ext_info = ext_info
        self.introduce = introduce
        self.name = name
        self.section_index = section_index
        self.section_name = section_name
        self.start_time = start_time
        self.status = status
        self.subject_code = subject_code
        self.teacher_corp_id = teacher_corp_id
        self.teacher_user_id = teacher_user_id
        self.teacher_user_name = teacher_user_name

    def validate(self):
        if self.classrooms:
            for k in self.classrooms:
                if k:
                    k.validate()
        if self.edu_user_models:
            for k in self.edu_user_models:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.biz_key is not None:
            result['bizKey'] = self.biz_key
        if self.class_id is not None:
            result['classId'] = self.class_id
        result['classrooms'] = []
        if self.classrooms is not None:
            for k in self.classrooms:
                result['classrooms'].append(k.to_map() if k else None)
        if self.code is not None:
            result['code'] = self.code
        if self.course_group_code is not None:
            result['courseGroupCode'] = self.course_group_code
        if self.cover_url is not None:
            result['coverUrl'] = self.cover_url
        if self.creator_corp_id is not None:
            result['creatorCorpId'] = self.creator_corp_id
        if self.creator_user_id is not None:
            result['creatorUserId'] = self.creator_user_id
        if self.creator_user_name is not None:
            result['creatorUserName'] = self.creator_user_name
        result['eduUserModels'] = []
        if self.edu_user_models is not None:
            for k in self.edu_user_models:
                result['eduUserModels'].append(k.to_map() if k else None)
        if self.end_time is not None:
            result['endTime'] = self.end_time
        if self.ext_info is not None:
            result['extInfo'] = self.ext_info
        if self.introduce is not None:
            result['introduce'] = self.introduce
        if self.name is not None:
            result['name'] = self.name
        if self.section_index is not None:
            result['sectionIndex'] = self.section_index
        if self.section_name is not None:
            result['sectionName'] = self.section_name
        if self.start_time is not None:
            result['startTime'] = self.start_time
        if self.status is not None:
            result['status'] = self.status
        if self.subject_code is not None:
            result['subjectCode'] = self.subject_code
        if self.teacher_corp_id is not None:
            result['teacherCorpId'] = self.teacher_corp_id
        if self.teacher_user_id is not None:
            result['teacherUserId'] = self.teacher_user_id
        if self.teacher_user_name is not None:
            result['teacherUserName'] = self.teacher_user_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('bizKey') is not None:
            self.biz_key = m.get('bizKey')
        if m.get('classId') is not None:
            self.class_id = m.get('classId')
        self.classrooms = []
        if m.get('classrooms') is not None:
            for k in m.get('classrooms'):
                temp_model = QueryClassScheduleByTimeSchoolResponseBodyResultClassrooms()
                self.classrooms.append(temp_model.from_map(k))
        if m.get('code') is not None:
            self.code = m.get('code')
        if m.get('courseGroupCode') is not None:
            self.course_group_code = m.get('courseGroupCode')
        if m.get('coverUrl') is not None:
            self.cover_url = m.get('coverUrl')
        if m.get('creatorCorpId') is not None:
            self.creator_corp_id = m.get('creatorCorpId')
        if m.get('creatorUserId') is not None:
            self.creator_user_id = m.get('creatorUserId')
        if m.get('creatorUserName') is not None:
            self.creator_user_name = m.get('creatorUserName')
        self.edu_user_models = []
        if m.get('eduUserModels') is not None:
            for k in m.get('eduUserModels'):
                temp_model = QueryClassScheduleByTimeSchoolResponseBodyResultEduUserModels()
                self.edu_user_models.append(temp_model.from_map(k))
        if m.get('endTime') is not None:
            self.end_time = m.get('endTime')
        if m.get('extInfo') is not None:
            self.ext_info = m.get('extInfo')
        if m.get('introduce') is not None:
            self.introduce = m.get('introduce')
        if m.get('name') is not None:
            self.name = m.get('name')
        if m.get('sectionIndex') is not None:
            self.section_index = m.get('sectionIndex')
        if m.get('sectionName') is not None:
            self.section_name = m.get('sectionName')
        if m.get('startTime') is not None:
            self.start_time = m.get('startTime')
        if m.get('status') is not None:
            self.status = m.get('status')
        if m.get('subjectCode') is not None:
            self.subject_code = m.get('subjectCode')
        if m.get('teacherCorpId') is not None:
            self.teacher_corp_id = m.get('teacherCorpId')
        if m.get('teacherUserId') is not None:
            self.teacher_user_id = m.get('teacherUserId')
        if m.get('teacherUserName') is not None:
            self.teacher_user_name = m.get('teacherUserName')
        return self


class QueryClassScheduleByTimeSchoolResponseBody(TeaModel):
    def __init__(
        self,
        result: List[QueryClassScheduleByTimeSchoolResponseBodyResult] = None,
    ):
        self.result = result

    def validate(self):
        if self.result:
            for k in self.result:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['result'] = []
        if self.result is not None:
            for k in self.result:
                result['result'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.result = []
        if m.get('result') is not None:
            for k in m.get('result'):
                temp_model = QueryClassScheduleByTimeSchoolResponseBodyResult()
                self.result.append(temp_model.from_map(k))
        return self


class QueryClassScheduleByTimeSchoolResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: QueryClassScheduleByTimeSchoolResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = QueryClassScheduleByTimeSchoolResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class QueryClassScheduleConfigHeaders(TeaModel):
    def __init__(
        self,
        common_headers: Dict[str, str] = None,
        x_acs_dingtalk_access_token: str = None,
    ):
        self.common_headers = common_headers
        self.x_acs_dingtalk_access_token = x_acs_dingtalk_access_token

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.common_headers is not None:
            result['commonHeaders'] = self.common_headers
        if self.x_acs_dingtalk_access_token is not None:
            result['x-acs-dingtalk-access-token'] = self.x_acs_dingtalk_access_token
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('commonHeaders') is not None:
            self.common_headers = m.get('commonHeaders')
        if m.get('x-acs-dingtalk-access-token') is not None:
            self.x_acs_dingtalk_access_token = m.get('x-acs-dingtalk-access-token')
        return self


class QueryClassScheduleConfigRequest(TeaModel):
    def __init__(
        self,
        class_ids: List[int] = None,
        op_user_id: str = None,
    ):
        self.class_ids = class_ids
        # This parameter is required.
        self.op_user_id = op_user_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.class_ids is not None:
            result['classIds'] = self.class_ids
        if self.op_user_id is not None:
            result['opUserId'] = self.op_user_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('classIds') is not None:
            self.class_ids = m.get('classIds')
        if m.get('opUserId') is not None:
            self.op_user_id = m.get('opUserId')
        return self


class QueryClassScheduleConfigShrinkRequest(TeaModel):
    def __init__(
        self,
        class_ids_shrink: str = None,
        op_user_id: str = None,
    ):
        self.class_ids_shrink = class_ids_shrink
        # This parameter is required.
        self.op_user_id = op_user_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.class_ids_shrink is not None:
            result['classIds'] = self.class_ids_shrink
        if self.op_user_id is not None:
            result['opUserId'] = self.op_user_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('classIds') is not None:
            self.class_ids_shrink = m.get('classIds')
        if m.get('opUserId') is not None:
            self.op_user_id = m.get('opUserId')
        return self


class QueryClassScheduleConfigResponseBodyResultEnd(TeaModel):
    def __init__(
        self,
        day_of_month: int = None,
        month: int = None,
        year: int = None,
    ):
        self.day_of_month = day_of_month
        self.month = month
        self.year = year

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.day_of_month is not None:
            result['dayOfMonth'] = self.day_of_month
        if self.month is not None:
            result['month'] = self.month
        if self.year is not None:
            result['year'] = self.year
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('dayOfMonth') is not None:
            self.day_of_month = m.get('dayOfMonth')
        if m.get('month') is not None:
            self.month = m.get('month')
        if m.get('year') is not None:
            self.year = m.get('year')
        return self


class QueryClassScheduleConfigResponseBodyResultSectionModelsEnd(TeaModel):
    def __init__(
        self,
        hour: int = None,
        min: int = None,
    ):
        self.hour = hour
        self.min = min

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.hour is not None:
            result['hour'] = self.hour
        if self.min is not None:
            result['min'] = self.min
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('hour') is not None:
            self.hour = m.get('hour')
        if m.get('min') is not None:
            self.min = m.get('min')
        return self


class QueryClassScheduleConfigResponseBodyResultSectionModelsStart(TeaModel):
    def __init__(
        self,
        hour: int = None,
        min: int = None,
    ):
        self.hour = hour
        self.min = min

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.hour is not None:
            result['hour'] = self.hour
        if self.min is not None:
            result['min'] = self.min
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('hour') is not None:
            self.hour = m.get('hour')
        if m.get('min') is not None:
            self.min = m.get('min')
        return self


class QueryClassScheduleConfigResponseBodyResultSectionModels(TeaModel):
    def __init__(
        self,
        end: QueryClassScheduleConfigResponseBodyResultSectionModelsEnd = None,
        section_index: int = None,
        section_name: str = None,
        section_type: str = None,
        start: QueryClassScheduleConfigResponseBodyResultSectionModelsStart = None,
    ):
        self.end = end
        self.section_index = section_index
        self.section_name = section_name
        self.section_type = section_type
        self.start = start

    def validate(self):
        if self.end:
            self.end.validate()
        if self.start:
            self.start.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.end is not None:
            result['end'] = self.end.to_map()
        if self.section_index is not None:
            result['sectionIndex'] = self.section_index
        if self.section_name is not None:
            result['sectionName'] = self.section_name
        if self.section_type is not None:
            result['sectionType'] = self.section_type
        if self.start is not None:
            result['start'] = self.start.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('end') is not None:
            temp_model = QueryClassScheduleConfigResponseBodyResultSectionModelsEnd()
            self.end = temp_model.from_map(m['end'])
        if m.get('sectionIndex') is not None:
            self.section_index = m.get('sectionIndex')
        if m.get('sectionName') is not None:
            self.section_name = m.get('sectionName')
        if m.get('sectionType') is not None:
            self.section_type = m.get('sectionType')
        if m.get('start') is not None:
            temp_model = QueryClassScheduleConfigResponseBodyResultSectionModelsStart()
            self.start = temp_model.from_map(m['start'])
        return self


class QueryClassScheduleConfigResponseBodyResultStart(TeaModel):
    def __init__(
        self,
        day_of_month: int = None,
        month: int = None,
        year: int = None,
    ):
        self.day_of_month = day_of_month
        self.month = month
        self.year = year

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.day_of_month is not None:
            result['dayOfMonth'] = self.day_of_month
        if self.month is not None:
            result['month'] = self.month
        if self.year is not None:
            result['year'] = self.year
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('dayOfMonth') is not None:
            self.day_of_month = m.get('dayOfMonth')
        if m.get('month') is not None:
            self.month = m.get('month')
        if m.get('year') is not None:
            self.year = m.get('year')
        return self


class QueryClassScheduleConfigResponseBodyResult(TeaModel):
    def __init__(
        self,
        class_id: int = None,
        end: QueryClassScheduleConfigResponseBodyResultEnd = None,
        section_models: List[QueryClassScheduleConfigResponseBodyResultSectionModels] = None,
        start: QueryClassScheduleConfigResponseBodyResultStart = None,
    ):
        self.class_id = class_id
        self.end = end
        self.section_models = section_models
        self.start = start

    def validate(self):
        if self.end:
            self.end.validate()
        if self.section_models:
            for k in self.section_models:
                if k:
                    k.validate()
        if self.start:
            self.start.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.class_id is not None:
            result['classId'] = self.class_id
        if self.end is not None:
            result['end'] = self.end.to_map()
        result['sectionModels'] = []
        if self.section_models is not None:
            for k in self.section_models:
                result['sectionModels'].append(k.to_map() if k else None)
        if self.start is not None:
            result['start'] = self.start.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('classId') is not None:
            self.class_id = m.get('classId')
        if m.get('end') is not None:
            temp_model = QueryClassScheduleConfigResponseBodyResultEnd()
            self.end = temp_model.from_map(m['end'])
        self.section_models = []
        if m.get('sectionModels') is not None:
            for k in m.get('sectionModels'):
                temp_model = QueryClassScheduleConfigResponseBodyResultSectionModels()
                self.section_models.append(temp_model.from_map(k))
        if m.get('start') is not None:
            temp_model = QueryClassScheduleConfigResponseBodyResultStart()
            self.start = temp_model.from_map(m['start'])
        return self


class QueryClassScheduleConfigResponseBody(TeaModel):
    def __init__(
        self,
        result: List[QueryClassScheduleConfigResponseBodyResult] = None,
    ):
        self.result = result

    def validate(self):
        if self.result:
            for k in self.result:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['result'] = []
        if self.result is not None:
            for k in self.result:
                result['result'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.result = []
        if m.get('result') is not None:
            for k in m.get('result'):
                temp_model = QueryClassScheduleConfigResponseBodyResult()
                self.result.append(temp_model.from_map(k))
        return self


class QueryClassScheduleConfigResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: QueryClassScheduleConfigResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = QueryClassScheduleConfigResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class QueryCollegeContactUserDetailHeaders(TeaModel):
    def __init__(
        self,
        common_headers: Dict[str, str] = None,
        x_acs_dingtalk_access_token: str = None,
    ):
        self.common_headers = common_headers
        self.x_acs_dingtalk_access_token = x_acs_dingtalk_access_token

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.common_headers is not None:
            result['commonHeaders'] = self.common_headers
        if self.x_acs_dingtalk_access_token is not None:
            result['x-acs-dingtalk-access-token'] = self.x_acs_dingtalk_access_token
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('commonHeaders') is not None:
            self.common_headers = m.get('commonHeaders')
        if m.get('x-acs-dingtalk-access-token') is not None:
            self.x_acs_dingtalk_access_token = m.get('x-acs-dingtalk-access-token')
        return self


class QueryCollegeContactUserDetailRequest(TeaModel):
    def __init__(
        self,
        job_number: str = None,
        language: str = None,
        userid: str = None,
    ):
        self.job_number = job_number
        self.language = language
        self.userid = userid

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.job_number is not None:
            result['jobNumber'] = self.job_number
        if self.language is not None:
            result['language'] = self.language
        if self.userid is not None:
            result['userid'] = self.userid
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('jobNumber') is not None:
            self.job_number = m.get('jobNumber')
        if m.get('language') is not None:
            self.language = m.get('language')
        if m.get('userid') is not None:
            self.userid = m.get('userid')
        return self


class QueryCollegeContactUserDetailResponseBodyResultDeptOrderList(TeaModel):
    def __init__(
        self,
        dept_id: int = None,
        order: int = None,
    ):
        self.dept_id = dept_id
        self.order = order

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dept_id is not None:
            result['deptId'] = self.dept_id
        if self.order is not None:
            result['order'] = self.order
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('deptId') is not None:
            self.dept_id = m.get('deptId')
        if m.get('order') is not None:
            self.order = m.get('order')
        return self


class QueryCollegeContactUserDetailResponseBodyResultDeptPositionSet(TeaModel):
    def __init__(
        self,
        dept_id: int = None,
        is_main: bool = None,
        manager_user_id: str = None,
        title: str = None,
        work_place: str = None,
    ):
        self.dept_id = dept_id
        self.is_main = is_main
        self.manager_user_id = manager_user_id
        self.title = title
        self.work_place = work_place

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dept_id is not None:
            result['deptId'] = self.dept_id
        if self.is_main is not None:
            result['isMain'] = self.is_main
        if self.manager_user_id is not None:
            result['managerUserId'] = self.manager_user_id
        if self.title is not None:
            result['title'] = self.title
        if self.work_place is not None:
            result['workPlace'] = self.work_place
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('deptId') is not None:
            self.dept_id = m.get('deptId')
        if m.get('isMain') is not None:
            self.is_main = m.get('isMain')
        if m.get('managerUserId') is not None:
            self.manager_user_id = m.get('managerUserId')
        if m.get('title') is not None:
            self.title = m.get('title')
        if m.get('workPlace') is not None:
            self.work_place = m.get('workPlace')
        return self


class QueryCollegeContactUserDetailResponseBodyResultDeptTypeSet(TeaModel):
    def __init__(
        self,
        dept_id: int = None,
        dept_name: str = None,
        dept_struct_type: str = None,
        dept_type: str = None,
        struct_dept_id: int = None,
    ):
        self.dept_id = dept_id
        self.dept_name = dept_name
        self.dept_struct_type = dept_struct_type
        self.dept_type = dept_type
        self.struct_dept_id = struct_dept_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dept_id is not None:
            result['deptId'] = self.dept_id
        if self.dept_name is not None:
            result['deptName'] = self.dept_name
        if self.dept_struct_type is not None:
            result['deptStructType'] = self.dept_struct_type
        if self.dept_type is not None:
            result['deptType'] = self.dept_type
        if self.struct_dept_id is not None:
            result['structDeptId'] = self.struct_dept_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('deptId') is not None:
            self.dept_id = m.get('deptId')
        if m.get('deptName') is not None:
            self.dept_name = m.get('deptName')
        if m.get('deptStructType') is not None:
            self.dept_struct_type = m.get('deptStructType')
        if m.get('deptType') is not None:
            self.dept_type = m.get('deptType')
        if m.get('structDeptId') is not None:
            self.struct_dept_id = m.get('structDeptId')
        return self


class QueryCollegeContactUserDetailResponseBodyResultLeaderInDept(TeaModel):
    def __init__(
        self,
        dept_id: int = None,
        leader: bool = None,
    ):
        self.dept_id = dept_id
        self.leader = leader

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dept_id is not None:
            result['deptId'] = self.dept_id
        if self.leader is not None:
            result['leader'] = self.leader
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('deptId') is not None:
            self.dept_id = m.get('deptId')
        if m.get('leader') is not None:
            self.leader = m.get('leader')
        return self


class QueryCollegeContactUserDetailResponseBodyResultRoleList(TeaModel):
    def __init__(
        self,
        group_name: str = None,
        id: int = None,
        name: str = None,
    ):
        self.group_name = group_name
        self.id = id
        self.name = name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.group_name is not None:
            result['groupName'] = self.group_name
        if self.id is not None:
            result['id'] = self.id
        if self.name is not None:
            result['name'] = self.name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('groupName') is not None:
            self.group_name = m.get('groupName')
        if m.get('id') is not None:
            self.id = m.get('id')
        if m.get('name') is not None:
            self.name = m.get('name')
        return self


class QueryCollegeContactUserDetailResponseBodyResultUnionEmpExtUnionEmpMapList(TeaModel):
    def __init__(
        self,
        corp_id: str = None,
        userid: str = None,
    ):
        self.corp_id = corp_id
        self.userid = userid

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.corp_id is not None:
            result['corpId'] = self.corp_id
        if self.userid is not None:
            result['userid'] = self.userid
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('corpId') is not None:
            self.corp_id = m.get('corpId')
        if m.get('userid') is not None:
            self.userid = m.get('userid')
        return self


class QueryCollegeContactUserDetailResponseBodyResultUnionEmpExt(TeaModel):
    def __init__(
        self,
        corp_id: str = None,
        union_emp_map_list: List[QueryCollegeContactUserDetailResponseBodyResultUnionEmpExtUnionEmpMapList] = None,
        userid: str = None,
    ):
        self.corp_id = corp_id
        self.union_emp_map_list = union_emp_map_list
        self.userid = userid

    def validate(self):
        if self.union_emp_map_list:
            for k in self.union_emp_map_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.corp_id is not None:
            result['corpId'] = self.corp_id
        result['unionEmpMapList'] = []
        if self.union_emp_map_list is not None:
            for k in self.union_emp_map_list:
                result['unionEmpMapList'].append(k.to_map() if k else None)
        if self.userid is not None:
            result['userid'] = self.userid
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('corpId') is not None:
            self.corp_id = m.get('corpId')
        self.union_emp_map_list = []
        if m.get('unionEmpMapList') is not None:
            for k in m.get('unionEmpMapList'):
                temp_model = QueryCollegeContactUserDetailResponseBodyResultUnionEmpExtUnionEmpMapList()
                self.union_emp_map_list.append(temp_model.from_map(k))
        if m.get('userid') is not None:
            self.userid = m.get('userid')
        return self


class QueryCollegeContactUserDetailResponseBodyResult(TeaModel):
    def __init__(
        self,
        active: bool = None,
        admin: bool = None,
        avatar: str = None,
        boss: bool = None,
        dept_id_list: List[int] = None,
        dept_order_list: List[QueryCollegeContactUserDetailResponseBodyResultDeptOrderList] = None,
        dept_position_set: List[QueryCollegeContactUserDetailResponseBodyResultDeptPositionSet] = None,
        dept_type_set: List[QueryCollegeContactUserDetailResponseBodyResultDeptTypeSet] = None,
        email: str = None,
        emp_type: str = None,
        exclusive_account: bool = None,
        exclusive_account_corp_id: str = None,
        exclusive_account_corp_name: str = None,
        exclusive_account_type: str = None,
        extension: str = None,
        hide_mobile: bool = None,
        hired_date: int = None,
        job_number: str = None,
        leader_in_dept: List[QueryCollegeContactUserDetailResponseBodyResultLeaderInDept] = None,
        login_id: str = None,
        login_type: str = None,
        main_dept_id: int = None,
        manager_userid: str = None,
        mobile: str = None,
        name: str = None,
        org_email: str = None,
        org_email_type: str = None,
        real_authed: bool = None,
        remark: str = None,
        role_list: List[QueryCollegeContactUserDetailResponseBodyResultRoleList] = None,
        senior: bool = None,
        state_code: str = None,
        telephone: str = None,
        title: str = None,
        union_emp_ext: QueryCollegeContactUserDetailResponseBodyResultUnionEmpExt = None,
        union_id: str = None,
        userid: str = None,
        work_place: str = None,
    ):
        self.active = active
        self.admin = admin
        self.avatar = avatar
        self.boss = boss
        self.dept_id_list = dept_id_list
        self.dept_order_list = dept_order_list
        self.dept_position_set = dept_position_set
        self.dept_type_set = dept_type_set
        self.email = email
        self.emp_type = emp_type
        self.exclusive_account = exclusive_account
        self.exclusive_account_corp_id = exclusive_account_corp_id
        self.exclusive_account_corp_name = exclusive_account_corp_name
        self.exclusive_account_type = exclusive_account_type
        self.extension = extension
        self.hide_mobile = hide_mobile
        self.hired_date = hired_date
        self.job_number = job_number
        self.leader_in_dept = leader_in_dept
        self.login_id = login_id
        self.login_type = login_type
        self.main_dept_id = main_dept_id
        self.manager_userid = manager_userid
        self.mobile = mobile
        self.name = name
        self.org_email = org_email
        self.org_email_type = org_email_type
        self.real_authed = real_authed
        self.remark = remark
        self.role_list = role_list
        self.senior = senior
        self.state_code = state_code
        self.telephone = telephone
        self.title = title
        self.union_emp_ext = union_emp_ext
        self.union_id = union_id
        self.userid = userid
        self.work_place = work_place

    def validate(self):
        if self.dept_order_list:
            for k in self.dept_order_list:
                if k:
                    k.validate()
        if self.dept_position_set:
            for k in self.dept_position_set:
                if k:
                    k.validate()
        if self.dept_type_set:
            for k in self.dept_type_set:
                if k:
                    k.validate()
        if self.leader_in_dept:
            for k in self.leader_in_dept:
                if k:
                    k.validate()
        if self.role_list:
            for k in self.role_list:
                if k:
                    k.validate()
        if self.union_emp_ext:
            self.union_emp_ext.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.active is not None:
            result['active'] = self.active
        if self.admin is not None:
            result['admin'] = self.admin
        if self.avatar is not None:
            result['avatar'] = self.avatar
        if self.boss is not None:
            result['boss'] = self.boss
        if self.dept_id_list is not None:
            result['deptIdList'] = self.dept_id_list
        result['deptOrderList'] = []
        if self.dept_order_list is not None:
            for k in self.dept_order_list:
                result['deptOrderList'].append(k.to_map() if k else None)
        result['deptPositionSet'] = []
        if self.dept_position_set is not None:
            for k in self.dept_position_set:
                result['deptPositionSet'].append(k.to_map() if k else None)
        result['deptTypeSet'] = []
        if self.dept_type_set is not None:
            for k in self.dept_type_set:
                result['deptTypeSet'].append(k.to_map() if k else None)
        if self.email is not None:
            result['email'] = self.email
        if self.emp_type is not None:
            result['empType'] = self.emp_type
        if self.exclusive_account is not None:
            result['exclusiveAccount'] = self.exclusive_account
        if self.exclusive_account_corp_id is not None:
            result['exclusiveAccountCorpId'] = self.exclusive_account_corp_id
        if self.exclusive_account_corp_name is not None:
            result['exclusiveAccountCorpName'] = self.exclusive_account_corp_name
        if self.exclusive_account_type is not None:
            result['exclusiveAccountType'] = self.exclusive_account_type
        if self.extension is not None:
            result['extension'] = self.extension
        if self.hide_mobile is not None:
            result['hideMobile'] = self.hide_mobile
        if self.hired_date is not None:
            result['hiredDate'] = self.hired_date
        if self.job_number is not None:
            result['jobNumber'] = self.job_number
        result['leaderInDept'] = []
        if self.leader_in_dept is not None:
            for k in self.leader_in_dept:
                result['leaderInDept'].append(k.to_map() if k else None)
        if self.login_id is not None:
            result['loginId'] = self.login_id
        if self.login_type is not None:
            result['loginType'] = self.login_type
        if self.main_dept_id is not None:
            result['mainDeptId'] = self.main_dept_id
        if self.manager_userid is not None:
            result['managerUserid'] = self.manager_userid
        if self.mobile is not None:
            result['mobile'] = self.mobile
        if self.name is not None:
            result['name'] = self.name
        if self.org_email is not None:
            result['orgEmail'] = self.org_email
        if self.org_email_type is not None:
            result['orgEmailType'] = self.org_email_type
        if self.real_authed is not None:
            result['realAuthed'] = self.real_authed
        if self.remark is not None:
            result['remark'] = self.remark
        result['roleList'] = []
        if self.role_list is not None:
            for k in self.role_list:
                result['roleList'].append(k.to_map() if k else None)
        if self.senior is not None:
            result['senior'] = self.senior
        if self.state_code is not None:
            result['stateCode'] = self.state_code
        if self.telephone is not None:
            result['telephone'] = self.telephone
        if self.title is not None:
            result['title'] = self.title
        if self.union_emp_ext is not None:
            result['unionEmpExt'] = self.union_emp_ext.to_map()
        if self.union_id is not None:
            result['unionId'] = self.union_id
        if self.userid is not None:
            result['userid'] = self.userid
        if self.work_place is not None:
            result['workPlace'] = self.work_place
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('active') is not None:
            self.active = m.get('active')
        if m.get('admin') is not None:
            self.admin = m.get('admin')
        if m.get('avatar') is not None:
            self.avatar = m.get('avatar')
        if m.get('boss') is not None:
            self.boss = m.get('boss')
        if m.get('deptIdList') is not None:
            self.dept_id_list = m.get('deptIdList')
        self.dept_order_list = []
        if m.get('deptOrderList') is not None:
            for k in m.get('deptOrderList'):
                temp_model = QueryCollegeContactUserDetailResponseBodyResultDeptOrderList()
                self.dept_order_list.append(temp_model.from_map(k))
        self.dept_position_set = []
        if m.get('deptPositionSet') is not None:
            for k in m.get('deptPositionSet'):
                temp_model = QueryCollegeContactUserDetailResponseBodyResultDeptPositionSet()
                self.dept_position_set.append(temp_model.from_map(k))
        self.dept_type_set = []
        if m.get('deptTypeSet') is not None:
            for k in m.get('deptTypeSet'):
                temp_model = QueryCollegeContactUserDetailResponseBodyResultDeptTypeSet()
                self.dept_type_set.append(temp_model.from_map(k))
        if m.get('email') is not None:
            self.email = m.get('email')
        if m.get('empType') is not None:
            self.emp_type = m.get('empType')
        if m.get('exclusiveAccount') is not None:
            self.exclusive_account = m.get('exclusiveAccount')
        if m.get('exclusiveAccountCorpId') is not None:
            self.exclusive_account_corp_id = m.get('exclusiveAccountCorpId')
        if m.get('exclusiveAccountCorpName') is not None:
            self.exclusive_account_corp_name = m.get('exclusiveAccountCorpName')
        if m.get('exclusiveAccountType') is not None:
            self.exclusive_account_type = m.get('exclusiveAccountType')
        if m.get('extension') is not None:
            self.extension = m.get('extension')
        if m.get('hideMobile') is not None:
            self.hide_mobile = m.get('hideMobile')
        if m.get('hiredDate') is not None:
            self.hired_date = m.get('hiredDate')
        if m.get('jobNumber') is not None:
            self.job_number = m.get('jobNumber')
        self.leader_in_dept = []
        if m.get('leaderInDept') is not None:
            for k in m.get('leaderInDept'):
                temp_model = QueryCollegeContactUserDetailResponseBodyResultLeaderInDept()
                self.leader_in_dept.append(temp_model.from_map(k))
        if m.get('loginId') is not None:
            self.login_id = m.get('loginId')
        if m.get('loginType') is not None:
            self.login_type = m.get('loginType')
        if m.get('mainDeptId') is not None:
            self.main_dept_id = m.get('mainDeptId')
        if m.get('managerUserid') is not None:
            self.manager_userid = m.get('managerUserid')
        if m.get('mobile') is not None:
            self.mobile = m.get('mobile')
        if m.get('name') is not None:
            self.name = m.get('name')
        if m.get('orgEmail') is not None:
            self.org_email = m.get('orgEmail')
        if m.get('orgEmailType') is not None:
            self.org_email_type = m.get('orgEmailType')
        if m.get('realAuthed') is not None:
            self.real_authed = m.get('realAuthed')
        if m.get('remark') is not None:
            self.remark = m.get('remark')
        self.role_list = []
        if m.get('roleList') is not None:
            for k in m.get('roleList'):
                temp_model = QueryCollegeContactUserDetailResponseBodyResultRoleList()
                self.role_list.append(temp_model.from_map(k))
        if m.get('senior') is not None:
            self.senior = m.get('senior')
        if m.get('stateCode') is not None:
            self.state_code = m.get('stateCode')
        if m.get('telephone') is not None:
            self.telephone = m.get('telephone')
        if m.get('title') is not None:
            self.title = m.get('title')
        if m.get('unionEmpExt') is not None:
            temp_model = QueryCollegeContactUserDetailResponseBodyResultUnionEmpExt()
            self.union_emp_ext = temp_model.from_map(m['unionEmpExt'])
        if m.get('unionId') is not None:
            self.union_id = m.get('unionId')
        if m.get('userid') is not None:
            self.userid = m.get('userid')
        if m.get('workPlace') is not None:
            self.work_place = m.get('workPlace')
        return self


class QueryCollegeContactUserDetailResponseBody(TeaModel):
    def __init__(
        self,
        result: QueryCollegeContactUserDetailResponseBodyResult = None,
        success: bool = None,
    ):
        self.result = result
        self.success = success

    def validate(self):
        if self.result:
            self.result.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.result is not None:
            result['result'] = self.result.to_map()
        if self.success is not None:
            result['success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('result') is not None:
            temp_model = QueryCollegeContactUserDetailResponseBodyResult()
            self.result = temp_model.from_map(m['result'])
        if m.get('success') is not None:
            self.success = m.get('success')
        return self


class QueryCollegeContactUserDetailResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: QueryCollegeContactUserDetailResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = QueryCollegeContactUserDetailResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class QueryDeviceHeaders(TeaModel):
    def __init__(
        self,
        common_headers: Dict[str, str] = None,
        x_acs_dingtalk_access_token: str = None,
    ):
        self.common_headers = common_headers
        self.x_acs_dingtalk_access_token = x_acs_dingtalk_access_token

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.common_headers is not None:
            result['commonHeaders'] = self.common_headers
        if self.x_acs_dingtalk_access_token is not None:
            result['x-acs-dingtalk-access-token'] = self.x_acs_dingtalk_access_token
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('commonHeaders') is not None:
            self.common_headers = m.get('commonHeaders')
        if m.get('x-acs-dingtalk-access-token') is not None:
            self.x_acs_dingtalk_access_token = m.get('x-acs-dingtalk-access-token')
        return self


class QueryDeviceRequest(TeaModel):
    def __init__(
        self,
        sn: str = None,
    ):
        # This parameter is required.
        self.sn = sn

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.sn is not None:
            result['sn'] = self.sn
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('sn') is not None:
            self.sn = m.get('sn')
        return self


class QueryDeviceResponseBody(TeaModel):
    def __init__(
        self,
        gmt_expiry: int = None,
        model: str = None,
        name: str = None,
        sn: str = None,
        type: str = None,
    ):
        self.gmt_expiry = gmt_expiry
        self.model = model
        self.name = name
        self.sn = sn
        self.type = type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.gmt_expiry is not None:
            result['gmtExpiry'] = self.gmt_expiry
        if self.model is not None:
            result['model'] = self.model
        if self.name is not None:
            result['name'] = self.name
        if self.sn is not None:
            result['sn'] = self.sn
        if self.type is not None:
            result['type'] = self.type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('gmtExpiry') is not None:
            self.gmt_expiry = m.get('gmtExpiry')
        if m.get('model') is not None:
            self.model = m.get('model')
        if m.get('name') is not None:
            self.name = m.get('name')
        if m.get('sn') is not None:
            self.sn = m.get('sn')
        if m.get('type') is not None:
            self.type = m.get('type')
        return self


class QueryDeviceResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: QueryDeviceResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = QueryDeviceResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class QueryDeviceListByCorpIdHeaders(TeaModel):
    def __init__(
        self,
        common_headers: Dict[str, str] = None,
        x_acs_dingtalk_access_token: str = None,
    ):
        self.common_headers = common_headers
        self.x_acs_dingtalk_access_token = x_acs_dingtalk_access_token

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.common_headers is not None:
            result['commonHeaders'] = self.common_headers
        if self.x_acs_dingtalk_access_token is not None:
            result['x-acs-dingtalk-access-token'] = self.x_acs_dingtalk_access_token
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('commonHeaders') is not None:
            self.common_headers = m.get('commonHeaders')
        if m.get('x-acs-dingtalk-access-token') is not None:
            self.x_acs_dingtalk_access_token = m.get('x-acs-dingtalk-access-token')
        return self


class QueryDeviceListByCorpIdRequest(TeaModel):
    def __init__(
        self,
        operator: str = None,
        page_number: int = None,
        page_size: int = None,
    ):
        # This parameter is required.
        self.operator = operator
        # This parameter is required.
        self.page_number = page_number
        # This parameter is required.
        self.page_size = page_size

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.operator is not None:
            result['operator'] = self.operator
        if self.page_number is not None:
            result['pageNumber'] = self.page_number
        if self.page_size is not None:
            result['pageSize'] = self.page_size
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('operator') is not None:
            self.operator = m.get('operator')
        if m.get('pageNumber') is not None:
            self.page_number = m.get('pageNumber')
        if m.get('pageSize') is not None:
            self.page_size = m.get('pageSize')
        return self


class QueryDeviceListByCorpIdResponseBodyResultList(TeaModel):
    def __init__(
        self,
        app_status: int = None,
        device_code: str = None,
        device_name: str = None,
    ):
        # This parameter is required.
        self.app_status = app_status
        # This parameter is required.
        self.device_code = device_code
        # This parameter is required.
        self.device_name = device_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.app_status is not None:
            result['appStatus'] = self.app_status
        if self.device_code is not None:
            result['deviceCode'] = self.device_code
        if self.device_name is not None:
            result['deviceName'] = self.device_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('appStatus') is not None:
            self.app_status = m.get('appStatus')
        if m.get('deviceCode') is not None:
            self.device_code = m.get('deviceCode')
        if m.get('deviceName') is not None:
            self.device_name = m.get('deviceName')
        return self


class QueryDeviceListByCorpIdResponseBodyResult(TeaModel):
    def __init__(
        self,
        has_more: bool = None,
        list: List[QueryDeviceListByCorpIdResponseBodyResultList] = None,
    ):
        # This parameter is required.
        self.has_more = has_more
        # This parameter is required.
        self.list = list

    def validate(self):
        if self.list:
            for k in self.list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.has_more is not None:
            result['hasMore'] = self.has_more
        result['list'] = []
        if self.list is not None:
            for k in self.list:
                result['list'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('hasMore') is not None:
            self.has_more = m.get('hasMore')
        self.list = []
        if m.get('list') is not None:
            for k in m.get('list'):
                temp_model = QueryDeviceListByCorpIdResponseBodyResultList()
                self.list.append(temp_model.from_map(k))
        return self


class QueryDeviceListByCorpIdResponseBody(TeaModel):
    def __init__(
        self,
        result: QueryDeviceListByCorpIdResponseBodyResult = None,
        success: bool = None,
    ):
        # This parameter is required.
        self.result = result
        self.success = success

    def validate(self):
        if self.result:
            self.result.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.result is not None:
            result['result'] = self.result.to_map()
        if self.success is not None:
            result['success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('result') is not None:
            temp_model = QueryDeviceListByCorpIdResponseBodyResult()
            self.result = temp_model.from_map(m['result'])
        if m.get('success') is not None:
            self.success = m.get('success')
        return self


class QueryDeviceListByCorpIdResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: QueryDeviceListByCorpIdResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.he