# AUTOGENERATED! DO NOT EDIT! File to edit: ../nbs/00_connect.ipynb.

# %% auto 0
__all__ = ['config', 'DbConnection']

# %% ../nbs/00_connect.ipynb 3
from configparser import ConfigParser
import psycopg2
import pandas as pd

# %% ../nbs/00_connect.ipynb 4
def config(filename="../database.ini", section="postgresql"):
    """Reads the database.ini file and returns the connection parameters as a dictionary.
    Assumes the ini file is in the parent directory"""
    # create a parser
    parser = ConfigParser()
    # read config file
    parser.read(filename)

    # get section, default to postgresql
    db = {}
    if parser.has_section(section):
        params = parser.items(section)
        for param in params:
            db[param[0]] = param[1]
    else:
        # raise Exception(
        #     "Section {0} not found in the {1} file".format(section, filename)
        # )
        print("Section {0} not found in the {1} file".format(section, filename))
        
    return db

# %% ../nbs/00_connect.ipynb 10
class DbConnection:
    "Class to create a connection to the database"
    def __init__(self, 
                params:dict):
        #todo add checks for params type and values
        if not isinstance(params, dict):
            raise TypeError(f"params must be a dictionary")
        self.params = params 
        self.conn = None
    def __str__(self): return f"connection object"
    __repr__ = __str__

    def _connect(self):
        try:
            self.conn = psycopg2.connect(**self.params)
        except:
            print("Unable to connect to the database.")

    def _close(self):
        if self.conn is not None:
            self.conn.close()
        else:
            print("Connection already closed. No action taken.")

    def pull_data(self, tablename):

        """
        Pulls data from the database for a given table and returns a pandas dataframe.
        See https://pklmart.com/postgres_pklm_pklm_prd/relationships.html for a list of tables.
        """
        #Open the connection
        self._connect()

        with self.conn.cursor() as cursor:
            try:
                cursor.execute(
                    f"SELECT column_name FROM information_schema.columns where table_name='{tablename}';"
                )
                cols = cursor.fetchall()
                cols = [cols[x][0] for x in range(len(cols))]
                cursor.execute(f"SELECT * FROM pklm_prd.{tablename}")
                data = cursor.fetchall()
                self._close()
                return pd.DataFrame(data, columns=cols)
            except Exception as inst:
                print(type(inst))
                print(inst.args)
                print(inst)
