# AUTOGENERATED! DO NOT EDIT! File to edit: ../nbs/03_stats.ipynb.

# %% auto 0
__all__ = ['team_first_serve_win_frac', 'get_first_serve_team', 'get_frac_first_serve_wins', 'get_teams_from_player',
           'team_win_frac', 'games_played_by_team']

# %% ../nbs/03_stats.ipynb 3
from .data import *
from .name import *
from .team import *
from .game import *
from .player import *

# %% ../nbs/03_stats.ipynb 5
def team_first_serve_win_frac(team_id):
    '''
    Takes a team id and returns that team's first serve win fraction.
    '''
    # Get all rallies where the team served the first rally of the game
    rally_fs_df = rally[(rally.rally_nbr == 1) & (rally.srv_team_id == team_id)]
    num_first_serves = len(rally_fs_df)
    #Find the number of games won by the team when they served first
    num_first_serve_games_won = sum(game[game.game_id.isin(rally_fs_df.game_id)].w_team_id == team_id)
    if num_first_serves == 0:
        return 0
    else:
        return num_first_serve_games_won/num_first_serves

# %% ../nbs/03_stats.ipynb 10
def get_first_serve_team(game_id: str):
    '''
    Returns the team_id of the team that served first for a given game with game_id.
    '''
    return rally[(rally.game_id == game_id) & (rally.rally_nbr == 1)].srv_team_id.values[0]

def get_frac_first_serve_wins(game_df):
    '''
    Returns the fraction of games won by the first searver for a given df of games.
    '''
    count = 0
    for game_id in game_df.game_id:
        if (game_df[game_df.game_id == game_id].w_team_id == get_first_serve_team(game_id)).values[0]:
            count +=1 
    return count/len(game_df)

# %% ../nbs/03_stats.ipynb 13
def get_teams_from_player(player_id: str):
    '''
    Returns the team_ids of the teams that a player with player_id played for.
    '''
    return team[team.player_id == player_id].team_id.values

def team_win_frac(team_id: str):
    '''
    Returns the fraction of games won by a team with team_id.
    '''
    t = Team(team_id)
    return t.num_games_won/t.num_games_played

# %% ../nbs/03_stats.ipynb 18
def games_played_by_team(team_id):
    '''
    Returns the number of games played by a team with team_id.
    '''
    return len(game[(game.w_team_id == team_id) | (game.l_team_id == team_id)])
