import { LogGroup } from 'aws-cdk-lib/aws-logs';
import { Construct } from 'constructs';
import { ArchiverProperties } from './archiverProperties';
export declare class Archiver extends Construct {
    props: ArchiverProperties;
    /**
     * Log group used by the CodeBuild projects.
     *
     * @type {LogGroup}
     * @memberof Archiver
     */
    logGroup: LogGroup;
    constructor(scope: Construct, id: string, props: ArchiverProperties);
    private createLogGroup;
    /**
     *Create the S3 bucket that will later store the repositories.
     *
     * @private
     * @return {*}
     * @memberof Archiver
     */
    private createArchiveBucket;
    private createLogGroupKey;
    /**
     * Creates for each backup configuration a separate CodeBuild project
     *
     * @private
     * @param {s3.Bucket} bucket
     * @memberof Archiver
     */
    private createProjects;
    /**
     * Create a CodeBuild project
     *
     * @private
     * @param {BackupConfiguration} element
     * @param {cdk.aws_s3.Bucket} bucket
     * @return {*}
     * @memberof Archiver
     */
    private createProject;
    private createBatchConfiguration;
}
export interface BatchListElement {
    readonly identifier: string;
    readonly env: Object;
}
