from datetime import date
from lxml.etree import _Element
from openpyxl.cell.cell import Cell
from openpyxl.worksheet.worksheet import Worksheet
from typing import (
    Any,
    Dict,
    Iterator,
    List,
    Optional,
    Set,
    Tuple,
    Union,
)
from xml.etree.ElementTree import Element
from zipfile import ZipExtFile

def _cast_number(value: str) -> Union[float, int]: ...

class WorkSheetParser:
    def __init__(
        self,
        src: Optional[Union[ZipExtFile, str]],
        shared_strings: Optional[Union[Dict[int, str], List[str]]],
        data_only: Optional[bool] = ...,
        epoch: Optional[Union[date, float]] = ...,
        date_formats: Set[int] = ...,
    ) -> None: ...
    def parse(self) -> Iterator[Any]: ...
    def parse_cell(self, element: Union[_Element, Element]) -> Dict[str, Any]: ...
    def parse_col_breaks(self, element: _Element) -> None: ...
    def parse_column_dimensions(self, col: Union[_Element, Element]) -> None: ...
    def parse_custom_views(self, element: Element) -> None: ...
    def parse_dimensions(
        self,
    ) -> Optional[Union[Tuple[int, int, int, int], Tuple[None, int, None, int]]]: ...
    def parse_extensions(self, element: Union[_Element, Element]) -> None: ...
    def parse_formatting(self, element: Union[_Element, Element]) -> None: ...
    def parse_formula(self, element: Union[_Element, Element]) -> str: ...
    def parse_legacy(self, element: Union[_Element, Element]) -> None: ...
    def parse_row(self, row: Union[_Element, Element]) -> Any: ...
    def parse_row_breaks(self, element: Union[_Element, Element]) -> None: ...
    def parse_sheet_protection(self, element: Union[_Element, Element]) -> None: ...

class WorksheetReader:
    def __init__(
        self,
        ws: Worksheet,
        xml_source: Union[ZipExtFile, str],
        shared_strings: Optional[List[str]],
        data_only: Optional[bool],
    ) -> None: ...
    def bind_all(self) -> None: ...
    def bind_cells(self) -> None: ...
    def bind_col_dimensions(self) -> None: ...
    def bind_formatting(self) -> None: ...
    def bind_hyperlinks(self) -> None: ...
    def bind_merged_cells(self) -> None: ...
    def bind_properties(self) -> None: ...
    def bind_row_dimensions(self) -> None: ...
    def bind_tables(self) -> None: ...
    def normalize_merged_cell_link(self, coord: str) -> Optional[Cell]: ...
