# coding: utf-8

"""
    Data Repository API

    <details><summary>This document defines the REST API for the Terra Data Repository.</summary> <p> **Status: design in progress** There are a few top-level endpoints (besides some used by swagger):  * / - generated by swagger: swagger API page that provides this documentation and a live UI for submitting REST requests  * /status - provides the operational status of the service  * /configuration - provides the basic configuration and information about the service  * /api - is the authenticated and authorized Data Repository API  * /ga4gh/drs/v1 - is a transcription of the Data Repository Service API  The API endpoints are organized by interface. Each interface is separately versioned. <p> **Notes on Naming** <p> All of the reference items are suffixed with \\\"Model\\\". Those names are used as the class names in the generated Java code. It is helpful to distinguish these model classes from other related classes, like the DAO classes and the operation classes. </details>   # noqa: E501

    The version of the OpenAPI document: 0.1.0
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from data_repo_client.configuration import Configuration


class BulkLoadHistoryModel(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'source_path': 'str',
        'target_path': 'str',
        'state': 'BulkLoadFileState',
        'file_id': 'str',
        'checksum_crc': 'str',
        'checksum_md5': 'str',
        'error': 'str'
    }

    attribute_map = {
        'source_path': 'sourcePath',
        'target_path': 'targetPath',
        'state': 'state',
        'file_id': 'fileId',
        'checksum_crc': 'checksumCRC',
        'checksum_md5': 'checksumMD5',
        'error': 'error'
    }

    def __init__(self, source_path=None, target_path=None, state=None, file_id=None, checksum_crc=None, checksum_md5=None, error=None, local_vars_configuration=None):  # noqa: E501
        """BulkLoadHistoryModel - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._source_path = None
        self._target_path = None
        self._state = None
        self._file_id = None
        self._checksum_crc = None
        self._checksum_md5 = None
        self._error = None
        self.discriminator = None

        self.source_path = source_path
        self.target_path = target_path
        if state is not None:
            self.state = state
        if file_id is not None:
            self.file_id = file_id
        if checksum_crc is not None:
            self.checksum_crc = checksum_crc
        if checksum_md5 is not None:
            self.checksum_md5 = checksum_md5
        if error is not None:
            self.error = error

    @property
    def source_path(self):
        """Gets the source_path of this BulkLoadHistoryModel.  # noqa: E501

        gs URL of the source file to load  # noqa: E501

        :return: The source_path of this BulkLoadHistoryModel.  # noqa: E501
        :rtype: str
        """
        return self._source_path

    @source_path.setter
    def source_path(self, source_path):
        """Sets the source_path of this BulkLoadHistoryModel.

        gs URL of the source file to load  # noqa: E501

        :param source_path: The source_path of this BulkLoadHistoryModel.  # noqa: E501
        :type: str
        """
        if self.local_vars_configuration.client_side_validation and source_path is None:  # noqa: E501
            raise ValueError("Invalid value for `source_path`, must not be `None`")  # noqa: E501

        self._source_path = source_path

    @property
    def target_path(self):
        """Gets the target_path of this BulkLoadHistoryModel.  # noqa: E501

        Full path within the dataset where the file should be placed. The path must start with /.   # noqa: E501

        :return: The target_path of this BulkLoadHistoryModel.  # noqa: E501
        :rtype: str
        """
        return self._target_path

    @target_path.setter
    def target_path(self, target_path):
        """Sets the target_path of this BulkLoadHistoryModel.

        Full path within the dataset where the file should be placed. The path must start with /.   # noqa: E501

        :param target_path: The target_path of this BulkLoadHistoryModel.  # noqa: E501
        :type: str
        """
        if self.local_vars_configuration.client_side_validation and target_path is None:  # noqa: E501
            raise ValueError("Invalid value for `target_path`, must not be `None`")  # noqa: E501

        self._target_path = target_path

    @property
    def state(self):
        """Gets the state of this BulkLoadHistoryModel.  # noqa: E501


        :return: The state of this BulkLoadHistoryModel.  # noqa: E501
        :rtype: BulkLoadFileState
        """
        return self._state

    @state.setter
    def state(self, state):
        """Sets the state of this BulkLoadHistoryModel.


        :param state: The state of this BulkLoadHistoryModel.  # noqa: E501
        :type: BulkLoadFileState
        """

        self._state = state

    @property
    def file_id(self):
        """Gets the file_id of this BulkLoadHistoryModel.  # noqa: E501

        The fileId of the loaded file; non-null if state is SUCCEEDED  # noqa: E501

        :return: The file_id of this BulkLoadHistoryModel.  # noqa: E501
        :rtype: str
        """
        return self._file_id

    @file_id.setter
    def file_id(self, file_id):
        """Sets the file_id of this BulkLoadHistoryModel.

        The fileId of the loaded file; non-null if state is SUCCEEDED  # noqa: E501

        :param file_id: The file_id of this BulkLoadHistoryModel.  # noqa: E501
        :type: str
        """

        self._file_id = file_id

    @property
    def checksum_crc(self):
        """Gets the checksum_crc of this BulkLoadHistoryModel.  # noqa: E501

        The checksum crc of the loaded file; non-null if state is SUCCEEDED  # noqa: E501

        :return: The checksum_crc of this BulkLoadHistoryModel.  # noqa: E501
        :rtype: str
        """
        return self._checksum_crc

    @checksum_crc.setter
    def checksum_crc(self, checksum_crc):
        """Sets the checksum_crc of this BulkLoadHistoryModel.

        The checksum crc of the loaded file; non-null if state is SUCCEEDED  # noqa: E501

        :param checksum_crc: The checksum_crc of this BulkLoadHistoryModel.  # noqa: E501
        :type: str
        """

        self._checksum_crc = checksum_crc

    @property
    def checksum_md5(self):
        """Gets the checksum_md5 of this BulkLoadHistoryModel.  # noqa: E501

        The checksum mD5 of the loaded file; non-null if state is SUCCEEDED  # noqa: E501

        :return: The checksum_md5 of this BulkLoadHistoryModel.  # noqa: E501
        :rtype: str
        """
        return self._checksum_md5

    @checksum_md5.setter
    def checksum_md5(self, checksum_md5):
        """Sets the checksum_md5 of this BulkLoadHistoryModel.

        The checksum mD5 of the loaded file; non-null if state is SUCCEEDED  # noqa: E501

        :param checksum_md5: The checksum_md5 of this BulkLoadHistoryModel.  # noqa: E501
        :type: str
        """

        self._checksum_md5 = checksum_md5

    @property
    def error(self):
        """Gets the error of this BulkLoadHistoryModel.  # noqa: E501

        The error message if state is FAILED  # noqa: E501

        :return: The error of this BulkLoadHistoryModel.  # noqa: E501
        :rtype: str
        """
        return self._error

    @error.setter
    def error(self, error):
        """Sets the error of this BulkLoadHistoryModel.

        The error message if state is FAILED  # noqa: E501

        :param error: The error of this BulkLoadHistoryModel.  # noqa: E501
        :type: str
        """

        self._error = error

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, BulkLoadHistoryModel):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, BulkLoadHistoryModel):
            return True

        return self.to_dict() != other.to_dict()
