import logging
logging.getLogger(__name__).addHandler(logging.NullHandler())

from .project import Project
from .fs import Fs
from .featherfs import FeatherFs
from .parquetfs import ParquetFs
from .plotfs import PlotFs
from .hasher import PandasObjectHasher
from .logger import ProjectLogger

__version__ = '0.8.4'
__author__ = "David Riedel"
__author_email__ = "systemverwalter@gmail.com"


__all__ = [
            'Project',
            'Fs',
            'FeatherFs',
            'ParquetFs',
            'PlotFs',
            'PandasObjectHasher',
            'ProjectLogger',
          ]
