import * as cdk from '@aws-cdk/core';
import * as cfn_parse from '@aws-cdk/core/lib/cfn-parse';
/**
 * Properties for defining a `AWS::MWAA::Environment`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mwaa-environment.html
 * @external
 */
export interface CfnEnvironmentProps {
    /**
     * `AWS::MWAA::Environment.AirflowConfigurationOptions`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mwaa-environment.html#cfn-mwaa-environment-airflowconfigurationoptions
     * @external
     */
    readonly airflowConfigurationOptions?: CfnEnvironment.AirflowConfigurationOptionsProperty | cdk.IResolvable;
    /**
     * `AWS::MWAA::Environment.AirflowVersion`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mwaa-environment.html#cfn-mwaa-environment-airflowversion
     * @external
     */
    readonly airflowVersion?: string;
    /**
     * `AWS::MWAA::Environment.DagS3Path`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mwaa-environment.html#cfn-mwaa-environment-dags3path
     * @external
     */
    readonly dagS3Path?: string;
    /**
     * `AWS::MWAA::Environment.EnvironmentClass`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mwaa-environment.html#cfn-mwaa-environment-environmentclass
     * @external
     */
    readonly environmentClass?: string;
    /**
     * `AWS::MWAA::Environment.ExecutionRoleArn`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mwaa-environment.html#cfn-mwaa-environment-executionrolearn
     * @external
     */
    readonly executionRoleArn?: string;
    /**
     * `AWS::MWAA::Environment.KmsKey`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mwaa-environment.html#cfn-mwaa-environment-kmskey
     * @external
     */
    readonly kmsKey?: string;
    /**
     * `AWS::MWAA::Environment.LoggingConfiguration`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mwaa-environment.html#cfn-mwaa-environment-loggingconfiguration
     * @external
     */
    readonly loggingConfiguration?: CfnEnvironment.LoggingConfigurationProperty | cdk.IResolvable;
    /**
     * `AWS::MWAA::Environment.MaxWorkers`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mwaa-environment.html#cfn-mwaa-environment-maxworkers
     * @external
     */
    readonly maxWorkers?: number;
    /**
     * `AWS::MWAA::Environment.NetworkConfiguration`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mwaa-environment.html#cfn-mwaa-environment-networkconfiguration
     * @external
     */
    readonly networkConfiguration?: CfnEnvironment.NetworkConfigurationProperty | cdk.IResolvable;
    /**
     * `AWS::MWAA::Environment.PluginsS3ObjectVersion`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mwaa-environment.html#cfn-mwaa-environment-pluginss3objectversion
     * @external
     */
    readonly pluginsS3ObjectVersion?: string;
    /**
     * `AWS::MWAA::Environment.PluginsS3Path`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mwaa-environment.html#cfn-mwaa-environment-pluginss3path
     * @external
     */
    readonly pluginsS3Path?: string;
    /**
     * `AWS::MWAA::Environment.RequirementsS3ObjectVersion`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mwaa-environment.html#cfn-mwaa-environment-requirementss3objectversion
     * @external
     */
    readonly requirementsS3ObjectVersion?: string;
    /**
     * `AWS::MWAA::Environment.RequirementsS3Path`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mwaa-environment.html#cfn-mwaa-environment-requirementss3path
     * @external
     */
    readonly requirementsS3Path?: string;
    /**
     * `AWS::MWAA::Environment.SourceBucketArn`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mwaa-environment.html#cfn-mwaa-environment-sourcebucketarn
     * @external
     */
    readonly sourceBucketArn?: string;
    /**
     * `AWS::MWAA::Environment.Tags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mwaa-environment.html#cfn-mwaa-environment-tags
     * @external
     */
    readonly tags?: CfnEnvironment.TagMapProperty;
    /**
     * `AWS::MWAA::Environment.WebserverAccessMode`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mwaa-environment.html#cfn-mwaa-environment-webserveraccessmode
     * @external
     */
    readonly webserverAccessMode?: string;
    /**
     * `AWS::MWAA::Environment.WebserverUrl`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mwaa-environment.html#cfn-mwaa-environment-webserverurl
     * @external
     */
    readonly webserverUrl?: string;
    /**
     * `AWS::MWAA::Environment.WeeklyMaintenanceWindowStart`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mwaa-environment.html#cfn-mwaa-environment-weeklymaintenancewindowstart
     * @external
     */
    readonly weeklyMaintenanceWindowStart?: string;
}
/**
 * A CloudFormation `AWS::MWAA::Environment`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mwaa-environment.html
 * @external
 * @cloudformationResource AWS::MWAA::Environment
 */
export declare class CfnEnvironment extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::MWAA::Environment";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnEnvironment;
    /**
     * @external
     * @cloudformationAttribute Arn
     */
    readonly attrArn: string;
    /**
     * @external
     * @cloudformationAttribute CreatedAt
     */
    readonly attrCreatedAt: string;
    /**
     * @external
     * @cloudformationAttribute Name
     */
    readonly attrName: string;
    /**
     * @external
     * @cloudformationAttribute ServiceRoleArn
     */
    readonly attrServiceRoleArn: string;
    /**
     * @external
     * @cloudformationAttribute Status
     */
    readonly attrStatus: string;
    /**
     * `AWS::MWAA::Environment.AirflowConfigurationOptions`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mwaa-environment.html#cfn-mwaa-environment-airflowconfigurationoptions
     * @external
     */
    airflowConfigurationOptions: CfnEnvironment.AirflowConfigurationOptionsProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::MWAA::Environment.AirflowVersion`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mwaa-environment.html#cfn-mwaa-environment-airflowversion
     * @external
     */
    airflowVersion: string | undefined;
    /**
     * `AWS::MWAA::Environment.DagS3Path`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mwaa-environment.html#cfn-mwaa-environment-dags3path
     * @external
     */
    dagS3Path: string | undefined;
    /**
     * `AWS::MWAA::Environment.EnvironmentClass`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mwaa-environment.html#cfn-mwaa-environment-environmentclass
     * @external
     */
    environmentClass: string | undefined;
    /**
     * `AWS::MWAA::Environment.ExecutionRoleArn`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mwaa-environment.html#cfn-mwaa-environment-executionrolearn
     * @external
     */
    executionRoleArn: string | undefined;
    /**
     * `AWS::MWAA::Environment.KmsKey`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mwaa-environment.html#cfn-mwaa-environment-kmskey
     * @external
     */
    kmsKey: string | undefined;
    /**
     * `AWS::MWAA::Environment.LoggingConfiguration`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mwaa-environment.html#cfn-mwaa-environment-loggingconfiguration
     * @external
     */
    loggingConfiguration: CfnEnvironment.LoggingConfigurationProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::MWAA::Environment.MaxWorkers`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mwaa-environment.html#cfn-mwaa-environment-maxworkers
     * @external
     */
    maxWorkers: number | undefined;
    /**
     * `AWS::MWAA::Environment.NetworkConfiguration`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mwaa-environment.html#cfn-mwaa-environment-networkconfiguration
     * @external
     */
    networkConfiguration: CfnEnvironment.NetworkConfigurationProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::MWAA::Environment.PluginsS3ObjectVersion`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mwaa-environment.html#cfn-mwaa-environment-pluginss3objectversion
     * @external
     */
    pluginsS3ObjectVersion: string | undefined;
    /**
     * `AWS::MWAA::Environment.PluginsS3Path`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mwaa-environment.html#cfn-mwaa-environment-pluginss3path
     * @external
     */
    pluginsS3Path: string | undefined;
    /**
     * `AWS::MWAA::Environment.RequirementsS3ObjectVersion`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mwaa-environment.html#cfn-mwaa-environment-requirementss3objectversion
     * @external
     */
    requirementsS3ObjectVersion: string | undefined;
    /**
     * `AWS::MWAA::Environment.RequirementsS3Path`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mwaa-environment.html#cfn-mwaa-environment-requirementss3path
     * @external
     */
    requirementsS3Path: string | undefined;
    /**
     * `AWS::MWAA::Environment.SourceBucketArn`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mwaa-environment.html#cfn-mwaa-environment-sourcebucketarn
     * @external
     */
    sourceBucketArn: string | undefined;
    /**
     * `AWS::MWAA::Environment.Tags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mwaa-environment.html#cfn-mwaa-environment-tags
     * @external
     */
    tags: CfnEnvironment.TagMapProperty | undefined;
    /**
     * `AWS::MWAA::Environment.WebserverAccessMode`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mwaa-environment.html#cfn-mwaa-environment-webserveraccessmode
     * @external
     */
    webserverAccessMode: string | undefined;
    /**
     * `AWS::MWAA::Environment.WebserverUrl`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mwaa-environment.html#cfn-mwaa-environment-webserverurl
     * @external
     */
    webserverUrl: string | undefined;
    /**
     * `AWS::MWAA::Environment.WeeklyMaintenanceWindowStart`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mwaa-environment.html#cfn-mwaa-environment-weeklymaintenancewindowstart
     * @external
     */
    weeklyMaintenanceWindowStart: string | undefined;
    /**
     * Create a new `AWS::MWAA::Environment`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props?: CfnEnvironmentProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::MWAA::Environment`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mwaa-environment.html
 * @external
 * @cloudformationResource AWS::MWAA::Environment
 */
export declare namespace CfnEnvironment {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mwaa-environment-airflowconfigurationoptions.html
     * @external
     */
    interface AirflowConfigurationOptionsProperty {
    }
}
/**
 * A CloudFormation `AWS::MWAA::Environment`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mwaa-environment.html
 * @external
 * @cloudformationResource AWS::MWAA::Environment
 */
export declare namespace CfnEnvironment {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mwaa-environment-lastupdate.html
     * @external
     */
    interface LastUpdateProperty {
        /**
         * `CfnEnvironment.LastUpdateProperty.CreatedAt`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mwaa-environment-lastupdate.html#cfn-mwaa-environment-lastupdate-createdat
         * @external
         */
        readonly createdAt?: string;
        /**
         * `CfnEnvironment.LastUpdateProperty.Error`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mwaa-environment-lastupdate.html#cfn-mwaa-environment-lastupdate-error
         * @external
         */
        readonly error?: CfnEnvironment.UpdateErrorProperty | cdk.IResolvable;
        /**
         * `CfnEnvironment.LastUpdateProperty.Status`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mwaa-environment-lastupdate.html#cfn-mwaa-environment-lastupdate-status
         * @external
         */
        readonly status?: string;
    }
}
/**
 * A CloudFormation `AWS::MWAA::Environment`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mwaa-environment.html
 * @external
 * @cloudformationResource AWS::MWAA::Environment
 */
export declare namespace CfnEnvironment {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mwaa-environment-loggingconfiguration.html
     * @external
     */
    interface LoggingConfigurationProperty {
        /**
         * `CfnEnvironment.LoggingConfigurationProperty.DagProcessingLogs`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mwaa-environment-loggingconfiguration.html#cfn-mwaa-environment-loggingconfiguration-dagprocessinglogs
         * @external
         */
        readonly dagProcessingLogs?: CfnEnvironment.ModuleLoggingConfigurationProperty | cdk.IResolvable;
        /**
         * `CfnEnvironment.LoggingConfigurationProperty.SchedulerLogs`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mwaa-environment-loggingconfiguration.html#cfn-mwaa-environment-loggingconfiguration-schedulerlogs
         * @external
         */
        readonly schedulerLogs?: CfnEnvironment.ModuleLoggingConfigurationProperty | cdk.IResolvable;
        /**
         * `CfnEnvironment.LoggingConfigurationProperty.TaskLogs`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mwaa-environment-loggingconfiguration.html#cfn-mwaa-environment-loggingconfiguration-tasklogs
         * @external
         */
        readonly taskLogs?: CfnEnvironment.ModuleLoggingConfigurationProperty | cdk.IResolvable;
        /**
         * `CfnEnvironment.LoggingConfigurationProperty.WebserverLogs`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mwaa-environment-loggingconfiguration.html#cfn-mwaa-environment-loggingconfiguration-webserverlogs
         * @external
         */
        readonly webserverLogs?: CfnEnvironment.ModuleLoggingConfigurationProperty | cdk.IResolvable;
        /**
         * `CfnEnvironment.LoggingConfigurationProperty.WorkerLogs`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mwaa-environment-loggingconfiguration.html#cfn-mwaa-environment-loggingconfiguration-workerlogs
         * @external
         */
        readonly workerLogs?: CfnEnvironment.ModuleLoggingConfigurationProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::MWAA::Environment`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mwaa-environment.html
 * @external
 * @cloudformationResource AWS::MWAA::Environment
 */
export declare namespace CfnEnvironment {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mwaa-environment-moduleloggingconfiguration.html
     * @external
     */
    interface ModuleLoggingConfigurationProperty {
        /**
         * `CfnEnvironment.ModuleLoggingConfigurationProperty.CloudWatchLogGroupArn`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mwaa-environment-moduleloggingconfiguration.html#cfn-mwaa-environment-moduleloggingconfiguration-cloudwatchloggrouparn
         * @external
         */
        readonly cloudWatchLogGroupArn?: string;
        /**
         * `CfnEnvironment.ModuleLoggingConfigurationProperty.Enabled`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mwaa-environment-moduleloggingconfiguration.html#cfn-mwaa-environment-moduleloggingconfiguration-enabled
         * @external
         */
        readonly enabled?: boolean | cdk.IResolvable;
        /**
         * `CfnEnvironment.ModuleLoggingConfigurationProperty.LogLevel`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mwaa-environment-moduleloggingconfiguration.html#cfn-mwaa-environment-moduleloggingconfiguration-loglevel
         * @external
         */
        readonly logLevel?: string;
    }
}
/**
 * A CloudFormation `AWS::MWAA::Environment`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mwaa-environment.html
 * @external
 * @cloudformationResource AWS::MWAA::Environment
 */
export declare namespace CfnEnvironment {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mwaa-environment-networkconfiguration.html
     * @external
     */
    interface NetworkConfigurationProperty {
        /**
         * `CfnEnvironment.NetworkConfigurationProperty.SecurityGroupIds`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mwaa-environment-networkconfiguration.html#cfn-mwaa-environment-networkconfiguration-securitygroupids
         * @external
         */
        readonly securityGroupIds?: CfnEnvironment.SecurityGroupListProperty | cdk.IResolvable;
        /**
         * `CfnEnvironment.NetworkConfigurationProperty.SubnetIds`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mwaa-environment-networkconfiguration.html#cfn-mwaa-environment-networkconfiguration-subnetids
         * @external
         */
        readonly subnetIds?: CfnEnvironment.SubnetListProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::MWAA::Environment`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mwaa-environment.html
 * @external
 * @cloudformationResource AWS::MWAA::Environment
 */
export declare namespace CfnEnvironment {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mwaa-environment-securitygrouplist.html
     * @external
     */
    interface SecurityGroupListProperty {
        /**
         * `CfnEnvironment.SecurityGroupListProperty.SecurityGroupList`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mwaa-environment-securitygrouplist.html#cfn-mwaa-environment-securitygrouplist-securitygrouplist
         * @external
         */
        readonly securityGroupList?: string[];
    }
}
/**
 * A CloudFormation `AWS::MWAA::Environment`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mwaa-environment.html
 * @external
 * @cloudformationResource AWS::MWAA::Environment
 */
export declare namespace CfnEnvironment {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mwaa-environment-subnetlist.html
     * @external
     */
    interface SubnetListProperty {
        /**
         * `CfnEnvironment.SubnetListProperty.SubnetList`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mwaa-environment-subnetlist.html#cfn-mwaa-environment-subnetlist-subnetlist
         * @external
         */
        readonly subnetList?: string[];
    }
}
/**
 * A CloudFormation `AWS::MWAA::Environment`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mwaa-environment.html
 * @external
 * @cloudformationResource AWS::MWAA::Environment
 */
export declare namespace CfnEnvironment {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mwaa-environment-tagmap.html
     * @external
     */
    interface TagMapProperty {
    }
}
/**
 * A CloudFormation `AWS::MWAA::Environment`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mwaa-environment.html
 * @external
 * @cloudformationResource AWS::MWAA::Environment
 */
export declare namespace CfnEnvironment {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mwaa-environment-updateerror.html
     * @external
     */
    interface UpdateErrorProperty {
        /**
         * `CfnEnvironment.UpdateErrorProperty.ErrorCode`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mwaa-environment-updateerror.html#cfn-mwaa-environment-updateerror-errorcode
         * @external
         */
        readonly errorCode?: string;
        /**
         * `CfnEnvironment.UpdateErrorProperty.ErrorMessage`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mwaa-environment-updateerror.html#cfn-mwaa-environment-updateerror-errormessage
         * @external
         */
        readonly errorMessage?: string;
    }
}
