"""Spectral lines produced by DKIST instruments."""
from dkist_spectral_lines.models import Instrument
from dkist_spectral_lines.models import Line
from dkist_spectral_lines.models import SpectralLine


SPECTRAL_LINES = (
    # Visp
    SpectralLine(
        line=Line.CALCIUM_TWO_K,
        wavelength=393.366,
        filter_min=392.8,
        filter_max=394.0,
        instrument=Instrument.VISP,
    ),
    SpectralLine(
        line=Line.CALCIUM_TWO_H,
        wavelength=396.847,
        filter_min=396.2,
        filter_max=397.4,
        instrument=Instrument.VISP,
    ),
    SpectralLine(
        line=Line.HYDROGEN_DELTA,
        wavelength=410.174,
        filter_min=410.0,
        filter_max=410.33,
        instrument=Instrument.VISP,
    ),
    SpectralLine(
        line=Line.HYDROGEN_GAMMA,
        wavelength=434.05,
        filter_min=433.9,
        filter_max=434.2,
        instrument=Instrument.VISP,
    ),
    SpectralLine(
        line=Line.CALCIUM_ONE,
        wavelength=422.67,
        filter_min=422.5,
        filter_max=422.82,
        instrument=Instrument.VISP,
    ),
    SpectralLine(
        line=Line.HYDROGEN_BETA,
        wavelength=486.133,
        filter_min=485.95,
        filter_max=486.32,
        instrument=Instrument.VISP,
    ),
    SpectralLine(
        line=Line.MAGNESIUM_ONE_B_ONE,
        wavelength=517.268,
        filter_min=517.2,
        filter_max=517.33,
        instrument=Instrument.VISP,
    ),
    SpectralLine(
        line=Line.MAGNESIUM_ONE_B_TWO,
        wavelength=518.362,
        filter_min=518.280,
        filter_max=518.440,
        instrument=Instrument.VISP,
    ),
    SpectralLine(
        line=Line.HELIUM_ONE_D_ONE,
        wavelength=587.590,
        filter_min=587.2,
        filter_max=588.2,
        instrument=Instrument.VISP,
    ),
    SpectralLine(
        line=Line.HELIUM_ONE_D_TWO,
        wavelength=588.995,
        filter_min=588.95,
        filter_max=589.04,
        instrument=Instrument.VISP,
    ),
    SpectralLine(
        line=Line.HELIUM_ONE_D_THREE,
        wavelength=589.592,
        filter_min=589.56,
        filter_max=589.62,
        instrument=Instrument.VISP,
    ),
    SpectralLine(
        line=Line.IRON_ONE,
        wavelength=630.2,
        filter_min=630.195,
        filter_max=630.206,
        instrument=Instrument.VISP,
    ),
    SpectralLine(
        line=Line.HYDROGEN_ALPHA,
        wavelength=656.28,
        filter_min=656.13,
        filter_max=656.43,
        instrument=Instrument.VISP,
    ),
    SpectralLine(
        line=Line.CALCIUM_TWO,
        wavelength=854.21,
        filter_min=854.11,
        filter_max=854.31,
        instrument=Instrument.VISP,
    ),
    # Cryp SP
    SpectralLine(
        line=Line.CALCIUM_TWO,
        wavelength=854.000,
        filter_min=848.000,
        filter_max=860.000,
        instrument=Instrument.CRYO_NIRSP_SP,
    ),
    SpectralLine(
        line=Line.HELIUM_ONE_IRON_THIRTEEN,
        wavelength=1077.000,
        filter_min=1067.000,
        filter_max=1087.000,
        instrument=Instrument.CRYO_NIRSP_SP,
    ),
    SpectralLine(
        line=Line.SULFUR_NINE,
        wavelength=1252.000,
        filter_min=1238.500,
        filter_max=1265.500,
        instrument=Instrument.CRYO_NIRSP_SP,
    ),
    SpectralLine(
        line=Line.PASCHEN_BETA,
        wavelength=1282.000,
        filter_min=1268.000,
        filter_max=1296.000,
        instrument=Instrument.CRYO_NIRSP_SP,
    ),
    SpectralLine(
        line=Line.SILICON_TEN,
        wavelength=1430.000,
        filter_min=1412.500,
        filter_max=1447.500,
        instrument=Instrument.CRYO_NIRSP_SP,
    ),
    SpectralLine(
        line=Line.IRON_TWELVE,
        wavelength=2218.000,
        filter_min=2196.500,
        filter_max=2239.500,
        instrument=Instrument.CRYO_NIRSP_SP,
    ),
    SpectralLine(
        line=Line.MAGNESIUM_EIGHT,
        wavelength=3028.000,
        filter_min=2993.000,
        filter_max=3063.000,
        instrument=Instrument.CRYO_NIRSP_SP,
    ),
    SpectralLine(
        line=Line.SILICON_NINE,
        wavelength=3934.000,
        filter_min=3872.000,
        filter_max=3996.000,
        instrument=Instrument.CRYO_NIRSP_SP,
    ),
    SpectralLine(
        line=Line.CARBON_MONOXIDE,
        wavelength=4651.000,
        filter_min=4565.500,
        filter_max=4736.500,
        instrument=Instrument.CRYO_NIRSP_SP,
    ),
    # Cryo CI
    SpectralLine(
        line=Line.CONTINUUM,
        wavelength=1049.500,
        filter_min=1049.000,
        filter_max=1050.000,
        instrument=Instrument.CRYO_NIRSP_CI,
    ),
    SpectralLine(
        line=Line.IRON_THIRTEEN,
        wavelength=1074.700,
        filter_min=1074.200,
        filter_max=1075.200,
        instrument=Instrument.CRYO_NIRSP_CI,
        include_wavelength_in_name=True,
    ),
    SpectralLine(
        line=Line.IRON_THIRTEEN,
        wavelength=1079.800,
        filter_min=1079.300,
        filter_max=1080.300,
        instrument=Instrument.CRYO_NIRSP_CI,
        include_wavelength_in_name=True,
    ),
    SpectralLine(
        line=Line.HELIUM_ONE,
        wavelength=1083.000,
        filter_min=1082.500,
        filter_max=1083.500,
        instrument=Instrument.CRYO_NIRSP_CI,
    ),
    SpectralLine(
        line=Line.PASCHEN_BETA,
        wavelength=1281.800,
        filter_min=1281.300,
        filter_max=1282.300,
        instrument=Instrument.CRYO_NIRSP_CI,
    ),
    SpectralLine(
        line=Line.J_BAND,
        wavelength=1250.000,
        filter_min=1170.000,
        filter_max=1330.000,
        instrument=Instrument.CRYO_NIRSP_CI,
    ),
    SpectralLine(
        line=Line.SILICON_TEN,
        wavelength=1430.000,
        filter_min=1427.500,
        filter_max=1432.500,
        instrument=Instrument.CRYO_NIRSP_CI,
    ),
    # VBI-Blue
    SpectralLine(
        line=Line.CALCIUM_TWO_K,
        wavelength=393.327,
        filter_min=393.276,
        filter_max=393.378,
        instrument=Instrument.VBI_BLUE,
    ),
    SpectralLine(
        line=Line.G_BAND,
        wavelength=430.52,
        filter_min=430.301,
        filter_max=430.789,
        instrument=Instrument.VBI_BLUE,
    ),
    SpectralLine(
        line=Line.CONTINUUM,
        wavelength=450.287,
        filter_min=450.084,
        filter_max=450.490,
        instrument=Instrument.VBI_BLUE,
    ),
    SpectralLine(
        line=Line.HYDROGEN_BETA,
        wavelength=486.139,
        filter_min=486.116,
        filter_max=486.162,
        instrument=Instrument.VBI_BLUE,
    ),
    # VBI-Red
    SpectralLine(
        line=Line.HYDROGEN_ALPHA,
        wavelength=656.282,
        filter_min=656.258,
        filter_max=656.306,
        instrument=Instrument.VBI_RED,
    ),
    SpectralLine(
        line=Line.CONTINUUM,
        wavelength=668.423,
        filter_min=668.202,
        filter_max=668.644,
        instrument=Instrument.VBI_RED,
    ),
    SpectralLine(
        line=Line.TITANIUM_OXIDE,
        wavelength=705.839,
        filter_min=705.545,
        filter_max=706.133,
        instrument=Instrument.VBI_RED,
    ),
    SpectralLine(
        line=Line.IRON_NINE,
        wavelength=789.186,
        filter_min=789.168,
        filter_max=789.204,
        instrument=Instrument.VBI_RED,
    ),
)
