"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
"""
import builtins
import collections.abc
import google.protobuf.descriptor
import google.protobuf.internal.containers
import google.protobuf.internal.enum_type_wrapper
import google.protobuf.message
import google.protobuf.timestamp_pb2
import sys
import typing

if sys.version_info >= (3, 10):
    import typing as typing_extensions
else:
    import typing_extensions

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor

@typing_extensions.final
class DAG(google.protobuf.message.Message):
    """DAG is the total set of operations to execute, though not technically
    DAGs since there can be recursion or anything that python can do. It
    is supposed to be our understanding of the code with our own internal
    IR.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing_extensions.final
    class SymbolsEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        @property
        def value(self) -> global___Node: ...
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: global___Node | None = ...,
        ) -> None: ...
        def HasField(self, field_name: typing_extensions.Literal["value", b"value"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing_extensions.Literal["key", b"key", "value", b"value"]) -> None: ...

    SYMBOLS_FIELD_NUMBER: builtins.int
    FLOWCHART_FIELD_NUMBER: builtins.int
    @property
    def symbols(self) -> google.protobuf.internal.containers.MessageMap[builtins.str, global___Node]:
        """symbols is a dict with name keys and nodes as values"""
    @property
    def flowchart(self) -> global___Flowchart: ...
    def __init__(
        self,
        *,
        symbols: collections.abc.Mapping[builtins.str, global___Node] | None = ...,
        flowchart: global___Flowchart | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["flowchart", b"flowchart"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["flowchart", b"flowchart", "symbols", b"symbols"]) -> None: ...

global___DAG = DAG

@typing_extensions.final
class Flowchart(google.protobuf.message.Message):
    """Flowchart represents the data flow with nodes and edges, this can then
    be optimised for faster more performant execution. With nodes and edges
    we can reconstruct and play with any kind of arbitrary code.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing_extensions.final
    class NodesEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        @property
        def value(self) -> global___Node: ...
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: global___Node | None = ...,
        ) -> None: ...
        def HasField(self, field_name: typing_extensions.Literal["value", b"value"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing_extensions.Literal["key", b"key", "value", b"value"]) -> None: ...

    @typing_extensions.final
    class EdgesEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        @property
        def value(self) -> global___Edge: ...
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: global___Edge | None = ...,
        ) -> None: ...
        def HasField(self, field_name: typing_extensions.Literal["value", b"value"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing_extensions.Literal["key", b"key", "value", b"value"]) -> None: ...

    NODES_FIELD_NUMBER: builtins.int
    EDGES_FIELD_NUMBER: builtins.int
    @property
    def nodes(self) -> google.protobuf.internal.containers.MessageMap[builtins.str, global___Node]:
        """node.id: node dict; map because easier to fetch and update things"""
    @property
    def edges(self) -> google.protobuf.internal.containers.MessageMap[builtins.str, global___Edge]:
        """edge.id: edge dict; map because easier to fetch and update things"""
    def __init__(
        self,
        *,
        nodes: collections.abc.Mapping[builtins.str, global___Node] | None = ...,
        edges: collections.abc.Mapping[builtins.str, global___Edge] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["edges", b"edges", "nodes", b"nodes"]) -> None: ...

global___Flowchart = Flowchart

@typing_extensions.final
class Edge(google.protobuf.message.Message):
    """The edges are just connectors and should not contain any data of its own
    nbox_string can be used to tell about the edge in our IR
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class _EdgeType:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _EdgeTypeEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[Edge._EdgeType.ValueType], builtins.type):  # noqa: F821
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        EXECUTION_ORDER: Edge._EdgeType.ValueType  # 0
        BRANCHING: Edge._EdgeType.ValueType  # 1
        LOOP: Edge._EdgeType.ValueType  # 2

    class EdgeType(_EdgeType, metaclass=_EdgeTypeEnumTypeWrapper):
        """execution order: default
        branching: conditionals or parallels
        loop edge: for or while loop things
        """

    EXECUTION_ORDER: Edge.EdgeType.ValueType  # 0
    BRANCHING: Edge.EdgeType.ValueType  # 1
    LOOP: Edge.EdgeType.ValueType  # 2

    ID_FIELD_NUMBER: builtins.int
    SOURCE_FIELD_NUMBER: builtins.int
    TARGET_FIELD_NUMBER: builtins.int
    TYPE_FIELD_NUMBER: builtins.int
    NBOX_STRING_FIELD_NUMBER: builtins.int
    id: builtins.str
    """edge id should be a combination of source and target"""
    source: builtins.str
    """name/id of the source"""
    target: builtins.str
    """name/id of the target"""
    type: global___Edge.EdgeType.ValueType
    """what type of edge is this, it can tell if it's a conditional
    edge or a loop edge or something
    """
    nbox_string: builtins.str
    def __init__(
        self,
        *,
        id: builtins.str = ...,
        source: builtins.str = ...,
        target: builtins.str = ...,
        type: global___Edge.EdgeType.ValueType = ...,
        nbox_string: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["id", b"id", "nbox_string", b"nbox_string", "source", b"source", "target", b"target", "type", b"type"]) -> None: ...

global___Edge = Edge

@typing_extensions.final
class RunStatus(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing_extensions.final
    class InputsEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        value: builtins.str
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: builtins.str = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing_extensions.Literal["key", b"key", "value", b"value"]) -> None: ...

    @typing_extensions.final
    class OutputsEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        value: builtins.str
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: builtins.str = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing_extensions.Literal["key", b"key", "value", b"value"]) -> None: ...

    START_FIELD_NUMBER: builtins.int
    END_FIELD_NUMBER: builtins.int
    INPUTS_FIELD_NUMBER: builtins.int
    OUTPUTS_FIELD_NUMBER: builtins.int
    @property
    def start(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """start datetime of this node"""
    @property
    def end(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """end datetime of this node"""
    @property
    def inputs(self) -> google.protobuf.internal.containers.ScalarMap[builtins.str, builtins.str]:
        """name of the inputs and optionally some value against them"""
    @property
    def outputs(self) -> google.protobuf.internal.containers.ScalarMap[builtins.str, builtins.str]:
        """name of the outputs with some string against it"""
    def __init__(
        self,
        *,
        start: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        end: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        inputs: collections.abc.Mapping[builtins.str, builtins.str] | None = ...,
        outputs: collections.abc.Mapping[builtins.str, builtins.str] | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["end", b"end", "start", b"start"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["end", b"end", "inputs", b"inputs", "outputs", b"outputs", "start", b"start"]) -> None: ...

global___RunStatus = RunStatus

@typing_extensions.final
class Code(google.protobuf.message.Message):
    """Code mostly has code related information"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing_extensions.final
    class InputsEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        value: builtins.str
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: builtins.str = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing_extensions.Literal["key", b"key", "value", b"value"]) -> None: ...

    @typing_extensions.final
    class OutputsEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        value: builtins.str
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: builtins.str = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing_extensions.Literal["key", b"key", "value", b"value"]) -> None: ...

    NAME_FIELD_NUMBER: builtins.int
    CODE_FIELD_NUMBER: builtins.int
    NBOX_STRING_FIELD_NUMBER: builtins.int
    LINENO_FIELD_NUMBER: builtins.int
    COL_OFFSET_FIELD_NUMBER: builtins.int
    END_LINENO_FIELD_NUMBER: builtins.int
    END_COL_OFFSET_FIELD_NUMBER: builtins.int
    INPUTS_FIELD_NUMBER: builtins.int
    OUTPUTS_FIELD_NUMBER: builtins.int
    CONDITIONS_FIELD_NUMBER: builtins.int
    name: builtins.str
    """name of the node"""
    code: builtins.str
    """code string for this node"""
    nbox_string: builtins.str
    lineno: builtins.int
    """these are code location elements"""
    col_offset: builtins.int
    end_lineno: builtins.int
    end_col_offset: builtins.int
    @property
    def inputs(self) -> google.protobuf.internal.containers.ScalarMap[builtins.str, builtins.str]:
        """name of the inputs and optionally some value against them"""
    @property
    def outputs(self) -> google.protobuf.internal.containers.ScalarMap[builtins.str, builtins.str]:
        """name of the outputs with some string against it"""
    @property
    def conditions(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___Code]:
        """when this is if-conditional it can have many different nodes"""
    def __init__(
        self,
        *,
        name: builtins.str = ...,
        code: builtins.str = ...,
        nbox_string: builtins.str = ...,
        lineno: builtins.int = ...,
        col_offset: builtins.int = ...,
        end_lineno: builtins.int = ...,
        end_col_offset: builtins.int = ...,
        inputs: collections.abc.Mapping[builtins.str, builtins.str] | None = ...,
        outputs: collections.abc.Mapping[builtins.str, builtins.str] | None = ...,
        conditions: collections.abc.Iterable[global___Code] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["code", b"code", "col_offset", b"col_offset", "conditions", b"conditions", "end_col_offset", b"end_col_offset", "end_lineno", b"end_lineno", "inputs", b"inputs", "lineno", b"lineno", "name", b"name", "nbox_string", b"nbox_string", "outputs", b"outputs"]) -> None: ...

global___Code = Code

@typing_extensions.final
class Node(google.protobuf.message.Message):
    """Nodes contain the real-deal, these beast of a data structure has
    logic for processing some inputs, they are the servers and edges
    are just conne
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class _NodeType:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _NodeTypeEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[Node._NodeType.ValueType], builtins.type):  # noqa: F821
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        CODE: Node._NodeType.ValueType  # 0
        """code-block, this default and selected when code cannot be"""
        OP: Node._NodeType.ValueType  # 1
        """understood
        this is when the code is an operation and to be considered
        """
        LOOP: Node._NodeType.ValueType  # 2
        """loop node can be a while or for loop"""
        BRANCHING: Node._NodeType.ValueType  # 3
        """code for parallelisation or conditional"""
        RETURN: Node._NodeType.ValueType  # 4
        """this code is returning something, defined for convinience"""

    class NodeType(_NodeType, metaclass=_NodeTypeEnumTypeWrapper):
        """NodeTypes can be of a few types such as"""

    CODE: Node.NodeType.ValueType  # 0
    """code-block, this default and selected when code cannot be"""
    OP: Node.NodeType.ValueType  # 1
    """understood
    this is when the code is an operation and to be considered
    """
    LOOP: Node.NodeType.ValueType  # 2
    """loop node can be a while or for loop"""
    BRANCHING: Node.NodeType.ValueType  # 3
    """code for parallelisation or conditional"""
    RETURN: Node.NodeType.ValueType  # 4
    """this code is returning something, defined for convinience"""

    ID_FIELD_NUMBER: builtins.int
    EXECUTION_INDEX_FIELD_NUMBER: builtins.int
    NAME_FIELD_NUMBER: builtins.int
    OPERATOR_FIELD_NUMBER: builtins.int
    TYPE_FIELD_NUMBER: builtins.int
    INFO_FIELD_NUMBER: builtins.int
    NBOX_STRING_FIELD_NUMBER: builtins.int
    RUN_STATUS_FIELD_NUMBER: builtins.int
    PARENT_NODE_ID_FIELD_NUMBER: builtins.int
    id: builtins.str
    """uuid4 id of the Node object"""
    execution_index: builtins.int
    """since the code during execution can be actually run out of order
    we need to store the order in which it would have been executed
    on the users single threaded GIL python for best experience. Thus
    adding execution_index which tracks this.
    """
    name: builtins.str
    """name of the node"""
    operator: builtins.str
    """operator is the name of the Operator class that is this node, it is
    to understanding what are the things people want to do since these
    names are given by the user
    """
    type: global___Node.NodeType.ValueType
    """Type of nodes"""
    @property
    def info(self) -> global___Code:
        """Code contains the code related information"""
    nbox_string: builtins.str
    @property
    def run_status(self) -> global___RunStatus:
        """define the run status"""
    parent_node_id: builtins.str
    """parent node id is used to determine the flow of the graph"""
    def __init__(
        self,
        *,
        id: builtins.str = ...,
        execution_index: builtins.int = ...,
        name: builtins.str = ...,
        operator: builtins.str = ...,
        type: global___Node.NodeType.ValueType = ...,
        info: global___Code | None = ...,
        nbox_string: builtins.str = ...,
        run_status: global___RunStatus | None = ...,
        parent_node_id: builtins.str = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["info", b"info", "run_status", b"run_status"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["execution_index", b"execution_index", "id", b"id", "info", b"info", "name", b"name", "nbox_string", b"nbox_string", "operator", b"operator", "parent_node_id", b"parent_node_id", "run_status", b"run_status", "type", b"type"]) -> None: ...

global___Node = Node
