import { Duration } from '@aws-cdk/core';
/**
 * Schedule for scheduled event rules.
 *
 * @stability stable
 */
export declare abstract class Schedule {
    /**
     * Construct a schedule from a literal schedule expression.
     *
     * @param expression The expression to use.
     * @stability stable
     */
    static expression(expression: string): Schedule;
    /**
     * Construct a schedule from an interval and a time unit.
     *
     * @stability stable
     */
    static rate(duration: Duration): Schedule;
    /**
     * Create a schedule from a set of cron fields.
     *
     * @stability stable
     */
    static cron(options: CronOptions): Schedule;
    /**
     * Retrieve the expression for this schedule.
     *
     * @stability stable
     */
    abstract readonly expressionString: string;
    /**
     * @stability stable
     */
    protected constructor();
}
/**
 * Options to configure a cron expression.
 *
 * All fields are strings so you can use complex expressions. Absence of
 * a field implies '*' or '?', whichever one is appropriate.
 *
 * @see https://docs.aws.amazon.com/eventbridge/latest/userguide/scheduled-events.html#cron-expressions
 * @stability stable
 */
export interface CronOptions {
    /**
     * The minute to run this rule at.
     *
     * @default - Every minute
     * @stability stable
     */
    readonly minute?: string;
    /**
     * The hour to run this rule at.
     *
     * @default - Every hour
     * @stability stable
     */
    readonly hour?: string;
    /**
     * The day of the month to run this rule at.
     *
     * @default - Every day of the month
     * @stability stable
     */
    readonly day?: string;
    /**
     * The month to run this rule at.
     *
     * @default - Every month
     * @stability stable
     */
    readonly month?: string;
    /**
     * The year to run this rule at.
     *
     * @default - Every year
     * @stability stable
     */
    readonly year?: string;
    /**
     * The day of the week to run this rule at.
     *
     * @default - Any day of the week
     * @stability stable
     */
    readonly weekDay?: string;
}
