###################################################################################################
#  WARNING: BEFORE CHANGING ANYTHING IN THIS FILE MAKE A BACKUP SO YOU CAN RESTORE !
#  Read the comments in this file as they contain valuable information to understand the effects 
###################################################################################################
import sys                                             # keep this import!
#
# There are 3 models from which you can select: Note: on home page URLs for other models are set to href="#" (deactivated) 
# Set captcha_model to 1, 2 or 3!
#  1. default    -> the Kaptsja is shown direct on a single full HTML page
#  2. modal      -> the Kaptsja is "injected" in a modal window generated by bootstrap.js at top of a full HTML page
#  3. div        -> the Kaptsja is "injected" in a single full HTML page using JQuery.js 
#
active_captcha_model        = 3           # Default: 2. Only 1, 2 or 3 allowed. It defaults to 2 when not set or when > 3 or < 1 
#                                         # When changing to another model make work_dir empty and 
#                                         # Run Kaptsjagenerator.py from command line to generate the corresponding Kaptsja sets
#                                         # See also max_captcha_sets   
max_captcha_sets            = 0           # Recommended 20 or higher: the maximum number of pre-generated Kaptsja sets (html,png,css,js files)
#                                         # When max_captcha_sets = 0 only dynamic Kaptsja generation happens!
#                                         # When the number of Kaptsja sets is low there will be a higher chance that
#                                         # the same Kaptsja will be shown twice or more in a sequence!
time_keep_captcha_set       = 60          # Value in seconds. Each Kaptsja set is uniquely generated in the work_dir to avoid 
#                                         # concurrency collisions. It will be kept there for the seconds defined.
#                                         # When max_captcha_sets > 0 then the time_keep_captcha_set value is not used and
#                                         # all generated files in work_dir will be kept
#
input_picture               = r"Kaptsja_bg.jpg" # Always keep a copy of your input picture as it might be rescaled due to width size or  setting of input_picture_rescale_width 
input_picture_rescale_width = 0                 # Default 0. Zero means no rescaling else use value between 360 - 598 
#                                               # When set input_picture will be resized to this pixel size and overwritten!!
#                                               # Be carefull as 360 is really a low number. Fonts below 30 for circles and 10 for text would easily needed
#                                               # Font default locations (Windows 10 and Ubuntu 20.04 are used here)
if(sys.platform=='win32'):
    font_circle             = r"c:/windows/fonts/Arial.ttf"   # Window fonts location
#    font_circle             = r"c:/windows/fonts/MSJHBD.ttc"   # Window fonts location for Chinese Traditional Han Microsoft JhengHei Bold (has been tested as well)
    font_textzone           = r"c:/windows/fonts/Arial.ttf"        
else:
    font_circle             = r"/usr/share/fonts/truetype/msttcorefonts/Arial.ttf"   # Linux: To locate Arial font use command: fc-list | grep arial 
    font_textzone           = r"/usr/share/fonts/truetype/msttcorefonts/Arial.ttf"     
font_pnts_circle            = 45              # Font points are not only about the size (width and height!)
font_pnts_textzone          = 20              # About Font points:
#                                             # In typography, the point is the smallest unit of measure. 
#                                             # It is used for measuring font size, leading, and other items on a printed page. 
#                                             # The size of the point has varied throughout the history of printing.
used_letters    = u"ABCDEFGHJKLMNPRSTUVWXYZ"  # Randomly given number of letters will be shown on Kaptsja. 
#                                             # Use u" " for Special Unicode Characters like u"個長句子。". NOTE: to display
#                                             # special characters like Chinese the correct (Chinese) font must be specified!
number_of_letters           = 2               # Default: 2 A maximum of 10 characters is allowed 
#                                             # (total of number_of_letters + number_of_digits < 11
used_digits                 = r"0123456789"   # Numbers 6 and 9 will be underscored when rotating is active
number_of_digits            = 4               # Default 4: Recommended: number_of_letters + number_of_digits is 6
#                                             # The number of circles drawn equals to number_of_letters + number_of_digits
#                                             # An even number 2 is better for precise positioning of area circle on HTML page 
max_retries                 = 2               # Counted after first try!, the maximum number people may retry to solve the captcha
border_circle               = 2               # The border thickness of circles in pixels
border_line                 = 3               # The thickness for lines in pixels
line_color                  = "#808080"       # String: default #808080 gray #d93211 orange/red HTML color names with Hex color codes
rotate_char_circle          = True            # Default: True. Set to False for better performance
rotate_angle_char_circle    = 75              # Default: 30. Means between -30 and +30  Max value is 360.
circle_color_trans          = 15              # Value between 0 and 100. No % sign! Higher number means more transparency. 50 is half.
char_circle_color_trans     = 0               # Value between 0 and 100. No % sign! As character color equals  the inversed circle color,
#                                             # a higher number here has the opposite effect!! 
#                                             # 100 means the full inversed circle color will be shown on the character: usefull for higher contrast
#                                             # 0 means full transparency. This is usefull is the background picture is relative dark.
#                                             # You get a see through the circle effect!
textzone_color_trans        = 50              # Value between 0 and 100. No % sign! Higher number means more transparency. 50 is half.
textzone_center_text        = True            # True or False (Python bool) True=center, False=Left Aligned
textzone_text_color         = "#fafafa"       # String:  HTML color names with Hex color codes
textzone_bg_color           = "#040406"       # String:  HTML color names with Hex color codes
max_morphing_pie_slices     = 9               # Minimal 3, Default 15 which is sufficient for Arial fontpoints 35
#                                             # A higher number of max_morphing_pie_slices will morph characters too much and they might become unreadable 
copyright_text_picture      =  "© Margrhet"   # Copyright text put at upper right or left corner of picture
copyright_text_color        = "#f123ab"       # String:  HTML color names with Hex color codes
copyright_text_position     = "R"             # R/r=right or L/l=Left upper corner of picture. Default R
font_pnts_copyright_text    = 12              # Using same font as for textzone

#                                                         
# Please check if the sub-directories do exist under the home_dir Kaptsja, only the key_dir will be automatically created if it doesn't exist
# Directory settings
home_dir          = r"./"                                 # current directory-> end slash required (in this directory KaptsjaSite.py should be started)
css_dir           = home_dir + r"css/"                    # directory path for javascript files -> end slash required
docs_dir          = home_dir + r"docs/"                   # directory path for documentationfiles (txt, doc, docx, rst, ...) -> end slash required
html_dir          = home_dir + r"html/"                   # directory path for HTML files -> end slash required
js_dir            = home_dir + r"js/"                     # directory path for javascript files -> end slash required
media_dir         = home_dir + r"media/"                  # directory path for media files (jpg, png, ...) -> end slash required
randomlist_dir    = media_dir + r"randomlist/"            # directory path for media files (jpg, png, ...) to show randomly.
#                                                         # -> end slash required. 
#                                                         # This works only when randomlist is set to True 
randomlist        = True                                  # Kaptsja Pictures from randomlist will be used (randomly selected)
scripts_dir       = home_dir + r"scripts/"                # directory path for python scripts  -> end slash required
key_dir           = home_dir + r"key/"                    # directory path for encryption key -> end slash required
log_dir           = home_dir + r"log/"                    # directory path for log file -> end slash required
work_dir          = home_dir + r"work/"                   # directory path for encryption key -> end slash required
# 
gen_picture       = r"KaptsjaPicture.png"       # Name of generated Kaptsja picture 
gen_captcha_page  = r"KaptsjaPage.html"         # Name of generated Kaptsja HTML page 
gen_home_page     = r"KaptsjaHome.html"         # Name of generated Kaptsja Home page  (home page of the site)
gen_div_page      = r"KaptsjaDIV.html"          # Name of generated Kaptsjadiv page 
gen_modal_page    = r"KaptsjaModal.html"        # Name of generated Kaptsja Modal page 
gen_success_page  = r"KaptsjaSuccessPage.html"  # Name of generated Kaptsja Success page  
gen_failure_page  = r"KaptsjaFailurePage.html"  # Name of generated Kaptsja Failure page 
gen_javascript    = r"KaptsjaDIV.js"           # Name of generated javascript; script of generated Kaptsja DIV page  
gen_css           = r"KaptsjaDIV.css"          # Name of generated css; style of generated Kaptsja page  
#
bootstrap_js_file    = js_dir + "bootstrap.min-3.3.7.js"    # Name / location of the used bootstrap javascript file
bootstrap_css_file   = css_dir + "bootstrap.min-3.3.7.css" # Name / location of the used bootstrap css file
jquery_js_file       = js_dir + "jquery.min-3.5.1.js"       # Name / location of the used jquery javascript file

# Full Path File names
secret_key_file          = key_dir   + r"Kaptsja_secret_key.txt"  # Path to the encryption / decryption key for controlvalue
log_file                 = log_dir   + r"Kaptsja.log"        # Path to log file 
ico_file                 = media_dir + r"Kaptsja.ico"        # Path to log file 
input_picture_file       = media_dir + input_picture # Path to input picture 
# Although generated (once generated when KaptsjaSite.py or KaptsjaHTMLpages.py are run) 
gen_home_page_file       = html_dir  + gen_home_page         # Path to generated Kaptsja Home page of the site
gen_success_page_file    = html_dir  + gen_success_page      # Path generated Kaptsja Success page 
gen_failure_page_file    = html_dir  + gen_failure_page      # Path generated Kaptsja Failure page 
# These files are generated once (Kaptsja Sets; delete manual from work_dir) or multiple times (dynamic; deleted automatically)
gen_picture_file         = work_dir  + gen_picture           # Path to generated Kaptsja picture
gen_captcha_page_file    = work_dir  + gen_captcha_page      # Path to generated Kaptsja HTML page
gen_div_page_file        = work_dir  + gen_div_page          # Path to generated Kaptsja DIV page 
gen_modal_page_file      = work_dir  + gen_modal_page        # Path to generated Kaptsja Modal page 
gen_javascript_file      = work_dir  + gen_javascript        # Path to generated javascript; script of generated Kaptsja page
gen_css_file             = work_dir  + gen_css               # Path generated css; style of generated Kaptsja page  
#
# Settings for Bottle example program KaptsjaSite.py
sitehost = "localhost"                         # hostname or IP address must be between quotes
siteport = 8080                                # port number must be integer, number below 1000 might require special Admin rights
siteserver = "wsgiref"                         # Values: Default "wsgiref" , use "python_server" when in production with nginx and uwsgi, or "gevent"
sitedebug = True                               # Values: True, False. Bottle shows debugging messages in start cmd window when True. Us False in production.
site_reloader = True                           # Values: True, False. When changes in loaded Python code are detected Bottle will automatically reload it.
#
# URL to resources or invoking module functions
# URL parts settings
site_url                    = r"/captsite/"                 # base URL for Kaptsja site    -> end slash is required
css_url                     = site_url + r"css/"            # URL part for all css files  -> end slash required
docs_url                    = site_url + r"docs/"           # URL part for all documentation files (txt, doc, docx, rst, ...) -> end slash required
html_url                    = site_url + r"html/"           # URL part for all HTML files  -> end slash required
js_url                      = site_url + r"js/"             # URL part for all javascript files (url part) -> end slash required
media_url                   = site_url + r"media/"          # URL part for all media files (png,jpg, ...) -> end slash required
work_url                    = site_url + r"work/"           # URL part for all work files (png,jpg, ...) -> end slash required
home_page_url               = site_url + "home"             # URL part for HREF reference/routing to Home Page
captcha_page_url            = site_url + "captcha"          # URL part for HREF reference/routing to generated Kaptsja HTML page
div_page_url                = site_url + "div"              # URL part for HREF reference/routing to generated Kaptsjadiv page  
div_captcha_page_url        = site_url + "div-Kaptsja"      # URL part for HREF reference/routing to generated Kaptsja Modal Page
modal_page_url              = site_url + "modal"            # URL part for HREF reference/routing to generated Kaptsja Modal Page
modal_captcha_page_url      = site_url + "modal-captcha"    # URL part for HREF reference/routing to refresh Kaptsja in genereated Kaptsja Modal Page
success_page_url            = site_url + "success"          # URL part for HREF reference/routing to Kaptsja Success Page
failure_page_url            = site_url + "failure"          # URL part for HREF reference/routing to Kaptsja Failure Page
captcha_check_url           = site_url + "check-captcha"    # URL part for HREF reference/routing to captcha_check_function
success_cont_url            = site_url + "success-continue" # URL part for HREF reference/routing to continue after display Kaptsja Success Page
failure_cont_url            = site_url + "failure-continue" # URL part for HREF reference/routing to continue after display Kaptsja Failure Page
gen_javascript_url          = js_url + gen_javascript       # URL to generated javascript ; contains script of generated Kaptsja page
gen_css_url                 = css_url + gen_css             # URL to generated javascript ; contains script of generated Kaptsja page
#
beautifulsoup_parser        = "html.parser"                 # Default html.parser. When lxml has been installed then you can specify "lxml"
#                                                           # Parser  used to prettify and 'complete' generated html pages
# ###################################################################
# TEXT SECTION The following text is displayed on the Kaptsja Pages. You May Change them into your language.
####################################################################
# When text literal is set to None, no text will be shown
# When text literal is set to "", the default English text will be shown
# Else the "translated text" set here will be shown
#
check_the_box_text =  "Please check box to continue"
number_of_clicks = "Number of clicks:"
too_many_clicks_text = "Too many clicks. Retry."
exact_nr_circles_submit =  "Clicking the exact number of circles enables Submit button"
submitted_text = "Submitted. Click button New Picture."
too_many_retries_text = "Too many retries. Click button New Picture."
new_pic_button_text = "New Picture"
retry_button_text = "Retry"
submit_button_text = "Submit Result"
intro_captcha_text = "CaptCha for Human recognition"
captcha_hdr_text = "Human Verification"
# Close modal window character X or use another HTML entity defined as &xxx; 
# Symbol &times; equals to &#215;  text may be used style is H2
captcha_hdr_close = "&otimes;"     
not_a_robot_text= "I am a not a robot&nbsp;&nbsp;"
## Button colors
submit_button_bgcolor_enabled = "#a3ff9e"   # greenish
submit_button_bgcolor_disabled = "#ff9e9e"  # redish
retry_button_bgcolor_enabled = "#a3ff9e"   # greenish
retry_button_bgcolor_disabled = "#ff9e9e"  # redish
new_pic_button_bgcolor_enabled = "#a3ff9e"   # greenish
new_pic_button_bgcolor_disabled = "#ff9e9e"  # redish
# Home page text
home_page_tab1 = "Home"
home_page_tab2 = "1. Kaptsja Page"
home_page_tab3 = "2. Kaptsja Modal Page"
home_page_tab4 = "3. Kaptsja inside page element &lt;div&gt ... &lt;/div&gt;"
home_page_click_tab_text = "To select the activated Kaptsja model click on tab "
home_page_one_model_active_text = "Only one model can be active at a time. To activate another model, "
home_page_change_setting_text = "change setting 'active_captcha_model' in configuration file KaptsjaConfiguration.py."

# Following instruction text will be displayed. Do not change the Sorting Order Instruction itself else failures will happen!
# These are the sorting instructions, You may not change the order or Digits and Letters as listed below!
# When you put \n inside the text a hard next line break will happen and the textzone will be adapted automatically
# as well as the positioning of the circles.
# Always keep this in mind:
# in ASCENDING order (▲). First Digits then Letters
# in DESCENDING order (▼). First Letters then Digits.
text_Ascending = "Are you human? Click in each circle. First Digits then Letters.\n In ASCENDING order (▲).\n Not readable? Click on New Picture button."
text_Descending = "Are you human? Click in each circle. First Letters then Digits.\n In DESCENDING order (▼).\n Not readable? Click on New Picture button."
# ###################################################################
# Performance setting. Read text first before changing this setting!
allowed_evals_per_char    = 250     # Default 250 --> increase only step-by-step! 
# CAUTION: Adapt this value when not all circles are drawn on a given picture in combination with the given font sizes. 
# Reason: A small height of the picture leads to higher number of evaluations to find non-overlapping space.
# Increasing this number might help a little, but leads to performance decrease!
# An increase of picture height is a better solution or reduce the font size, which is less optimal for users. 
# Backgound information: 
# For each circle a random position is generated and verified that there is no overlap with other circles. 
# To avoid endless loops or too much evaluations a maximum number is calculated as follows: 
# Maximum evaluations = "Allowed evaluations per character" multiplied by sum of "letters and digits" as defined above. 
# When the maximum is reached a break happens in the loop and an error message is generated in the log file.
# The error message contains a suggested minimum height for your picture! 
# Always test first when using changing pictures, font type or size and total number of characters.
# ###################################################################
