import { Actions, PolicyStatement, ResourceTypes } from "../shared";
import { PolicyStatementProps } from "@aws-cdk/aws-iam";
/**
 * Action provider for service appflow
 *
 * https://docs.aws.amazon.com/IAM/latest/UserGuide/list_amazonappflow.html
 */
export declare class Appflow extends PolicyStatement {
    servicePrefix: string;
    actions: Actions;
    resourceTypes: ResourceTypes;
    /**
     * Action provider for service appflow
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/list_amazonappflow.html
     */
    constructor(props?: PolicyStatementProps);
    /**
     * Grants permission to create a login profile to be used with AppFlow flows
     *
     * Access Level: Write
     */
    createConnectorProfile(): this;
    /**
     * Grants permission to create an AppFlow flow
     *
     * Access Level: Write
     */
    createFlow(): this;
    /**
     * Grants permission to delete a login profile set up for use with AppFlow
     *
     * Access Level: Write
     */
    deleteConnectorProfile(): this;
    /**
     * Grants permission to delete an AppFlow flow
     *
     * Access Level: Write
     */
    deleteFlow(): this;
    /**
     * Grants permission to describe all fields supported by AppFlow
     *
     * Access Level: Read
     */
    describeConnectorFields(): this;
    /**
     * Grants permission to describe all login profiles configured in AppFlow
     *
     * Access Level: Read
     */
    describeConnectorProfiles(): this;
    /**
     * Grants permission to describe all connectors supported by AppFlow
     *
     * Access Level: Read
     */
    describeConnectors(): this;
    /**
     * Grants permission to describe all flow executions for a flow configured in AppFlow
     *
     * Access Level: Read
     */
    describeFlowExecution(): this;
    /**
     * Grants permission to describe all flows configured in AppFlow
     *
     * Access Level: Read
     */
    describeFlows(): this;
    /**
     * Grants permission to list all fields supported by AppFlow
     *
     * Access Level: Read
     */
    listConnectorFields(): this;
    /**
     * Grants permission to list tags for a flow
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/appflow/latest/APIReference/API_ListTagsForResource.html
     */
    listTagsForResource(): this;
    /**
     * Grants permission to run a flow configured in AppFlow
     *
     * Access Level: Write
     */
    runFlow(): this;
    /**
     * Grants permission to tag a flow
     *
     * Access Level: Tagging
     *
     * https://docs.aws.amazon.com/appflow/latest/APIReference/API_TagResource.html
     */
    tagResource(): this;
    /**
     * Grants permission to untag a flow
     *
     * Access Level: Tagging
     *
     * https://docs.aws.amazon.com/appflow/latest/APIReference/API_UntagResource.html
     */
    untagResource(): this;
    /**
     * Grants permission to update an AppFlow flow
     *
     * Access Level: Write
     */
    updateFlow(): this;
    /**
     * Adds a resource of type flow to the statement
     *
     * @param flowName - Identifier for the flowName.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     *
     * Possible condition keys:
     *  - aws:ResourceTag/${TagKey}
     */
    onFlow(flowName: string, account?: string, partition?: string): this;
    /**
     * Adds a resource of type connectorprofile to the statement
     *
     * @param profileName - Identifier for the profileName.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     */
    onConnectorprofile(profileName: string, account?: string, partition?: string): this;
}
