"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const shared_1 = require("../shared");
/**
 * Action provider for service frauddetector
 *
 * https://docs.aws.amazon.com/IAM/latest/UserGuide/list_amazonfrauddetector.html
 */
class Frauddetector extends shared_1.PolicyStatement {
    /**
     * Action provider for service frauddetector
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/list_amazonfrauddetector.html
     */
    constructor(props) {
        super(props);
        this.servicePrefix = 'frauddetector';
        this.actions = {
            "BatchCreateVariable": {
                "url": "https://docs.aws.amazon.com/frauddetector/latest/api/API_BatchCreateVariable",
                "description": "Creates a batch of variables.",
                "accessLevel": "Write"
            },
            "BatchGetVariable": {
                "url": "https://docs.aws.amazon.com/frauddetector/latest/api/API_BatchGetVariable",
                "description": "Gets a batch of variables.",
                "accessLevel": "List"
            },
            "CreateDetectorVersion": {
                "url": "https://docs.aws.amazon.com/frauddetector/latest/api/API_CreateDetectorVersion",
                "description": "Creates a detector version. The detector version starts in a DRAFT status.",
                "accessLevel": "Write"
            },
            "CreateModelVersion": {
                "url": "https://docs.aws.amazon.com/frauddetector/latest/api/API_CreateModelVersion",
                "description": "Creates a version of the model using the specified model type.",
                "accessLevel": "Write"
            },
            "CreateRule": {
                "url": "https://docs.aws.amazon.com/frauddetector/latest/api/API_CreateRule.html",
                "description": "Creates a rule for use with the specified detector.",
                "accessLevel": "Write"
            },
            "CreateVariable": {
                "url": "https://docs.aws.amazon.com/frauddetector/latest/api/API_CreateVariable.html",
                "description": "Creates a variable.",
                "accessLevel": "Write"
            },
            "DeleteDetector": {
                "url": "https://docs.aws.amazon.com/frauddetector/latest/api/API_DeleteDetector",
                "description": "Deletes the detector. Before deleting a detector, you must first delete all detector versions and rule versions associated with the detector.",
                "accessLevel": "Write"
            },
            "DeleteDetectorVersion": {
                "url": "https://docs.aws.amazon.com/frauddetector/latest/api/API_DeleteDetectorVersion",
                "description": "Deletes the detector version. You cannot delete detector versions that are in ACTIVE status.",
                "accessLevel": "Write"
            },
            "DeleteEvent": {
                "url": "https://docs.aws.amazon.com/frauddetector/latest/api/API_DeleteEvent",
                "description": "Deletes the specified event.",
                "accessLevel": "Write"
            },
            "DeleteRuleVersion": {
                "url": "https://docs.aws.amazon.com/frauddetector/latest/api/API_DeleteRuleVersion",
                "description": "Deletes the rule version. You cannot delete a rule version if it is used by an ACTIVE or INACTIVE detector version.",
                "accessLevel": "Write"
            },
            "DescribeDetector": {
                "url": "https://docs.aws.amazon.com/frauddetector/latest/api/API_DescribeDetector",
                "description": "Gets all versions for a specified detector.",
                "accessLevel": "Read"
            },
            "DescribeModelVersions": {
                "url": "https://docs.aws.amazon.com/frauddetector/latest/api/API_DescribeModelVersions",
                "description": "Gets all of the model versions for the specified model type or for the specified model type and model ID. You can also get details for a single, specified model version.",
                "accessLevel": "Read"
            },
            "GetDetectorVersion": {
                "url": "https://docs.aws.amazon.com/frauddetector/latest/api/API_GetDetectorVersion",
                "description": "Gets a particular detector version.",
                "accessLevel": "List"
            },
            "GetDetectors": {
                "url": "https://docs.aws.amazon.com/frauddetector/latest/api/API_GetDetectors",
                "description": "Gets all of detectors. This is a paginated API. If you provide a null maxSizePerPage, this actions retrieves a maximum of 10 records per page. If you provide a maxSizePerPage, the value must be between 5 and 10. To get the next page results, provide the pagination token from the GetEventTypesResponse as part of your request. A null pagination token fetches the records from the beginning.",
                "accessLevel": "List"
            },
            "GetExternalModels": {
                "url": "https://docs.aws.amazon.com/frauddetector/latest/api/API_GetExternalModels",
                "description": "Gets the details for one or more Amazon SageMaker models that have been imported into the service. This is a paginated API. If you provide a null maxSizePerPage, this actions retrieves a maximum of 10 records per page. If you provide a maxSizePerPage, the value must be between 5 and 10. To get the next page results, provide the pagination token from the GetExternalModelsResult as part of your request. A null pagination token fetches the records from the beginning.",
                "accessLevel": "List"
            },
            "GetModelVersion": {
                "url": "https://docs.aws.amazon.com/frauddetector/latest/api/API_GetModelVersion",
                "description": "Gets a model version.",
                "accessLevel": "List"
            },
            "GetModels": {
                "url": "https://docs.aws.amazon.com/frauddetector/latest/api/API_GetModels",
                "description": "Gets all of the models for the AWS account, or the specified model type, or gets a single model for the specified model type, model ID combination.",
                "accessLevel": "List"
            },
            "GetOutcomes": {
                "url": "https://docs.aws.amazon.com/frauddetector/latest/api/API_GetOutcomes",
                "description": "Gets one or more outcomes. This is a paginated API. If you provide a null maxSizePerPage, this actions retrieves a maximum of 10 records per page. If you provide a maxSizePerPage, the value must be between 50 and 100. To get the next page results, provide the pagination token from the GetOutcomesResult as part of your request. A null pagination token fetches the records from the beginning.",
                "accessLevel": "List"
            },
            "GetPrediction": {
                "url": "https://docs.aws.amazon.com/frauddetector/latest/api/API_GetPrediction",
                "description": "Evaluates an event against a detector version. If a version ID is not provided, the detector’s (ACTIVE) version is used.",
                "accessLevel": "Read"
            },
            "GetRules": {
                "url": "https://docs.aws.amazon.com/frauddetector/latest/api/API_GetRules.html",
                "description": "Gets all rules available for the specified detector.",
                "accessLevel": "List"
            },
            "GetVariables": {
                "url": "https://docs.aws.amazon.com/frauddetector/latest/api/API_GetVariables",
                "description": "Gets all of the variables or the specific variable. This is a paginated API. Providing null maxSizePerPage results in retrieving maximum of 100 records per page. If you provide maxSizePerPage the value must be between 50 and 100. To get the next page result, a provide a pagination token from GetVariablesResult as part of your request. Null pagination token fetches the records from the beginning.",
                "accessLevel": "List"
            },
            "PutDetector": {
                "url": "https://docs.aws.amazon.com/frauddetector/latest/api/API_PutDetector.html",
                "description": "Creates or updates a detector.",
                "accessLevel": "Write"
            },
            "PutExternalModel": {
                "url": "https://docs.aws.amazon.com/frauddetector/latest/api/API_PutExternalModel.html",
                "description": "Creates or updates an Amazon SageMaker model endpoint. You can also use this action to update the configuration of the model endpoint, including the IAM role and/or the mapped variables.",
                "accessLevel": "Write"
            },
            "PutModel": {
                "url": "https://docs.aws.amazon.com/frauddetector/latest/api/API_PutModel",
                "description": "Creates or updates a model.",
                "accessLevel": "Write"
            },
            "PutOutcome": {
                "url": "https://docs.aws.amazon.com/frauddetector/latest/api/API_PutOutcome.html",
                "description": "Creates or updates an outcome.",
                "accessLevel": "Write"
            },
            "UpdateDetectorVersion": {
                "url": "https://docs.aws.amazon.com/frauddetector/latest/api/API_UpdateDetectorVersion",
                "description": "Updates a detector version. The detector version attributes that you can update include models, external model endpoints, rules, and description. You can only update a DRAFT detector version.",
                "accessLevel": "Write"
            },
            "UpdateDetectorVersionMetadata": {
                "url": "https://docs.aws.amazon.com/frauddetector/latest/api/API_UpdateDetectorVersionMetadata",
                "description": "Updates the detector version's description. You can update the metadata for any detector version (DRAFT, ACTIVE, or INACTIVE).",
                "accessLevel": "Write"
            },
            "UpdateDetectorVersionStatus": {
                "url": "https://docs.aws.amazon.com/frauddetector/latest/api/API_UpdateDetectorVersionStatus",
                "description": "Updates the detector version’s status. You can perform the following promotions or demotions using UpdateDetectorVersionStatus: DRAFT to ACTIVE, ACTIVE to INACTIVE, and INACTIVE to ACTIVE.",
                "accessLevel": "Write"
            },
            "UpdateModelVersion": {
                "url": "https://docs.aws.amazon.com/frauddetector/latest/api/API_UpdateModelVersion",
                "description": "Updates a model version. You can update the description and status attributes using this action.",
                "accessLevel": "Write"
            },
            "UpdateRuleMetadata": {
                "url": "https://docs.aws.amazon.com/frauddetector/latest/api/API_UpdateRuleMetadata.html",
                "description": "Updates a rule's metadata.",
                "accessLevel": "Write"
            },
            "UpdateRuleVersion": {
                "url": "https://docs.aws.amazon.com/frauddetector/latest/api/API_UpdateRuleVersion.html",
                "description": "Updates a rule version resulting in a new rule version.",
                "accessLevel": "Write"
            },
            "UpdateVariable": {
                "url": "https://docs.aws.amazon.com/frauddetector/latest/api/API_UpdateVariable.html",
                "description": "Updates a variable.",
                "accessLevel": "Write"
            }
        };
        this.resourceTypes = {};
    }
    /**
     * Creates a batch of variables.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/frauddetector/latest/api/API_BatchCreateVariable
     */
    batchCreateVariable() {
        this.add('frauddetector:BatchCreateVariable');
        return this;
    }
    /**
     * Gets a batch of variables.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/frauddetector/latest/api/API_BatchGetVariable
     */
    batchGetVariable() {
        this.add('frauddetector:BatchGetVariable');
        return this;
    }
    /**
     * Creates a detector version. The detector version starts in a DRAFT status.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/frauddetector/latest/api/API_CreateDetectorVersion
     */
    createDetectorVersion() {
        this.add('frauddetector:CreateDetectorVersion');
        return this;
    }
    /**
     * Creates a version of the model using the specified model type.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/frauddetector/latest/api/API_CreateModelVersion
     */
    createModelVersion() {
        this.add('frauddetector:CreateModelVersion');
        return this;
    }
    /**
     * Creates a rule for use with the specified detector.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/frauddetector/latest/api/API_CreateRule.html
     */
    createRule() {
        this.add('frauddetector:CreateRule');
        return this;
    }
    /**
     * Creates a variable.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/frauddetector/latest/api/API_CreateVariable.html
     */
    createVariable() {
        this.add('frauddetector:CreateVariable');
        return this;
    }
    /**
     * Deletes the detector. Before deleting a detector, you must first delete all detector versions and rule versions associated with the detector.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/frauddetector/latest/api/API_DeleteDetector
     */
    deleteDetector() {
        this.add('frauddetector:DeleteDetector');
        return this;
    }
    /**
     * Deletes the detector version. You cannot delete detector versions that are in ACTIVE status.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/frauddetector/latest/api/API_DeleteDetectorVersion
     */
    deleteDetectorVersion() {
        this.add('frauddetector:DeleteDetectorVersion');
        return this;
    }
    /**
     * Deletes the specified event.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/frauddetector/latest/api/API_DeleteEvent
     */
    deleteEvent() {
        this.add('frauddetector:DeleteEvent');
        return this;
    }
    /**
     * Deletes the rule version. You cannot delete a rule version if it is used by an ACTIVE or INACTIVE detector version.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/frauddetector/latest/api/API_DeleteRuleVersion
     */
    deleteRuleVersion() {
        this.add('frauddetector:DeleteRuleVersion');
        return this;
    }
    /**
     * Gets all versions for a specified detector.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/frauddetector/latest/api/API_DescribeDetector
     */
    describeDetector() {
        this.add('frauddetector:DescribeDetector');
        return this;
    }
    /**
     * Gets all of the model versions for the specified model type or for the specified model type and model ID. You can also get details for a single, specified model version.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/frauddetector/latest/api/API_DescribeModelVersions
     */
    describeModelVersions() {
        this.add('frauddetector:DescribeModelVersions');
        return this;
    }
    /**
     * Gets a particular detector version.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/frauddetector/latest/api/API_GetDetectorVersion
     */
    getDetectorVersion() {
        this.add('frauddetector:GetDetectorVersion');
        return this;
    }
    /**
     * Gets all of detectors. This is a paginated API. If you provide a null maxSizePerPage, this actions retrieves a maximum of 10 records per page. If you provide a maxSizePerPage, the value must be between 5 and 10. To get the next page results, provide the pagination token from the GetEventTypesResponse as part of your request. A null pagination token fetches the records from the beginning.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/frauddetector/latest/api/API_GetDetectors
     */
    getDetectors() {
        this.add('frauddetector:GetDetectors');
        return this;
    }
    /**
     * Gets the details for one or more Amazon SageMaker models that have been imported into the service. This is a paginated API. If you provide a null maxSizePerPage, this actions retrieves a maximum of 10 records per page. If you provide a maxSizePerPage, the value must be between 5 and 10. To get the next page results, provide the pagination token from the GetExternalModelsResult as part of your request. A null pagination token fetches the records from the beginning.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/frauddetector/latest/api/API_GetExternalModels
     */
    getExternalModels() {
        this.add('frauddetector:GetExternalModels');
        return this;
    }
    /**
     * Gets a model version.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/frauddetector/latest/api/API_GetModelVersion
     */
    getModelVersion() {
        this.add('frauddetector:GetModelVersion');
        return this;
    }
    /**
     * Gets all of the models for the AWS account, or the specified model type, or gets a single model for the specified model type, model ID combination.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/frauddetector/latest/api/API_GetModels
     */
    getModels() {
        this.add('frauddetector:GetModels');
        return this;
    }
    /**
     * Gets one or more outcomes. This is a paginated API. If you provide a null maxSizePerPage, this actions retrieves a maximum of 10 records per page. If you provide a maxSizePerPage, the value must be between 50 and 100. To get the next page results, provide the pagination token from the GetOutcomesResult as part of your request. A null pagination token fetches the records from the beginning.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/frauddetector/latest/api/API_GetOutcomes
     */
    getOutcomes() {
        this.add('frauddetector:GetOutcomes');
        return this;
    }
    /**
     * Evaluates an event against a detector version. If a version ID is not provided, the detector’s (ACTIVE) version is used.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/frauddetector/latest/api/API_GetPrediction
     */
    getPrediction() {
        this.add('frauddetector:GetPrediction');
        return this;
    }
    /**
     * Gets all rules available for the specified detector.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/frauddetector/latest/api/API_GetRules.html
     */
    getRules() {
        this.add('frauddetector:GetRules');
        return this;
    }
    /**
     * Gets all of the variables or the specific variable. This is a paginated API. Providing null maxSizePerPage results in retrieving maximum of 100 records per page. If you provide maxSizePerPage the value must be between 50 and 100. To get the next page result, a provide a pagination token from GetVariablesResult as part of your request. Null pagination token fetches the records from the beginning.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/frauddetector/latest/api/API_GetVariables
     */
    getVariables() {
        this.add('frauddetector:GetVariables');
        return this;
    }
    /**
     * Creates or updates a detector.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/frauddetector/latest/api/API_PutDetector.html
     */
    putDetector() {
        this.add('frauddetector:PutDetector');
        return this;
    }
    /**
     * Creates or updates an Amazon SageMaker model endpoint. You can also use this action to update the configuration of the model endpoint, including the IAM role and/or the mapped variables.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/frauddetector/latest/api/API_PutExternalModel.html
     */
    putExternalModel() {
        this.add('frauddetector:PutExternalModel');
        return this;
    }
    /**
     * Creates or updates a model.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/frauddetector/latest/api/API_PutModel
     */
    putModel() {
        this.add('frauddetector:PutModel');
        return this;
    }
    /**
     * Creates or updates an outcome.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/frauddetector/latest/api/API_PutOutcome.html
     */
    putOutcome() {
        this.add('frauddetector:PutOutcome');
        return this;
    }
    /**
     * Updates a detector version. The detector version attributes that you can update include models, external model endpoints, rules, and description. You can only update a DRAFT detector version.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/frauddetector/latest/api/API_UpdateDetectorVersion
     */
    updateDetectorVersion() {
        this.add('frauddetector:UpdateDetectorVersion');
        return this;
    }
    /**
     * Updates the detector version's description. You can update the metadata for any detector version (DRAFT, ACTIVE, or INACTIVE).
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/frauddetector/latest/api/API_UpdateDetectorVersionMetadata
     */
    updateDetectorVersionMetadata() {
        this.add('frauddetector:UpdateDetectorVersionMetadata');
        return this;
    }
    /**
     * Updates the detector version’s status. You can perform the following promotions or demotions using UpdateDetectorVersionStatus: DRAFT to ACTIVE, ACTIVE to INACTIVE, and INACTIVE to ACTIVE.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/frauddetector/latest/api/API_UpdateDetectorVersionStatus
     */
    updateDetectorVersionStatus() {
        this.add('frauddetector:UpdateDetectorVersionStatus');
        return this;
    }
    /**
     * Updates a model version. You can update the description and status attributes using this action.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/frauddetector/latest/api/API_UpdateModelVersion
     */
    updateModelVersion() {
        this.add('frauddetector:UpdateModelVersion');
        return this;
    }
    /**
     * Updates a rule's metadata.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/frauddetector/latest/api/API_UpdateRuleMetadata.html
     */
    updateRuleMetadata() {
        this.add('frauddetector:UpdateRuleMetadata');
        return this;
    }
    /**
     * Updates a rule version resulting in a new rule version.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/frauddetector/latest/api/API_UpdateRuleVersion.html
     */
    updateRuleVersion() {
        this.add('frauddetector:UpdateRuleVersion');
        return this;
    }
    /**
     * Updates a variable.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/frauddetector/latest/api/API_UpdateVariable.html
     */
    updateVariable() {
        this.add('frauddetector:UpdateVariable');
        return this;
    }
}
exports.Frauddetector = Frauddetector;
//# sourceMappingURL=data:application/json;base64,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