"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const shared_1 = require("../shared");
/**
 * Action provider for service groundtruthlabeling
 *
 * https://docs.aws.amazon.com/IAM/latest/UserGuide/list_amazongroundtruthlabeling.html
 */
class Groundtruthlabeling extends shared_1.PolicyStatement {
    /**
     * Action provider for service groundtruthlabeling
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/list_amazongroundtruthlabeling.html
     */
    constructor(props) {
        super(props);
        this.servicePrefix = 'groundtruthlabeling';
        this.actions = {
            "DescribeConsoleJob": {
                "url": "https://docs.aws.amazon.com/sagemaker/latest/dg/sms-data-input.html#sms-console-create-manifest-file",
                "description": "Get status of GroundTruthLabeling Jobs.",
                "accessLevel": "Read"
            },
            "ListDatasetObjects": {
                "url": "https://docs.aws.amazon.com/sagemaker/latest/dg/sms-data-input.html#sms-console-create-manifest-file",
                "description": "Paginated list API to list dataset objects in a manifest file.",
                "accessLevel": "Read"
            },
            "RunFilterOrSampleDatasetJob": {
                "url": "https://docs.aws.amazon.com/sagemaker/latest/dg/sms-data-input.html#sms-data-filtering",
                "description": "Filter records from a manifest file using S3 select. Get sample entries based on random sampling.",
                "accessLevel": "Write"
            },
            "RunGenerateManifestByCrawlingJob": {
                "url": "https://docs.aws.amazon.com/sagemaker/latest/dg/sms-data-input.html#sms-console-create-manifest-file",
                "description": "List a S3 prefix and create manifest files from objects in that location.",
                "accessLevel": "Write"
            }
        };
        this.resourceTypes = {};
    }
    /**
     * Get status of GroundTruthLabeling Jobs.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/sagemaker/latest/dg/sms-data-input.html#sms-console-create-manifest-file
     */
    describeConsoleJob() {
        this.add('groundtruthlabeling:DescribeConsoleJob');
        return this;
    }
    /**
     * Paginated list API to list dataset objects in a manifest file.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/sagemaker/latest/dg/sms-data-input.html#sms-console-create-manifest-file
     */
    listDatasetObjects() {
        this.add('groundtruthlabeling:ListDatasetObjects');
        return this;
    }
    /**
     * Filter records from a manifest file using S3 select. Get sample entries based on random sampling.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/sagemaker/latest/dg/sms-data-input.html#sms-data-filtering
     */
    runFilterOrSampleDatasetJob() {
        this.add('groundtruthlabeling:RunFilterOrSampleDatasetJob');
        return this;
    }
    /**
     * List a S3 prefix and create manifest files from objects in that location.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/sagemaker/latest/dg/sms-data-input.html#sms-console-create-manifest-file
     */
    runGenerateManifestByCrawlingJob() {
        this.add('groundtruthlabeling:RunGenerateManifestByCrawlingJob');
        return this;
    }
}
exports.Groundtruthlabeling = Groundtruthlabeling;
//# sourceMappingURL=data:application/json;base64,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