import { Actions, PolicyStatement, ResourceTypes } from "../shared";
import { PolicyStatementProps } from "@aws-cdk/aws-iam";
/**
 * Action provider for service macie2
 *
 * https://docs.aws.amazon.com/IAM/latest/UserGuide/list_amazonmacie.html
 */
export declare class Macie2 extends PolicyStatement {
    servicePrefix: string;
    actions: Actions;
    resourceTypes: ResourceTypes;
    /**
     * Action provider for service macie2
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/list_amazonmacie.html
     */
    constructor(props?: PolicyStatementProps);
    /**
     * Grants permission to accept an Amazon Macie membership invitation
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/macie/latest/APIReference/invitations-accept.html
     */
    acceptInvitation(): this;
    /**
     * Grants permission to archive one or more findings
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/macie/latest/APIReference/findings-archive.html
     */
    archiveFindings(): this;
    /**
     * Grants permission to retrieve information about one or more custom data identifiers
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/macie/latest/APIReference/custom-data-identifiers-get.html
     */
    batchGetCustomDataIdentifiers(): this;
    /**
     * Grants permission to create and define the settings for a classification job
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/macie/latest/APIReference/jobs.html
     */
    createClassificationJob(): this;
    /**
     * Grants permission to create and define the settings for a custom data identifier
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/macie/latest/APIReference/custom-data-identifiers.html
     */
    createCustomDataIdentifier(): this;
    /**
     * Grants permission to create and define the settings for a findings filter
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/macie/latest/APIReference/findingsfilters.html
     */
    createFindingsFilter(): this;
    /**
     * Grants permission to send an Amazon Macie membership invitation
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/macie/latest/APIReference/invitations.html
     */
    createInvitations(): this;
    /**
     * Grants permission to associate an account with an Amazon Macie master account
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/macie/latest/APIReference/members.html
     */
    createMember(): this;
    /**
     * Grants permission to create sample findings
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/macie/latest/APIReference/findings-sample.html
     */
    createSampleFindings(): this;
    /**
     * Grants permission to decline Amazon Macie membership invitations
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/macie/latest/APIReference/invitations-decline.html
     */
    declineInvitations(): this;
    /**
     * Grants permission to delete a custom data identifier
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/macie/latest/APIReference/custom-data-identifiers-id.html
     */
    deleteCustomDataIdentifier(): this;
    /**
     * Grants permission to delete a findings filter
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/macie/latest/APIReference/findingsfilters-id.html
     */
    deleteFindingsFilter(): this;
    /**
     * Grants permission to delete Amazon Macie membership invitations
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/macie/latest/APIReference/invitations-delete.html
     */
    deleteInvitations(): this;
    /**
     * Grants permission to delete the association between an Amazon Macie master account and an account
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/macie/latest/APIReference/members-id.html
     */
    deleteMember(): this;
    /**
     * Grants permission to retrieve statistical and other data about S3 buckets that Amazon Macie monitors and analyzes
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/macie/latest/APIReference/datasources-s3.html
     */
    describeBuckets(): this;
    /**
     * Grants permission to retrieve information about the status and settings for a classification job
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/macie/latest/APIReference/jobs-jobid.html
     */
    describeClassificationJob(): this;
    /**
     * Grants permission to retrieve information about the Amazon Macie configuration settings for an AWS organization
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/macie/latest/APIReference/admin-configuration.html
     */
    describeOrganizationConfiguration(): this;
    /**
     * Grants permission to disable an Amazon Macie account, which also deletes Macie resources for the account
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/macie/latest/APIReference/macie.html
     */
    disableMacie(): this;
    /**
     * Grants permission to disable an account as a delegated administrator of Amazon Macie for an AWS organization
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/macie/latest/APIReference/admin.html
     */
    disableOrganizationAdminAccount(): this;
    /**
     * Grants an Amazon Macie member account with permission to disassociate from its master account
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/macie/latest/APIReference/master-disassociate.html
     */
    disassociateFromMasterAccount(): this;
    /**
     * Grants an Amazon Macie master account with permission to disassociate from a member account
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/macie/latest/APIReference/members-disassociate-id.html
     */
    disassociateMember(): this;
    /**
     * Grants permission to enable and specify the configuration settings for a new Amazon Macie account
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/macie/latest/APIReference/macie.html
     */
    enableMacie(): this;
    /**
     * Grants permission to enable an account as a delegated administrator of Amazon Macie for an AWS organization
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/macie/latest/APIReference/admin.html
     */
    enableOrganizationAdminAccount(): this;
    /**
     * Grants permission to retrieve aggregated statistical data for all the S3 buckets that Amazon Macie monitors and analyzes
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/macie/latest/APIReference/datasources-s3-statistics.html
     */
    getBucketStatistics(): this;
    /**
     * Grants permission to retrieve the settings for exporting data classification results
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/macie/latest/APIReference/classification-export-configuration.html
     */
    getClassificationExportConfiguration(): this;
    /**
     * Grants permission to retrieve information about the settings for a custom data identifier
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/macie/latest/APIReference/custom-data-identifiers-id.html
     */
    getCustomDataIdentifier(): this;
    /**
     * Grants permission to retrieve aggregated statistical data about findings
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/macie/latest/APIReference/findings-statistics.html
     */
    getFindingStatistics(): this;
    /**
     * Grants permission to retrieve information about one or more findings
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/macie/latest/APIReference/findings-describe.html
     */
    getFindings(): this;
    /**
     * Grants permission to retrieve information about the settings for a findings filter
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/macie/latest/APIReference/findingsfilters-id.html
     */
    getFindingsFilter(): this;
    /**
     * Grants permission to retrieve the count of Amazon Macie membership invitations that were received by an account
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/macie/latest/APIReference/invitations-count.html
     */
    getInvitationsCount(): this;
    /**
     * Grants permission to retrieve information about the status and configuration settings for an Amazon Macie account
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/macie/latest/APIReference/macie.html
     */
    getMacieSession(): this;
    /**
     * Grants permission to retrieve information about the Amazon Macie master account for an account
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/macie/latest/APIReference/master.html
     */
    getMasterAccount(): this;
    /**
     * Grants permission to retrieve information about an account that's associated with an Amazon Macie master account
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/macie/latest/APIReference/members-id.html
     */
    getMember(): this;
    /**
     * Grants permission to retrieve quotas and aggregated usage data for one or more accounts
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/macie/latest/APIReference/usage-statistics.html
     */
    getUsageStatistics(): this;
    /**
     * Grants permission to retrieve aggregated usage data for an account
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/macie/latest/APIReference/usage.html
     */
    getUsageTotals(): this;
    /**
     * Grants permission to retrieve information about the status and settings for one or more classification jobs
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/macie/latest/APIReference/jobs-list.html
     */
    listClassificationJobs(): this;
    /**
     * Grants permission to retrieve information about all custom data identifiers
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/macie/latest/APIReference/custom-data-identifiers-list.html
     */
    listCustomDataIdentifiers(): this;
    /**
     * Grants permission to retrieve a subset of information about one or more findings
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/macie/latest/APIReference/findings.html
     */
    listFindings(): this;
    /**
     * Grants permission to retrieve information about all findings filters
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/macie/latest/APIReference/findingsfilters.html
     */
    listFindingsFilters(): this;
    /**
     * Grants permission to retrieve information about all the Amazon Macie membership invitations that were received by an account
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/macie/latest/APIReference/invitations.html
     */
    listInvitations(): this;
    /**
     * Grants permission to retrieve information about all the accounts that are associated with an Amazon Macie master account
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/macie/latest/APIReference/members.html
     */
    listMembers(): this;
    /**
     * Grants permission to retrieve information about the delegated, Amazon Macie administrator account for an AWS organization
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/macie/latest/APIReference/admin.html
     */
    listOrganizationAdminAccounts(): this;
    /**
     * Grants permission to retrieve the tags for an Amazon Macie resource or member account
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/macie/latest/APIReference/tags-resourcearn.html
     */
    listTagsForResources(): this;
    /**
     * Grants permission to create or update the settings for exporting data classification results
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/macie/latest/APIReference/classification-export-configuration.html
     */
    putClassificationExportConfiguration(): this;
    /**
     * Grants permission to add or update the tags for an Amazon Macie resource or member account
     *
     * Access Level: Tagging
     *
     * https://docs.aws.amazon.com/macie/latest/APIReference/tags-resourcearn.html
     */
    tagResource(): this;
    /**
     * Grants permission to test a custom data identifier
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/macie/latest/APIReference/custom-data-identifiers-test.html
     */
    testCustomDataIdentifier(): this;
    /**
     * Grants permission to reactivate (unarchive) one or more findings
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/macie/latest/APIReference/findings-unarchive.html
     */
    unarchiveFindings(): this;
    /**
     * Grants permission to remove tags from an Amazon Macie resource or member account
     *
     * Access Level: Tagging
     *
     * https://docs.aws.amazon.com/macie/latest/APIReference/tags-resourcearn.html
     */
    untagResource(): this;
    /**
     * Grants permission to cancel a classification job
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/macie/latest/APIReference/jobs-jobid.html
     */
    updateClassificationJob(): this;
    /**
     * Grants permission to update the settings for a findings filter
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/macie/latest/APIReference/findingsfilters-id.html
     */
    updateFindingsFilter(): this;
    /**
     * Grants permission to suspend or re-enable an Amazon Macie account, or update the configuration settings for a Macie account
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/macie/latest/APIReference/macie.html
     */
    updateMacieSession(): this;
    /**
     * Grants an Amazon Macie master account with permission to suspend or re-enable a member account
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/macie/latest/APIReference/macie-members-id.html
     */
    updateMemberSession(): this;
    /**
     * Grants permission to update Amazon Macie configuration settings for an AWS organization
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/macie/latest/APIReference/admin-configuration.html
     */
    updateOrganizationConfiguration(): this;
    /**
     * Adds a resource of type ClassificationJob to the statement
     *
     * https://docs.aws.amazon.com/macie/latest/user/what-is-macie.html
     *
     * @param resourceId - Identifier for the resourceId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     *
     * Possible condition keys:
     *  - aws:ResourceTag/${TagKey}
     */
    onClassificationJob(resourceId: string, account?: string, partition?: string): this;
    /**
     * Adds a resource of type CustomDataIdentifier to the statement
     *
     * https://docs.aws.amazon.com/macie/latest/user/what-is-macie.html.html
     *
     * @param resourceId - Identifier for the resourceId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     *
     * Possible condition keys:
     *  - aws:ResourceTag/${TagKey}
     */
    onCustomDataIdentifier(resourceId: string, account?: string, partition?: string): this;
    /**
     * Adds a resource of type Member to the statement
     *
     * https://docs.aws.amazon.com/macie/latest/user/what-is-macie.html
     *
     * @param resourceId - Identifier for the resourceId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     *
     * Possible condition keys:
     *  - aws:ResourceTag/${TagKey}
     */
    onMember(resourceId: string, account?: string, partition?: string): this;
    /**
     * Adds a resource of type FindingsFilter to the statement
     *
     * https://docs.aws.amazon.com/macie/latest/user/what-is-macie.html
     *
     * @param resourceId - Identifier for the resourceId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     *
     * Possible condition keys:
     *  - aws:ResourceTag/${TagKey}
     */
    onFindingsFilter(resourceId: string, account?: string, partition?: string): this;
}
