"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const shared_1 = require("../shared");
/**
 * Action provider for service macie
 *
 * https://docs.aws.amazon.com/IAM/latest/UserGuide/list_amazonmacieclassic.html
 */
class Macie extends shared_1.PolicyStatement {
    /**
     * Action provider for service macie
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/list_amazonmacieclassic.html
     */
    constructor(props) {
        super(props);
        this.servicePrefix = 'macie';
        this.actions = {
            "AssociateMemberAccount": {
                "url": "https://docs.aws.amazon.com/macie/1.0/APIReference/API_AssociateMemberAccount.html",
                "description": "Enables the user to associate a specified AWS account with Amazon Macie as a member account.",
                "accessLevel": "Write"
            },
            "AssociateS3Resources": {
                "url": "https://docs.aws.amazon.com/macie/1.0/APIReference/API_AssociateS3Resources.html",
                "description": "Enables the user to associate specified S3 resources with Amazon Macie for monitoring and data classification.",
                "accessLevel": "Write",
                "conditions": [
                    "aws:SourceArn"
                ]
            },
            "DisassociateMemberAccount": {
                "url": "https://docs.aws.amazon.com/macie/1.0/APIReference/API_DisassociateMemberAccount.html",
                "description": "Enables the user to remove the specified member account from Amazon Macie.",
                "accessLevel": "Write"
            },
            "DisassociateS3Resources": {
                "url": "https://docs.aws.amazon.com/macie/1.0/APIReference/API_DisassociateS3Resources.html",
                "description": "Enables the user to remove specified S3 resources from being monitored by Amazon Macie.",
                "accessLevel": "Write",
                "conditions": [
                    "aws:SourceArn"
                ]
            },
            "ListMemberAccounts": {
                "url": "https://docs.aws.amazon.com/macie/1.0/APIReference/API_ListMemberAccounts.html",
                "description": "Enables the user to list all Amazon Macie member accounts for the current Macie master account.",
                "accessLevel": "List"
            },
            "ListS3Resources": {
                "url": "https://docs.aws.amazon.com/macie/1.0/APIReference/API_ListS3Resources.html",
                "description": "Enables the user to list all the S3 resources associated with Amazon Macie.",
                "accessLevel": "List"
            },
            "UpdateS3Resources": {
                "url": "https://docs.aws.amazon.com/macie/1.0/APIReference/API_UpdateS3Resources.html",
                "description": "Enables the user to update the classification types for the specified S3 resources.",
                "accessLevel": "Write",
                "conditions": [
                    "aws:SourceArn"
                ]
            }
        };
        this.resourceTypes = {};
    }
    /**
     * Enables the user to associate a specified AWS account with Amazon Macie as a member account.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/macie/1.0/APIReference/API_AssociateMemberAccount.html
     */
    associateMemberAccount() {
        this.add('macie:AssociateMemberAccount');
        return this;
    }
    /**
     * Enables the user to associate specified S3 resources with Amazon Macie for monitoring and data classification.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/macie/1.0/APIReference/API_AssociateS3Resources.html
     */
    associateS3Resources() {
        this.add('macie:AssociateS3Resources');
        return this;
    }
    /**
     * Enables the user to remove the specified member account from Amazon Macie.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/macie/1.0/APIReference/API_DisassociateMemberAccount.html
     */
    disassociateMemberAccount() {
        this.add('macie:DisassociateMemberAccount');
        return this;
    }
    /**
     * Enables the user to remove specified S3 resources from being monitored by Amazon Macie.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/macie/1.0/APIReference/API_DisassociateS3Resources.html
     */
    disassociateS3Resources() {
        this.add('macie:DisassociateS3Resources');
        return this;
    }
    /**
     * Enables the user to list all Amazon Macie member accounts for the current Macie master account.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/macie/1.0/APIReference/API_ListMemberAccounts.html
     */
    listMemberAccounts() {
        this.add('macie:ListMemberAccounts');
        return this;
    }
    /**
     * Enables the user to list all the S3 resources associated with Amazon Macie.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/macie/1.0/APIReference/API_ListS3Resources.html
     */
    listS3Resources() {
        this.add('macie:ListS3Resources');
        return this;
    }
    /**
     * Enables the user to update the classification types for the specified S3 resources.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/macie/1.0/APIReference/API_UpdateS3Resources.html
     */
    updateS3Resources() {
        this.add('macie:UpdateS3Resources');
        return this;
    }
}
exports.Macie = Macie;
//# sourceMappingURL=data:application/json;base64,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