import { Actions, PolicyStatement, ResourceTypes } from "../shared";
import { PolicyStatementProps } from "@aws-cdk/aws-iam";
/**
 * Action provider for service ec2messages
 *
 * https://docs.aws.amazon.com/IAM/latest/UserGuide/list_amazonmessagedeliveryservice.html
 */
export declare class Ec2messages extends PolicyStatement {
    servicePrefix: string;
    actions: Actions;
    resourceTypes: ResourceTypes;
    /**
     * Action provider for service ec2messages
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/list_amazonmessagedeliveryservice.html
     */
    constructor(props?: PolicyStatementProps);
    /**
     * Acknowledges a message, ensuring it will not be delivered again
     *
     * Access Level: Write
     */
    acknowledgeMessage(): this;
    /**
     * Deletes a message
     *
     * Access Level: Write
     */
    deleteMessage(): this;
    /**
     * Fails a message, signifying the message could not be processed successfully, ensuring it cannot be replied to or delivered again
     *
     * Access Level: Write
     */
    failMessage(): this;
    /**
     * Routes traffic to the correct endpoint based on the given destination for the messages
     *
     * Access Level: Read
     */
    getEndpoint(): this;
    /**
     * Delivers messages to clients/instances using long polling
     *
     * Access Level: Read
     */
    getMessages(): this;
    /**
     * Sends replies from clients/instances to upstream service
     *
     * Access Level: Write
     */
    sendReply(): this;
}
