"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const shared_1 = require("../shared");
/**
 * Action provider for service mobileanalytics
 *
 * https://docs.aws.amazon.com/IAM/latest/UserGuide/list_amazonmobileanalytics.html
 */
class Mobileanalytics extends shared_1.PolicyStatement {
    /**
     * Action provider for service mobileanalytics
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/list_amazonmobileanalytics.html
     */
    constructor(props) {
        super(props);
        this.servicePrefix = 'mobileanalytics';
        this.actions = {
            "GetFinancialReports": {
                "url": "",
                "description": "Grant access to financial metrics for an app",
                "accessLevel": "Read"
            },
            "GetReports": {
                "url": "",
                "description": "Grant access to standard metrics for an app",
                "accessLevel": "Read"
            },
            "PutEvents": {
                "url": "https://docs.aws.amazon.com/mobileanalytics/latest/ug/PutEvents.html",
                "description": "The PutEvents operation records one or more events",
                "accessLevel": "Write"
            }
        };
        this.resourceTypes = {};
    }
    /**
     * Grant access to financial metrics for an app
     *
     * Access Level: Read
     */
    getFinancialReports() {
        this.add('mobileanalytics:GetFinancialReports');
        return this;
    }
    /**
     * Grant access to standard metrics for an app
     *
     * Access Level: Read
     */
    getReports() {
        this.add('mobileanalytics:GetReports');
        return this;
    }
    /**
     * The PutEvents operation records one or more events
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/mobileanalytics/latest/ug/PutEvents.html
     */
    putEvents() {
        this.add('mobileanalytics:PutEvents');
        return this;
    }
}
exports.Mobileanalytics = Mobileanalytics;
//# sourceMappingURL=data:application/json;base64,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