"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const shared_1 = require("../shared");
/**
 * Action provider for service route53domains
 *
 * https://docs.aws.amazon.com/IAM/latest/UserGuide/list_amazonroute53domains.html
 */
class Route53domains extends shared_1.PolicyStatement {
    /**
     * Action provider for service route53domains
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/list_amazonroute53domains.html
     */
    constructor(props) {
        super(props);
        this.servicePrefix = 'route53domains';
        this.actions = {
            "CheckDomainAvailability": {
                "url": "https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_CheckDomainAvailability.html",
                "description": "Grants permission to check the availability of one domain name",
                "accessLevel": "Read"
            },
            "DeleteTagsForDomain": {
                "url": "https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_DeleteTagsForDomain.html",
                "description": "Grants permission to delete the specified tags for a domain",
                "accessLevel": "Tagging"
            },
            "DisableDomainAutoRenew": {
                "url": "https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_DisableDomainAutoRenew.html",
                "description": "Grants permission to configure Amazon Route 53 to automatically renew the specified domain before the domain registration expires",
                "accessLevel": "Write"
            },
            "DisableDomainTransferLock": {
                "url": "https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_DisableDomainTransferLock.html",
                "description": "Grants permission to remove the transfer lock on the domain (specifically the clientTransferProhibited status) to allow domain transfers",
                "accessLevel": "Write"
            },
            "EnableDomainAutoRenew": {
                "url": "https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_DisableDomainAutoRenew.html",
                "description": "Grants permission to configure Amazon Route 53 to automatically renew the specified domain before the domain registration expires",
                "accessLevel": "Write"
            },
            "EnableDomainTransferLock": {
                "url": "https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_EnableDomainTransferLock.html",
                "description": "Grants permission to set the transfer lock on the domain (specifically the clientTransferProhibited status) to prevent domain transfers",
                "accessLevel": "Write"
            },
            "GetContactReachabilityStatus": {
                "url": "https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_GetContactReachabilityStatus.html",
                "description": "For operations that require confirmation that the email address for the registrant contact is valid, such as registering a new domain, grants permission to get information about whether the registrant contact has responded",
                "accessLevel": "Read"
            },
            "GetDomainDetail": {
                "url": "https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_GetDomainDetail.html",
                "description": "Grants permission to get detailed information about a domain",
                "accessLevel": "Read"
            },
            "GetDomainSuggestions": {
                "url": "https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_GetDomainSuggestions.html",
                "description": "Grants permission to get a list of suggested domain names given a string, which can either be a domain name or simply a word or phrase (without spaces)",
                "accessLevel": "Read"
            },
            "GetOperationDetail": {
                "url": "https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_GetOperationDetail.html",
                "description": "Grants permission to get the current status of an operation that is not completed",
                "accessLevel": "Read"
            },
            "ListDomains": {
                "url": "https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_ListDomains.html",
                "description": "Grants permission to list all the domain names registered with Amazon Route 53 for the current AWS account",
                "accessLevel": "List"
            },
            "ListOperations": {
                "url": "https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_ListOperations.html",
                "description": "Grants permission to list the operation IDs of operations that are not yet complete",
                "accessLevel": "List"
            },
            "ListTagsForDomain": {
                "url": "https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_ListTagsForDomain.html",
                "description": "Grants permission to list all the tags that are associated with the specified domain",
                "accessLevel": "List"
            },
            "RegisterDomain": {
                "url": "https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_RegisterDomain.html",
                "description": "Grants permission to register domains",
                "accessLevel": "Write"
            },
            "RenewDomain": {
                "url": "https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_RenewDomain.html",
                "description": "Grants permission to renew domains for the specified number of years",
                "accessLevel": "Write"
            },
            "ResendContactReachabilityEmail": {
                "url": "https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_ResendContactReachabilityEmail.html",
                "description": "For operations that require confirmation that the email address for the registrant contact is valid, such as registering a new domain, grants permission to resend the confirmation email to the current email address for the registrant contact",
                "accessLevel": "Write"
            },
            "RetrieveDomainAuthCode": {
                "url": "https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_RetrieveDomainAuthCode.html",
                "description": "Grants permission to get the AuthCode for the domain",
                "accessLevel": "Write"
            },
            "TransferDomain": {
                "url": "https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_TransferDomain.html",
                "description": "Grants permission to transfer a domain from another registrar to Amazon Route 53",
                "accessLevel": "Write"
            },
            "UpdateDomainContact": {
                "url": "https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_UpdateDomainContact.html",
                "description": "Grants permission to update the contact information for domain",
                "accessLevel": "Write"
            },
            "UpdateDomainContactPrivacy": {
                "url": "https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_UpdateDomainContactPrivacy.html",
                "description": "Grants permission to update the domain contact privacy setting",
                "accessLevel": "Write"
            },
            "UpdateDomainNameservers": {
                "url": "https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_UpdateDomainNameservers.html",
                "description": "Grants permission to replace the current set of name servers for a domain with the specified set of name servers",
                "accessLevel": "Write"
            },
            "UpdateTagsForDomain": {
                "url": "https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_UpdateTagsForDomain.html",
                "description": "Grants permission to add or update tags for a specified domain",
                "accessLevel": "Tagging"
            },
            "ViewBilling": {
                "url": "https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_ViewBilling.html",
                "description": "Grants permission to get all the domain-related billing records for the current AWS account for a specified period",
                "accessLevel": "Read"
            }
        };
        this.resourceTypes = {};
    }
    /**
     * Grants permission to check the availability of one domain name
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_CheckDomainAvailability.html
     */
    checkDomainAvailability() {
        this.add('route53domains:CheckDomainAvailability');
        return this;
    }
    /**
     * Grants permission to delete the specified tags for a domain
     *
     * Access Level: Tagging
     *
     * https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_DeleteTagsForDomain.html
     */
    deleteTagsForDomain() {
        this.add('route53domains:DeleteTagsForDomain');
        return this;
    }
    /**
     * Grants permission to configure Amazon Route 53 to automatically renew the specified domain before the domain registration expires
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_DisableDomainAutoRenew.html
     */
    disableDomainAutoRenew() {
        this.add('route53domains:DisableDomainAutoRenew');
        return this;
    }
    /**
     * Grants permission to remove the transfer lock on the domain (specifically the clientTransferProhibited status) to allow domain transfers
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_DisableDomainTransferLock.html
     */
    disableDomainTransferLock() {
        this.add('route53domains:DisableDomainTransferLock');
        return this;
    }
    /**
     * Grants permission to configure Amazon Route 53 to automatically renew the specified domain before the domain registration expires
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_DisableDomainAutoRenew.html
     */
    enableDomainAutoRenew() {
        this.add('route53domains:EnableDomainAutoRenew');
        return this;
    }
    /**
     * Grants permission to set the transfer lock on the domain (specifically the clientTransferProhibited status) to prevent domain transfers
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_EnableDomainTransferLock.html
     */
    enableDomainTransferLock() {
        this.add('route53domains:EnableDomainTransferLock');
        return this;
    }
    /**
     * For operations that require confirmation that the email address for the registrant contact is valid, such as registering a new domain, grants permission to get information about whether the registrant contact has responded
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_GetContactReachabilityStatus.html
     */
    getContactReachabilityStatus() {
        this.add('route53domains:GetContactReachabilityStatus');
        return this;
    }
    /**
     * Grants permission to get detailed information about a domain
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_GetDomainDetail.html
     */
    getDomainDetail() {
        this.add('route53domains:GetDomainDetail');
        return this;
    }
    /**
     * Grants permission to get a list of suggested domain names given a string, which can either be a domain name or simply a word or phrase (without spaces)
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_GetDomainSuggestions.html
     */
    getDomainSuggestions() {
        this.add('route53domains:GetDomainSuggestions');
        return this;
    }
    /**
     * Grants permission to get the current status of an operation that is not completed
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_GetOperationDetail.html
     */
    getOperationDetail() {
        this.add('route53domains:GetOperationDetail');
        return this;
    }
    /**
     * Grants permission to list all the domain names registered with Amazon Route 53 for the current AWS account
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_ListDomains.html
     */
    listDomains() {
        this.add('route53domains:ListDomains');
        return this;
    }
    /**
     * Grants permission to list the operation IDs of operations that are not yet complete
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_ListOperations.html
     */
    listOperations() {
        this.add('route53domains:ListOperations');
        return this;
    }
    /**
     * Grants permission to list all the tags that are associated with the specified domain
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_ListTagsForDomain.html
     */
    listTagsForDomain() {
        this.add('route53domains:ListTagsForDomain');
        return this;
    }
    /**
     * Grants permission to register domains
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_RegisterDomain.html
     */
    registerDomain() {
        this.add('route53domains:RegisterDomain');
        return this;
    }
    /**
     * Grants permission to renew domains for the specified number of years
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_RenewDomain.html
     */
    renewDomain() {
        this.add('route53domains:RenewDomain');
        return this;
    }
    /**
     * For operations that require confirmation that the email address for the registrant contact is valid, such as registering a new domain, grants permission to resend the confirmation email to the current email address for the registrant contact
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_ResendContactReachabilityEmail.html
     */
    resendContactReachabilityEmail() {
        this.add('route53domains:ResendContactReachabilityEmail');
        return this;
    }
    /**
     * Grants permission to get the AuthCode for the domain
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_RetrieveDomainAuthCode.html
     */
    retrieveDomainAuthCode() {
        this.add('route53domains:RetrieveDomainAuthCode');
        return this;
    }
    /**
     * Grants permission to transfer a domain from another registrar to Amazon Route 53
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_TransferDomain.html
     */
    transferDomain() {
        this.add('route53domains:TransferDomain');
        return this;
    }
    /**
     * Grants permission to update the contact information for domain
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_UpdateDomainContact.html
     */
    updateDomainContact() {
        this.add('route53domains:UpdateDomainContact');
        return this;
    }
    /**
     * Grants permission to update the domain contact privacy setting
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_UpdateDomainContactPrivacy.html
     */
    updateDomainContactPrivacy() {
        this.add('route53domains:UpdateDomainContactPrivacy');
        return this;
    }
    /**
     * Grants permission to replace the current set of name servers for a domain with the specified set of name servers
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_UpdateDomainNameservers.html
     */
    updateDomainNameservers() {
        this.add('route53domains:UpdateDomainNameservers');
        return this;
    }
    /**
     * Grants permission to add or update tags for a specified domain
     *
     * Access Level: Tagging
     *
     * https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_UpdateTagsForDomain.html
     */
    updateTagsForDomain() {
        this.add('route53domains:UpdateTagsForDomain');
        return this;
    }
    /**
     * Grants permission to get all the domain-related billing records for the current AWS account for a specified period
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_ViewBilling.html
     */
    viewBilling() {
        this.add('route53domains:ViewBilling');
        return this;
    }
}
exports.Route53domains = Route53domains;
//# sourceMappingURL=data:application/json;base64,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