"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const shared_1 = require("../shared");
/**
 * Action provider for service ssmmessages
 *
 * https://docs.aws.amazon.com/IAM/latest/UserGuide/list_amazonsessionmanagermessagegatewayservice.html
 */
class Ssmmessages extends shared_1.PolicyStatement {
    /**
     * Action provider for service ssmmessages
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/list_amazonsessionmanagermessagegatewayservice.html
     */
    constructor(props) {
        super(props);
        this.servicePrefix = 'ssmmessages';
        this.actions = {
            "CreateControlChannel": {
                "url": "",
                "description": "Registers a control channel for an instance to send control messages to Systems Manager service.",
                "accessLevel": "Write"
            },
            "CreateDataChannel": {
                "url": "",
                "description": "Registers a data channel for an instance to send data messages to Systems Manager service.",
                "accessLevel": "Write"
            },
            "OpenControlChannel": {
                "url": "",
                "description": "Opens a websocket connection for a registered control channel stream from an instance to Systems Manager service.",
                "accessLevel": "Write"
            },
            "OpenDataChannel": {
                "url": "",
                "description": "Opens a websocket connection for a registered data channel stream from an instance to Systems Manager service.",
                "accessLevel": "Write"
            }
        };
        this.resourceTypes = {};
    }
    /**
     * Registers a control channel for an instance to send control messages to Systems Manager service.
     *
     * Access Level: Write
     */
    createControlChannel() {
        this.add('ssmmessages:CreateControlChannel');
        return this;
    }
    /**
     * Registers a data channel for an instance to send data messages to Systems Manager service.
     *
     * Access Level: Write
     */
    createDataChannel() {
        this.add('ssmmessages:CreateDataChannel');
        return this;
    }
    /**
     * Opens a websocket connection for a registered control channel stream from an instance to Systems Manager service.
     *
     * Access Level: Write
     */
    openControlChannel() {
        this.add('ssmmessages:OpenControlChannel');
        return this;
    }
    /**
     * Opens a websocket connection for a registered data channel stream from an instance to Systems Manager service.
     *
     * Access Level: Write
     */
    openDataChannel() {
        this.add('ssmmessages:OpenDataChannel');
        return this;
    }
}
exports.Ssmmessages = Ssmmessages;
//# sourceMappingURL=data:application/json;base64,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