"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const shared_1 = require("../shared");
/**
 * Action provider for service storagegateway
 *
 * https://docs.aws.amazon.com/IAM/latest/UserGuide/list_amazonstoragegateway.html
 */
class Storagegateway extends shared_1.PolicyStatement {
    /**
     * Action provider for service storagegateway
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/list_amazonstoragegateway.html
     */
    constructor(props) {
        super(props);
        this.servicePrefix = 'storagegateway';
        this.actions = {
            "ActivateGateway": {
                "url": "https://docs.aws.amazon.com/storagegateway/latest/APIReference/API_ActivateGateway.html",
                "description": "This operation activates the gateway you previously deployed on your host.",
                "accessLevel": "Write",
                "conditions": [
                    "aws:RequestTag/${TagKey}",
                    "aws:TagKeys"
                ]
            },
            "AddCache": {
                "url": "https://docs.aws.amazon.com/storagegateway/latest/APIReference/API_AddCache.html",
                "description": "This operation configures one or more gateway local disks as cache for a cached-volume gateway.",
                "accessLevel": "Write",
                "resourceTypes": {
                    "gateway": {
                        "required": true
                    }
                }
            },
            "AddTagsToResource": {
                "url": "https://docs.aws.amazon.com/storagegateway/latest/APIReference/API_AddTagsToResource.html",
                "description": "This operation adds one or more tags to the specified resource.",
                "accessLevel": "Tagging",
                "resourceTypes": {
                    "gateway": {
                        "required": false
                    },
                    "share": {
                        "required": false
                    },
                    "tape": {
                        "required": false
                    },
                    "volume": {
                        "required": false
                    }
                },
                "conditions": [
                    "aws:RequestTag/${TagKey}",
                    "aws:TagKeys"
                ]
            },
            "AddUploadBuffer": {
                "url": "https://docs.aws.amazon.com/storagegateway/latest/APIReference/API_AddUploadBuffer.html",
                "description": "This operation configures one or more gateway local disks as upload buffer for a specified gateway.",
                "accessLevel": "Write",
                "resourceTypes": {
                    "gateway": {
                        "required": true
                    }
                }
            },
            "AddWorkingStorage": {
                "url": "https://docs.aws.amazon.com/storagegateway/latest/APIReference/API_AddWorkingStorage.html",
                "description": "This operation configures one or more gateway local disks as working storage for a gateway.",
                "accessLevel": "Write",
                "resourceTypes": {
                    "gateway": {
                        "required": true
                    }
                }
            },
            "AttachVolume": {
                "url": "https://docs.aws.amazon.com/storagegateway/latest/APIReference/API_AttachVolume.html",
                "description": "This operation connects a volume to an iSCSI connection and then attaches the volume to the specified gateway.",
                "accessLevel": "Write",
                "resourceTypes": {
                    "gateway": {
                        "required": true
                    },
                    "volume": {
                        "required": true
                    }
                }
            },
            "CancelArchival": {
                "url": "https://docs.aws.amazon.com/storagegateway/latest/APIReference/API_CancelArchival.html",
                "description": "Cancels archiving of a virtual tape to the virtual tape shelf (VTS) after the archiving process is initiated.",
                "accessLevel": "Write",
                "resourceTypes": {
                    "gateway": {
                        "required": true
                    },
                    "tape": {
                        "required": true
                    }
                }
            },
            "CancelRetrieval": {
                "url": "https://docs.aws.amazon.com/storagegateway/latest/APIReference/API_CancelRetrieval.html",
                "description": "Cancels retrieval of a virtual tape from the virtual tape shelf (VTS) to a gateway after the retrieval process is initiated.",
                "accessLevel": "Write",
                "resourceTypes": {
                    "gateway": {
                        "required": true
                    },
                    "tape": {
                        "required": true
                    }
                }
            },
            "CreateCachediSCSIVolume": {
                "url": "https://docs.aws.amazon.com/storagegateway/latest/APIReference/API_CreateCachediSCSIVolume.html",
                "description": "This operation creates a cached volume on a specified cached gateway. This operation is supported only for the gateway-cached volume architecture.",
                "accessLevel": "Write",
                "resourceTypes": {
                    "gateway": {
                        "required": true
                    },
                    "volume": {
                        "required": true
                    }
                },
                "conditions": [
                    "aws:RequestTag/${TagKey}",
                    "aws:TagKeys"
                ]
            },
            "CreateNFSFileShare": {
                "url": "https://docs.aws.amazon.com/storagegateway/latest/APIReference/API_CreateNFSFileShare.html",
                "description": "This operation creates a NFS file share on an existing file gateway.",
                "accessLevel": "Write",
                "resourceTypes": {
                    "gateway": {
                        "required": true
                    }
                },
                "conditions": [
                    "aws:RequestTag/${TagKey}",
                    "aws:TagKeys"
                ]
            },
            "CreateSMBFileShare": {
                "url": "https://docs.aws.amazon.com/storagegateway/latest/APIReference/API_CreateSMBFileShare.html",
                "description": "This operation creates a SMB file share on an existing file gateway.",
                "accessLevel": "Write",
                "resourceTypes": {
                    "gateway": {
                        "required": true
                    }
                },
                "conditions": [
                    "aws:RequestTag/${TagKey}",
                    "aws:TagKeys"
                ]
            },
            "CreateSnapshot": {
                "url": "https://docs.aws.amazon.com/storagegateway/latest/APIReference/API_CreateSnapshot.html",
                "description": "This operation initiates a snapshot of a volume.",
                "accessLevel": "Write",
                "resourceTypes": {
                    "volume": {
                        "required": true
                    }
                }
            },
            "CreateSnapshotFromVolumeRecoveryPoint": {
                "url": "https://docs.aws.amazon.com/storagegateway/latest/APIReference/API_CreateSnapshotFromVolumeRecoveryPoint.html",
                "description": "This operation initiates a snapshot of a gateway from a volume recovery point.",
                "accessLevel": "Write",
                "resourceTypes": {
                    "volume": {
                        "required": true
                    }
                }
            },
            "CreateStorediSCSIVolume": {
                "url": "https://docs.aws.amazon.com/storagegateway/latest/APIReference/API_CreateStorediSCSIVolume.html",
                "description": "This operation creates a volume on a specified gateway.",
                "accessLevel": "Write",
                "resourceTypes": {
                    "gateway": {
                        "required": true
                    }
                },
                "conditions": [
                    "aws:RequestTag/${TagKey}",
                    "aws:TagKeys"
                ]
            },
            "CreateTapeWithBarcode": {
                "url": "https://docs.aws.amazon.com/storagegateway/latest/APIReference/API_CreateTapeWithBarcode.html",
                "description": "Creates a virtual tape by using your own barcode.",
                "accessLevel": "Write",
                "resourceTypes": {
                    "gateway": {
                        "required": true
                    }
                },
                "conditions": [
                    "aws:RequestTag/${TagKey}",
                    "aws:TagKeys"
                ]
            },
            "CreateTapes": {
                "url": "https://docs.aws.amazon.com/storagegateway/latest/APIReference/API_CreateTapes.html",
                "description": "Creates one or more virtual tapes. You write data to the virtual tapes and then archive the tapes.",
                "accessLevel": "Write",
                "resourceTypes": {
                    "gateway": {
                        "required": true
                    }
                },
                "conditions": [
                    "aws:RequestTag/${TagKey}",
                    "aws:TagKeys"
                ]
            },
            "DeleteBandwidthRateLimit": {
                "url": "https://docs.aws.amazon.com/storagegateway/latest/APIReference/API_DeleteBandwidthRateLimit.html",
                "description": "This operation deletes the bandwidth rate limits of a gateway.",
                "accessLevel": "Write",
                "resourceTypes": {
                    "gateway": {
                        "required": true
                    }
                }
            },
            "DeleteChapCredentials": {
                "url": "https://docs.aws.amazon.com/storagegateway/latest/APIReference/API_DeleteChapCredentials.html",
                "description": "This operation deletes Challenge-Handshake Authentication Protocol (CHAP) credentials for a specified iSCSI target and initiator pair.",
                "accessLevel": "Write",
                "resourceTypes": {
                    "target": {
                        "required": true
                    }
                }
            },
            "DeleteFileShare": {
                "url": "https://docs.aws.amazon.com/storagegateway/latest/APIReference/API_DeleteFileShare.html",
                "description": "This operation deletes a file share from a file gateway.",
                "accessLevel": "Write",
                "resourceTypes": {
                    "share": {
                        "required": true
                    }
                }
            },
            "DeleteGateway": {
                "url": "https://docs.aws.amazon.com/storagegateway/latest/APIReference/API_DeleteGateway.html",
                "description": "This operation deletes a gateway.",
                "accessLevel": "Write",
                "resourceTypes": {
                    "gateway": {
                        "required": true
                    }
                }
            },
            "DeleteSnapshotSchedule": {
                "url": "https://docs.aws.amazon.com/storagegateway/latest/APIReference/API_DeleteSnapshotSchedule.html",
                "description": "This operation deletes a snapshot of a volume.",
                "accessLevel": "Write",
                "resourceTypes": {
                    "volume": {
                        "required": true
                    }
                }
            },
            "DeleteTape": {
                "url": "https://docs.aws.amazon.com/storagegateway/latest/APIReference/API_DeleteTape.html",
                "description": "Deletes the specified virtual tape.",
                "accessLevel": "Write",
                "resourceTypes": {
                    "gateway": {
                        "required": true
                    },
                    "tape": {
                        "required": true
                    }
                }
            },
            "DeleteTapeArchive": {
                "url": "https://docs.aws.amazon.com/storagegateway/latest/APIReference/API_DeleteTapeArchive.html",
                "description": "Deletes the specified virtual tape from the virtual tape shelf (VTS).",
                "accessLevel": "Write"
            },
            "DeleteVolume": {
                "url": "https://docs.aws.amazon.com/storagegateway/latest/APIReference/API_DeleteVolume.html",
                "description": "This operation deletes the specified gateway volume that you previously created using the CreateCachediSCSIVolume or CreateStorediSCSIVolume API.",
                "accessLevel": "Write",
                "resourceTypes": {
                    "volume": {
                        "required": true
                    }
                }
            },
            "DescribeBandwidthRateLimit": {
                "url": "https://docs.aws.amazon.com/storagegateway/latest/APIReference/API_DescribeBandwidthRateLimit.html",
                "description": "This operation returns the bandwidth rate limits of a gateway.",
                "accessLevel": "Read",
                "resourceTypes": {
                    "gateway": {
                        "required": true
                    }
                }
            },
            "DescribeCache": {
                "url": "https://docs.aws.amazon.com/storagegateway/latest/APIReference/API_DescribeCache.html",
                "description": "This operation returns information about the cache of a gateway. This operation is supported only for the gateway-cached volume architecture.",
                "accessLevel": "Read",
                "resourceTypes": {
                    "gateway": {
                        "required": true
                    }
                }
            },
            "DescribeCachediSCSIVolumes": {
                "url": "https://docs.aws.amazon.com/storagegateway/latest/APIReference/API_DescribeCachediSCSIVolumes.html",
                "description": "This operation returns a description of the gateway volumes specified in the request. This operation is supported only for the gateway-cached volume architecture.",
                "accessLevel": "Read",
                "resourceTypes": {
                    "volume": {
                        "required": true
                    }
                }
            },
            "DescribeChapCredentials": {
                "url": "https://docs.aws.amazon.com/storagegateway/latest/APIReference/API_DescribeChapCredentials.html",
                "description": "This operation returns an array of Challenge-Handshake Authentication Protocol (CHAP) credentials information for a specified iSCSI target, one for each target-initiator pair.",
                "accessLevel": "Read",
                "resourceTypes": {
                    "target": {
                        "required": true
                    }
                }
            },
            "DescribeGatewayInformation": {
                "url": "https://docs.aws.amazon.com/storagegateway/latest/APIReference/API_DescribeGatewayInformation.html",
                "description": "This operation returns metadata about a gateway such as its name, network interfaces, configured time zone, and the state (whether the gateway is running or not).",
                "accessLevel": "Read",
                "resourceTypes": {
                    "gateway": {
                        "required": true
                    }
                }
            },
            "DescribeMaintenanceStartTime": {
                "url": "https://docs.aws.amazon.com/storagegateway/latest/APIReference/API_DescribeMaintenanceStartTime.html",
                "description": "This operation returns your gateway's weekly maintenance start time including the day and time of the week.",
                "accessLevel": "Read",
                "resourceTypes": {
                    "gateway": {
                        "required": true
                    }
                }
            },
            "DescribeNFSFileShares": {
                "url": "https://docs.aws.amazon.com/storagegateway/latest/APIReference/API_DescribeNFSFileShares.html",
                "description": "This operation gets a description for one or more file shares from a file gateway.",
                "accessLevel": "Read",
                "resourceTypes": {
                    "share": {
                        "required": true
                    }
                }
            },
            "DescribeSMBFileShares": {
                "url": "https://docs.aws.amazon.com/storagegateway/latest/APIReference/API_DescribeSMBFileShares.html",
                "description": "This operation gets a description for one or more file shares from a file gateway.",
                "accessLevel": "Read",
                "resourceTypes": {
                    "share": {
                        "required": true
                    }
                }
            },
            "DescribeSMBSettings": {
                "url": "https://docs.aws.amazon.com/storagegateway/latest/APIReference/API_DescribeSMBSettings.html",
                "description": "This operation gets a description of a Server Message Block (SMB) file share settings from a file gateway.",
                "accessLevel": "Read",
                "resourceTypes": {
                    "gateway": {
                        "required": true
                    }
                }
            },
            "DescribeSnapshotSchedule": {
                "url": "https://docs.aws.amazon.com/storagegateway/latest/APIReference/API_DescribeSnapshotSchedule.html",
                "description": "This operation describes the snapshot schedule for the specified gateway volume.",
                "accessLevel": "Read",
                "resourceTypes": {
                    "volume": {
                        "required": true
                    }
                }
            },
            "DescribeStorediSCSIVolumes": {
                "url": "https://docs.aws.amazon.com/storagegateway/latest/APIReference/API_DescribeStorediSCSIVolumes.html",
                "description": "This operation returns the description of the gateway volumes specified in the request.",
                "accessLevel": "Read",
                "resourceTypes": {
                    "volume": {
                        "required": true
                    }
                }
            },
            "DescribeTapeArchives": {
                "url": "https://docs.aws.amazon.com/storagegateway/latest/APIReference/API_DescribeTapeArchives.html",
                "description": "Returns a description of specified virtual tapes in the virtual tape shelf (VTS).",
                "accessLevel": "Read"
            },
            "DescribeTapeRecoveryPoints": {
                "url": "https://docs.aws.amazon.com/storagegateway/latest/APIReference/API_DescribeTapeRecoveryPoints.html",
                "description": "Returns a list of virtual tape recovery points that are available for the specified gateway-VTL.",
                "accessLevel": "Read",
                "resourceTypes": {
                    "gateway": {
                        "required": true
                    }
                }
            },
            "DescribeTapes": {
                "url": "https://docs.aws.amazon.com/storagegateway/latest/APIReference/API_DescribeTapes.html",
                "description": "Returns a description of the specified Amazon Resource Name (ARN) of virtual tapes.",
                "accessLevel": "Read",
                "resourceTypes": {
                    "gateway": {
                        "required": true
                    }
                }
            },
            "DescribeUploadBuffer": {
                "url": "https://docs.aws.amazon.com/storagegateway/latest/APIReference/API_DescribeUploadBuffer.html",
                "description": "This operation returns information about the upload buffer of a gateway.",
                "accessLevel": "Read",
                "resourceTypes": {
                    "gateway": {
                        "required": true
                    }
                }
            },
            "DescribeVTLDevices": {
                "url": "https://docs.aws.amazon.com/storagegateway/latest/APIReference/API_DescribeVTLDevices.html",
                "description": "Returns a description of virtual tape library (VTL) devices for the specified gateway.",
                "accessLevel": "Read",
                "resourceTypes": {
                    "gateway": {
                        "required": true
                    }
                }
            },
            "DescribeWorkingStorage": {
                "url": "https://docs.aws.amazon.com/storagegateway/latest/APIReference/API_DescribeWorkingStorage.html",
                "description": "This operation returns information about the working storage of a gateway.",
                "accessLevel": "Read",
                "resourceTypes": {
                    "gateway": {
                        "required": true
                    }
                }
            },
            "DetachVolume": {
                "url": "https://docs.aws.amazon.com/storagegateway/latest/APIReference/API_DetachVolume.html",
                "description": "This operation disconnects a volume from an iSCSI connection and then detaches the volume from the specified gateway.",
                "accessLevel": "Write",
                "resourceTypes": {
                    "volume": {
                        "required": true
                    }
                }
            },
            "DisableGateway": {
                "url": "https://docs.aws.amazon.com/storagegateway/latest/APIReference/API_DisableGateway.html",
                "description": "Disables a gateway when the gateway is no longer functioning.",
                "accessLevel": "Write",
                "resourceTypes": {
                    "gateway": {
                        "required": true
                    }
                }
            },
            "JoinDomain": {
                "url": "https://docs.aws.amazon.com/storagegateway/latest/APIReference/API_JoinDomain.html",
                "description": "This operation enables you to join an Active Directory Domain.",
                "accessLevel": "Write",
                "resourceTypes": {
                    "gateway": {
                        "required": true
                    }
                }
            },
            "ListFileShares": {
                "url": "https://docs.aws.amazon.com/storagegateway/latest/APIReference/API_ListFileShares.html",
                "description": "This operation gets a list of the file shares for a specific file gateway, or the list of file shares that belong to the calling user account.",
                "accessLevel": "List",
                "resourceTypes": {
                    "gateway": {
                        "required": true
                    }
                }
            },
            "ListGateways": {
                "url": "https://docs.aws.amazon.com/storagegateway/latest/APIReference/API_ListGateways.html",
                "description": "This operation lists gateways owned by an AWS account in a region specified in the request. The returned list is ordered by gateway Amazon Resource Name (ARN).",
                "accessLevel": "List"
            },
            "ListLocalDisks": {
                "url": "https://docs.aws.amazon.com/storagegateway/latest/APIReference/API_ListLocalDisks.html",
                "description": "This operation returns a list of the gateway's local disks.",
                "accessLevel": "List",
                "resourceTypes": {
                    "gateway": {
                        "required": true
                    }
                }
            },
            "ListTagsForResource": {
                "url": "https://docs.aws.amazon.com/storagegateway/latest/APIReference/API_ListTagsForResource.html",
                "description": "This operation lists the tags that have been added to the specified resource.",
                "accessLevel": "Read",
                "resourceTypes": {
                    "gateway": {
                        "required": false
                    },
                    "share": {
                        "required": false
                    },
                    "tape": {
                        "required": false
                    },
                    "volume": {
                        "required": false
                    }
                }
            },
            "ListTapes": {
                "url": "https://docs.aws.amazon.com/storagegateway/latest/APIReference/API_ListTapes.html",
                "description": "Lists virtual tapes in your virtual tape library (VTL) and your virtual tape shelf (VTS).",
                "accessLevel": "Read",
                "resourceTypes": {
                    "tape": {
                        "required": true
                    }
                }
            },
            "ListVolumeInitiators": {
                "url": "https://docs.aws.amazon.com/storagegateway/latest/APIReference/API_ListVolumeInitiators.html",
                "description": "This operation lists iSCSI initiators that are connected to a volume.",
                "accessLevel": "Read",
                "resourceTypes": {
                    "volume": {
                        "required": true
                    }
                }
            },
            "ListVolumeRecoveryPoints": {
                "url": "https://docs.aws.amazon.com/storagegateway/latest/APIReference/API_ListVolumeRecoveryPoints.html",
                "description": "This operation lists the recovery points for a specified gateway.",
                "accessLevel": "List",
                "resourceTypes": {
                    "gateway": {
                        "required": true
                    }
                }
            },
            "ListVolumes": {
                "url": "https://docs.aws.amazon.com/storagegateway/latest/APIReference/API_ListVolumes.html",
                "description": "This operation lists the iSCSI stored volumes of a gateway.",
                "accessLevel": "List",
                "resourceTypes": {
                    "gateway": {
                        "required": true
                    }
                }
            },
            "NotifyWhenUploaded": {
                "url": "https://docs.aws.amazon.com/storagegateway/latest/APIReference/API_NotifyWhenUploaded.html",
                "description": "This action sends you a notification through CloudWatch Events when all files written to your NFS file share have been uploaded to Amazon S3.",
                "accessLevel": "Write",
                "resourceTypes": {
                    "share": {
                        "required": true
                    }
                }
            },
            "RefreshCache": {
                "url": "https://docs.aws.amazon.com/storagegateway/latest/APIReference/API_RefreshCache.html",
                "description": "This operation refreshes the cache for the specified file share.",
                "accessLevel": "Write",
                "resourceTypes": {
                    "share": {
                        "required": true
                    }
                }
            },
            "RemoveTagsFromResource": {
                "url": "https://docs.aws.amazon.com/storagegateway/latest/APIReference/API_RemoveTagsFromResource.html",
                "description": "This operation removes one or more tags from the specified resource.",
                "accessLevel": "Tagging",
                "resourceTypes": {
                    "gateway": {
                        "required": false
                    },
                    "share": {
                        "required": false
                    },
                    "tape": {
                        "required": false
                    },
                    "volume": {
                        "required": false
                    }
                },
                "conditions": [
                    "aws:TagKeys"
                ]
            },
            "ResetCache": {
                "url": "https://docs.aws.amazon.com/storagegateway/latest/APIReference/API_ResetCache.html",
                "description": "This operation resets all cache disks that have encountered a error and makes the disks available for reconfiguration as cache storage.",
                "accessLevel": "Write",
                "resourceTypes": {
                    "gateway": {
                        "required": true
                    }
                }
            },
            "RetrieveTapeArchive": {
                "url": "https://docs.aws.amazon.com/storagegateway/latest/APIReference/API_RetrieveTapeArchive.html",
                "description": "Retrieves an archived virtual tape from the virtual tape shelf (VTS) to a gateway-VTL.",
                "accessLevel": "Write",
                "resourceTypes": {
                    "gateway": {
                        "required": true
                    },
                    "tape": {
                        "required": true
                    }
                }
            },
            "RetrieveTapeRecoveryPoint": {
                "url": "https://docs.aws.amazon.com/storagegateway/latest/APIReference/API_RetrieveTapeRecoveryPoint.html",
                "description": "Retrieves the recovery point for the specified virtual tape.",
                "accessLevel": "Write",
                "resourceTypes": {
                    "gateway": {
                        "required": true
                    },
                    "tape": {
                        "required": true
                    }
                }
            },
            "SetLocalConsolePassword": {
                "url": "https://docs.aws.amazon.com/storagegateway/latest/APIReference/API_SetLocalConsolePassword.html",
                "description": "Sets the password for your VM local console.",
                "accessLevel": "Write",
                "resourceTypes": {
                    "gateway": {
                        "required": true
                    }
                }
            },
            "SetSMBGuestPassword": {
                "url": "https://docs.aws.amazon.com/storagegateway/latest/APIReference/API_SetSMBGuestPassword.html",
                "description": "Sets the password for SMB Guest user.",
                "accessLevel": "Write",
                "resourceTypes": {
                    "gateway": {
                        "required": true
                    }
                }
            },
            "ShutdownGateway": {
                "url": "https://docs.aws.amazon.com/storagegateway/latest/APIReference/API_ShutdownGateway.html",
                "description": "This operation shuts down a gateway.",
                "accessLevel": "Write",
                "resourceTypes": {
                    "gateway": {
                        "required": true
                    }
                }
            },
            "StartGateway": {
                "url": "https://docs.aws.amazon.com/storagegateway/latest/APIReference/API_StartGateway.html",
                "description": "This operation starts a gateway that you previously shut down.",
                "accessLevel": "Write",
                "resourceTypes": {
                    "gateway": {
                        "required": true
                    }
                }
            },
            "UpdateBandwidthRateLimit": {
                "url": "https://docs.aws.amazon.com/storagegateway/latest/APIReference/API_UpdateBandwidthRateLimit.html",
                "description": "This operation updates the bandwidth rate limits of a gateway.",
                "accessLevel": "Write",
                "resourceTypes": {
                    "gateway": {
                        "required": true
                    }
                }
            },
            "UpdateChapCredentials": {
                "url": "https://docs.aws.amazon.com/storagegateway/latest/APIReference/API_UpdateChapCredentials.html",
                "description": "This operation updates the Challenge-Handshake Authentication Protocol (CHAP) credentials for a specified iSCSI target.",
                "accessLevel": "Write",
                "resourceTypes": {
                    "target": {
                        "required": true
                    }
                }
            },
            "UpdateGatewayInformation": {
                "url": "https://docs.aws.amazon.com/storagegateway/latest/APIReference/API_UpdateGatewayInformation.html",
                "description": "This operation updates a gateway's metadata, which includes the gateway's name and time zone.",
                "accessLevel": "Write",
                "resourceTypes": {
                    "gateway": {
                        "required": true
                    }
                }
            },
            "UpdateGatewaySoftwareNow": {
                "url": "https://docs.aws.amazon.com/storagegateway/latest/APIReference/API_UpdateGatewaySoftwareNow.html",
                "description": "This operation updates the gateway virtual machine (VM) software.",
                "accessLevel": "Write",
                "resourceTypes": {
                    "gateway": {
                        "required": true
                    }
                }
            },
            "UpdateMaintenanceStartTime": {
                "url": "https://docs.aws.amazon.com/storagegateway/latest/APIReference/API_UpdateMaintenanceStartTime.html",
                "description": "This operation updates a gateway's weekly maintenance start time information, including day and time of the week. The maintenance time is the time in your gateway's time zone.",
                "accessLevel": "Write",
                "resourceTypes": {
                    "gateway": {
                        "required": true
                    }
                }
            },
            "UpdateNFSFileShare": {
                "url": "https://docs.aws.amazon.com/storagegateway/latest/APIReference/API_UpdateNFSFileShare.html",
                "description": "This operation updates a NFS file share.",
                "accessLevel": "Write",
                "resourceTypes": {
                    "share": {
                        "required": true
                    }
                }
            },
            "UpdateSMBFileShare": {
                "url": "https://docs.aws.amazon.com/storagegateway/latest/APIReference/API_UpdateSMBFileShare.html",
                "description": "This operation updates a SMB file share.",
                "accessLevel": "Write",
                "resourceTypes": {
                    "share": {
                        "required": true
                    }
                }
            },
            "UpdateSnapshotSchedule": {
                "url": "https://docs.aws.amazon.com/storagegateway/latest/APIReference/API_UpdateSnapshotSchedule.html",
                "description": "This operation updates a snapshot schedule configured for a gateway volume.",
                "accessLevel": "Write",
                "resourceTypes": {
                    "volume": {
                        "required": true
                    }
                }
            },
            "UpdateVTLDeviceType": {
                "url": "https://docs.aws.amazon.com/storagegateway/latest/APIReference/API_UpdateVTLDeviceType.html",
                "description": "This operation updates the type of medium changer in a gateway-VTL.",
                "accessLevel": "Write",
                "resourceTypes": {
                    "device": {
                        "required": true
                    }
                }
            }
        };
        this.resourceTypes = {
            "device": {
                "name": "device",
                "url": "https://docs.aws.amazon.com/storagegateway/latest/userguide/resource_vtl-devices.html",
                "arn": "arn:${Partition}:storagegateway:${Region}:${Account}:gateway/${GatewayId}/device/${Vtldevice}",
                "conditionKeys": []
            },
            "gateway": {
                "name": "gateway",
                "url": "https://docs.aws.amazon.com/storagegateway/latest/userguide/StorageGatewayConcepts.html",
                "arn": "arn:${Partition}:storagegateway:${Region}:${Account}:gateway/${GatewayId}",
                "conditionKeys": [
                    "aws:ResourceTag/${TagKey}"
                ]
            },
            "share": {
                "name": "share",
                "url": "https://docs.aws.amazon.com/storagegateway/latest/userguide/GettingStartedCreateFileShare.html",
                "arn": "arn:${Partition}:storagegateway:${Region}:${Account}:share/${ShareId}",
                "conditionKeys": [
                    "aws:ResourceTag/${TagKey}"
                ]
            },
            "tape": {
                "name": "tape",
                "url": "https://docs.aws.amazon.com/storagegateway/latest/userguide/StorageGatewayConcepts.html#storage-gateway-vtl-concepts",
                "arn": "arn:${Partition}:storagegateway:${Region}:${Account}:tape/${TapeBarcode}",
                "conditionKeys": [
                    "aws:ResourceTag/${TagKey}"
                ]
            },
            "target": {
                "name": "target",
                "url": "https://docs.aws.amazon.com/storagegateway/latest/userguide/GettingStartedCreateVolumes.html",
                "arn": "arn:${Partition}:storagegateway:${Region}:${Account}:gateway/${GatewayId}/target/${IscsiTarget}",
                "conditionKeys": []
            },
            "volume": {
                "name": "volume",
                "url": "https://docs.aws.amazon.com/storagegateway/latest/userguide/StorageGatewayConcepts.html#volume-gateway-concepts",
                "arn": "arn:${Partition}:storagegateway:${Region}:${Account}:gateway/${GatewayId}/volume/${VolumeId}",
                "conditionKeys": [
                    "aws:ResourceTag/${TagKey}"
                ]
            }
        };
    }
    /**
     * This operation activates the gateway you previously deployed on your host.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/storagegateway/latest/APIReference/API_ActivateGateway.html
     */
    activateGateway() {
        this.add('storagegateway:ActivateGateway');
        return this;
    }
    /**
     * This operation configures one or more gateway local disks as cache for a cached-volume gateway.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/storagegateway/latest/APIReference/API_AddCache.html
     */
    addCache() {
        this.add('storagegateway:AddCache');
        return this;
    }
    /**
     * This operation adds one or more tags to the specified resource.
     *
     * Access Level: Tagging
     *
     * https://docs.aws.amazon.com/storagegateway/latest/APIReference/API_AddTagsToResource.html
     */
    addTagsToResource() {
        this.add('storagegateway:AddTagsToResource');
        return this;
    }
    /**
     * This operation configures one or more gateway local disks as upload buffer for a specified gateway.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/storagegateway/latest/APIReference/API_AddUploadBuffer.html
     */
    addUploadBuffer() {
        this.add('storagegateway:AddUploadBuffer');
        return this;
    }
    /**
     * This operation configures one or more gateway local disks as working storage for a gateway.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/storagegateway/latest/APIReference/API_AddWorkingStorage.html
     */
    addWorkingStorage() {
        this.add('storagegateway:AddWorkingStorage');
        return this;
    }
    /**
     * This operation connects a volume to an iSCSI connection and then attaches the volume to the specified gateway.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/storagegateway/latest/APIReference/API_AttachVolume.html
     */
    attachVolume() {
        this.add('storagegateway:AttachVolume');
        return this;
    }
    /**
     * Cancels archiving of a virtual tape to the virtual tape shelf (VTS) after the archiving process is initiated.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/storagegateway/latest/APIReference/API_CancelArchival.html
     */
    cancelArchival() {
        this.add('storagegateway:CancelArchival');
        return this;
    }
    /**
     * Cancels retrieval of a virtual tape from the virtual tape shelf (VTS) to a gateway after the retrieval process is initiated.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/storagegateway/latest/APIReference/API_CancelRetrieval.html
     */
    cancelRetrieval() {
        this.add('storagegateway:CancelRetrieval');
        return this;
    }
    /**
     * This operation creates a cached volume on a specified cached gateway. This operation is supported only for the gateway-cached volume architecture.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/storagegateway/latest/APIReference/API_CreateCachediSCSIVolume.html
     */
    createCachediSCSIVolume() {
        this.add('storagegateway:CreateCachediSCSIVolume');
        return this;
    }
    /**
     * This operation creates a NFS file share on an existing file gateway.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/storagegateway/latest/APIReference/API_CreateNFSFileShare.html
     */
    createNFSFileShare() {
        this.add('storagegateway:CreateNFSFileShare');
        return this;
    }
    /**
     * This operation creates a SMB file share on an existing file gateway.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/storagegateway/latest/APIReference/API_CreateSMBFileShare.html
     */
    createSMBFileShare() {
        this.add('storagegateway:CreateSMBFileShare');
        return this;
    }
    /**
     * This operation initiates a snapshot of a volume.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/storagegateway/latest/APIReference/API_CreateSnapshot.html
     */
    createSnapshot() {
        this.add('storagegateway:CreateSnapshot');
        return this;
    }
    /**
     * This operation initiates a snapshot of a gateway from a volume recovery point.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/storagegateway/latest/APIReference/API_CreateSnapshotFromVolumeRecoveryPoint.html
     */
    createSnapshotFromVolumeRecoveryPoint() {
        this.add('storagegateway:CreateSnapshotFromVolumeRecoveryPoint');
        return this;
    }
    /**
     * This operation creates a volume on a specified gateway.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/storagegateway/latest/APIReference/API_CreateStorediSCSIVolume.html
     */
    createStorediSCSIVolume() {
        this.add('storagegateway:CreateStorediSCSIVolume');
        return this;
    }
    /**
     * Creates a virtual tape by using your own barcode.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/storagegateway/latest/APIReference/API_CreateTapeWithBarcode.html
     */
    createTapeWithBarcode() {
        this.add('storagegateway:CreateTapeWithBarcode');
        return this;
    }
    /**
     * Creates one or more virtual tapes. You write data to the virtual tapes and then archive the tapes.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/storagegateway/latest/APIReference/API_CreateTapes.html
     */
    createTapes() {
        this.add('storagegateway:CreateTapes');
        return this;
    }
    /**
     * This operation deletes the bandwidth rate limits of a gateway.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/storagegateway/latest/APIReference/API_DeleteBandwidthRateLimit.html
     */
    deleteBandwidthRateLimit() {
        this.add('storagegateway:DeleteBandwidthRateLimit');
        return this;
    }
    /**
     * This operation deletes Challenge-Handshake Authentication Protocol (CHAP) credentials for a specified iSCSI target and initiator pair.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/storagegateway/latest/APIReference/API_DeleteChapCredentials.html
     */
    deleteChapCredentials() {
        this.add('storagegateway:DeleteChapCredentials');
        return this;
    }
    /**
     * This operation deletes a file share from a file gateway.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/storagegateway/latest/APIReference/API_DeleteFileShare.html
     */
    deleteFileShare() {
        this.add('storagegateway:DeleteFileShare');
        return this;
    }
    /**
     * This operation deletes a gateway.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/storagegateway/latest/APIReference/API_DeleteGateway.html
     */
    deleteGateway() {
        this.add('storagegateway:DeleteGateway');
        return this;
    }
    /**
     * This operation deletes a snapshot of a volume.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/storagegateway/latest/APIReference/API_DeleteSnapshotSchedule.html
     */
    deleteSnapshotSchedule() {
        this.add('storagegateway:DeleteSnapshotSchedule');
        return this;
    }
    /**
     * Deletes the specified virtual tape.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/storagegateway/latest/APIReference/API_DeleteTape.html
     */
    deleteTape() {
        this.add('storagegateway:DeleteTape');
        return this;
    }
    /**
     * Deletes the specified virtual tape from the virtual tape shelf (VTS).
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/storagegateway/latest/APIReference/API_DeleteTapeArchive.html
     */
    deleteTapeArchive() {
        this.add('storagegateway:DeleteTapeArchive');
        return this;
    }
    /**
     * This operation deletes the specified gateway volume that you previously created using the CreateCachediSCSIVolume or CreateStorediSCSIVolume API.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/storagegateway/latest/APIReference/API_DeleteVolume.html
     */
    deleteVolume() {
        this.add('storagegateway:DeleteVolume');
        return this;
    }
    /**
     * This operation returns the bandwidth rate limits of a gateway.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/storagegateway/latest/APIReference/API_DescribeBandwidthRateLimit.html
     */
    describeBandwidthRateLimit() {
        this.add('storagegateway:DescribeBandwidthRateLimit');
        return this;
    }
    /**
     * This operation returns information about the cache of a gateway. This operation is supported only for the gateway-cached volume architecture.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/storagegateway/latest/APIReference/API_DescribeCache.html
     */
    describeCache() {
        this.add('storagegateway:DescribeCache');
        return this;
    }
    /**
     * This operation returns a description of the gateway volumes specified in the request. This operation is supported only for the gateway-cached volume architecture.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/storagegateway/latest/APIReference/API_DescribeCachediSCSIVolumes.html
     */
    describeCachediSCSIVolumes() {
        this.add('storagegateway:DescribeCachediSCSIVolumes');
        return this;
    }
    /**
     * This operation returns an array of Challenge-Handshake Authentication Protocol (CHAP) credentials information for a specified iSCSI target, one for each target-initiator pair.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/storagegateway/latest/APIReference/API_DescribeChapCredentials.html
     */
    describeChapCredentials() {
        this.add('storagegateway:DescribeChapCredentials');
        return this;
    }
    /**
     * This operation returns metadata about a gateway such as its name, network interfaces, configured time zone, and the state (whether the gateway is running or not).
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/storagegateway/latest/APIReference/API_DescribeGatewayInformation.html
     */
    describeGatewayInformation() {
        this.add('storagegateway:DescribeGatewayInformation');
        return this;
    }
    /**
     * This operation returns your gateway's weekly maintenance start time including the day and time of the week.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/storagegateway/latest/APIReference/API_DescribeMaintenanceStartTime.html
     */
    describeMaintenanceStartTime() {
        this.add('storagegateway:DescribeMaintenanceStartTime');
        return this;
    }
    /**
     * This operation gets a description for one or more file shares from a file gateway.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/storagegateway/latest/APIReference/API_DescribeNFSFileShares.html
     */
    describeNFSFileShares() {
        this.add('storagegateway:DescribeNFSFileShares');
        return this;
    }
    /**
     * This operation gets a description for one or more file shares from a file gateway.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/storagegateway/latest/APIReference/API_DescribeSMBFileShares.html
     */
    describeSMBFileShares() {
        this.add('storagegateway:DescribeSMBFileShares');
        return this;
    }
    /**
     * This operation gets a description of a Server Message Block (SMB) file share settings from a file gateway.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/storagegateway/latest/APIReference/API_DescribeSMBSettings.html
     */
    describeSMBSettings() {
        this.add('storagegateway:DescribeSMBSettings');
        return this;
    }
    /**
     * This operation describes the snapshot schedule for the specified gateway volume.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/storagegateway/latest/APIReference/API_DescribeSnapshotSchedule.html
     */
    describeSnapshotSchedule() {
        this.add('storagegateway:DescribeSnapshotSchedule');
        return this;
    }
    /**
     * This operation returns the description of the gateway volumes specified in the request.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/storagegateway/latest/APIReference/API_DescribeStorediSCSIVolumes.html
     */
    describeStorediSCSIVolumes() {
        this.add('storagegateway:DescribeStorediSCSIVolumes');
        return this;
    }
    /**
     * Returns a description of specified virtual tapes in the virtual tape shelf (VTS).
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/storagegateway/latest/APIReference/API_DescribeTapeArchives.html
     */
    describeTapeArchives() {
        this.add('storagegateway:DescribeTapeArchives');
        return this;
    }
    /**
     * Returns a list of virtual tape recovery points that are available for the specified gateway-VTL.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/storagegateway/latest/APIReference/API_DescribeTapeRecoveryPoints.html
     */
    describeTapeRecoveryPoints() {
        this.add('storagegateway:DescribeTapeRecoveryPoints');
        return this;
    }
    /**
     * Returns a description of the specified Amazon Resource Name (ARN) of virtual tapes.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/storagegateway/latest/APIReference/API_DescribeTapes.html
     */
    describeTapes() {
        this.add('storagegateway:DescribeTapes');
        return this;
    }
    /**
     * This operation returns information about the upload buffer of a gateway.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/storagegateway/latest/APIReference/API_DescribeUploadBuffer.html
     */
    describeUploadBuffer() {
        this.add('storagegateway:DescribeUploadBuffer');
        return this;
    }
    /**
     * Returns a description of virtual tape library (VTL) devices for the specified gateway.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/storagegateway/latest/APIReference/API_DescribeVTLDevices.html
     */
    describeVTLDevices() {
        this.add('storagegateway:DescribeVTLDevices');
        return this;
    }
    /**
     * This operation returns information about the working storage of a gateway.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/storagegateway/latest/APIReference/API_DescribeWorkingStorage.html
     */
    describeWorkingStorage() {
        this.add('storagegateway:DescribeWorkingStorage');
        return this;
    }
    /**
     * This operation disconnects a volume from an iSCSI connection and then detaches the volume from the specified gateway.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/storagegateway/latest/APIReference/API_DetachVolume.html
     */
    detachVolume() {
        this.add('storagegateway:DetachVolume');
        return this;
    }
    /**
     * Disables a gateway when the gateway is no longer functioning.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/storagegateway/latest/APIReference/API_DisableGateway.html
     */
    disableGateway() {
        this.add('storagegateway:DisableGateway');
        return this;
    }
    /**
     * This operation enables you to join an Active Directory Domain.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/storagegateway/latest/APIReference/API_JoinDomain.html
     */
    joinDomain() {
        this.add('storagegateway:JoinDomain');
        return this;
    }
    /**
     * This operation gets a list of the file shares for a specific file gateway, or the list of file shares that belong to the calling user account.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/storagegateway/latest/APIReference/API_ListFileShares.html
     */
    listFileShares() {
        this.add('storagegateway:ListFileShares');
        return this;
    }
    /**
     * This operation lists gateways owned by an AWS account in a region specified in the request. The returned list is ordered by gateway Amazon Resource Name (ARN).
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/storagegateway/latest/APIReference/API_ListGateways.html
     */
    listGateways() {
        this.add('storagegateway:ListGateways');
        return this;
    }
    /**
     * This operation returns a list of the gateway's local disks.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/storagegateway/latest/APIReference/API_ListLocalDisks.html
     */
    listLocalDisks() {
        this.add('storagegateway:ListLocalDisks');
        return this;
    }
    /**
     * This operation lists the tags that have been added to the specified resource.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/storagegateway/latest/APIReference/API_ListTagsForResource.html
     */
    listTagsForResource() {
        this.add('storagegateway:ListTagsForResource');
        return this;
    }
    /**
     * Lists virtual tapes in your virtual tape library (VTL) and your virtual tape shelf (VTS).
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/storagegateway/latest/APIReference/API_ListTapes.html
     */
    listTapes() {
        this.add('storagegateway:ListTapes');
        return this;
    }
    /**
     * This operation lists iSCSI initiators that are connected to a volume.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/storagegateway/latest/APIReference/API_ListVolumeInitiators.html
     */
    listVolumeInitiators() {
        this.add('storagegateway:ListVolumeInitiators');
        return this;
    }
    /**
     * This operation lists the recovery points for a specified gateway.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/storagegateway/latest/APIReference/API_ListVolumeRecoveryPoints.html
     */
    listVolumeRecoveryPoints() {
        this.add('storagegateway:ListVolumeRecoveryPoints');
        return this;
    }
    /**
     * This operation lists the iSCSI stored volumes of a gateway.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/storagegateway/latest/APIReference/API_ListVolumes.html
     */
    listVolumes() {
        this.add('storagegateway:ListVolumes');
        return this;
    }
    /**
     * This action sends you a notification through CloudWatch Events when all files written to your NFS file share have been uploaded to Amazon S3.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/storagegateway/latest/APIReference/API_NotifyWhenUploaded.html
     */
    notifyWhenUploaded() {
        this.add('storagegateway:NotifyWhenUploaded');
        return this;
    }
    /**
     * This operation refreshes the cache for the specified file share.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/storagegateway/latest/APIReference/API_RefreshCache.html
     */
    refreshCache() {
        this.add('storagegateway:RefreshCache');
        return this;
    }
    /**
     * This operation removes one or more tags from the specified resource.
     *
     * Access Level: Tagging
     *
     * https://docs.aws.amazon.com/storagegateway/latest/APIReference/API_RemoveTagsFromResource.html
     */
    removeTagsFromResource() {
        this.add('storagegateway:RemoveTagsFromResource');
        return this;
    }
    /**
     * This operation resets all cache disks that have encountered a error and makes the disks available for reconfiguration as cache storage.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/storagegateway/latest/APIReference/API_ResetCache.html
     */
    resetCache() {
        this.add('storagegateway:ResetCache');
        return this;
    }
    /**
     * Retrieves an archived virtual tape from the virtual tape shelf (VTS) to a gateway-VTL.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/storagegateway/latest/APIReference/API_RetrieveTapeArchive.html
     */
    retrieveTapeArchive() {
        this.add('storagegateway:RetrieveTapeArchive');
        return this;
    }
    /**
     * Retrieves the recovery point for the specified virtual tape.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/storagegateway/latest/APIReference/API_RetrieveTapeRecoveryPoint.html
     */
    retrieveTapeRecoveryPoint() {
        this.add('storagegateway:RetrieveTapeRecoveryPoint');
        return this;
    }
    /**
     * Sets the password for your VM local console.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/storagegateway/latest/APIReference/API_SetLocalConsolePassword.html
     */
    setLocalConsolePassword() {
        this.add('storagegateway:SetLocalConsolePassword');
        return this;
    }
    /**
     * Sets the password for SMB Guest user.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/storagegateway/latest/APIReference/API_SetSMBGuestPassword.html
     */
    setSMBGuestPassword() {
        this.add('storagegateway:SetSMBGuestPassword');
        return this;
    }
    /**
     * This operation shuts down a gateway.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/storagegateway/latest/APIReference/API_ShutdownGateway.html
     */
    shutdownGateway() {
        this.add('storagegateway:ShutdownGateway');
        return this;
    }
    /**
     * This operation starts a gateway that you previously shut down.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/storagegateway/latest/APIReference/API_StartGateway.html
     */
    startGateway() {
        this.add('storagegateway:StartGateway');
        return this;
    }
    /**
     * This operation updates the bandwidth rate limits of a gateway.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/storagegateway/latest/APIReference/API_UpdateBandwidthRateLimit.html
     */
    updateBandwidthRateLimit() {
        this.add('storagegateway:UpdateBandwidthRateLimit');
        return this;
    }
    /**
     * This operation updates the Challenge-Handshake Authentication Protocol (CHAP) credentials for a specified iSCSI target.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/storagegateway/latest/APIReference/API_UpdateChapCredentials.html
     */
    updateChapCredentials() {
        this.add('storagegateway:UpdateChapCredentials');
        return this;
    }
    /**
     * This operation updates a gateway's metadata, which includes the gateway's name and time zone.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/storagegateway/latest/APIReference/API_UpdateGatewayInformation.html
     */
    updateGatewayInformation() {
        this.add('storagegateway:UpdateGatewayInformation');
        return this;
    }
    /**
     * This operation updates the gateway virtual machine (VM) software.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/storagegateway/latest/APIReference/API_UpdateGatewaySoftwareNow.html
     */
    updateGatewaySoftwareNow() {
        this.add('storagegateway:UpdateGatewaySoftwareNow');
        return this;
    }
    /**
     * This operation updates a gateway's weekly maintenance start time information, including day and time of the week. The maintenance time is the time in your gateway's time zone.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/storagegateway/latest/APIReference/API_UpdateMaintenanceStartTime.html
     */
    updateMaintenanceStartTime() {
        this.add('storagegateway:UpdateMaintenanceStartTime');
        return this;
    }
    /**
     * This operation updates a NFS file share.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/storagegateway/latest/APIReference/API_UpdateNFSFileShare.html
     */
    updateNFSFileShare() {
        this.add('storagegateway:UpdateNFSFileShare');
        return this;
    }
    /**
     * This operation updates a SMB file share.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/storagegateway/latest/APIReference/API_UpdateSMBFileShare.html
     */
    updateSMBFileShare() {
        this.add('storagegateway:UpdateSMBFileShare');
        return this;
    }
    /**
     * This operation updates a snapshot schedule configured for a gateway volume.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/storagegateway/latest/APIReference/API_UpdateSnapshotSchedule.html
     */
    updateSnapshotSchedule() {
        this.add('storagegateway:UpdateSnapshotSchedule');
        return this;
    }
    /**
     * This operation updates the type of medium changer in a gateway-VTL.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/storagegateway/latest/APIReference/API_UpdateVTLDeviceType.html
     */
    updateVTLDeviceType() {
        this.add('storagegateway:UpdateVTLDeviceType');
        return this;
    }
    /**
     * Adds a resource of type device to the statement
     *
     * https://docs.aws.amazon.com/storagegateway/latest/userguide/resource_vtl-devices.html
     *
     * @param gatewayId - Identifier for the gatewayId.
     * @param vtldevice - Identifier for the vtldevice.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     */
    onDevice(gatewayId, vtldevice, account, region, partition) {
        var arn = 'arn:${Partition}:storagegateway:${Region}:${Account}:gateway/${GatewayId}/device/${Vtldevice}';
        arn = arn.replace('${GatewayId}', gatewayId);
        arn = arn.replace('${Vtldevice}', vtldevice);
        arn = arn.replace('${Account}', account || '*');
        arn = arn.replace('${Region}', region || '*');
        arn = arn.replace('${Partition}', partition || 'aws');
        return this.on(arn);
    }
    /**
     * Adds a resource of type gateway to the statement
     *
     * https://docs.aws.amazon.com/storagegateway/latest/userguide/StorageGatewayConcepts.html
     *
     * @param gatewayId - Identifier for the gatewayId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     *
     * Possible condition keys:
     *  - aws:ResourceTag/${TagKey}
     */
    onGateway(gatewayId, account, region, partition) {
        var arn = 'arn:${Partition}:storagegateway:${Region}:${Account}:gateway/${GatewayId}';
        arn = arn.replace('${GatewayId}', gatewayId);
        arn = arn.replace('${Account}', account || '*');
        arn = arn.replace('${Region}', region || '*');
        arn = arn.replace('${Partition}', partition || 'aws');
        return this.on(arn);
    }
    /**
     * Adds a resource of type share to the statement
     *
     * https://docs.aws.amazon.com/storagegateway/latest/userguide/GettingStartedCreateFileShare.html
     *
     * @param shareId - Identifier for the shareId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     *
     * Possible condition keys:
     *  - aws:ResourceTag/${TagKey}
     */
    onShare(shareId, account, region, partition) {
        var arn = 'arn:${Partition}:storagegateway:${Region}:${Account}:share/${ShareId}';
        arn = arn.replace('${ShareId}', shareId);
        arn = arn.replace('${Account}', account || '*');
        arn = arn.replace('${Region}', region || '*');
        arn = arn.replace('${Partition}', partition || 'aws');
        return this.on(arn);
    }
    /**
     * Adds a resource of type tape to the statement
     *
     * https://docs.aws.amazon.com/storagegateway/latest/userguide/StorageGatewayConcepts.html#storage-gateway-vtl-concepts
     *
     * @param tapeBarcode - Identifier for the tapeBarcode.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     *
     * Possible condition keys:
     *  - aws:ResourceTag/${TagKey}
     */
    onTape(tapeBarcode, account, region, partition) {
        var arn = 'arn:${Partition}:storagegateway:${Region}:${Account}:tape/${TapeBarcode}';
        arn = arn.replace('${TapeBarcode}', tapeBarcode);
        arn = arn.replace('${Account}', account || '*');
        arn = arn.replace('${Region}', region || '*');
        arn = arn.replace('${Partition}', partition || 'aws');
        return this.on(arn);
    }
    /**
     * Adds a resource of type target to the statement
     *
     * https://docs.aws.amazon.com/storagegateway/latest/userguide/GettingStartedCreateVolumes.html
     *
     * @param gatewayId - Identifier for the gatewayId.
     * @param iscsiTarget - Identifier for the iscsiTarget.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     */
    onTarget(gatewayId, iscsiTarget, account, region, partition) {
        var arn = 'arn:${Partition}:storagegateway:${Region}:${Account}:gateway/${GatewayId}/target/${IscsiTarget}';
        arn = arn.replace('${GatewayId}', gatewayId);
        arn = arn.replace('${IscsiTarget}', iscsiTarget);
        arn = arn.replace('${Account}', account || '*');
        arn = arn.replace('${Region}', region || '*');
        arn = arn.replace('${Partition}', partition || 'aws');
        return this.on(arn);
    }
    /**
     * Adds a resource of type volume to the statement
     *
     * https://docs.aws.amazon.com/storagegateway/latest/userguide/StorageGatewayConcepts.html#volume-gateway-concepts
     *
     * @param gatewayId - Identifier for the gatewayId.
     * @param volumeId - Identifier for the volumeId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     *
     * Possible condition keys:
     *  - aws:ResourceTag/${TagKey}
     */
    onVolume(gatewayId, volumeId, account, region, partition) {
        var arn = 'arn:${Partition}:storagegateway:${Region}:${Account}:gateway/${GatewayId}/volume/${VolumeId}';
        arn = arn.replace('${GatewayId}', gatewayId);
        arn = arn.replace('${VolumeId}', volumeId);
        arn = arn.replace('${Account}', account || '*');
        arn = arn.replace('${Region}', region || '*');
        arn = arn.replace('${Partition}', partition || 'aws');
        return this.on(arn);
    }
}
exports.Storagegateway = Storagegateway;
//# sourceMappingURL=data:application/json;base64,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