import { Actions, PolicyStatement, ResourceTypes } from "../shared";
import { PolicyStatementProps } from "@aws-cdk/aws-iam";
/**
 * Action provider for service sumerian
 *
 * https://docs.aws.amazon.com/IAM/latest/UserGuide/list_amazonsumerian.html
 */
export declare class Sumerian extends PolicyStatement {
    servicePrefix: string;
    actions: Actions;
    resourceTypes: ResourceTypes;
    /**
     * Action provider for service sumerian
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/list_amazonsumerian.html
     */
    constructor(props?: PolicyStatementProps);
    /**
     * Grant login access to the Sumerian console.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/sumerian/latest/userguide/sumerian-permissions.html
     */
    login(): this;
    /**
     * Grant access to view a project release.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/sumerian/latest/userguide/sumerian-permissions.html
     */
    viewRelease(): this;
    /**
     * Adds a resource of type project to the statement
     *
     * @param projectName - Identifier for the projectName.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     */
    onProject(projectName: string, account?: string, region?: string, partition?: string): this;
}
