"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const shared_1 = require("../shared");
/**
 * Action provider for service textract
 *
 * https://docs.aws.amazon.com/IAM/latest/UserGuide/list_amazontextract.html
 */
class Textract extends shared_1.PolicyStatement {
    /**
     * Action provider for service textract
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/list_amazontextract.html
     */
    constructor(props) {
        super(props);
        this.servicePrefix = 'textract';
        this.actions = {
            "AnalyzeDocument": {
                "url": "https://docs.aws.amazon.com/textract/latest/dg/API_AnalyzeDocument.html",
                "description": "Detects instances of real-world document entities within an image provided as input.",
                "accessLevel": "Read"
            },
            "DetectDocumentText": {
                "url": "https://docs.aws.amazon.com/textract/latest/dg/API_DetectDocumentText.html",
                "description": "Detects text in document images.",
                "accessLevel": "Read"
            },
            "GetDocumentAnalysis": {
                "url": "https://docs.aws.amazon.com/textract/latest/dg/API_GetDocumentAnalysis.html",
                "description": "Returns information about a document analysis job.",
                "accessLevel": "Read"
            },
            "GetDocumentTextDetection": {
                "url": "https://docs.aws.amazon.com/textract/latest/dg/API_GetDocumentTextDetection.html",
                "description": "Returns information about a document text detection job.",
                "accessLevel": "Read"
            },
            "StartDocumentAnalysis": {
                "url": "https://docs.aws.amazon.com/textract/latest/dg/API_StartDocumentAnalysis.html",
                "description": "Starts an asynchronous job to detect instances of real-world document entities within an image or pdf provided as input.",
                "accessLevel": "Write"
            },
            "StartDocumentTextDetection": {
                "url": "https://docs.aws.amazon.com/textract/latest/dg/API_StartDocumentTextDetection.html",
                "description": "Starts an asynchronous job to detect text in document images or pdfs.",
                "accessLevel": "Write"
            }
        };
        this.resourceTypes = {};
    }
    /**
     * Detects instances of real-world document entities within an image provided as input.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/textract/latest/dg/API_AnalyzeDocument.html
     */
    analyzeDocument() {
        this.add('textract:AnalyzeDocument');
        return this;
    }
    /**
     * Detects text in document images.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/textract/latest/dg/API_DetectDocumentText.html
     */
    detectDocumentText() {
        this.add('textract:DetectDocumentText');
        return this;
    }
    /**
     * Returns information about a document analysis job.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/textract/latest/dg/API_GetDocumentAnalysis.html
     */
    getDocumentAnalysis() {
        this.add('textract:GetDocumentAnalysis');
        return this;
    }
    /**
     * Returns information about a document text detection job.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/textract/latest/dg/API_GetDocumentTextDetection.html
     */
    getDocumentTextDetection() {
        this.add('textract:GetDocumentTextDetection');
        return this;
    }
    /**
     * Starts an asynchronous job to detect instances of real-world document entities within an image or pdf provided as input.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/textract/latest/dg/API_StartDocumentAnalysis.html
     */
    startDocumentAnalysis() {
        this.add('textract:StartDocumentAnalysis');
        return this;
    }
    /**
     * Starts an asynchronous job to detect text in document images or pdfs.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/textract/latest/dg/API_StartDocumentTextDetection.html
     */
    startDocumentTextDetection() {
        this.add('textract:StartDocumentTextDetection');
        return this;
    }
}
exports.Textract = Textract;
//# sourceMappingURL=data:application/json;base64,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