import { Actions, PolicyStatement, ResourceTypes } from "../shared";
import { PolicyStatementProps } from "@aws-cdk/aws-iam";
/**
 * Action provider for service translate
 *
 * https://docs.aws.amazon.com/IAM/latest/UserGuide/list_amazontranslate.html
 */
export declare class Translate extends PolicyStatement {
    servicePrefix: string;
    actions: Actions;
    resourceTypes: ResourceTypes;
    /**
     * Action provider for service translate
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/list_amazontranslate.html
     */
    constructor(props?: PolicyStatementProps);
    /**
     * A synchronous action that deletes a custom terminology.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/translate/latest/dg/API_DeleteTerminology.html
     */
    deleteTerminology(): this;
    /**
     * Gets the properties associated with an asynchronous batch translation job including name, ID, status, source and target languages, input/output S3 buckets, and so on.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/translate/latest/dg/API_DescribeTextTranslationJob.html
     */
    describeTextTranslationJob(): this;
    /**
     * Retrieves a custom terminology.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/translate/latest/dg/API_GetTerminology.html
     */
    getTerminology(): this;
    /**
     * Creates or updates a custom terminology, depending on whether or not one already exists for the given terminology name.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/translate/latest/dg/API_ImportTerminology.html
     */
    importTerminology(): this;
    /**
     * Provides a list of custom terminologies associated with your account.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/translate/latest/dg/API_ListTerminologies.html
     */
    listTerminologies(): this;
    /**
     * Gets a list of the batch translation jobs that you have submitted.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/translate/latest/dg/API_ListTextTranslationJobs.html
     */
    listTextTranslationJobs(): this;
    /**
     * Starts an asynchronous batch translation job. Batch translation jobs can be used to translate large volumes of text across multiple documents at once.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/translate/latest/dg/API_StartTextTranslationJob.html
     */
    startTextTranslationJob(): this;
    /**
     * Stops an asynchronous batch translation job that is in progress.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/translate/latest/dg/API_StopTextTranslationJob.html
     */
    stopTextTranslationJob(): this;
    /**
     * Translate text from a source language to a target language.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/translate/latest/dg/API_TranslateText.html
     */
    translateText(): this;
}
