"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const shared_1 = require("../shared");
/**
 * Action provider for service wam
 *
 * https://docs.aws.amazon.com/IAM/latest/UserGuide/list_amazonworkspacesapplicationmanager.html
 */
class Wam extends shared_1.PolicyStatement {
    /**
     * Action provider for service wam
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/list_amazonworkspacesapplicationmanager.html
     */
    constructor(props) {
        super(props);
        this.servicePrefix = 'wam';
        this.actions = {
            "AuthenticatePackager": {
                "url": "https://docs.aws.amazon.com/wam/latest/adminguide/iam.html",
                "description": "Allows the Amazon WAM packaging instance to access your application package catalog.",
                "accessLevel": "Write"
            }
        };
        this.resourceTypes = {};
    }
    /**
     * Allows the Amazon WAM packaging instance to access your application package catalog.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/wam/latest/adminguide/iam.html
     */
    authenticatePackager() {
        this.add('wam:AuthenticatePackager');
        return this;
    }
}
exports.Wam = Wam;
//# sourceMappingURL=data:application/json;base64,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