"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const shared_1 = require("../shared");
/**
 * Action provider for service discovery
 *
 * https://docs.aws.amazon.com/IAM/latest/UserGuide/list_applicationdiscovery.html
 */
class Discovery extends shared_1.PolicyStatement {
    /**
     * Action provider for service discovery
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/list_applicationdiscovery.html
     */
    constructor(props) {
        super(props);
        this.servicePrefix = 'discovery';
        this.actions = {
            "AssociateConfigurationItemsToApplication": {
                "url": "https://docs.aws.amazon.com/application-discovery/latest/APIReference/API_AssociateConfigurationItemsToApplication.html",
                "description": "Associates one or more configuration items with an application.",
                "accessLevel": "Write"
            },
            "BatchDeleteImportData": {
                "url": "https://docs.aws.amazon.com/application-discovery/latest/APIReference/API_BatchDeleteImportData.html",
                "description": "Deletes one or more Migration Hub import tasks, each identified by their import ID. Each import task has a number of records, which can identify servers or applications.",
                "accessLevel": "Write"
            },
            "CreateApplication": {
                "url": "https://docs.aws.amazon.com/application-discovery/latest/APIReference/API_CreateApplication.html",
                "description": "Creates an application with the given name and description.",
                "accessLevel": "Write"
            },
            "CreateTags": {
                "url": "https://docs.aws.amazon.com/application-discovery/latest/APIReference/API_CreateTags.html",
                "description": "Creates one or more tags for configuration items. Tags are metadata that help you categorize IT assets. This API accepts a list of multiple configuration items.",
                "accessLevel": "Tagging"
            },
            "DeleteApplications": {
                "url": "https://docs.aws.amazon.com/application-discovery/latest/APIReference/API_DeleteApplications.html",
                "description": "Deletes a list of applications and their associations with configuration items.",
                "accessLevel": "Write"
            },
            "DeleteTags": {
                "url": "https://docs.aws.amazon.com/application-discovery/latest/APIReference/API_DeleteTags.html",
                "description": "Deletes the association between configuration items and one or more tags. This API accepts a list of multiple configuration items.",
                "accessLevel": "Tagging"
            },
            "DescribeAgents": {
                "url": "https://docs.aws.amazon.com/application-discovery/latest/APIReference/API_DescribeAgents.html",
                "description": "Lists agents or the Connector by ID or lists all agents/Connectors associated with your user account if you did not specify an ID.",
                "accessLevel": "Read"
            },
            "DescribeConfigurations": {
                "url": "https://docs.aws.amazon.com/application-discovery/latest/APIReference/API_DescribeConfigurations.html",
                "description": "Retrieves attributes for a list of configuration item IDs. All of the supplied IDs must be for the same asset type (server, application, process, or connection). Output fields are specific to the asset type selected. For example, the output for a server configuration item includes a list of attributes about the server, such as host name, operating system, and number of network cards.",
                "accessLevel": "Read"
            },
            "DescribeContinuousExports": {
                "url": "https://docs.aws.amazon.com/application-discovery/latest/APIReference/API_DescribeContinuousExports.html",
                "description": "Lists exports as specified by ID. All continuous exports associated with your user account can be listed if you call DescribeContinuousExports as is without passing any parameters.",
                "accessLevel": "Read"
            },
            "DescribeExportConfigurations": {
                "url": "https://docs.aws.amazon.com/application-discovery/latest/APIReference/API_DescribeExportConfigurations.html",
                "description": "Retrieves the status of a given export process. You can retrieve status from a maximum of 100 processes.",
                "accessLevel": "Read"
            },
            "DescribeExportTasks": {
                "url": "https://docs.aws.amazon.com/application-discovery/latest/APIReference/API_DescribeExportTasks.html",
                "description": "Retrieve status of one or more export tasks. You can retrieve the status of up to 100 export tasks.",
                "accessLevel": "Read"
            },
            "DescribeImportTasks": {
                "url": "https://docs.aws.amazon.com/application-discovery/latest/APIReference/API_DescribeImportTasks.html",
                "description": "Returns an array of import tasks for your account, including status information, times, IDs, the Amazon S3 Object URL for the import file, and more.",
                "accessLevel": "List"
            },
            "DescribeTags": {
                "url": "https://docs.aws.amazon.com/application-discovery/latest/APIReference/API_DescribeTags.html",
                "description": "Retrieves a list of configuration items that are tagged with a specific tag. Or retrieves a list of all tags assigned to a specific configuration item.",
                "accessLevel": "Read"
            },
            "DisassociateConfigurationItemsFromApplication": {
                "url": "https://docs.aws.amazon.com/application-discovery/latest/APIReference/API_DisassociateConfigurationItemsFromApplication.html",
                "description": "Disassociates one or more configuration items from an application.",
                "accessLevel": "Write"
            },
            "ExportConfigurations": {
                "url": "https://docs.aws.amazon.com/application-discovery/latest/APIReference/API_ExportConfigurations.html",
                "description": "Exports all discovered configuration data to an Amazon S3 bucket or an application that enables you to view and evaluate the data. Data includes tags and tag associations, processes, connections, servers, and system performance.",
                "accessLevel": "Write"
            },
            "GetDiscoverySummary": {
                "url": "https://docs.aws.amazon.com/application-discovery/latest/APIReference/API_GetDiscoverySummary.html",
                "description": "Retrieves a short summary of discovered assets.",
                "accessLevel": "Read"
            },
            "ListConfigurations": {
                "url": "https://docs.aws.amazon.com/application-discovery/latest/APIReference/API_ListConfigurations.html",
                "description": "Retrieves a list of configuration items according to criteria you specify in a filter. The filter criteria identify relationship requirements.",
                "accessLevel": "List"
            },
            "ListServerNeighbors": {
                "url": "https://docs.aws.amazon.com/application-discovery/latest/APIReference/API_ListServerNeighbors.html",
                "description": "Retrieves a list of servers which are one network hop away from a specified server.",
                "accessLevel": "List"
            },
            "StartContinuousExport": {
                "url": "https://docs.aws.amazon.com/application-discovery/latest/APIReference/API_StartContinuousExport.html",
                "description": "Start the continuous flow of agent's discovered data into Amazon Athena.",
                "accessLevel": "Write"
            },
            "StartDataCollectionByAgentIds": {
                "url": "https://docs.aws.amazon.com/application-discovery/latest/APIReference/API_StartDataCollectionByAgentIds.html",
                "description": "Instructs the specified agents or Connectors to start collecting data.",
                "accessLevel": "Write"
            },
            "StartExportTask": {
                "url": "https://docs.aws.amazon.com/application-discovery/latest/APIReference/API_StartExportTask.html",
                "description": "Export the configuration data about discovered configuration items and relationships to an S3 bucket in a specified format.",
                "accessLevel": "Write"
            },
            "StartImportTask": {
                "url": "https://docs.aws.amazon.com/application-discovery/latest/APIReference/API_StartImportTask.html",
                "description": "Starts an import task. The Migration Hub import feature allows you to import details of your on-premises environment directly into AWS without having to use the Application Discovery Service (ADS) tools such as the Discovery Connector or Discovery Agent. This gives you the option to perform migration assessment and planning directly from your imported data including the ability to group your devices as applications and track their migration status.",
                "accessLevel": "Write"
            },
            "StopContinuousExport": {
                "url": "https://docs.aws.amazon.com/application-discovery/latest/APIReference/API_StopContinuousExport.html",
                "description": "Stop the continuous flow of agent's discovered data into Amazon Athena.",
                "accessLevel": "Write"
            },
            "StopDataCollectionByAgentIds": {
                "url": "https://docs.aws.amazon.com/application-discovery/latest/APIReference/API_StopDataCollectionByAgentIds.html",
                "description": "Instructs the specified agents or Connectors to stop collecting data.",
                "accessLevel": "Write"
            },
            "UpdateApplication": {
                "url": "https://docs.aws.amazon.com/application-discovery/latest/APIReference/API_UpdateApplication.html",
                "description": "Updates metadata about an application.",
                "accessLevel": "Write"
            }
        };
        this.resourceTypes = {};
    }
    /**
     * Associates one or more configuration items with an application.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/application-discovery/latest/APIReference/API_AssociateConfigurationItemsToApplication.html
     */
    associateConfigurationItemsToApplication() {
        this.add('discovery:AssociateConfigurationItemsToApplication');
        return this;
    }
    /**
     * Deletes one or more Migration Hub import tasks, each identified by their import ID. Each import task has a number of records, which can identify servers or applications.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/application-discovery/latest/APIReference/API_BatchDeleteImportData.html
     */
    batchDeleteImportData() {
        this.add('discovery:BatchDeleteImportData');
        return this;
    }
    /**
     * Creates an application with the given name and description.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/application-discovery/latest/APIReference/API_CreateApplication.html
     */
    createApplication() {
        this.add('discovery:CreateApplication');
        return this;
    }
    /**
     * Creates one or more tags for configuration items. Tags are metadata that help you categorize IT assets. This API accepts a list of multiple configuration items.
     *
     * Access Level: Tagging
     *
     * https://docs.aws.amazon.com/application-discovery/latest/APIReference/API_CreateTags.html
     */
    createTags() {
        this.add('discovery:CreateTags');
        return this;
    }
    /**
     * Deletes a list of applications and their associations with configuration items.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/application-discovery/latest/APIReference/API_DeleteApplications.html
     */
    deleteApplications() {
        this.add('discovery:DeleteApplications');
        return this;
    }
    /**
     * Deletes the association between configuration items and one or more tags. This API accepts a list of multiple configuration items.
     *
     * Access Level: Tagging
     *
     * https://docs.aws.amazon.com/application-discovery/latest/APIReference/API_DeleteTags.html
     */
    deleteTags() {
        this.add('discovery:DeleteTags');
        return this;
    }
    /**
     * Lists agents or the Connector by ID or lists all agents/Connectors associated with your user account if you did not specify an ID.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/application-discovery/latest/APIReference/API_DescribeAgents.html
     */
    describeAgents() {
        this.add('discovery:DescribeAgents');
        return this;
    }
    /**
     * Retrieves attributes for a list of configuration item IDs. All of the supplied IDs must be for the same asset type (server, application, process, or connection). Output fields are specific to the asset type selected. For example, the output for a server configuration item includes a list of attributes about the server, such as host name, operating system, and number of network cards.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/application-discovery/latest/APIReference/API_DescribeConfigurations.html
     */
    describeConfigurations() {
        this.add('discovery:DescribeConfigurations');
        return this;
    }
    /**
     * Lists exports as specified by ID. All continuous exports associated with your user account can be listed if you call DescribeContinuousExports as is without passing any parameters.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/application-discovery/latest/APIReference/API_DescribeContinuousExports.html
     */
    describeContinuousExports() {
        this.add('discovery:DescribeContinuousExports');
        return this;
    }
    /**
     * Retrieves the status of a given export process. You can retrieve status from a maximum of 100 processes.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/application-discovery/latest/APIReference/API_DescribeExportConfigurations.html
     */
    describeExportConfigurations() {
        this.add('discovery:DescribeExportConfigurations');
        return this;
    }
    /**
     * Retrieve status of one or more export tasks. You can retrieve the status of up to 100 export tasks.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/application-discovery/latest/APIReference/API_DescribeExportTasks.html
     */
    describeExportTasks() {
        this.add('discovery:DescribeExportTasks');
        return this;
    }
    /**
     * Returns an array of import tasks for your account, including status information, times, IDs, the Amazon S3 Object URL for the import file, and more.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/application-discovery/latest/APIReference/API_DescribeImportTasks.html
     */
    describeImportTasks() {
        this.add('discovery:DescribeImportTasks');
        return this;
    }
    /**
     * Retrieves a list of configuration items that are tagged with a specific tag. Or retrieves a list of all tags assigned to a specific configuration item.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/application-discovery/latest/APIReference/API_DescribeTags.html
     */
    describeTags() {
        this.add('discovery:DescribeTags');
        return this;
    }
    /**
     * Disassociates one or more configuration items from an application.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/application-discovery/latest/APIReference/API_DisassociateConfigurationItemsFromApplication.html
     */
    disassociateConfigurationItemsFromApplication() {
        this.add('discovery:DisassociateConfigurationItemsFromApplication');
        return this;
    }
    /**
     * Exports all discovered configuration data to an Amazon S3 bucket or an application that enables you to view and evaluate the data. Data includes tags and tag associations, processes, connections, servers, and system performance.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/application-discovery/latest/APIReference/API_ExportConfigurations.html
     */
    exportConfigurations() {
        this.add('discovery:ExportConfigurations');
        return this;
    }
    /**
     * Retrieves a short summary of discovered assets.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/application-discovery/latest/APIReference/API_GetDiscoverySummary.html
     */
    getDiscoverySummary() {
        this.add('discovery:GetDiscoverySummary');
        return this;
    }
    /**
     * Retrieves a list of configuration items according to criteria you specify in a filter. The filter criteria identify relationship requirements.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/application-discovery/latest/APIReference/API_ListConfigurations.html
     */
    listConfigurations() {
        this.add('discovery:ListConfigurations');
        return this;
    }
    /**
     * Retrieves a list of servers which are one network hop away from a specified server.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/application-discovery/latest/APIReference/API_ListServerNeighbors.html
     */
    listServerNeighbors() {
        this.add('discovery:ListServerNeighbors');
        return this;
    }
    /**
     * Start the continuous flow of agent's discovered data into Amazon Athena.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/application-discovery/latest/APIReference/API_StartContinuousExport.html
     */
    startContinuousExport() {
        this.add('discovery:StartContinuousExport');
        return this;
    }
    /**
     * Instructs the specified agents or Connectors to start collecting data.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/application-discovery/latest/APIReference/API_StartDataCollectionByAgentIds.html
     */
    startDataCollectionByAgentIds() {
        this.add('discovery:StartDataCollectionByAgentIds');
        return this;
    }
    /**
     * Export the configuration data about discovered configuration items and relationships to an S3 bucket in a specified format.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/application-discovery/latest/APIReference/API_StartExportTask.html
     */
    startExportTask() {
        this.add('discovery:StartExportTask');
        return this;
    }
    /**
     * Starts an import task. The Migration Hub import feature allows you to import details of your on-premises environment directly into AWS without having to use the Application Discovery Service (ADS) tools such as the Discovery Connector or Discovery Agent. This gives you the option to perform migration assessment and planning directly from your imported data including the ability to group your devices as applications and track their migration status.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/application-discovery/latest/APIReference/API_StartImportTask.html
     */
    startImportTask() {
        this.add('discovery:StartImportTask');
        return this;
    }
    /**
     * Stop the continuous flow of agent's discovered data into Amazon Athena.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/application-discovery/latest/APIReference/API_StopContinuousExport.html
     */
    stopContinuousExport() {
        this.add('discovery:StopContinuousExport');
        return this;
    }
    /**
     * Instructs the specified agents or Connectors to stop collecting data.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/application-discovery/latest/APIReference/API_StopDataCollectionByAgentIds.html
     */
    stopDataCollectionByAgentIds() {
        this.add('discovery:StopDataCollectionByAgentIds');
        return this;
    }
    /**
     * Updates metadata about an application.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/application-discovery/latest/APIReference/API_UpdateApplication.html
     */
    updateApplication() {
        this.add('discovery:UpdateApplication');
        return this;
    }
}
exports.Discovery = Discovery;
//# sourceMappingURL=data:application/json;base64,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