"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const shared_1 = require("../shared");
/**
 * Action provider for service arsenal
 *
 * https://docs.aws.amazon.com/IAM/latest/UserGuide/list_applicationdiscoveryarsenal.html
 */
class Arsenal extends shared_1.PolicyStatement {
    /**
     * Action provider for service arsenal
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/list_applicationdiscoveryarsenal.html
     */
    constructor(props) {
        super(props);
        this.servicePrefix = 'arsenal';
        this.actions = {
            "RegisterOnPremisesAgent": {
                "url": "https://docs.aws.amazon.com/setting-up.html#setting-up-user-policy",
                "description": "Grants permission to register AWS provided data collectors to the Application Discovery Service",
                "accessLevel": "Write"
            }
        };
        this.resourceTypes = {};
    }
    /**
     * Grants permission to register AWS provided data collectors to the Application Discovery Service
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/setting-up.html#setting-up-user-policy
     */
    registerOnPremisesAgent() {
        this.add('arsenal:RegisterOnPremisesAgent');
        return this;
    }
}
exports.Arsenal = Arsenal;
//# sourceMappingURL=data:application/json;base64,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