import { Actions, PolicyStatement, ResourceTypes } from "../shared";
import { PolicyStatementProps } from "@aws-cdk/aws-iam";
/**
 * Action provider for service backup-storage
 *
 * https://docs.aws.amazon.com/IAM/latest/UserGuide/list_awsbackupstorage.html
 */
export declare class BackupStorage extends PolicyStatement {
    servicePrefix: string;
    actions: Actions;
    resourceTypes: ResourceTypes;
    /**
     * Action provider for service backup-storage
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/list_awsbackupstorage.html
     */
    constructor(props?: PolicyStatementProps);
    /**
     * Associates a KMS key to a backup vault
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/aws-backup/latest/devguide/API_CreateBackupVault.html
     */
    mountCapsule(): this;
}
