import { Actions, PolicyStatement, ResourceTypes } from "../shared";
import { PolicyStatementProps } from "@aws-cdk/aws-iam";
/**
 * Action provider for service codecommit
 *
 * https://docs.aws.amazon.com/IAM/latest/UserGuide/list_awscodecommit.html
 */
export declare class Codecommit extends PolicyStatement {
    servicePrefix: string;
    actions: Actions;
    resourceTypes: ResourceTypes;
    /**
     * Action provider for service codecommit
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/list_awscodecommit.html
     */
    constructor(props?: PolicyStatementProps);
    /**
     * Grants permission to associate an approval rule template with a repository
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/codecommit/latest/APIReference/API_AssociateApprovalRuleTemplateWithRepository.html
     */
    associateApprovalRuleTemplateWithRepository(): this;
    /**
     * Grants permission to associate an approval rule template with multiple repositories in a single operation
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/codecommit/latest/APIReference/API_BatchAssociateApprovalRuleTemplateWithRepositories.html
     */
    batchAssociateApprovalRuleTemplateWithRepositories(): this;
    /**
     * Grants permission to get information about multiple merge conflicts when attempting to merge two commits using either the three-way merge or the squash merge option
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/codecommit/latest/APIReference/API_BatchDescribeMergeConflicts.html
     */
    batchDescribeMergeConflicts(): this;
    /**
     * Grants permission to remove the association between an approval rule template and multiple repositories in a single operation
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/codecommit/latest/APIReference/API_BatchDisassociateApprovalRuleTemplateFromRepositories.html
     */
    batchDisassociateApprovalRuleTemplateFromRepositories(): this;
    /**
     * Grants permission to get return information about one or more commits in an AWS CodeCommit repository.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/codecommit/latest/APIReference/API_BatchGetCommits.html
     */
    batchGetCommits(): this;
    /**
     * Grants permission to return information about one or more pull requests in an AWS CodeCommit repository
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/codecommit/latest/userguide/auth-and-access-control-permissions-reference.html#aa-pr
     */
    batchGetPullRequests(): this;
    /**
     * Grants permission to get information about multiple repositories
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/codecommit/latest/APIReference/API_BatchGetRepositories.html
     */
    batchGetRepositories(): this;
    /**
     * Grants permission to cancel the uploading of an archive to a pipeline in AWS CodePipeline
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/codecommit/latest/userguide/auth-and-access-control-permissions-reference.html#aa-acp
     */
    cancelUploadArchive(): this;
    /**
     * Grants permission to create an approval rule template that will automatically create approval rules in pull requests that match the conditions defined in the template; does not grant permission to create approval rules for individual pull requests
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/codecommit/latest/APIReference/API_CreateApprovalRuleTemplate.html
     */
    createApprovalRuleTemplate(): this;
    /**
     * Grants permission to create a branch in an AWS CodeCommit repository with this API; does not control Git create branch actions
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/codecommit/latest/APIReference/API_CreateBranch.html
     */
    createBranch(): this;
    /**
     * Grants permission to add, copy, move or update single or multiple files in a branch in an AWS CodeCommit repository, and generate a commit for the changes in the specified branch.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/codecommit/latest/APIReference/API_CreateCommit.html
     */
    createCommit(): this;
    /**
     * Grants permission to create a pull request in the specified repository
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/codecommit/latest/APIReference/API_CreatePullRequest.html
     */
    createPullRequest(): this;
    /**
     * Grants permission to create an approval rule specific to an individual pull request; does not grant permission to create approval rule templates
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/codecommit/latest/APIReference/API_CreatePullRequestApprovalRule.html
     */
    createPullRequestApprovalRule(): this;
    /**
     * Grants permission to create an AWS CodeCommit repository
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/codecommit/latest/APIReference/API_CreateRepository.html
     */
    createRepository(): this;
    /**
     * Grants permission to create an unreferenced commit that contains the result of merging two commits using either the three-way or the squash merge option; does not control Git merge actions
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/codecommit/latest/APIReference/API_CreateUnreferencedMergeCommit.html
     */
    createUnreferencedMergeCommit(): this;
    /**
     * Grants permission to delete an approval rule template
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/codecommit/latest/APIReference/API_DeleteApprovalRuleTemplate.html
     */
    deleteApprovalRuleTemplate(): this;
    /**
     * Grants permission to delete a branch in an AWS CodeCommit repository with this API; does not control Git delete branch actions
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/codecommit/latest/APIReference/API_DeleteBranch.html
     */
    deleteBranch(): this;
    /**
     * Grants permission to delete the content of a comment made on a change, file, or commit in a repository
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/codecommit/latest/APIReference/API_DeleteCommentContent.html
     */
    deleteCommentContent(): this;
    /**
     * Grants permission to delete a specified file from a specified branch
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/codecommit/latest/APIReference/API_DeleteFile.html
     */
    deleteFile(): this;
    /**
     * Grants permission to delete approval rule created for a pull request if the rule was not created by an approval rule template
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/codecommit/latest/APIReference/API_DeletePullRequestApprovalRule.html
     */
    deletePullRequestApprovalRule(): this;
    /**
     * Grants permission to delete an AWS CodeCommit repository
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/codecommit/latest/APIReference/API_DeleteRepository.html
     */
    deleteRepository(): this;
    /**
     * Grants permission to get information about specific merge conflicts when attempting to merge two commits using either the three-way or the squash merge option
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/codecommit/latest/APIReference/API_DescribeMergeConflicts.html
     */
    describeMergeConflicts(): this;
    /**
     * Grants permission to return information about one or more pull request events
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/codecommit/latest/APIReference/API_DescribePullRequestEvents.html
     */
    describePullRequestEvents(): this;
    /**
     * Grants permission to remove the association between an approval rule template and a repository
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/codecommit/latest/APIReference/API_DisassociateApprovalRuleTemplateFromRepository.html
     */
    disassociateApprovalRuleTemplateFromRepository(): this;
    /**
     * Grants permission to evaluate whether a pull request is mergable based on its current approval state and approval rule requirements
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/codecommit/latest/APIReference/API_EvaluatePullRequestApprovalRules.html
     */
    evaluatePullRequestApprovalRules(): this;
    /**
     * Grants permission to return information about an approval rule template
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/codecommit/latest/APIReference/API_GetApprovalRuleTemplate.html
     */
    getApprovalRuleTemplate(): this;
    /**
     * Grants permission to view the encoded content of an individual file in an AWS CodeCommit repository from the AWS CodeCommit console
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/codecommit/latest/APIReference/API_GetBlob.html
     */
    getBlob(): this;
    /**
     * Grants permission to get details about a branch in an AWS CodeCommit repository with this API; does not control Git branch actions
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/codecommit/latest/APIReference/API_GetBranch.html
     */
    getBranch(): this;
    /**
     * Grants permission to get the content of a comment made on a change, file, or commit in a repository
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/codecommit/latest/APIReference/API_GetComment.html
     */
    getComment(): this;
    /**
     * Grants permission to get the reactions on a comment
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/codecommit/latest/APIReference/API_GetCommentReactions.html
     */
    getCommentReactions(): this;
    /**
     * Grants permission to get information about comments made on the comparison between two commits
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/codecommit/latest/APIReference/API_GetCommentsForComparedCommit.html
     */
    getCommentsForComparedCommit(): this;
    /**
     * Grants permission to get comments made on a pull request
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/codecommit/latest/APIReference/API_GetCommentsForPullRequest.html
     */
    getCommentsForPullRequest(): this;
    /**
     * Grants permission to return information about a commit, including commit message and committer information, with this API; does not control Git log actions
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/codecommit/latest/APIReference/API_GetCommit.html
     */
    getCommit(): this;
    /**
     * Grants permission to get information about the history of commits in a repository
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/codecommit/latest/userguide/auth-and-access-control-permissions-reference.html#aa-code
     */
    getCommitHistory(): this;
    /**
     * Grants permission to get information about the difference between commits in the context of a potential merge
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/codecommit/latest/userguide/auth-and-access-control-permissions-reference.html#aa-pr
     */
    getCommitsFromMergeBase(): this;
    /**
     * Grants permission to view information about the differences between valid commit specifiers such as a branch, tag, HEAD, commit ID, or other fully qualified reference
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/codecommit/latest/APIReference/API_GetDifferences.html
     */
    getDifferences(): this;
    /**
     * Grants permission to return the base-64 encoded contents of a specified file and its metadata
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/codecommit/latest/APIReference/API_GetFile.html
     */
    getFile(): this;
    /**
     * Grants permission to return the contents of a specified folder in a repository
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/codecommit/latest/APIReference/API_GetFolder.html
     */
    getFolder(): this;
    /**
     * Grants permission to get information about a merge commit created by one of the merge options for pull requests that creates merge commits. Not all merge options create merge commits. This permission does not control Git merge actions
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/codecommit/latest/APIReference/API_GetMergeCommit.html
     */
    getMergeCommit(): this;
    /**
     * Grants permission to get information about merge conflicts between the before and after commit IDs for a pull request in a repository
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/codecommit/latest/APIReference/API_GetMergeConflicts.html
     */
    getMergeConflicts(): this;
    /**
     * Grants permission to get information about merge options for pull requests that can be used to merge two commits; does not control Git merge actions
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/codecommit/latest/APIReference/API_GetMergeOptions.html
     */
    getMergeOptions(): this;
    /**
     * Grants permission to resolve blobs, trees, and commits to their identifier
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/codecommit/latest/userguide/auth-and-access-control-permissions-reference.html#aa-code
     */
    getObjectIdentifier(): this;
    /**
     * Grants permission to get information about a pull request in a specified repository
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/codecommit/latest/APIReference/API_GetPullRequest.html
     */
    getPullRequest(): this;
    /**
     * Grants permission to retrieve the current approvals on an inputted pull request
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/codecommit/latest/APIReference/API_GetPullRequestApprovalStates.html
     */
    getPullRequestApprovalStates(): this;
    /**
     * Grants permission to retrieve the current override state of a given pull request
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/codecommit/latest/APIReference/API_GetPullRequestOverrideState.html
     */
    getPullRequestOverrideState(): this;
    /**
     * Grants permission to get details about references in an AWS CodeCommit repository; does not control Git reference actions
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/codecommit/latest/userguide/auth-and-access-control-permissions-reference.html#aa-code
     */
    getReferences(): this;
    /**
     * Grants permission to get information about an AWS CodeCommit repository
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/codecommit/latest/APIReference/API_GetRepository.html
     */
    getRepository(): this;
    /**
     * Grants permission to get information about triggers configured for a repository
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/codecommit/latest/APIReference/API_GetRepositoryTriggers.html
     */
    getRepositoryTriggers(): this;
    /**
     * Grants permission to view the contents of a specified tree in an AWS CodeCommit repository from the AWS CodeCommit console
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/codecommit/latest/userguide/auth-and-access-control-permissions-reference.html#aa-code
     */
    getTree(): this;
    /**
     * Grants permission to get status information about an archive upload to a pipeline in AWS CodePipeline
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/codecommit/latest/userguide/auth-and-access-control-permissions-reference.html#aa-acp
     */
    getUploadArchiveStatus(): this;
    /**
     * Grants permission to pull information from an AWS CodeCommit repository to a local repo
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/codecommit/latest/userguide/auth-and-access-control-permissions-reference.html#aa-git
     */
    gitPull(): this;
    /**
     * Grants permission to push information from a local repo to an AWS CodeCommit repository
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/codecommit/latest/userguide/auth-and-access-control-permissions-reference.html#aa-git
     */
    gitPush(): this;
    /**
     * Grants permission to list all approval rule templates in an AWS Region for the AWS account
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/codecommit/latest/APIReference/API_ListApprovalRuleTemplates.html
     */
    listApprovalRuleTemplates(): this;
    /**
     * Grants permission to list approval rule templates that are associated with a repository
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/codecommit/latest/APIReference/API_ListAssociatedApprovalRuleTemplatesForRepository.html
     */
    listAssociatedApprovalRuleTemplatesForRepository(): this;
    /**
     * Grants permission to list branches for an AWS CodeCommit repository with this API; does not control Git branch actions
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/codecommit/latest/APIReference/API_ListBranches.html
     */
    listBranches(): this;
    /**
     * Grants permission to list pull requests for a specified repository
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/codecommit/latest/APIReference/API_ListPullRequests.html
     */
    listPullRequests(): this;
    /**
     * Grants permission to list information about AWS CodeCommit repositories in the current Region for your AWS account
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/codecommit/latest/APIReference/API_ListRepositories.html
     */
    listRepositories(): this;
    /**
     * Grants permission to list repositories that are associated with an approval rule template
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/codecommit/latest/APIReference/API_ListRepositoriesForApprovalRuleTemplate.html
     */
    listRepositoriesForApprovalRuleTemplate(): this;
    /**
     * Grants permission to list the resource attached to a CodeCommit resource ARN
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/codecommit/latest/APIReference/API_ListTagsForResource.html
     */
    listTagsForResource(): this;
    /**
     * Grants permission to merge two commits into the specified destination branch using the fast-forward merge option
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/codecommit/latest/APIReference/API_MergeBranchesByFastForward.html
     */
    mergeBranchesByFastForward(): this;
    /**
     * Grants permission to merge two commits into the specified destination branch using the squash merge option
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/codecommit/latest/APIReference/API_MergeBranchesBySquash.html
     */
    mergeBranchesBySquash(): this;
    /**
     * Grants permission to merge two commits into the specified destination branch using the three-way merge option
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/codecommit/latest/APIReference/API_MergeBranchesByThreeWay.html
     */
    mergeBranchesByThreeWay(): this;
    /**
     * Grants permission to close a pull request and attempt to merge it into the specified destination branch for that pull request at the specified commit using the fast-forward merge option
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/codecommit/latest/APIReference/API_MergePullRequestByFastForward.html
     */
    mergePullRequestByFastForward(): this;
    /**
     * Grants permission to close a pull request and attempt to merge it into the specified destination branch for that pull request at the specified commit using the squash merge option
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/codecommit/latest/APIReference/API_MergePullRequestBySquash.html
     */
    mergePullRequestBySquash(): this;
    /**
     * Grants permission to close a pull request and attempt to merge it into the specified destination branch for that pull request at the specified commit using the three-way merge option
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/codecommit/latest/APIReference/API_MergePullRequestByThreeWay.html
     */
    mergePullRequestByThreeWay(): this;
    /**
     * Grants permission to override all approval rules for a pull request, including approval rules created by a template
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/codecommit/latest/APIReference/API_OverridePullRequestApprovalRules.html
     */
    overridePullRequestApprovalRules(): this;
    /**
     * Grants permission to post a comment on the comparison between two commits
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/codecommit/latest/APIReference/API_PostCommentForComparedCommit.html
     */
    postCommentForComparedCommit(): this;
    /**
     * Grants permission to post a comment on a pull request
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/codecommit/latest/APIReference/API_PostCommentForPullRequest.html
     */
    postCommentForPullRequest(): this;
    /**
     * Grants permission to post a comment in reply to a comment on a comparison between commits or a pull request
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/codecommit/latest/APIReference/API_PostCommentReply.html
     */
    postCommentReply(): this;
    /**
     * Grants permission to post a reaction on a comment
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/codecommit/latest/APIReference/API_PutCommentReaction.html
     */
    putCommentReaction(): this;
    /**
     * Grants permission to add or update a file in a branch in an AWS CodeCommit repository, and generate a commit for the addition in the specified branch
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/codecommit/latest/APIReference/API_PutFile.html
     */
    putFile(): this;
    /**
     * Grants permission to create, update, or delete triggers for a repository
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/codecommit/latest/APIReference/API_PutRepositoryTriggers.html
     */
    putRepositoryTriggers(): this;
    /**
     * Grants permission to attach resource tags to a CodeCommit resource ARN
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/codecommit/latest/APIReference/API_TagResource.html
     */
    tagResource(): this;
    /**
     * Grants permission to test the functionality of repository triggers by sending information to the trigger target
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/codecommit/latest/APIReference/API_TestRepositoryTriggers.html
     */
    testRepositoryTriggers(): this;
    /**
     * Grants permission to disassociate resource tags from a CodeCommit resource ARN
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/codecommit/latest/APIReference/API_UntagResource.html
     */
    untagResource(): this;
    /**
     * Grants permission to update the content of approval rule templates; does not grant permission to update content of approval rules created specifically for pull requests
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/codecommit/latest/APIReference/API_UpdateApprovalRuleTemplateContent.html
     */
    updateApprovalRuleTemplateContent(): this;
    /**
     * Grants permission to update the description of approval rule templates
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/codecommit/latest/APIReference/API_UpdateApprovalRuleTemplateDescription.html
     */
    updateApprovalRuleTemplateDescription(): this;
    /**
     * Grants permission to update the name of approval rule templates
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/codecommit/latest/APIReference/API_UpdateApprovalRuleTemplateName.html
     */
    updateApprovalRuleTemplateName(): this;
    /**
     * Grants permission to update the contents of a comment if the identity matches the identity used to create the comment
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/codecommit/latest/APIReference/API_UpdateComment.html
     */
    updateComment(): this;
    /**
     * Grants permission to change the default branch in an AWS CodeCommit repository
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/codecommit/latest/APIReference/API_UpdateDefaultBranch.html
     */
    updateDefaultBranch(): this;
    /**
     * Grants permission to update the content for approval rules created for a specific pull requests; does not grant permission to update approval rule content for rules created with an approval rule template
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/codecommit/latest/APIReference/API_UpdatePullRequestApprovalRuleContent.html
     */
    updatePullRequestApprovalRuleContent(): this;
    /**
     * Grants permission to update the approval state for pull requests
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/codecommit/latest/APIReference/API_UpdatePullRequestApprovalState.html
     */
    updatePullRequestApprovalState(): this;
    /**
     * Grants permission to update the description of a pull request
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/codecommit/latest/APIReference/API_UpdatePullRequestDescription.html
     */
    updatePullRequestDescription(): this;
    /**
     * Grants permission to update the status of a pull request
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/codecommit/latest/APIReference/API_UpdatePullRequestStatus.html
     */
    updatePullRequestStatus(): this;
    /**
     * Grants permission to update the title of a pull request
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/codecommit/latest/APIReference/API_UpdatePullRequestTitle.html
     */
    updatePullRequestTitle(): this;
    /**
     * Grants permission to change the description of an AWS CodeCommit repository
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/codecommit/latest/APIReference/API_UpdateRepositoryDescription.html
     */
    updateRepositoryDescription(): this;
    /**
     * Grants permission to change the name of an AWS CodeCommit repository
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/codecommit/latest/APIReference/API_UpdateRepositoryName.html
     */
    updateRepositoryName(): this;
    /**
     * Grants permission to the service role for AWS CodePipeline to upload repository changes into a pipeline
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/codecommit/latest/userguide/auth-and-access-control-permissions-reference.html#aa-acp
     */
    uploadArchive(): this;
    /**
     * Adds a resource of type repository to the statement
     *
     * https://docs.aws.amazon.com/codecommit/latest/userguide/auth-and-access-control-iam-access-control-identity-based.html#arn-formats
     *
     * @param repositoryName - Identifier for the repositoryName.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     *
     * Possible condition keys:
     *  - aws:ResourceTag/${TagKey}
     */
    onRepository(repositoryName: string, account?: string, region?: string, partition?: string): this;
    /**
     * Filters access by Git reference to specified AWS CodeCommit actions
     *
     * https://docs.aws.amazon.com/codecommit/latest/userguide/how-to-conditional-branch.html
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifReferences(value: string | string[], operator?: string): this;
}
