import { Actions, PolicyStatement, ResourceTypes } from "../shared";
import { PolicyStatementProps } from "@aws-cdk/aws-iam";
/**
 * Action provider for service devicefarm
 *
 * https://docs.aws.amazon.com/IAM/latest/UserGuide/list_awsdevicefarm.html
 */
export declare class Devicefarm extends PolicyStatement {
    servicePrefix: string;
    actions: Actions;
    resourceTypes: ResourceTypes;
    /**
     * Action provider for service devicefarm
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/list_awsdevicefarm.html
     */
    constructor(props?: PolicyStatementProps);
    /**
     * Grants permission to create a device pool within a project
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/devicefarm/latest/APIReference/API_CreateDevicePool.html
     */
    createDevicePool(): this;
    /**
     * Grants permission to create a device instance profile
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/devicefarm/latest/APIReference/API_CreateInstanceProfile.html
     */
    createInstanceProfile(): this;
    /**
     * Grants permission to create a network profile within a project
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/devicefarm/latest/APIReference/API_CreateNetworkProfile.html
     */
    createNetworkProfile(): this;
    /**
     * Grants permission to create a project for mobile testing
     *
     * Access Level: Tagging
     *
     * https://docs.aws.amazon.com/devicefarm/latest/APIReference/API_CreateProject.html
     */
    createProject(): this;
    /**
     * Grants permission to start a remote access session to a device instance
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/devicefarm/latest/APIReference/API_CreateRemoteAccessSession.html
     */
    createRemoteAccessSession(): this;
    /**
     * Grants permission to create a project for desktop testing
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/devicefarm/latest/APIReference/API_CreateTestGridProject.html
     */
    createTestGridProject(): this;
    /**
     * Grants permission to generate a new pre-signed url used to access our test grid service
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/devicefarm/latest/APIReference/API_CreateTestGridUrl.html
     */
    createTestGridUrl(): this;
    /**
     * Grants permission to upload a new file or app within a project
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/devicefarm/latest/APIReference/API_CreateUpload.html
     */
    createUpload(): this;
    /**
     * Grants permission to create an Amazon Virtual Private Cloud (VPC) endpoint configuration
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/devicefarm/latest/APIReference/API_CreateVPCEConfiguration.html
     */
    createVPCEConfiguration(): this;
    /**
     * Grants permission to delete a user-generated device pool
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/devicefarm/latest/APIReference/API_DeleteDevicePool.html
     */
    deleteDevicePool(): this;
    /**
     * Grants permission to delete a user-generated instance profile
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/devicefarm/latest/APIReference/API_DeleteInstanceProfile.html
     */
    deleteInstanceProfile(): this;
    /**
     * Grants permission to delete a user-generated network profile
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/devicefarm/latest/APIReference/DeleteNetworkProfile.html
     */
    deleteNetworkProfile(): this;
    /**
     * Grants permission to delete a mobile testing project
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/devicefarm/latest/APIReference/API_DeleteProject.html
     */
    deleteProject(): this;
    /**
     * Grants permission to delete a completed remote access session and its results
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/devicefarm/latest/APIReference/API_DeleteRemoteAccessSession.html
     */
    deleteRemoteAccessSession(): this;
    /**
     * Grants permission to delete a run
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/devicefarm/latest/APIReference/API_DeleteRun.html
     */
    deleteRun(): this;
    /**
     * Grants permission to delete a desktop testing project
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/devicefarm/latest/APIReference/API_DeleteTestGridProject.html
     */
    deleteTestGridProject(): this;
    /**
     * Grants permission to delete a user-uploaded file
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/devicefarm/latest/APIReference/API_DeleteUpload.html
     */
    deleteUpload(): this;
    /**
     * Grants permission to delete an Amazon Virtual Private Cloud (VPC) endpoint configuration
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/devicefarm/latest/APIReference/API_DeleteVPCEConfiguration.html
     */
    deleteVPCEConfiguration(): this;
    /**
     * Grants permission to retrieve the number of unmetered iOS and/or unmetered Android devices purchased by the account
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/devicefarm/latest/APIReference/API_GetAccountSettings.html
     */
    getAccountSettings(): this;
    /**
     * Grants permission to retrieve the information of a unique device type
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/devicefarm/latest/APIReference/API_GetDevice.html
     */
    getDevice(): this;
    /**
     * Grants permission to retireve the information of a device instance
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/devicefarm/latest/APIReference/API_GetDeviceInstance.html
     */
    getDeviceInstance(): this;
    /**
     * Grants permission to retireve the information of a device pool
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/devicefarm/latest/APIReference/API_GetDevicePool.html
     */
    getDevicePool(): this;
    /**
     * Grants permission to retrieve information about the compatibility of a test and/or app with a device pool
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/devicefarm/latest/APIReference/API_GetDevicePoolCompatibility.html
     */
    getDevicePoolCompatibility(): this;
    /**
     * Grants permission to retireve the information of an instance profile
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/devicefarm/latest/APIReference/API_GetInstanceProfile.html
     */
    getInstanceProfile(): this;
    /**
     * Grants permission to retireve the information of a job
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/devicefarm/latest/APIReference/API_GetJob.html
     */
    getJob(): this;
    /**
     * Grants permission to retireve the information of a network profile
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/devicefarm/latest/APIReference/API_GetNetworkProfile.html
     */
    getNetworkProfile(): this;
    /**
     * Grants permission to retrieve the current status and future status of all offerings purchased by an AWS account
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/devicefarm/latest/APIReference/API_GetOfferingStatus.html
     */
    getOfferingStatus(): this;
    /**
     * Grants permission to retrieve information about a mobile testing project
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/devicefarm/latest/APIReference/API_GetProject.html
     */
    getProject(): this;
    /**
     * Grants permission to retireve the link to a currently running remote access session
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/devicefarm/latest/APIReference/API_GetRemoteAccessSession.html
     */
    getRemoteAccessSession(): this;
    /**
     * Grants permission to retireve the information of a run
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/devicefarm/latest/APIReference/API_GetRun.html
     */
    getRun(): this;
    /**
     * Grants permission to retireve the information of a testing suite
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/devicefarm/latest/APIReference/API_GetSuite.html
     */
    getSuite(): this;
    /**
     * Grants permission to retireve the information of a test case
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/devicefarm/latest/APIReference/API_GetTest.html
     */
    getTest(): this;
    /**
     * Grants permission to retrieve information about a desktop testing project
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/devicefarm/latest/APIReference/API_GetTestGridProject.html
     */
    getTestGridProject(): this;
    /**
     * Grants permission to retireve the information of a test grid session
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/devicefarm/latest/APIReference/API_GetTestGridSession.html
     */
    getTestGridSession(): this;
    /**
     * Grants permission to retireve the information of an uploaded file
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/devicefarm/latest/APIReference/API_GetUpload.html
     */
    getUpload(): this;
    /**
     * Grants permission to retireve the information of an Amazon Virtual Private Cloud (VPC) endpoint configuration
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/devicefarm/latest/APIReference/API_GetVPCEConfiguration.html
     */
    getVPCEConfiguration(): this;
    /**
     * Grants permission to install an application to a device in a remote access session
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/devicefarm/latest/APIReference/API_InstallToRemoteAccessSession.html
     */
    installToRemoteAccessSession(): this;
    /**
     * Grants permission to list the artifacts in a project
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/devicefarm/latest/APIReference/API_ListArtifacts.html
     */
    listArtifacts(): this;
    /**
     * Grants permission to list the information of device instances
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/devicefarm/latest/APIReference/API_ListDeviceInstances.html
     */
    listDeviceInstances(): this;
    /**
     * Grants permission to list the information of device pools
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/devicefarm/latest/APIReference/API_ListDevicePools.html
     */
    listDevicePools(): this;
    /**
     * Grants permission to list the information of unique device types
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/devicefarm/latest/APIReference/API_ListDevices.html
     */
    listDevices(): this;
    /**
     * Grants permission to list the information of device instance profiles
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/devicefarm/latest/APIReference/API_ListInstanceProfiles.html
     */
    listInstanceProfiles(): this;
    /**
     * Grants permission to list the information of jobs within a run
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/devicefarm/latest/APIReference/API_ListJobs.html
     */
    listJobs(): this;
    /**
     * Grants permission to list the information of network profiles within a project
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/devicefarm/latest/APIReference/API_ListNetworkProfiles.html
     */
    listNetworkProfiles(): this;
    /**
     * Grants permission to list the offering promotions
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/devicefarm/latest/APIReference/API_ListOfferingPromotions.html
     */
    listOfferingPromotions(): this;
    /**
     * Grants permission to list all of the historical purchases, renewals, and system renewal transactions for an AWS account
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/devicefarm/latest/APIReference/API_ListOfferingTransactions.html
     */
    listOfferingTransactions(): this;
    /**
     * Grants permission to list the products or offerings that the user can manage through the API
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/devicefarm/latest/APIReference/API_ListOfferings.html
     */
    listOfferings(): this;
    /**
     * Grants permission to list the information of mobile testing projects for an AWS account
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/devicefarm/latest/APIReference/API_ListProjects.html
     */
    listProjects(): this;
    /**
     * Grants permission to list the information of currently running remote access sessions
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/devicefarm/latest/APIReference/API_ListRemoteAccessSessions.html
     */
    listRemoteAccessSessions(): this;
    /**
     * Grants permission to list the information of runs within a project
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/devicefarm/latest/APIReference/API_ListRuns.html
     */
    listRuns(): this;
    /**
     * Grants permission to list the information of samples within a project
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/devicefarm/latest/APIReference/API_ListSamples.html
     */
    listSamples(): this;
    /**
     * Grants permission to list the information of testing suites within a job
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/devicefarm/latest/APIReference/API_ListSuites.html
     */
    listSuites(): this;
    /**
     * Grants permission to list the tags of a resource
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/devicefarm/latest/APIReference/API_ListTagsForResource.html
     */
    listTagsForResource(): this;
    /**
     * Grants permission to list the information of desktop testing projects for an AWS account
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/devicefarm/latest/APIReference/API_ListTestGridProjects.html
     */
    listTestGridProjects(): this;
    /**
     * Grants permission to list the session actions performed during a test grid session
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/devicefarm/latest/APIReference/API_ListTestGridSessionActions.html
     */
    listTestGridSessionActions(): this;
    /**
     * Grants permission to list the artifacts generated by a test grid session
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/devicefarm/latest/APIReference/API_ListTestGridSessionArtifacts.html
     */
    listTestGridSessionArtifacts(): this;
    /**
     * Grants permission to list the sessions within a test grid project
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/devicefarm/latest/APIReference/API_ListTestGridSessions.html
     */
    listTestGridSessions(): this;
    /**
     * Grants permission to list the information of tests within a testing suite
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/devicefarm/latest/APIReference/API_ListTests.html
     */
    listTests(): this;
    /**
     * Grants permission to list the information of unique problems within a run
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/devicefarm/latest/APIReference/API_ListUniqueProblems.html
     */
    listUniqueProblems(): this;
    /**
     * Grants permission to list the information of uploads within a project
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/devicefarm/latest/APIReference/API_ListUploads.html
     */
    listUploads(): this;
    /**
     * Grants permission to list the information of Amazon Virtual Private Cloud (VPC) endpoint configurations
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/devicefarm/latest/APIReference/API_ListVPCEConfigurations.html
     */
    listVPCEConfigurations(): this;
    /**
     * Grants permission to purchase offerings for an AWS account
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/devicefarm/latest/APIReference/API_PurchaseOffering.html
     */
    purchaseOffering(): this;
    /**
     * Grants permission to set the quantity of devices to renew for an offering
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/devicefarm/latest/APIReference/API_RenewOffering.html
     */
    renewOffering(): this;
    /**
     * Grants permission to schedule a run
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/devicefarm/latest/APIReference/API_ScheduleRun.html
     */
    scheduleRun(): this;
    /**
     * Grants permission to terminate a running job
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/devicefarm/latest/APIReference/API_StopJob.html
     */
    stopJob(): this;
    /**
     * Grants permission to terminate a running remote access session
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/devicefarm/latest/APIReference/API_StopRemoteAccessSession.html
     */
    stopRemoteAccessSession(): this;
    /**
     * Grants permission to terminate a running test run
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/devicefarm/latest/APIReference/API_StopRun.html
     */
    stopRun(): this;
    /**
     * Grants permission to add tags to a resource
     *
     * Access Level: Tagging
     *
     * https://docs.aws.amazon.com/devicefarm/latest/APIReference/API_TagResource.html
     */
    tagResource(): this;
    /**
     * Grants permission to remove tags from a resource
     *
     * Access Level: Tagging
     *
     * https://docs.aws.amazon.com/devicefarm/latest/APIReference/API_UntagResource.html
     */
    untagResource(): this;
    /**
     * Grants permission to modify an existing device instance
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/devicefarm/latest/APIReference/API_UpdateDeviceInstance.html
     */
    updateDeviceInstance(): this;
    /**
     * Grants permission to modify an existing device pool
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/devicefarm/latest/APIReference/API_UpdateDevicePool.html
     */
    updateDevicePool(): this;
    /**
     * Grants permission to modify an existing instance profile
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/devicefarm/latest/APIReference/API_UpdateInstanceProfile.html
     */
    updateInstanceProfile(): this;
    /**
     * Grants permission to modify an existing network profile
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/devicefarm/latest/APIReference/API_UpdateNetworkProfile.html
     */
    updateNetworkProfile(): this;
    /**
     * Grants permission to modify an existing mobile testing project
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/devicefarm/latest/APIReference/API_UpdateProject.html
     */
    updateProject(): this;
    /**
     * Grants permission to modify an existing desktop testing project
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/devicefarm/latest/APIReference/API_UpdateTestGridProject.html
     */
    updateTestGridProject(): this;
    /**
     * Grants permission to modify an existing upload
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/devicefarm/latest/APIReference/API_UpdateUpload.html
     */
    updateUpload(): this;
    /**
     * Grants permission to modify an existing Amazon Virtual Private Cloud (VPC) endpoint configuration
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/devicefarm/latest/APIReference/API_UpdateVPCEConfiguration.html
     */
    updateVPCEConfiguration(): this;
    /**
     * Adds a resource of type project to the statement
     *
     * https://docs.aws.amazon.com/devicefarm/latest/APIReference/API_Project.html
     *
     * @param resourceId - Identifier for the resourceId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     *
     * Possible condition keys:
     *  - aws:ResourceTag/${TagKey}
     */
    onProject(resourceId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type run to the statement
     *
     * https://docs.aws.amazon.com/devicefarm/latest/APIReference/API_Run.html
     *
     * @param resourceId - Identifier for the resourceId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     *
     * Possible condition keys:
     *  - aws:ResourceTag/${TagKey}
     */
    onRun(resourceId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type job to the statement
     *
     * https://docs.aws.amazon.com/devicefarm/latest/APIReference/API_Job.html
     *
     * @param resourceId - Identifier for the resourceId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     */
    onJob(resourceId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type suite to the statement
     *
     * https://docs.aws.amazon.com/devicefarm/latest/APIReference/API_Suite.html
     *
     * @param resourceId - Identifier for the resourceId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     */
    onSuite(resourceId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type test to the statement
     *
     * https://docs.aws.amazon.com/devicefarm/latest/APIReference/API_Test.html
     *
     * @param resourceId - Identifier for the resourceId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     */
    onTest(resourceId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type upload to the statement
     *
     * https://docs.aws.amazon.com/devicefarm/latest/APIReference/API_Upload.html
     *
     * @param resourceId - Identifier for the resourceId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     */
    onUpload(resourceId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type artifact to the statement
     *
     * https://docs.aws.amazon.com/devicefarm/latest/APIReference/API_Artifact.html
     *
     * @param resourceId - Identifier for the resourceId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     */
    onArtifact(resourceId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type sample to the statement
     *
     * https://docs.aws.amazon.com/devicefarm/latest/APIReference/API_Sample.html
     *
     * @param resourceId - Identifier for the resourceId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     */
    onSample(resourceId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type networkprofile to the statement
     *
     * https://docs.aws.amazon.com/devicefarm/latest/APIReference/API_NetworkProfile.html
     *
     * @param resourceId - Identifier for the resourceId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     *
     * Possible condition keys:
     *  - aws:ResourceTag/${TagKey}
     */
    onNetworkprofile(resourceId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type deviceinstance to the statement
     *
     * https://docs.aws.amazon.com/devicefarm/latest/APIReference/API_DeviceInstance.html
     *
     * @param resourceId - Identifier for the resourceId.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     *
     * Possible condition keys:
     *  - aws:ResourceTag/${TagKey}
     */
    onDeviceinstance(resourceId: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type session to the statement
     *
     * https://docs.aws.amazon.com/devicefarm/latest/APIReference/API_RemoteAccessSession.html
     *
     * @param resourceId - Identifier for the resourceId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     *
     * Possible condition keys:
     *  - aws:ResourceTag/${TagKey}
     */
    onSession(resourceId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type devicepool to the statement
     *
     * https://docs.aws.amazon.com/devicefarm/latest/APIReference/API_DevicePool.html
     *
     * @param resourceId - Identifier for the resourceId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     *
     * Possible condition keys:
     *  - aws:ResourceTag/${TagKey}
     */
    onDevicepool(resourceId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type device to the statement
     *
     * https://docs.aws.amazon.com/devicefarm/latest/APIReference/API_Device.html
     *
     * @param resourceId - Identifier for the resourceId.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     *
     * Possible condition keys:
     *  - aws:ResourceTag/${TagKey}
     */
    onDevice(resourceId: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type instanceprofile to the statement
     *
     * https://docs.aws.amazon.com/devicefarm/latest/APIReference/API_InstanceProfile.html
     *
     * @param resourceId - Identifier for the resourceId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     *
     * Possible condition keys:
     *  - aws:ResourceTag/${TagKey}
     */
    onInstanceprofile(resourceId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type vpceconfiguration to the statement
     *
     * https://docs.aws.amazon.com/devicefarm/latest/APIReference/API_VPCEConfiguration.html
     *
     * @param resourceId - Identifier for the resourceId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     *
     * Possible condition keys:
     *  - aws:ResourceTag/${TagKey}
     */
    onVpceconfiguration(resourceId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type testgrid-project to the statement
     *
     * https://docs.aws.amazon.com/devicefarm/latest/APIReference/API_TestGridProject.html
     *
     * @param resourceId - Identifier for the resourceId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     *
     * Possible condition keys:
     *  - aws:ResourceTag/${TagKey}
     */
    onTestgridProject(resourceId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type testgrid-session to the statement
     *
     * https://docs.aws.amazon.com/devicefarm/latest/APIReference/API_TestGridSession.html
     *
     * @param resourceId - Identifier for the resourceId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     *
     * Possible condition keys:
     *  - aws:ResourceTag/${TagKey}
     */
    onTestgridSession(resourceId: string, account?: string, region?: string, partition?: string): this;
}
