import { Actions, PolicyStatement, ResourceTypes } from "../shared";
import { PolicyStatementProps } from "@aws-cdk/aws-iam";
/**
 * Action provider for service mediastore
 *
 * https://docs.aws.amazon.com/IAM/latest/UserGuide/list_awselementalmediastore.html
 */
export declare class Mediastore extends PolicyStatement {
    servicePrefix: string;
    actions: Actions;
    resourceTypes: ResourceTypes;
    /**
     * Action provider for service mediastore
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/list_awselementalmediastore.html
     */
    constructor(props?: PolicyStatementProps);
    /**
     * Grants permission to create containers.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/mediastore/latest/apireference/API_CreateContainer.html
     */
    createContainer(): this;
    /**
     * Grants permission to delete any container in the current account.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/mediastore/latest/apireference/API_DeleteContainer.html
     */
    deleteContainer(): this;
    /**
     * Grants permission to delete the access policy of any container in the current account.
     *
     * Access Level: Permissions management
     *
     * https://docs.aws.amazon.com/mediastore/latest/apireference/API_DeleteContainerPolicy.html
     */
    deleteContainerPolicy(): this;
    /**
     * Grants permission to delete the CORS policy from any container in the current account.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/mediastore/latest/apireference/API_DeleteCorsPolicy.html
     */
    deleteCorsPolicy(): this;
    /**
     * Grants permission to delete the lifecycle policy from any container in the current account.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/mediastore/latest/apireference/API_DeleteLifecyclePolicy.html
     */
    deleteLifecyclePolicy(): this;
    /**
     * Grants permission to delete the metric policy from any container in the current account.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/mediastore/latest/apireference/API_DeleteMetricPolicy.html
     */
    deleteMetricPolicy(): this;
    /**
     * Grants permission to delete objects.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/mediastore/latest/apireference/API_objstore_DeleteObject.html
     */
    deleteObject(): this;
    /**
     * Grants permission to retrieve details on any container in the current account.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/mediastore/latest/apireference/API_DescribeContainer.html
     */
    describeContainer(): this;
    /**
     * Grants permission to retrieve object metadata.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/mediastore/latest/apireference/API_objstore_DescribeObject.html
     */
    describeObject(): this;
    /**
     * Grants permission to retrieve the access policy of any container in the current account.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/mediastore/latest/apireference/API_GetContainerPolicy.html
     */
    getContainerPolicy(): this;
    /**
     * Grants permission to retrieve the CORS policy of any container in the current account.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/mediastore/latest/apireference/API_GetCorsPolicy.html
     */
    getCorsPolicy(): this;
    /**
     * Grants permission to retrieve the lifecycle policy that is assigned to any container in the current account.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/mediastore/latest/apireference/API_GetLifecyclePolicy.html
     */
    getLifecyclePolicy(): this;
    /**
     * Grants permission to retrieve the metric policy that is assigned to any container in the current account.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/mediastore/latest/apireference/API_GetMetricPolicy.html
     */
    getMetricPolicy(): this;
    /**
     * Grants permission to retrieve objects.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/mediastore/latest/apireference/API_objstore_GetObject.html
     */
    getObject(): this;
    /**
     * Grants permission to retrieve a list of containers in the current account.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/mediastore/latest/apireference/API_ListContainers.html
     */
    listContainers(): this;
    /**
     * Grants permission to retrieve a list of objects and folders in the current account.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/mediastore/latest/apireference/API_objstore_ListItems.html
     */
    listItems(): this;
    /**
     * Grants permission to list tags on any container in the current account.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/mediastore/latest/apireference/API_ListTagsForResource.html
     */
    listTagsForResource(): this;
    /**
     * Grants permission to create or replace the access policy of any container in the current account.
     *
     * Access Level: Permissions management
     *
     * https://docs.aws.amazon.com/mediastore/latest/apireference/API_PutContainerPolicy.html
     */
    putContainerPolicy(): this;
    /**
     * Grants permission to add or modify the CORS policy of any container in the current account.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/mediastore/latest/apireference/API_PutCorsPolicy.html
     */
    putCorsPolicy(): this;
    /**
     * Grants permission to add or modify the lifecycle policy that is assigned to any container in the current account.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/mediastore/latest/apireference/API_PutLifecyclePolicy.html
     */
    putLifecyclePolicy(): this;
    /**
     * Grants permission to add or modify the metric policy that is assigned to any container in the current account.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/mediastore/latest/apireference/API_PutMetricPolicy.html
     */
    putMetricPolicy(): this;
    /**
     * Grants permission to upload objects.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/mediastore/latest/apireference/API_objstore_PutObject.html
     */
    putObject(): this;
    /**
     * Grants permission to enable access logging on any container in the current account.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/mediastore/latest/apireference/API_StartAccessLogging.html
     */
    startAccessLogging(): this;
    /**
     * Grants permission to disable access logging on any container in the current account.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/mediastore/latest/apireference/API_StopAccessLogging.html
     */
    stopAccessLogging(): this;
    /**
     * Grants permission to add tags to any container in the current account.
     *
     * Access Level: Tagging
     *
     * https://docs.aws.amazon.com/mediastore/latest/apireference/API_TagResource.html
     */
    tagResource(): this;
    /**
     * Grants permission to remove tags from any container in the current account.
     *
     * Access Level: Tagging
     *
     * https://docs.aws.amazon.com/mediastore/latest/apireference/API_UntagResource.html
     */
    untagResource(): this;
    /**
     * Adds a resource of type container to the statement
     *
     * https://docs.aws.amazon.com/mediastore/latest/ug/containers.html
     *
     * @param containerName - Identifier for the containerName.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     */
    onContainer(containerName: string, account?: string, region?: string, partition?: string): this;
}
