"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const shared_1 = require("../shared");
/**
 * Action provider for service importexport
 *
 * https://docs.aws.amazon.com/IAM/latest/UserGuide/list_awsimportexportdiskservice.html
 */
class Importexport extends shared_1.PolicyStatement {
    /**
     * Action provider for service importexport
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/list_awsimportexportdiskservice.html
     */
    constructor(props) {
        super(props);
        this.servicePrefix = 'importexport';
        this.actions = {
            "CancelJob": {
                "url": "https://docs.aws.amazon.com/AWSImportExport/latest/DG/WebCancelJob.html",
                "description": "This action cancels a specified job. Only the job owner can cancel it. The action fails if the job has already started or is complete.",
                "accessLevel": "Write"
            },
            "CreateJob": {
                "url": "https://docs.aws.amazon.com/AWSImportExport/latest/DG/WebCreateJob.html",
                "description": "This action initiates the process of scheduling an upload or download of your data.",
                "accessLevel": "Write"
            },
            "GetShippingLabel": {
                "url": "https://docs.aws.amazon.com/AWSImportExport/latest/DG/WebGetShippingLabel.html",
                "description": "This action generates a pre-paid shipping label that you will use to ship your device to AWS for processing.",
                "accessLevel": "Read"
            },
            "GetStatus": {
                "url": "https://docs.aws.amazon.com/AWSImportExport/latest/DG/WebGetStatus.html",
                "description": "This action returns information about a job, including where the job is in the processing pipeline, the status of the results, and the signature value associated with the job.",
                "accessLevel": "Read"
            },
            "ListJobs": {
                "url": "https://docs.aws.amazon.com/AWSImportExport/latest/DG/WebListJobs.html",
                "description": "This action returns the jobs associated with the requester.",
                "accessLevel": "List"
            },
            "UpdateJob": {
                "url": "https://docs.aws.amazon.com/AWSImportExport/latest/DG/WebUpdateJob.html",
                "description": "You use this action to change the parameters specified in the original manifest file by supplying a new manifest file.",
                "accessLevel": "Write"
            }
        };
        this.resourceTypes = {};
    }
    /**
     * This action cancels a specified job. Only the job owner can cancel it. The action fails if the job has already started or is complete.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSImportExport/latest/DG/WebCancelJob.html
     */
    cancelJob() {
        this.add('importexport:CancelJob');
        return this;
    }
    /**
     * This action initiates the process of scheduling an upload or download of your data.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSImportExport/latest/DG/WebCreateJob.html
     */
    createJob() {
        this.add('importexport:CreateJob');
        return this;
    }
    /**
     * This action generates a pre-paid shipping label that you will use to ship your device to AWS for processing.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/AWSImportExport/latest/DG/WebGetShippingLabel.html
     */
    getShippingLabel() {
        this.add('importexport:GetShippingLabel');
        return this;
    }
    /**
     * This action returns information about a job, including where the job is in the processing pipeline, the status of the results, and the signature value associated with the job.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/AWSImportExport/latest/DG/WebGetStatus.html
     */
    getStatus() {
        this.add('importexport:GetStatus');
        return this;
    }
    /**
     * This action returns the jobs associated with the requester.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/AWSImportExport/latest/DG/WebListJobs.html
     */
    listJobs() {
        this.add('importexport:ListJobs');
        return this;
    }
    /**
     * You use this action to change the parameters specified in the original manifest file by supplying a new manifest file.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSImportExport/latest/DG/WebUpdateJob.html
     */
    updateJob() {
        this.add('importexport:UpdateJob');
        return this;
    }
}
exports.Importexport = Importexport;
//# sourceMappingURL=data:application/json;base64,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