import { Actions, PolicyStatement, ResourceTypes } from "../shared";
import { PolicyStatementProps } from "@aws-cdk/aws-iam";
/**
 * Action provider for service iot-device-tester
 *
 * https://docs.aws.amazon.com/IAM/latest/UserGuide/list_awsiotdevicetester.html
 */
export declare class IotDeviceTester extends PolicyStatement {
    servicePrefix: string;
    actions: Actions;
    resourceTypes: ResourceTypes;
    /**
     * Action provider for service iot-device-tester
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/list_awsiotdevicetester.html
     */
    constructor(props?: PolicyStatementProps);
    /**
     * Grants permission for IoT Device Tester to check if a given set of product, test suite and device tester version are compatible
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/freertos/latest/userguide/dev-tester-prereqs.html
     */
    checkVersion(): this;
    /**
     * Grants permission for IoT Device Tester to download compatible test suite versions
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/freertos/latest/userguide/dev-tester-prereqs.html
     */
    downloadTestSuite(): this;
    /**
     * Grants permission for IoT Device Tester to get information on latest version of device tester available
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/freertos/latest/userguide/dev-tester-prereqs.html
     */
    latestIdt(): this;
    /**
     * Grants permissions for IoT Device Tester to send usage metrics on your behalf
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/freertos/latest/userguide/dev-tester-prereqs.html
     */
    sendMetrics(): this;
    /**
     * Grants permission for IoT Device Tester to get list of supported products and test suite versions
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/freertos/latest/userguide/dev-tester-prereqs.html
     */
    supportedVersion(): this;
}
