"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const shared_1 = require("../shared");
/**
 * Action provider for service iot-device-tester
 *
 * https://docs.aws.amazon.com/IAM/latest/UserGuide/list_awsiotdevicetester.html
 */
class IotDeviceTester extends shared_1.PolicyStatement {
    /**
     * Action provider for service iot-device-tester
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/list_awsiotdevicetester.html
     */
    constructor(props) {
        super(props);
        this.servicePrefix = 'iot-device-tester';
        this.actions = {
            "CheckVersion": {
                "url": "https://docs.aws.amazon.com/freertos/latest/userguide/dev-tester-prereqs.html",
                "description": "Grants permission for IoT Device Tester to check if a given set of product, test suite and device tester version are compatible",
                "accessLevel": "Read"
            },
            "DownloadTestSuite": {
                "url": "https://docs.aws.amazon.com/freertos/latest/userguide/dev-tester-prereqs.html",
                "description": "Grants permission for IoT Device Tester to download compatible test suite versions",
                "accessLevel": "Read"
            },
            "LatestIdt": {
                "url": "https://docs.aws.amazon.com/freertos/latest/userguide/dev-tester-prereqs.html",
                "description": "Grants permission for IoT Device Tester to get information on latest version of device tester available",
                "accessLevel": "Read"
            },
            "SendMetrics": {
                "url": "https://docs.aws.amazon.com/freertos/latest/userguide/dev-tester-prereqs.html",
                "description": "Grants permissions for IoT Device Tester to send usage metrics on your behalf",
                "accessLevel": "Write"
            },
            "SupportedVersion": {
                "url": "https://docs.aws.amazon.com/freertos/latest/userguide/dev-tester-prereqs.html",
                "description": "Grants permission for IoT Device Tester to get list of supported products and test suite versions",
                "accessLevel": "Read"
            }
        };
        this.resourceTypes = {};
    }
    /**
     * Grants permission for IoT Device Tester to check if a given set of product, test suite and device tester version are compatible
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/freertos/latest/userguide/dev-tester-prereqs.html
     */
    checkVersion() {
        this.add('iot-device-tester:CheckVersion');
        return this;
    }
    /**
     * Grants permission for IoT Device Tester to download compatible test suite versions
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/freertos/latest/userguide/dev-tester-prereqs.html
     */
    downloadTestSuite() {
        this.add('iot-device-tester:DownloadTestSuite');
        return this;
    }
    /**
     * Grants permission for IoT Device Tester to get information on latest version of device tester available
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/freertos/latest/userguide/dev-tester-prereqs.html
     */
    latestIdt() {
        this.add('iot-device-tester:LatestIdt');
        return this;
    }
    /**
     * Grants permissions for IoT Device Tester to send usage metrics on your behalf
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/freertos/latest/userguide/dev-tester-prereqs.html
     */
    sendMetrics() {
        this.add('iot-device-tester:SendMetrics');
        return this;
    }
    /**
     * Grants permission for IoT Device Tester to get list of supported products and test suite versions
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/freertos/latest/userguide/dev-tester-prereqs.html
     */
    supportedVersion() {
        this.add('iot-device-tester:SupportedVersion');
        return this;
    }
}
exports.IotDeviceTester = IotDeviceTester;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiYXdzaW90ZGV2aWNldGVzdGVyLmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiYXdzaW90ZGV2aWNldGVzdGVyLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7O0FBQUEsc0NBQW9FO0FBR3BFOzs7O0dBSUc7QUFDSCxNQUFhLGVBQWdCLFNBQVEsd0JBQWU7SUErQmxEOzs7O09BSUc7SUFDSCxZQUFhLEtBQTRCO1FBQ3ZDLEtBQUssQ0FBQyxLQUFLLENBQUMsQ0FBQztRQXBDUixrQkFBYSxHQUFHLG1CQUFtQixDQUFDO1FBQ3BDLFlBQU8sR0FBWTtZQUN4QixjQUFjLEVBQUU7Z0JBQ2QsS0FBSyxFQUFFLCtFQUErRTtnQkFDdEYsYUFBYSxFQUFFLGlJQUFpSTtnQkFDaEosYUFBYSxFQUFFLE1BQU07YUFDdEI7WUFDRCxtQkFBbUIsRUFBRTtnQkFDbkIsS0FBSyxFQUFFLCtFQUErRTtnQkFDdEYsYUFBYSxFQUFFLG9GQUFvRjtnQkFDbkcsYUFBYSxFQUFFLE1BQU07YUFDdEI7WUFDRCxXQUFXLEVBQUU7Z0JBQ1gsS0FBSyxFQUFFLCtFQUErRTtnQkFDdEYsYUFBYSxFQUFFLHlHQUF5RztnQkFDeEgsYUFBYSxFQUFFLE1BQU07YUFDdEI7WUFDRCxhQUFhLEVBQUU7Z0JBQ2IsS0FBSyxFQUFFLCtFQUErRTtnQkFDdEYsYUFBYSxFQUFFLCtFQUErRTtnQkFDOUYsYUFBYSxFQUFFLE9BQU87YUFDdkI7WUFDRCxrQkFBa0IsRUFBRTtnQkFDbEIsS0FBSyxFQUFFLCtFQUErRTtnQkFDdEYsYUFBYSxFQUFFLG1HQUFtRztnQkFDbEgsYUFBYSxFQUFFLE1BQU07YUFDdEI7U0FDRixDQUFDO1FBQ0ssa0JBQWEsR0FBa0IsRUFBRSxDQUFDO0lBU3pDLENBQUM7SUFFRDs7Ozs7O09BTUc7SUFDSSxZQUFZO1FBQ2pCLElBQUksQ0FBQyxHQUFHLENBQUMsZ0NBQWdDLENBQUMsQ0FBQztRQUMzQyxPQUFPLElBQUksQ0FBQztJQUNkLENBQUM7SUFFRDs7Ozs7O09BTUc7SUFDSSxpQkFBaUI7UUFDdEIsSUFBSSxDQUFDLEdBQUcsQ0FBQyxxQ0FBcUMsQ0FBQyxDQUFDO1FBQ2hELE9BQU8sSUFBSSxDQUFDO0lBQ2QsQ0FBQztJQUVEOzs7Ozs7T0FNRztJQUNJLFNBQVM7UUFDZCxJQUFJLENBQUMsR0FBRyxDQUFDLDZCQUE2QixDQUFDLENBQUM7UUFDeEMsT0FBTyxJQUFJLENBQUM7SUFDZCxDQUFDO0lBRUQ7Ozs7OztPQU1HO0lBQ0ksV0FBVztRQUNoQixJQUFJLENBQUMsR0FBRyxDQUFDLCtCQUErQixDQUFDLENBQUM7UUFDMUMsT0FBTyxJQUFJLENBQUM7SUFDZCxDQUFDO0lBRUQ7Ozs7OztPQU1HO0lBQ0ksZ0JBQWdCO1FBQ3JCLElBQUksQ0FBQyxHQUFHLENBQUMsb0NBQW9DLENBQUMsQ0FBQztRQUMvQyxPQUFPLElBQUksQ0FBQztJQUNkLENBQUM7Q0FDRjtBQW5HRCwwQ0FtR0MiLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgeyBBY3Rpb25zLCBQb2xpY3lTdGF0ZW1lbnQsIFJlc291cmNlVHlwZXMgfSBmcm9tIFwiLi4vc2hhcmVkXCI7XG5pbXBvcnQgeyBQb2xpY3lTdGF0ZW1lbnRQcm9wcyB9IGZyb20gXCJAYXdzLWNkay9hd3MtaWFtXCI7XG5cbi8qKlxuICogQWN0aW9uIHByb3ZpZGVyIGZvciBzZXJ2aWNlIGlvdC1kZXZpY2UtdGVzdGVyXG4gKlxuICogaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0lBTS9sYXRlc3QvVXNlckd1aWRlL2xpc3RfYXdzaW90ZGV2aWNldGVzdGVyLmh0bWxcbiAqL1xuZXhwb3J0IGNsYXNzIElvdERldmljZVRlc3RlciBleHRlbmRzIFBvbGljeVN0YXRlbWVudCB7XG4gIHB1YmxpYyBzZXJ2aWNlUHJlZml4ID0gJ2lvdC1kZXZpY2UtdGVzdGVyJztcbiAgcHVibGljIGFjdGlvbnM6IEFjdGlvbnMgPSB7XG4gICAgXCJDaGVja1ZlcnNpb25cIjoge1xuICAgICAgXCJ1cmxcIjogXCJodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vZnJlZXJ0b3MvbGF0ZXN0L3VzZXJndWlkZS9kZXYtdGVzdGVyLXByZXJlcXMuaHRtbFwiLFxuICAgICAgXCJkZXNjcmlwdGlvblwiOiBcIkdyYW50cyBwZXJtaXNzaW9uIGZvciBJb1QgRGV2aWNlIFRlc3RlciB0byBjaGVjayBpZiBhIGdpdmVuIHNldCBvZiBwcm9kdWN0LCB0ZXN0IHN1aXRlIGFuZCBkZXZpY2UgdGVzdGVyIHZlcnNpb24gYXJlIGNvbXBhdGlibGVcIixcbiAgICAgIFwiYWNjZXNzTGV2ZWxcIjogXCJSZWFkXCJcbiAgICB9LFxuICAgIFwiRG93bmxvYWRUZXN0U3VpdGVcIjoge1xuICAgICAgXCJ1cmxcIjogXCJodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vZnJlZXJ0b3MvbGF0ZXN0L3VzZXJndWlkZS9kZXYtdGVzdGVyLXByZXJlcXMuaHRtbFwiLFxuICAgICAgXCJkZXNjcmlwdGlvblwiOiBcIkdyYW50cyBwZXJtaXNzaW9uIGZvciBJb1QgRGV2aWNlIFRlc3RlciB0byBkb3dubG9hZCBjb21wYXRpYmxlIHRlc3Qgc3VpdGUgdmVyc2lvbnNcIixcbiAgICAgIFwiYWNjZXNzTGV2ZWxcIjogXCJSZWFkXCJcbiAgICB9LFxuICAgIFwiTGF0ZXN0SWR0XCI6IHtcbiAgICAgIFwidXJsXCI6IFwiaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL2ZyZWVydG9zL2xhdGVzdC91c2VyZ3VpZGUvZGV2LXRlc3Rlci1wcmVyZXFzLmh0bWxcIixcbiAgICAgIFwiZGVzY3JpcHRpb25cIjogXCJHcmFudHMgcGVybWlzc2lvbiBmb3IgSW9UIERldmljZSBUZXN0ZXIgdG8gZ2V0IGluZm9ybWF0aW9uIG9uIGxhdGVzdCB2ZXJzaW9uIG9mIGRldmljZSB0ZXN0ZXIgYXZhaWxhYmxlXCIsXG4gICAgICBcImFjY2Vzc0xldmVsXCI6IFwiUmVhZFwiXG4gICAgfSxcbiAgICBcIlNlbmRNZXRyaWNzXCI6IHtcbiAgICAgIFwidXJsXCI6IFwiaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL2ZyZWVydG9zL2xhdGVzdC91c2VyZ3VpZGUvZGV2LXRlc3Rlci1wcmVyZXFzLmh0bWxcIixcbiAgICAgIFwiZGVzY3JpcHRpb25cIjogXCJHcmFudHMgcGVybWlzc2lvbnMgZm9yIElvVCBEZXZpY2UgVGVzdGVyIHRvIHNlbmQgdXNhZ2UgbWV0cmljcyBvbiB5b3VyIGJlaGFsZlwiLFxuICAgICAgXCJhY2Nlc3NMZXZlbFwiOiBcIldyaXRlXCJcbiAgICB9LFxuICAgIFwiU3VwcG9ydGVkVmVyc2lvblwiOiB7XG4gICAgICBcInVybFwiOiBcImh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9mcmVlcnRvcy9sYXRlc3QvdXNlcmd1aWRlL2Rldi10ZXN0ZXItcHJlcmVxcy5odG1sXCIsXG4gICAgICBcImRlc2NyaXB0aW9uXCI6IFwiR3JhbnRzIHBlcm1pc3Npb24gZm9yIElvVCBEZXZpY2UgVGVzdGVyIHRvIGdldCBsaXN0IG9mIHN1cHBvcnRlZCBwcm9kdWN0cyBhbmQgdGVzdCBzdWl0ZSB2ZXJzaW9uc1wiLFxuICAgICAgXCJhY2Nlc3NMZXZlbFwiOiBcIlJlYWRcIlxuICAgIH1cbiAgfTtcbiAgcHVibGljIHJlc291cmNlVHlwZXM6IFJlc291cmNlVHlwZXMgPSB7fTtcblxuICAvKipcbiAgICogQWN0aW9uIHByb3ZpZGVyIGZvciBzZXJ2aWNlIGlvdC1kZXZpY2UtdGVzdGVyXG4gICAqXG4gICAqIGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9JQU0vbGF0ZXN0L1VzZXJHdWlkZS9saXN0X2F3c2lvdGRldmljZXRlc3Rlci5odG1sXG4gICAqL1xuICBjb25zdHJ1Y3RvciAocHJvcHM/OiBQb2xpY3lTdGF0ZW1lbnRQcm9wcykge1xuICAgIHN1cGVyKHByb3BzKTtcbiAgfVxuXG4gIC8qKlxuICAgKiBHcmFudHMgcGVybWlzc2lvbiBmb3IgSW9UIERldmljZSBUZXN0ZXIgdG8gY2hlY2sgaWYgYSBnaXZlbiBzZXQgb2YgcHJvZHVjdCwgdGVzdCBzdWl0ZSBhbmQgZGV2aWNlIHRlc3RlciB2ZXJzaW9uIGFyZSBjb21wYXRpYmxlXG4gICAqXG4gICAqIEFjY2VzcyBMZXZlbDogUmVhZFxuICAgKlxuICAgKiBodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vZnJlZXJ0b3MvbGF0ZXN0L3VzZXJndWlkZS9kZXYtdGVzdGVyLXByZXJlcXMuaHRtbFxuICAgKi9cbiAgcHVibGljIGNoZWNrVmVyc2lvbigpIHtcbiAgICB0aGlzLmFkZCgnaW90LWRldmljZS10ZXN0ZXI6Q2hlY2tWZXJzaW9uJyk7XG4gICAgcmV0dXJuIHRoaXM7XG4gIH1cblxuICAvKipcbiAgICogR3JhbnRzIHBlcm1pc3Npb24gZm9yIElvVCBEZXZpY2UgVGVzdGVyIHRvIGRvd25sb2FkIGNvbXBhdGlibGUgdGVzdCBzdWl0ZSB2ZXJzaW9uc1xuICAgKlxuICAgKiBBY2Nlc3MgTGV2ZWw6IFJlYWRcbiAgICpcbiAgICogaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL2ZyZWVydG9zL2xhdGVzdC91c2VyZ3VpZGUvZGV2LXRlc3Rlci1wcmVyZXFzLmh0bWxcbiAgICovXG4gIHB1YmxpYyBkb3dubG9hZFRlc3RTdWl0ZSgpIHtcbiAgICB0aGlzLmFkZCgnaW90LWRldmljZS10ZXN0ZXI6RG93bmxvYWRUZXN0U3VpdGUnKTtcbiAgICByZXR1cm4gdGhpcztcbiAgfVxuXG4gIC8qKlxuICAgKiBHcmFudHMgcGVybWlzc2lvbiBmb3IgSW9UIERldmljZSBUZXN0ZXIgdG8gZ2V0IGluZm9ybWF0aW9uIG9uIGxhdGVzdCB2ZXJzaW9uIG9mIGRldmljZSB0ZXN0ZXIgYXZhaWxhYmxlXG4gICAqXG4gICAqIEFjY2VzcyBMZXZlbDogUmVhZFxuICAgKlxuICAgKiBodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vZnJlZXJ0b3MvbGF0ZXN0L3VzZXJndWlkZS9kZXYtdGVzdGVyLXByZXJlcXMuaHRtbFxuICAgKi9cbiAgcHVibGljIGxhdGVzdElkdCgpIHtcbiAgICB0aGlzLmFkZCgnaW90LWRldmljZS10ZXN0ZXI6TGF0ZXN0SWR0Jyk7XG4gICAgcmV0dXJuIHRoaXM7XG4gIH1cblxuICAvKipcbiAgICogR3JhbnRzIHBlcm1pc3Npb25zIGZvciBJb1QgRGV2aWNlIFRlc3RlciB0byBzZW5kIHVzYWdlIG1ldHJpY3Mgb24geW91ciBiZWhhbGZcbiAgICpcbiAgICogQWNjZXNzIExldmVsOiBXcml0ZVxuICAgKlxuICAgKiBodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vZnJlZXJ0b3MvbGF0ZXN0L3VzZXJndWlkZS9kZXYtdGVzdGVyLXByZXJlcXMuaHRtbFxuICAgKi9cbiAgcHVibGljIHNlbmRNZXRyaWNzKCkge1xuICAgIHRoaXMuYWRkKCdpb3QtZGV2aWNlLXRlc3RlcjpTZW5kTWV0cmljcycpO1xuICAgIHJldHVybiB0aGlzO1xuICB9XG5cbiAgLyoqXG4gICAqIEdyYW50cyBwZXJtaXNzaW9uIGZvciBJb1QgRGV2aWNlIFRlc3RlciB0byBnZXQgbGlzdCBvZiBzdXBwb3J0ZWQgcHJvZHVjdHMgYW5kIHRlc3Qgc3VpdGUgdmVyc2lvbnNcbiAgICpcbiAgICogQWNjZXNzIExldmVsOiBSZWFkXG4gICAqXG4gICAqIGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9mcmVlcnRvcy9sYXRlc3QvdXNlcmd1aWRlL2Rldi10ZXN0ZXItcHJlcmVxcy5odG1sXG4gICAqL1xuICBwdWJsaWMgc3VwcG9ydGVkVmVyc2lvbigpIHtcbiAgICB0aGlzLmFkZCgnaW90LWRldmljZS10ZXN0ZXI6U3VwcG9ydGVkVmVyc2lvbicpO1xuICAgIHJldHVybiB0aGlzO1xuICB9XG59XG4iXX0=