import { Actions, PolicyStatement, ResourceTypes } from "../shared";
import { PolicyStatementProps } from "@aws-cdk/aws-iam";
/**
 * Action provider for service iq-permission
 *
 * https://docs.aws.amazon.com/IAM/latest/UserGuide/list_awsiqpermissions.html
 */
export declare class IqPermission extends PolicyStatement {
    servicePrefix: string;
    actions: Actions;
    resourceTypes: ResourceTypes;
    /**
     * Action provider for service iq-permission
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/list_awsiqpermissions.html
     */
    constructor(props?: PolicyStatementProps);
    /**
     * Grants permission to approve an access grant
     *
     * Access Level: Write
     *
     * https://aws.amazon.com/iq/
     */
    approveAccessGrant(): this;
}
