"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const shared_1 = require("../shared");
/**
 * Action provider for service aws-marketplace-procurement-systems-integration
 *
 * https://docs.aws.amazon.com/IAM/latest/UserGuide/list_awsmarketplaceprocurementsystemsintegration.html
 */
class AwsMarketplaceProcurementSystemsIntegration extends shared_1.PolicyStatement {
    /**
     * Action provider for service aws-marketplace-procurement-systems-integration
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/list_awsmarketplaceprocurementsystemsintegration.html
     */
    constructor(props) {
        super(props);
        this.servicePrefix = 'aws-marketplace-procurement-systems-integration';
        this.actions = {
            "DescribeProcurementSystemConfiguration": {
                "url": "https://docs.aws.amazon.com/marketplace/latest/buyerguide/procurement-systems-integration.html",
                "description": "Describes the Procurement System integration configuration (e.g. Coupa) for the individual account, or for the entire AWS Organization if one exists. This action can only be performed by the master account if using an AWS Organization.",
                "accessLevel": "Read"
            },
            "PutProcurementSystemConfiguration": {
                "url": "https://docs.aws.amazon.com/marketplace/latest/buyerguide/procurement-systems-integration.html",
                "description": "Creates or updates the Procurement System integration configuration (e.g. Coupa) for the individual account, or for the entire AWS Organization if one exists. This action can only be performed by the master account if using an AWS Organization.",
                "accessLevel": "Write"
            }
        };
        this.resourceTypes = {};
    }
    /**
     * Describes the Procurement System integration configuration (e.g. Coupa) for the individual account, or for the entire AWS Organization if one exists. This action can only be performed by the master account if using an AWS Organization.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/marketplace/latest/buyerguide/procurement-systems-integration.html
     */
    describeProcurementSystemConfiguration() {
        this.add('aws-marketplace-procurement-systems-integration:DescribeProcurementSystemConfiguration');
        return this;
    }
    /**
     * Creates or updates the Procurement System integration configuration (e.g. Coupa) for the individual account, or for the entire AWS Organization if one exists. This action can only be performed by the master account if using an AWS Organization.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/marketplace/latest/buyerguide/procurement-systems-integration.html
     */
    putProcurementSystemConfiguration() {
        this.add('aws-marketplace-procurement-systems-integration:PutProcurementSystemConfiguration');
        return this;
    }
}
exports.AwsMarketplaceProcurementSystemsIntegration = AwsMarketplaceProcurementSystemsIntegration;
//# sourceMappingURL=data:application/json;base64,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