"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const shared_1 = require("../shared");
/**
 * Action provider for service aws-marketplace-private
 *
 * https://docs.aws.amazon.com/IAM/latest/UserGuide/list_awsprivatemarketplace.html
 */
class AwsMarketplacePrivate extends shared_1.PolicyStatement {
    /**
     * Action provider for service aws-marketplace-private
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/list_awsprivatemarketplace.html
     */
    constructor(props) {
        super(props);
        this.servicePrefix = 'aws-marketplace-private';
        this.actions = {
            "AssociateProductsWithPrivateMarketplace": {
                "url": "https://docs.aws.amazon.com/marketplace/latest/buyerguide/private-marketplace.html",
                "description": "Adds new approved products to the Private Marketplace. Also allows to approve a request for a product to be associated with the Private Marketplace. This action can be performed by any account in an AWS Organization, provided the user has permissions to do so, and the Organization's Service Control Policies allow it.",
                "accessLevel": "Write"
            },
            "CreatePrivateMarketplace": {
                "url": "https://docs.aws.amazon.com/marketplace/latest/buyerguide/private-marketplace.html",
                "description": "Creates a Private Marketplace for the individual account, or for the entire AWS Organization if one exists. This action can only be performed by the master account if using an AWS Organization.",
                "accessLevel": "Write"
            },
            "CreatePrivateMarketplaceProfile": {
                "url": "https://docs.aws.amazon.com/marketplace/latest/buyerguide/private-marketplace.html",
                "description": "Creates a Private Marketplace Profile that customizes the white label experience on the AWS Marketplace website for the individual account, or for the entire AWS Organization if one exists. This action can only be performed by the master account if using an AWS Organization.",
                "accessLevel": "Write"
            },
            "CreatePrivateMarketplaceRequests": {
                "url": "https://docs.aws.amazon.com/marketplace/latest/buyerguide/private-marketplace.html",
                "description": "Creates a new request for a product or products to be associated with the Private Marketplace. This action can be performed by any account in an in an AWS Organization, provided the user has permissions to do so, and the Organization's Service Control Policies allow it.",
                "accessLevel": "Write"
            },
            "DescribePrivateMarketplaceProducts": {
                "url": "https://docs.aws.amazon.com/marketplace/latest/buyerguide/private-marketplace.html",
                "description": "Describes the status of requested products in the Private Marketplace for administrative purposes. This action can be performed by any account in an AWS Organization, provided the user has permissions to do so, and the Organization's Service Control Policies allow it.",
                "accessLevel": "List"
            },
            "DescribePrivateMarketplaceProfile": {
                "url": "https://docs.aws.amazon.com/marketplace/latest/buyerguide/private-marketplace.html",
                "description": "Describes details about the Private Marketplace Profile for administrative purposes. This action can be performed by any account in an AWS Organization, provided the user has permissions to do so, and the Organization's Service Control Policies allow it.",
                "accessLevel": "Read"
            },
            "DescribePrivateMarketplaceRequests": {
                "url": "https://docs.aws.amazon.com/marketplace/latest/buyerguide/private-marketplace.html",
                "description": "Describes requests and associated products in the Private Marketplace. This action can be performed by any account in an AWS Organization, provided the user has permissions to do so, and the Organization's Service Control Policies allow it.",
                "accessLevel": "List"
            },
            "DescribePrivateMarketplaceSettings": {
                "url": "https://docs.aws.amazon.com/marketplace/latest/buyerguide/private-marketplace.html",
                "description": "Describes the Private Marketplace settings. This includes setting for enabling requests from end users and preferences for notifications. This action can be performed by any account in an AWS Organization, provided the user has permissions to do so, and the Organization's Service Control Policies allow it.",
                "accessLevel": "Read"
            },
            "DescribePrivateMarketplaceStatus": {
                "url": "https://docs.aws.amazon.com/marketplace/latest/buyerguide/private-marketplace.html",
                "description": "Describes the status of the Private Marketplace for administrative purposes. This action can be performed by any account in an AWS Organization, provided the user has permissions to do so, and the Organization's Service Control Policies allow it.",
                "accessLevel": "Read"
            },
            "DisassociateProductsFromPrivateMarketplace": {
                "url": "https://docs.aws.amazon.com/marketplace/latest/buyerguide/private-marketplace.html",
                "description": "Removes approved products from the Private Marketplace. Also allows to decline a request for a product to be associated with the Private Marketplace. This action can be performed by any account in an AWS Organization, provided the user has permissions to do so, and the Organization's Service Control Policies allow it.",
                "accessLevel": "Write"
            },
            "ListPrivateMarketplaceProducts": {
                "url": "https://docs.aws.amazon.com/marketplace/latest/buyerguide/private-marketplace.html",
                "description": "Queryable list for the products and status of products in the Private Marketplace for administrative purposes. This action can be performed by any account in an AWS Organization, provided the user has permissions to do so, and the Organization's Service Control Policies allow it.",
                "accessLevel": "List"
            },
            "ListPrivateMarketplaceRequests": {
                "url": "https://docs.aws.amazon.com/marketplace/latest/buyerguide/private-marketplace.html",
                "description": "Queryable list for requests and associated products in the Private Marketplace. This action can be performed by any account in an AWS Organization, provided the user has permissions to do so, and the Organization's Service Control Policies allow it.",
                "accessLevel": "List"
            },
            "StartPrivateMarketplace": {
                "url": "https://docs.aws.amazon.com/marketplace/latest/buyerguide/private-marketplace.html",
                "description": "Starts the Private Marketplace, enabling the customized AWS Marketplace experience, and enabling restrictions on the procurement of products based on what is available in the Private Marketplace. This action can be performed by any account in an AWS Organization, provided the user has permissions to do so, and the Organization's Service Control Policies allow it.",
                "accessLevel": "Write"
            },
            "StopPrivateMarketplace": {
                "url": "https://docs.aws.amazon.com/marketplace/latest/buyerguide/private-marketplace.html",
                "description": "Stops the Private Marketplace, disabling the customized AWS Marketplace experience and removing the Private Marketplace procurement restrictions on products. This action can be performed by any account in an AWS Organization, provided the user has permissions to do so, and the Organization's Service Control Policies allow it.",
                "accessLevel": "Write"
            },
            "UpdatePrivateMarketplaceProfile": {
                "url": "https://docs.aws.amazon.com/marketplace/latest/buyerguide/private-marketplace.html",
                "description": "Updates the Private Marketplace Profile that customizes the white label experience on the AWS Marketplace website for the individual account, or for the entire AWS Organization if one exists. This action can be performed by any account in an AWS Organization, provided the user has permissions to do so, and the Organization's Service Control Policies allow it.",
                "accessLevel": "Write"
            },
            "UpdatePrivateMarketplaceSettings": {
                "url": "https://docs.aws.amazon.com/marketplace/latest/buyerguide/private-marketplace.html",
                "description": "Updates the Private Marketplace settings. This includes setting for enabling requests from end users and preferences for notifications. This action can be performed by any account in an AWS Organization, provided the user has permissions to do so, and the Organization's Service Control Policies allow it.",
                "accessLevel": "Write"
            }
        };
        this.resourceTypes = {};
    }
    /**
     * Adds new approved products to the Private Marketplace. Also allows to approve a request for a product to be associated with the Private Marketplace. This action can be performed by any account in an AWS Organization, provided the user has permissions to do so, and the Organization's Service Control Policies allow it.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/marketplace/latest/buyerguide/private-marketplace.html
     */
    associateProductsWithPrivateMarketplace() {
        this.add('aws-marketplace-private:AssociateProductsWithPrivateMarketplace');
        return this;
    }
    /**
     * Creates a Private Marketplace for the individual account, or for the entire AWS Organization if one exists. This action can only be performed by the master account if using an AWS Organization.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/marketplace/latest/buyerguide/private-marketplace.html
     */
    createPrivateMarketplace() {
        this.add('aws-marketplace-private:CreatePrivateMarketplace');
        return this;
    }
    /**
     * Creates a Private Marketplace Profile that customizes the white label experience on the AWS Marketplace website for the individual account, or for the entire AWS Organization if one exists. This action can only be performed by the master account if using an AWS Organization.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/marketplace/latest/buyerguide/private-marketplace.html
     */
    createPrivateMarketplaceProfile() {
        this.add('aws-marketplace-private:CreatePrivateMarketplaceProfile');
        return this;
    }
    /**
     * Creates a new request for a product or products to be associated with the Private Marketplace. This action can be performed by any account in an in an AWS Organization, provided the user has permissions to do so, and the Organization's Service Control Policies allow it.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/marketplace/latest/buyerguide/private-marketplace.html
     */
    createPrivateMarketplaceRequests() {
        this.add('aws-marketplace-private:CreatePrivateMarketplaceRequests');
        return this;
    }
    /**
     * Describes the status of requested products in the Private Marketplace for administrative purposes. This action can be performed by any account in an AWS Organization, provided the user has permissions to do so, and the Organization's Service Control Policies allow it.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/marketplace/latest/buyerguide/private-marketplace.html
     */
    describePrivateMarketplaceProducts() {
        this.add('aws-marketplace-private:DescribePrivateMarketplaceProducts');
        return this;
    }
    /**
     * Describes details about the Private Marketplace Profile for administrative purposes. This action can be performed by any account in an AWS Organization, provided the user has permissions to do so, and the Organization's Service Control Policies allow it.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/marketplace/latest/buyerguide/private-marketplace.html
     */
    describePrivateMarketplaceProfile() {
        this.add('aws-marketplace-private:DescribePrivateMarketplaceProfile');
        return this;
    }
    /**
     * Describes requests and associated products in the Private Marketplace. This action can be performed by any account in an AWS Organization, provided the user has permissions to do so, and the Organization's Service Control Policies allow it.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/marketplace/latest/buyerguide/private-marketplace.html
     */
    describePrivateMarketplaceRequests() {
        this.add('aws-marketplace-private:DescribePrivateMarketplaceRequests');
        return this;
    }
    /**
     * Describes the Private Marketplace settings. This includes setting for enabling requests from end users and preferences for notifications. This action can be performed by any account in an AWS Organization, provided the user has permissions to do so, and the Organization's Service Control Policies allow it.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/marketplace/latest/buyerguide/private-marketplace.html
     */
    describePrivateMarketplaceSettings() {
        this.add('aws-marketplace-private:DescribePrivateMarketplaceSettings');
        return this;
    }
    /**
     * Describes the status of the Private Marketplace for administrative purposes. This action can be performed by any account in an AWS Organization, provided the user has permissions to do so, and the Organization's Service Control Policies allow it.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/marketplace/latest/buyerguide/private-marketplace.html
     */
    describePrivateMarketplaceStatus() {
        this.add('aws-marketplace-private:DescribePrivateMarketplaceStatus');
        return this;
    }
    /**
     * Removes approved products from the Private Marketplace. Also allows to decline a request for a product to be associated with the Private Marketplace. This action can be performed by any account in an AWS Organization, provided the user has permissions to do so, and the Organization's Service Control Policies allow it.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/marketplace/latest/buyerguide/private-marketplace.html
     */
    disassociateProductsFromPrivateMarketplace() {
        this.add('aws-marketplace-private:DisassociateProductsFromPrivateMarketplace');
        return this;
    }
    /**
     * Queryable list for the products and status of products in the Private Marketplace for administrative purposes. This action can be performed by any account in an AWS Organization, provided the user has permissions to do so, and the Organization's Service Control Policies allow it.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/marketplace/latest/buyerguide/private-marketplace.html
     */
    listPrivateMarketplaceProducts() {
        this.add('aws-marketplace-private:ListPrivateMarketplaceProducts');
        return this;
    }
    /**
     * Queryable list for requests and associated products in the Private Marketplace. This action can be performed by any account in an AWS Organization, provided the user has permissions to do so, and the Organization's Service Control Policies allow it.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/marketplace/latest/buyerguide/private-marketplace.html
     */
    listPrivateMarketplaceRequests() {
        this.add('aws-marketplace-private:ListPrivateMarketplaceRequests');
        return this;
    }
    /**
     * Starts the Private Marketplace, enabling the customized AWS Marketplace experience, and enabling restrictions on the procurement of products based on what is available in the Private Marketplace. This action can be performed by any account in an AWS Organization, provided the user has permissions to do so, and the Organization's Service Control Policies allow it.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/marketplace/latest/buyerguide/private-marketplace.html
     */
    startPrivateMarketplace() {
        this.add('aws-marketplace-private:StartPrivateMarketplace');
        return this;
    }
    /**
     * Stops the Private Marketplace, disabling the customized AWS Marketplace experience and removing the Private Marketplace procurement restrictions on products. This action can be performed by any account in an AWS Organization, provided the user has permissions to do so, and the Organization's Service Control Policies allow it.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/marketplace/latest/buyerguide/private-marketplace.html
     */
    stopPrivateMarketplace() {
        this.add('aws-marketplace-private:StopPrivateMarketplace');
        return this;
    }
    /**
     * Updates the Private Marketplace Profile that customizes the white label experience on the AWS Marketplace website for the individual account, or for the entire AWS Organization if one exists. This action can be performed by any account in an AWS Organization, provided the user has permissions to do so, and the Organization's Service Control Policies allow it.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/marketplace/latest/buyerguide/private-marketplace.html
     */
    updatePrivateMarketplaceProfile() {
        this.add('aws-marketplace-private:UpdatePrivateMarketplaceProfile');
        return this;
    }
    /**
     * Updates the Private Marketplace settings. This includes setting for enabling requests from end users and preferences for notifications. This action can be performed by any account in an AWS Organization, provided the user has permissions to do so, and the Organization's Service Control Policies allow it.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/marketplace/latest/buyerguide/private-marketplace.html
     */
    updatePrivateMarketplaceSettings() {
        this.add('aws-marketplace-private:UpdatePrivateMarketplaceSettings');
        return this;
    }
}
exports.AwsMarketplacePrivate = AwsMarketplacePrivate;
//# sourceMappingURL=data:application/json;base64,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