import { Actions, PolicyStatement, ResourceTypes } from "../shared";
import { PolicyStatementProps } from "@aws-cdk/aws-iam";
/**
 * Action provider for service serverlessrepo
 *
 * https://docs.aws.amazon.com/IAM/latest/UserGuide/list_awsserverlessapplicationrepository.html
 */
export declare class Serverlessrepo extends PolicyStatement {
    servicePrefix: string;
    actions: Actions;
    resourceTypes: ResourceTypes;
    /**
     * Action provider for service serverlessrepo
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/list_awsserverlessapplicationrepository.html
     */
    constructor(props?: PolicyStatementProps);
    /**
     * Creates an application, optionally including an AWS SAM file to create the first application version in the same call.
     *
     * Access Level: Write
     */
    createApplication(): this;
    /**
     * Creates an application version.
     *
     * Access Level: Write
     */
    createApplicationVersion(): this;
    /**
     * Creates an AWS CloudFormation ChangeSet for the given application.
     *
     * Access Level: Write
     */
    createCloudFormationChangeSet(): this;
    /**
     * Creates an AWS CloudFormation template
     *
     * Access Level: Write
     */
    createCloudFormationTemplate(): this;
    /**
     * Deletes the specified application
     *
     * Access Level: Write
     */
    deleteApplication(): this;
    /**
     * Gets the specified application.
     *
     * Access Level: Read
     */
    getApplication(): this;
    /**
     * Gets the policy for the specified application.
     *
     * Access Level: Read
     */
    getApplicationPolicy(): this;
    /**
     * Gets the specified AWS CloudFormation template
     *
     * Access Level: Read
     */
    getCloudFormationTemplate(): this;
    /**
     * Retrieves the list of applications nested in the containing application
     *
     * Access Level: List
     */
    listApplicationDependencies(): this;
    /**
     * Lists versions for the specified application owned by the requester.
     *
     * Access Level: List
     */
    listApplicationVersions(): this;
    /**
     * Lists applications owned by the requester.
     *
     * Access Level: List
     */
    listApplications(): this;
    /**
     * Puts the policy for the specified application.
     *
     * Access Level: Write
     */
    putApplicationPolicy(): this;
    /**
     * Gets all applications authorized for this user
     *
     * Access Level: Read
     */
    searchApplications(): this;
    /**
     * Unshares the specified application
     *
     * Access Level: Write
     */
    unshareApplication(): this;
    /**
     * Updates meta-data of the application
     *
     * Access Level: Write
     */
    updateApplication(): this;
    /**
     * Adds a resource of type applications to the statement
     *
     * @param resourceId - Identifier for the resourceId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     */
    onApplications(resourceId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Application type
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifApplicationType(value: string | string[], operator?: string): this;
}
