"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const shared_1 = require("../shared");
/**
 * Action provider for service snowball
 *
 * https://docs.aws.amazon.com/IAM/latest/UserGuide/list_awssnowball.html
 */
class Snowball extends shared_1.PolicyStatement {
    /**
     * Action provider for service snowball
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/list_awssnowball.html
     */
    constructor(props) {
        super(props);
        this.servicePrefix = 'snowball';
        this.actions = {
            "CancelCluster": {
                "url": "https://docs.aws.amazon.com/snowball/latest/api-reference/API_CancelCluster.html",
                "description": "Cancels a cluster job.",
                "accessLevel": "Write"
            },
            "CancelJob": {
                "url": "https://docs.aws.amazon.com/snowball/latest/api-reference/API_CancelJob.html",
                "description": "Cancels the specified job.",
                "accessLevel": "Write"
            },
            "CreateAddress": {
                "url": "https://docs.aws.amazon.com/snowball/latest/api-reference/API_CreateAddress.html",
                "description": "Creates an address for a Snowball to be shipped to.",
                "accessLevel": "Write"
            },
            "CreateCluster": {
                "url": "https://docs.aws.amazon.com/snowball/latest/api-reference/API_CreateCluster.html",
                "description": "Creates an empty cluster.",
                "accessLevel": "Write"
            },
            "CreateJob": {
                "url": "https://docs.aws.amazon.com/snowball/latest/api-reference/API_CreateJob.html",
                "description": "Creates a job to import or export data between Amazon S3 and your on-premises data center.",
                "accessLevel": "Write"
            },
            "DescribeAddress": {
                "url": "https://docs.aws.amazon.com/snowball/latest/api-reference/API_DescribeAddress.html",
                "description": "Takes an AddressId and returns specific details about that address in the form of an Address object.",
                "accessLevel": "Read"
            },
            "DescribeAddresses": {
                "url": "https://docs.aws.amazon.com/snowball/latest/api-reference/API_DescribeAddresses.html",
                "description": "Returns a specified number of ADDRESS objects.",
                "accessLevel": "List"
            },
            "DescribeCluster": {
                "url": "https://docs.aws.amazon.com/snowball/latest/api-reference/API_DescribeCluster.html",
                "description": "Returns information about a specific cluster including shipping information, cluster status, and other important metadata.",
                "accessLevel": "Read"
            },
            "DescribeJob": {
                "url": "https://docs.aws.amazon.com/snowball/latest/api-reference/API_DescribeJob.html",
                "description": "Returns information about a specific job including shipping information, job status, and other important metadata.",
                "accessLevel": "Read"
            },
            "GetJobManifest": {
                "url": "https://docs.aws.amazon.com/snowball/latest/api-reference/API_GetJobManifest.html",
                "description": "Returns a link to an Amazon S3 presigned URL for the manifest file associated with the specified JobId value.",
                "accessLevel": "Read"
            },
            "GetJobUnlockCode": {
                "url": "https://docs.aws.amazon.com/snowball/latest/api-reference/API_GetJobUnlockCode.html",
                "description": "Returns the UnlockCode code value for the specified job.",
                "accessLevel": "Read"
            },
            "GetSnowballUsage": {
                "url": "https://docs.aws.amazon.com/snowball/latest/api-reference/API_GetSnowballUsage.html",
                "description": "Returns information about the Snowball service limit for your account, and also the number of Snowballs your account has in use.",
                "accessLevel": "Read"
            },
            "ListClusterJobs": {
                "url": "https://docs.aws.amazon.com/snowball/latest/api-reference/API_ListClusterJobs.html",
                "description": "Returns an array of JobListEntry objects of the specified length.",
                "accessLevel": "List"
            },
            "ListClusters": {
                "url": "https://docs.aws.amazon.com/snowball/latest/api-reference/API_ListClusters.html",
                "description": "Returns an array of ClusterListEntry objects of the specified length.",
                "accessLevel": "List"
            },
            "ListJobs": {
                "url": "https://docs.aws.amazon.com/snowball/latest/api-reference/API_ListJobs.html",
                "description": "Returns an array of JobListEntry objects of the specified length.",
                "accessLevel": "List"
            },
            "UpdateCluster": {
                "url": "https://docs.aws.amazon.com/snowball/latest/api-reference/API_UpdateCluster.html",
                "description": "While a cluster's ClusterState value is in the AwaitingQuorum state, you can update some of the information associated with a cluster.",
                "accessLevel": "Write"
            },
            "UpdateJob": {
                "url": "https://docs.aws.amazon.com/snowball/latest/api-reference/API_UpdateJob.html",
                "description": "While a job's JobState value is New, you can update some of the information associated with a job.",
                "accessLevel": "Write"
            }
        };
        this.resourceTypes = {};
    }
    /**
     * Cancels a cluster job.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/snowball/latest/api-reference/API_CancelCluster.html
     */
    cancelCluster() {
        this.add('snowball:CancelCluster');
        return this;
    }
    /**
     * Cancels the specified job.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/snowball/latest/api-reference/API_CancelJob.html
     */
    cancelJob() {
        this.add('snowball:CancelJob');
        return this;
    }
    /**
     * Creates an address for a Snowball to be shipped to.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/snowball/latest/api-reference/API_CreateAddress.html
     */
    createAddress() {
        this.add('snowball:CreateAddress');
        return this;
    }
    /**
     * Creates an empty cluster.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/snowball/latest/api-reference/API_CreateCluster.html
     */
    createCluster() {
        this.add('snowball:CreateCluster');
        return this;
    }
    /**
     * Creates a job to import or export data between Amazon S3 and your on-premises data center.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/snowball/latest/api-reference/API_CreateJob.html
     */
    createJob() {
        this.add('snowball:CreateJob');
        return this;
    }
    /**
     * Takes an AddressId and returns specific details about that address in the form of an Address object.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/snowball/latest/api-reference/API_DescribeAddress.html
     */
    describeAddress() {
        this.add('snowball:DescribeAddress');
        return this;
    }
    /**
     * Returns a specified number of ADDRESS objects.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/snowball/latest/api-reference/API_DescribeAddresses.html
     */
    describeAddresses() {
        this.add('snowball:DescribeAddresses');
        return this;
    }
    /**
     * Returns information about a specific cluster including shipping information, cluster status, and other important metadata.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/snowball/latest/api-reference/API_DescribeCluster.html
     */
    describeCluster() {
        this.add('snowball:DescribeCluster');
        return this;
    }
    /**
     * Returns information about a specific job including shipping information, job status, and other important metadata.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/snowball/latest/api-reference/API_DescribeJob.html
     */
    describeJob() {
        this.add('snowball:DescribeJob');
        return this;
    }
    /**
     * Returns a link to an Amazon S3 presigned URL for the manifest file associated with the specified JobId value.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/snowball/latest/api-reference/API_GetJobManifest.html
     */
    getJobManifest() {
        this.add('snowball:GetJobManifest');
        return this;
    }
    /**
     * Returns the UnlockCode code value for the specified job.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/snowball/latest/api-reference/API_GetJobUnlockCode.html
     */
    getJobUnlockCode() {
        this.add('snowball:GetJobUnlockCode');
        return this;
    }
    /**
     * Returns information about the Snowball service limit for your account, and also the number of Snowballs your account has in use.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/snowball/latest/api-reference/API_GetSnowballUsage.html
     */
    getSnowballUsage() {
        this.add('snowball:GetSnowballUsage');
        return this;
    }
    /**
     * Returns an array of JobListEntry objects of the specified length.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/snowball/latest/api-reference/API_ListClusterJobs.html
     */
    listClusterJobs() {
        this.add('snowball:ListClusterJobs');
        return this;
    }
    /**
     * Returns an array of ClusterListEntry objects of the specified length.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/snowball/latest/api-reference/API_ListClusters.html
     */
    listClusters() {
        this.add('snowball:ListClusters');
        return this;
    }
    /**
     * Returns an array of JobListEntry objects of the specified length.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/snowball/latest/api-reference/API_ListJobs.html
     */
    listJobs() {
        this.add('snowball:ListJobs');
        return this;
    }
    /**
     * While a cluster's ClusterState value is in the AwaitingQuorum state, you can update some of the information associated with a cluster.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/snowball/latest/api-reference/API_UpdateCluster.html
     */
    updateCluster() {
        this.add('snowball:UpdateCluster');
        return this;
    }
    /**
     * While a job's JobState value is New, you can update some of the information associated with a job.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/snowball/latest/api-reference/API_UpdateJob.html
     */
    updateJob() {
        this.add('snowball:UpdateJob');
        return this;
    }
}
exports.Snowball = Snowball;
//# sourceMappingURL=data:application/json;base64,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