"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const shared_1 = require("../shared");
/**
 * Action provider for service support
 *
 * https://docs.aws.amazon.com/IAM/latest/UserGuide/list_awssupport.html
 */
class Support extends shared_1.PolicyStatement {
    /**
     * Action provider for service support
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/list_awssupport.html
     */
    constructor(props) {
        super(props);
        this.servicePrefix = 'support';
        this.actions = {
            "AddAttachmentsToSet": {
                "url": "https://docs.aws.amazon.com/awssupport/latest/APIReference/API_AddAttachmentsToSet.html",
                "description": "Adds one or more attachments to an AWS Support case.",
                "accessLevel": "Write"
            },
            "AddCommunicationToCase": {
                "url": "https://docs.aws.amazon.com/awssupport/latest/APIReference/API_AddCommunicationToCase.html",
                "description": "Adds a customer communication to an AWS Support case.",
                "accessLevel": "Write"
            },
            "CreateCase": {
                "url": "https://docs.aws.amazon.com/awssupport/latest/APIReference/API_CreateCase.html",
                "description": "Creates a new AWS Support case.",
                "accessLevel": "Write"
            },
            "DescribeAttachment": {
                "url": "https://docs.aws.amazon.com/awssupport/latest/APIReference/API_DescribeAttachment.html",
                "description": "Returns the description for an attachment.",
                "accessLevel": "Read"
            },
            "DescribeCaseAttributes": {
                "url": "",
                "description": "This is an internally managed function which allows secondary services to read AWS Support case attributes.",
                "accessLevel": "Read"
            },
            "DescribeCases": {
                "url": "https://docs.aws.amazon.com/awssupport/latest/APIReference/API_DescribeCases.html",
                "description": "Returns a list of AWS Support cases that matches the given inputs.",
                "accessLevel": "Read"
            },
            "DescribeCommunications": {
                "url": "https://docs.aws.amazon.com/awssupport/latest/APIReference/API_DescribeCommunications.html",
                "description": "Returns the communications and attachments for one or more AWS Support cases.",
                "accessLevel": "Read"
            },
            "DescribeIssueTypes": {
                "url": "",
                "description": "Returns issue types for AWS Support cases.",
                "accessLevel": "Read"
            },
            "DescribeServices": {
                "url": "https://docs.aws.amazon.com/awssupport/latest/APIReference/API_DescribeServices.html",
                "description": "Returns the current list of AWS services and categories that applies to each service.",
                "accessLevel": "Read"
            },
            "DescribeSeverityLevels": {
                "url": "https://docs.aws.amazon.com/awssupport/latest/APIReference/API_DescribeSeverityLevels.html",
                "description": "Returns the list of severity levels that can be assigned to an AWS Support case.",
                "accessLevel": "Read"
            },
            "DescribeSupportLevel": {
                "url": "",
                "description": "Returns the support level for an AWS Account identifier.",
                "accessLevel": "Read"
            },
            "DescribeTrustedAdvisorCheckRefreshStatuses": {
                "url": "https://docs.aws.amazon.com/awssupport/latest/APIReference/API_DescribeTrustedAdvisorCheckRefreshStatuses.html",
                "description": "Returns the status of a Trusted Advisor refresh check based on a list of check identifiers.",
                "accessLevel": "Read"
            },
            "DescribeTrustedAdvisorCheckResult": {
                "url": "https://docs.aws.amazon.com/awssupport/latest/APIReference/API_DescribeTrustedAdvisorCheckResult.html",
                "description": "Returns the results of the Trusted Advisor check that has the specified check identifier.",
                "accessLevel": "Read"
            },
            "DescribeTrustedAdvisorCheckSummaries": {
                "url": "https://docs.aws.amazon.com/awssupport/latest/APIReference/API_DescribeTrustedAdvisorCheckSummaries.html",
                "description": "Returns the summaries of the results of the Trusted Advisor checks that have the specified check identifiers.",
                "accessLevel": "Read"
            },
            "DescribeTrustedAdvisorChecks": {
                "url": "https://docs.aws.amazon.com/awssupport/latest/APIReference/API_DescribeTrustedAdvisorChecks.html",
                "description": "Returns a list of all available Trusted Advisor checks, including name, identifier, category and description.",
                "accessLevel": "Read"
            },
            "InitiateCallForCase": {
                "url": "",
                "description": "This is an internally managed function to initiate a call on AWS Support Center.",
                "accessLevel": "Write"
            },
            "InitiateChatForCase": {
                "url": "",
                "description": "This is an internally managed function to initiate a chat on AWS Support Center.",
                "accessLevel": "Write"
            },
            "PutCaseAttributes": {
                "url": "",
                "description": "This is an internally managed function which allows secondary services to attach attributes to AWS Support cases.",
                "accessLevel": "Write"
            },
            "RateCaseCommunication": {
                "url": "",
                "description": "Rate an AWS Support case communication.",
                "accessLevel": "Write"
            },
            "RefreshTrustedAdvisorCheck": {
                "url": "https://docs.aws.amazon.com/awssupport/latest/APIReference/API_RefreshTrustedAdvisorCheck.html",
                "description": "Requests a refresh of the Trusted Advisor check that has the specified check identifier.",
                "accessLevel": "Write"
            },
            "ResolveCase": {
                "url": "https://docs.aws.amazon.com/awssupport/latest/APIReference/API_ResolveCase.html",
                "description": "Resolves an AWS Support case.",
                "accessLevel": "Write"
            },
            "SearchForCases": {
                "url": "",
                "description": "Returns a list of AWS Support cases that matches the given inputs.",
                "accessLevel": "Read"
            }
        };
        this.resourceTypes = {};
    }
    /**
     * Adds one or more attachments to an AWS Support case.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/awssupport/latest/APIReference/API_AddAttachmentsToSet.html
     */
    addAttachmentsToSet() {
        this.add('support:AddAttachmentsToSet');
        return this;
    }
    /**
     * Adds a customer communication to an AWS Support case.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/awssupport/latest/APIReference/API_AddCommunicationToCase.html
     */
    addCommunicationToCase() {
        this.add('support:AddCommunicationToCase');
        return this;
    }
    /**
     * Creates a new AWS Support case.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/awssupport/latest/APIReference/API_CreateCase.html
     */
    createCase() {
        this.add('support:CreateCase');
        return this;
    }
    /**
     * Returns the description for an attachment.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/awssupport/latest/APIReference/API_DescribeAttachment.html
     */
    describeAttachment() {
        this.add('support:DescribeAttachment');
        return this;
    }
    /**
     * This is an internally managed function which allows secondary services to read AWS Support case attributes.
     *
     * Access Level: Read
     */
    describeCaseAttributes() {
        this.add('support:DescribeCaseAttributes');
        return this;
    }
    /**
     * Returns a list of AWS Support cases that matches the given inputs.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/awssupport/latest/APIReference/API_DescribeCases.html
     */
    describeCases() {
        this.add('support:DescribeCases');
        return this;
    }
    /**
     * Returns the communications and attachments for one or more AWS Support cases.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/awssupport/latest/APIReference/API_DescribeCommunications.html
     */
    describeCommunications() {
        this.add('support:DescribeCommunications');
        return this;
    }
    /**
     * Returns issue types for AWS Support cases.
     *
     * Access Level: Read
     */
    describeIssueTypes() {
        this.add('support:DescribeIssueTypes');
        return this;
    }
    /**
     * Returns the current list of AWS services and categories that applies to each service.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/awssupport/latest/APIReference/API_DescribeServices.html
     */
    describeServices() {
        this.add('support:DescribeServices');
        return this;
    }
    /**
     * Returns the list of severity levels that can be assigned to an AWS Support case.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/awssupport/latest/APIReference/API_DescribeSeverityLevels.html
     */
    describeSeverityLevels() {
        this.add('support:DescribeSeverityLevels');
        return this;
    }
    /**
     * Returns the support level for an AWS Account identifier.
     *
     * Access Level: Read
     */
    describeSupportLevel() {
        this.add('support:DescribeSupportLevel');
        return this;
    }
    /**
     * Returns the status of a Trusted Advisor refresh check based on a list of check identifiers.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/awssupport/latest/APIReference/API_DescribeTrustedAdvisorCheckRefreshStatuses.html
     */
    describeTrustedAdvisorCheckRefreshStatuses() {
        this.add('support:DescribeTrustedAdvisorCheckRefreshStatuses');
        return this;
    }
    /**
     * Returns the results of the Trusted Advisor check that has the specified check identifier.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/awssupport/latest/APIReference/API_DescribeTrustedAdvisorCheckResult.html
     */
    describeTrustedAdvisorCheckResult() {
        this.add('support:DescribeTrustedAdvisorCheckResult');
        return this;
    }
    /**
     * Returns the summaries of the results of the Trusted Advisor checks that have the specified check identifiers.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/awssupport/latest/APIReference/API_DescribeTrustedAdvisorCheckSummaries.html
     */
    describeTrustedAdvisorCheckSummaries() {
        this.add('support:DescribeTrustedAdvisorCheckSummaries');
        return this;
    }
    /**
     * Returns a list of all available Trusted Advisor checks, including name, identifier, category and description.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/awssupport/latest/APIReference/API_DescribeTrustedAdvisorChecks.html
     */
    describeTrustedAdvisorChecks() {
        this.add('support:DescribeTrustedAdvisorChecks');
        return this;
    }
    /**
     * This is an internally managed function to initiate a call on AWS Support Center.
     *
     * Access Level: Write
     */
    initiateCallForCase() {
        this.add('support:InitiateCallForCase');
        return this;
    }
    /**
     * This is an internally managed function to initiate a chat on AWS Support Center.
     *
     * Access Level: Write
     */
    initiateChatForCase() {
        this.add('support:InitiateChatForCase');
        return this;
    }
    /**
     * This is an internally managed function which allows secondary services to attach attributes to AWS Support cases.
     *
     * Access Level: Write
     */
    putCaseAttributes() {
        this.add('support:PutCaseAttributes');
        return this;
    }
    /**
     * Rate an AWS Support case communication.
     *
     * Access Level: Write
     */
    rateCaseCommunication() {
        this.add('support:RateCaseCommunication');
        return this;
    }
    /**
     * Requests a refresh of the Trusted Advisor check that has the specified check identifier.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/awssupport/latest/APIReference/API_RefreshTrustedAdvisorCheck.html
     */
    refreshTrustedAdvisorCheck() {
        this.add('support:RefreshTrustedAdvisorCheck');
        return this;
    }
    /**
     * Resolves an AWS Support case.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/awssupport/latest/APIReference/API_ResolveCase.html
     */
    resolveCase() {
        this.add('support:ResolveCase');
        return this;
    }
    /**
     * Returns a list of AWS Support cases that matches the given inputs.
     *
     * Access Level: Read
     */
    searchForCases() {
        this.add('support:SearchForCases');
        return this;
    }
}
exports.Support = Support;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiYXdzc3VwcG9ydC5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbImF3c3N1cHBvcnQudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7QUFBQSxzQ0FBb0U7QUFHcEU7Ozs7R0FJRztBQUNILE1BQWEsT0FBUSxTQUFRLHdCQUFlO0lBb0gxQzs7OztPQUlHO0lBQ0gsWUFBYSxLQUE0QjtRQUN2QyxLQUFLLENBQUMsS0FBSyxDQUFDLENBQUM7UUF6SFIsa0JBQWEsR0FBRyxTQUFTLENBQUM7UUFDMUIsWUFBTyxHQUFZO1lBQ3hCLHFCQUFxQixFQUFFO2dCQUNyQixLQUFLLEVBQUUseUZBQXlGO2dCQUNoRyxhQUFhLEVBQUUsc0RBQXNEO2dCQUNyRSxhQUFhLEVBQUUsT0FBTzthQUN2QjtZQUNELHdCQUF3QixFQUFFO2dCQUN4QixLQUFLLEVBQUUsNEZBQTRGO2dCQUNuRyxhQUFhLEVBQUUsdURBQXVEO2dCQUN0RSxhQUFhLEVBQUUsT0FBTzthQUN2QjtZQUNELFlBQVksRUFBRTtnQkFDWixLQUFLLEVBQUUsZ0ZBQWdGO2dCQUN2RixhQUFhLEVBQUUsaUNBQWlDO2dCQUNoRCxhQUFhLEVBQUUsT0FBTzthQUN2QjtZQUNELG9CQUFvQixFQUFFO2dCQUNwQixLQUFLLEVBQUUsd0ZBQXdGO2dCQUMvRixhQUFhLEVBQUUsNENBQTRDO2dCQUMzRCxhQUFhLEVBQUUsTUFBTTthQUN0QjtZQUNELHdCQUF3QixFQUFFO2dCQUN4QixLQUFLLEVBQUUsRUFBRTtnQkFDVCxhQUFhLEVBQUUsNkdBQTZHO2dCQUM1SCxhQUFhLEVBQUUsTUFBTTthQUN0QjtZQUNELGVBQWUsRUFBRTtnQkFDZixLQUFLLEVBQUUsbUZBQW1GO2dCQUMxRixhQUFhLEVBQUUsb0VBQW9FO2dCQUNuRixhQUFhLEVBQUUsTUFBTTthQUN0QjtZQUNELHdCQUF3QixFQUFFO2dCQUN4QixLQUFLLEVBQUUsNEZBQTRGO2dCQUNuRyxhQUFhLEVBQUUsK0VBQStFO2dCQUM5RixhQUFhLEVBQUUsTUFBTTthQUN0QjtZQUNELG9CQUFvQixFQUFFO2dCQUNwQixLQUFLLEVBQUUsRUFBRTtnQkFDVCxhQUFhLEVBQUUsNENBQTRDO2dCQUMzRCxhQUFhLEVBQUUsTUFBTTthQUN0QjtZQUNELGtCQUFrQixFQUFFO2dCQUNsQixLQUFLLEVBQUUsc0ZBQXNGO2dCQUM3RixhQUFhLEVBQUUsdUZBQXVGO2dCQUN0RyxhQUFhLEVBQUUsTUFBTTthQUN0QjtZQUNELHdCQUF3QixFQUFFO2dCQUN4QixLQUFLLEVBQUUsNEZBQTRGO2dCQUNuRyxhQUFhLEVBQUUsa0ZBQWtGO2dCQUNqRyxhQUFhLEVBQUUsTUFBTTthQUN0QjtZQUNELHNCQUFzQixFQUFFO2dCQUN0QixLQUFLLEVBQUUsRUFBRTtnQkFDVCxhQUFhLEVBQUUsMERBQTBEO2dCQUN6RSxhQUFhLEVBQUUsTUFBTTthQUN0QjtZQUNELDRDQUE0QyxFQUFFO2dCQUM1QyxLQUFLLEVBQUUsZ0hBQWdIO2dCQUN2SCxhQUFhLEVBQUUsNkZBQTZGO2dCQUM1RyxhQUFhLEVBQUUsTUFBTTthQUN0QjtZQUNELG1DQUFtQyxFQUFFO2dCQUNuQyxLQUFLLEVBQUUsdUdBQXVHO2dCQUM5RyxhQUFhLEVBQUUsMkZBQTJGO2dCQUMxRyxhQUFhLEVBQUUsTUFBTTthQUN0QjtZQUNELHNDQUFzQyxFQUFFO2dCQUN0QyxLQUFLLEVBQUUsMEdBQTBHO2dCQUNqSCxhQUFhLEVBQUUsK0dBQStHO2dCQUM5SCxhQUFhLEVBQUUsTUFBTTthQUN0QjtZQUNELDhCQUE4QixFQUFFO2dCQUM5QixLQUFLLEVBQUUsa0dBQWtHO2dCQUN6RyxhQUFhLEVBQUUsK0dBQStHO2dCQUM5SCxhQUFhLEVBQUUsTUFBTTthQUN0QjtZQUNELHFCQUFxQixFQUFFO2dCQUNyQixLQUFLLEVBQUUsRUFBRTtnQkFDVCxhQUFhLEVBQUUsa0ZBQWtGO2dCQUNqRyxhQUFhLEVBQUUsT0FBTzthQUN2QjtZQUNELHFCQUFxQixFQUFFO2dCQUNyQixLQUFLLEVBQUUsRUFBRTtnQkFDVCxhQUFhLEVBQUUsa0ZBQWtGO2dCQUNqRyxhQUFhLEVBQUUsT0FBTzthQUN2QjtZQUNELG1CQUFtQixFQUFFO2dCQUNuQixLQUFLLEVBQUUsRUFBRTtnQkFDVCxhQUFhLEVBQUUsbUhBQW1IO2dCQUNsSSxhQUFhLEVBQUUsT0FBTzthQUN2QjtZQUNELHVCQUF1QixFQUFFO2dCQUN2QixLQUFLLEVBQUUsRUFBRTtnQkFDVCxhQUFhLEVBQUUseUNBQXlDO2dCQUN4RCxhQUFhLEVBQUUsT0FBTzthQUN2QjtZQUNELDRCQUE0QixFQUFFO2dCQUM1QixLQUFLLEVBQUUsZ0dBQWdHO2dCQUN2RyxhQUFhLEVBQUUsMEZBQTBGO2dCQUN6RyxhQUFhLEVBQUUsT0FBTzthQUN2QjtZQUNELGFBQWEsRUFBRTtnQkFDYixLQUFLLEVBQUUsaUZBQWlGO2dCQUN4RixhQUFhLEVBQUUsK0JBQStCO2dCQUM5QyxhQUFhLEVBQUUsT0FBTzthQUN2QjtZQUNELGdCQUFnQixFQUFFO2dCQUNoQixLQUFLLEVBQUUsRUFBRTtnQkFDVCxhQUFhLEVBQUUsb0VBQW9FO2dCQUNuRixhQUFhLEVBQUUsTUFBTTthQUN0QjtTQUNGLENBQUM7UUFDSyxrQkFBYSxHQUFrQixFQUFFLENBQUM7SUFTekMsQ0FBQztJQUVEOzs7Ozs7T0FNRztJQUNJLG1CQUFtQjtRQUN4QixJQUFJLENBQUMsR0FBRyxDQUFDLDZCQUE2QixDQUFDLENBQUM7UUFDeEMsT0FBTyxJQUFJLENBQUM7SUFDZCxDQUFDO0lBRUQ7Ozs7OztPQU1HO0lBQ0ksc0JBQXNCO1FBQzNCLElBQUksQ0FBQyxHQUFHLENBQUMsZ0NBQWdDLENBQUMsQ0FBQztRQUMzQyxPQUFPLElBQUksQ0FBQztJQUNkLENBQUM7SUFFRDs7Ozs7O09BTUc7SUFDSSxVQUFVO1FBQ2YsSUFBSSxDQUFDLEdBQUcsQ0FBQyxvQkFBb0IsQ0FBQyxDQUFDO1FBQy9CLE9BQU8sSUFBSSxDQUFDO0lBQ2QsQ0FBQztJQUVEOzs7Ozs7T0FNRztJQUNJLGtCQUFrQjtRQUN2QixJQUFJLENBQUMsR0FBRyxDQUFDLDRCQUE0QixDQUFDLENBQUM7UUFDdkMsT0FBTyxJQUFJLENBQUM7SUFDZCxDQUFDO0lBRUQ7Ozs7T0FJRztJQUNJLHNCQUFzQjtRQUMzQixJQUFJLENBQUMsR0FBRyxDQUFDLGdDQUFnQyxDQUFDLENBQUM7UUFDM0MsT0FBTyxJQUFJLENBQUM7SUFDZCxDQUFDO0lBRUQ7Ozs7OztPQU1HO0lBQ0ksYUFBYTtRQUNsQixJQUFJLENBQUMsR0FBRyxDQUFDLHVCQUF1QixDQUFDLENBQUM7UUFDbEMsT0FBTyxJQUFJLENBQUM7SUFDZCxDQUFDO0lBRUQ7Ozs7OztPQU1HO0lBQ0ksc0JBQXNCO1FBQzNCLElBQUksQ0FBQyxHQUFHLENBQUMsZ0NBQWdDLENBQUMsQ0FBQztRQUMzQyxPQUFPLElBQUksQ0FBQztJQUNkLENBQUM7SUFFRDs7OztPQUlHO0lBQ0ksa0JBQWtCO1FBQ3ZCLElBQUksQ0FBQyxHQUFHLENBQUMsNEJBQTRCLENBQUMsQ0FBQztRQUN2QyxPQUFPLElBQUksQ0FBQztJQUNkLENBQUM7SUFFRDs7Ozs7O09BTUc7SUFDSSxnQkFBZ0I7UUFDckIsSUFBSSxDQUFDLEdBQUcsQ0FBQywwQkFBMEIsQ0FBQyxDQUFDO1FBQ3JDLE9BQU8sSUFBSSxDQUFDO0lBQ2QsQ0FBQztJQUVEOzs7Ozs7T0FNRztJQUNJLHNCQUFzQjtRQUMzQixJQUFJLENBQUMsR0FBRyxDQUFDLGdDQUFnQyxDQUFDLENBQUM7UUFDM0MsT0FBTyxJQUFJLENBQUM7SUFDZCxDQUFDO0lBRUQ7Ozs7T0FJRztJQUNJLG9CQUFvQjtRQUN6QixJQUFJLENBQUMsR0FBRyxDQUFDLDhCQUE4QixDQUFDLENBQUM7UUFDekMsT0FBTyxJQUFJLENBQUM7SUFDZCxDQUFDO0lBRUQ7Ozs7OztPQU1HO0lBQ0ksMENBQTBDO1FBQy9DLElBQUksQ0FBQyxHQUFHLENBQUMsb0RBQW9ELENBQUMsQ0FBQztRQUMvRCxPQUFPLElBQUksQ0FBQztJQUNkLENBQUM7SUFFRDs7Ozs7O09BTUc7SUFDSSxpQ0FBaUM7UUFDdEMsSUFBSSxDQUFDLEdBQUcsQ0FBQywyQ0FBMkMsQ0FBQyxDQUFDO1FBQ3RELE9BQU8sSUFBSSxDQUFDO0lBQ2QsQ0FBQztJQUVEOzs7Ozs7T0FNRztJQUNJLG9DQUFvQztRQUN6QyxJQUFJLENBQUMsR0FBRyxDQUFDLDhDQUE4QyxDQUFDLENBQUM7UUFDekQsT0FBTyxJQUFJLENBQUM7SUFDZCxDQUFDO0lBRUQ7Ozs7OztPQU1HO0lBQ0ksNEJBQTRCO1FBQ2pDLElBQUksQ0FBQyxHQUFHLENBQUMsc0NBQXNDLENBQUMsQ0FBQztRQUNqRCxPQUFPLElBQUksQ0FBQztJQUNkLENBQUM7SUFFRDs7OztPQUlHO0lBQ0ksbUJBQW1CO1FBQ3hCLElBQUksQ0FBQyxHQUFHLENBQUMsNkJBQTZCLENBQUMsQ0FBQztRQUN4QyxPQUFPLElBQUksQ0FBQztJQUNkLENBQUM7SUFFRDs7OztPQUlHO0lBQ0ksbUJBQW1CO1FBQ3hCLElBQUksQ0FBQyxHQUFHLENBQUMsNkJBQTZCLENBQUMsQ0FBQztRQUN4QyxPQUFPLElBQUksQ0FBQztJQUNkLENBQUM7SUFFRDs7OztPQUlHO0lBQ0ksaUJBQWlCO1FBQ3RCLElBQUksQ0FBQyxHQUFHLENBQUMsMkJBQTJCLENBQUMsQ0FBQztRQUN0QyxPQUFPLElBQUksQ0FBQztJQUNkLENBQUM7SUFFRDs7OztPQUlHO0lBQ0kscUJBQXFCO1FBQzFCLElBQUksQ0FBQyxHQUFHLENBQUMsK0JBQStCLENBQUMsQ0FBQztRQUMxQyxPQUFPLElBQUksQ0FBQztJQUNkLENBQUM7SUFFRDs7Ozs7O09BTUc7SUFDSSwwQkFBMEI7UUFDL0IsSUFBSSxDQUFDLEdBQUcsQ0FBQyxvQ0FBb0MsQ0FBQyxDQUFDO1FBQy9DLE9BQU8sSUFBSSxDQUFDO0lBQ2QsQ0FBQztJQUVEOzs7Ozs7T0FNRztJQUNJLFdBQVc7UUFDaEIsSUFBSSxDQUFDLEdBQUcsQ0FBQyxxQkFBcUIsQ0FBQyxDQUFDO1FBQ2hDLE9BQU8sSUFBSSxDQUFDO0lBQ2QsQ0FBQztJQUVEOzs7O09BSUc7SUFDSSxjQUFjO1FBQ25CLElBQUksQ0FBQyxHQUFHLENBQUMsd0JBQXdCLENBQUMsQ0FBQztRQUNuQyxPQUFPLElBQUksQ0FBQztJQUNkLENBQUM7Q0FDRjtBQXBYRCwwQkFvWEMiLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgeyBBY3Rpb25zLCBQb2xpY3lTdGF0ZW1lbnQsIFJlc291cmNlVHlwZXMgfSBmcm9tIFwiLi4vc2hhcmVkXCI7XG5pbXBvcnQgeyBQb2xpY3lTdGF0ZW1lbnRQcm9wcyB9IGZyb20gXCJAYXdzLWNkay9hd3MtaWFtXCI7XG5cbi8qKlxuICogQWN0aW9uIHByb3ZpZGVyIGZvciBzZXJ2aWNlIHN1cHBvcnRcbiAqXG4gKiBodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vSUFNL2xhdGVzdC9Vc2VyR3VpZGUvbGlzdF9hd3NzdXBwb3J0Lmh0bWxcbiAqL1xuZXhwb3J0IGNsYXNzIFN1cHBvcnQgZXh0ZW5kcyBQb2xpY3lTdGF0ZW1lbnQge1xuICBwdWJsaWMgc2VydmljZVByZWZpeCA9ICdzdXBwb3J0JztcbiAgcHVibGljIGFjdGlvbnM6IEFjdGlvbnMgPSB7XG4gICAgXCJBZGRBdHRhY2htZW50c1RvU2V0XCI6IHtcbiAgICAgIFwidXJsXCI6IFwiaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL2F3c3N1cHBvcnQvbGF0ZXN0L0FQSVJlZmVyZW5jZS9BUElfQWRkQXR0YWNobWVudHNUb1NldC5odG1sXCIsXG4gICAgICBcImRlc2NyaXB0aW9uXCI6IFwiQWRkcyBvbmUgb3IgbW9yZSBhdHRhY2htZW50cyB0byBhbiBBV1MgU3VwcG9ydCBjYXNlLlwiLFxuICAgICAgXCJhY2Nlc3NMZXZlbFwiOiBcIldyaXRlXCJcbiAgICB9LFxuICAgIFwiQWRkQ29tbXVuaWNhdGlvblRvQ2FzZVwiOiB7XG4gICAgICBcInVybFwiOiBcImh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9hd3NzdXBwb3J0L2xhdGVzdC9BUElSZWZlcmVuY2UvQVBJX0FkZENvbW11bmljYXRpb25Ub0Nhc2UuaHRtbFwiLFxuICAgICAgXCJkZXNjcmlwdGlvblwiOiBcIkFkZHMgYSBjdXN0b21lciBjb21tdW5pY2F0aW9uIHRvIGFuIEFXUyBTdXBwb3J0IGNhc2UuXCIsXG4gICAgICBcImFjY2Vzc0xldmVsXCI6IFwiV3JpdGVcIlxuICAgIH0sXG4gICAgXCJDcmVhdGVDYXNlXCI6IHtcbiAgICAgIFwidXJsXCI6IFwiaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL2F3c3N1cHBvcnQvbGF0ZXN0L0FQSVJlZmVyZW5jZS9BUElfQ3JlYXRlQ2FzZS5odG1sXCIsXG4gICAgICBcImRlc2NyaXB0aW9uXCI6IFwiQ3JlYXRlcyBhIG5ldyBBV1MgU3VwcG9ydCBjYXNlLlwiLFxuICAgICAgXCJhY2Nlc3NMZXZlbFwiOiBcIldyaXRlXCJcbiAgICB9LFxuICAgIFwiRGVzY3JpYmVBdHRhY2htZW50XCI6IHtcbiAgICAgIFwidXJsXCI6IFwiaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL2F3c3N1cHBvcnQvbGF0ZXN0L0FQSVJlZmVyZW5jZS9BUElfRGVzY3JpYmVBdHRhY2htZW50Lmh0bWxcIixcbiAgICAgIFwiZGVzY3JpcHRpb25cIjogXCJSZXR1cm5zIHRoZSBkZXNjcmlwdGlvbiBmb3IgYW4gYXR0YWNobWVudC5cIixcbiAgICAgIFwiYWNjZXNzTGV2ZWxcIjogXCJSZWFkXCJcbiAgICB9LFxuICAgIFwiRGVzY3JpYmVDYXNlQXR0cmlidXRlc1wiOiB7XG4gICAgICBcInVybFwiOiBcIlwiLFxuICAgICAgXCJkZXNjcmlwdGlvblwiOiBcIlRoaXMgaXMgYW4gaW50ZXJuYWxseSBtYW5hZ2VkIGZ1bmN0aW9uIHdoaWNoIGFsbG93cyBzZWNvbmRhcnkgc2VydmljZXMgdG8gcmVhZCBBV1MgU3VwcG9ydCBjYXNlIGF0dHJpYnV0ZXMuXCIsXG4gICAgICBcImFjY2Vzc0xldmVsXCI6IFwiUmVhZFwiXG4gICAgfSxcbiAgICBcIkRlc2NyaWJlQ2FzZXNcIjoge1xuICAgICAgXCJ1cmxcIjogXCJodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vYXdzc3VwcG9ydC9sYXRlc3QvQVBJUmVmZXJlbmNlL0FQSV9EZXNjcmliZUNhc2VzLmh0bWxcIixcbiAgICAgIFwiZGVzY3JpcHRpb25cIjogXCJSZXR1cm5zIGEgbGlzdCBvZiBBV1MgU3VwcG9ydCBjYXNlcyB0aGF0IG1hdGNoZXMgdGhlIGdpdmVuIGlucHV0cy5cIixcbiAgICAgIFwiYWNjZXNzTGV2ZWxcIjogXCJSZWFkXCJcbiAgICB9LFxuICAgIFwiRGVzY3JpYmVDb21tdW5pY2F0aW9uc1wiOiB7XG4gICAgICBcInVybFwiOiBcImh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9hd3NzdXBwb3J0L2xhdGVzdC9BUElSZWZlcmVuY2UvQVBJX0Rlc2NyaWJlQ29tbXVuaWNhdGlvbnMuaHRtbFwiLFxuICAgICAgXCJkZXNjcmlwdGlvblwiOiBcIlJldHVybnMgdGhlIGNvbW11bmljYXRpb25zIGFuZCBhdHRhY2htZW50cyBmb3Igb25lIG9yIG1vcmUgQVdTIFN1cHBvcnQgY2FzZXMuXCIsXG4gICAgICBcImFjY2Vzc0xldmVsXCI6IFwiUmVhZFwiXG4gICAgfSxcbiAgICBcIkRlc2NyaWJlSXNzdWVUeXBlc1wiOiB7XG4gICAgICBcInVybFwiOiBcIlwiLFxuICAgICAgXCJkZXNjcmlwdGlvblwiOiBcIlJldHVybnMgaXNzdWUgdHlwZXMgZm9yIEFXUyBTdXBwb3J0IGNhc2VzLlwiLFxuICAgICAgXCJhY2Nlc3NMZXZlbFwiOiBcIlJlYWRcIlxuICAgIH0sXG4gICAgXCJEZXNjcmliZVNlcnZpY2VzXCI6IHtcbiAgICAgIFwidXJsXCI6IFwiaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL2F3c3N1cHBvcnQvbGF0ZXN0L0FQSVJlZmVyZW5jZS9BUElfRGVzY3JpYmVTZXJ2aWNlcy5odG1sXCIsXG4gICAgICBcImRlc2NyaXB0aW9uXCI6IFwiUmV0dXJucyB0aGUgY3VycmVudCBsaXN0IG9mIEFXUyBzZXJ2aWNlcyBhbmQgY2F0ZWdvcmllcyB0aGF0IGFwcGxpZXMgdG8gZWFjaCBzZXJ2aWNlLlwiLFxuICAgICAgXCJhY2Nlc3NMZXZlbFwiOiBcIlJlYWRcIlxuICAgIH0sXG4gICAgXCJEZXNjcmliZVNldmVyaXR5TGV2ZWxzXCI6IHtcbiAgICAgIFwidXJsXCI6IFwiaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL2F3c3N1cHBvcnQvbGF0ZXN0L0FQSVJlZmVyZW5jZS9BUElfRGVzY3JpYmVTZXZlcml0eUxldmVscy5odG1sXCIsXG4gICAgICBcImRlc2NyaXB0aW9uXCI6IFwiUmV0dXJucyB0aGUgbGlzdCBvZiBzZXZlcml0eSBsZXZlbHMgdGhhdCBjYW4gYmUgYXNzaWduZWQgdG8gYW4gQVdTIFN1cHBvcnQgY2FzZS5cIixcbiAgICAgIFwiYWNjZXNzTGV2ZWxcIjogXCJSZWFkXCJcbiAgICB9LFxuICAgIFwiRGVzY3JpYmVTdXBwb3J0TGV2ZWxcIjoge1xuICAgICAgXCJ1cmxcIjogXCJcIixcbiAgICAgIFwiZGVzY3JpcHRpb25cIjogXCJSZXR1cm5zIHRoZSBzdXBwb3J0IGxldmVsIGZvciBhbiBBV1MgQWNjb3VudCBpZGVudGlmaWVyLlwiLFxuICAgICAgXCJhY2Nlc3NMZXZlbFwiOiBcIlJlYWRcIlxuICAgIH0sXG4gICAgXCJEZXNjcmliZVRydXN0ZWRBZHZpc29yQ2hlY2tSZWZyZXNoU3RhdHVzZXNcIjoge1xuICAgICAgXCJ1cmxcIjogXCJodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vYXdzc3VwcG9ydC9sYXRlc3QvQVBJUmVmZXJlbmNlL0FQSV9EZXNjcmliZVRydXN0ZWRBZHZpc29yQ2hlY2tSZWZyZXNoU3RhdHVzZXMuaHRtbFwiLFxuICAgICAgXCJkZXNjcmlwdGlvblwiOiBcIlJldHVybnMgdGhlIHN0YXR1cyBvZiBhIFRydXN0ZWQgQWR2aXNvciByZWZyZXNoIGNoZWNrIGJhc2VkIG9uIGEgbGlzdCBvZiBjaGVjayBpZGVudGlmaWVycy5cIixcbiAgICAgIFwiYWNjZXNzTGV2ZWxcIjogXCJSZWFkXCJcbiAgICB9LFxuICAgIFwiRGVzY3JpYmVUcnVzdGVkQWR2aXNvckNoZWNrUmVzdWx0XCI6IHtcbiAgICAgIFwidXJsXCI6IFwiaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL2F3c3N1cHBvcnQvbGF0ZXN0L0FQSVJlZmVyZW5jZS9BUElfRGVzY3JpYmVUcnVzdGVkQWR2aXNvckNoZWNrUmVzdWx0Lmh0bWxcIixcbiAgICAgIFwiZGVzY3JpcHRpb25cIjogXCJSZXR1cm5zIHRoZSByZXN1bHRzIG9mIHRoZSBUcnVzdGVkIEFkdmlzb3IgY2hlY2sgdGhhdCBoYXMgdGhlIHNwZWNpZmllZCBjaGVjayBpZGVudGlmaWVyLlwiLFxuICAgICAgXCJhY2Nlc3NMZXZlbFwiOiBcIlJlYWRcIlxuICAgIH0sXG4gICAgXCJEZXNjcmliZVRydXN0ZWRBZHZpc29yQ2hlY2tTdW1tYXJpZXNcIjoge1xuICAgICAgXCJ1cmxcIjogXCJodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vYXdzc3VwcG9ydC9sYXRlc3QvQVBJUmVmZXJlbmNlL0FQSV9EZXNjcmliZVRydXN0ZWRBZHZpc29yQ2hlY2tTdW1tYXJpZXMuaHRtbFwiLFxuICAgICAgXCJkZXNjcmlwdGlvblwiOiBcIlJldHVybnMgdGhlIHN1bW1hcmllcyBvZiB0aGUgcmVzdWx0cyBvZiB0aGUgVHJ1c3RlZCBBZHZpc29yIGNoZWNrcyB0aGF0IGhhdmUgdGhlIHNwZWNpZmllZCBjaGVjayBpZGVudGlmaWVycy5cIixcbiAgICAgIFwiYWNjZXNzTGV2ZWxcIjogXCJSZWFkXCJcbiAgICB9LFxuICAgIFwiRGVzY3JpYmVUcnVzdGVkQWR2aXNvckNoZWNrc1wiOiB7XG4gICAgICBcInVybFwiOiBcImh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9hd3NzdXBwb3J0L2xhdGVzdC9BUElSZWZlcmVuY2UvQVBJX0Rlc2NyaWJlVHJ1c3RlZEFkdmlzb3JDaGVja3MuaHRtbFwiLFxuICAgICAgXCJkZXNjcmlwdGlvblwiOiBcIlJldHVybnMgYSBsaXN0IG9mIGFsbCBhdmFpbGFibGUgVHJ1c3RlZCBBZHZpc29yIGNoZWNrcywgaW5jbHVkaW5nIG5hbWUsIGlkZW50aWZpZXIsIGNhdGVnb3J5IGFuZCBkZXNjcmlwdGlvbi5cIixcbiAgICAgIFwiYWNjZXNzTGV2ZWxcIjogXCJSZWFkXCJcbiAgICB9LFxuICAgIFwiSW5pdGlhdGVDYWxsRm9yQ2FzZVwiOiB7XG4gICAgICBcInVybFwiOiBcIlwiLFxuICAgICAgXCJkZXNjcmlwdGlvblwiOiBcIlRoaXMgaXMgYW4gaW50ZXJuYWxseSBtYW5hZ2VkIGZ1bmN0aW9uIHRvIGluaXRpYXRlIGEgY2FsbCBvbiBBV1MgU3VwcG9ydCBDZW50ZXIuXCIsXG4gICAgICBcImFjY2Vzc0xldmVsXCI6IFwiV3JpdGVcIlxuICAgIH0sXG4gICAgXCJJbml0aWF0ZUNoYXRGb3JDYXNlXCI6IHtcbiAgICAgIFwidXJsXCI6IFwiXCIsXG4gICAgICBcImRlc2NyaXB0aW9uXCI6IFwiVGhpcyBpcyBhbiBpbnRlcm5hbGx5IG1hbmFnZWQgZnVuY3Rpb24gdG8gaW5pdGlhdGUgYSBjaGF0IG9uIEFXUyBTdXBwb3J0IENlbnRlci5cIixcbiAgICAgIFwiYWNjZXNzTGV2ZWxcIjogXCJXcml0ZVwiXG4gICAgfSxcbiAgICBcIlB1dENhc2VBdHRyaWJ1dGVzXCI6IHtcbiAgICAgIFwidXJsXCI6IFwiXCIsXG4gICAgICBcImRlc2NyaXB0aW9uXCI6IFwiVGhpcyBpcyBhbiBpbnRlcm5hbGx5IG1hbmFnZWQgZnVuY3Rpb24gd2hpY2ggYWxsb3dzIHNlY29uZGFyeSBzZXJ2aWNlcyB0byBhdHRhY2ggYXR0cmlidXRlcyB0byBBV1MgU3VwcG9ydCBjYXNlcy5cIixcbiAgICAgIFwiYWNjZXNzTGV2ZWxcIjogXCJXcml0ZVwiXG4gICAgfSxcbiAgICBcIlJhdGVDYXNlQ29tbXVuaWNhdGlvblwiOiB7XG4gICAgICBcInVybFwiOiBcIlwiLFxuICAgICAgXCJkZXNjcmlwdGlvblwiOiBcIlJhdGUgYW4gQVdTIFN1cHBvcnQgY2FzZSBjb21tdW5pY2F0aW9uLlwiLFxuICAgICAgXCJhY2Nlc3NMZXZlbFwiOiBcIldyaXRlXCJcbiAgICB9LFxuICAgIFwiUmVmcmVzaFRydXN0ZWRBZHZpc29yQ2hlY2tcIjoge1xuICAgICAgXCJ1cmxcIjogXCJodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vYXdzc3VwcG9ydC9sYXRlc3QvQVBJUmVmZXJlbmNlL0FQSV9SZWZyZXNoVHJ1c3RlZEFkdmlzb3JDaGVjay5odG1sXCIsXG4gICAgICBcImRlc2NyaXB0aW9uXCI6IFwiUmVxdWVzdHMgYSByZWZyZXNoIG9mIHRoZSBUcnVzdGVkIEFkdmlzb3IgY2hlY2sgdGhhdCBoYXMgdGhlIHNwZWNpZmllZCBjaGVjayBpZGVudGlmaWVyLlwiLFxuICAgICAgXCJhY2Nlc3NMZXZlbFwiOiBcIldyaXRlXCJcbiAgICB9LFxuICAgIFwiUmVzb2x2ZUNhc2VcIjoge1xuICAgICAgXCJ1cmxcIjogXCJodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vYXdzc3VwcG9ydC9sYXRlc3QvQVBJUmVmZXJlbmNlL0FQSV9SZXNvbHZlQ2FzZS5odG1sXCIsXG4gICAgICBcImRlc2NyaXB0aW9uXCI6IFwiUmVzb2x2ZXMgYW4gQVdTIFN1cHBvcnQgY2FzZS5cIixcbiAgICAgIFwiYWNjZXNzTGV2ZWxcIjogXCJXcml0ZVwiXG4gICAgfSxcbiAgICBcIlNlYXJjaEZvckNhc2VzXCI6IHtcbiAgICAgIFwidXJsXCI6IFwiXCIsXG4gICAgICBcImRlc2NyaXB0aW9uXCI6IFwiUmV0dXJucyBhIGxpc3Qgb2YgQVdTIFN1cHBvcnQgY2FzZXMgdGhhdCBtYXRjaGVzIHRoZSBnaXZlbiBpbnB1dHMuXCIsXG4gICAgICBcImFjY2Vzc0xldmVsXCI6IFwiUmVhZFwiXG4gICAgfVxuICB9O1xuICBwdWJsaWMgcmVzb3VyY2VUeXBlczogUmVzb3VyY2VUeXBlcyA9IHt9O1xuXG4gIC8qKlxuICAgKiBBY3Rpb24gcHJvdmlkZXIgZm9yIHNlcnZpY2Ugc3VwcG9ydFxuICAgKlxuICAgKiBodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vSUFNL2xhdGVzdC9Vc2VyR3VpZGUvbGlzdF9hd3NzdXBwb3J0Lmh0bWxcbiAgICovXG4gIGNvbnN0cnVjdG9yIChwcm9wcz86IFBvbGljeVN0YXRlbWVudFByb3BzKSB7XG4gICAgc3VwZXIocHJvcHMpO1xuICB9XG5cbiAgLyoqXG4gICAqIEFkZHMgb25lIG9yIG1vcmUgYXR0YWNobWVudHMgdG8gYW4gQVdTIFN1cHBvcnQgY2FzZS5cbiAgICpcbiAgICogQWNjZXNzIExldmVsOiBXcml0ZVxuICAgKlxuICAgKiBodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vYXdzc3VwcG9ydC9sYXRlc3QvQVBJUmVmZXJlbmNlL0FQSV9BZGRBdHRhY2htZW50c1RvU2V0Lmh0bWxcbiAgICovXG4gIHB1YmxpYyBhZGRBdHRhY2htZW50c1RvU2V0KCkge1xuICAgIHRoaXMuYWRkKCdzdXBwb3J0OkFkZEF0dGFjaG1lbnRzVG9TZXQnKTtcbiAgICByZXR1cm4gdGhpcztcbiAgfVxuXG4gIC8qKlxuICAgKiBBZGRzIGEgY3VzdG9tZXIgY29tbXVuaWNhdGlvbiB0byBhbiBBV1MgU3VwcG9ydCBjYXNlLlxuICAgKlxuICAgKiBBY2Nlc3MgTGV2ZWw6IFdyaXRlXG4gICAqXG4gICAqIGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9hd3NzdXBwb3J0L2xhdGVzdC9BUElSZWZlcmVuY2UvQVBJX0FkZENvbW11bmljYXRpb25Ub0Nhc2UuaHRtbFxuICAgKi9cbiAgcHVibGljIGFkZENvbW11bmljYXRpb25Ub0Nhc2UoKSB7XG4gICAgdGhpcy5hZGQoJ3N1cHBvcnQ6QWRkQ29tbXVuaWNhdGlvblRvQ2FzZScpO1xuICAgIHJldHVybiB0aGlzO1xuICB9XG5cbiAgLyoqXG4gICAqIENyZWF0ZXMgYSBuZXcgQVdTIFN1cHBvcnQgY2FzZS5cbiAgICpcbiAgICogQWNjZXNzIExldmVsOiBXcml0ZVxuICAgKlxuICAgKiBodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vYXdzc3VwcG9ydC9sYXRlc3QvQVBJUmVmZXJlbmNlL0FQSV9DcmVhdGVDYXNlLmh0bWxcbiAgICovXG4gIHB1YmxpYyBjcmVhdGVDYXNlKCkge1xuICAgIHRoaXMuYWRkKCdzdXBwb3J0OkNyZWF0ZUNhc2UnKTtcbiAgICByZXR1cm4gdGhpcztcbiAgfVxuXG4gIC8qKlxuICAgKiBSZXR1cm5zIHRoZSBkZXNjcmlwdGlvbiBmb3IgYW4gYXR0YWNobWVudC5cbiAgICpcbiAgICogQWNjZXNzIExldmVsOiBSZWFkXG4gICAqXG4gICAqIGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9hd3NzdXBwb3J0L2xhdGVzdC9BUElSZWZlcmVuY2UvQVBJX0Rlc2NyaWJlQXR0YWNobWVudC5odG1sXG4gICAqL1xuICBwdWJsaWMgZGVzY3JpYmVBdHRhY2htZW50KCkge1xuICAgIHRoaXMuYWRkKCdzdXBwb3J0OkRlc2NyaWJlQXR0YWNobWVudCcpO1xuICAgIHJldHVybiB0aGlzO1xuICB9XG5cbiAgLyoqXG4gICAqIFRoaXMgaXMgYW4gaW50ZXJuYWxseSBtYW5hZ2VkIGZ1bmN0aW9uIHdoaWNoIGFsbG93cyBzZWNvbmRhcnkgc2VydmljZXMgdG8gcmVhZCBBV1MgU3VwcG9ydCBjYXNlIGF0dHJpYnV0ZXMuXG4gICAqXG4gICAqIEFjY2VzcyBMZXZlbDogUmVhZFxuICAgKi9cbiAgcHVibGljIGRlc2NyaWJlQ2FzZUF0dHJpYnV0ZXMoKSB7XG4gICAgdGhpcy5hZGQoJ3N1cHBvcnQ6RGVzY3JpYmVDYXNlQXR0cmlidXRlcycpO1xuICAgIHJldHVybiB0aGlzO1xuICB9XG5cbiAgLyoqXG4gICAqIFJldHVybnMgYSBsaXN0IG9mIEFXUyBTdXBwb3J0IGNhc2VzIHRoYXQgbWF0Y2hlcyB0aGUgZ2l2ZW4gaW5wdXRzLlxuICAgKlxuICAgKiBBY2Nlc3MgTGV2ZWw6IFJlYWRcbiAgICpcbiAgICogaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL2F3c3N1cHBvcnQvbGF0ZXN0L0FQSVJlZmVyZW5jZS9BUElfRGVzY3JpYmVDYXNlcy5odG1sXG4gICAqL1xuICBwdWJsaWMgZGVzY3JpYmVDYXNlcygpIHtcbiAgICB0aGlzLmFkZCgnc3VwcG9ydDpEZXNjcmliZUNhc2VzJyk7XG4gICAgcmV0dXJuIHRoaXM7XG4gIH1cblxuICAvKipcbiAgICogUmV0dXJucyB0aGUgY29tbXVuaWNhdGlvbnMgYW5kIGF0dGFjaG1lbnRzIGZvciBvbmUgb3IgbW9yZSBBV1MgU3VwcG9ydCBjYXNlcy5cbiAgICpcbiAgICogQWNjZXNzIExldmVsOiBSZWFkXG4gICAqXG4gICAqIGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9hd3NzdXBwb3J0L2xhdGVzdC9BUElSZWZlcmVuY2UvQVBJX0Rlc2NyaWJlQ29tbXVuaWNhdGlvbnMuaHRtbFxuICAgKi9cbiAgcHVibGljIGRlc2NyaWJlQ29tbXVuaWNhdGlvbnMoKSB7XG4gICAgdGhpcy5hZGQoJ3N1cHBvcnQ6RGVzY3JpYmVDb21tdW5pY2F0aW9ucycpO1xuICAgIHJldHVybiB0aGlzO1xuICB9XG5cbiAgLyoqXG4gICAqIFJldHVybnMgaXNzdWUgdHlwZXMgZm9yIEFXUyBTdXBwb3J0IGNhc2VzLlxuICAgKlxuICAgKiBBY2Nlc3MgTGV2ZWw6IFJlYWRcbiAgICovXG4gIHB1YmxpYyBkZXNjcmliZUlzc3VlVHlwZXMoKSB7XG4gICAgdGhpcy5hZGQoJ3N1cHBvcnQ6RGVzY3JpYmVJc3N1ZVR5cGVzJyk7XG4gICAgcmV0dXJuIHRoaXM7XG4gIH1cblxuICAvKipcbiAgICogUmV0dXJucyB0aGUgY3VycmVudCBsaXN0IG9mIEFXUyBzZXJ2aWNlcyBhbmQgY2F0ZWdvcmllcyB0aGF0IGFwcGxpZXMgdG8gZWFjaCBzZXJ2aWNlLlxuICAgKlxuICAgKiBBY2Nlc3MgTGV2ZWw6IFJlYWRcbiAgICpcbiAgICogaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL2F3c3N1cHBvcnQvbGF0ZXN0L0FQSVJlZmVyZW5jZS9BUElfRGVzY3JpYmVTZXJ2aWNlcy5odG1sXG4gICAqL1xuICBwdWJsaWMgZGVzY3JpYmVTZXJ2aWNlcygpIHtcbiAgICB0aGlzLmFkZCgnc3VwcG9ydDpEZXNjcmliZVNlcnZpY2VzJyk7XG4gICAgcmV0dXJuIHRoaXM7XG4gIH1cblxuICAvKipcbiAgICogUmV0dXJucyB0aGUgbGlzdCBvZiBzZXZlcml0eSBsZXZlbHMgdGhhdCBjYW4gYmUgYXNzaWduZWQgdG8gYW4gQVdTIFN1cHBvcnQgY2FzZS5cbiAgICpcbiAgICogQWNjZXNzIExldmVsOiBSZWFkXG4gICAqXG4gICAqIGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9hd3NzdXBwb3J0L2xhdGVzdC9BUElSZWZlcmVuY2UvQVBJX0Rlc2NyaWJlU2V2ZXJpdHlMZXZlbHMuaHRtbFxuICAgKi9cbiAgcHVibGljIGRlc2NyaWJlU2V2ZXJpdHlMZXZlbHMoKSB7XG4gICAgdGhpcy5hZGQoJ3N1cHBvcnQ6RGVzY3JpYmVTZXZlcml0eUxldmVscycpO1xuICAgIHJldHVybiB0aGlzO1xuICB9XG5cbiAgLyoqXG4gICAqIFJldHVybnMgdGhlIHN1cHBvcnQgbGV2ZWwgZm9yIGFuIEFXUyBBY2NvdW50IGlkZW50aWZpZXIuXG4gICAqXG4gICAqIEFjY2VzcyBMZXZlbDogUmVhZFxuICAgKi9cbiAgcHVibGljIGRlc2NyaWJlU3VwcG9ydExldmVsKCkge1xuICAgIHRoaXMuYWRkKCdzdXBwb3J0OkRlc2NyaWJlU3VwcG9ydExldmVsJyk7XG4gICAgcmV0dXJuIHRoaXM7XG4gIH1cblxuICAvKipcbiAgICogUmV0dXJucyB0aGUgc3RhdHVzIG9mIGEgVHJ1c3RlZCBBZHZpc29yIHJlZnJlc2ggY2hlY2sgYmFzZWQgb24gYSBsaXN0IG9mIGNoZWNrIGlkZW50aWZpZXJzLlxuICAgKlxuICAgKiBBY2Nlc3MgTGV2ZWw6IFJlYWRcbiAgICpcbiAgICogaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL2F3c3N1cHBvcnQvbGF0ZXN0L0FQSVJlZmVyZW5jZS9BUElfRGVzY3JpYmVUcnVzdGVkQWR2aXNvckNoZWNrUmVmcmVzaFN0YXR1c2VzLmh0bWxcbiAgICovXG4gIHB1YmxpYyBkZXNjcmliZVRydXN0ZWRBZHZpc29yQ2hlY2tSZWZyZXNoU3RhdHVzZXMoKSB7XG4gICAgdGhpcy5hZGQoJ3N1cHBvcnQ6RGVzY3JpYmVUcnVzdGVkQWR2aXNvckNoZWNrUmVmcmVzaFN0YXR1c2VzJyk7XG4gICAgcmV0dXJuIHRoaXM7XG4gIH1cblxuICAvKipcbiAgICogUmV0dXJucyB0aGUgcmVzdWx0cyBvZiB0aGUgVHJ1c3RlZCBBZHZpc29yIGNoZWNrIHRoYXQgaGFzIHRoZSBzcGVjaWZpZWQgY2hlY2sgaWRlbnRpZmllci5cbiAgICpcbiAgICogQWNjZXNzIExldmVsOiBSZWFkXG4gICAqXG4gICAqIGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9hd3NzdXBwb3J0L2xhdGVzdC9BUElSZWZlcmVuY2UvQVBJX0Rlc2NyaWJlVHJ1c3RlZEFkdmlzb3JDaGVja1Jlc3VsdC5odG1sXG4gICAqL1xuICBwdWJsaWMgZGVzY3JpYmVUcnVzdGVkQWR2aXNvckNoZWNrUmVzdWx0KCkge1xuICAgIHRoaXMuYWRkKCdzdXBwb3J0OkRlc2NyaWJlVHJ1c3RlZEFkdmlzb3JDaGVja1Jlc3VsdCcpO1xuICAgIHJldHVybiB0aGlzO1xuICB9XG5cbiAgLyoqXG4gICAqIFJldHVybnMgdGhlIHN1bW1hcmllcyBvZiB0aGUgcmVzdWx0cyBvZiB0aGUgVHJ1c3RlZCBBZHZpc29yIGNoZWNrcyB0aGF0IGhhdmUgdGhlIHNwZWNpZmllZCBjaGVjayBpZGVudGlmaWVycy5cbiAgICpcbiAgICogQWNjZXNzIExldmVsOiBSZWFkXG4gICAqXG4gICAqIGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9hd3NzdXBwb3J0L2xhdGVzdC9BUElSZWZlcmVuY2UvQVBJX0Rlc2NyaWJlVHJ1c3RlZEFkdmlzb3JDaGVja1N1bW1hcmllcy5odG1sXG4gICAqL1xuICBwdWJsaWMgZGVzY3JpYmVUcnVzdGVkQWR2aXNvckNoZWNrU3VtbWFyaWVzKCkge1xuICAgIHRoaXMuYWRkKCdzdXBwb3J0OkRlc2NyaWJlVHJ1c3RlZEFkdmlzb3JDaGVja1N1bW1hcmllcycpO1xuICAgIHJldHVybiB0aGlzO1xuICB9XG5cbiAgLyoqXG4gICAqIFJldHVybnMgYSBsaXN0IG9mIGFsbCBhdmFpbGFibGUgVHJ1c3RlZCBBZHZpc29yIGNoZWNrcywgaW5jbHVkaW5nIG5hbWUsIGlkZW50aWZpZXIsIGNhdGVnb3J5IGFuZCBkZXNjcmlwdGlvbi5cbiAgICpcbiAgICogQWNjZXNzIExldmVsOiBSZWFkXG4gICAqXG4gICAqIGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9hd3NzdXBwb3J0L2xhdGVzdC9BUElSZWZlcmVuY2UvQVBJX0Rlc2NyaWJlVHJ1c3RlZEFkdmlzb3JDaGVja3MuaHRtbFxuICAgKi9cbiAgcHVibGljIGRlc2NyaWJlVHJ1c3RlZEFkdmlzb3JDaGVja3MoKSB7XG4gICAgdGhpcy5hZGQoJ3N1cHBvcnQ6RGVzY3JpYmVUcnVzdGVkQWR2aXNvckNoZWNrcycpO1xuICAgIHJldHVybiB0aGlzO1xuICB9XG5cbiAgLyoqXG4gICAqIFRoaXMgaXMgYW4gaW50ZXJuYWxseSBtYW5hZ2VkIGZ1bmN0aW9uIHRvIGluaXRpYXRlIGEgY2FsbCBvbiBBV1MgU3VwcG9ydCBDZW50ZXIuXG4gICAqXG4gICAqIEFjY2VzcyBMZXZlbDogV3JpdGVcbiAgICovXG4gIHB1YmxpYyBpbml0aWF0ZUNhbGxGb3JDYXNlKCkge1xuICAgIHRoaXMuYWRkKCdzdXBwb3J0OkluaXRpYXRlQ2FsbEZvckNhc2UnKTtcbiAgICByZXR1cm4gdGhpcztcbiAgfVxuXG4gIC8qKlxuICAgKiBUaGlzIGlzIGFuIGludGVybmFsbHkgbWFuYWdlZCBmdW5jdGlvbiB0byBpbml0aWF0ZSBhIGNoYXQgb24gQVdTIFN1cHBvcnQgQ2VudGVyLlxuICAgKlxuICAgKiBBY2Nlc3MgTGV2ZWw6IFdyaXRlXG4gICAqL1xuICBwdWJsaWMgaW5pdGlhdGVDaGF0Rm9yQ2FzZSgpIHtcbiAgICB0aGlzLmFkZCgnc3VwcG9ydDpJbml0aWF0ZUNoYXRGb3JDYXNlJyk7XG4gICAgcmV0dXJuIHRoaXM7XG4gIH1cblxuICAvKipcbiAgICogVGhpcyBpcyBhbiBpbnRlcm5hbGx5IG1hbmFnZWQgZnVuY3Rpb24gd2hpY2ggYWxsb3dzIHNlY29uZGFyeSBzZXJ2aWNlcyB0byBhdHRhY2ggYXR0cmlidXRlcyB0byBBV1MgU3VwcG9ydCBjYXNlcy5cbiAgICpcbiAgICogQWNjZXNzIExldmVsOiBXcml0ZVxuICAgKi9cbiAgcHVibGljIHB1dENhc2VBdHRyaWJ1dGVzKCkge1xuICAgIHRoaXMuYWRkKCdzdXBwb3J0OlB1dENhc2VBdHRyaWJ1dGVzJyk7XG4gICAgcmV0dXJuIHRoaXM7XG4gIH1cblxuICAvKipcbiAgICogUmF0ZSBhbiBBV1MgU3VwcG9ydCBjYXNlIGNvbW11bmljYXRpb24uXG4gICAqXG4gICAqIEFjY2VzcyBMZXZlbDogV3JpdGVcbiAgICovXG4gIHB1YmxpYyByYXRlQ2FzZUNvbW11bmljYXRpb24oKSB7XG4gICAgdGhpcy5hZGQoJ3N1cHBvcnQ6UmF0ZUNhc2VDb21tdW5pY2F0aW9uJyk7XG4gICAgcmV0dXJuIHRoaXM7XG4gIH1cblxuICAvKipcbiAgICogUmVxdWVzdHMgYSByZWZyZXNoIG9mIHRoZSBUcnVzdGVkIEFkdmlzb3IgY2hlY2sgdGhhdCBoYXMgdGhlIHNwZWNpZmllZCBjaGVjayBpZGVudGlmaWVyLlxuICAgKlxuICAgKiBBY2Nlc3MgTGV2ZWw6IFdyaXRlXG4gICAqXG4gICAqIGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9hd3NzdXBwb3J0L2xhdGVzdC9BUElSZWZlcmVuY2UvQVBJX1JlZnJlc2hUcnVzdGVkQWR2aXNvckNoZWNrLmh0bWxcbiAgICovXG4gIHB1YmxpYyByZWZyZXNoVHJ1c3RlZEFkdmlzb3JDaGVjaygpIHtcbiAgICB0aGlzLmFkZCgnc3VwcG9ydDpSZWZyZXNoVHJ1c3RlZEFkdmlzb3JDaGVjaycpO1xuICAgIHJldHVybiB0aGlzO1xuICB9XG5cbiAgLyoqXG4gICAqIFJlc29sdmVzIGFuIEFXUyBTdXBwb3J0IGNhc2UuXG4gICAqXG4gICAqIEFjY2VzcyBMZXZlbDogV3JpdGVcbiAgICpcbiAgICogaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL2F3c3N1cHBvcnQvbGF0ZXN0L0FQSVJlZmVyZW5jZS9BUElfUmVzb2x2ZUNhc2UuaHRtbFxuICAgKi9cbiAgcHVibGljIHJlc29sdmVDYXNlKCkge1xuICAgIHRoaXMuYWRkKCdzdXBwb3J0OlJlc29sdmVDYXNlJyk7XG4gICAgcmV0dXJuIHRoaXM7XG4gIH1cblxuICAvKipcbiAgICogUmV0dXJucyBhIGxpc3Qgb2YgQVdTIFN1cHBvcnQgY2FzZXMgdGhhdCBtYXRjaGVzIHRoZSBnaXZlbiBpbnB1dHMuXG4gICAqXG4gICAqIEFjY2VzcyBMZXZlbDogUmVhZFxuICAgKi9cbiAgcHVibGljIHNlYXJjaEZvckNhc2VzKCkge1xuICAgIHRoaXMuYWRkKCdzdXBwb3J0OlNlYXJjaEZvckNhc2VzJyk7XG4gICAgcmV0dXJuIHRoaXM7XG4gIH1cbn1cbiJdfQ==