import { Actions, PolicyStatement, ResourceTypes } from "../shared";
import { PolicyStatementProps } from "@aws-cdk/aws-iam";
/**
 * Action provider for service trustedadvisor
 *
 * https://docs.aws.amazon.com/IAM/latest/UserGuide/list_awstrustedadvisor.html
 */
export declare class Trustedadvisor extends PolicyStatement {
    servicePrefix: string;
    actions: Actions;
    resourceTypes: ResourceTypes;
    /**
     * Action provider for service trustedadvisor
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/list_awstrustedadvisor.html
     */
    constructor(props?: PolicyStatementProps);
    /**
     * View support plan and various TA preferences.
     *
     * Access Level: Read
     */
    describeAccount(): this;
    /**
     * Resolve whether Account has disabled Trusted Advisor
     *
     * Access Level: Read
     */
    describeAccountAccess(): this;
    /**
     * View details for the check items
     *
     * Access Level: Read
     */
    describeCheckItems(): this;
    /**
     * Describe check refresh statuses
     *
     * Access Level: Read
     */
    describeCheckRefreshStatuses(): this;
    /**
     * Describes the check's summaries
     *
     * Access Level: Read
     */
    describeCheckSummaries(): this;
    /**
     * List valid Trusted Advisor checks and details.
     *
     * Access Level: Read
     */
    describeChecks(): this;
    /**
     * Describes the notification preferences for the account
     *
     * Access Level: Read
     */
    describeNotificationPreferences(): this;
    /**
     * Exclude recommendations for checks for a given customer
     *
     * Access Level: Write
     */
    excludeCheckItems(): this;
    /**
     * Include recommendations for checks for a given customer
     *
     * Access Level: Write
     */
    includeCheckItems(): this;
    /**
     * Enqueue a refresh for the specified check
     *
     * Access Level: Write
     */
    refreshCheck(): this;
    /**
     * Toggle whether TrustedAdvisor is enabled/disabled for the account
     *
     * Access Level: Write
     */
    setAccountAccess(): this;
    /**
     * Update notification preferences
     *
     * Access Level: Write
     */
    updateNotificationPreferences(): this;
    /**
     * Adds a resource of type checks to the statement
     *
     * https://docs.aws.amazon.com/awssupport/latest/APIReference/API_TrustedAdvisorCheckDescription.html
     *
     * @param categoryCode - Identifier for the categoryCode.
     * @param checkId - Identifier for the checkId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     */
    onChecks(categoryCode: string, checkId: string, account?: string, region?: string, partition?: string): this;
}
