import { Actions, PolicyStatement, ResourceTypes } from "../shared";
import { PolicyStatementProps } from "@aws-cdk/aws-iam";
/**
 * Action provider for service comprehendmedical
 *
 * https://docs.aws.amazon.com/IAM/latest/UserGuide/list_comprehendmedical.html
 */
export declare class Comprehendmedical extends PolicyStatement {
    servicePrefix: string;
    actions: Actions;
    resourceTypes: ResourceTypes;
    /**
     * Action provider for service comprehendmedical
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/list_comprehendmedical.html
     */
    constructor(props?: PolicyStatementProps);
    /**
     * Inspects the specified text for the specified type of entities and returns information about them.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/comprehend/latest/dg/API_hera_DetectEntities.html
     */
    detectEntities(): this;
    /**
     * Inspects the specified text for PHI entities and returns information about them.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/comprehend/latest/dg/API_hera_DetectPHI.html
     */
    detectPHI(): this;
}
