"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const shared_1 = require("../shared");
/**
 * Action provider for service comprehendmedical
 *
 * https://docs.aws.amazon.com/IAM/latest/UserGuide/list_comprehendmedical.html
 */
class Comprehendmedical extends shared_1.PolicyStatement {
    /**
     * Action provider for service comprehendmedical
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/list_comprehendmedical.html
     */
    constructor(props) {
        super(props);
        this.servicePrefix = 'comprehendmedical';
        this.actions = {
            "DetectEntities": {
                "url": "https://docs.aws.amazon.com/comprehend/latest/dg/API_hera_DetectEntities.html",
                "description": "Inspects the specified text for the specified type of entities and returns information about them.",
                "accessLevel": "Read"
            },
            "DetectPHI": {
                "url": "https://docs.aws.amazon.com/comprehend/latest/dg/API_hera_DetectPHI.html",
                "description": "Inspects the specified text for PHI entities and returns information about them.",
                "accessLevel": "Read"
            }
        };
        this.resourceTypes = {};
    }
    /**
     * Inspects the specified text for the specified type of entities and returns information about them.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/comprehend/latest/dg/API_hera_DetectEntities.html
     */
    detectEntities() {
        this.add('comprehendmedical:DetectEntities');
        return this;
    }
    /**
     * Inspects the specified text for PHI entities and returns information about them.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/comprehend/latest/dg/API_hera_DetectPHI.html
     */
    detectPHI() {
        this.add('comprehendmedical:DetectPHI');
        return this;
    }
}
exports.Comprehendmedical = Comprehendmedical;
//# sourceMappingURL=data:application/json;base64,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