"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const shared_1 = require("../shared");
/**
 * Action provider for service compute-optimizer
 *
 * https://docs.aws.amazon.com/IAM/latest/UserGuide/list_computeoptimizer.html
 */
class ComputeOptimizer extends shared_1.PolicyStatement {
    /**
     * Action provider for service compute-optimizer
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/list_computeoptimizer.html
     */
    constructor(props) {
        super(props);
        this.servicePrefix = 'compute-optimizer';
        this.actions = {
            "DescribeRecommendationExportJobs": {
                "url": "https://docs.aws.amazon.com/compute-optimizer/latest/APIReference/API_DescribeRecommendationExportJobs.html",
                "description": "Grants permission to view the status of recommendation export jobs.",
                "accessLevel": "List"
            },
            "ExportAutoScalingGroupRecommendations": {
                "url": "https://docs.aws.amazon.com/compute-optimizer/latest/APIReference/API_ExportAutoScalingGroupRecommendations.html",
                "description": "Grants permission to export autoscaling group recommendations to S3 for the provided accounts.",
                "accessLevel": "Write"
            },
            "ExportEC2InstanceRecommendations": {
                "url": "https://docs.aws.amazon.com/compute-optimizer/latest/APIReference/API_ExportEC2InstanceRecommendations.html",
                "description": "Grants permission to export EC2 instance recommendations to S3 for the provided accounts.",
                "accessLevel": "Write"
            },
            "GetAutoScalingGroupRecommendations": {
                "url": "https://docs.aws.amazon.com/compute-optimizer/latest/APIReference/API_GetAutoScalingGroupRecommendations.html",
                "description": "Grants permission to get recommendations for the provided autoscaling groups.",
                "accessLevel": "List"
            },
            "GetEC2InstanceRecommendations": {
                "url": "https://docs.aws.amazon.com/compute-optimizer/latest/APIReference/API_GetEC2InstanceRecommendations.html",
                "description": "Grants permission to get recommendations for the provided EC2 instances.",
                "accessLevel": "List"
            },
            "GetEC2RecommendationProjectedMetrics": {
                "url": "https://docs.aws.amazon.com/compute-optimizer/latest/APIReference/API_GetEC2RecommendationProjectedMetrics.html",
                "description": "Grants permission to get the recommendation projected metrics of the specified instance.",
                "accessLevel": "List"
            },
            "GetEnrollmentStatus": {
                "url": "https://docs.aws.amazon.com/compute-optimizer/latest/APIReference/API_GetEnrollmentStatus.html",
                "description": "Grants permission to get the enrollment status for the specified account.",
                "accessLevel": "List"
            },
            "GetRecommendationSummaries": {
                "url": "https://docs.aws.amazon.com/compute-optimizer/latest/APIReference/API_GetRecommendationSummaries.html",
                "description": "Grants permission to get the recommendation summaries for the specified account(s).",
                "accessLevel": "List"
            },
            "UpdateEnrollmentStatus": {
                "url": "https://docs.aws.amazon.com/compute-optimizer/latest/APIReference/API_UpdateEnrollmentStatus.html",
                "description": "Grants permission to update the enrollment status.",
                "accessLevel": "Write"
            }
        };
        this.resourceTypes = {};
    }
    /**
     * Grants permission to view the status of recommendation export jobs.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/compute-optimizer/latest/APIReference/API_DescribeRecommendationExportJobs.html
     */
    describeRecommendationExportJobs() {
        this.add('compute-optimizer:DescribeRecommendationExportJobs');
        return this;
    }
    /**
     * Grants permission to export autoscaling group recommendations to S3 for the provided accounts.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/compute-optimizer/latest/APIReference/API_ExportAutoScalingGroupRecommendations.html
     */
    exportAutoScalingGroupRecommendations() {
        this.add('compute-optimizer:ExportAutoScalingGroupRecommendations');
        return this;
    }
    /**
     * Grants permission to export EC2 instance recommendations to S3 for the provided accounts.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/compute-optimizer/latest/APIReference/API_ExportEC2InstanceRecommendations.html
     */
    exportEC2InstanceRecommendations() {
        this.add('compute-optimizer:ExportEC2InstanceRecommendations');
        return this;
    }
    /**
     * Grants permission to get recommendations for the provided autoscaling groups.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/compute-optimizer/latest/APIReference/API_GetAutoScalingGroupRecommendations.html
     */
    getAutoScalingGroupRecommendations() {
        this.add('compute-optimizer:GetAutoScalingGroupRecommendations');
        return this;
    }
    /**
     * Grants permission to get recommendations for the provided EC2 instances.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/compute-optimizer/latest/APIReference/API_GetEC2InstanceRecommendations.html
     */
    getEC2InstanceRecommendations() {
        this.add('compute-optimizer:GetEC2InstanceRecommendations');
        return this;
    }
    /**
     * Grants permission to get the recommendation projected metrics of the specified instance.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/compute-optimizer/latest/APIReference/API_GetEC2RecommendationProjectedMetrics.html
     */
    getEC2RecommendationProjectedMetrics() {
        this.add('compute-optimizer:GetEC2RecommendationProjectedMetrics');
        return this;
    }
    /**
     * Grants permission to get the enrollment status for the specified account.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/compute-optimizer/latest/APIReference/API_GetEnrollmentStatus.html
     */
    getEnrollmentStatus() {
        this.add('compute-optimizer:GetEnrollmentStatus');
        return this;
    }
    /**
     * Grants permission to get the recommendation summaries for the specified account(s).
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/compute-optimizer/latest/APIReference/API_GetRecommendationSummaries.html
     */
    getRecommendationSummaries() {
        this.add('compute-optimizer:GetRecommendationSummaries');
        return this;
    }
    /**
     * Grants permission to update the enrollment status.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/compute-optimizer/latest/APIReference/API_UpdateEnrollmentStatus.html
     */
    updateEnrollmentStatus() {
        this.add('compute-optimizer:UpdateEnrollmentStatus');
        return this;
    }
}
exports.ComputeOptimizer = ComputeOptimizer;
//# sourceMappingURL=data:application/json;base64,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